/**************************************************************************//**
* \file     clTpeg_Property_TMCData.cpp
*
*           RdbIdActualList property implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "TMCTuner/clTpeg_Property_TMCData.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_SERVER_TMCTUNER
#include "trcGenProj/Header/clTpeg_Property_TMCData.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Property_TMCData::~clTpeg_Property_TMCData()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Property_TMCData::clTpeg_Property_TMCData(clCCAhandler* poCCAhandler)
   : clServerProperty(TMCTUNERFI_C_U16_TMCDATA, poCCAhandler)
{
   m_TmcList.CycleStart = FALSE;
   m_TmcList.DataForRdbIdComplete = FALSE;
   m_TmcList.Duplicate = FALSE;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TMCData::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TMCData::vGet(amt_tclServiceData* /*poInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TMCData::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TMCData::vSendStatus()
{
   vTraceTMCData();
   vStatus(m_TmcList);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TMCData::vOnNewTrafficData(std::vector<fi_tcl_TrafficInfo, std::allocator<fi_tcl_TrafficInfo> > &oTrafficInfoList)
{
   ETG_TRACE_USR4(("clTpeg_Property_TMCData:: vOnNewTrafficData entered."))
   m_TmcList.ListOfTrafficInfo = oTrafficInfoList;
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TMCData::vTraceTMCData()
{
   tU16 u16TrafficDataSize= (tU16)m_TmcList.ListOfTrafficInfo.size();
   ET_TRACE_BIN(
      TR_CLASS_FC_TPEG_CCA_HANDLER,
      TR_LEVEL_USER_1,
      ET_EN_T16 _ TRACE_CCA_VALUE _
      ET_EN_T16 _ TMCTUNERFI_C_U16_TMCDATA _
      ET_EN_T16 _ 0 _
      ET_EN_T16 _ u16TrafficDataSize _
      ET_EN_DONE );

  /* for (tU16 u16Index= 0; u16Index< u16TrafficDataSize;  u16Index++)
   {
      ET_TRACE_BIN(
         TR_CLASS_FC_TPEG_CCA_HANDLER,
         TR_LEVEL_USER_2,
         ET_EN_T16 _ TRACE_CCA_VALUE _
         ET_EN_T16 _ m_poCCAhandler->u16GetServiceId() _
         ET_EN_T16 _ u16GetFunctionID() _
         ET_EN_T16 _ 1 _
         ET_EN_T8 _ m_TmcList.ListOfTrafficInfo[u16Index].RDBId.TMCCountryCode _
         ET_EN_T8 _ m_TmcList.ListOfTrafficInfo[u16Index].RDBId.TableNo _
         ET_EN_T16 _ m_TmcList.ListOfTrafficInfo[u16Index].RDBId.BSA _
         ET_EN_T8  _ m_TmcList.ListOfTrafficInfo[u16Index].RDBId.ServiceID _
         ET_EN_T16  _ m_TmcList.ListOfTrafficInfo[u16Index].RDBId.Encrypted _
         ET_EN_DONE );

      ET_TRACE_BIN(
         TR_CLASS_FC_TPEG_CCA_HANDLER,
         TR_LEVEL_USER_2,
         ET_EN_T16 _ TRACE_CCA_VALUE _
         ET_EN_T16 _ m_poCCAhandler->u16GetServiceId() _
         ET_EN_T16 _ u16GetFunctionID() _
         ET_EN_T16 _ 2 _
         ET_EN_T16 _ m_TmcList.ListOfTrafficInfo[u16Index].ECC _
         ET_EN_T16 _ m_TmcList.ListOfTrafficInfo[u16Index].ApplicationId.enType _
         ET_EN_T16 _ m_TmcList.ListOfTrafficInfo[u16Index].ProgramID _
         ET_EN_T16  _ m_TmcList.ListOfTrafficInfo[u16Index].Encryption.Encrypted _
         ET_EN_T8  _ m_TmcList.ListOfTrafficInfo[u16Index].Encryption.Encid _
         ET_EN_T8  _ m_TmcList.ListOfTrafficInfo[u16Index].Encryption.TestBits _
         ET_EN_DONE );

      ET_TRACE_BIN(
         TR_CLASS_FC_TPEG_CCA_HANDLER,
         TR_LEVEL_USER_2,
         ET_EN_T16 _ TRACE_CCA_VALUE _
         ET_EN_T16 _ m_poCCAhandler->u16GetServiceId() _
         ET_EN_T16 _ u16GetFunctionID() _
         ET_EN_T16 _ 3 _
         ET_EN_T8 _ m_TmcList.ListOfTrafficInfo[u16Index].ListOf8AData[0] _
         ET_EN_T8 _ m_TmcList.ListOfTrafficInfo[u16Index].ListOf8AData[1] _
         ET_EN_T8 _ m_TmcList.ListOfTrafficInfo[u16Index].ListOf8AData[2] _
         ET_EN_T8  _ m_TmcList.ListOfTrafficInfo[u16Index].ListOf8AData[3] _
         ET_EN_T8  _ m_TmcList.ListOfTrafficInfo[u16Index].ListOf8AData[4] _
         ET_EN_DONE );
   }*/
}

