/**************************************************************************//**
* \file     clTpeg_Property_RdbIdActualList.cpp
*
*           RdbIdActualList property implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "TMCTuner/clTpeg_Property_RdbIdActualList.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_SERVER_TMCTUNER
#include "trcGenProj/Header/clTpeg_Property_RdbIdActualList.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Property_RdbIdActualList::~clTpeg_Property_RdbIdActualList()
{
   	m_ActualListStatus.ListOfRdbIds.clear();
	m_ActualListStatus.ReceptionState.enType=fi_tcl_e8_TunerReceptionState::FI_EN_OK;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Property_RdbIdActualList::clTpeg_Property_RdbIdActualList(clCCAhandler* poCCAhandler)
   : clServerProperty(TMCTUNERFI_C_U16_RDBIDACTUALLIST, poCCAhandler)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_RdbIdActualList::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_RdbIdActualList::vGet(amt_tclServiceData* /*poInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_RdbIdActualList::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_RdbIdActualList::vSendStatus()
{
   vStatus(m_ActualListStatus);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_RdbIdActualList::vOnNewRdbIdList(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &oListOfRdbIds, fi_tcl_e8_TunerReceptionState::tenType receptionState)
{
   ETG_TRACE_USR4(("clTpeg_Property_RdbIdActualList:: vOnNewRdbIdList entered."));
	m_ActualListStatus.ListOfRdbIds = oListOfRdbIds;
   	m_ActualListStatus.ReceptionState.enType=receptionState;
   vSendStatus();
}
