/**************************************************************************//**
* \file     clTpeg_Method_SetRdbIdWishList.cpp
*
*           clTpeg_Method_SetRdbIdWishList method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "TMCTuner/clTpeg_Method_SetRdbIdWishList.h"
#include "interface/clTpeg_TunerControl.h"
#include "TMCTuner/tpeg_TMCTuner_fi.h"
#include "CcaApp/clCCAhandler.h"


clTpeg_TunerControl tunerControl;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Method_SetRdbIdWishList::~clTpeg_Method_SetRdbIdWishList()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Method_SetRdbIdWishList::clTpeg_Method_SetRdbIdWishList(clCCAhandler* poCCAhandler)
   : clServerMethod(TMCTUNERFI_C_U16_SETRDBIDWISHLIST, poCCAhandler)
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_SetRdbIdWishList::vMethodStart(amt_tclServiceData* poInMessage)
{
	if(m_poCCAhandler !=NULL)
	{
		tmctunerfi_tclMsgSetRdbIdWishListMethodStart oMessage;
		m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
		tunerControl.vSetRDBIDListToTuner(oMessage.ListOfRdbIds);
		tmctunerfi_tclMsgSetRdbIdWishListMethodResult oResult;
		oResult.ListOfRdbIds = oMessage.ListOfRdbIds;
		vSendMethodResult(oResult);
	}
}

