/**************************************************************************//**
* \file     clTpeg_Method_ExchangeCapabilities.h
*
*           VC FC Service Message handler functions
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clTpeg_Method_ExchangeCapabilities_h
#define clTpeg_Method_ExchangeCapabilities_h


#include "CcaApp/clServerMethod.h"
#include "TMCTuner/tpeg_TMCTuner_fi.h"
#include "fc_tpeg_types.h"
#include <vector>


class clTpeg_TMCConfiguration;
class clTpeg_TpegConfiguration;
class clTpeg_CommonCapability;


class clTpeg_Method_ExchangeCapabilities : public clServerMethod
{
   public:
      virtual ~clTpeg_Method_ExchangeCapabilities();
      clTpeg_Method_ExchangeCapabilities(clCCAhandler* poCCAhandler, clTpeg_TMCConfiguration *poTMCConfiguration, clTpeg_TpegConfiguration *poTpegConfiguration, clTpeg_CommonCapability *poCommonCapability);
 
   private:
      std::vector<fi_tcl_TmcCapability, std::allocator<fi_tcl_TmcCapability> > oGetTmcCapability();
      std::vector<fi_tcl_TpegCapability, std::allocator<fi_tcl_TpegCapability> > oGetTpegCapability();
      std::vector<fi_tcl_CommonCapability, std::allocator<fi_tcl_CommonCapability> > oGetCommonCapability();
      std::vector<fi_tcl_VersionedTpegApplication, std::allocator<fi_tcl_VersionedTpegApplication> > oGetSupportedTpegApplications();
      tVoid vSetSupportedTpegLocReferencing(std::vector<fi_tcl_e8_TpegLocReferencing, std::allocator<fi_tcl_e8_TpegLocReferencing> > oSupportedTpegLocationReferencing);
      tVoid vSetMessageDataAmount(std::vector<fi_tcl_TpegCapability, std::allocator<fi_tcl_TpegCapability> > oListOfTpegCapabilities);
      virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
      clTpeg_TMCConfiguration *m_poTMCConfiguration;
      clTpeg_TpegConfiguration *m_poTpegConfiguration;
      clTpeg_CommonCapability *m_poCommonCapability;

};

#endif
