/**************************************************************************//**
* \file     clTpeg_Method_ExchangeCapabilities.cpp
*
*           clTpeg_Method_ExchangeCapabilities method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "TMCTuner/clTpeg_Method_ExchangeCapabilities.h"
#include "TpegApplication/clTpeg_TMCConfiguration.h"
#include "TpegApplication/clTpeg_TpegConfiguration.h"
#include "TpegApplication/clTpeg_CommonCapability.h"
#include "CcaApp/clCCAhandler.h"


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Method_ExchangeCapabilities::~clTpeg_Method_ExchangeCapabilities()
{
   m_poTMCConfiguration = NULL;
   m_poTpegConfiguration = NULL;
   m_poCommonCapability = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Method_ExchangeCapabilities::clTpeg_Method_ExchangeCapabilities(clCCAhandler* poCCAhandler,  clTpeg_TMCConfiguration *poTMCConfiguration, clTpeg_TpegConfiguration *poTpegConfiguration, clTpeg_CommonCapability *poCommonCapability)
   : clServerMethod(TMCTUNERFI_C_U16_EXCHANGECAPABILITIES, poCCAhandler),
   m_poTMCConfiguration(poTMCConfiguration), m_poTpegConfiguration(poTpegConfiguration), m_poCommonCapability(poCommonCapability)
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_ExchangeCapabilities::vMethodStart(amt_tclServiceData* poInMessage )
{
   if(m_poCCAhandler == NULL)
   {
	   return;
   }
	tmctunerfi_tclMsgExchangeCapabilitiesMethodStart oMessage;
   m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
   tmctunerfi_tclMsgExchangeCapabilitiesMethodResult oResult;
   vSetMessageDataAmount(oMessage.ListOfTpegCapabilities);
   oResult.ListOfTmcCapabilities = oGetTmcCapability();
   oResult.ListOfTpegCapabilities = oMessage.ListOfTpegCapabilities;
   oResult.ListOfCommonCapabilities = oGetCommonCapability();
   oResult.SupportedTpegApplications = oGetSupportedTpegApplications();
   oResult.SupportedTpegLocReferencing = oMessage.SupportedTpegLocReferencing;
   vSetSupportedTpegLocReferencing(oMessage.SupportedTpegLocReferencing);
   vSendMethodResult(oResult);
}


/**************************************************************************//**
* 
******************************************************************************/
std::vector<fi_tcl_TmcCapability, std::allocator<fi_tcl_TmcCapability> > clTpeg_Method_ExchangeCapabilities::oGetTmcCapability()
{
   std::vector<fi_tcl_TmcCapability, std::allocator<fi_tcl_TmcCapability> > oListOfTmcCapabilities;
   if(m_poTMCConfiguration != NULL)
   {
   for ( tU8 u8Count = 0 ; u8Count  < enTmcCapability_max ; u8Count++ )
   {
      fi_tcl_TmcCapability oElem;
      oElem.CapabilityId.enType = (fi_tcl_e8_TmcCapability::tenType)u8Count;
      oElem.Value = m_poTMCConfiguration->u8GetCapability(u8Count);
      oListOfTmcCapabilities.push_back(oElem);
   }
   }
   return oListOfTmcCapabilities;
}


/**************************************************************************//**
* 
******************************************************************************/
std::vector<fi_tcl_TpegCapability, std::allocator<fi_tcl_TpegCapability> > clTpeg_Method_ExchangeCapabilities::oGetTpegCapability()
{
   std::vector<fi_tcl_TpegCapability, std::allocator<fi_tcl_TpegCapability> > oListOfCapabilities;
   if(m_poTpegConfiguration !=NULL)
   {
	   for ( tU8 u8Count = 0 ; u8Count  < enTpegCapability_max ; u8Count++ )
	   {
		  if (m_poTpegConfiguration->bIsCapabilityInList(u8Count))
		  {
			 fi_tcl_TpegCapability oElem;
			 oElem.CapabilityId.enType = (fi_tcl_e8_TpegCapability::tenType)u8Count;
			 oElem.Value = m_poTpegConfiguration->u8GetCapability(u8Count);
			 oListOfCapabilities.push_back(oElem);
		  }
	   }
   }
   return oListOfCapabilities;
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_ExchangeCapabilities::vSetSupportedTpegLocReferencing(std::vector<fi_tcl_e8_TpegLocReferencing, std::allocator<fi_tcl_e8_TpegLocReferencing> > oSupportedTpegLocationReferencing)
{
	if(m_poTpegConfiguration !=NULL)
	{
		std::vector<fi_tcl_e8_TpegLocReferencing> oSupportedTpegLocReferences;
		for (tU32 u32Count = 0; u32Count < oSupportedTpegLocationReferencing.size(); u32Count++)
		{
			fi_tcl_e8_TpegLocReferencing oLr;
			oLr.enType = (fi_tcl_e8_TpegLocReferencing::tenType)(oSupportedTpegLocationReferencing[u32Count].enType);
			oSupportedTpegLocReferences.push_back(oLr);
		}
		m_poTpegConfiguration->vSetSupportedLocationReferences(oSupportedTpegLocReferences);
	}
}


/**************************************************************************//**
* 
******************************************************************************/
std::vector<fi_tcl_CommonCapability, std::allocator<fi_tcl_CommonCapability> > clTpeg_Method_ExchangeCapabilities::oGetCommonCapability()
{
	std::vector<fi_tcl_CommonCapability, std::allocator<fi_tcl_CommonCapability> > oListOfCapabilities;
	if(m_poCommonCapability !=NULL)
	{
		for ( tU8 u8Count = 0 ; u8Count  < enTmcCapability_max ; u8Count++ )
		{
			if (m_poCommonCapability->bIsCapabilityInList(u8Count))
			{
				fi_tcl_CommonCapability oElem;
				oElem.CapabilityId.enType = (fi_tcl_e8_CommonCapability::tenType)u8Count;
				oElem.Value = m_poCommonCapability->u8GetCapability(u8Count);
				oListOfCapabilities.push_back(oElem);
			}
		}
	}
	return oListOfCapabilities;
}


/**************************************************************************//**
* 
******************************************************************************/
std::vector<fi_tcl_VersionedTpegApplication, std::allocator<fi_tcl_VersionedTpegApplication> > clTpeg_Method_ExchangeCapabilities::oGetSupportedTpegApplications()
{
	std::vector<fi_tcl_VersionedTpegApplication, std::allocator<fi_tcl_VersionedTpegApplication> >  oSupportedApplicationList;
	if(m_poTpegConfiguration!= NULL)
	{
		for ( tU8 u8Count = 0 ; u8Count  <  fi_tcl_e8_TpegApplication::FI_EN_TFP; u8Count++ )
		{
			if (m_poTpegConfiguration->bIsApplicationInList(u8Count))
			{
				fi_tcl_VersionedTpegApplication oElem;
				oElem.ApplicationId.enType = (fi_tcl_e8_TpegApplication::tenType)(u8Count);
				oElem.SupportedMajorVersions = m_poTpegConfiguration->oGetSupportedApplicationVersions(u8Count);
				oSupportedApplicationList.push_back(oElem);
			}
		}
	}
	return oSupportedApplicationList;
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_ExchangeCapabilities::vSetMessageDataAmount(std::vector<fi_tcl_TpegCapability, std::allocator<fi_tcl_TpegCapability> > oListOfTpegCapabilities)
{
	if(m_poTpegConfiguration !=NULL)
	{
		for(tU32 u32Count = 0; u32Count < oListOfTpegCapabilities.size(); u32Count++)
		{
			if (oListOfTpegCapabilities[u32Count].CapabilityId.enType == fi_tcl_e8_TpegCapability::FI_EN_MESSAGEDATAAMOUNT)
			{
				m_poTpegConfiguration->vSetMessageDataAmount(oListOfTpegCapabilities[u32Count].Value);
			}
		}
	}
}
