/**************************************************************************//**
* \file     clTpeg_SXMTunerImpl.cpp
*
*           clTpeg_SXMTunerImpl method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "SXMTuner/clTpeg_SXMTunerImpl.h"
#include "SXMTuner/clTpeg_Method_TrafficSetRDBID.h"
#include "SXMTuner/tpeg_sxmTunerService_fi.h"

/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_SXMTunerImpl::~clTpeg_SXMTunerImpl()
{
   m_poSetRDBID = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_SXMTunerImpl::clTpeg_SXMTunerImpl(clTpeg_Method_TrafficSetRDBID* poSetRDBID)
:m_poSetRDBID(poSetRDBID)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_SXMTunerImpl::vSetRDBIDListToTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   vSendWishListToSXMTuner(ListOfRdbIds);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_SXMTunerImpl::vSendWishListToSXMTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   if( m_poSetRDBID == NULL)
   {
	   return;
   }
   std::vector<midw_fi_tcl_TrafficRdbidValue, std::allocator<midw_fi_tcl_TrafficRdbidValue> > oRdbidList;
   for (tU32 u32Count = 0; u32Count <ListOfRdbIds.size(); u32Count++)
   {
      if (ListOfRdbIds[u32Count].MsgType.enType != fi_tcl_e8_MessageType::FI_EN_TPEG) // Send all non TPEG messages to SXMTuner
      {
         midw_fi_tcl_TrafficRdbidValue oRDBID;
		 oRDBID.u8RdbidCC  = ListOfRdbIds[u32Count].TMCCountryCode;
         oRDBID.u8RdbidLTN = ListOfRdbIds[u32Count].TableNo;
		 oRDBID.u16Bsa = ListOfRdbIds[u32Count].BSA;
         oRDBID.u8RdbidSID = ListOfRdbIds[u32Count].TmcService.ServiceID;
         oRDBID.bEncFlag   = ListOfRdbIds[u32Count].TmcService.Encrypted;
         oRdbidList.push_back(oRDBID);
      }
   }
   m_poSetRDBID->vSetRDBIDListToTuner(oRdbidList);
}
