/**************************************************************************//**
* \file     clTpeg_Property_TrafficRDBIDACTUALLIST.cpp
*
*           
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "SXMTuner/clTpeg_Property_TrafficRDBIDACTUALLIST.h"
#include "TMCTuner/clTpeg_Property_RdbIdActualList.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_CLIENT_TRAFFICTUNER
#include "trcGenProj/Header/clTpeg_Property_TrafficRDBIDACTUALLIST.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Property_TrafficRDBIDACTUALLIST::~clTpeg_Property_TrafficRDBIDACTUALLIST()
{
   m_poTmcRdbIdActualList = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Property_TrafficRDBIDACTUALLIST::clTpeg_Property_TrafficRDBIDACTUALLIST(
   clCCAhandler* poCCAhandler,  clTpeg_Property_RdbIdActualList* potmcRdbIdActualList
   )
   : clClientProperty(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_RDBIDACTUALLIST, poCCAhandler),
   m_poTmcRdbIdActualList(potmcRdbIdActualList)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TrafficRDBIDACTUALLIST::vStatus(amt_tclServiceData* poInMsg)
{
   if(m_poCCAhandler == NULL){
	   return;
   }
   ETG_TRACE_USR4(("clTpeg_Property_TrafficRDBIDACTUALLIST:: vStatus entered."));
   midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus oMessage;
   m_poCCAhandler->vGetDataFromAmt(poInMsg, oMessage);
   vSendSupportedRdbIdsToTIMA(oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TrafficRDBIDACTUALLIST::vSendSupportedRdbIdsToTIMA(midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& oMessage)
{
   if(m_poTmcRdbIdActualList == NULL)
   {
	   return;
   }
   std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > tmcRdbIdList;
   fi_tcl_e8_TunerReceptionState::tenType receptionState;
   tmcRdbIdList = oGetTMCTunerRdbIdList(oMessage.ListOfRdbIds);
   receptionState = (fi_tcl_e8_TunerReceptionState::tenType)oMessage.ReceptionState.enType;
   m_poTmcRdbIdActualList->vOnNewRdbIdList(tmcRdbIdList,receptionState);
}


/**************************************************************************//**
*
******************************************************************************/
std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > clTpeg_Property_TrafficRDBIDACTUALLIST::oGetTMCTunerRdbIdList(std::vector<midw_fi_tcl_TrafficRdbidValue, std::allocator<midw_fi_tcl_TrafficRdbidValue> > &ListOfRdbIds)
{
   std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > oTmcRdbIdList;
   for (tU32 u32Index=0; u32Index<ListOfRdbIds.size();u32Index++)
   {
	  fi_tcl_TunerRdbId oRdbidElem;
      midw_fi_tcl_TrafficRdbidValue &oRdbid = ListOfRdbIds[u32Index] ;
      oRdbidElem.TMCCountryCode = oRdbid.u8RdbidCC;
      oRdbidElem.TableNo = oRdbid.u8RdbidLTN;
      oRdbidElem.BSA = oRdbid.u16Bsa;
      oRdbidElem.TmcService.ServiceID = oRdbid.u8RdbidSID;
      oRdbidElem.TmcService.Encrypted = oRdbid.bEncFlag;
      oRdbidElem.MsgType.enType = fi_tcl_e8_MessageType::FI_EN_TMC;
      oTmcRdbIdList.push_back(oRdbidElem);
   }
   return oTmcRdbIdList;
}

/**************************************************************************//**
*
******************************************************************************/
std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> >  clTpeg_Property_TrafficRDBIDACTUALLIST::uTestoGetTMCTunerRdbIdList(std::vector<midw_fi_tcl_TrafficRdbidValue, std::allocator<midw_fi_tcl_TrafficRdbidValue> > &ListOfRdbIds)
{
	return oGetTMCTunerRdbIdList(ListOfRdbIds);;
}
