/**************************************************************************//**
* \file     fc_tpeg_tclServiceHdlTmcTuner.cpp
*
*           CCA Service based on ahl_tclBaseOneThreadService
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "fc_tpeg_tclServiceHdlTmcTuner.h"
#include "TMCTuner/tpeg_TMCTuner_fi.h"
#include "fc_tpeg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_SERVER_TMCTUNER
#include "trcGenProj/Header/fc_tpeg_tclServiceHdlTmcTuner.cpp.trc.h"
#endif


/**************************************************************************//**
* Defines
******************************************************************************/
#define TMCTUNER_SERVICE_ID              46
#ifdef VARIANT_S_FTR_ENABLE_FC_TRAFFIC
#define TMCTUNER_FI_MAJOR_VERSION        4
#define TMCTUNER_FI_MINOR_VERSION        0
#else
#define TMCTUNER_FI_MAJOR_VERSION        2
#define TMCTUNER_FI_MINOR_VERSION        1
#endif


/**************************************************************************//**
* Message Map
******************************************************************************/
BEGIN_MSG_MAP(fc_tpeg_tclServiceHdlTmcTuner, ahl_tclBaseWork)
   ON_MESSAGE(TMCTUNERFI_C_U16_SWITCHONOFF, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_SETRDBIDWISHLIST, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_EXCHANGETMCCAPABILITIES, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_OPERATIONMODE, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_RDBIDACTUALLIST, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_TMCDATA, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_TUNERMODE, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_TUNERSTATEANDMODE, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_CURRENTUSERSELECTEDTMCSTATION, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_TPEGDATA, vHandleAllMessages)
   ON_MESSAGE(TMCTUNERFI_C_U16_EXCHANGECAPABILITIES, vHandleAllMessages)
END_MSG_MAP()


/**************************************************************************//**
* Constructor
******************************************************************************/
fc_tpeg_tclServiceHdlTmcTuner::fc_tpeg_tclServiceHdlTmcTuner(ahl_tclBaseOneThreadApp* poMainAppl) : 
ahl_tclBaseOneThreadService(poMainAppl, 
#if (OSAL_OS == OSAL_WINNT)
                            CCA_C_U16_APP_FC_TPEG,
#endif
                            TMCTUNER_SERVICE_ID, TMCTUNER_FI_MAJOR_VERSION, TMCTUNER_FI_MINOR_VERSION
#if (OSAL_OS == OSAL_WINNT)
                            , 0
#endif
                            ),
clCCAhandler(poMainAppl, TMCTUNER_SERVICE_ID, TMCTUNER_FI_MAJOR_VERSION, TMCTUNER_FI_MINOR_VERSION, 0)
{
   ETG_TRACE_USR4(("fc_tpeg_tclServiceHdlTmcTuner() entered."));
}


/**************************************************************************//**
* Destructor
******************************************************************************/
fc_tpeg_tclServiceHdlTmcTuner::~fc_tpeg_tclServiceHdlTmcTuner(tVoid)
{
   ETG_TRACE_USR4(("~fc_tpeg_tclServiceHdlTmcTuner() entered."));
}


/**************************************************************************//**
* Common Handler for All Messages
******************************************************************************/
tVoid fc_tpeg_tclServiceHdlTmcTuner::vHandleAllMessages(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("fc_tpeg_tclServiceHdlTmcTuner::vHandleAllMessages() entered"));
   clCCAhandler::vHandleMessage(poMessage);
}


/**************************************************************************//**
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
******************************************************************************/
tVoid fc_tpeg_tclServiceHdlTmcTuner::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("vOnServiceAvailable() entered."));
}


/**************************************************************************//**
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
******************************************************************************/
tVoid fc_tpeg_tclServiceHdlTmcTuner::vOnServiceUnavailable()
{
    ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));
}

