/**************************************************************************//**
* \file     fc_tpeg_tclClientHdlSxmTuner.cpp
*
*           CCA Client Handler based on ahl_tclBaseOneThreadClientHandler
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "fc_tpeg_tclClientHdlSxmTuner.h"
#include "SXMTuner/tpeg_sxmTunerService_fi.h"
#include "SXMTuner/clTpeg_Method_TrafficSetRDBID.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_CLIENT_TRAFFICTUNER
#include "trcGenProj/Header/fc_tpeg_tclClientHdlSxmTuner.cpp.trc.h"
#endif


/**************************************************************************//**
* Defines
******************************************************************************/
#define TRAFFIC_SERVICE_ID              158
#define TRAFFIC_FI_MAJOR_VERSION        1
#define TRAFFIC_FI_MINOR_VERSION        0


/**************************************************************************//**
* Message Map
******************************************************************************/
#if __GNUC__>5
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wshift-negative-value"
#endif //__GNUC__>5
BEGIN_MSG_MAP(fc_tpeg_tclClientHdlSxmTuner, ahl_tclBaseWork)
   ON_MESSAGE(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_S_SETRDBID, vHandleAllMessages )
   ON_MESSAGE(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TMCDATA, vHandleAllMessages )
   ON_MESSAGE(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_RDBIDACTUALLIST, vHandleAllMessages )
   ON_MESSAGE(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_G_TMCINFO, vHandleAllMessages )
END_MSG_MAP()
#if __GNUC__>5
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wshift-negative-value"
#endif //__GNUC__>5

/**************************************************************************//**
* Constructor
******************************************************************************/
fc_tpeg_tclClientHdlSxmTuner::fc_tpeg_tclClientHdlSxmTuner(ahl_tclBaseOneThreadApp* poMainAppl) : 
clCCAhandler(poMainAppl, TRAFFIC_SERVICE_ID, TRAFFIC_FI_MAJOR_VERSION, TRAFFIC_FI_MINOR_VERSION, CCA_C_U16_APP_FC_SXM),
ahl_tclBaseOneThreadClientHandler(poMainAppl, TRAFFIC_SERVICE_ID, TRAFFIC_FI_MAJOR_VERSION, TRAFFIC_FI_MINOR_VERSION)
{
   ETG_TRACE_USR4(("fc_tpeg_tclClientHdlSxmTuner() entered."));
}


/**************************************************************************//**
* Destructor
******************************************************************************/
fc_tpeg_tclClientHdlSxmTuner::~fc_tpeg_tclClientHdlSxmTuner(tVoid)
{
   ETG_TRACE_USR4(("~fc_tpeg_tclClientHdlSxmTuner() entered."));
}


/**************************************************************************//**
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
******************************************************************************/
tVoid fc_tpeg_tclClientHdlSxmTuner::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("fc_tpeg_tclClientHdlSxmTuner:: vOnServiceAvailable entered."))
   clCCAhandler::vSetRegisterId(ahl_tclBaseOneThreadClientHandler::u16GetRegID());
   clCCAhandler::bRegisterForAllFID();
   vNotifyServiceStateChange();
}


/**************************************************************************//**
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
******************************************************************************/
tVoid fc_tpeg_tclClientHdlSxmTuner::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("fc_tpeg_tclClientHdlSxmTuner:: vOnServiceUnavailable entered."))
   clCCAhandler::vSetRegisterId(0);
}


/**************************************************************************//**
* Common Handler for All Messages
******************************************************************************/
tVoid fc_tpeg_tclClientHdlSxmTuner::vHandleAllMessages(amt_tclServiceData* poInMsg)
{
   ETG_TRACE_USR4(("fc_tpeg_tclClientHdlSxmTuner:: vHandleMessage entered."))
   clCCAhandler::vHandleMessage(poInMsg);
}


/**************************************************************************//**
* Overrides method vProcessTimer.
******************************************************************************/
tVoid fc_tpeg_tclClientHdlSxmTuner::vProcessTimer(tU16 /*u16TimerId */) const
{
   if (TRUE == bIfServiceAvailable())
   {
      // Create message for used service.
   }
}


/**************************************************************************//**
* Currently only the method pclTpeg_Method_SetRDBID has to remember changes
* If required later, this logic will be modified for all classes.
******************************************************************************/
tVoid fc_tpeg_tclClientHdlSxmTuner::vNotifyServiceStateChange()
{
   clTpeg_Method_TrafficSetRDBID *pclTpeg_Method_TrafficSetRDBID =
              dynamic_cast <clTpeg_Method_TrafficSetRDBID*>(poGetFunction(MIDW_TRAFFICFI_C_U16_FID_TRAFFIC_S_SETRDBID));
   if (NULL != pclTpeg_Method_TrafficSetRDBID)
   {
	   pclTpeg_Method_TrafficSetRDBID->vOnNewServiceState(bIfServiceAvailable());
   }
}
