/**************************************************************************//**
* \file     clServerMethod.cpp
*
*           Base class for SDS server method implementations.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "CcaApp/clServerMethod.h"
#include "CcaApp/clCCAhandler.h"
#include "CcaApp/clServerMethodObserver.h"


/**************************************************************************//**
* Destructor
******************************************************************************/
clServerMethod::~clServerMethod()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clServerMethod::clServerMethod(
   tU16 u16FunctionID,
   clCCAhandler* poCCAhandler
   )
   : clFunction(u16FunctionID, poCCAhandler),
     m_u16DestAppID(0),
     m_u16CmdCtr(0),
     m_u16RegisterID(0)
{
}


/**************************************************************************//**
* Performs opcode check for incoming message. Delegates message handling to
* derived class.
******************************************************************************/
tVoid clServerMethod::vHandleMessage(amt_tclServiceData* poInMsg)
{
   switch (poInMsg->u8GetOpCode())
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
         vSaveResponseParameters(poInMsg);
         vMethodStart(poInMsg);
         break;

      default:
         break;
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerMethod::vSaveResponseParameters(
   amt_tclServiceData* poInMessage
   )
{
   m_u16DestAppID = poInMessage->u16GetSourceAppID();
   m_u16CmdCtr = poInMessage->u16GetCmdCounter();
   m_u16RegisterID = poInMessage->u16GetRegisterID();
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerMethod::vSendMethodResult()
{
   m_poCCAhandler->vSendEmptyMessage( 
      m_u16DestAppID,
      m_u16CmdCtr,
      m_u16RegisterID,
      u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerMethod::vSendMethodResult(fi_tclTypeBase& oOutData)
{
   m_poCCAhandler->vSendMessage( 
      m_u16DestAppID,
      m_u16CmdCtr,
      m_u16RegisterID,
      oOutData,
      u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerMethod::vSendErrorMessage(tU16 u16ErrorCode)
{
   m_poCCAhandler->vTpegSendErrorMessage( 
      m_u16DestAppID,
      m_u16CmdCtr,
      m_u16RegisterID,
      u16GetFunctionID(),
      u16ErrorCode);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerMethod::vRegisterObserver(clServerMethodObserver* poObserver)
{
   if (poObserver != NULL)
   {
      m_observers.push_back(poObserver);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerMethod::vNotifyObservers()
{
   std::vector<clServerMethodObserver*>::iterator iter = m_observers.begin();
   while (iter != m_observers.end())
   {
      if (*iter != NULL)
      {
         (*iter)->vMethodStart(u16GetFunctionID());
      }
      iter++;
   }
}


/**************************************************************************//**
*
******************************************************************************/
tU16 clServerMethod::u16GetCmdCtr() const
{
   return m_u16CmdCtr;
}
