/************************************************************************
* FILE:         clFiPropRegHelper.h
* PROJECT:      Ford
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:  Data of a Function ID registration
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
*************************************************************************/


#ifndef CLFIPROPREGHELPER_H
#define CLFIPROPREGHELPER_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


class clFiPropRegHelper 
{
private:

    /**
    * function ID which should be supported 
    */
    tU16 m_u16FunctionID;

    /**
    * return value store for registration
    */
    tBool m_bIsRegSucceeded;

    /**
    * return value store for registration
    */
    tBool m_bRegisterDone;

    /**
    * store value for response of upreg 
    */
    tBool m_bUpRegOK;

public:

    /**
    * destructor 
    */
    virtual ~clFiPropRegHelper();      

    /**
    * constructor 
    */
    clFiPropRegHelper();

    /**
    * helperfunction to set the function ID of the property 
    */
    virtual tVoid  vSetFunctionID( tU16 u16FunctionID );

    /**
    * helperfunction to get the FunctionID
    */
    virtual tU16 u16GetFunctionID(tVoid);

    /**
    * helperfunction to set the return value of the 
    * register for the property 
    */
    virtual tVoid vSetRetVal( tBool bRetVal );

    /**
    * helperfunction to get the return value of the 
    * register for the property 
    */
    virtual tBool bGetRetVal( tVoid );

    /**
    * helperfunction to set a flag that registration was triggered
    */
    virtual tVoid vSetRegisterDone( tBool bRetVal );

    /**
    * helperfunction to get information if registration was done
    */
    virtual tBool bIsRegisterDone( tVoid );

    /**
    * helperfunction to set a flag for response of registration/UpReg
    */
    virtual tVoid vSetUpRegResponse( tBool bRetVal );

    /**
    * helperfunction to get information if registration/UpReg response was successful 
    */
    virtual tBool bIsUpRegValid( tVoid );
};
#endif //CLFIPROPREGHELPER_H
