/**************************************************************************//**
* \file     clTpeg_Property_TunRDBIDACTUALLIST.cpp
*
*           
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "AMFMTuner/clTpeg_Property_TunRDBIDACTUALLIST.h"
#include "TMCTuner/clTpeg_Property_RdbIdActualList.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_CLIENT_AMFMTUNER
#include "trcGenProj/Header/clTpeg_Property_TunRDBIDACTUALLIST.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Property_TunRDBIDACTUALLIST::~clTpeg_Property_TunRDBIDACTUALLIST()
{
   m_poTmcRdbIdActualList = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Property_TunRDBIDACTUALLIST::clTpeg_Property_TunRDBIDACTUALLIST(
   clCCAhandler* poCCAhandler,  clTpeg_Property_RdbIdActualList* potmcRdbIdActualList
   )
   : clClientProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_RDBIDACTUALLIST, poCCAhandler),
   m_poTmcRdbIdActualList(potmcRdbIdActualList)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TunRDBIDACTUALLIST::vStatus(amt_tclServiceData* poInMsg)
{
   if(m_poCCAhandler!=NULL)
   {
      ETG_TRACE_USR4(("clTpeg_Property_TunRDBIDACTUALLIST:: vStatus entered."));
      midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus oMessage;
      m_poCCAhandler->vGetDataFromAmt(poInMsg, oMessage);
      vSendSupportedRdbIdsToTIMA(oMessage);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TunRDBIDACTUALLIST::vSendSupportedRdbIdsToTIMA(midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& oMessage)
{
   if(m_poTmcRdbIdActualList!=NULL)
   {
      std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > tmcRdbIdList;
      tmcRdbIdList = oGetTMCTunerRdbIdList(oMessage.ListOfRdbIds);
      fi_tcl_e8_TunerReceptionState::tenType receptionState=fi_tcl_e8_TunerReceptionState::FI_EN_OK;//ok
      m_poTmcRdbIdActualList->vOnNewRdbIdList(tmcRdbIdList,receptionState);
   }
}


/**************************************************************************//**
*
******************************************************************************/
std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > clTpeg_Property_TunRDBIDACTUALLIST::oGetTMCTunerRdbIdList(std::vector<midw_fi_tcl_TunerRdbId, std::allocator<midw_fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > oTmcRdbIdList;
   for (tU32 u32Index=0; u32Index<ListOfRdbIds.size();u32Index++)
   {
      fi_tcl_TunerRdbId oRdbidElem;
      midw_fi_tcl_TunerRdbId &oRdbid = ListOfRdbIds[u32Index] ;
      oRdbidElem.TMCCountryCode = oRdbid.TMCCountryCode;
      oRdbidElem.TableNo = oRdbid.TableNo;
      oRdbidElem.BSA = 0;
      oRdbidElem.TmcService.ServiceID = oRdbid.ServiceID;
      oRdbidElem.TmcService.Encrypted = oRdbid.Encrypted;
      oRdbidElem.MsgType.enType = fi_tcl_e8_MessageType::FI_EN_TMC;
      oTmcRdbIdList.push_back(oRdbidElem);
   }
   return oTmcRdbIdList;
}

