/**************************************************************************//**
* \file     clTpeg_Method_SetRDBID.cpp
*
*           clTpeg_Method_SetRDBID method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "AMFMTuner/clTpeg_Method_SetRDBID.h"
#include "CcaApp/clCCAhandler.h"
#include "fc_tpeg_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_CLIENT_AMFMTUNER
#include "trcGenProj/Header/clTpeg_Method_SetRDBID.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Method_SetRDBID::~clTpeg_Method_SetRDBID()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Method_SetRDBID::clTpeg_Method_SetRDBID(clCCAhandler* poCCAhandler)
   : clClientMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_RDBID, poCCAhandler)
{
   m_oMessage.TunRDBID_Value.clear();
   m_oMessage.u8NumOfRDBID = 0;
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_SetRDBID::vMethodResult(amt_tclServiceData* /*poInMessage*/ )
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_SetRDBID::vSetRDBIDListToTuner(std::vector<midw_fi_tcl_Tun_RDBID_Value, std::allocator<midw_fi_tcl_Tun_RDBID_Value> > &oRdbidList)
{
   if(!oRdbidList.empty())
   {
	   m_oMessage.TunRDBID_Value = oRdbidList;
	   m_oMessage.u8NumOfRDBID = (tU8)oRdbidList.size();
	   vMethodStart(m_oMessage);
   }
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_Method_SetRDBID::vOnNewServiceState(tBool bIsServiceAvailable) 
{
   if(bIsServiceAvailable == TRUE && m_oMessage.TunRDBID_Value.size())
   {
      ETG_TRACE_USR4(("clTpeg_Method_SetRDBID:: vOnNewServiceState  Sending methodstart on service availability "))
      vMethodStart(m_oMessage);
   }
}
