/**************************************************************************//**
* \file     clTpeg_AMFMTunerImpl.cpp
*
*           clTpeg_AMFMTunerImpl method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "AMFMTuner/clTpeg_AMFMTunerImpl.h"
#include "AMFMTuner/clTpeg_Method_SetRDBID.h"
#include "AMFMTuner/tpeg_amfmTunerService_fi.h"

/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_AMFMTunerImpl::~clTpeg_AMFMTunerImpl()
{
   m_poSetRDBID = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_AMFMTunerImpl::clTpeg_AMFMTunerImpl(clTpeg_Method_SetRDBID* poSetRDBID)
:m_poSetRDBID(poSetRDBID)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_AMFMTunerImpl::vSetRDBIDListToTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   vSendWishListToAMFMTuner(ListOfRdbIds);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_AMFMTunerImpl::vSendWishListToAMFMTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds)
{
   std::vector<midw_fi_tcl_Tun_RDBID_Value, std::allocator<midw_fi_tcl_Tun_RDBID_Value> > oRdbidList;
   for (tU32 u32Count = 0; u32Count <ListOfRdbIds.size(); u32Count++)
   {
      if (ListOfRdbIds[u32Count].MsgType.enType != fi_tcl_e8_MessageType::FI_EN_TPEG) // Send all non TPEG messages to AMFMTuner
      {
         midw_fi_tcl_Tun_RDBID_Value oRDBID;
         oRDBID.u8RdbidCC  = ListOfRdbIds[u32Count].TMCCountryCode;
         oRDBID.u8RdbidLTN = ListOfRdbIds[u32Count].TableNo;
         oRDBID.u8RdbidSID = ListOfRdbIds[u32Count].TmcService.ServiceID;
         oRDBID.bEncFlag   = ListOfRdbIds[u32Count].TmcService.Encrypted;
         oRdbidList.push_back(oRDBID);
      }
   }
   if(m_poSetRDBID!=NULL)
   {
      m_poSetRDBID->vSetRDBIDListToTuner(oRdbidList);
   }

}
