/************************************************************************
 * FILE:        clTmcTuner_TMCTunerControl.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_TMCTunerControl.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "interface/clTmcTuner_TMCTunerControl.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "interface/clTmcTuner_TunerApp_ImpInterface.h"

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGFROMHMI
#include "trcGenProj/Header/clTmcTuner_TMCTunerControl.cpp.trc.h"
#endif

static clTmcTuner_HMI_ImpInterface* m_poAudioFGBGImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poSetGetStaticListImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poPresetListSetActiveImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poDemodulationImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poAtPiSearchImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poAudioProgramSelectImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poHDTestMode = 0;
static clTmcTuner_HMI_ImpInterface* m_poATHDLongName = 0;
static clTmcTuner_HMI_ImpInterface* m_poATHDImageFileUpdate = 0;
static clTmcTuner_HMI_ImpInterface* m_poDRMTestModeImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poAudioSplitModeImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poHDSectionParameterImpl = 0;
static clTmcTuner_TunerApp_ImpInterface* m_poHDFirmwareInfo = 0;
static clTmcTuner_HMI_ImpInterface* m_poDRMRadioTextimpl =0;
static clTmcTuner_HMI_ImpInterface* m_poGetConfigListImpl=0;
static clTmcTuner_TunerApp_ImpInterface* m_poSetConfigSections = 0;
static clTmcTuner_TunerApp_ImpInterface* m_poGetConfigurationInfo = 0;
static clTmcTuner_HMI_ImpInterface* m_poPropertyGetConfigListImpl=0;
static clTmcTuner_HMI_ImpInterface* m_poPropertySurviellanceListUpdateImpl=0;
static clTmcTuner_HMI_ImpInterface* m_poMethodConfiglistUpdateLandImpl=0;
static clTmcTuner_HMI_ImpInterface* m_poPropertyUpdateLandscapeProgressImpl=0;
static clTmcTuner_HMI_ImpInterface* m_poMuteRequestImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poAudioMuteRequestImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poMethodSelectConfiglistElementImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poATPIImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poATSeekImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poATFrequencyImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poStationListSelectionImpl = 0;
static clTmcTuner_TunerApp_ImpInterface* m_poAdditionalVersionInfo = 0;
static clTmcTuner_HMI_ImpInterface* m_poCalibrationDataImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poPropertyListUpdateNotificationImpl =0;
static clTmcTuner_HMI_ImpInterface* m_poEnhancedTestModeImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poDARCDataImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poSetUserOptionsImpl = 0;
//static clTmcTuner_HMI_ImpInterface* m_poCopyUserContentImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poPresetListContentUpdateImpl = 0;
static clTmcTuner_HMI_ImpInterface* m_poChangeLsmImpl = 0;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_TMCTunerControl::~clTmcTuner_TMCTunerControl()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_TMCTunerControl::clTmcTuner_TMCTunerControl()
{
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetAudioFGBGImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poAudioFGBGImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetGetStaticListImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poSetGetStaticListImpl=poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetPresetListSetActiveImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poPresetListSetActiveImpl=poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetDemodulationImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poDemodulationImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetChangeLsmImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poChangeLsmImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetHDTestModeImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poHDTestMode = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetAtPiSearchImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poAtPiSearchImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetATFrequencyImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poATFrequencyImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetStationListSelectionImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poStationListSelectionImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetSelectAudioProgramImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poAudioProgramSelectImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetDRMTestModeImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poDRMTestModeImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetAudioSplitModeImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poAudioSplitModeImpl = poImpl;
}
void clTmcTuner_TMCTunerControl::vSetHDSectionParameterImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poHDSectionParameterImpl = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetHDFirmwareInfoImpl(clTmcTuner_TunerApp_ImpInterface* poImpl)
{
   m_poHDFirmwareInfo = poImpl;
}
/*****************************************************************************
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetAdditionalVersionInfoImpl(clTmcTuner_TunerApp_ImpInterface* poImpl)
{
	m_poAdditionalVersionInfo = poImpl;
}
/*****************************************************************************
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetDRMRadiotextImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poDRMRadioTextimpl=poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetATHDLongNameImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poATHDLongName = poImpl;
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetATHDImageFileUpdateImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
   m_poATHDImageFileUpdate = poImpl;
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetConfigSectionsImpl(clTmcTuner_TunerApp_ImpInterface* poImpl)
{
   m_poSetConfigSections = poImpl;
}


/**************************************************************************//**
 *
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetGetConfigurationInfoImpl(clTmcTuner_TunerApp_ImpInterface* poImpl)
{
	m_poGetConfigurationInfo = poImpl;
}

/**************************************************************************//**
 *
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetCMSetUserOptionsImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poSetUserOptionsImpl = poImpl;
}

/**************************************************************************//**
 *
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetPresetListContentUpdateImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poPresetListContentUpdateImpl = poImpl;
}
/**************************************************************************//**
 *
******************************************************************************/

void clTmcTuner_TMCTunerControl::vOnNewTunerFGBGStatus(unsigned char AudioSource)
{
   if (0 != m_poAudioFGBGImpl)
   {
      m_poAudioFGBGImpl->vOnNewTunerFGBGStatus(AudioSource);
   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnATPresetListSetActiveResult()
{
	   if (0 != m_poPresetListSetActiveImpl)
	   {
	      m_poPresetListSetActiveImpl->vOnATPresetListSetActiveResult();
	   }
}
void clTmcTuner_TMCTunerControl::vOnCopyUserContentResult()
{
	   if (0 != m_poSetUserOptionsImpl)
	   {
		   m_poSetUserOptionsImpl->vOnCopyUserContentResult();
	   }
}
void clTmcTuner_TMCTunerControl::vOnPresetListContentUpdateResult(unsigned char u8Result)
{
	   if (0 != m_poPresetListContentUpdateImpl)
	   {
		   m_poPresetListContentUpdateImpl->vOnPresetListContentUpdateResult(u8Result);
	   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnCMATPresetList_XX_Status(clCMATPresetList_XX &oData,unsigned short u16FunctionId)
{
		if (0 != m_poSetGetStaticListImpl)
	   {
		   m_poSetGetStaticListImpl->vOnCMATPresetList_XX_Status(oData,u16FunctionId);
	   }
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewDemodulationStatus(const unsigned char &u8DemodulationSwitch)
{
   if (0 != m_poDemodulationImpl)
   {
      m_poDemodulationImpl->vOnNewDemodulationStatus(u8DemodulationSwitch);
   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnChangeLsmStatus()
{
   if (0 != m_poChangeLsmImpl)
   {
	  m_poChangeLsmImpl->vOnChangeLsmStatus();
   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewAtPiSearchStatus(const unsigned char &u8PiSearchStatus)
{
   if (0 != m_poAtPiSearchImpl)
   {
      m_poAtPiSearchImpl->vOnNewAtPiSearchStatus(u8PiSearchStatus);
   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewATHDAudioProgramStatus(const unsigned char &u8HDAudioProgram)
{
   if (0 != m_poAudioProgramSelectImpl)
   {
      m_poAudioProgramSelectImpl->vOnNewATHDAudioProgramStatus(u8HDAudioProgram);
   }
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewATHDTestModeStatus(clCMHDTestModeStatus &oHDTestModeData,unsigned char u8PhysicalTuner,unsigned char u8TransitionCount)
{
   if (0 != m_poHDTestMode)
   {
      m_poHDTestMode->vOnNewATHDTestModeStatus(oHDTestModeData,u8PhysicalTuner,u8TransitionCount);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewHDFirmwareInfoStatus(const char* poU8Firmwareinfo )
{
   if (0 != m_poHDFirmwareInfo)
   {
      m_poHDFirmwareInfo->vOnNewHDFirmwareInfoStatus(poU8Firmwareinfo);
   }
}
/******************************************************************************
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewAdditionalVersionInfoStatus(unsigned char u8FirstVersionDigit, unsigned char u8SecondVersionDigit, unsigned char u8ThirdVersionDigit)
{
   if (0 != m_poAdditionalVersionInfo)
   {
      m_poAdditionalVersionInfo->vOnNewAdditionalVersionInfoStatus(u8FirstVersionDigit,u8SecondVersionDigit,u8ThirdVersionDigit);
   }
}
/******************************************************************************
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnCM_DRMCurrentRadiotextStatus(tunerString sDRMCurrentRadioText)
{
	if(0!=m_poDRMRadioTextimpl)
	{
		m_poDRMRadioTextimpl->vOnCM_DRMCurrentRadiotextStatus(sDRMCurrentRadioText);
	}
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewDRMTestModeStatus(clCMDrmTestModeStatus &oData)
{
   if (0 != m_poDRMTestModeImpl)
   {
      m_poDRMTestModeImpl->vOnNewDRMTestModeStatus(oData);
   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewAudioSplitModeStatus(char s8ParameterValue)
{
   if (0 != m_poAudioSplitModeImpl)
   {
	   m_poAudioSplitModeImpl->vOnNewAudioSplitModeStatus(s8ParameterValue);
   }
}
void clTmcTuner_TMCTunerControl::vOnNewHDSectionParameterStatus(unsigned short u16ParameterID, char s8ParameterValue)
{
   if (0 != m_poHDSectionParameterImpl)
   {
	   m_poHDSectionParameterImpl->vOnNewHDSectionParameterStatus(u16ParameterID,s8ParameterValue);
   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewCMSetUserOptionsStatus(unsigned char u8UserId, unsigned int u32UserOptions)
{
   if (0 != m_poSetUserOptionsImpl)
   {
	   m_poSetUserOptionsImpl->vOnNewCMSetUserOptionsStatus(u8UserId,u32UserOptions);
   }
}
/**************************************************************************//**

******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewATHDLongNameStatus(const unsigned int u32HDStationId,const unsigned char u8HDAudioProgram,const tunerString sATHDLongName)
{
   if (0 != m_poATHDLongName)
   {
      m_poATHDLongName->vOnNewATHDLongNameStatus(u32HDStationId,u8HDAudioProgram,sATHDLongName);
   }
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewATHDImageFileUpdateStatus(clCMATHDImageFileUpdateStatus &oImageFileData)
{
   if (0 != m_poATHDImageFileUpdate)
   {
      m_poATHDImageFileUpdate->vOnNewATHDImageFileUpdateStatus(oImageFileData);
   }
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewSetConfigSectionsResult(unsigned char u8Result)
{
   if (0 != m_poSetConfigSections)
   {
      m_poSetConfigSections->vOnNewSetConfigSectionsResult(u8Result);
   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vOnNewGetConfigurationInfoStatus(tunerString sVersioninfo , unsigned int u32CRC)
{
   if (0 != m_poGetConfigurationInfo)
   {
	   m_poGetConfigurationInfo->vOnNewGetConfigurationInfoStatus(sVersioninfo,u32CRC);
   }
}
/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_TMCTunerControl::vSetUpdateLandscapeProgressImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poPropertyUpdateLandscapeProgressImpl = poImpl;
}
void clTmcTuner_TMCTunerControl::vOnCM_StationListConfigResult(unsigned char u8ListId,unsigned char u8NumberOfStations)
{
	   if (0 != m_poGetConfigListImpl)
	   {
		   m_poGetConfigListImpl->vOnCM_StationListConfigResult(u8ListId,u8NumberOfStations);
	   }
}
/*****************************************************************************
*
******************************************************************************/
void  clTmcTuner_TMCTunerControl::vOnCM_StationListStatus(clCMStationsListStatus &oData)
{
	if((0==m_poPropertyGetConfigListImpl) || (0==m_poPropertySurviellanceListUpdateImpl))
	{
		NORMAL_M_ASSERT( m_poPropertyGetConfigListImpl != NULL );
		NORMAL_M_ASSERT( m_poPropertySurviellanceListUpdateImpl != NULL );	
		return;
	}
	if(oData.ListId == 0x06)
	{
		m_poPropertySurviellanceListUpdateImpl->vOnCM_StationListStatus(oData);
	}
	else
	{
		m_poPropertyGetConfigListImpl->vOnCM_StationListStatus(oData);
	}
}
/*****************************************************************************
*
******************************************************************************/

void clTmcTuner_TMCTunerControl::vOnNewATSeekStatus(unsigned char u8SeekState)
{
    if(m_poATSeekImpl != 0)
    {
        m_poATSeekImpl->vOnNewATSeekStatus(u8SeekState);
    }
}

void  clTmcTuner_TMCTunerControl::vOnCM_UpdateLandscapeResult()
{
	m_poMethodConfiglistUpdateLandImpl->vOnCM_UpdateLandscapeResult();
}
void  clTmcTuner_TMCTunerControl::vOnCM_UpdateLandscapeError()
{
	m_poMethodConfiglistUpdateLandImpl->vOnCM_UpdateLandscapeError();
}
void  clTmcTuner_TMCTunerControl::vOnCM_UpdateLandscapeProgressStatus(unsigned char u8ScannedFrequenciesRatio)
{
	m_poPropertyUpdateLandscapeProgressImpl->vOnCM_UpdateLandscapeProgressStatus(u8ScannedFrequenciesRatio);
}

void clTmcTuner_TMCTunerControl::vSetMethodGetConfigListImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poGetConfigListImpl=poImpl;
}
/*****************************************************************************
*
******************************************************************************/

void clTmcTuner_TMCTunerControl::vSetPropertyGetConfigListImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poPropertyGetConfigListImpl=poImpl;
}

void clTmcTuner_TMCTunerControl::vSetPropertySurviellanceListUpdateImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poPropertySurviellanceListUpdateImpl=poImpl;
}

void clTmcTuner_TMCTunerControl::vSetPropertyListUpdateNotificationImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poPropertyListUpdateNotificationImpl=poImpl;
}


/*****************************************************************************
*
******************************************************************************/

void clTmcTuner_TMCTunerControl::vSetMethodConfiglistUpdateLandImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poMethodConfiglistUpdateLandImpl=poImpl;
}
/*****************************************************************************/
void clTmcTuner_TMCTunerControl::vSetMuteRequestImpl(clTmcTuner_HMI_ImpInterface*  poImpl)
{
	m_poMuteRequestImpl = poImpl;
}
/*****************************************************************************/
void clTmcTuner_TMCTunerControl::vSetAudioMuteRequestImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poAudioMuteRequestImpl = poImpl;
}
/*****************************************************************************/
void clTmcTuner_TMCTunerControl::vSendMuteDemuteRequestStatus(bool bMuteState, bool bInterrupt)
{
	if(m_poMuteRequestImpl != 0)
	{
		m_poMuteRequestImpl->vSendMuteDemuteRequestStatus(bMuteState, bInterrupt);
	}
}
/*****************************************************************************/
void clTmcTuner_TMCTunerControl::vSetMethodSelectConfiglistElementImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poMethodSelectConfiglistElementImpl = poImpl;
}
void clTmcTuner_TMCTunerControl::vSetATPIImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
    m_poATPIImpl = poImpl;
}

void clTmcTuner_TMCTunerControl::vSetATSeekImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
    m_poATSeekImpl = poImpl;
}


void clTmcTuner_TMCTunerControl::vSetCalibrationDataImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
    m_poCalibrationDataImpl = poImpl;
}

void clTmcTuner_TMCTunerControl::vOnCalibrationStatus(clCMCalibrationDataStatus &oCalibrationData)
{
    if(m_poCalibrationDataImpl != 0)
    {
        m_poCalibrationDataImpl->vOnCalibrationStatus(oCalibrationData);
    }
}

void clTmcTuner_TMCTunerControl::vOnCM_ChangeOfSurveilledStationsStatus()
{
	if((0 == m_poPropertySurviellanceListUpdateImpl) || (0 == m_poPropertyListUpdateNotificationImpl))
	{
		NORMAL_M_ASSERT( m_poPropertySurviellanceListUpdateImpl != NULL );
		NORMAL_M_ASSERT( m_poPropertyListUpdateNotificationImpl != NULL );	
		return;
    }
	m_poPropertySurviellanceListUpdateImpl->vSendSDSStationListConfig();
	m_poPropertyListUpdateNotificationImpl->vOnListUpdateNotification();	
}

void clTmcTuner_TMCTunerControl::vSetEnhancedTestModeImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
    m_poEnhancedTestModeImpl = poImpl;
}

void clTmcTuner_TMCTunerControl::vOnEnhancedTestModeStatus(unsigned char u8PhysicalTuner, clCMEnhancedTestModeStatus &oEnhancedTestModeData)
{
    if(m_poEnhancedTestModeImpl != 0)
    {
        m_poEnhancedTestModeImpl->vOnEnhancedTestModeStatus(u8PhysicalTuner, oEnhancedTestModeData);
    }
}

void clTmcTuner_TMCTunerControl::vSetPropertyDARCDataImpl(clTmcTuner_HMI_ImpInterface* poImpl)
{
	m_poDARCDataImpl = poImpl;
}

void clTmcTuner_TMCTunerControl::vOnCM_DARCDataStatus(clCMDARCGetDataStatus &oDARCDataStatus)
{
	if(m_poDARCDataImpl != 0)
	{
		m_poDARCDataImpl->vOnCM_DARCDataStatus(oDARCDataStatus);
	}
}


/******************************** Error Handling *********************************************/
void clTmcTuner_TMCTunerControl::vOnATPIError(clCMError &oData)
{
    if(m_poATPIImpl != 0)
    {
        m_poATPIImpl->vOnATPIError(oData);
    }
}

void clTmcTuner_TMCTunerControl::vOnATSeekError(clCMError &oData)
{
    if(m_poATPIImpl != 0)
    {
        m_poATPIImpl->vOnATSeekError(oData);
    }
}

void clTmcTuner_TMCTunerControl::vOnATFrequencyError(clCMError &oData)
{
    if(m_poATFrequencyImpl != 0)
    {
        m_poATFrequencyImpl->vOnATFrequencyError(oData);
    }
}

void clTmcTuner_TMCTunerControl::vOnStationListSelectionError(clCMError &oData)
{
    if(m_poStationListSelectionImpl != 0)
    {
        m_poStationListSelectionImpl->vOnStationListSelectionError(oData);
    }
}

void clTmcTuner_TMCTunerControl::vOnUpdateLandscapeError(clCMError &oData)
{
    if(m_poPropertyUpdateLandscapeProgressImpl != 0)
    {
        m_poPropertyUpdateLandscapeProgressImpl->vOnUpdateLandscapeError(oData);
    }
}

void clTmcTuner_TMCTunerControl::vOnCM_SetUserOptionsError(clCMError &oData)
{
    if(m_poSetUserOptionsImpl != 0)
    {
    	m_poSetUserOptionsImpl->vOnCM_SetUserOptionsError(oData);
    }
}
void clTmcTuner_TMCTunerControl::vOnCM_PresetListContentUpdateError()
{
    if(m_poPresetListContentUpdateImpl != 0)
    {
    	m_poSetUserOptionsImpl->vOnCM_PresetListContentUpdateError();
    }
}
void clTmcTuner_TMCTunerControl::vOnCM_CopyUserContentError(clCMError &oData)
{
    if(m_poSetUserOptionsImpl != 0)
    {
    	m_poSetUserOptionsImpl->vOnCM_CopyUserContentError(oData);
    }
}
void clTmcTuner_TMCTunerControl::vOnNewDemodulationError(clCMError &oData)
{
   if (0 != m_poDemodulationImpl)
   {
      m_poDemodulationImpl->vOnNewDemodulationError(oData);
   }
}
void clTmcTuner_TMCTunerControl::vOnChangeLsmError()
{	
   if (0 != m_poChangeLsmImpl)
   {
      m_poChangeLsmImpl->vOnChangeLsmError();
   }
}
