/************************************************************************
 * FILE:         clTmcTuner_HMI_ImpInterface.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_HMI_ImpInterface.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#ifndef clTmcTuner_HMI_ImpInterface_h
#define clTmcTuner_HMI_ImpInterface_h
#include "ADRMsg/ADRMsg_if.h"

#include "datatypes/tString.h"
class clTmcTuner_HMI_ImpInterface
{
   public:
        virtual ~clTmcTuner_HMI_ImpInterface();
        clTmcTuner_HMI_ImpInterface();
        virtual void vOnNewTunerFGBGStatus(unsigned char AudioSource);
        virtual void vOnATPresetListSetActiveResult();
        virtual void vOnCMATPresetList_XX_Status(clCMATPresetList_XX &oData,short u16FunctionId);
        virtual void vOnNewDemodulationStatus(const unsigned char u8DemodulationSwitch);
        virtual void vOnNewAtPiSearchStatus(const unsigned char u8AtPiSearchStatus);
        virtual void vOnNewATHDAudioProgramStatus(const unsigned char &u8AudioProgram);
        virtual void vOnCM_DRMCurrentRadiotextStatus(tunerString sDRMCurrentRadioText);
        virtual void vOnNewDRMTestModeStatus(clCMDrmTestModeStatus &oData);
        virtual void vOnNewATHDTestModeStatus(clCMHDTestModeStatus &oHDTestModeData,unsigned char u8PhysicalTuner,unsigned char u8TransitionCount);
        virtual void vOnNewATHDLongNameStatus(const unsigned int u32HDStationId,const unsigned char u8HDAudioProgram,const tunerString sATHDLongName);
        virtual void vOnNewATHDImageFileUpdateStatus(clCMATHDImageFileUpdateStatus &oImageFileData);
        virtual void vOnCM_StationListConfigResult(unsigned char u8ListId,unsigned char u8NumberOfStations);
        virtual void vOnCM_StationListStatus(clCMStationsListStatus &oData);
        virtual void vOnCM_UpdateLandscapeResult();
        virtual void vOnCM_UpdateLandscapeError();
        virtual void  vOnCM_UpdateLandscapeProgressStatus(unsigned char u8ScannedFrequenciesRatio);
        virtual void vOnATPIError(clCMError &oData);
        virtual void vOnATSeekError(clCMError &/*oData*/);
		virtual void vOnCM_SetUserOptionsError(clCMError &oData);
		virtual void vOnCM_CopyUserContentError(clCMError &oData);
        virtual void vOnATFrequencyError(clCMError &oData);
        virtual void vOnStationListSelectionError(clCMError &oData);
        virtual void vSendMuteDemuteRequestStatus(bool bMuteState, bool bInterrupt);
        virtual void vOnNewATSeekStatus(unsigned char u8SeekState);
        virtual void vOnUpdateLandscapeError(clCMError &oData);
		virtual void vOnNewAudioSplitModeStatus(char s8ParameterValue);
        virtual void vOnNewHDSectionParameterStatus(unsigned short u16ParameterID, char s8ParameterValue);
        virtual void vOnCalibrationStatus(clCMCalibrationDataStatus &oCalibrationData);
        virtual void vOnEnhancedTestModeStatus(unsigned char u8PhysicalTuner, clCMEnhancedTestModeStatus &oEnhancedTestModeData);
	    virtual void vSendSDSStationListConfig();
	    virtual void vOnListUpdateNotification();
	    virtual void vOnCM_DARCDataStatus(clCMDARCGetDataStatus &oDARCDataStatus);
	    virtual void vOnNewCMSetUserOptionsStatus(unsigned char u8UserId, unsigned int u32UserOptions);
	    virtual void vOnCopyUserContentResult();
	    virtual void vOnPresetListContentUpdateResult(unsigned char u8Result);
		virtual void vOnNewDemodulationError(clCMError &oData);
		virtual void vOnCM_PresetListContentUpdateError();
		virtual void vOnChangeLsmError();
		virtual void vOnChangeLsmStatus();
};

#endif
