/************************************************************************
 * FILE:        dp_tclTunerImpl.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dp_tclTunerImpl.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 
 
#include "dp_tclTunerImpl.h"

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#endif
#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/dp_tclTunerImpl.cpp.trc.h"
#endif
dp_tclTunerImpl::dp_tclTunerImpl()
{

}
dp_tclTunerImpl::~dp_tclTunerImpl()
{

}
bool dp_tclTunerImpl::getTunerDPValue(tentclTunerDp entclTunerDp)
{
	switch(entclTunerDp)
	{
		case enAMAvailabilityHMIStatusDp:
		{
			dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
			tBool bTmcTunerDPAMAvailStatus = true;
			oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);
			ETG_TRACE_USR4(("TunerDPAMAvailabilityHMIStatus=%d",bTmcTunerDPAMAvailStatus));
			return (bTmcTunerDPAMAvailStatus);
			break;
		}
		default:
			break;
	}
	return false;
}
void dp_tclTunerImpl::vSetTunerDPValue(tentclTunerDp entclTunerDp,bool blval)
{
	ETG_TRACE_USR4(("SettunerDp entclTunerDp=%d blval=%d",entclTunerDp,blval));
	switch(entclTunerDp)
	{
		case enAMAvailabilityHMIStatusDp:
		{
			dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
			getTunerDPValue(enAMAvailabilityHMIStatusDp);
			//oTmcTunerDPAMAvailability.bReloadDpElement();
			//getTunerDPValue(enAMAvailabilityHMIStatusDp);
			oTmcTunerDPAMAvailability.s32SetData(blval);
			getTunerDPValue(enAMAvailabilityHMIStatusDp);
			break;
		}
		default:
			break;
	}
}