/************************************************************************
 * FILE:        clTmcTuner_stationLogo_map.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_stationLogo_map.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   15-Apr-2015         vnd4kor
				
 *************************************************************************/

#ifndef clTmcTuner_stationLogo_map_h
#define clTmcTuner_stationLogo_map_h

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "datatypes/tString.h"
#include <list>
#include <map>
#include "radioDnsEcc/clExtCountryCode.h"
/** importing bpstl map required for list id map */
//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_LIST
//#include <stl_pif.h>
//using namespace bpstl;

namespace tuner
{
	namespace common
	{
		namespace radiodnsecc
		{
			class clExtCountryCode;
		}
	}
}

struct logostr{
	logostr(tU8 ecc ,tunerString str):
	u8ECC(ecc),
	sPath(str)
	{
	}
	tU8 u8ECC;
	tunerString sPath;
};
typedef std::map<unsigned int,logostr  > MapPICode_StationLogoFileName;

class clConfigInterface;

class clTmcTuner_stationLogo_map 
{
   public:
      virtual ~clTmcTuner_stationLogo_map();
      clTmcTuner_stationLogo_map(clConfigInterface* poclConfigInterface);
	  	  
	  void vGetStationLogoFilePath(unsigned int u32PICode,tunerString& sLogoPath,tBool bRequireSmallLogo);
	  void vOnSensorStatus(double latitude, double longitude);
	  void vSetdpTunerDPLatitudeNdLongitudeOnShutdown();

private:

	 clConfigInterface*		m_poclConfigInterface;
	 tuner::common::radiodnsecc::clExtCountryCode*		m_poclExtCountryCode;

	 MapPICode_StationLogoFileName m_oPICode_StationLogoFileName;
	 double m_latitude;
	 double m_longitude;
	 bool bFileExists(tunerString  &sLogoPath);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	 tBool bRadioLogosExists;
	 tBool bRadioLogo_FOTA_Exists;
	 tBool bCheckLogoPaths;
	 tU8 m_u8DefaultLogoPathAvail;
	 void vUpdateLargeLogoPath(tunerString logopath , tunerString& sLogoPath);
	 void vUpdateSmallLogoPath(tunerString logopath , tunerString& sLogoPath);
	 void vCheckRadioLogosExist(tBool bCheckFOTALogo = FALSE);
#endif
};

#endif
