/************************************************************************
 * FILE:        clTmcTuner_stationLogo_map.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_stationLogo_map.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   15-Apr-2015         vnd4kor
				
 *************************************************************************/


#include "TunerApp/clTmcTuner_stationLogo_map.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"
#include "dirent.h"
#include "kdsconfig/clConfigInterface.h"
#include <iostream>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#include "dp_generic_if.h"
#else
   #include"diaglib_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_stationLogo_map.cpp.trc.h"
#endif

#define LOGO_PATH "/var/opt/bosch/static/tuner/fmlogo/"
#define RADIOLOGO_PATH "/var/opt/bosch/static/tuner/RadioLogo/"
#define RADIOLOGO_FOTA_PATH "/var/opt/bosch/persistent/swupdate/activations/ivi_rdl_application/"

#define RADIOLOGO_SIZE_LARGE "_L.png"
#define RADIOLOGO_SIZE_SMALL "_S.png"

#define RADIOLOGO_FOTA_PATH_LARGE 		RADIOLOGO_FOTA_PATH + logopath + RADIOLOGO_SIZE_LARGE
#define RADIOLOGO_STATIC_PATH_LARGE		RADIOLOGO_PATH + logopath + RADIOLOGO_SIZE_LARGE
#define RADIOLOGO_FOTA_PATH_SMALL 		RADIOLOGO_FOTA_PATH + logopath + RADIOLOGO_SIZE_SMALL
#define RADIOLOGO_STATIC_PATH_SMALL		RADIOLOGO_PATH + logopath + RADIOLOGO_SIZE_SMALL

#define RADIOLOGO_FOTA_DEF_PATH_LARGE		RADIOLOGO_FOTA_PATH + sLargeDefaultLogo
#define RADIOLOGO_STATIC_DEF_PATH_LARGE		RADIOLOGO_PATH + sLargeDefaultLogo
#define RADIOLOGO_FOTA_DEF_PATH_SMALL		RADIOLOGO_FOTA_PATH + sSmallDefaultLogo
#define RADIOLOGO_STATIC_DEF_PATH_SMALL		RADIOLOGO_PATH + sSmallDefaultLogo

#define RADIOLOGO_LARGE_FOTA_DEF 0X01
#define RADIOLOGO_LARGE_DEF 0X02
#define RADIOLOGO_SMALL_FOTA_DEF 0X04
#define RADIOLOGO_SMALL_DEF 0X08


/*#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
static const stRadioLogo aRadioLogo[] =
{
   #define Radio_Logo(u8CountryCode, u32PI, sRadioLogo)                  { u8CountryCode, u32PI, sRadioLogo},
   #include "RadioLogo.dat"
   #undef Radio_Logo
};
#endif*/

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_stationLogo_map::~clTmcTuner_stationLogo_map()
{
	m_poclConfigInterface = NULL;
	m_latitude = 0.0;
	m_longitude = 0.0;
	m_poclExtCountryCode = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_stationLogo_map::clTmcTuner_stationLogo_map(clConfigInterface* poclConfigInterface)
{
  
	#include "TunerApp/FMStationLogo.dat"
	m_poclConfigInterface = poclConfigInterface;
	m_latitude = 0.0;
	m_longitude = 0.0;
	#ifndef VARIANT_S_FTR_ENABLE_TMCTUNER_MOCK
	dp_tclTmcTunerDPLatitudeOnShutdown oLatitudeOnShutdown;
	oLatitudeOnShutdown.s32GetData(m_latitude);
	dp_tclTmcTunerDPLongitudeOnShutdown oLongitudeOnShutdown;
	oLongitudeOnShutdown.s32GetData(m_longitude);
	#endif
#ifndef GTEST_x86LINUX_BUILD
	m_poclExtCountryCode = tuner::common::radiodnsecc::clExtCountryCode::instance();
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	bRadioLogosExists = FALSE;
	bRadioLogo_FOTA_Exists = FALSE;
	m_u8DefaultLogoPathAvail = 0;
	bCheckLogoPaths = TRUE;
#endif

}


/**************************************************************************//**
*
******************************************************************************/
 void clTmcTuner_stationLogo_map::vGetStationLogoFilePath(unsigned int u32PICode,tunerString& sLogoPath,tBool bRequireSmallLogo)
 {
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	 MapPICode_StationLogoFileName::iterator it;

	 it = m_oPICode_StationLogoFileName.find(u32PICode);
	
	 if(it != m_oPICode_StationLogoFileName.end())
	 {
		 sLogoPath = LOGO_PATH;
		 sLogoPath += it->second.sPath;
		
		/** open file and then assign to midwstring*/
		if(!bFileExists(sLogoPath))
		{
			sLogoPath.clear();
		}
	 }	 
#else
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI

	if(m_poclConfigInterface == NULL || m_poclExtCountryCode == NULL)
	{
		return;
	}

	if(bCheckLogoPaths)
	{
		vCheckRadioLogosExist();
		vCheckRadioLogosExist(TRUE);
	}

	if(((bRadioLogosExists == TRUE) || (bRadioLogo_FOTA_Exists == TRUE)) && (!(m_poclConfigInterface->u32GetConfigData("HDSupported"))))
	{
		char PIcode[5];
		sprintf(PIcode,"%x",u32PICode);
		std::string logopath = (std::string)PIcode;
		for(unsigned int i=0 ; i<logopath.size() ; i++)
		{
			logopath.at(i) = (char)std::toupper(logopath.at(i));
		}
		ETG_TRACE_USR2((  " clTmcTuner_stationLogo_map::vGetStationLogoFilePath for Latitude : %f, Longitude : %f, PIcode : %x",(tFloat) m_latitude, (tFloat)m_longitude, PIcode[0]));
		
		string strEccCode = m_poclExtCountryCode->strGetExtendedCountryCode(m_latitude, m_longitude, PIcode[0]);
		ETG_TRACE_USR4(( "clTmcTuner_stationLogo_map: Extended Country Code - %s", strEccCode.c_str() ));

		if(strEccCode != "XXXX")
		{
			logopath = strEccCode + "_" + logopath;
			if(!bRequireSmallLogo) //for large image
			{
				vUpdateLargeLogoPath(logopath , sLogoPath);
			}
			else // for small image
			{
				vUpdateSmallLogoPath(logopath , sLogoPath);
			}
		}
	}
#endif
#endif
	ETG_TRACE_USR2((  " clTmcTuner_stationLogo_map::vGetStationLogoFilePath() : StationLogoPathLength = %d, bRequireSmallLogo=%d u32PICode =%d StationLogoPath = %s ",
					  sLogoPath.size(),bRequireSmallLogo,u32PICode,sLogoPath.c_str()));
}

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
/**************************************************************************
******************************************************************************/

void clTmcTuner_stationLogo_map::vUpdateLargeLogoPath(tunerString logopath, tunerString& sLogoPath)
{
	struct stat sb;
	string sLogo_Path = RADIOLOGO_FOTA_PATH_LARGE;
	if((bRadioLogo_FOTA_Exists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_FOTA_PATH_LARGE;
		return;
	}
	sLogo_Path = RADIOLOGO_STATIC_PATH_LARGE;
	if((bRadioLogosExists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_STATIC_PATH_LARGE;
		return;
	}
	if(m_u8DefaultLogoPathAvail & RADIOLOGO_LARGE_FOTA_DEF)
	{
		std::string sLargeDefaultLogo = "EE_FFFF_L.png";
		sLogoPath = RADIOLOGO_FOTA_DEF_PATH_LARGE;
	}
	else if(m_u8DefaultLogoPathAvail & RADIOLOGO_LARGE_DEF)
	{
		std::string sLargeDefaultLogo = "EE_FFFF_L.png";
		sLogoPath = RADIOLOGO_STATIC_DEF_PATH_LARGE;
	}
	else
	{
		// no logo update
	}
}


/**************************************************************************
******************************************************************************/

void clTmcTuner_stationLogo_map::vUpdateSmallLogoPath(tunerString logopath , tunerString& sLogoPath)
{
	struct stat sb;
	string sLogo_Path = RADIOLOGO_FOTA_PATH_SMALL;
	if((bRadioLogo_FOTA_Exists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_FOTA_PATH_SMALL;
		return;
	}
	sLogo_Path = RADIOLOGO_STATIC_PATH_SMALL;
	if((bRadioLogosExists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_STATIC_PATH_SMALL;
		return;
	}
	sLogo_Path = RADIOLOGO_FOTA_PATH_LARGE;
	if((bRadioLogo_FOTA_Exists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_FOTA_PATH_LARGE;
		return;
	}
	sLogo_Path = RADIOLOGO_STATIC_PATH_LARGE;
	if((bRadioLogosExists) && (stat(sLogo_Path.c_str() , &sb) ==0))
	{
		sLogoPath = RADIOLOGO_STATIC_PATH_LARGE;
		return;
	}
	if(m_u8DefaultLogoPathAvail & RADIOLOGO_SMALL_FOTA_DEF)
	{
		std::string sSmallDefaultLogo = "EE_FFFF_S.png";
		sLogoPath = RADIOLOGO_FOTA_DEF_PATH_SMALL;
	}
	else if(m_u8DefaultLogoPathAvail & RADIOLOGO_SMALL_DEF)
	{
		std::string sSmallDefaultLogo = "EE_FFFF_S.png";
		sLogoPath = RADIOLOGO_STATIC_DEF_PATH_SMALL;
	}
	else if(m_u8DefaultLogoPathAvail & RADIOLOGO_LARGE_FOTA_DEF)
	{
		std::string sLargeDefaultLogo = "EE_FFFF_L.png";
		sLogoPath = RADIOLOGO_FOTA_DEF_PATH_LARGE;
	}
	else if(m_u8DefaultLogoPathAvail & RADIOLOGO_LARGE_DEF)
	{
		std::string sLargeDefaultLogo = "EE_FFFF_L.png";
		sLogoPath = RADIOLOGO_STATIC_DEF_PATH_LARGE;
	}
	else
	{
		// no logo update
	}
}


/**************************************************************************//**
*
******************************************************************************/
 void clTmcTuner_stationLogo_map::vCheckRadioLogosExist(tBool bCheckFOTALogo)
 {
	DIR *RadioLogoDirectory;
	struct dirent *DiretoryDetails;
	tU8 u8count = 0;

	if(bCheckFOTALogo)
	{
		bCheckLogoPaths = FALSE;
		RadioLogoDirectory = opendir(RADIOLOGO_FOTA_PATH);
	}
	else
	{
		RadioLogoDirectory = opendir(RADIOLOGO_PATH);
	}

	if(!RadioLogoDirectory)
	{
		if(bCheckFOTALogo)
		{
			ETG_TRACE_USR2(("vCheckRadioLogosExist(), Radio Logos FOTA directory doesn't exist"));
		}
		else
		{
			ETG_TRACE_USR2(("vCheckRadioLogosExist(), Radio Logos static directory doesn't exist"));
		}
		tInt errsv = errno;
		ETG_TRACE_ERR(("vCheckRadioLogosExist failed with error:%d", errsv));
		ETG_TRACE_ERR(("vCheckRadioLogosExist failed and error msg : %s\n", strerror(errsv)));
		return;
	}
	while( (DiretoryDetails = readdir(RadioLogoDirectory)) != NULL)
	{
		if(++u8count > 2)
		{
			break;
		}
	}

	closedir(RadioLogoDirectory);

	if(u8count <= 2)
	{
		return;
	}
	else
	{
		if(bCheckFOTALogo)
			bRadioLogo_FOTA_Exists = TRUE;
		else
			bRadioLogosExists = TRUE;
	}
	
	ETG_TRACE_USR2((" vCheckRadioLogosExist(), bRadioLogosExists = %d, bRadioLogo_FOTA_Exists = %d",bRadioLogosExists,bRadioLogo_FOTA_Exists));

	struct stat sb;
	string sLargeDefaultLogo = "EE_FFFF_L.png";
	string sSmallDefaultLogo = "EE_FFFF_S.png";

	if(bRadioLogo_FOTA_Exists)
	{
		string sDefaultLogo = RADIOLOGO_FOTA_DEF_PATH_LARGE;
		if(stat(sDefaultLogo.c_str() , &sb) ==0)
		{
			m_u8DefaultLogoPathAvail |= RADIOLOGO_LARGE_FOTA_DEF;
		}
		sDefaultLogo = RADIOLOGO_FOTA_DEF_PATH_SMALL;
		if(stat(sDefaultLogo.c_str() , &sb) ==0)
		{
			m_u8DefaultLogoPathAvail |= RADIOLOGO_SMALL_FOTA_DEF;
		}
	}
	if(bRadioLogosExists)
	{
		string sDefaultLogo = RADIOLOGO_STATIC_DEF_PATH_LARGE;
		if(stat(sDefaultLogo.c_str() , &sb) ==0)
		{
			m_u8DefaultLogoPathAvail |= RADIOLOGO_LARGE_DEF;
		}
		sDefaultLogo = RADIOLOGO_STATIC_DEF_PATH_SMALL;
		if(stat(sDefaultLogo.c_str() , &sb) ==0)
		{
			m_u8DefaultLogoPathAvail |= RADIOLOGO_SMALL_DEF;
		}
	}

	ETG_TRACE_USR2(( " vCheckRadioLogosExist(), m_u8DefaultLogoPathAvail = %d",m_u8DefaultLogoPathAvail));

}

#endif

/**************************************************************************
******************************************************************************/

bool  clTmcTuner_stationLogo_map::bFileExists(tunerString  &sLogoPath)
{

	FILE * fp;
    fp = fopen(sLogoPath.c_str(), "r");

	if(fp == NULL)
	{
		ETG_TRACE_USR2((  "clTmcTuner_stationLogo_map::bFileExists() = False "));
		return false;
	}
	else
	{
		fclose(fp);
		return true;
	}
}


void clTmcTuner_stationLogo_map::vOnSensorStatus(double latitude, double longitude)
{
	ETG_TRACE_USR4((" clTmcTuner_stationLogo_map::vOnSensorStatus() : Latitude - %f, Longitude - %f", (tFloat)latitude, (tFloat)longitude));
	m_latitude = latitude;
	m_longitude = longitude;
}
void clTmcTuner_stationLogo_map::vSetdpTunerDPLatitudeNdLongitudeOnShutdown()
{
	dp_tclTmcTunerDPLatitudeOnShutdown oLatitudeOnShutdown;
	oLatitudeOnShutdown.vSetData(m_latitude);
	dp_tclTmcTunerDPLongitudeOnShutdown oLongitudeOnShutdown;
	oLongitudeOnShutdown.vSetData(m_longitude);
	ETG_TRACE_USR4(("vSetdpTunerDPLatitudeNdLongitudeOnShutdown() : Latitude - %f, Longitude - %f", (tFloat)m_latitude, (tFloat)m_longitude));
}
