/************************************************************************
 * FILE:        clTmcTuner_SetConfigSections.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_SetConfigSections.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   31-Jul-2015         vnd4kor
				
 *************************************************************************/

#ifndef clTmcTuner_SetConfigSections_h
#define clTmcTuner_SetConfigSections_h

#include "interface/clTmcTuner_TunerApp_ImpInterface.h"

#include "datatypes/tString.h"
#include "datatypes/tVector.h"


#include "TunerApp/ADRConfiguration/clTuningBehaviourConfiguration.h"
#include "TunerApp/ADRConfiguration/clATStationInfoConfiguration.h"
#include "TunerApp/ADRConfiguration/clTimerConfiguration.h"
#include "TunerApp/ADRConfiguration/clReceptionBehaviourConfiguration.h"
#include "TunerApp/ADRConfiguration/clBandSetupConfiguration.h"
#include "TunerApp/ADRConfiguration/clUserSettingConfiguration.h"
#include "TunerApp/ADRConfiguration/clAMFMParameterConfiguration.h"
#include "TunerApp/ADRConfiguration/clRDSParameterConfiguration.h"
#include "TunerApp/ADRConfiguration/clTestmodeAndAFListConfiguration.h"
#include "TunerApp/ADRConfiguration/clStationListConfiguration.h"
#include "TunerApp/ADRConfiguration/clHDParameterConfiguration.h"

#ifdef VARIANT_S_FTR_ENABLE_DRM
#include "TunerApp/ADRConfiguration/clDRMParameterConfiguration.h"
#endif

#include "TunerApp/ADRConfiguration/clPresetListConfiguration.h"
#include "TunerApp/ADRConfiguration/clHardwareRelatedConfiguration.h"
#include "TunerApp/ADRConfiguration/clEndOfConfiguration.h"

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
#include "TunerApp/ADRConfiguration/clAnnouncementConfiguration.h"
#endif


class tun_Config;
class clAars_SetConfigSections;
class tun_Utility;
class clConfigInterface;

class clTmcTuner_SetConfigSections: public clTmcTuner_TunerApp_ImpInterface, public clByteConverter
{
private:
	tunerString m_sVesrinInfo;
	unsigned short m_u16NumberOfBytes;
	clAars_SetConfigSections* m_poclAars_SetConfigSections;
	unsigned char m_u8Result;
	
	tunerVector<unsigned char> m_payload;
	
	tun_Config* m_potun_Config;
	tun_Utility* m_potun_Utility;
	clConfigInterface* m_poclConfigInterface;
	
	clTuningBehaviourConfiguration m_oTuningBehaviourConfiguration;
	clATStationInfoConfiguration m_oclATStationInfoConfiguration;
	clTimerConfiguration m_oTimerConfiguration;
	clReceptionBehaviourConfiguration m_oReceptionBehaviourConfiguration;
	clBandSetupConfiguration m_oBandSetupConfiguration;
	clUserSettingConfiguration m_oUserSettingConfiguration;
	clAMFMParameterConfiguration m_oAMFMParameterConfiguration;
	clRDSParameterConfiguration m_oRDSParameterConfiguration;
	clTestmodeAndAFListConfiguration m_oTestmodeAndAFListConfiguration;
	clStationListConfiguration m_oStationListConfiguration;
	clHDParameterConfiguration m_oHDParameterConfiguration;
#ifdef VARIANT_S_FTR_ENABLE_DRM
	clDRMParameterConfiguration m_oDRMParameterConfiguration;
#endif
	clPresetListConfiguration m_oPresetListConfiguration;
	clHardwareRelatedConfiguration m_oHardwareRelatedConfiguration;
	clEndOfConfiguration m_oEndOfConfiguration;
	
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	clAnnouncementConfiguration m_oAnnouncementConfiguration;
#endif

	bool bIsActionCalculateCRC(unsigned char& u8Action);
	bool bIsActionSetConfiguation(unsigned char& u8Action);
	void vSetVersionId();
	void vConstructConfigSections();
	void vBuildSetConfigSectionsPayload(tunerVector<unsigned char>& oConfigData);
	void vCalculateCRC(unsigned int* pu32Crc ,unsigned char* pu8HWCrc);
	void vInsertConfigSectionToPayload(clBaseConfigSection* pBaseConfigSection);
	void vTraceConfigSection(clBaseConfigSection* pConfigSection);
	void vCall(void (clTmcTuner_SetConfigSections::*pfunctionPointer)(clBaseConfigSection* ));
	bool bIsConfigurationRequired(enConfigSectionID enSectionID);
public:
	clTmcTuner_SetConfigSections(clAars_SetConfigSections* poclAars_SetConfigSections, tun_Config* potun_Config, tun_Utility* potun_Utility, clConfigInterface* poclConfigInterface);
	virtual ~clTmcTuner_SetConfigSections();
	unsigned short u16GetNumberOfBytes();
	void vSendSetConfigSections( unsigned char u8Action, unsigned int* pu32Crc,unsigned char* pu8HWCrc);
	virtual void vOnNewSetConfigSectionsResult(unsigned char u8Result);
};

#endif
