/************************************************************************
 * FILE:        clTmcTuner_AdditionalVersionInfo_Update.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_AdditionalVersionInfo_Update.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "TunerApp/clTmcTuner_AdditionalVersionInfo_Update.h"
#include "string.h"
#include "tun_main.h"
#include "tun_Utility.h"


#define ADR_SW_CUSTOMER_ADDITIONALVERSIONINFO_LENGTH 32
#define ADR_API_VERSION_3_30 3.30

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clTmcTuner_AdditionalVersionInfo_Update.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_AdditionalVersionInfo_Update::~clTmcTuner_AdditionalVersionInfo_Update()
{
	m_potun_main = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_AdditionalVersionInfo_Update::clTmcTuner_AdditionalVersionInfo_Update(tuner_tclApp* potun_main):
m_f32ADRVersion(0),	
m_potun_main(potun_main)
{
	
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_AdditionalVersionInfo_Update::vWriteToDP(tString sSwCustomerVersion)
{
   ETG_TRACE_USR2(( "clTmcTuner_AdditionalVersionInfo_Update::vWriteToDP() , CustomerVersion changed "));
   m_oAdrSwVersionCustomer.vSetData( sSwCustomerVersion, ADR_SW_CUSTOMER_ADDITIONALVERSIONINFO_LENGTH );
}


bool clTmcTuner_AdditionalVersionInfo_Update::bIsAdditionalVersionInfoChanged(tString sSwCustomerVersion)
{
	char sCustomerVersion[ADR_SW_CUSTOMER_ADDITIONALVERSIONINFO_LENGTH] = {0};

	m_oAdrSwVersionCustomer.u8GetData(sCustomerVersion , ADR_SW_CUSTOMER_ADDITIONALVERSIONINFO_LENGTH);
	ETG_TRACE_USR2(( "clTmcTuner_AdditionalVersionInfo_Update::bIsAdditionalVersionInfoChanged() , DP read :: sCustomerVersion : %s ", sCustomerVersion));

	if(strcmp(sSwCustomerVersion , sCustomerVersion))
	{
		return true;
	}

	return false;
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_AdditionalVersionInfo_Update::vOnNewAdditionalVersionInfoStatus(unsigned char u8FirstVersionDigit, unsigned char u8SecondVersionDigit, unsigned char u8ThirdVersionDigit)
{
	vCalculateADRVersion(u8FirstVersionDigit, u8SecondVersionDigit, u8ThirdVersionDigit);
	ETG_TRACE_COMP(( " clTmcTuner_AdditionalVersionInfo_Update::vOnNewAdditionalVersionInfoStatus() Version : %1.2f",m_f32ADRVersion ));
	
/*#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	if(!bIsADRVersionCompatible())
	{
		vHandleIncompatibleAdrVersion();
	}
#endif*/
			
	tChar sVersionNo[ADR_SW_CUSTOMER_ADDITIONALVERSIONINFO_LENGTH];
	OSAL_s32PrintFormat(sVersionNo, "%1.2f", m_f32ADRVersion);
	ETG_TRACE_COMP(( " clTmcTuner_AdditionalVersionInfo_Update::vOnNewAdditionalVersionInfoStatus() ->\n"
	                       " sVersionNo                  : %32s\n", sVersionNo));

	tString sSwCustomerVersion = sVersionNo;

	if(bIsAdditionalVersionInfoChanged(sSwCustomerVersion))
	{
		vWriteToDP(sSwCustomerVersion);
	}
}

tVoid clTmcTuner_AdditionalVersionInfo_Update::vCalculateADRVersion(unsigned char u8FirstVersionDigit, unsigned char u8SecondVersionDigit, unsigned char u8ThirdVersionDigit)
{
	m_f32ADRVersion = 0;
	
	m_f32ADRVersion =(float) (m_f32ADRVersion + u8FirstVersionDigit);
	m_f32ADRVersion =(float) (m_f32ADRVersion + (float)u8SecondVersionDigit * 0.1);
	m_f32ADRVersion =(float)( m_f32ADRVersion + (float)u8ThirdVersionDigit * 0.01);
}

/*bool clTmcTuner_AdditionalVersionInfo_Update::bIsADRVersionCompatible()
{
	return m_f32ADRVersion >= ADR_API_VERSION_3_30 ? false:true ;
}*/

/**************************************************************************//**
*
******************************************************************************/

/*tVoid clTmcTuner_AdditionalVersionInfo_Update::vHandleIncompatibleAdrVersion()
{
	ETG_TRACE_COMP(( "clTmcTuner_AdditionalVersionInfo_Update::vHandleIncompatibleAdrVersion() ->\n"
		 "***********************************************\n"
		 "=>		ADR VERSION NOT COMPATIBLE			*\n"
		 "=>			 REQUIRED API 3.30				*\n"
		 "=>			 RECEIVED API %1.2f				*\n"
		 "=>			TUNER WILL SHUTDOWN				*\n"
		 "***********************************************\n"
		 ,m_f32ADRVersion
		 ));
	 m_potun_main->vTunerShutDownProcess();
}*/

float clTmcTuner_AdditionalVersionInfo_Update::fGetAdrVersionInfo()
{
	return m_f32ADRVersion;
}




