/************************************************************************
 * FILE:        HandleTTFISCommands.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of HandleTTFISCommands.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
    Mar 14, 2016                     pmn3kor
				
 *************************************************************************/



#ifndef COMPONENTS_FC_TMCTUNER_AMFMTUNER_HANDLETTFISCOMMANDS_H_
#define COMPONENTS_FC_TMCTUNER_AMFMTUNER_HANDLETTFISCOMMANDS_H_

class tun_MsgFromHMI;
class tun_MsgToADR;
class tun_Config;
class tun_ActualData;
class tuner_tclApp;
class clTmcTuner_stationLogo_map;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
class clAars_CM_Commit;
#endif
#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
class tun_INCComm;
#endif

class HandleTTFISCommands
{
public:
   HandleTTFISCommands( );
   virtual ~HandleTTFISCommands();

   /*Registers trace channel to send commands from TTFis*/
   void vRegisterInTraceCmdService ();
   /*De-registers trace channel used to send commands from TTFis*/
   void vUnregisterInTraceCmdService()throw();
   /*React on TTFis commands*/
   static void vTraceTunerChannelMgr (unsigned char* puchData);
   /* Needed for access from static functions */
   static HandleTTFISCommands* _poTTFISHandler;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  void vSet_tun_AarsCommit(clAars_CM_Commit* poclAars_CM_Commit);
#endif
  /**/
  void vSet_tun_MsgFromHMI_Ptr(tun_MsgFromHMI* potun_MsgFromHMI);
  void vSet_tun_MsgToADR_Ptr(tun_MsgToADR* potun_MsgToADR);
  void vSet_tun_Config_Ptr(tun_Config* potun_Config);
  void vSet_tun_ActualData_Ptr(tun_ActualData* potun_ActualData);
  void vSet_tun_Main_Ptr(tuner_tclApp* potun_main);
  void vSet_StationLogoMapPtr(clTmcTuner_stationLogo_map* poclTmcTuner_stationLogo_map);

private:
   OSAL_tIODescriptor   _fdTrace;  /* Variable required for incoming trace */
   tun_MsgFromHMI* m_potun_MsgFromHMI;
   tun_MsgToADR* m_potun_MsgToADR;
   tun_Config* m_potun_Config;
   tun_ActualData* m_potun_ActualData;
   tuner_tclApp* m_potun_main;
   clTmcTuner_stationLogo_map* m_poclTmcTuner_stationLogo_map;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   clAars_CM_Commit* m_poclAars_CM_Commit;
#endif

   /*Handler for FID_TUN_S_DRM_TESTMODE MethodStart*/
   void vDRMTestModeMethodHandler(unsigned char* puchData);
   /*Handle TUN_MSG_TO_ADR traces*/
   void vHandle_TUN_MSG_TO_ADR_Trace(unsigned char* puchData);
   /*handler for TUN_CHECK_CONTAINER*/
   void vHandleContainerCheck(unsigned char* puchData);
   /*handler for FID_TUN_S_ATSEEK_WITH_TUNERHEADER*/
   void vHandleSeekMethod(unsigned char* puchData);
   
   /*handler for FID_TUN_S_PRESET_HANDLING*/
   void vHandlePresetHandlingMethod(unsigned char* puchData);
   /*handler for FID_TUN_S_ATFREQUENCY*/
   void vHandleAtfrequencyMethod(unsigned char* puchData);
   /*handler for FID_TUN_S_CHANGE_LSM*/
   void vHandleChangeLSMMethod(unsigned char* puchData);
   /*handler for FID_TUN_S_GET_STATIC_LIST*/
   void vHandleGetStaticListMethod(unsigned char* puchData); 
   /*handler for FID_TUN_S_ANNOUNCEMENT_ESCAPE*/
   void vHandleAnnouncementEscapeMethod(unsigned char* puchData);
   /*handler for FID_TUN_S_ANNOUNCEMENT_SWITCH*/
   void vHandleAnnouncementSwitchMethod(unsigned char* puchData);
   /*Handler for FID_TUN_S_SET_HICUT*/
   void vHandleHicutMethod(unsigned char* puchData);
   /*Handler for FID_TUN_S_SET_SHARXLEVEL*/
   void vHandleSharxMethod(unsigned char* puchData);
   /*handler for FID_TUN_S_SEL_LIST_ELEM*/
   void vHandleSelecetListElement(unsigned char* puchData);
   /*handler for FID_TUN_S_SET_ENGG_PARAMETER*/
   void vHandleSetEnggParameterMethod(unsigned char* puchData);
   /*handler for FID_TUN_G_SET_ENGG_PARAMETER*/
   void vHandleSetEnggParameterGet(unsigned char* puchData);
   /*handler for FID_TUN_S_SET_ACTIVE_PRESETLIST*/
   void vHandleSetActivePresetMethod(unsigned char* puchData);
   /*handler for FID_TUN_S_VOLUME_INFO*/
   /*handler for FID_TUN_S_SPEED_INFO*/
   void vHandleSpeedInfoMethod(unsigned char* puchData);
   /*handler for FID_TUN_G_AVAILABLE_BAND_RANGE*/
   void vHandleAvailBandRangeGet();
   /*handler for FID_TUN_G_SET_DDA*/
   void vHandleDDAGet();
   /*handler for FID_TUN_G_SET_AF*/
   void vHandleAFGet();
   /*handler for FID_TUN_S_CONFIGLIST_UPDATE*/
   void vHandleUpdateConfigList(unsigned char* puchData);
   /*handler for FID_TUN_S_DEFAULT_SETTING*/
  void vHandleDefaultSettingsMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_SET_DEMODULATION_SWITCH*/
  void vHandleDemodulationSwitchMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_SELECT_HD_AUDIOPRGM*/
  void vHandleHDAudioPrgmMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_SELECT_DRM_AUDIOPRGM*/
  void vHandleDRMAudioServiceDirectMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_SET_TESTMODE*/
  void vHandleEnhancedTestmodeMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_SET_PI*/
  void vHandleSetPIMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_SEL_HD_AUDIOPRGMDIRECT*/
  void vHandleSelHDAudioPrgmDirectMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_DIRECT_FREQUENCY*/
  void vHandleDirectFrequencyMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_SET_AUDIO_SPLIT_MODE*/
  void vHandleSetHDSectionParameterMethod(unsigned char* puchData);
  /*handler for FID_TUN_S_HD_RESET_TRANSITIONCOUNT*/
  void vHandleHDResetTransitionCount();
  /*handler for FID_TUN_S_GET_CONFIG_LIST*/
  void vHandleGetConfigListMethod(unsigned char* puchData);
  /*handler for FID_TUN_G_CALIBRATION_DATA*/
  void vHandleCalibrationDataGet();
  /*handler for communication error*/
  void vHandleADRCommunicationErr(unsigned char* puchData);
  /*handler for FID_TUN_S_JAPAN_SET_AREA*/
  void vHandleJapanSetArea(unsigned char* puchData);
  /*handler for FID_TUN_S_JAPAN_CHANGE_STATION_NAME*/
  void vHandleJapanStationNameChange(unsigned char* puchData);
  /*handler for FID_TUN_S_USER_PROFILE_UPDATE*/
  void vHandleUserProfileUpdate(unsigned char* puchData);
  /*handler for FID_TUN_S_LANGUAGE_SETTING*/
  void vHandleLanguageSetting(unsigned char* puchData);
  /*handler for FID_TUN_S_DRM_RESET_MUTECOUNTER*/
  void vHandleDRMResetMuteCounter(unsigned char* puchData);
    /*handler for Sensor Position property*/
   void vHandleSensorPositionProperty(unsigned char* puchData);
  /*handler for FID_TUN_S_PRESET_STORAGE_PS_FREEZE*/
  void vHandlePresetStoragePSFreezeMethod(unsigned char* puchData);
  /*handler for FID_TUN_G_JAPAN_STATION_NAME_LIST Get*/
  void vHandleJapanStationNameList(unsigned char* puchData);
  /*handler for FID_TUN_S_JAPAN_SELECT_STATION_NAME */
  void vHandleJapanSelectStationName(unsigned char* puchData);

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  /*Handler for CM_Commit message*/
  void vHandleCommitMethod();
#endif

};


#endif /* COMPONENTS_FC_TMCTUNER_AMFMTUNER_HANDLETTFISCOMMANDS_H_ */
