/************************************************************************
 * FILE:        clJapanStationName.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clJapanStationName.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   Mar 22, 2016       pmn3kor
				
 *************************************************************************/



#ifndef COMPONENTS_FC_TMCTUNER_TUNERAPP_STATIONNAMEJAPAN_CLJAPANSTATIONNAME_H_
#define COMPONENTS_FC_TMCTUNER_TUNERAPP_STATIONNAMEJAPAN_CLJAPANSTATIONNAME_H_

//include database path here
#include "datatypes/tString.h"
#include "sqlite3.h"
#include "datatypes/tVector.h"
#include "tun_defines.h"
#include <mutex>

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#include "dp_generic_if.h"
#else
   #include"diaglib_if.h"
#endif

class clJapanStationName
{
public:
   /*constructor*/
   clJapanStationName();
   /*destructore*/
   ~clJapanStationName();
   /*open database*/
   void vOpenDatabase();
   /*close database*/
   void vCloseDatabase();
   /*execute the requested query and return result*/
   void vExecuteQuery(tunerString sQuery, sqlite3* tempobj);
   /*execute the requested query and callback the mentioned function*/
   void vExecuteQueryWithCallbackFunction(tunerString sQuery);
   /*call back function for sqlite_exec function*/
   static int Callback_SQLiteQuery(void *data, int argc, char **argv, char **column);
   /*get the count of Japan stations available at given freq and given area code */
   unsigned char GetJapanStationCount(unsigned char u8AreaCode, unsigned int u32Freq);
   /*change to station name to next/prev available station name*/
   void vSendStationName(unsigned char u8ChangeStationMode);
   /*check if requested station name index is available in map*/
   bool bIsStationNamePresent(unsigned short u16Position);
   /*select station name based on the position given by client*/
   bool bSelectStationName(unsigned short u16Position);
   /*Print all the available stations for given frequency and area code*/
   void vPrintJapanStationsForGivenFrequency();
   /*Get the station name for given frequency and area code*/
   const char* sGetStationNameFromDB();
   /*Get station name based on the language selected Japanese/english*/
   const char* pchUpdateStationNameFromDB();
   /*Get the station name for given frequency and area code*/
    const char* sGetStationNameForUpdList(unsigned int u32Frequency, unsigned char u8AreaCode);
   /*update the user select value to database from map data*/
   void vUpdateMapDataToDatabase(unsigned int u8Index, bool bUserSelect);
   /*copy database from source path to destination path*/
   void vCopyDatabase(const char* poSrcFileName, const char* poDestFileName);
   /*check if the file already exists in given path*/
   bool bFileExists(const char* path);
   /*differential copy database from RAM memory (/tmp) to flash memory (/var/opt/bosch/dynamic/tuner)*/
   void vDifferentialCopyDatabaseFromRAMToFlash();
   /*return the previously calculated station count*/
   unsigned char u8GetStationCount();
   /*check if station name change type is TUN_UP*/
   bool bIsChangeStationNameUpward(unsigned char u8NewVal);
   /*check if station name change type is TUN_DOWN*/
   bool bIsChangeStationNameDownward(unsigned char u8NewVal);
   /*version comparision of database. Check if new database version available in static memory*/
   void vCompareDatabaseVersion();
   /*delete the database present in dynamic folder of target*/
   void vHandleDynamicDatabase();
   /*get dynamic database version*/
   signed int s32GetDatabaseVersion(sqlite3* tempobj);
   /*set new database version to dynamic database*/
   void vSetDatabaseVersion(sqlite3* tempobj);
   /*check if stationname is valid utf8 character*/
   bool bCheckIfValidUTF8(const char* utf8String);
   /*differential copy database from static folder to dynamic folder*/
   bool bDifferentialCopyDatabaseFromStaticToDynamic();
   /* check if target language is Japanese. Value got from HMI */
   bool bCheckIfJapaneseLanguage();
   /*new language selected from FID_TUN_S_LANGUAGE_SETTING*/
   void vSetSelectedLanguage(unsigned char u8NewLang);
   /*change to default user select value available in flash database version(static folder) */
   void vChangeToDefaultJapanDatabase();
   /*differential copy database from dynamic folder to /tmp folder*/
   bool bDifferentialCopyDatabaseFromDynamicToRAM();
   /*copy selective Japan station name details from map to vector. Also send the index of selected station name*/
   unsigned short u16GetJpnStnNameListData(tunerVector<TunerJapanStationName> &oJpnStnNameList);

   sqlite3 *m_databaseobj;

private:
   unsigned int u32SQLiteCommandReturnValue;
   unsigned char m_LanguageSetting;
   char *ErrMsg;
   /*lock the map during read and write cycle.
    * if one more lock is getting introduced, make sure to check all conditions properly for m_JapanMapLock. deadlock should not happen*/
   //pthread_mutex_t m_JapanMapLock;
   std::mutex m_JapanMapLock;
   /*temporary string for sending station names.*/
   tunerString sTempStationNameString;
   /*temporary string2 for sending station names for list update. avoided reuse of sTempStationNameString to prevent unwanted overriding of data*/
   tunerString sTemp2StationNameString;
   /*total entries in the map for given area code and frequency*/
   unsigned char u8JapanStationCount;
};



#endif /* COMPONENTS_FC_TMCTUNER_TUNERAPP_STATIONNAMEJAPAN_CLJAPANSTATIONNAME_H_ */
