/************************************************************************
 * FILE:        tunerMute.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of tunerMute.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef tunerMute_h
#define tunerMute_h

#include "../MuteHandling/muteDatatype.h"

struct stTunerMuteActive
{
	Mute::MuteHandling::enMuteTuningAction muteTuningAction;
	unsigned char IsEnabled;
	unsigned char IsInterrupt;
	short priority;
	unsigned short ADRFktId;
};

bool bIsMuteActionEnabled(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
bool bIsMuteActionInterruptable(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
short getMuteActionPriority(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
Mute::MuteHandling::enMuteTuningAction getMuteActionIDForADRFktId(unsigned short u16FktId);
bool bIsMuteFunction(unsigned short u16FktId);

#endif
