/************************************************************************
 * FILE:        clMuteControl.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clMuteControl.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/






#include "clMuteControl.h"
#include "../clMuteRequest.h"
#include "common/tuner_trace.h"

using namespace Mute;
using namespace Mute::MuteHandling;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MUTE_HANDLER
#include "trcGenProj/Header/clMuteControl.cpp.trc.h"
#endif

clMuteControl* clMuteControl::m_poMuteControl = NULL;

clMuteControl::~clMuteControl() {

}

clMuteControl* clMuteControl::instance()
{
	if (m_poMuteControl == 0)
	{
		m_poMuteControl = new clMuteControl();
	}
	return m_poMuteControl;
}

void clMuteControl::vSetMuteTunerImpl(Mute::MuteHandling::enMuteTuningAction muteAction, Mute::clMuteInterface* poImpl)
{
	TunerMuteMap[muteAction] = poImpl;
}

void clMuteControl::vClearStates()
{
	if (TunerMuteMap.find(oCurrentMuteAction.MuteTuningActionType) != TunerMuteMap.end())
	{
		TunerMuteMap[oCurrentMuteAction.MuteTuningActionType]->vClearStoredRequest();
		oCurrentMuteAction.vClearMuteActionState();
	}
	if (TunerMuteMap.find(oNextMuteAction.MuteTuningActionType) != TunerMuteMap.end())
	{
		TunerMuteMap[oNextMuteAction.MuteTuningActionType]->vClearStoredRequest();
		oNextMuteAction.vClearMuteActionState();
	}
}

void clMuteControl::vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction)
{
	ETG_TRACE_USR4(("clMuteControl::vOnNewMuteTunerAction() muteTuningAction = %d, muteAction = %d",
		ETG_ENUM(MUTE_TUNINGACTION, (tU8)muteTuningAction), ETG_ENUM(MUTE_ACTION, (tU8)bIsMuteActionEnabled(muteTuningAction))));
	if(bIsMuteActionEnabled(muteTuningAction) == Mute::MuteHandling::ENABLED)
	{
		vProcessMuteTunerAction(muteTuningAction);
		/* do not send Mute request, if tuner is already in Mute state */
		(bIsTunerInMuteState() == true) ? vProcessTunerAction(oCurrentMuteAction.MuteTuningActionType) : vOnNewMuteState(Mute::MuteHandling::MUTE) ;	
	}
	else
	{
		vProcessTunerAction(muteTuningAction);
		vSendMethodResult(muteTuningAction);
	}
}

bool clMuteControl::bIsTunerInMuteState()
{
	if((oCurrentMuteAction.MuteState == Mute::MuteHandling::MUTE) && (bIsMuteRequestPending() == false))
	{
		return true;
	}
	return false;
}

void clMuteControl::vSendMethodResult(Mute::MuteHandling::enMuteTuningAction muteTuningAction)
{
	if (TunerMuteMap.find(muteTuningAction) != TunerMuteMap.end())
	{
		TunerMuteMap[muteTuningAction]->vOnDemuteSendMethodResult();
	}
}

void clMuteControl::vProcessTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction)
{
	ETG_TRACE_USR4(("clMuteControl::vOnNewMuteTunerAction() oCurrentMuteAction = %d", ETG_ENUM(MUTE_TUNINGACTION, (tU8)oCurrentMuteAction.MuteTuningActionType)));
	if (TunerMuteMap.find(muteTuningAction) != TunerMuteMap.end())
	{
		TunerMuteMap[muteTuningAction]->vProcessTunerAction();
	}
}

void clMuteControl::vProcessMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction)
{
	bool bCurrentActionInterrupt = (bIsMuteActionInterruptable(oCurrentMuteAction.MuteTuningActionType) == Mute::MuteHandling::INTERRUPT);
	ETG_TRACE_USR4(("clMuteControl::vProcessMuteTunerAction() Requested Mute Action = %d",  ETG_ENUM(MUTE_TUNINGACTION, (tU8)muteTuningAction)));
    ETG_TRACE_USR4(("clMuteControl::vProcessMuteTunerAction() Current Mute Action = %d",  ETG_ENUM(MUTE_TUNINGACTION, (tU8)oCurrentMuteAction.MuteTuningActionType)));
    ETG_TRACE_USR4(("clMuteControl::vProcessMuteTunerAction() Next Mute Action = %d",  ETG_ENUM(MUTE_TUNINGACTION, (tU8)oNextMuteAction.MuteTuningActionType)));
	/*	if current action is having interrupt flag and requested is having non-interrupt flag, put requested action in queue
		if current action is having interrupt flag and requested is also having interrupt flag, put requested action in queue
		if current action is having non-interrupt flag and requested is having interrupt flag, abort the current action (overwrite requested action value as current action)
		if current action is having non-interrupt flag and requested is also having non-interrupt flag, put requested action in queue
		*/
    if(oCurrentMuteAction.MuteTuningActionType == Mute::MuteHandling::NONE)
	{
		ETG_TRACE_USR4(("clMuteControl::vProcessMuteTunerAction() muteTuningAction = %d",  ETG_ENUM(MUTE_TUNINGACTION, (tU8)muteTuningAction)));
		oCurrentMuteAction.MuteTuningActionType = muteTuningAction;
	}
	else if(bIsMuteRequestPending())
	{
		/*If previous mute request is pending (not received response from tunermaster), override current action with the latest request received.
		  And clear the stored request for previous tuning action */
		ETG_TRACE_USR4(("clMuteControl::vOnNewMuteState() Mute Request State = %d", ETG_ENUM(MUTE_REQUEST_STATE, (tU8)oCurrentMuteAction.MuteRequestState)));
		if(muteTuningAction != oCurrentMuteAction.MuteTuningActionType)
		{
			TunerMuteMap[oCurrentMuteAction.MuteTuningActionType]->vClearStoredRequest();
			oCurrentMuteAction.MuteTuningActionType = muteTuningAction;
		}
	}
	else
	{
		(bCurrentActionInterrupt == true && (muteTuningAction != oCurrentMuteAction.MuteTuningActionType))?(oNextMuteAction.MuteTuningActionType = muteTuningAction):(oCurrentMuteAction.MuteTuningActionType = muteTuningAction);
	}
}

void clMuteControl::vOnNewMuteState(Mute::MuteHandling::enMuteState muteState)
{
    bool bInterrupt = false;
    ETG_TRACE_USR4(("clMuteControl::vOnNewMuteState() muteState = %d", ETG_ENUM(MUTE_STATE, (tU8)muteState)));
    if(muteState == Mute::MuteHandling::DEMUTE)
    {
        if(oCurrentMuteAction.MuteTuningActionType == Mute::MuteHandling::NONE)
        {
            return;
        }

        TunerMuteMap[oCurrentMuteAction.MuteTuningActionType]->vOnTunerStateIdle();

        if(bIsTuningActionPending())
        {
            vHandleNextTuningAction();
        }
        else
        {
            vCompleteCurrentTuningAction(muteState, bInterrupt);
        }
    }
    else
    {
        oCurrentMuteAction.MuteState = muteState;
        bInterrupt = ((bIsMuteActionInterruptable(oCurrentMuteAction.MuteTuningActionType) == Mute::MuteHandling::INTERRUPT)? true : false) ;
        vSendMuteDemuteRequest(muteState, bInterrupt);
    }
}

bool clMuteControl::bIsMuteRequestPending()
{
	return (oCurrentMuteAction.bIsMuteRequestPending() == true) ? true : false ;
}


void clMuteControl::vSendMuteDemuteRequest(Mute::MuteHandling::enMuteState muteState, bool bInterrupt)
{
	ETG_TRACE_USR4(("clMuteControl::vSendMuteDemuteRequest() muteState = %d, bInterrupt = %d", ETG_ENUM(MUTE_STATE, (tU8)muteState), ETG_ENUM(MUTE_INTERRUPT, (tU8)bInterrupt)));
	oCurrentMuteAction.MuteRequestState = Mute::MuteHandling::PENDING;
	ETG_TRACE_USR4(("clMuteControl::vSendMuteDemuteRequest() tuning action = %d, Mute Request State = %d", ETG_ENUM(MUTE_TUNINGACTION, (tU8)oCurrentMuteAction.MuteTuningActionType), 
		ETG_ENUM(MUTE_REQUEST_STATE, (tU8)oCurrentMuteAction.MuteRequestState)));
	Mute::clMuteRequest muteRequest;
	muteRequest.vSendMuteDemuteRequestStatus(muteState, bInterrupt);
}

Mute::MuteHandling::enMuteTuningAction clMuteControl::getCurrentMuteTuningAction()
{
	return oCurrentMuteAction.MuteTuningActionType;
}

Mute::MuteHandling::enMuteTuningAction clMuteControl::getNextMuteTuningAction()
{
	return oNextMuteAction.MuteTuningActionType;
}

void clMuteControl::vOnTuningActionError(Mute::MuteHandling::enMuteTuningAction enErrorAction)
{
    bool bInterrupt = false;
     if(bIsCurrentAction(enErrorAction))
    {
        if(bIsTuningActionPending())
        {
            vHandleNextTuningAction();
        }
        else
        {
            bInterrupt = ((bIsMuteActionInterruptable(enErrorAction) == Mute::MuteHandling::INTERRUPT)? true : false) ;
            vCompleteCurrentTuningAction(Mute::MuteHandling::DEMUTE, bInterrupt);
        }
    }
}

void clMuteControl::vHandleNextTuningAction()
{
    oCurrentMuteAction.MuteTuningActionType = oNextMuteAction.MuteTuningActionType;
    oNextMuteAction.MuteTuningActionType = Mute::MuteHandling::NONE;
    vProcessTunerAction(oCurrentMuteAction.MuteTuningActionType);
}

void clMuteControl::vCompleteCurrentTuningAction(Mute::MuteHandling::enMuteState muteState, bool bInterrupt)
{
    oCurrentMuteAction.MuteTuningActionType = Mute::MuteHandling::NONE;
    oCurrentMuteAction.MuteState = MUTESTATE_UNKNOWN;
    vSendMuteDemuteRequest(muteState, bInterrupt);
}

bool clMuteControl::bIsTuningActionPending()
{
    return oNextMuteAction.MuteTuningActionType != Mute::MuteHandling::NONE ? true : false;
}

bool clMuteControl::bIsCurrentAction(Mute::MuteHandling::enMuteTuningAction enErrorAction)
{
    return enErrorAction == oCurrentMuteAction.MuteTuningActionType ? true : false;
}

void clMuteControl::vOnAudioMuteRequest()
{
	oCurrentMuteAction.MuteRequestState = Mute::MuteHandling::ACKNOWLEDGED;
	ETG_TRACE_USR4(("clMuteControl::vOnAudioMuteRequest() Mute Request State = %d", ETG_ENUM(MUTE_REQUEST_STATE, (tU8)oCurrentMuteAction.MuteRequestState)));
}
