/************************************************************************
 * FILE:          clTimerConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTimerConfiguration.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   4-Aug-2015			vnd4kor
				
 *************************************************************************/

#ifndef clTimerConfiguration_h
#define clTimerConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;

class clTimerConfiguration : public clBaseConfigSection 
{

private:
	unsigned char m_u8TScanRadio;
	unsigned char m_u8TInhibitListSortAfterSkip;
	unsigned char m_u8TDelayTPStationSelectAfterVolZero;
	unsigned char m_u8TDelayNoTPStationFound;
	unsigned char m_u8TNonRDSDetect;
	unsigned char m_u8PSDeleteAfterRDSLost;
	unsigned char m_u8TWrongPIAccept;
	unsigned char m_u8TScrollPSDetect;
	unsigned char m_u8TDelayTPStationSelectAfterRDSLost;
	unsigned char m_u8TTAEndAfterRDSLost;
	unsigned char m_u8TAMMinTuneTime;
	unsigned char m_u8TCursorDelayAfterStationSelect;
	unsigned char m_u8TAFInhibitAfterManualTune;
	unsigned char m_u8TAcceptPIAfterRecall;
	unsigned char m_u8TPTYHold;
			
public:
	/**
	 * Constructor
	 */
	clTimerConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clTimerConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* poclConfigInterface);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();
};

#endif