/************************************************************************
 * FILE:           clTestmodeAndAFListConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTestmodeAndAFListConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/


#include "TunerApp/ADRConfiguration/clTestmodeAndAFListConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clTestmodeAndAFListConfiguration.cpp.trc.h"
#endif


clTestmodeAndAFListConfiguration::clTestmodeAndAFListConfiguration() :clBaseConfigSection(enTestmodeAndAFListConfiguration)
,m_u8UpdateCycleForTestmodeData(0)
,m_u8UpdateCycleForAFList(0)
,m_u8AFListReleaseBehaviour(0)
{
}

clTestmodeAndAFListConfiguration::~clTestmodeAndAFListConfiguration()
{
}

void clTestmodeAndAFListConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8UpdateCycleForTestmodeData);
	m_payload.push_back(m_u8UpdateCycleForAFList);
	m_payload.push_back(m_u8AFListReleaseBehaviour);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clTestmodeAndAFListConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u8UpdateCycleForTestmodeData = (tU8)poclConfigInterface->u32GetConfigData("TestmodeUpdateCycle");
	m_u8UpdateCycleForAFList = (tU8)poclConfigInterface->u32GetConfigData("AFListUpdateCycle");
	m_u8AFListReleaseBehaviour = (tU8)poclConfigInterface->u32GetConfigData("AFlistReleaseBehavior");
}

tunerVector<unsigned char> clTestmodeAndAFListConfiguration::oGetPayload()
{
	return m_payload;
}

short clTestmodeAndAFListConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clTestmodeAndAFListConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clTestmodeAndAFListConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clTestmodeAndAFListConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clTestmodeAndAFListConfiguration::vTrace() part 2 -> \n m_u8UpdateCycleForTestmodeData = %d s \n m_u8UpdateCycleForAFList = %d s \n "\
		"m_u8AFListReleaseBehaviour = 0x%02X ",\
		m_u8UpdateCycleForTestmodeData,m_u8UpdateCycleForAFList,m_u8AFListReleaseBehaviour));
}