/************************************************************************
 * FILE:          clStationListConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clStationListConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/


#include "TunerApp/ADRConfiguration/clStationListConfiguration.h"

#include "tun_Config.h"

#include "kdsconfig/clConfigInterface.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clStationListConfiguration.cpp.trc.h"
#endif


clStationListConfiguration::clStationListConfiguration() :clBaseConfigSection(enStationListConfiguration)
,m_u8MaximumNumberOfStationsInList(0)
{
}

clStationListConfiguration::~clStationListConfiguration()
{
}

void clStationListConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8MaximumNumberOfStationsInList);

	m_u16NumberOfBytesInSection = (unsigned short) m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clStationListConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL || poclConfigInterface == NULL)
	{
		return;
	}

	m_u8MaximumNumberOfStationsInList = (unsigned char)poclConfigInterface->u32GetConfigData("MaxNumberofStationsInStnList");
}

tunerVector<unsigned char> clStationListConfiguration::oGetPayload()
{
	return m_payload;
}

short clStationListConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clStationListConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clStationListConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clStationListConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clStationListConfiguration::vTrace() part 2 -> \n m_u8MaximumNumberOfStationsInList = %d ",m_u8MaximumNumberOfStationsInList));
}