/************************************************************************
 * FILE:          clReceptionBehaviourConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clReceptionBehaviourConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/

#include "TunerApp/ADRConfiguration/clReceptionBehaviourConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clReceptionBehaviourConfiguration.cpp.trc.h"
#endif


clReceptionBehaviourConfiguration::clReceptionBehaviourConfiguration() :clBaseConfigSection(enReceptionBehaviourConfiguration)
,m_u8FieldStrengthSeekLevelFMRDS(0)
,m_u8QualitySeekLevelFMRDS(0)
,m_u8FieldStrengthSeekLevelFMNonRDS(0)
,m_u8QualitySeekLevelFMNonRDS(0)
,m_u8FieldStrengthSeekLevelLW(0)
,m_u8QualitySeekLevelLW(0)
,m_u8FieldStrengthSeekLevelMW(0)
,m_u8QualitySeekLevelMW(0)
,m_u8FieldStrengthSeekLevelSW(0)
,m_u8QualitySeekLevelSW(0)
,m_u8FieldStrengthSeekLevelTRF(0)
,m_u8QualitySeekLevelTRF(0)
,m_u8FieldStrengthSeekLevelWB(0)
,m_u8QualitySeekLevelWB(0)
,m_u8FieldStrengthListLevelFMRDS(0)
,m_u8QualityListLevelFMRDS(0)
,m_u8FieldStrengthListLevelFMNonRDS(0)
,m_u8QualityListLevelFMNonRDS(0)
,m_u8FieldStrengthListLevelLW(0)
,m_u8QualityListLevelLW(0)
,m_u8FieldStrengthListLevelMW(0)
,m_u8QualityListLevelMW(0)
,m_u8FieldStrengthListLevelSW(0)
,m_u8QualityListLevelSW(0)
,m_u8FieldStrengthListLevelTRF(0)
,m_u8QualityListLevelTRF(0)
,m_u8FieldStrengthListLevelWB(0)
,m_u8QualityListLevelWB(0)
,m_u8FMSharx(0)
,m_u8AMSharx(0)
,m_u8FMHicut(0)
,m_u8AMHicut(0)
{
}

clReceptionBehaviourConfiguration::~clReceptionBehaviourConfiguration()
{
}

void clReceptionBehaviourConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8FieldStrengthSeekLevelFMRDS);
	m_payload.push_back(m_u8QualitySeekLevelFMRDS);
	m_payload.push_back(m_u8FieldStrengthSeekLevelFMNonRDS);
	m_payload.push_back(m_u8QualitySeekLevelFMNonRDS);
	m_payload.push_back(m_u8FieldStrengthSeekLevelLW);
	m_payload.push_back(m_u8QualitySeekLevelLW);
	m_payload.push_back(m_u8FieldStrengthSeekLevelMW);
	m_payload.push_back(m_u8QualitySeekLevelMW);
	m_payload.push_back(m_u8FieldStrengthSeekLevelSW);
	m_payload.push_back(m_u8QualitySeekLevelSW);
	m_payload.push_back(m_u8FieldStrengthSeekLevelTRF);
	m_payload.push_back(m_u8QualitySeekLevelTRF);
	m_payload.push_back(m_u8FieldStrengthSeekLevelWB);
	m_payload.push_back(m_u8QualitySeekLevelWB);
	m_payload.push_back(m_u8FieldStrengthListLevelFMRDS);
	m_payload.push_back(m_u8QualityListLevelFMRDS);
	m_payload.push_back(m_u8FieldStrengthListLevelFMNonRDS);
	m_payload.push_back(m_u8QualityListLevelFMNonRDS);
	m_payload.push_back(m_u8FieldStrengthListLevelLW);
	m_payload.push_back(m_u8QualityListLevelLW);
	m_payload.push_back(m_u8FieldStrengthListLevelMW);
	m_payload.push_back(m_u8QualityListLevelMW);
	m_payload.push_back(m_u8FieldStrengthListLevelSW);
	m_payload.push_back(m_u8QualityListLevelSW);
	m_payload.push_back(m_u8FieldStrengthListLevelTRF);
	m_payload.push_back(m_u8QualityListLevelTRF);
	m_payload.push_back(m_u8FieldStrengthListLevelWB);
	m_payload.push_back(m_u8QualityListLevelWB);
	m_payload.push_back(m_u8FMSharx);
	m_payload.push_back(m_u8AMSharx);
	m_payload.push_back(m_u8FMHicut);
	m_payload.push_back(m_u8AMHicut);
	

	m_u16NumberOfBytesInSection = (tU16) m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clReceptionBehaviourConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}
	
	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u8FieldStrengthSeekLevelFMRDS = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelFMRDSFieldstrength");
	m_u8QualitySeekLevelFMRDS = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelFMRDSQuality");
	m_u8FieldStrengthSeekLevelFMNonRDS = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelFMNonRDSFieldstrength");
	m_u8QualitySeekLevelFMNonRDS = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelFMNonRDSQuality");
	m_u8FieldStrengthSeekLevelLW = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelLWFieldstrength");
	m_u8QualitySeekLevelLW = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelLWQuality");
	m_u8FieldStrengthSeekLevelMW = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelMWFieldstrength");
	m_u8QualitySeekLevelMW = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelMWQuality");
	m_u8FieldStrengthSeekLevelSW = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelSWFieldstrength");
	m_u8QualitySeekLevelSW = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelSWQuality");
	m_u8FieldStrengthSeekLevelTRF = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelTRFFieldstrength");
	m_u8QualitySeekLevelTRF = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelTRFQuality");
	m_u8FieldStrengthSeekLevelWB = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelWBFieldstrength");
	m_u8QualitySeekLevelWB = (tU8)poclConfigInterface->u32GetConfigData("SeekLevelWBQuality");
	m_u8FieldStrengthListLevelFMRDS = (tU8)poclConfigInterface->u32GetConfigData("ListLevelFMRDSFieldstrength");
	m_u8QualityListLevelFMRDS = (tU8)poclConfigInterface->u32GetConfigData("ListLevelFMRDSQualify");
	m_u8FieldStrengthListLevelFMNonRDS = (tU8)poclConfigInterface->u32GetConfigData("ListLevelFMNonRDSFieldstrength");
	m_u8QualityListLevelFMNonRDS = (tU8)poclConfigInterface->u32GetConfigData("ListLevelFMNonRDSQuality");
	m_u8FieldStrengthListLevelLW = (tU8)poclConfigInterface->u32GetConfigData("ListLevelLWFieldstrength");
	m_u8QualityListLevelLW = (tU8)poclConfigInterface->u32GetConfigData("ListLevelLWQuality");
	m_u8FieldStrengthListLevelMW = (tU8)poclConfigInterface->u32GetConfigData("ListLevelMWFieldstrength");
	m_u8QualityListLevelMW = (tU8)poclConfigInterface->u32GetConfigData("ListLevelMWQuality");
	m_u8FieldStrengthListLevelSW = (tU8)poclConfigInterface->u32GetConfigData("ListLevelSWFieldstrength");
	m_u8QualityListLevelSW = (tU8)poclConfigInterface->u32GetConfigData("ListLevelSWQuality");
	m_u8FieldStrengthListLevelTRF = (tU8)poclConfigInterface->u32GetConfigData("ListLevelTRFFieldstrength");
	m_u8QualityListLevelTRF = (tU8)poclConfigInterface->u32GetConfigData("ListLevelTRFQuality");
	m_u8FieldStrengthListLevelWB = (tU8)poclConfigInterface->u32GetConfigData("ListLevelWBFieldstrength");
	m_u8QualityListLevelWB = (tU8)poclConfigInterface->u32GetConfigData("ListLevelWBQuality");
	m_u8FMSharx = (tU8)poclConfigInterface->u32GetConfigData("FMSHARX");
	m_u8AMSharx = (tU8)poclConfigInterface->u32GetConfigData("AMSHARX");
	m_u8FMHicut = (tU8)poclConfigInterface->u32GetConfigData("FMHICUT");
	m_u8AMHicut = (tU8)poclConfigInterface->u32GetConfigData("AMHICUT");
}

tunerVector<unsigned char> clReceptionBehaviourConfiguration::oGetPayload()
{
	return m_payload;
}

short clReceptionBehaviourConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clReceptionBehaviourConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clReceptionBehaviourConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clReceptionBehaviourConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clReceptionBehaviourConfiguration::vTrace() part 2 -> \n m_u8FieldStrengthSeekLevelFMRDS = 0x%02X \n m_u8QualitySeekLevelFMRDS = 0x%02X \n "\
		"m_u8FieldStrengthSeekLevelFMNonRDS = 0x%02X \n m_u8QualitySeekLevelFMNonRDS = 0x%02X \n m_u8FieldStrengthSeekLevelLW = 0x%02X ",\
		m_u8FieldStrengthSeekLevelFMRDS,m_u8QualitySeekLevelFMRDS,m_u8FieldStrengthSeekLevelFMNonRDS,m_u8QualitySeekLevelFMNonRDS,m_u8FieldStrengthSeekLevelLW ));
	
	ETG_TRACE_USR2(( "clReceptionBehaviourConfiguration::vTrace() part 3 -> \n m_u8QualitySeekLevelLW = 0x%02X \n m_u8FieldStrengthSeekLevelMW = 0x%02X \n "\
		"m_u8QualitySeekLevelMW = 0x%02X \n m_u8FieldStrengthSeekLevelSW = 0x%02X \n m_u8QualitySeekLevelSW = 0x%02X ",\
		m_u8QualitySeekLevelLW,m_u8FieldStrengthSeekLevelMW,m_u8QualitySeekLevelMW,m_u8FieldStrengthSeekLevelSW,m_u8QualitySeekLevelSW ));

	ETG_TRACE_USR2(( "clReceptionBehaviourConfiguration::vTrace() part 4 -> \n m_u8FieldStrengthSeekLevelTRF = 0x%02X \n m_u8QualitySeekLevelTRF = 0x%02X \n "\
		"m_u8FieldStrengthSeekLevelWB = 0x%02X \n m_u8QualitySeekLevelWB = 0x%02X \n m_u8FieldStrengthListLevelFMRDS = 0x%02X ",\
		m_u8FieldStrengthSeekLevelTRF,m_u8QualitySeekLevelTRF,m_u8FieldStrengthSeekLevelWB,m_u8QualitySeekLevelWB,m_u8FieldStrengthListLevelFMRDS ));

	ETG_TRACE_USR2(( "clReceptionBehaviourConfiguration::vTrace() part 5 -> \n m_u8QualityListLevelFMRDS = 0x%02X \n m_u8FieldStrengthListLevelFMNonRDS = 0x%02X \n "\
		"m_u8QualityListLevelFMNonRDS = 0x%02X \n m_u8FieldStrengthListLevelLW = 0x%02X  \n m_u8QualityListLevelLW = 0x%02X  ",\
		m_u8QualityListLevelFMRDS,m_u8FieldStrengthListLevelFMNonRDS,m_u8QualityListLevelFMNonRDS,m_u8FieldStrengthListLevelLW,m_u8QualityListLevelLW ));
		
	ETG_TRACE_USR2(( "clReceptionBehaviourConfiguration::vTrace() part 6 ->  \n m_u8FieldStrengthListLevelMW = 0x%02X  \n m_u8QualityListLevelMW = 0x%02X \n "\
		"m_u8FieldStrengthListLevelSW = 0x%02X \n m_u8QualityListLevelSW = 0x%02X  \n m_u8FieldStrengthListLevelTRF = 0x%02X  ",\
		m_u8FieldStrengthListLevelMW,m_u8QualityListLevelMW,m_u8FieldStrengthListLevelSW,m_u8QualityListLevelSW,m_u8FieldStrengthListLevelTRF ));
		
	ETG_TRACE_USR2(( "clReceptionBehaviourConfiguration::vTrace() part 7 ->  \n m_u8QualityListLevelTRF = 0x%02X  \n m_u8FieldStrengthListLevelWB = 0x%02X  \n "\
		"m_u8QualityListLevelWB = 0x%02X  ",\
		m_u8QualityListLevelTRF,m_u8FieldStrengthListLevelWB,m_u8QualityListLevelWB));

	ETG_TRACE_USR2(( "clReceptionBehaviourConfiguration::vTrace() part 6 ->  \n m_u8FMSharx = %d \n m_u8AMSharx = %d \n "\
		"m_u8FMHicut = %d \n m_u8AMHicut = %d",\
		m_u8FMSharx,m_u8AMSharx,m_u8FMHicut,m_u8AMHicut));
}