/************************************************************************
 * FILE:          clRDSParameterConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clRDSParameterConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/

#include "TunerApp/ADRConfiguration/clRDSParameterConfiguration.h"

#include "tun_Config.h"

#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clRDSParameterConfiguration.cpp.trc.h"
#endif

#define UNUSED_BYTE 0xaa
#define MAX_UNUSED_BYTES 14

clRDSParameterConfiguration::clRDSParameterConfiguration() :clBaseConfigSection(enRDSParameterConfiguration) 
,m_u8ExchangeAntennaLevel(0)
,m_u8PITestLevel(0)
,m_u8NRDSLevel(0)
,m_u8EONLevel(0)
,m_u8FMMemoLevel(0)
,m_u8PanicFieldstrengthLevel(0)
,m_u8ParamRDSLevel(0)
,m_u8RDSDataAcceptLevel(0)
,m_u8PIStepLevel(0)
,m_u8DDAAntennaDistLevel(0)
,m_u8RDSSynDelayCnt(0)
,m_u8MPMeasureLevel(0)
,m_u8MPLevel2Level(0)
,m_u8MPVeryBadLevel(0)
,m_u8MPMediumLevel(0)
,m_u8RDSBadLevel(0)
,m_u8IllegalAF(0)
,m_u8AFSaveLevel(0)
,m_u8FirstRundum(0)
,m_u8SecondRundum(0)
,m_u8ThirdRundum(0)
,m_u8PIStepMode(0)
,m_u8AudioOffScanMode(0)
,m_u8AMLearnCycle(0)
,m_u8PIIgnore(0)
,m_u8PISearchTime(0)
,m_u8DisableSeamlessBlending(0)
,m_u8SlAdjThreshold(0)
,m_u8SlMPThreshold(0)
,m_u8SpecialFMStartFrequency(0)
,m_u8FMSharxLimit(0)
,m_u8HDScanEveryFreq(0)
,m_u8HWSubConfig(0)
,m_u8FM2DABDelayTime(0)
{
}

clRDSParameterConfiguration::~clRDSParameterConfiguration()
{
}

void clRDSParameterConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8ExchangeAntennaLevel);
	m_payload.push_back(m_u8PITestLevel);
	m_payload.push_back(m_u8NRDSLevel);
	m_payload.push_back(m_u8EONLevel);
	m_payload.push_back(m_u8FMMemoLevel);
	m_payload.push_back(m_u8PanicFieldstrengthLevel);
	m_payload.push_back(m_u8ParamRDSLevel);
	m_payload.push_back(m_u8RDSDataAcceptLevel);
	m_payload.push_back(m_u8PIStepLevel);
	m_payload.push_back(m_u8DDAAntennaDistLevel);
	m_payload.push_back(m_u8RDSSynDelayCnt);
	m_payload.push_back(m_u8MPMeasureLevel);
	m_payload.push_back(m_u8MPLevel2Level);
	m_payload.push_back(m_u8MPVeryBadLevel);
	m_payload.push_back(m_u8MPMediumLevel);
	m_payload.push_back(m_u8RDSBadLevel);
	m_payload.push_back(m_u8IllegalAF);
	m_payload.push_back(m_u8AFSaveLevel);
	m_payload.push_back(m_u8FirstRundum);
	m_payload.push_back(m_u8SecondRundum);
	m_payload.push_back(m_u8ThirdRundum);
	m_payload.push_back(m_u8PIStepMode);
	m_payload.push_back(m_u8AudioOffScanMode);
	m_payload.push_back(m_u8AMLearnCycle);
	m_payload.push_back(m_u8PIIgnore);
	m_payload.push_back(m_u8PISearchTime);
	m_payload.push_back(m_u8DisableSeamlessBlending);
	m_payload.push_back(m_u8SlAdjThreshold);
	m_payload.push_back(m_u8SlMPThreshold);
	m_payload.push_back(m_u8SpecialFMStartFrequency);
	m_payload.push_back(m_u8FMSharxLimit);
	m_payload.push_back(m_u8HDScanEveryFreq);
	m_payload.push_back(m_u8HWSubConfig);
	m_payload.push_back(m_u8FM2DABDelayTime);

	for(unsigned char i=0; i<MAX_UNUSED_BYTES; i++)
	{
		m_payload.push_back(UNUSED_BYTE);
	}

	
	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clRDSParameterConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}
	
	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u8ExchangeAntennaLevel = (tU8)poclConfigInterface->u32GetConfigData("ExchangeAntennaLevel");
	m_u8PITestLevel = (tU8)poclConfigInterface->u32GetConfigData("PTTestLevel");
	m_u8NRDSLevel = (tU8)poclConfigInterface->u32GetConfigData("NRDSLevel");
	m_u8EONLevel = (tU8)poclConfigInterface->u32GetConfigData("EONLevel");
	m_u8FMMemoLevel = (tU8)poclConfigInterface->u32GetConfigData("FMMemoLevel");
	m_u8PanicFieldstrengthLevel = (tU8)poclConfigInterface->u32GetConfigData("PanicFieldstLevel");
	m_u8ParamRDSLevel = (tU8)poclConfigInterface->u32GetConfigData("ParamRDSLevel");
	m_u8RDSDataAcceptLevel = (tU8)poclConfigInterface->u32GetConfigData("RDSDataAccept");
	m_u8PIStepLevel = (tU8)poclConfigInterface->u32GetConfigData("PIStepLevel");
	m_u8DDAAntennaDistLevel = (tU8)poclConfigInterface->u32GetConfigData("DDAAntennaDistLevel");
	m_u8RDSSynDelayCnt = (tU8)poclConfigInterface->u32GetConfigData("RDSSynDelayCounter");
	m_u8MPMeasureLevel = (tU8)poclConfigInterface->u32GetConfigData("MPMeasureLevel");
	m_u8MPLevel2Level = (tU8)poclConfigInterface->u32GetConfigData("MPLevel2");
	m_u8MPVeryBadLevel = (tU8)poclConfigInterface->u32GetConfigData("MPVeryBadLevel");
	m_u8MPMediumLevel = (tU8)poclConfigInterface->u32GetConfigData("MPMediumLevel");
	m_u8RDSBadLevel = (tU8)poclConfigInterface->u32GetConfigData("RDSBadLevel");
	m_u8IllegalAF = (tU8)poclConfigInterface->u32GetConfigData("IllegalAF");
	m_u8AFSaveLevel = (tU8)poclConfigInterface->u32GetConfigData("AFSaveLevel");
	m_u8FirstRundum = (tU8)poclConfigInterface->u32GetConfigData("FirstRundum");
	m_u8SecondRundum = (tU8)poclConfigInterface->u32GetConfigData("SecondRundum");
	m_u8ThirdRundum = (tU8)poclConfigInterface->u32GetConfigData("ThirdRundum");
	m_u8PIStepMode = (tU8)poclConfigInterface->u32GetConfigData("PIStepMode");
	m_u8AudioOffScanMode = (tU8)poclConfigInterface->u32GetConfigData("AudioOffScanMode");
	m_u8AMLearnCycle = (tU8)poclConfigInterface->u32GetConfigData("AMLearnCycle");
	m_u8PIIgnore = (tU8)poclConfigInterface->u32GetConfigData("PIIgnore");
	m_u8PISearchTime = (tU8)poclConfigInterface->u32GetConfigData("PISearchTime");
	m_u8DisableSeamlessBlending = (tU8)poclConfigInterface->u32GetConfigData("DisableSeamlessBlending");
	m_u8SlAdjThreshold = (tU8)poclConfigInterface->u32GetConfigData("SLAdjThreshold");
	m_u8SlMPThreshold = (tU8)poclConfigInterface->u32GetConfigData("SLMpThreshold");
	m_u8SpecialFMStartFrequency = (tU8)poclConfigInterface->u32GetConfigData("SpecialFmStartFrequency");
	m_u8FMSharxLimit = (tU8)poclConfigInterface->u32GetConfigData("FMSharxLimit");
	m_u8HDScanEveryFreq = (tU8)poclConfigInterface->u32GetConfigData("HDScanEveryFrequency");
	m_u8HWSubConfig = (tU8)poclConfigInterface->u32GetConfigData("HWSubConfig");
	m_u8FM2DABDelayTime = (tU8)poclConfigInterface->u32GetConfigData("FMToDABDelayTime");
}

tunerVector<unsigned char> clRDSParameterConfiguration::oGetPayload()
{
	return m_payload;
}

short clRDSParameterConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clRDSParameterConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clRDSParameterConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clRDSParameterConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clRDSParameterConfiguration::vTrace() part 2 -> \n m_u8ExchangeAntennaLevel = 0x%02X \n m_u8PITestLevel = %2d dBuV \n "\
		"m_u8NRDSLevel = %2d dBuV \n m_u8EONLevel = %2d dBuV \n m_u8FMMemoLevel = %2d dBuV ",\
		m_u8ExchangeAntennaLevel,m_u8PITestLevel,m_u8NRDSLevel,m_u8EONLevel,m_u8FMMemoLevel ));
	
	ETG_TRACE_USR2(( "clRDSParameterConfiguration::vTrace() part 3 -> \n m_u8PanicFieldstrengthLevel = %2d dBuV \n m_u8ParamRDSLevel = %2d dBuV \n "\
		"m_u8RDSDataAcceptLevel = %2d dBuV \n m_u8PIStepLevel = %2d dBuV \n m_u8DDAAntennaDistLevel = %3d ",\
		m_u8PanicFieldstrengthLevel,m_u8ParamRDSLevel,m_u8RDSDataAcceptLevel,m_u8PIStepLevel,m_u8DDAAntennaDistLevel ));

	
	ETG_TRACE_USR2(( "clRDSParameterConfiguration::vTrace() part 4 -> \n m_u8RDSSynDelayCnt =%3d \n m_u8MPMeasureLevel = %3d \n "\
		"m_u8MPLevel2Level = %3d \n m_u8MPVeryBadLevel = %3d \n m_u8MPMediumLevel = %3d ",\
		m_u8RDSSynDelayCnt,m_u8MPMeasureLevel,m_u8MPLevel2Level,m_u8MPVeryBadLevel,m_u8MPMediumLevel ));
	
	ETG_TRACE_USR2(( "clRDSParameterConfiguration::vTrace() part 5 -> \n m_u8RDSBadLevel = %3d \n m_u8IllegalAF = %3d \n "\
		"m_u8AFSaveLevel = %3d \n m_u8FirstRundum = %3d seconds \n m_u8SecondRundum = %3d seconds ",\
		m_u8RDSBadLevel,m_u8IllegalAF,m_u8AFSaveLevel,m_u8FirstRundum,m_u8SecondRundum ));
	
	ETG_TRACE_USR2(( "clRDSParameterConfiguration::vTrace() part 6 ->  \n m_u8ThirdRundum = %3d seconds \n m_u8PIStepMode = %3d \n "\
		"m_u8AudioOffScanMode = %3d \n m_u8AMLearnCycle = %3d seconds \n m_u8PIIgnore = %3d seconds ",\
		m_u8ThirdRundum,m_u8PIStepMode,m_u8AudioOffScanMode,m_u8AMLearnCycle,m_u8PIIgnore ));
		
	ETG_TRACE_USR2(( "clRDSParameterConfiguration::vTrace() part 7 ->  \n m_u8PISearchTime = %3d seconds \n m_u8DisableSeamlessBlending = %3d seconds \n "\
		"m_u8SlAdjThreshold = %3d seconds \n m_u8SlMPThreshold = %3d seconds \n m_u8SpecialFMStartFrequency = %3d seconds ",\
		m_u8PISearchTime,m_u8DisableSeamlessBlending,m_u8SlAdjThreshold,m_u8SlMPThreshold,m_u8SpecialFMStartFrequency));

	ETG_TRACE_USR2(( "clRDSParameterConfiguration::vTrace() part 8 ->  \n m_u8FMSharxLimit = %3d \n m_u8HDScanEveryFreq = %3d \n m_u8HWSubConfig = %3d seconds\nm_u8FM2DABDelayTime = %d",\
		m_u8FMSharxLimit,m_u8HDScanEveryFreq,m_u8HWSubConfig,m_u8FM2DABDelayTime ));
}
