/************************************************************************
 * FILE:           clHardwareRelatedConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clHardwareRelatedConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/

#include "TunerApp/ADRConfiguration/clHardwareRelatedConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clHardwareRelatedConfiguration.cpp.trc.h"
#endif


clHardwareRelatedConfiguration::clHardwareRelatedConfiguration() :clBaseConfigSection(enHardwareReleatedConfiguration)
,m_u8PhysicalTunerConfigurationId(0)
,m_u8AntennaTunerConfigurationId(0)
{
}

clHardwareRelatedConfiguration::~clHardwareRelatedConfiguration()
{
}

void clHardwareRelatedConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8PhysicalTunerConfigurationId);
	m_payload.push_back(m_u8AntennaTunerConfigurationId);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clHardwareRelatedConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}
	
	m_u8PhysicalTunerConfigurationId = (tU8) poclConfigInterface->u32GetConfigData("FmDabHdTunerMode");
	m_u8AntennaTunerConfigurationId = (tU8) poclConfigInterface->u32GetConfigData("AntennaConfigId");
}

tunerVector<unsigned char> clHardwareRelatedConfiguration::oGetPayload()
{
	return m_payload;
}

short clHardwareRelatedConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clHardwareRelatedConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

unsigned char clHardwareRelatedConfiguration::u8GetPhysicalTunerConfigurationId()
{
	return m_u8PhysicalTunerConfigurationId;
}
	
void clHardwareRelatedConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clHardwareRelatedConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clHardwareRelatedConfiguration::vTrace() part 2 -> \n m_u8PhysicalTunerConfigurationId = %02X \n m_u8AntennaTunerConfigurationId = 0x%02X ",\
		m_u8PhysicalTunerConfigurationId,m_u8AntennaTunerConfigurationId));
}