/************************************************************************
 * FILE:          clHDParameterConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clHDParameterConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/


#include "TunerApp/ADRConfiguration/clHDParameterConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clHDParameterConfiguration.cpp.trc.h"
#endif


clHDParameterConfiguration::clHDParameterConfiguration() :clBaseConfigSection(enHDParameterConfiguration)
,m_u8BlendThresholdFMHybrid(0)
,m_u16DigiAudioScalingFMHybrid(0)
,m_u16DigiAudioDelayFMHybridPrimaryBBRate(0)
,m_u8BlendRateFMHybrid(0)			
,m_u8BlendThresholdAMHybrid(0)			
,m_u16AM_MPSAudioScaling(0)					
,m_u8AM_MPSBlendRate(0)						
,m_u16DigiAudioDelayAM_MPSPrimaryBBRate(0)    
,m_u8DigiAudioPhaseInversion(0)				
,m_u8BlendDecision(0)						
,m_u8FM_CDNO_BlendDecision(0)				
,m_u8AM_CDNO_BlendDecision(0)
,m_u8FMSPSBlendThreshold(0)
,m_u16FMSPSAudioScaling(0)
,m_u8FMSPSBlendRate(0)
,m_u8BallgameModeAudioOutput(0)
,m_u8FilteredDSQMTimeConstant(0)
,m_u8EZBlendEnable(0)
,m_u16DSQMSeekThreshold(0x0000)
{
}

clHDParameterConfiguration::~clHDParameterConfiguration()
{
}

void clHDParameterConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8BlendThresholdFMHybrid);
	vAddShort(m_payload, m_u16DigiAudioScalingFMHybrid);
	vAddShort(m_payload, m_u16DigiAudioDelayFMHybridPrimaryBBRate);
	m_payload.push_back(m_u8BlendRateFMHybrid);			
	m_payload.push_back(m_u8BlendThresholdAMHybrid);			
	vAddShort(m_payload, m_u16AM_MPSAudioScaling);					
	m_payload.push_back(m_u8AM_MPSBlendRate);						
	vAddShort(m_payload, m_u16DigiAudioDelayAM_MPSPrimaryBBRate);    
	m_payload.push_back(m_u8DigiAudioPhaseInversion);				
	m_payload.push_back(m_u8BlendDecision);						
	m_payload.push_back(m_u8FM_CDNO_BlendDecision);				
	m_payload.push_back(m_u8AM_CDNO_BlendDecision);
	m_payload.push_back(m_u8FMSPSBlendThreshold);
	vAddShort(m_payload,m_u16FMSPSAudioScaling);
	m_payload.push_back(m_u8FMSPSBlendRate);
	m_payload.push_back(m_u8BallgameModeAudioOutput);
	m_payload.push_back(m_u8FilteredDSQMTimeConstant);
	m_payload.push_back(m_u8EZBlendEnable);
	vAddShort(m_payload,m_u16DSQMSeekThreshold);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clHDParameterConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u8BlendThresholdFMHybrid = (tU8)poclConfigInterface->u32GetConfigData("BlendThresholdFMHybrid");
	m_u16DigiAudioScalingFMHybrid = (tU16)poclConfigInterface->u32GetConfigData("DigitalAudioScalingForFMHybrid");
	m_u16DigiAudioDelayFMHybridPrimaryBBRate = (tU16)poclConfigInterface->u32GetConfigData("DigiAudioDelayFMHybridPrimaryBBRate");
	m_u8BlendRateFMHybrid = (tU8)poclConfigInterface->u32GetConfigData("BlendRateFMHybrid");
	m_u8BlendThresholdAMHybrid = (tU8)poclConfigInterface->u32GetConfigData("BlendThresholdAMHybrid");
	m_u16AM_MPSAudioScaling = (tU16)poclConfigInterface->u32GetConfigData("AMMPSAudioScaling");
	m_u8AM_MPSBlendRate = (tU8)poclConfigInterface->u32GetConfigData("AMMPSBlendRate");
	m_u16DigiAudioDelayAM_MPSPrimaryBBRate = (tU16)poclConfigInterface->u32GetConfigData("DigitalAudioDelayForAMMPSPrimaryBBRate");
	m_u8DigiAudioPhaseInversion = (tU8)poclConfigInterface->u32GetConfigData("DigitalAudioPhaseInversion");
	m_u8BlendDecision = (tU8)poclConfigInterface->u32GetConfigData("BlendDecision");
	m_u8FM_CDNO_BlendDecision = (tU8)poclConfigInterface->u32GetConfigData("FMCDNOBlendDecision");
	m_u8AM_CDNO_BlendDecision = (tU8)poclConfigInterface->u32GetConfigData("AMCDNOBlendDecision");
	m_u8FMSPSBlendThreshold = (tU8)poclConfigInterface->u32GetConfigData("FMSPSBlendThreshold");
	m_u16FMSPSAudioScaling = (tU16)poclConfigInterface->u32GetConfigData("FMSPSAudioScaling");
	m_u8FMSPSBlendRate = (tU8)poclConfigInterface->u32GetConfigData("FMSPSBlendRate");
	m_u8BallgameModeAudioOutput = (tU8)poclConfigInterface->u32GetConfigData("BallgameModeAudioOutput");
	m_u8FilteredDSQMTimeConstant = (tU8)poclConfigInterface->u32GetConfigData("FilteredDSQMTimeConstant");
	m_u8EZBlendEnable = (tU8)poclConfigInterface->u32GetConfigData("EZBlendEnable");
	m_u16DSQMSeekThreshold = (tU16)poclConfigInterface->u32GetConfigData("DSQMSeekThreshold");

}

tunerVector<unsigned char> clHDParameterConfiguration::oGetPayload()
{
	return m_payload;
}

short clHDParameterConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clHDParameterConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clHDParameterConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clHDParameterConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clHDParameterConfiguration::vTrace() part 2 -> \n m_u8BlendThresholdFMHybrid = 0x%02X \n m_u16DigiAudioScalingFMHybrid = 0x%04X \n "\
		"m_u16DigiAudioDelayFMHybridPrimaryBBRate = 0x%04X \n m_u8BlendRateFMHybrid = 0x%02X \n m_u8BlendThresholdAMHybrid = 0x%02X \n",\
		m_u8BlendThresholdFMHybrid,m_u16DigiAudioScalingFMHybrid,m_u16DigiAudioDelayFMHybridPrimaryBBRate,m_u8BlendRateFMHybrid,m_u8BlendThresholdAMHybrid ));
 
	ETG_TRACE_USR2(( "clHDParameterConfiguration::vTrace() part 3 -> \n m_u16AM_MPSAudioScaling = 0x%04X \n m_u8AM_MPSBlendRate = 0x%02X \n "\
		"m_u16DigiAudioDelayAM_MPSPrimaryBBRate = 0x%04X \n m_u8DigiAudioPhaseInversion = 0x%02X \n m_u8BlendDecision = 0x%02X \n",\
		m_u16AM_MPSAudioScaling,m_u8AM_MPSBlendRate,m_u16DigiAudioDelayAM_MPSPrimaryBBRate,m_u8DigiAudioPhaseInversion,m_u8BlendDecision ));
	
	ETG_TRACE_USR2(( "clHDParameterConfiguration::vTrace() part 4 -> \n m_u8FM_CDNO_BlendDecision = 0x%02X \n m_u8AM_CDNO_BlendDecision = 0x%02X \n "\
		"m_u8FMSPSBlendThreshold = 0x%02X \n m_u16FMSPSAudioScaling = 0x%04X \n m_u8FMSPSBlendRate = 0x%02X \n",\
		m_u8FM_CDNO_BlendDecision,m_u8AM_CDNO_BlendDecision,m_u8FMSPSBlendThreshold,m_u16FMSPSAudioScaling,m_u8FMSPSBlendRate ));
	
	ETG_TRACE_USR2(( "clHDParameterConfiguration::vTrace() part 5 -> \n m_u8BallgameModeAudioOutput = 0x%02X \n m_u8FilteredDSQMTimeConstant = 0x%02X \n "\
		"m_u8EZBlendEnable = 0x%02X \n m_u16DSQMSeekThreshold = 0x%04X \n",\
		m_u8BallgameModeAudioOutput,m_u8FilteredDSQMTimeConstant,m_u8EZBlendEnable,m_u16DSQMSeekThreshold));
	
}