/************************************************************************
 * FILE:           clDRMParameterConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clDRMParameterConfiguration.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   8-Aug-2015			vnd4kor
				
 *************************************************************************/


#ifndef clDRMParameterConfiguration_h
#define clDRMParameterConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;


class clDRMParameterConfiguration : public clBaseConfigSection 
{

private:

	unsigned char m_u8DRMBandEnable;
	unsigned int m_u32DRMMWStepSizeForSearch;
	unsigned int m_u32DRMMWStepSizeForManualStep;
	unsigned char m_u8DRMServiceFollowing;
	unsigned char m_u8DRMAFSearchDelayTime;
	unsigned char m_u8DRMServiceListUnlearnTimeThreshold;
	unsigned char m_u8DRMServiceListLearnAcceptanceTime;
	unsigned char m_u8DRMServiceListLearnAcceptanceThreshold;
	unsigned char m_u8DRMQualityThresholdForAudioMute;
	unsigned char m_u8DRMErrorConcealmentLevel;
	signed char m_s8DRMMWSeekStopFieldStrengthThreshold;
	unsigned char m_u8DRMSwitches; //DRM frequency grid corection: ON/OFF

		
public:
	/**
	 * Constructor
	 */
	clDRMParameterConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clDRMParameterConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();
};

#endif