/************************************************************************
 * FILE:        clDRMParameterConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clDRMParameterConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "TunerApp/ADRConfiguration/clDRMParameterConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clDRMParameterConfiguration.cpp.trc.h"
#endif


clDRMParameterConfiguration::clDRMParameterConfiguration() :clBaseConfigSection(enDRMParameterConfiguration)
,m_u8DRMBandEnable(0)
,m_u32DRMMWStepSizeForSearch(0)
,m_u32DRMMWStepSizeForManualStep(0)
,m_u8DRMServiceFollowing(0)
,m_u8DRMAFSearchDelayTime(0)
,m_u8DRMServiceListUnlearnTimeThreshold(0)
,m_u8DRMServiceListLearnAcceptanceTime(0)
,m_u8DRMServiceListLearnAcceptanceThreshold(0)
,m_u8DRMQualityThresholdForAudioMute(0)
,m_u8DRMErrorConcealmentLevel(0)
,m_s8DRMMWSeekStopFieldStrengthThreshold(0)
,m_u8DRMSwitches(0)
{
}

clDRMParameterConfiguration::~clDRMParameterConfiguration()
{
}

void clDRMParameterConfiguration::vSerialize()
{
	
	m_payload.clear();
		
	m_payload.push_back(m_u8DRMBandEnable);	
	vAddInt(m_payload , m_u32DRMMWStepSizeForSearch);
    vAddInt(m_payload , m_u32DRMMWStepSizeForManualStep);
	m_payload.push_back(m_u8DRMServiceFollowing);
	m_payload.push_back(m_u8DRMAFSearchDelayTime);
	m_payload.push_back(m_u8DRMServiceListUnlearnTimeThreshold);
	m_payload.push_back(m_u8DRMServiceListLearnAcceptanceTime);
	m_payload.push_back(m_u8DRMServiceListLearnAcceptanceThreshold);
	m_payload.push_back(m_u8DRMQualityThresholdForAudioMute);
	m_payload.push_back(m_u8DRMErrorConcealmentLevel);
	m_payload.push_back(m_s8DRMMWSeekStopFieldStrengthThreshold);
	m_payload.push_back(m_u8DRMSwitches);
	
	m_u16NumberOfBytesInSection = m_payload.size();
	
	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clDRMParameterConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}
	m_u8DRMBandEnable							= poclConfigInterface->u32GetConfigData("DRMBandEnable");
	m_u32DRMMWStepSizeForSearch					= poclConfigInterface->u32GetConfigData("DRMMWTunningStepSizeForSearch");
	m_u32DRMMWStepSizeForManualStep				= poclConfigInterface->u32GetConfigData("DRMMWTunningStepSizeForManualStep");
	m_u8DRMServiceFollowing						= poclConfigInterface->u32GetConfigData("DRMServiceFollowing");
	m_u8DRMAFSearchDelayTime					= poclConfigInterface->u32GetConfigData("DRMAFSearchDelayTime");
	m_u8DRMServiceListUnlearnTimeThreshold		= poclConfigInterface->u32GetConfigData("DRMServiceListUnlearnTimeThreshold");
	m_u8DRMServiceListLearnAcceptanceTime		= poclConfigInterface->u32GetConfigData("DRMServiceListLearnAcceptanceTime");
	m_u8DRMServiceListLearnAcceptanceThreshold	= poclConfigInterface->u32GetConfigData("DRMServiceListLearnAcceptanceThreshold");
	m_u8DRMQualityThresholdForAudioMute			= poclConfigInterface->u32GetConfigData("DRMQualityThresholdForAudioMute");
	m_u8DRMErrorConcealmentLevel				= poclConfigInterface->u32GetConfigData("DRMAudioErrorConcealmentLevel");
	m_s8DRMMWSeekStopFieldStrengthThreshold     = poclConfigInterface->u32GetConfigData("DRMSeekStopFielstrengthThreshold");
	m_u8DRMSwitches  							= poclConfigInterface->u32GetConfigData("DRMSwitches");

}

tunerVector<unsigned char> clDRMParameterConfiguration::oGetPayload()
{
	return m_payload;
}

short clDRMParameterConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clDRMParameterConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clDRMParameterConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clDRMParameterConfiguration::vTrace() part 1 -> \n"
		"******************************************************\n"
		"=>	Section Id									= %5d\n"
		"=>	m_u16NumberOfBytesInSection					= %5d\n"
		"******************************************************"
		,m_enSectionID
		,m_u16NumberOfBytesInSection ));
	
	ETG_TRACE_USR2(( "clDRMParameterConfiguration::vTrace() part 2 -> \n"
		"=>	m_u8DRMBandEnable					= 0x%02x \n"
		"=>	m_u32DRMMWStepSizeForSearch			= %08d kHz steps \n"
		"=>	m_u32DRMMWStepSizeForManualStep		= %08d kHz steps \n"
		"=>	m_u8DRMServiceFollowing				= 0x%02x \n"
		"=>	m_u8DRMAFSearchDelayTime			= 0x%02X 100ms  steps\n"
		,m_u8DRMBandEnable
		,m_u32DRMMWStepSizeForSearch
		,m_u32DRMMWStepSizeForManualStep
		,m_u8DRMServiceFollowing
		,m_u8DRMAFSearchDelayTime));

	ETG_TRACE_USR2(( "clDRMParameterConfiguration::vTrace() part 3 -> \n"
		"=>	m_u8DRMServiceListUnlearnTimeThreshold			= 0x%02x 10s   steps\n"
		"=>	m_u8DRMServiceListLearnAcceptanceTime			= 0x%02x 100ms steps \n"
		"=>	m_u8DRMServiceListLearnAcceptanceThreshold		= %02d \n"
		"=>	m_u8DRMQualityThresholdForAudioMute				= %02d \n"
		"=>	m_u8DRMErrorConcealmentLevel					= %02d \n"
		"=> m_s8DRMMWSeekStopFieldStrengthThreshold         = %02d  dBuV\n"
		"=> m_u8DRMSwitches                                 = %02d  \n"
		,m_u8DRMServiceListUnlearnTimeThreshold
		,m_u8DRMServiceListLearnAcceptanceTime
		,m_u8DRMServiceListLearnAcceptanceThreshold
		,m_u8DRMQualityThresholdForAudioMute
		,m_u8DRMErrorConcealmentLevel
      ,m_s8DRMMWSeekStopFieldStrengthThreshold
      ,m_u8DRMSwitches));

}