/************************************************************************
 * FILE:         clBandSetupConfiguration.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clBandSetupConfiguration.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef clBandSetupConfiguration_h
#define clBandSetupConfiguration_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TunerApp/ADRConfiguration/clBaseConfigSection.h"

class tun_Config;
class clConfigInterface;


class clBandSetupConfiguration : public clBaseConfigSection 
{

private:
	unsigned int m_u32AvailableBands;
	unsigned int m_u32CombiBand;
	
	unsigned int m_u32FMLowestFrequency;
	unsigned int m_u32FMHighestFrequency;
	unsigned short m_u16FMAutoSeekStepWidth;
	unsigned short m_u16FMManualStepWidth;
	unsigned int m_u32FMInitialLSM;
	
	unsigned int m_u32LWLowestFrequency;
	unsigned int m_u32LWHighestFrequency;
	unsigned short m_u16LWAutoSeekStepWidth;
	unsigned short m_u16LWManualStepWidth;
	unsigned int m_u32LWInitialLSM;

	unsigned int m_u32MWLowestFrequency;
	unsigned int m_u32MWHighestFrequency;
	unsigned short m_u16MWAutoSeekStepWidth;
	unsigned short m_u16MWManualStepWidth;
	unsigned int m_u32MWInitialLSM;

	unsigned int m_u32TRFLowestFrequency;
	unsigned int m_u32TRFHighestFrequency;
	unsigned short m_u16TRFAutoSeekStepWidth;
	unsigned short m_u16TRFManualStepWidth;
	unsigned int m_u32TRFInitialLSM;
	
	unsigned int m_u32WBLowestFrequency;
	unsigned int m_u32WBHighestFrequency;
	unsigned short m_u16WBAutoSeekStepWidth;
	unsigned short m_u16WBManualStepWidth;
	unsigned int m_u32WBInitialLSM;
public:
	/**
	 * Constructor
	 */
	clBandSetupConfiguration();
	/**
	 * Destrcutor
	 */
	virtual ~clBandSetupConfiguration();

	/**
	 * serialize m_payload
	 */
	void vSerialize();
	/**
	 * returns the size of the m_payload
	 */
	short u16GetSize();
	/**
	 * constructs m_payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * returns m_payload
	 */
	tunerVector<unsigned char> oGetPayload();
	/**
	 * Sets Configuration values to member variables
	 */
	void vSetParameters(tun_Config* m_potun_Config, clConfigInterface* m_poclConfigInterface);
	/**
	 * Trace print for value of each member variable
	 */
	void vTrace();

	unsigned int u32GetBitPositionVal(unsigned char u8Value);

};

#endif