/************************************************************************
 * FILE:         clBandSetupConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clBandSetupConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "TunerApp/ADRConfiguration/clBandSetupConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"
#include "tun_defines.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clBandSetupConfiguration.cpp.trc.h"
#endif

#define UNUSED_SHORT 0xaaaa
#define UNUSED_INT 0xaaaaaaaa
//Only Band from SW1 to SW14 is currnetly unused
#define MAX_NUMBER_UNUSED_BANDS 14
clBandSetupConfiguration::clBandSetupConfiguration() :clBaseConfigSection(enBandSetupConfiguration) 
,m_u32AvailableBands(0)
,m_u32CombiBand(0)
,m_u32FMLowestFrequency(0)
,m_u32FMHighestFrequency(0)
,m_u16FMAutoSeekStepWidth(0)
,m_u16FMManualStepWidth(0)
,m_u32FMInitialLSM(0)
,m_u32LWLowestFrequency(0)
,m_u32LWHighestFrequency(0)
,m_u16LWAutoSeekStepWidth(0)
,m_u16LWManualStepWidth(0)
,m_u32LWInitialLSM(0)
,m_u32MWLowestFrequency(0)
,m_u32MWHighestFrequency(0)
,m_u16MWAutoSeekStepWidth(0)
,m_u16MWManualStepWidth(0)
,m_u32MWInitialLSM(0)
,m_u32TRFLowestFrequency(0)
,m_u32TRFHighestFrequency(0)
,m_u16TRFAutoSeekStepWidth(0)
,m_u16TRFManualStepWidth(0)
,m_u32TRFInitialLSM(0)
,m_u32WBLowestFrequency(UNUSED_INT)
,m_u32WBHighestFrequency(UNUSED_INT)
,m_u16WBAutoSeekStepWidth(UNUSED_SHORT)
,m_u16WBManualStepWidth(UNUSED_SHORT)
,m_u32WBInitialLSM(UNUSED_INT)
{
}

clBandSetupConfiguration::~clBandSetupConfiguration()
{
}

void clBandSetupConfiguration::vSerialize()
{
	m_payload.clear();
	vAddInt(m_payload , m_u32AvailableBands);
	vAddInt(m_payload , m_u32CombiBand);
	
	vAddInt(m_payload , m_u32FMLowestFrequency);
	vAddInt(m_payload , m_u32FMHighestFrequency);
	vAddShort(m_payload, m_u16FMAutoSeekStepWidth);
	vAddShort(m_payload, m_u16FMManualStepWidth);
	vAddInt(m_payload , m_u32FMInitialLSM);	
	
	vAddInt(m_payload , m_u32LWLowestFrequency);
	vAddInt(m_payload , m_u32LWHighestFrequency);
	vAddShort(m_payload, m_u16LWAutoSeekStepWidth);
	vAddShort(m_payload, m_u16LWManualStepWidth);
	vAddInt(m_payload , m_u32LWInitialLSM);
	
	vAddInt(m_payload , m_u32MWLowestFrequency);
	vAddInt(m_payload , m_u32MWHighestFrequency);
	vAddShort(m_payload, m_u16MWAutoSeekStepWidth);
	vAddShort(m_payload, m_u16MWManualStepWidth);
	vAddInt(m_payload , m_u32MWInitialLSM);
	// For WB band
	vAddInt(m_payload , m_u32WBLowestFrequency);
	vAddInt(m_payload , m_u32WBHighestFrequency);
	vAddShort(m_payload, m_u16WBAutoSeekStepWidth);
	vAddShort(m_payload, m_u16WBManualStepWidth);
	vAddInt(m_payload , m_u32WBInitialLSM);
	//For TRF band 
	vAddInt(m_payload , m_u32TRFLowestFrequency);
	vAddInt(m_payload , m_u32TRFHighestFrequency);
	vAddShort(m_payload, m_u16TRFAutoSeekStepWidth);
	vAddShort(m_payload, m_u16TRFManualStepWidth);
	vAddInt(m_payload , m_u32TRFInitialLSM);
	unsigned int u32TempFrequency = UNUSED_INT;
	unsigned short u32TempStep = UNUSED_SHORT;
	for(unsigned char i=0; i < MAX_NUMBER_UNUSED_BANDS ; i++)
	{
		vAddInt(m_payload , u32TempFrequency);
		vAddInt(m_payload , u32TempFrequency);
		vAddShort(m_payload, u32TempStep);
		vAddShort(m_payload, u32TempStep);
		vAddInt(m_payload , u32TempFrequency);
	}

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clBandSetupConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u32AvailableBands = poclConfigInterface->u32GetConfigData("AvailableBands");
	m_u32CombiBand = poclConfigInterface->u32GetConfigData("CombiBands");
	
	m_u32FMLowestFrequency = poclConfigInterface->u32GetConfigData("LowFM");
	m_u32FMHighestFrequency = poclConfigInterface->u32GetConfigData("HighFM");
	m_u16FMAutoSeekStepWidth = (tU16)poclConfigInterface->u32GetConfigData("StepSizeFM");
	m_u16FMManualStepWidth = (tU16)poclConfigInterface->u32GetConfigData("ManualStepSizeFM");
	m_u32FMInitialLSM = poclConfigInterface->u32GetConfigData("FM_LSM");
	
	m_u32LWLowestFrequency = poclConfigInterface->u32GetConfigData("LowLW");
	m_u32LWHighestFrequency = poclConfigInterface->u32GetConfigData("HighLW");
	m_u16LWAutoSeekStepWidth = (tU16)poclConfigInterface->u32GetConfigData("StepSizeLW");
	m_u16LWManualStepWidth = (tU16)poclConfigInterface->u32GetConfigData("ManualStepSizeLW");
	m_u32LWInitialLSM = poclConfigInterface->u32GetConfigData("LW_LSM");

	m_u32MWLowestFrequency = poclConfigInterface->u32GetConfigData("LowMW");
	m_u32MWHighestFrequency = poclConfigInterface->u32GetConfigData("HighMW");
	m_u16MWAutoSeekStepWidth = (tU16)poclConfigInterface->u32GetConfigData("StepSizeMW");
	m_u16MWManualStepWidth = (tU16)poclConfigInterface->u32GetConfigData("ManualStepSizeMW");
	m_u32MWInitialLSM = poclConfigInterface->u32GetConfigData("MW_LSM");
	if((poclConfigInterface->u32GetConfigData("AvailableBands") & TUN_CONFIG_DEFAULT_AVAILABLEBAND_TRF_MASKVAL ))
	{
		m_u32TRFLowestFrequency=TUN_CONFIG_DEFAULT_TRF_LOW_FREQ;
		m_u32TRFHighestFrequency= TUN_CONFIG_DEFAULT_TRF_HIGH_FREQ;
		m_u16TRFAutoSeekStepWidth= TUN_CONFIG_DEFAULT_TRF_AUTO_SEEK_STEPSIZE;
		m_u16TRFManualStepWidth= TUN_CONFIG_DEFAULT_TRF_MANUAL_STEPSIZE;
		m_u32TRFInitialLSM= TUN_CONFIG_DEFAULT_TRF_LSM_FREQ;
	}
	if((poclConfigInterface->u32GetConfigData("AvailableBands") & TUN_CONFIG_DEFAULT_AVAILABLEBAND_WB_MASKVAL ))
	{
		m_u32WBLowestFrequency=poclConfigInterface->u32GetConfigData("LowWB");
		m_u32WBHighestFrequency= poclConfigInterface->u32GetConfigData("HighWB");
		m_u16WBAutoSeekStepWidth= (tU16)poclConfigInterface->u32GetConfigData("StepSizeWB");
		m_u16WBManualStepWidth= (tU16)poclConfigInterface->u32GetConfigData("ManualStepSizeWB");
		m_u32WBInitialLSM= poclConfigInterface->u32GetConfigData("WB_LSM");
	}
}

tunerVector<unsigned char> clBandSetupConfiguration::oGetPayload()
{
	return m_payload;
}

short clBandSetupConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}
unsigned int clBandSetupConfiguration::u32GetBitPositionVal(unsigned char u8Value)
{
	unsigned int u32RetVal=1;
	return u32RetVal<< u8Value;
}

void clBandSetupConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}


void clBandSetupConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clBandSetupConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clBandSetupConfiguration::vTrace() part 2 -> \n m_u32AvailableBands = 0x%08X \n m_u32CombiBand = 0x%08X ",\
		m_u32AvailableBands,m_u32CombiBand));
	
	ETG_TRACE_USR2(( "clBandSetupConfiguration::vTrace() part 3 -> FM Band Configuration \n m_u32FMLowestFrequency = %8d kHz \n m_u32FMHighestFrequency = %8d kHz \n "\
		"m_u16FMAutoSeekStepWidth = %8d kHz \n m_u16FMManualStepWidth = %8d kHz \n m_u32FMInitialLSM = %8d kHz \n",\
		m_u32FMLowestFrequency,m_u32FMHighestFrequency,m_u16FMAutoSeekStepWidth,m_u16FMManualStepWidth,m_u32FMInitialLSM ));
	
	ETG_TRACE_USR2(( "clBandSetupConfiguration::vTrace() part 5 -> LM Band Configuration \n m_u32LWLowestFrequency = %8d kHz \n m_u32LWHighestFrequency = %8d kHz \n "\
		"m_u16LWAutoSeekStepWidth = %8d kHz \n m_u16LWManualStepWidth = %8d kHz \n m_u32LWInitialLSM = %8d kHz \n",\
		m_u32LWLowestFrequency,m_u32LWHighestFrequency,m_u16LWAutoSeekStepWidth,m_u16LWManualStepWidth,m_u32LWInitialLSM ));
	
	ETG_TRACE_USR2(( "clBandSetupConfiguration::vTrace() part 6 ->  MW Band Configuration \n m_u32MWLowestFrequency = %8d kHz \n m_u32MWHighestFrequency = %8d kHz \n "\
		"m_u16MWAutoSeekStepWidth = %8d kHz \n m_u16MWManualStepWidth = %8d kHz \n m_u32MWInitialLSM = %8d kHz \n",\
		m_u32MWLowestFrequency,m_u32MWHighestFrequency,m_u16MWAutoSeekStepWidth,m_u16MWManualStepWidth,m_u32MWInitialLSM ));
	ETG_TRACE_USR2(( "clBandSetupConfiguration::vTrace() part 6 ->  TRF Band Configuration \n TRFLowestFrequency = %8d kHz \n TRFHighestFrequency = %8d kHz \n "\
		"TRFAutoSeekStepWidth = %8d kHz \n TRFManualStepWidth = %8d kHz \n TRFInitialLSM = %8d kHz \n",\
		m_u32TRFLowestFrequency,m_u32TRFHighestFrequency,m_u16TRFAutoSeekStepWidth,m_u16TRFManualStepWidth,m_u32TRFInitialLSM ));
	ETG_TRACE_USR2(( "clBandSetupConfiguration::vTrace() part 7 ->  WB Band Configuration \n WBLowestFrequency = %8d kHz \n WBHighestFrequency = %8d kHz \n "\
		"WBAutoSeekStepWidth = %8d kHz \n WBManualStepWidth = %8d kHz \n WBInitialLSM = %8d kHz \n",\
		m_u32WBLowestFrequency,m_u32WBHighestFrequency,m_u16WBAutoSeekStepWidth,m_u16WBManualStepWidth,m_u32WBInitialLSM ));
	ETG_TRACE_USR2(( "clBandSetupConfiguration::vTrace() part 8 ->  Default values for Unused Bands \n m_u32LowestFrequency = 0x%8x \n m_u32HighestFrequency = 0x%8x \n "\
		"m_u16AutoSeekStepWidth = 0x%04x kHz \n m_u16ManualStepWidth = 0x%04x kHz \n m_u32InitialLSM = 0x%8x kHz \n NumberOfUnusedBands = %d",\
		UNUSED_INT,UNUSED_INT,UNUSED_INT,UNUSED_INT,UNUSED_INT,MAX_NUMBER_UNUSED_BANDS ));
}
