/************************************************************************
 * FILE:          clAnnouncementConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clAnnouncementConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "TunerApp/ADRConfiguration/clAnnouncementConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clAnnouncementConfiguration.cpp.trc.h"
#endif


clAnnouncementConfiguration::clAnnouncementConfiguration() :clBaseConfigSection(enAnnouncementConfiguration)
,m_u8BackgroundTA(0)
{
}

clAnnouncementConfiguration::~clAnnouncementConfiguration()
{
}

void clAnnouncementConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8BackgroundTA);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);
	vAddSectionIdToPayload(m_payload);

}

void clAnnouncementConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if((potun_Config == NULL) || (poclConfigInterface == NULL))
	{
		return;
	}

	unsigned char u8BackgroundTA = (tU8)poclConfigInterface->u32GetConfigData("MonitorFMTA");
	
	if((u8BackgroundTA & TUN_READ_MONITORFMTA_NONTP_FM) == TUN_ALLOW_BACKGROUND_TA)
	{
		m_u8BackgroundTA = m_u8BackgroundTA | TUN_SET_ZEROTH_BIT;
	}

	if(u8BackgroundTA & TUN_READ_MONITORFMTA_AM)
	{
		m_u8BackgroundTA = m_u8BackgroundTA | TUN_SET_FIRST_BIT;
	}
}

tunerVector<unsigned char> clAnnouncementConfiguration::oGetPayload()
{
	return m_payload;
}

short clAnnouncementConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clAnnouncementConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clAnnouncementConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clAnnouncementConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clAnnouncementConfiguration::vTrace() part 2 -> \n m_u8BackgroundTA = %d \n ",\
			m_u8BackgroundTA));
}
