/************************************************************************
 * FILE:         clATStationInfoConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clATStationInfoConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "TunerApp/ADRConfiguration/clATStationInfoConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clATStationInfoConfiguration.cpp.trc.h"
#endif

#define UNUSED_BYTE 0xaa

clATStationInfoConfiguration::clATStationInfoConfiguration() :clBaseConfigSection(enATStationInfoConfiguration), 
m_u8Unused1(0),
m_u8ATStationInfoSwitches(0)
{
}

clATStationInfoConfiguration::~clATStationInfoConfiguration()
{
}

void clATStationInfoConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8Unused1);
	m_payload.push_back(m_u8ATStationInfoSwitches);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clATStationInfoConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}

	m_u8Unused1 = UNUSED_BYTE;
	m_u8ATStationInfoSwitches = potun_Config->u8GetATStationInfoSwitches();
}

tunerVector<unsigned char> clATStationInfoConfiguration::oGetPayload()
{
	return m_payload;
}

short clATStationInfoConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clATStationInfoConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clATStationInfoConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clATStationInfoConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clATStationInfoConfiguration::vTrace() part 2 -> \n m_u8ATStationInfoSwitches = 0x%02X ",m_u8ATStationInfoSwitches));
}