/************************************************************************
 * FILE:          clAMFMParameterConfiguration.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clAMFMParameterConfiguration.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "TunerApp/ADRConfiguration/clAMFMParameterConfiguration.h"

#include "tun_Config.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clAMFMParameterConfiguration.cpp.trc.h"
#endif


clAMFMParameterConfiguration::clAMFMParameterConfiguration() :clBaseConfigSection(enAMFMTuningParameterConfiguration) 
,m_u8FMChannelSeperation(0)
,m_u8FMLimiting(0)               
,m_u8FMMultipath(0)              
,m_u8FMSoftmute(0)               
,m_u8AMSoftmute(0)               
,m_u8FMHicutConfiguration(0)    
,m_u8AMHicutConfiguration(0)    
,m_u8FMDeemphasis(0)             
,m_u8AMDeemphasis(0)             
,m_u8FMFrequencyResponse(0)     
,m_u8AMFrequencyResponse(0)     
,m_u8FMMiscellaneous(0)          
,m_u8AMMiscellaneous(0)          
,m_u8AMAntennaAttenuation(0)    
,m_u8FMAntennaAttenuation(0)    
,m_u8AMFMHicutExtender(0)
,m_u8FMSoftmuteTiming(0)
,m_u8AMFMMiscellaneous2(0)
,m_u8FMHicutExtenderFieldstrengthThreshold(0)
,m_u8FMHicutExtenderFilterOffset(0)
,m_u8FMChannelSeperationMaximum(0)
,m_u8FMChannelSeperationTiming(0)
,m_u8FMHicutFieldstrengthThreshold(0)
,m_u8FMHicutTiming(0)
,m_u8DMQSensitivity(0)
,m_u8FMDeviationAdaptation(0)
,m_u8AMNoiseBlanker228kHzSensitivity(0)
,m_u8AMNoiseBlanker45_6kHzSensitivity(0)
,m_u8AMHicutExtenderFieldStrengthThreshold(0)
,m_u8AMHicutExtenderFilterOffset(0)
{
}

clAMFMParameterConfiguration::~clAMFMParameterConfiguration()
{
}

void clAMFMParameterConfiguration::vSerialize()
{
	m_payload.clear();
	m_payload.push_back(m_u8FMChannelSeperation);
	m_payload.push_back(m_u8FMLimiting);               
	m_payload.push_back(m_u8FMMultipath);              
	m_payload.push_back(m_u8FMSoftmute);               
	m_payload.push_back(m_u8AMSoftmute);               
	m_payload.push_back(m_u8FMHicutConfiguration);    
	m_payload.push_back(m_u8AMHicutConfiguration);    
	m_payload.push_back(m_u8FMDeemphasis);             
	m_payload.push_back(m_u8AMDeemphasis);             
	m_payload.push_back(m_u8FMFrequencyResponse);     
	m_payload.push_back(m_u8AMFrequencyResponse);     
	m_payload.push_back(m_u8FMMiscellaneous);          
	m_payload.push_back(m_u8AMMiscellaneous);          
	m_payload.push_back(m_u8AMAntennaAttenuation);    
	m_payload.push_back(m_u8FMAntennaAttenuation);    
	m_payload.push_back(m_u8AMFMHicutExtender);
	m_payload.push_back(m_u8FMSoftmuteTiming);
	m_payload.push_back(m_u8AMFMMiscellaneous2);
	m_payload.push_back(m_u8FMHicutExtenderFieldstrengthThreshold);
	m_payload.push_back(m_u8FMHicutExtenderFilterOffset);
	m_payload.push_back(m_u8FMChannelSeperationMaximum);
	m_payload.push_back(m_u8FMChannelSeperationTiming);
	m_payload.push_back(m_u8FMHicutFieldstrengthThreshold);
	m_payload.push_back(m_u8FMHicutTiming);
	m_payload.push_back(m_u8DMQSensitivity);
	m_payload.push_back(m_u8FMDeviationAdaptation);
	m_payload.push_back(m_u8AMNoiseBlanker228kHzSensitivity);
	m_payload.push_back(m_u8AMNoiseBlanker45_6kHzSensitivity);
	m_payload.push_back(m_u8AMHicutExtenderFieldStrengthThreshold);
	m_payload.push_back(m_u8AMHicutExtenderFilterOffset);

	m_u16NumberOfBytesInSection = (tU16)m_payload.size();

	vAddNumberOfBytesInSectionToPayload(m_payload);	
	vAddSectionIdToPayload(m_payload);
	
}

void clAMFMParameterConfiguration::vSetParameters(tun_Config* potun_Config, clConfigInterface* poclConfigInterface)
{
	if(potun_Config == NULL)
	{
		return;
	}

	if(poclConfigInterface == NULL)
	{
		return;
	}

	
	m_u8FMChannelSeperation = (tU8)poclConfigInterface->u32GetConfigData("ADRFmChannelSeparation");
	m_u8FMLimiting = (tU8)poclConfigInterface->u32GetConfigData("ADRFmLimiting");
	m_u8FMMultipath = (tU8)poclConfigInterface->u32GetConfigData("ADRFmMultipath");
	m_u8FMSoftmute = (tU8)poclConfigInterface->u32GetConfigData("ADRFmSoftMute");
	m_u8AMSoftmute = (tU8)poclConfigInterface->u32GetConfigData("ADRAmSoftMute");
	m_u8FMHicutConfiguration = (tU8)poclConfigInterface->u32GetConfigData("ADRFmHighCut");
	m_u8AMHicutConfiguration = (tU8)poclConfigInterface->u32GetConfigData("ADRAM_Hicut_Configuration");
	m_u8FMDeemphasis = (tU8)poclConfigInterface->u32GetConfigData("ADRFmDeemphasis");
	m_u8AMDeemphasis = (tU8)poclConfigInterface->u32GetConfigData("ADRAMDeemphasis");
	m_u8FMFrequencyResponse = (tU8)poclConfigInterface->u32GetConfigData("ADRFmFrequencyResponse");
	m_u8AMFrequencyResponse = (tU8)poclConfigInterface->u32GetConfigData("ADRAmFrequencyResponse");
	m_u8FMMiscellaneous = (tU8)poclConfigInterface->u32GetConfigData("ADRFmMisc");
	m_u8AMMiscellaneous = (tU8)poclConfigInterface->u32GetConfigData("ADRAmMisc");


	m_u8AMAntennaAttenuation = (tU8)poclConfigInterface->u32GetConfigData("ADRFmAmplificationLevel");
	m_u8FMAntennaAttenuation = (tU8)poclConfigInterface->u32GetConfigData("ADRAmAmplificationLevel");

	m_u8AMFMHicutExtender = (tU8)poclConfigInterface->u32GetConfigData("AMFMHicutExtender");
	m_u8FMSoftmuteTiming = (tU8)poclConfigInterface->u32GetConfigData("FMSoftMuteTiming");
	m_u8AMFMMiscellaneous2 = (tU8)poclConfigInterface->u32GetConfigData("AMFMMisscellaneous2");
	m_u8FMHicutExtenderFieldstrengthThreshold = (tU8)poclConfigInterface->u32GetConfigData("FMHicutExtenderFieldstrengthThreshold");
	m_u8FMHicutExtenderFilterOffset = (tU8)poclConfigInterface->u32GetConfigData("FMHicutExtenderFieldstrengthFilterOffset");
	m_u8FMChannelSeperationMaximum = (tU8)poclConfigInterface->u32GetConfigData("FMChannelSeperationMaximum");
	m_u8FMChannelSeperationTiming = (tU8)poclConfigInterface->u32GetConfigData("FMChannelSeperationTiming");
	m_u8FMHicutFieldstrengthThreshold = (tU8)poclConfigInterface->u32GetConfigData("FMHicutFieldstrengthThreshold");
	m_u8FMHicutTiming = (tU8)poclConfigInterface->u32GetConfigData("FMHicutTiming");
	m_u8DMQSensitivity = (tU8)poclConfigInterface->u32GetConfigData("FMDMQSensitivity");
	m_u8FMDeviationAdaptation = (tU8)poclConfigInterface->u32GetConfigData("FMDeviationAdaption");
	m_u8AMNoiseBlanker228kHzSensitivity = (tU8)poclConfigInterface->u32GetConfigData("AMNoiseBlanker228kHzSensitivity");
	m_u8AMNoiseBlanker45_6kHzSensitivity = (tU8)poclConfigInterface->u32GetConfigData("AMNoiseBlanker45_6kHzSensitivity");
	m_u8AMHicutExtenderFieldStrengthThreshold = (tU8)poclConfigInterface->u32GetConfigData("AMHicutExtenderFieldstrengthThreshold");
	m_u8AMHicutExtenderFilterOffset = (tU8)poclConfigInterface->u32GetConfigData("AMHicutExtenderFieldstrengthFilterOffset");
}

tunerVector<unsigned char> clAMFMParameterConfiguration::oGetPayload()
{
	return m_payload;
}

short clAMFMParameterConfiguration::u16GetSize()
{
	return m_u16NumberOfBytesInSection;
}

void clAMFMParameterConfiguration::vConstruct(tunerVector<unsigned char> /*bitStream*/)
{

}

void clAMFMParameterConfiguration::vTrace()
{
	ETG_TRACE_USR2(( "clAMFMParameterConfiguration::vTrace() part 1 -> \n************************************\n* Section Id \t\t\t\t\t= %d *\n"\
					 "* m_u16NumberOfBytesInSection = %2d *\n************************************",m_enSectionID,m_u16NumberOfBytesInSection ));

	ETG_TRACE_USR2(( "clAMFMParameterConfiguration::vTrace() part 2 -> \n m_u8FMChannelSeperation = 0x%02X \n m_u8FMLimiting = 0x%02X \n "\
		"m_u8FMMultipath = 0x%02X \n m_u8FMSoftmute = 0x%02X \n m_u8AMSoftmute = 0x%02X \n",\
		m_u8FMChannelSeperation,m_u8FMLimiting,m_u8FMMultipath,m_u8FMSoftmute,m_u8AMSoftmute ));
 
	ETG_TRACE_USR2(( "clAMFMParameterConfiguration::vTrace() part 3 -> \n m_u8FMHicutConfiguration = 0x%02X \n m_u8AMHicutConfiguration = 0x%02X \n "\
		"m_u8FMDeemphasis = 0x%02X \n m_u8AMDeemphasis = 0x%02X \n m_u8FMFrequencyResponse = 0x%02X \n",\
		m_u8FMHicutConfiguration,m_u8AMHicutConfiguration,m_u8FMDeemphasis,m_u8AMDeemphasis,m_u8FMFrequencyResponse ));
	
	ETG_TRACE_USR2(( "clAMFMParameterConfiguration::vTrace() part 4 -> \n m_u8AMFrequencyResponse = 0x%02X \n m_u8FMMiscellaneous = 0x%02X \n "\
		"m_u8AMMiscellaneous = 0x%02X \n m_u8AMAntennaAttenuation = 0x%02X \n m_u8FMAntennaAttenuation = 0x%02X \n",\
		m_u8AMFrequencyResponse,m_u8FMMiscellaneous,m_u8AMMiscellaneous,m_u8AMAntennaAttenuation,m_u8FMAntennaAttenuation ));
	
	ETG_TRACE_USR2(( "clAMFMParameterConfiguration::vTrace() part 5 -> \n m_u8AMFMHicutExtender = 0x%02X \n m_u8FMSoftmuteTiming = 0x%02X \n "\
		"m_u8AMFMMiscellaneous2 = 0x%02X \n m_u8FMHicutExtenderFieldstrengthThreshold = 0x%02X \n m_u8FMHicutExtenderFilterOffset = 0x%02X \n",\
		m_u8AMFMHicutExtender,m_u8AMFMMiscellaneous2,m_u8AMMiscellaneous,m_u8FMHicutExtenderFieldstrengthThreshold,m_u8FMHicutExtenderFilterOffset ));
	
	ETG_TRACE_USR2(( "clAMFMParameterConfiguration::vTrace() part 6 -> \n m_u8FMChannelSeperationMaximum = 0x%02X \n m_u8FMChannelSeperationTiming = 0x%02X \n "\
		"m_u8FMHicutFieldstrengthThreshold = 0x%02X \n m_u8FMHicutTiming = 0x%02X \n m_u8DMQSensitivity = 0x%02X \n",\
		m_u8FMChannelSeperationMaximum,m_u8FMChannelSeperationTiming,m_u8FMHicutFieldstrengthThreshold,m_u8FMHicutTiming,m_u8DMQSensitivity ));
	
	ETG_TRACE_USR2(( "clAMFMParameterConfiguration::vTrace() part 7 -> \n m_u8FMDeviationAdaptation = 0x%02X \n m_u8AMNoiseBlanker228kHzSensitivity = 0x%02X \n "\
		"m_u8AMNoiseBlanker45_6kHzSensitivity = 0x%02X \n m_u8AMHicutExtenderFieldStrengthThreshold = 0x%02X \n m_u8AMHicutExtenderFilterOffset = 0x%02X \n",\
		m_u8FMDeviationAdaptation,m_u8AMNoiseBlanker228kHzSensitivity,m_u8AMNoiseBlanker45_6kHzSensitivity,m_u8AMHicutExtenderFieldStrengthThreshold,m_u8AMHicutExtenderFilterOffset ));
}