/***********************************************************************
* FILE:           tuner_main.cpp
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Tuner Server
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------

* HISTORY:      
* Date      | Author                       | Modification
* 17.10.04  | CM-DI/ESA2 Wersuhn           | initial version
* 14.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Configured as Tuner server.
*
*************************************************************************/

/* ---
read "---" comments to know what the code does
--- */

/* +++
read "+++" comments to know what you have to implement
+++ */

/* +++
Please recplace "ccademo_" in class names and function names by your application's prefix
+++ */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"       


/*****************************************************************************
 * ETG trace
 * 0x2601:    TUN_TRACE_CLASS_TUNAPP
 ****************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/tun_main.cpp.trc.h"
#endif


//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 

#include "tun_defines.h"
#include "tun_SPM_Client.h"
#include "tun_VdClockClient.h"
#include "tun_SensorClient.h"
#include "tun_Config.h"

#include "tun_Utility.h"

#include "tun_ActualData.h"



#include "tun_MsgToADR.h"
#include "tun_Manager.h"

#include "tun_HMIManager.h"
#include "tun_MsgToHMI.h"
#include "tun_MsgtoTunMaster.h"
#include "tun_MsgDispatcher.h"

#include "tun_MessageQ.h"
#include "tun_RUIF_WaitingThread.h"

#include "tun_MsgFromHMI.h"

#include "tun_MsgToHMI.h"
#include "tun_service.h"

#include "tun_DrvAdrIf.hpp"

#include "tun_main.h"

#include "tun_trace.h"
#include "tun_MsgDefines.h"
#include "tun_PrjConfig.h"
#include "tun_DiagManager.h"
#include "tun_Diagnostics.h"
#include "tun_Diaglog.h"
#include "tun_diaghandler.h"
#include "kdsconfig/clConfigMain.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include <errno.h>
#include <sstream>
#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#include "config/dp_tclTunerImpl.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20

#include "AMFMTuner/clTmcTuner_Method_AudioDevice.h"

#ifdef VARIANT_S_FTR_ENABLE_DRM
#include "AMFMTuner/clTmcTuner_Method_SetDrmSrcActivity.h"
#include "Aars/clAars_DRMAudioStreamDecoderStatus.h"
#include "Aars/clAars_CM_DRMCurrentRadiotext.h"
#include "Aars/clAars_DRMTestMode.h"
#include "Aars/clAars_CM_ATDRM_AudioServiceDirect.h"
#include "AMFMTuner/clTmcTuner_Property_DrmRadioText.h"
#include "AMFMTuner/clTmcTuner_Method_DRM_TestMode.h"
#include "AMFMTuner/clTmcTuner_Property_DRM_TestMode.h"
#include "AMFMTuner/clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM.h"
#include "Aars/clAars_DRMLogicalFrame.h"
#include "AMFMTuner/clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER.h"
#endif

#include "AMFMTuner/clTmcTuner_Method_S_AUDIO_FG_BG_NEW.h"
#include "AMFMTuner/clTmcTuner_Method_SetDemodulationSwitch.h"
#include "AMFMTuner/clTmcTuner_Method_S_GET_STATIC_LIST.h"
#include "AMFMTuner/clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST.h"
#include "AMFMTuner/clTmcTuner_Method_S_PRESET_HANDLING.h"
#include "AMFMTuner/clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE.h"
#include "AMFMTuner/clTmcTuner_Property_G_GET_STATIC_LIST.h"
#include "AMFMTuner/clTmcTuner_Property_DemodulationSwitchStatus.h"
#include "AMFMTuner/clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM.h"
#include "AMFMTuner/clTmcTuner_Property_G_HD_AUDIOPRGM.h"


#include "AMFMTuner/clTmcTuner_Property_G_HD_LONGNAME.h"
#include "AMFMTuner/clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE.h"
#include "AMFMTuner/clTmcTuner_Property_G_HD_TEST_MODE_DATA.h"
#include "AMFMTuner/clTmcTuner_Method_S_GET_CONFIG_LIST.h"
#include "AMFMTuner/clTmcTuner_Property_G_GET_CONFIG_LIST.h"
#include "AMFMTuner/clTmcTuner_Method_S_STATIONLIST_EXIT.h"
#include "AMFMTuner/clTmcTuner_Method_S_CONFIGLIST_UPDATE.h"
#include "AMFMTuner/clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS.h"
#include "AMFMTuner/clTmcTuner_Method_S_Set_AF.h"
#include "AMFMTuner/clTmcTuner_Property_G_Mute_Request.h"
#include "AMFMTuner/clTmcTuner_Method_S_AudioMuteRequest.h"
#include "AMFMTuner/clTmcTuner_Method_S_SEL_LIST_ELEM.h"
#include "AMFMTuner/clTmcTuner_Method_G_SEL_LIST_ELEM.h"
#include "AMFMTuner/clTmcTuner_Method_S_SET_PI.h"
#include "AMFMTuner/clTmcTuner_Property_G_SET_PI.h"
#include "AMFMTuner/clTmcTuner_Method_S_SEEK.h"
#include "AMFMTuner/clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT.h"
#include "AMFMTuner/clTmcTuner_Method_S_DIRECT_FREQUENCY.h"
#include "AMFMTuner/clTmcTuner_Property_G_SEEK.h"
#include "AMFMTuner/clTmcTuner_Property_G_DIRECT_FREQUENCY.h"
#include "TunerApp/StationNameJapan/clJapanStationName.h"
#include "AMFMTuner/clTmcTuner_Method_S_JAPAN_SET_AREA.h"
#include "AMFMTuner/clTmcTuner_Property_G_JAPAN_AREA.h"
#include "AMFMTuner/clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME.h"
#include "AMFMTuner/clTmcTuner_Method_S_LANGUAGE_SETTING.h"
#include "AMFMTuner/clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME.h"
#include "AMFMTuner/clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.h"
#include "AMFMTuner/clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE.h"
#include "AMFMTuner/clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER.h"
#include "AMFMTuner/clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT.h"
#include "AMFMTuner/clTmcTuner_Property_G_AUDIO_SPLIT_MODE.h"
#include "AMFMTuner/clTmcTuner_Property_G_HD_SECTION_PARAMETER.h"
#include "AMFMTuner/clTmcTuner_Property_G_CALIBRATION_DATA.h"
#include "AMFMTuner/clTmcTuner_Method_S_CHANGE_LSM.h"
#include "AMFMTuner/clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE.h"
#include "AMFMTuner/clTmcTuner_Property_G_LISTUPDATE_NOTIFICATION.h"
#include "AMFMTuner/clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS.h"
#include "AMFMTuner/clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE.h"
#include "AMFMTuner/clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.h"
#include "AMFMTuner/clTmcTuner_Property_G_GET_DARC_DATA.h"
#include "AMFMTuner/clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID.h"
#include "AMFMTuner/clTmcTuner_Method_S_DISABLE_BAND.h"
#include "AMFMTuner/clTmcTuner_Method_S_USER_PROFILE_UPDATE.h"
#include "AMFMTuner/clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE.h"
#include "AMFMTuner/clHDImageMemoryManagement.h"
#include "Aars/clAars_MTCAudioSource.h"
#include "Aars/clAars_AudioSource.h"
#include "Aars/clAars_SpecialDiagnosisMode.h"
#include "Aars/clAars_ATHDLongName.h"
#include "Aars/clAars_ATHDImageFileUpdate.h"
#include "Aars/clAars_HDTestMode.h"
#include "Aars/clAars_DemodulationSwitch.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "Aars/clAars_ATPresetListSetActive.h"
#include "Aars/clAars_ATPresetSave.h"
#include "Aars/clAars_HDFirmwareInfo.h"
#include "Aars/clAars_ATHDAudioProgram.h"
#include "TunerApp/clTmcTuner_HDFirwareInfo_Update.h"
#include "Aars/clAars_ATPreparePresetStorage.h"
#include "Aars/clAars_CM_StationsList.h"
#include "TunerApp/clTmcTuner_SetConfigSections.h"
#include "Aars/clAars_SetConfigSections.h"
#include "Aars/clAars_CM_StationListConfig.h"
#include "Aars/clAars_CM_StationListRelease.h"
#include "Aars/clAars_CM_UpdateLandscape.h"
#include "Aars/clAars_CM_UpdateLandscapeProgress.h"
#include "Aars/clAars_CM_Commit.h"
#include "Aars/clAars_AFBestSwitch.h"
#include "Aars/clAars_ATTunerState.h"
#include "TunerApp/Mute/MuteHandling/clMuteControl.h"
#include "Aars/clAars_ATPI.h"
#include "Aars/clAars_ATSeek.h"
#include "Aars/clAars_ATHDAudioProgramDirect.h"
#include "Aars/clAars_ATFrequency.h"
#include "Aars/clAars_CM_EvaluationParameter.h"
#include "Aars/clAars_CM_CalibrationData.h"
#include "Aars/clAars_CM_ChangeOfSurveilledStations.h"
#include "Aars/clAars_CM_ChangeLsm.h"
#include "Aars/clAars_CM_DARC_SetFrequency.h"
#include "Aars/clAars_CM_DARCGetData.h"
#include "kdsconfig/clConfigInterface.h"
#include "Aars/clAars_CM_SetUserOptions.h"
#include "Aars/clAars_CM_CopyUserContent.h"
#include "Aars/clAars_CM_PresetListContentUpdate.h"
#endif
#include "TunerApp/TraceHandler/HandleTTFISCommands.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "TunerApp/clTmcTuner_stationLogo_map.h"
#include "AMFMTuner/clTmcTuner_Property_AtPiSearch.h"
#include "Aars/clAars_AtPiSearch.h"
#include "Aars/clAars_EnhancedTestMode.h"
#include "AMFMTuner/clTmcTuner_Method_S_TESTMODE.h"
#include "Aars/clAars_CM_AdditionalVersionInfo.h"
#include "TunerApp/clTmcTuner_AdditionalVersionInfo_Update.h"
#include "TunerApp/clTmcTuner_GetConfigurationInfoStatus.h"
#include "Aars/clAars_GetConfigurationInfo.h"
#include "AMFMTuner/clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY.h"

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
#include "AarsDBusProxy/tuner_gio_dbus_handler.h"
#endif

#include <fcntl.h>
#include <unistd.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
//#include "trcGenProj/Header/tuner_tclApp.cpp.trc.h"
#endif



OSAL_tSemHandle tuner_tclApp::_hNotTableSem  = OSAL_C_INVALID_HANDLE;
OSAL_tSemHandle tuner_tclApp::_hADRDataUpdateSem  = OSAL_C_INVALID_HANDLE;
OSAL_tTimerHandle tuner_tclApp::_hTimerHandler = 0;
OSAL_tTimerHandle  tuner_tclApp::m_hDoNotfication_1secTimer = 0;

tBool           tuner_tclApp::_bAppClosed    = FALSE;
tuner_tclApp* tuner_tclApp::_poExemplar      = NULL;

tuner_tclApp* tuner_tclApp::_theServer = NULL;

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::theServer
 *
 *DESCRIPTION:  create new server object
 *             
 *PARAMETER:    None
 *
 *RETURNVALUE:  tuner_tclApp* _theServer
 *
 *HISTORY:
 *27.01.07 kol2hi
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tuner_tclApp*
tuner_tclApp::theServer()
{
	ETG_TRACE_USR4(("theServer()"));
	if (_theServer == NULL)
   {
      _theServer = new tuner_tclApp();
#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
      _theServer->m_potun_tclINCComm = new tun_INCComm();
      _theServer->m_potun_tclINCComm->vSet_tuner_tclApp(_theServer);
#endif
	  tS32 s32OsalError = OSAL_s32TimerCreate((OSAL_tpfCallback)VTimeoutCallback,
		  (tPVoid)_theServer, &_hTimerHandler);
	tS32 u32OsalError = OSAL_s32TimerCreate( ( OSAL_tpfCallback )VTimeoutCallback_ForDoNotfication_1secTimer,
			( tPVoid )_theServer, &m_hDoNotfication_1secTimer );
	  if (s32OsalError == OSAL_ERROR)
	  {
		  NORMAL_M_ASSERT(s32OsalError != OSAL_ERROR);
	  }
	  if (u32OsalError == OSAL_ERROR)
	  {
		  NORMAL_M_ASSERT(u32OsalError != OSAL_ERROR);
	  }

   }
	ETG_TRACE_USR4(("theServer() end"));
   return _theServer;
}

OSAL_tpfCallback tuner_tclApp::VTimeoutCallback_ForDoNotfication_1secTimer(tVoid* pArg)
{
	ETG_TRACE_USR4(("VTimeoutCallback_ForDoNotfication_1secTimer"));
	tuner_tclApp* potuner_tclApp;
	potuner_tclApp = (tuner_tclApp*) pArg;

	potuner_tclApp->m_poclTmcTuner_GetConfigurationInfoStatus->vDoNotification();
	potuner_tclApp->m_potun_MsgToHMI->vSetFMActivePresetListId(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)enBand_FM));
	potuner_tclApp->m_potun_MsgToHMI->vSetAMActivePresetListId(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)enBand_MW));

	return 0;
}

/*************************************************************************
*************************************************************************/
tVoid tuner_tclApp::VSetTime_ForDoNotfication_1secTimer( tU32 u32MsTimeout)
{
	//Timer active
	ETG_TRACE_USR4(("VSetTime_ForDoNotfication_1secTimer()"
		"u32MsTimeout=%d",
		u32MsTimeout
		));
	(tVoid)OSAL_s32TimerSetTime( m_hDoNotfication_1secTimer,u32MsTimeout , 0 );
}

OSAL_tpfCallback tuner_tclApp::VTimeoutCallback(tVoid* /*pArg*/)
{
	ETG_TRACE_USR4(("VTimeoutCallback::TimerValue:%d",_theServer->m_enRestartTimeValue));
#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
	if(_theServer->m_enRestartTimeValue==enDgramSendError)
	{
		//If adr3 is alive and cm_startup is rx
		if(tun_DrvAdrIf::instance()->bIsAdrCommunicationRunning())
		{
		/*need to reset value as this is checked in function vSendNextMessageFromQueue */
		_theServer->m_enRestartTimeValue=enNoError;
		_theServer->m_ptun_MsgToADR->vSendNextMessageFromQueue();
		}
		//If adr3 is dead or waiting for cm_startupmsg
		else
		{
			ETG_TRACE_USR4(("VTimeoutCallback::dont send any msg, msg will be sent after rx the cm_startup msg"));
		}

	}
	else if(_theServer->m_enRestartTimeValue==enIntialTimerValue)
	{
		_theServer->m_enRestartTimeValue=enNoError;
		tun_DrvAdrIf::instance()->vStartCommunication();
		_theServer->m_potun_tclINCComm->vOpenINCCommunication();
	}
	else
	{
		ETG_TRACE_ERRMEM(("VTimeoutCallback::received with m_enRestartTimeValue : %d", _theServer->m_enRestartTimeValue));
		_theServer->m_enRestartTimeValue=enNoError;
		if(_theServer->m_potun_tclINCComm->m_nADRSocketFd < 0)
		{
			ETG_TRACE_ERRMEM(("VTimeoutCallback::Creating new socket, existing socket id : %d", _theServer->m_potun_tclINCComm->m_nADRSocketFd));
			_theServer->m_potun_tclINCComm->vOpenINCCommunication();
		}
	}
#endif
	return 0;
}
/*************************************************************************
*
* FUNCTION: tuner_tclApp::tuner_tclApp()
* 
* DESCRIPTION: 
*
*  Constructor: - Initialize AMT, create Sem, create notification table 
* 
*
* PARAMETER: void
*
* RETURNVALUE: none
*
*************************************************************************/
tuner_tclApp::tuner_tclApp() :fInitializationComplete( FALSE )
{
   /* ---
   initialize the AMT/CCA framework for this component
   --- */
	ETG_TRACE_USR4(("tuner_tclApp()"));
   ET_TRACE_OPEN; 

   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP, ET_EN_T16 _ TUN_TRACE_TUNAPP_CONSTRUCTOR _ ET_EN_DONE);

   _fdTrace = OSAL_ERROR;
   m_hPWMDutyCycle = -1;
   m_hPWMPeriod = -1;
   
   m_hPWMSync1DutyCycle = -1;
   m_hPWMSync1Period = -1;
   
   m_hPWMSync3DutyCycle = -1;
   m_hPWMSync3Period = -1;
   
   m_bTunerSrvStatus = false;
   m_u32Freq = 0;
   m_u16PWMValue = 0;
   
   m_u32Sync1Freq = 0;
   m_u16Sync1PWMValue = 0;
   
   m_u32Sync3Freq = 0;
   m_u16Sync3PWMValue = 0;
   
   m_u16TPEGRegID = 0x00;
   m_u16TMRegID = 0x00;
   m_u16UIRegID = 0x00;
   m_enRestartTimeValue=enIntialTimerValue;
   m_potun_TMCManager = NULL;

#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
	   m_potun_tclINCComm = NULL;
#endif

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   m_poclAars_SpecialDiagnosisMode = NULL;
   m_poclAars_SpecialDiagnosisMode = NULL;
   m_poclAars_ATPresetList_XX = NULL;
   m_poclAars_ATPresetListSetActive = NULL;
   m_poclTmcTuner_Property_G_GET_STATIC_LIST = NULL;
   m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST = NULL;
   m_poclTmcTuner_Method_S_PRESET_HANDLING = NULL;
   m_poclTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE = NULL;
   m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID = NULL;
   m_poclTmcTuner_Method_S_GET_STATIC_LIST = NULL;
   m_poclTmcTuner_AdditionalVersionInfo_Update = NULL;
   m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST = NULL;
   m_poclTmcTuner_Method_S_LANGUAGE_SETTING = NULL;
   m_poclTmcTuner_Property_AtPiSearch = NULL;
   m_poclTmcTuner_Property_G_CALIBRATION_DATA = NULL;
   m_poclTmcTuner_GetConfigurationInfoStatus = NULL;
   m_poclTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE = NULL;
   m_poclTmcTuner_Method_S_JAPAN_SET_AREA = NULL;
   m_poclJapanStationName = NULL;
   m_poclAars_CM_SetUserOptions = NULL;
   m_poclTmcTuner_Method_S_CHANGE_LSM = NULL;
   m_poclTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE = NULL;
   m_poclTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS = NULL;
   m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE = NULL;
   m_poclTmcTuner_Property_G_AUDIO_SPLIT_MODE = NULL;
   m_poclTmcTuner_Property_G_HD_SECTION_PARAMETER = NULL;
   m_poclAars_CM_PresetListContentUpdate = NULL;
   m_poclTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE = NULL;
   m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE = NULL;
   m_poclAars_CM_CopyUserContent = NULL;
   m_poclTmcTuner_Property_G_JAPAN_AREA = NULL;
   m_poclTmcTuner_Property_G_GET_DARC_DATA = NULL;
   m_poclTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME = NULL;
   m_poclTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME = NULL;
   m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST = NULL;
   m_poclTmcTuner_Property_G_LISTUPDATE_NOTIFICATION = NULL;
   m_poclAars_ATFrequency = NULL;
   m_poclTmcTuner_Method_S_SET_HD_SECTION_PARAMETER = NULL;
   m_poclTmcTuner_Property_G_DIRECT_FREQUENCY = NULL;
   m_poclTmcTuner_Method_S_SET_PI = NULL;
   m_poclTmcTuner_Property_G_SET_PI = NULL;
   m_poclTmcTuner_Method_S_DIRECT_FREQUENCY = NULL;
   m_poclTmcTuner_Property_G_SEEK = NULL;
   m_poclTmcTuner_Method_S_SEEK = NULL;
   m_poclAars_ATSeek = NULL;
   m_poclTmcTuner_Property_G_HD_TEST_MODE_DATA = NULL;
   m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE = NULL;
   m_poclTmcTuner_Property_G_HD_LONGNAME = NULL;
   m_poclTmcTuner_Property_G_HD_AUDIOPRGM = NULL;
   m_poclTmcTuner_SetConfigSections = NULL;
   m_poclAars_ATPI = NULL;
   m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW = NULL;
   m_poclTmcTuner_Property_G_Mute_Request = NULL;
   m_poclTmcTuner_Method_S_AudioMuteRequest = NULL;
   m_poclTmcTuner_Method_S_STATIONLIST_EXIT = NULL;
   m_poclTmcTuner_Method_G_SEL_LIST_ELEM = NULL;
   m_poclTmcTuner_Method_S_SEL_LIST_ELEM = NULL;
   m_poclTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS = NULL;
   m_poclTmcTuner_Property_DemodulationSwitchStatus = NULL;
   m_poclTmcTuner_Property_G_GET_CONFIG_LIST = NULL;
   m_poclTmcTuner_Method_SetDemodulationSwitch = NULL;
   m_poclTmcTuner_Method_S_Set_AF = NULL;
   m_poclTmcTuner_Method_S_CONFIGLIST_UPDATE = NULL;
   m_poclTmcTuner_Method_S_GET_CONFIG_LIST = NULL;
   m_poclAars_ATPreparePresetStorage = NULL;
   m_poclAars_ATPresetSave = NULL;
   m_poclAars_ATHDAudioProgramDirect = NULL;
   m_poclAars_CM_ChangeOfSurveilledStations = NULL;
   m_poclHDStationLogoManagement = NULL;
   m_poclAars_ATHDAudioProgram = NULL;
   m_poclAars_HDTestMode = NULL;
   m_potun_tclVdClockClient = NULL;
   m_poclAars_CM_StationListConfig = NULL;
   m_poclAars_GetConfigurationInfo = NULL;
   m_poclAars_ATHDImageFileUpdate = NULL;
   m_poclAars_EvaluationParameter = NULL;
   m_poclAars_CM_StationsList = NULL;
   m_poclAars_CM_ChangeLsm = NULL;
   m_poclAars_CM_StationListRelease = NULL;
   m_poclAars_ATHDLongName = NULL;
   m_poclclAars_CM_CalibrationData = NULL;
   m_potun_tclSensorClient = NULL;
   m_poclTmcTuner_stationLogo_map = NULL;
   m_poclAars_AdditionalVersionInfo = NULL;
   m_poclTmcTuner_GetConfigurationInfoStatus = NULL;
   m_poclAars_CM_UpdateLandscape = NULL;
   m_poclAars_CM_UpdateLandscapeProgress = NULL;
   m_poclAars_CM_Commit = NULL;
   m_poclAars_SetConfigSections = NULL;
   m_poclAars_AFBestSwitch = NULL;
   m_poclAars_ATTunerState = NULL;
   m_poclAars_CM_DARC_SetFrequency = NULL;
   m_poclAars_CM_DARCGetData = NULL;
   m_poclTmcTuner_Method_S_DISABLE_BAND = NULL;
   m_poclAars_MTCAudioSource = NULL;
   m_poclAars_AudioSource = NULL;

#ifdef VARIANT_S_FTR_ENABLE_DRM
   m_poclTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM = NULL;
   m_poclTmcTuner_Method_DRM_TestMode = NULL;
   m_poclTmcTuner_Property_DrmRadioText = NULL;
   m_poclTmcTuner_Method_DRM_ResetMuteCounter = NULL;
   m_poclTmcTuner_Property_DRM_TestMode = NULL;
   m_poclAars_DRMTestMode = NULL;
   m_poclAars_CM_ATDRM_AudioServiceDirect = NULL;
   m_poclAars_DRMAudioStreamDecoderStatus = NULL;
   m_poclAars_CM_DRMCurrentRadiotext = NULL;
#endif

#endif
   m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY = NULL;

   m_poclAars_AtPiSearch = NULL;
   m_podp_tclTunerImpl = NULL;
   m_poPortMngr = NULL;
   m_potun_HMIManager = NULL;
   amt_bInit();
   
   /* ---
   create semaphore for protecting NotificationTable
   --- */
   tS32 s32Ret = OSAL_s32SemaphoreCreate(TUNER_NOTTABLE_SEM_NAME, &_hNotTableSem, 1);
   ETG_TRACE_USR4(("tuner_tclApp() s32Ret=%d",s32Ret));

   /**tpo protect the data from ADR if it is too fast.*/
   s32Ret = OSAL_s32SemaphoreCreate(TUNER_RECV_DATA_FROM_ADR_SEM_NAME, &_hADRDataUpdateSem, 1);
   ETG_TRACE_USR4(("tuner_tclApp() s32Ret=%d",s32Ret));
      
   /* ---
   create NotificationTable.
   Here we store information about all registered clients
   --- */
   _poNotTable = new ahl_tclNotificationTable(TUNER_FUNCARRAY_SIZE);

   /* ---
   create the cca service handler. 
   It analyses the received cca messages and calls the corresponding handler function
   --- */
   _tuner_poCCAService = new tuner_tclservice(this);

   /* +++
  HERE YOU CAN INITIALIZE YOUR APPLICATION 
  - start your threads
  - register your call backs
  - create anything you need
  +++ */

   /* class tuner_tclApp* can be accessed from static functions */
   _poExemplar = this;

   m_potun_DiagManager = NULL;
   m_potun_DiaglogHandler = NULL;
   m_potun_MsgFromDiag = NULL;
   m_potun_MsgFromHMI = NULL;
   m_potun_MsgToHMI = NULL;
   m_potun_tclDiagHandler = NULL;
   m_potun_tclSPMClient = NULL;
   m_poHandleTTFISCommands = NULL;
   /*--------------------------------------*/
   /* Initialize the tuner component here  */
   /*--------------------------------------*/
   if( !fInitializationComplete )
   {
      vInitializeTunerComponent( );

      fInitializationComplete = TRUE;
   }
   
   /*-----------------------------------*/
   /* Register with the trace component */
   /*-----------------------------------*/
   if(_poExemplar == NULL || m_poHandleTTFISCommands==NULL)
   {
      NORMAL_M_ASSERT(_poExemplar != NULL);
      NORMAL_M_ASSERT(m_poHandleTTFISCommands != NULL);
      return;
   }
   _poExemplar ->m_poHandleTTFISCommands->vRegisterInTraceCmdService();

   m_poPortMngr = new ahl_tclServerPortMngr(this);

   std::string sDev_Period = "";
   std::string sDev_DutyCycle = "";
   
   if(bCheckAIVI_SBRVariant())
   {
	   sDev_Period = "/sys/class/pwm/pwmchip0/pwm0/period";
	   sDev_DutyCycle = "/sys/class/pwm/pwmchip0/pwm0/duty_cycle";
	   vOpenPWMChannel(sDev_Period, sDev_DutyCycle , TUN_PWM_SYNC_SIGNAL1);
	   
	   sDev_Period = "/sys/class/pwm/pwmchip0/pwm2/period";
	   sDev_DutyCycle = "/sys/class/pwm/pwmchip0/pwm2/duty_cycle";
	   vOpenPWMChannel(sDev_Period, sDev_DutyCycle, TUN_PWM_SYNC_SIGNAL3);
   }
   else
   {
	   /**Opening the period for PWM0 which is the only channel exported to iMx*/
	   sDev_Period = "/sys/class/pwm/pwmchip4/pwm0/period";
	   /**Opening the dutycycle for PWM0 which is the only channel exported to iMx*/
	   sDev_DutyCycle = "/sys/class/pwm/pwmchip4/pwm0/duty_cycle";
	   vOpenPWMChannel(sDev_Period, sDev_DutyCycle);
   }

   ETG_TRACE_USR4(("fInitializationComplete completed"));
}

/*************************************************************************
*
* FUNCTION: tuner_tclApp::~tuner_tclApp()
* 
* DESCRIPTION: destructor, frees all ressources 
*             ( if not done by vOnApplicationClose before )
*
* PARAMETER: void
* 
* RETURNVALUE: none
*
*************************************************************************/
tuner_tclApp::~tuner_tclApp()
{
   /* ---
   Normally the SPM calls vOnApplicationClose before this application - object is
   destroyed. Here we check if the ressources are already freed by vOnApplicationClose else 
   we free the ressources
   --- */ 

   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP, ET_EN_T16 _ TUN_TRACE_TUNAPP_DESTRUCTOR _ ET_EN_DONE);

   /*----------------------------------------*/
   /* Delete all the tuner internal classes  */
   /*----------------------------------------*/
   vDeleteClassInstances();
   vDeleteHMIClassInstances();
   vDeleteDiagnosisClassInstances();
   
   #ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
   if( m_potun_tclINCComm != NULL )
   {
	   vDeleteNoThrow (m_potun_tclINCComm);

	   m_potun_tclINCComm = NULL;
   }
#endif
    if( _tuner_poCCAService != NULL )
    {
      vDeleteNoThrow(_tuner_poCCAService);

      _tuner_poCCAService = NULL;
    }
    if( _poNotTable != NULL )
    {
      vDeleteNoThrow(_poNotTable);

      _poNotTable = NULL;
    }


    /*--------------------------------------*/
    /* Unregister with the trace component  */
    /*--------------------------------------*/
     _poExemplar ->m_poHandleTTFISCommands->vUnregisterInTraceCmdService();
     if(_poExemplar ->m_poHandleTTFISCommands!=NULL)
     {
        vDeleteNoThrow(_poExemplar ->m_poHandleTTFISCommands);
        _poExemplar ->m_poHandleTTFISCommands = NULL;
     }

    _poExemplar = NULL;


  /*CLose the PWM channel*/
    /*if (m_hPWMOutDevice != OSAL_ERROR)
    {
       OSAL_s32IOClose(m_hPWMOutDevice);
       ETG_TRACE_USR4(("PWM  :: PWMOut channel closed!"));
    }
    else
    {
       ETG_TRACE_USR4(("PWM  :: PWMOut channel could not be closed!"));
    }*/

   if(bCheckAIVI_SBRVariant())
   {
	   vclosePWMChannel(m_hPWMSync1DutyCycle, m_hPWMSync1Period , TUN_PWM_SYNC_SIGNAL1);
	   vclosePWMChannel(m_hPWMSync3DutyCycle, m_hPWMSync3Period , TUN_PWM_SYNC_SIGNAL3);
   }
   else
   {
	   vclosePWMChannel(m_hPWMDutyCycle, m_hPWMPeriod);
   }

   if(!_bAppClosed) 
   {     
      tuner_tclApp :: vOnApplicationClose();
   }
   
   ET_TRACE_CLOSE;

}


/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vOpenPWMChannel ()
* 
* DESCRIPTION: opens PWM channnel to write period and duty_cycle
*
* PARAMETER: std::string sPeriod , std::string sDutyCycle , tU8 u8Sync_Signal
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid tuner_tclApp::vOpenPWMChannel(std::string sPeriod , std::string sDutyCycle , tU8 u8Sync_Signal)
{
	switch(u8Sync_Signal)
	{
	   case TUN_PWM_SYNC_SIGNAL1:
	   {
			m_hPWMSync1Period = open(sPeriod.c_str(), O_WRONLY );
			if ( m_hPWMSync1Period < 0 )
				ETG_TRACE_USR4(("PWM  :: Opening file period : Failed, Error no is : %d Desc: %s", errno,strerror(errno)));

			m_hPWMSync1DutyCycle = open(sDutyCycle.c_str(), O_WRONLY);
			if ( m_hPWMSync1DutyCycle < 0 )
				ETG_TRACE_USR4(("PWM  :: Opening file duty_cycle: Failed, Error no is : %d Desc: %s", errno,strerror(errno)));

			if ((m_hPWMSync1Period == -1) || (m_hPWMSync1DutyCycle == -1))
			{
				ETG_TRACE_USR4(("PWM  :: Error opening PWM channel 1"));
			}
			else
			{
				vSetPWM(DUTYCYCLE_50 , TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC1_RANGE1 , TUN_PWM_SYNC_SIGNAL1);
				ETG_TRACE_USR4(("PWM  :: PWM channel 1 opened"));
			}
			break;
	   }
	   case TUN_PWM_SYNC_SIGNAL3:
	   {
			m_hPWMSync3Period = open(sPeriod.c_str(), O_WRONLY );
			if ( m_hPWMSync3Period < 0 )
				ETG_TRACE_USR4(("PWM  :: Opening file period : Failed, Error no is : %d Desc: %s", errno,strerror(errno)));

			m_hPWMSync3DutyCycle = open(sDutyCycle.c_str(), O_WRONLY);
			if ( m_hPWMSync3DutyCycle < 0 )
				ETG_TRACE_USR4(("PWM  :: Opening file duty_cycle: Failed, Error no is : %d Desc: %s", errno,strerror(errno)));

			if ((m_hPWMSync3Period == -1) || (m_hPWMSync3DutyCycle == -1))
			{
				ETG_TRACE_USR4(("PWM  :: Error opening PWM channel 3"));
			}
			else
			{
				vSetPWM(DUTYCYCLE_50 , TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC3_RANGE1 , TUN_PWM_SYNC_SIGNAL3);
				ETG_TRACE_USR4(("PWM  :: PWM channel 3 opened"));
			}
			break;
	   }
	   case TUN_PWM_SYNC_GEN3:
	   {
		   	m_hPWMPeriod = open(sPeriod.c_str(), O_WRONLY );
			if ( m_hPWMPeriod < 0 )
				ETG_TRACE_USR4(("PWM  :: Opening file period : Failed, Error no is : %d Desc: %s", errno,strerror(errno)));

			m_hPWMDutyCycle = open(sDutyCycle.c_str(), O_WRONLY);
			if ( m_hPWMDutyCycle < 0 )
				ETG_TRACE_USR4(("PWM  :: Opening file duty_cycle: Failed, Error no is : %d Desc: %s", errno,strerror(errno)));

			if ((m_hPWMPeriod == -1) || (m_hPWMDutyCycle == -1))
			{
				ETG_TRACE_USR4(("PWM  :: Error opening PWM channel"));
			}
			else
			{
				#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
				/*Set PWM12 to 50% duty cycle - NCG3D-44370*/
				vSetPWM(DUTYCYCLE_50 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY);
				#else
				/*Default setting DutyCycle is set to 100%, i.e. High, thinking Tuner is not current source by default.*/
				vSetPWM(DUTYCYCLE_100, TUN_PWM_HIGH_CORRECTEDFREQUENCY);
				#endif
				ETG_TRACE_USR4(("PWM  :: PWM channel opened"));
			}
			break;
		}
		default:
		{
			ETG_TRACE_USR4(("vOpenPWMChannel , invalid"));
		}
	}
}


/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vclosePWMChannel ()
* 
* DESCRIPTION: closes PWM channnel
*
* PARAMETER: tS32 m_hPWMDutyCycle , tS32 m_hPWMPeriod ,  tU8 u8Sync_Signal
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid tuner_tclApp::vclosePWMChannel(tS32 s32PWMDutyCycle , tS32 s32PWMPeriod ,  tU8 u8Sync_Signal)
{
	if((s32PWMDutyCycle == -1) && (s32PWMPeriod == -1))
	{
		
		ETG_TRACE_USR4(("PWM  :: PWMOut channel could not be closed!"));
	}
	else
	{
		if (s32PWMDutyCycle != -1)
		{
			if (close(s32PWMDutyCycle) < 0)
			{
				tInt errsv = errno;
				ETG_TRACE_ERR(("closing file duty_cycle : failed with error:%d", errsv));
				ETG_TRACE_ERR(("closing file duty_cycle : failed and error msg : %s\n", strerror(errsv)));
			}
		}
		if (s32PWMPeriod != -1)
		{
			if (close(s32PWMPeriod) < 0)
			{
				tInt errsv = errno;
				ETG_TRACE_ERR(("Closing file cDev_Period : failed with error:%d", errsv));
				ETG_TRACE_ERR(("Closing file cDev_Period : failed and error msg : %s\n", strerror(errsv)));
			}
		}
		ETG_TRACE_USR4(("PWM  :: PWMOut channel closed!"));
	}

	switch(u8Sync_Signal)
	{
		case TUN_PWM_SYNC_SIGNAL1:
		{
			m_u32Sync1Freq = 0;
			m_u16Sync1PWMValue = 0;
			break;
		}
		case TUN_PWM_SYNC_SIGNAL3:
		{
			m_u32Sync3Freq = 0;
			m_u16Sync3PWMValue = 0;
			break;
		}
		case TUN_PWM_SYNC_GEN3:
		{
			m_u32Freq = 0;
			m_u16PWMValue = 0;
			break;
		}
		default:
		{
			ETG_TRACE_USR4(("vclosePWMChannel , invalid"));
		}
	}
}


/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vInitializeTunerComponent ()
* 
* DESCRIPTION: 
*
* PARAMETER: void
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid tuner_tclApp::vInitializeTunerComponent ()
{

   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP, ET_EN_T16 _ TUN_TRACE_TUNAPP_INIT_TUNER _ ET_EN_DONE);
   
   /*-------------------------------------*/
   /* Create class instances and pointers */
   /*-------------------------------------*/
   
   vCreateClassInstances();
   vCreateHMIClassInstances();
   vCreateDiagnosisClassInstances();
   vCreateTraceClassInstances();
   vCreateClassPointers();
   vCreateHMIClassPointers();
   vCreateDiagnosisClassPointers();
   vCreateTraceClassPointers();
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   vCreateGeneralConfigurationClassInstances();
#endif
   vReadProjectConfiguration();

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
   if(m_poclConfigMain != nullptr)
   {
	   if(m_poclConfigMain->u32GetConfigData("SBR"))
	   {
		   m_enRestartTimeValue = enNoError;

	#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
		   if( m_potun_tclINCComm != nullptr )
		   {
			   vDeleteNoThrow (m_potun_tclINCComm);
			   m_potun_tclINCComm = nullptr;
		   }
	#endif
			m_pGioDbusHandler = tuner_gio_dbus_handler::instance();
	   }
   }
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
   vSetMidwTunerToAdr3MapPSA();
#else
   if (m_poclConfigMain != nullptr)
       vSetMidwTunerToAdr3Map(m_poclConfigMain->u32GetConfigData("PresetListMapping"));
#endif

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   m_poclTmcTuner_Method_S_DISABLE_BAND =OSAL_NEW clTmcTuner_Method_S_DISABLE_BAND(m_potun_MsgFromHMI,m_poclAars_ATPresetList_XX,m_poclAars_CM_ChangeLsm,m_potun_Config,m_poclTmcTuner_Property_G_GET_STATIC_LIST,m_poclAars_ATFrequency,m_potun_MsgFromHMI);
   if((NULL==m_potun_MsgFromHMI)|| (NULL==m_poclTmcTuner_Property_G_GET_STATIC_LIST)|| (NULL==m_poclTmcTuner_Method_S_DISABLE_BAND))
   {
	   return;
   }
   m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_DISABLE_BAND);
   m_poclTmcTuner_Property_G_GET_STATIC_LIST->vSetclTmcTuner_Method_S_DISABLE_BANDPtr(m_poclTmcTuner_Method_S_DISABLE_BAND);
   m_poclTmcTuner_Method_S_DISABLE_BAND->vSetdp_tclTunerImplPtr(m_podp_tclTunerImpl);
#endif
}
/*************************************************************************
*
* FUNCTION: tBool tuner_tclApp::vReadProjectConfiguration ()
* 
* DESCRIPTION: Read project configuration
*
* PARAMETER: void
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclApp::vReadProjectConfiguration() 
{
	if(m_poclConfigMain != NULL)
	{
		m_poclConfigMain->vStartKDSRead();
		#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
			m_podp_tclTunerImpl = new dp_tclTunerImpl();
		#endif
	}
}
/*************************************************************************
*
* FUNCTION: tBool tuner_tclApp::bOnInit ()
* 
* DESCRIPTION: is called after the initialisation of the framework is finished
*
* PARAMETER: void
*
* RETURNVALUE: TRUE
*
*************************************************************************/
tBool tuner_tclApp::bOnInit ()
{
    ETG_TRACE_USR4(("tuner_tclApp::bOnInit() Entered"));
	if(m_poclConfigMain == NULL)
	{
		return TRUE;
	}
	if(!m_poclConfigMain->u32GetConfigData("SBR"))
	{
		(tVoid)OSAL_s32TimerSetTime(_hTimerHandler,_theServer->m_enRestartTimeValue, 0);
	}
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
			tBool bSuccess = false;
			if(m_poclConfigMain->u32GetConfigData("SBR") && m_pGioDbusHandler!= NULL)
			{
			   ETG_TRACE_USR4(("tuner_tclApp::bOnInit() Initializing gio handler."));
			   bSuccess = m_pGioDbusHandler->bInit("AMFM_SBR_COM");
			}
			if(!bSuccess)
			{
				/*Failed to intialize AMFM_SBR_COM*/
				ETG_TRACE_USR1(("tuner_tclApp::bOnInit() Initializing gio handler failed"));
			}
#endif

	ETG_TRACE_USR4(("tuner_tclApp::bOnInit() done"));
    return  TRUE;
}

/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vOnServiceState
* 
* DESCRIPTION: FC_TmcTuner is client to the components, the 
*              Service state responses will be handled here.
*              
*
* PARAMETER: 
*
* RETURNVALUE:
*
*************************************************************************/
tVoid tuner_tclApp::vOnServiceState
( 
 tU16  u16ServiceId   ,
 tU16  u16ServerId    ,
 tU16  u16RegisterId  , 
 tU8   u8ServiceState ,
 tU16  u16SubId       
 )
{

  switch ( u16ServiceId )
  {
    case CCA_C_U16_SRV_DIAGLOG:
    {

      if ( NULL == m_potun_DiaglogHandler )
      {
        // Trace this corrupted reference
        NORMAL_M_ASSERT (NULL != m_potun_DiaglogHandler);
      }
      else
      {
        // Inform the DiaglogHandler
        m_potun_DiaglogHandler -> vOnServiceState ( u16ServiceId,
                                                    u16ServerId,
                                                    u16RegisterId, 
                                                    u8ServiceState,
                                                    u16SubId );

        /*ETG_TRACE_USR1(( " tuner_tclApp::vOnServiceState() -> CCA_C_U16_SRV_DIAGLOG\n"
                         " u16ServiceId   : %x\n"
                         " u16ServerId    : %x\n"
                         " u16RegisterId  : %x\n"
                         " u8ServiceState : %x\n"
                         " u16SubId       : %x\n"
                        ,ETG_ENUM( ail_u16ServiceId        ,u16ServiceId)
                        ,ETG_ENUM( ail_u16ServiceId        ,u16ServerId)
                        ,u16RegisterId
                        ,ETG_ENUM( ail_u8ServiceState      ,u8ServiceState)
                        ,u16SubId
                      ));*/
      }

    }
    break;
    case CCA_C_U16_SRV_SPM:
    {
      if ( NULL == m_potun_tclSPMClient )
      {
        // Trace this corrupted reference
        NORMAL_M_ASSERT (NULL != m_potun_tclSPMClient);
      }
      else
      {
        // Inform the SPM CCA client handler
        m_potun_tclSPMClient->vOnServiceState ( u16ServiceId,
                                                u16ServerId,
                                                u16RegisterId, 
                                                u8ServiceState,
                                                u16SubId );


        /**ETG_TRACE_USR1(( " tuner_tclApp::vOnServiceState() -> CCA_C_U16_SRV_SPM\n"
                         " u16ServiceId   : %x\n"
                         " u16ServerId    : %x\n"
                         " u16RegisterId  : %x\n"
                         " u8ServiceState : %x\n"
                         " u16SubId       : %x\n"
                        ,ETG_ENUM( ail_u16ServiceId        ,u16ServiceId)
                        ,ETG_ENUM( ail_u16ServiceId        ,u16ServerId)
                        ,u16RegisterId
                        ,ETG_ENUM( ail_u8ServiceState      ,u8ServiceState)
                        ,u16SubId
                      ));*/
      }

    }
    break;

#ifdef VARIANT_S_FTR_ENABLE_VDCLOCK
    case CCA_C_U16_SRV_CLOCK:
    {
    	if(NULL == m_potun_tclVdClockClient)
    	{
    		NORMAL_M_ASSERT (NULL != m_potun_tclVdClockClient);
    	}
    	else
    	{
    		m_potun_tclVdClockClient->vOnServiceState ( u16ServiceId,
    		                                                u16ServerId,
    		                                                u16RegisterId,
    		                                                u8ServiceState,
    		                                                u16SubId );
    	}
    	break;
    }
#endif
    case CCA_C_U16_SRV_PV:
    {
    	if(NULL == m_potun_tclSensorClient)
    	{
    		NORMAL_M_ASSERT (NULL != m_potun_tclSensorClient);
    	}
    	else
    	{
#ifndef GTEST_x86LINUX_BUILD
    		m_potun_tclSensorClient->vOnServiceState ( u16ServiceId,
    				u16ServerId,
    				u16RegisterId,
    				u8ServiceState,
    				u16SubId );
#endif
    	}
    	break;
    }

    default:
    {
        
		ETG_TRACE_USR1(( " tuner_tclApp::vOnServiceState() -> default\n"
                         " u16ServiceId   : %x\n"
                         " u16ServerId    : %x\n"
                         " u16RegisterId  : %x\n"
                         " u8ServiceState : %x\n"
                         " u16SubId       : %x\n"
                        ,ETG_ENUM( ail_u16ServiceId        ,u16ServiceId)
                        ,ETG_ENUM( ail_u16ServiceId        ,u16ServerId)
                        ,u16RegisterId
                        ,ETG_ENUM( ail_u8ServiceState      ,u8ServiceState)
                        ,u16SubId
                      ));
    }
    break;

  }  


  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP, ET_EN_T16 _ TUN_TRACE_TUNAPP_SERVICE_STATE _ ET_EN_DONE );
}

/************************************************************************
 *
 * FUNCTION: tBool vOnAsyncRegisterConf()
 *
 * DESCRIPTION: only used for one thread applications
 *
 * PARAMETER:
 *              tU16 u16RegisterId,
 *              tU16 u16ServerAppId
 *              tU16 u16ServiceId,
 *              tU16 u16SourceSubID
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
tVoid tuner_tclApp::vOnAsyncRegisterConf (  tU16 u16RegisterId, 
		tU16 u16ServerAppId,
		tU16 u16ServiceId,
		tU16 u16SourceSubID )
{

	ETG_TRACE_USR4(( " tuner_tclApp::vOnAsyncRegisterConf() u16ServiceId=%d", u16ServiceId));
	switch ( u16ServiceId )
	{
	#ifdef VARIANT_S_FTR_ENABLE_VDCLOCK
		case CCA_C_U16_SRV_CLOCK:
		{
			if(NULL == m_potun_tclVdClockClient)
			{
				return;
			}
			m_potun_tclVdClockClient->vOnAsyncRegisterConf(u16RegisterId, u16ServerAppId, u16ServiceId, u16SourceSubID);
			break;
		}
	#endif
		case CCA_C_U16_SRV_PV:
		{
			if(NULL == m_potun_tclSensorClient)
			{
				return;
			}
			if(u16ServiceId == CCA_C_U16_SRV_PV)
			{
#ifndef GTEST_x86LINUX_BUILD
				m_potun_tclSensorClient->vOnAsyncRegisterConf(u16RegisterId, u16ServerAppId, u16ServiceId, u16SourceSubID);
#endif
			}
			break;
		}
		default:
			break;
	}
}

/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState)
* 
* DESCRIPTION: * is call from SPM to inform this application about new power states
*              * changes the state of the application
*              * sends ServiceAvailability state to all notified clients
*              * changes state of downloadservice(-object)  
*
* PARAMETER: tU32 u32OldAppState (actual state), 
*            tU32 u32AppState (state to change to)
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclApp::vOnNewAppState (tU32 u32OldAppState, tU32 u32NewAppState)
{
    /* Validate the Pointer */

    if (  m_potun_tclSPMClient == NULL || m_potu_Manager == NULL || m_poPortMngr == NULL || m_ptun_MsgToADR == NULL || m_poclConfigMain==NULL   )
    {
        NORMAL_M_ASSERT( m_potun_tclSPMClient != NULL );
        NORMAL_M_ASSERT( m_potu_Manager != NULL );
        NORMAL_M_ASSERT(m_poPortMngr != NULL);
        NORMAL_M_ASSERT(m_ptun_MsgToADR != NULL);
        NORMAL_M_ASSERT(m_poclConfigMain != NULL);
        return;
    }  
   if(u32OldAppState==u32NewAppState)
   {
	   return;
   }
   m_potu_Manager ->vSetTunerSystemState( (tU8)u32NewAppState );
   switch(u32NewAppState)
   {
		case AMT_C_U32_STATE_NORMAL:
		{

			if((m_bTunerSrvStatus == false) && (tun_DrvAdrIf::instance()->enGetADRState() == enADRState_ALIVE)\
                && ( tun_DrvAdrIf::instance()->vGetADRCommnState() != enComState_WaitForStartup))
			{
			
				//ETG_TRACE_USR4(("ADR is still alive but Tuner service is Unavailable, send Service availability"));
				/*ADR is still alive but Tuner service is Unavailable, send Service availability*/     
				ETG_TRACE_USR4(("ADRCommState is != enComState_WaitForStartup"));
					//tun_DrvAdrIf::instance()->vSetADRCommnState(enComState_Run);
				if(m_ptun_MsgToADR->bGetNotificationSentStatus())
				{
					vTunerStartUpProcess();
				}
			}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI

			   ETG_TRACE_USR4(("Destination_Region = 0x%02x JapaneseStationNamesFromLookupTable=0x%02x",
			   		m_poclConfigMain->u32GetConfigData("Destination_Region"), m_poclConfigMain->u32GetConfigData("JapaneseStationNamesFromLookupTable")));
			   if(m_poclTmcTuner_Method_S_JAPAN_SET_AREA!=NULL)
			   {
			   	if(m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bIsJapanRegion() &&
						( m_poclTmcTuner_Method_S_JAPAN_SET_AREA->m_poclJapanStationName->m_databaseobj == NULL) &&
						(!(m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bIsSuppressStationName())))
					{
						m_poclTmcTuner_Method_S_JAPAN_SET_AREA->vConnectDatabaseForJapanStationName();
					}
			   }
#endif
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
			if(m_poclConfigMain->u32GetConfigData("HDSupported"))
			{
				if(m_poclHDStationLogoManagement != NULL)
				{
					m_poclHDStationLogoManagement->vHandleHDStationLogo();
				}
			}
#endif
			break;
      }     
   case AMT_C_U32_STATE_OFF:
      {
//		  ETG_TRACE_USR4(("tuner_tclApp::vOnNewAppState OFF entered!"));
		  if(m_poclTmcTuner_stationLogo_map != NULL)
		  {
			  m_poclTmcTuner_stationLogo_map->vSetdpTunerDPLatitudeNdLongitudeOnShutdown();
		  }
         /*Set Duty cycle of PWM to 0% i.e. set the PIN to LOW, becoz it is shutdown.*/
		 if(bCheckAIVI_SBRVariant())
		 {
			vSetPWM(0, 0 , TUN_PWM_SYNC_SIGNAL1);
			vSetPWM(0, 0 , TUN_PWM_SYNC_SIGNAL3); 
		 }
		 else
		 {
			vSetPWM(0, 0);
		 }

         fDestroyADRComm ();
         
         //ETG_TRACE_USR4(( " tuner_tclApp::vOnNewAppState, vSendCommit "));

         /*If Landscape is not requested send CM_Commit, else send it on response for Landscape*/
		 bool bIsLandscapeRequested =false;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		 bIsLandscapeRequested = m_poclAars_CM_UpdateLandscape->bIsLandscapeRequested();
#else
         bIsLandscapeRequested = m_ptun_MsgToADR->bGetLandscapeRequested();
#endif
		 if(!bIsLandscapeRequested)
         {
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
			m_poclAars_CM_Commit->vSendCommitMsg();
#else
			 m_ptun_MsgToADR->vSendCommit();
#endif
         }
		 
//close the database during shutdown
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		 ETG_TRACE_USR4(("Destination_Region = 0x%02x JapaneseStationNamesFromLookupTable=0x%02x",
				m_poclConfigMain->u32GetConfigData("Destination_Region"), m_poclConfigMain->u32GetConfigData("JapaneseStationNamesFromLookupTable")));
		 if(m_poclTmcTuner_Method_S_JAPAN_SET_AREA!=NULL)
		 {
			 if(m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bIsJapanRegion() &&
					 (!(m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bIsSuppressStationName())))
			 {
				 m_poclTmcTuner_Method_S_JAPAN_SET_AREA->vDisconnectDatabaseForJapanStationName();
			 }
		 }
#endif
		
		 /** NCG3D-10402 and NCG3D-8305 tuner shut down handled in main thread */
		vTunerShutDownProcess();
        /*Since ADR has not reset and tunershutdown called due to shutdown trigger from SPM the previous notification request is still valid*/
		m_ptun_MsgToADR->vSetNotificationSentStatus(true);
        m_poPortMngr->vClearAll(FALSE);

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		if(m_poclConfigMain->u32GetConfigData("HDSupported"))
		{
			if(m_poclHDStationLogoManagement != NULL)
			{
				m_poclHDStationLogoManagement->vDoDifferentialCopyLogosFromRAMToFlash();
			}
		}
#endif
         break;
      }
   default:
      {
		  break;
      }
   }

   /* ---
   inform the message handler about the new state
   --- */
    /**pmn3kor:
     * created new function to solve logiscope issues
     * Handler for Updating new app state to theclients*/
    vUpdateMessageHandler(u32OldAppState, u32NewAppState);

    // Inform the status to SPM client handler
#ifndef GTEST_x86LINUX_BUILD
    m_potun_tclSPMClient->vOnNewAppState ( u32OldAppState,
                                           u32NewAppState );
#endif
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
    m_potun_tclVdClockClient->vOnNewAppState ( u32OldAppState,
                                               u32NewAppState );
#endif
#ifndef GTEST_x86LINUX_BUILD
    m_potun_tclSensorClient->vOnNewAppState(u32OldAppState,
                                               u32NewAppState );
#endif
    /* ---
   create and send an acknowledge message so the SPM knows you have reached the new state
   --- */
    vAppStateChanged (u32NewAppState, 0);

} 
/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vUpdateMessageHandler
*
* DESCRIPTION: changes the state of the application
*
* PARAMETER: tU32 u32OldAppState (actual state),
*            tU32 u32AppState (state to change to)
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclApp::vUpdateMessageHandler(tU32 u32OldAppState, tU32 u32AppState)
{
    /**update new app state*/
    /**update Tuner Server app state*/
    if(_tuner_poCCAService != OSAL_NULL)
    {
        _tuner_poCCAService->vOnNewAppState(u32OldAppState, u32AppState);
    }
    /**update app state of tun_DiaglogHandler*/
#ifndef GTEST_x86LINUX_BUILD
    if(m_potun_DiaglogHandler != NULL)
    {
        m_potun_DiaglogHandler->vOnNewAppState(u32OldAppState, u32AppState);
    }
    /**update app state*/
    if(m_potun_tclDiagHandler != NULL)
    {
        m_potun_tclDiagHandler->vOnNewAppState(u32OldAppState, u32AppState);
    }
#endif
}



/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vOnNewMessage (amt_tclBaseMessage* poMessage)
* 
* DESCRIPTION: * casts Message to amt_tclServiceData (if legal)
*              * gives amt_tclServiceData - Message to service for analyzing
*              * ignores all unexpected messsages
*
* PARAMETER: amt_tclBaseMessage* poMessage ( Message to analyse)
*
* RETURNVALUE: void
*
* vnd4kor: solved logiscope poor maintainability issue 
*************************************************************************/
tVoid tuner_tclApp::vOnNewMessage (amt_tclBaseMessage* poMessage) 
{
    /* Validate the Pointer */
    if ( (poMessage == NULL) || (m_poPortMngr == NULL) || \
         (m_potun_MsgFromHMI == NULL) || (m_potun_MsgFromDiag == NULL) \
         || (m_potun_DiaglogHandler == NULL) || (NULL == m_potun_tclSPMClient)\
         || (m_potun_tclDiagHandler == NULL) || (NULL == m_potun_tclSensorClient)
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		 || (NULL == m_potun_tclVdClockClient)
#endif 
	)
    {
        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_poPortMngr != NULL );
        NORMAL_M_ASSERT( m_potun_MsgFromHMI != NULL );
        NORMAL_M_ASSERT( m_potun_MsgFromDiag != NULL );
        NORMAL_M_ASSERT( m_potun_DiaglogHandler != NULL );
        FATAL_M_ASSERT(NULL != m_potun_tclSPMClient);
        NORMAL_M_ASSERT( m_potun_tclDiagHandler != NULL );
        NORMAL_M_ASSERT( m_potun_tclSensorClient != NULL );
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
        NORMAL_M_ASSERT( m_potun_tclVdClockClient != NULL );
#endif
        return ;
    }

   /* ---
   check if the received message is a AMT Service data message
   --- */
	tU16 u16ServiceID = 0;
	//ETG_TRACE_USR1(("tuner_tclApp:: vOnNewMessage Message Start****"));
   if(poMessage->u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA)
   {

      /* ---
      cast the received message to a AMT Service data message so we 
      can access the standard members
      --- */
      amt_tclServiceData oServiceData(poMessage);
      
      m_poPortMngr->enUpdate(&oServiceData);

	  /** Get serviceID from msg */
	  u16ServiceID = oServiceData.u16GetServiceID();
	  
	  /** Get SourceAppId from msg */
	  tU16 u16AppID = oServiceData.u16GetSourceAppID();
	  
	  /** Assign Reg ID based on App Id */
	  vAssignRegID(oServiceData.u16GetRegisterID(), u16AppID);

	  /* ---
      one server can offer more than one service. So we analyse the ServiceID
      to know which service handler we have to call. 
      99% of all Servers only offer one service ( with a different function ID for each feature ). 
      --- */
      switch(u16ServiceID)
      {
         /* +++
          enter your Service ID here
            +++ */     
        case CCA_C_U16_SRV_TUNERCONTROL:
          {
           /* ETG_TRACE_USR1(( " tuner_tclApp::vOnNewMessage() -> SrvId %x"
                            ,ETG_ENUM( ail_u16ServiceId, u16ServiceID)
                          ));*/
              m_potun_MsgFromHMI->vDispatchMessage(&oServiceData);
			  break;
          }
        case CCA_C_U16_SRV_TUNERDIAG:
          {
            ETG_TRACE_USR1(( " tuner_tclApp::vOnNewMessage() -> SrvId %x"
                            ,ETG_ENUM( ail_u16ServiceId, u16ServiceID)
                          ));

               m_potun_MsgFromDiag ->vDispatchMessage(&oServiceData);
               ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP, ET_EN_T16 _ CCA_C_U16_SRV_TUNERDIAG _  
                                                          ET_EN_T16 _ m_potun_MsgFromDiag _ 
                                                          ET_EN_DONE);
			   break;
          }

        case CCA_C_U16_SRV_DIAGLOG:
          {
         //   ETG_TRACE_USR1(( " tuner_tclApp::vOnNewMessage() -> SrvId %x"
         //                   ,ETG_ENUM( ail_u16ServiceId, u16ServiceID)
         //                 ));

               m_potun_DiaglogHandler ->vDispatchMessage(&oServiceData);
			   break;
          }

        case CCA_C_U16_SRV_SPM:
          {
            /** Give the message to cca service handler for analysing.
            // vDispatchMessage is a framework function. it will compare
            // the function ID with the message map and call the corresponding 
            //  function */
           
              m_potun_tclSPMClient->vDispatchMessage(&oServiceData);
			  break;
          }
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
        case CCA_C_U16_SRV_CLOCK:
        {
        	m_potun_tclVdClockClient->vDispatchMessage(&oServiceData);
        	break;
        }
#endif
        case CCA_C_U16_SRV_PV:
        {
        	m_potun_tclSensorClient->vDispatchMessage(&oServiceData);
        	break;
        }
        default:
           {
			   /* +++
			   we have received a message with an unkown service ID.
			   this is an error so make a trace or assert here
			   +++ */
			   /* dispatch to diaglib if the service ID is the diaglibs one */

				if(u16ServiceID == m_potun_tclDiagHandler->u16GetServiceId())
				{
        			 /*ETG_TRACE_USR1(( " tuner_tclApp::vOnNewMessage() default case -> SrvId %x"
        										,ETG_ENUM( ail_u16ServiceId, u16ServiceID)
        									  ));*/
					m_potun_tclDiagHandler->vDispatchMessage(&oServiceData);
				}
				break;
           }
      }
   }
   else
   {
      /* +++
      we have received a message with an unkown format.
      this is an error so make a trace or assert here
      +++ */

      /* ---
      we can't do anything with this message so free the ressources
      --- */
      //poMessage->bDelete();
   }
   if(poMessage->bIsValid() == TRUE)
   {
	   if(poMessage->bDelete() == FALSE)
		{
			//ETG_TRACE_USR1(("tuner_tclApp:: vOnNewMessage Message Not deleted from Serive Id = %d", u16ServiceID));
		}
   }
}

/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vAssignRegID(tU16 u16RegisterID, tU16 u16AppID)
* 
* DESCRIPTION: Assign Reg ID based on App Id 
*
* PARAMETER: tU16 u16RegisterID, tU16 u16AppID
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid tuner_tclApp::vAssignRegID(tU16 u16RegisterID, tU16 u16AppID)
{
	  /** Assign Reg ID based on App Id */
	  if(u16AppID == CCA_C_U16_APP_TUNERMASTER)
	  {
		m_u16TMRegID = u16RegisterID;
	  }
	  else if(u16AppID == CCA_C_U16_APP_UI)
	  {
		m_u16UIRegID = u16RegisterID;
	  }
	  else if(u16AppID == CCA_C_U16_APP_FC_TPEG)
	  {
		m_u16TPEGRegID = u16RegisterID;
	  }
}


/*************************************************************************
*
* FUNCTION: tBool tuner_tclApp::bGetServiceVersion (tU16 u16ServiceID, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion)
* 
* DESCRIPTION: stores data about the version of this service (magics) 
*
* PARAMETER: * u16ServiceID: the service we should describe
*            * rfu16MajorVersion, rfu16MinorVersion, rfu16PatchVersion: targets for storing the data
*
* RETURNVALUE: success: true / false
*
*************************************************************************/
tBool tuner_tclApp::bGetServiceVersion (tU16 u16ServiceID, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion)
{
   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP, ET_EN_T16 _\
                      TUN_TRACE_TUNAPP_GET_SRV_VERSION _ ET_EN_DONE);

   tBool bRetVal = false;

   if(u16ServiceID == CCA_C_U16_SRV_TUNERCONTROL )
   {
      /* +++
      Enter the version of this service you offer
      +++ */

      rfu16MajorVersion =MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION;
    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP,\
             ET_EN_T16 _ TUN_TRACE_TUNAPP_SRV_TUNERCONTROL_MAJOR_VERSION _\
             ET_EN_T16 _ rfu16MajorVersion _\
             ET_EN_DONE);
    
      rfu16MinorVersion = MIDW_TUNERFI_C_U16_SERVICE_MINORVERSION;
    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP,\
             ET_EN_T16 _ TUN_TRACE_TUNAPP_SRV_TUNERCONTROL_MINOR_VERSION _\
             ET_EN_T16 _ rfu16MinorVersion _\
             ET_EN_DONE);
   
      rfu16PatchVersion = 0;
      
      bRetVal = true;
   }
   else if( u16ServiceID == CCA_C_U16_SRV_TUNERDIAG ) 
   {
     // Major ver
     rfu16MajorVersion = 2;
     // Minor ver
     rfu16MinorVersion = 0;
     // Patch ver
     rfu16PatchVersion = 0;

     bRetVal = true;

   }
   else if( (0 != m_potun_tclDiagHandler) && (u16ServiceID == m_potun_tclDiagHandler->u16GetServiceId()) )
   {
   bRetVal = m_potun_tclDiagHandler->bGetServiceVersion(rfu16MajorVersion, rfu16MinorVersion, rfu16PatchVersion);
   }
   else
   {
      /* +++
      we have received a request with an unkown service ID.
      this is an error so make a trace or assert here
      +++ */
      bRetVal = false;
   }

   return bRetVal;
}


/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vSendError
* 
* DESCRIPTION: sends an error - message
*
* PARAMETER: data for addressing the message
*
* RETURNVALUE: void
*

**************************************************************************/
tVoid tuner_tclApp::vSendError(tU16 /* u16SourceID    */, 
                               tU16 /* u16TargetID    */, 
                               tU16 /* u16RegisterID  */, 
                               tU16 /* u16CmdCounter  */, 
                               tU16 /* u16Sid         */, 
                               tU16 /* u16Fid         */)const
{

}

/************************************************************************
*
* FUNCTION: tBool tuner_tclApp::bOnWatchdog()
* 
* DESCRIPTION: ????
*
* PARAMETER: void
*
* RETURNVALUE: true
*
*************************************************************************/
tBool tuner_tclApp::bOnWatchdog()
{
   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP, ET_EN_T16 _ TUN_TRACE_TUNAPP_ONWATCHDOG _ ET_EN_DONE);
   return TRUE;
}

/*************************************************************************
*
* FUNCTION: tVoid tuner_tclApp::vOnApplicationClose()
* 
* DESCRIPTION: releases all resources and sends close - message
*
* PARAMETER: void
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tuner_tclApp::vOnApplicationClose()
{ 


   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP, ET_EN_T16 _ TIN_TRACE_TUNAPP_APPLICATION_CLOSE _ ET_EN_DONE);
   _bAppClosed = TRUE;

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY   
		   if(m_pGioDbusHandler!= NULL)
		   {
			   m_pGioDbusHandler->vDeInit();
			   delete m_pGioDbusHandler;
			   m_pGioDbusHandler = NULL;
		   }
#else
   tun_DrvAdrIf::instance()->vStopCommunication();
    

   /*--------------------------------------------------------------------*/
   /* Terminate the continous while loop in class tun_RUIF_WaitingThread */
   /*--------------------------------------------------------------------*/
   if( m_ptun_RUIF_WaitingThread != NULL )
   {
     m_ptun_RUIF_WaitingThread->_bTerminate = TRUE;
     m_ptun_RUIF_WaitingThread ->vPostEventToSelf(  );
   }
#endif

   OSAL_s32SemaphoreClose( _hNotTableSem );   

   OSAL_s32SemaphoreClose( _hADRDataUpdateSem );   
   
   OSAL_s32SemaphoreDelete( TUNER_NOTTABLE_SEM_NAME );

  OSAL_s32SemaphoreDelete( TUNER_RECV_DATA_FROM_ADR_SEM_NAME );
   
   if( _poNotTable != NULL )
   {
    vDeleteNoThrow( _poNotTable);

    _poNotTable = NULL;
   }

   if( _tuner_poCCAService != NULL )
   {
    vDeleteNoThrow( _tuner_poCCAService);   

    _tuner_poCCAService = NULL;
   }
   /* ---
   inform SPM about successful shut down
   --- */
   vApplicationCloseAcknowledge(AIL_C_U8_APP_END_SUCCESSFUL);
}

/*************************************************************************
 *
 * FUNCTION: tVoid tuner_tclApp::vOnUnregister
 *
 * DESCRIPTION: This is oveeloaded function of AIL, to handle "Do service unregister" requests from clients.
 *
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *************************************************************************/
tVoid tuner_tclApp:: vOnUnregister(tU16 u16ServiceId,  tU16 u16RegisterId)
{
	if(m_potun_MsgToHMI == NULL)
	{
		NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
		//ETG_TRACE_USR1(( " tuner_tclApp::vOnUnregister() ->NULL Pointer." ));
		return;
	}
	switch ( u16ServiceId )
	{
	case CCA_C_U16_SRV_TUNERCONTROL:
	{
		m_potun_MsgToHMI ->vRemoveAllEntriesWithRegID(u16ServiceId,u16RegisterId);
		//ETG_TRACE_USR1(( " tuner_tclApp::vUnregister() -> Unregister Tuner service request from Client." ));
	}break;
	default:
	{
		//ETG_TRACE_USR1(( " tuner_tclApp::vUnregister() -> Default case -> Service iD =%d", u16ServiceId));
	}
	break;
	}
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::vTunerStartUpProcess
 *
 *DESCRIPTION:  Tuner activities during startup, After Radio unit communication is 
 *              established. Inform all the clients of service availablility.
 *             
 *PARAMETER:    tVoid
 *
 *RETURNVALUE:  tVoid
 *              
 *
 *HISTORY:
 *15.09.06 dip2kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tuner_tclApp::vTunerStartUpProcess ()
{
  if(  (NULL == m_potun_MsgToTunMaster) || ( NULL == m_poclConfigMain ))
  {
    NORMAL_M_ASSERT( m_poclConfigMain != NULL );
	NORMAL_M_ASSERT( m_potun_MsgToTunMaster != NULL );
    return;
  }
  
  //-----------------------------------------
  // Service availability information to HMI and tunermaster
  //-----------------------------------------
  if(m_bTunerSrvStatus == FALSE)
  {

     ETG_TRACE_USR4(( " tuner_tclApp::vTunerStartUpProcess, before serv avail "));

	    vServiceAvailabilityChanged
	    (
	     CCA_C_U16_SRV_TUNERCONTROL,
	     AMT_C_U8_SVCSTATE_AVAILABLE
	    );

	    //---------------------
	    // Diagnostics Service
	    //---------------------
	    vServiceAvailabilityChanged
	    (
	     CCA_C_U16_SRV_TUNERDIAG,
	     AMT_C_U8_SVCSTATE_AVAILABLE
	    );

	    m_bTunerSrvStatus = true;

	    //ETG_TRACE_USR4(( " tuner_tclApp::vTunerStartUpProcess, m_bTunerSrvStatus = %d ", m_bTunerSrvStatus));
  }
  else
  {
	  //ETG_TRACE_USR4(( " tuner_tclApp::vTunerStartUpProcess, service already avail"));
  }


}//End of function

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::fDestroyADRComm
 *
 *DESCRIPTION:  This function is the central control to inactivate ADR comm.
 *              It decides to inactivate based on the current application state
 *              and current voltage  status (copro state bit)
 *             
 *PARAMETER:    None
 *
 *RETURNVALUE:  TRUE  : RU communication inactivated
 *              FALSE : RU communication activated
 *
 *HISTORY:
 *17.04.06 aca2kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tBool tuner_tclApp::fDestroyADRComm ()
{
  // Return value
  tBool fRUInactivated = FALSE;

  if((NULL == m_ptun_MsgToADR )||(NULL == m_potu_Manager)||(NULL == m_potun_ActualData)||(NULL == m_potun_MsgToHMI))
  {
    NORMAL_M_ASSERT (NULL != m_ptun_MsgToADR);
    NORMAL_M_ASSERT (NULL != m_potu_Manager);
    NORMAL_M_ASSERT (NULL != m_potun_ActualData);
    NORMAL_M_ASSERT (NULL != m_potun_MsgToHMI);

	return fRUInactivated;
  }

  else
  {

      // Get current system state:
      tU32 u32RequestedAppState = m_potu_Manager->u8GetTunerSystemState();
  
      ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_TUNAPP,\
                         ET_EN_T16 _ TUN_TRACE_TUNAPP_COMMUNICATION_DE_INIT _\
                         ET_EN_T32 _ u32RequestedAppState _\
                         ET_EN_DONE );

         
      /*-----------------------------------------*/
      /* Trigger COMP_STATUS_ATIVE command to RU */
      /*-----------------------------------------*/
      if( ( m_potun_ActualData->m_otun_Data_MainStatus.u8GetStatus()) == TUN_COMPONENT_STATUS_ACTIVE )
      {
        if(  m_potun_MsgToHMI->u8GetTunFGBGStatus() == (tU8)enAudioSource_User_audio)
		{
			

            tBool bTunerState= FALSE;
            //put User1 to Background
            m_ptun_MsgToADR ->vSend_TUNFgBg(TU_FOREGROUND, (tU8)FI_EN_TUN_CHANGE_TO_BG,
                                                    (tU8)FI_EN_TUN_USR1_CHANGE_TO_FG_BG, bTunerState, 0xff );
													/*changed from 0 to 0xff in order to send tuner to background and avoid entering test mode*/

        }
        fRUInactivated = TRUE;
            
            
      }
          
  }
  return (fRUInactivated);
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::vTunerShutDownProcess
 *
 *DESCRIPTION:  All Tuner shut down process after PAUSE, OFF state received from
 *              SPM. Inform all the CCA clients, SERVICE NOT AVAILABLE.
 *             
 *PARAMETER:    tVoid
 *
 *RETURNVALUE:  tVoid
 *              
 *
 *HISTORY:
 *15.09.06 dip2kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tuner_tclApp::vTunerShutDownProcess ()
{
  	ETG_TRACE_USR4(( " tuner_tclApp::vTunerShutDownProcess "));
   
   // Tuner Control Service
   vServiceAvailabilityChanged
    (
     CCA_C_U16_SRV_TUNERCONTROL,
     AMT_C_U8_SVCSTATE_NOT_AVAILABLE
    );

   // Diagnostics Service           
   vServiceAvailabilityChanged
    (
     CCA_C_U16_SRV_TUNERDIAG, 
     AMT_C_U8_SVCSTATE_NOT_AVAILABLE
    );
   
   m_bTunerSrvStatus = false;
   m_potun_MsgToHMI->vClearAnnoMessage();
   
   ETG_TRACE_USR4(( " tuner_tclApp::vTunerShutDownProcess,  m_bTunerSrvStatus = %d", m_bTunerSrvStatus));
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   vHandleTunerVariableStatesOnShutdown();
#endif
   	TUN_ASSERT_RETURN( m_ptun_MsgToADR != NULL);
    /*It is required When ADR reset triggers tuner shutdown, notification flag should be set to false.  */
	m_ptun_MsgToADR->vSetNotificationSentStatus(false);
}

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tuner_tclApp::vHandleTunerVariableStatesOnShutdown()
{
	/* Clear member variables*/
	if((m_poclTmcTuner_Method_S_STATIONLIST_EXIT != NULL ) && (m_poclTmcTuner_Method_S_GET_CONFIG_LIST != NULL ))
	{
		ETG_TRACE_USR4(( " tuner_tclApp::vHandleTunerVariableStatesOnShutdown : State Variables cleared "));
		m_poclTmcTuner_Method_S_STATIONLIST_EXIT->vClearAllStationListExitRequests();
		m_poclTmcTuner_Method_S_GET_CONFIG_LIST->vClearOpenStationListsCount();
	}
	if(m_poclAars_ATTunerState != 0)
	{
		m_poclAars_ATTunerState->vClearStates();
		Mute::MuteHandling::clMuteControl::instance()->vClearStates();
	}
}
#endif


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::vSetPWM
 *
 *DESCRIPTION:  Sets Duty cycle and frequency of PWM12
 *
 *PARAMETER:    tU16 u16PWMValue, tU16 u16Freq, tU8 u8Sync_Signal = 0x00
 *
 *RETURNVALUE:  None

 ******************************************************************-FUNCHEADER*/
tVoid tuner_tclApp:: vSetPWM(tU16 u16PWMValue, tU32 u32Freq, tU8 u8Sync_Signal)
{
	ETG_TRACE_USR4(("tuner_tclApp:: vSetPWM entered! u32Freq : %d , u16PWMValue : %d" ,u32Freq,u16PWMValue));
	tS32 s32PWMPeriod = -1;
	tS32 s32PWMDutyCycle = -1;
	
	if(u8Sync_Signal == TUN_PWM_SYNC_SIGNAL1)
	{
		m_u32Sync1Freq = u32Freq;
		m_u16Sync1PWMValue = u16PWMValue;
		s32PWMPeriod = m_hPWMSync1Period;
		s32PWMDutyCycle = m_hPWMSync1DutyCycle;
	}
	else if(u8Sync_Signal == TUN_PWM_SYNC_SIGNAL3)
	{
		m_u32Sync3Freq = u32Freq;
		m_u16Sync3PWMValue = u16PWMValue;
		s32PWMPeriod = m_hPWMSync3Period;
		s32PWMDutyCycle = m_hPWMSync3DutyCycle;
	}
	else if(u8Sync_Signal == TUN_PWM_SYNC_GEN3)
	{
		m_u32Freq = u32Freq;
		m_u16PWMValue = u16PWMValue;
		s32PWMPeriod = m_hPWMPeriod;
		s32PWMDutyCycle = m_hPWMDutyCycle;
	}
	else
	{
		// no handling
	}

	/*Set Duty Cycle and Frequency of PWM12*/

	char cBufferDutyCycle[4];
	memset(cBufferDutyCycle, 0, 4);
	char cBufferPeriod[4];
	memset(cBufferPeriod, 0, 4);
	

	tDouble td_Period = 0;
	tDouble td_DutyCycle = 0;
	/**calculating for period
	period in nano seconds: p = 1/f(Hz) * (pow 10, 9)
	*/
	if(u32Freq != 0)
	{
		/** to solve lint info 741 */
		td_Period = ((1.0/u32Freq)* (pow((double)10,(double)9)));
	}

	/**calculating the duty cycle 
	d = period in nano sec(p) * dutycycle percentage() 
	*/
	/** to solve lint info 741 */
	td_DutyCycle = td_Period*((double)u16PWMValue/100);
	
	/**If duty cycle is 100% or the freq is out of the designated values then CEIL it.*/
	if((DUTYCYCLE_100 == u16PWMValue) || (519500 == u32Freq))
	{
	/** to solve lint info 741 */
		td_Period = ceil((double)td_Period);
		td_DutyCycle = ceil((double)td_DutyCycle);
	}

	OSAL_s32PrintFormat(cBufferDutyCycle, "%d",(tU32)td_DutyCycle );
	OSAL_s32PrintFormat(cBufferPeriod, "%d",(tU32)td_Period);

	int err = 0;
	/**Writing into the period*/
	if(s32PWMPeriod > 0)
	{
		if (write(s32PWMPeriod, &cBufferPeriod, sizeof(cBufferPeriod)) < 0)
		{
			err = errno;
			ETG_TRACE_ERR(("PWM  :: Failed to write in file cDev_Period : (%d) %s\n", err, strerror(err)));
		}
		ETG_TRACE_USR4(("tuner_tclApp:: cBufferPeriod %d", (tU32)td_Period));
	}
	else
	{
		ETG_TRACE_USR4(("tuner_tclApp:: PWMPeriod File Descriptor is not opened "));
	}


	/**Writing into the dutycycle*/
	if(s32PWMDutyCycle > 0)
	{
		if (write(s32PWMDutyCycle, &cBufferDutyCycle, sizeof(cBufferDutyCycle)) < 0)
		{
			err = errno;
			
			ETG_TRACE_USR4(("PWM  :: Failed to write in file duty_cycle :(%d) %s\n",errno,strerror(errno)));
		}
		ETG_TRACE_USR4(("tuner_tclApp:: cBufferDutyCycle %d", (tU32)td_DutyCycle));
	}
	else
	{
		ETG_TRACE_USR4(("tuner_tclApp:: m_hPWMDutyCycle File Descriptor is not opened "));
	}
}



/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::vGetPWMFrequency()
 *
 *DESCRIPTION:  returns frequency
 *
 *PARAMETER:    tU8 u8Sync_Signal
 *
 *RETURNVALUE:  tU32

 ******************************************************************-FUNCHEADER*/
tU32 tuner_tclApp:: vGetPWMFrequency(tU8 u8Sync_Signal) const
{
	if(u8Sync_Signal == TUN_PWM_SYNC_SIGNAL1)
	{
		ETG_TRACE_USR4(("tuner_tclApp:: vGetPWMFrequency entered = %u", m_u32Sync1Freq));
		return m_u32Sync1Freq;
	}
	else if(u8Sync_Signal == TUN_PWM_SYNC_SIGNAL3)
	{
		ETG_TRACE_USR4(("tuner_tclApp:: vGetPWMFrequency entered = %u", m_u32Sync3Freq));
		return m_u32Sync3Freq;
	}
	else if(u8Sync_Signal == TUN_PWM_SYNC_GEN3)
	{
		ETG_TRACE_USR4(("tuner_tclApp:: vGetPWMFrequency entered = %u", m_u32Freq));
		return m_u32Freq;
	}
	else
	{
		return 0;
	}
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::vGetPWMValue()
 *
 *DESCRIPTION:  returns PWMvalue
 *
 *PARAMETER:    tU8 u8Sync_Signal
 *
 *RETURNVALUE:  tU16

 ******************************************************************-FUNCHEADER*/
tU16 tuner_tclApp:: vGetPWMValue(tU8 u8Sync_Signal)const
{
	if(u8Sync_Signal == TUN_PWM_SYNC_SIGNAL1)
	{
		ETG_TRACE_USR4(("tuner_tclApp:: vGetPWMValue entered = %u", m_u16Sync1PWMValue));
		return m_u16Sync1PWMValue;
	}
	else if(u8Sync_Signal == TUN_PWM_SYNC_SIGNAL3)
	{
		ETG_TRACE_USR4(("tuner_tclApp:: vGetPWMValue entered = %u", m_u16Sync1PWMValue));
		return m_u16Sync1PWMValue;
	}
	else if(u8Sync_Signal == TUN_PWM_SYNC_GEN3)
	{
		ETG_TRACE_USR4(("tuner_tclApp:: vGetPWMValue entered = %u", m_u16PWMValue));
		return m_u16PWMValue;
	}
	else
	{
		return 0;
	}
}

tVoid tuner_tclApp::vCreateClassInstances()
{
	/** vnd4kor:
	 if new cannot allocate memory in free store it will throw an exception of type std::bad_alloc. 
	 This removes the need to explicitly check the result of an allocation.
	 if bad_alloc is not caught, the program terminates.
	*/

	/** Hence no need to check if pointer is NULL after assignment with new */

	/** Create new instances of each class */
	try 
	{
		m_potu_Manager = tu_Manager::instance();
		m_potu_Manager->vSet_tuner_tclApp_Ptr( this);
		m_potun_MsgDispatcher = new tun_MsgDispatcher(this );
		m_ptun_RUIF_WaitingThread = new tun_RUIF_WaitingThread( );
		m_ptun_MsgToADR = tun_MsgToADR::instance();
		m_potun_MsgToTunMaster = tun_MsgToTunMaster::instance();
		m_potun_MsgToTunMaster->vSet_tuner_tclApp_Ptr( this);
		m_potun_ActualData = tun_ActualData::instance();
		m_potun_Utility = new tun_Utility;
		m_potun_Config = tun_Config::instance();
		m_potun_tclSPMClient = new tun_tclSPMClient(this);
		m_poclConfigMain = clConfigMain::instance();
		tun_DrvAdrIf::instance();

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20

		vCreateFunctionBlockInterfaceClassInstances();
		vCreateCurrentStateClassInstances();
		vCreateDiagnosisAdjustmentTestFeaturesClassInstances();
		vCreatePresetListClassInstances();
		vCreateStationListClassInstances();
#ifdef VARIANT_S_FTR_ENABLE_DRM
		vCreateDRMClassInstances();
#endif
		vCreateHDClassInstances();
		m_potun_tclVdClockClient = new tun_tclVdClockClient(this, m_poclHDStationLogoManagement);


		m_poclAars_GetConfigurationInfo		= new clAars_GetConfigurationInfo(m_ptun_MsgToADR);
		m_ptun_MsgToADR->vAddFunction(m_poclAars_GetConfigurationInfo);
#endif
		m_poclAars_AdditionalVersionInfo    = new clAars_CM_AdditionalVersionInfo(m_ptun_MsgToADR);
		m_ptun_MsgToADR->vAddFunction(m_poclAars_AdditionalVersionInfo);

		m_poclTmcTuner_stationLogo_map = new clTmcTuner_stationLogo_map(m_poclConfigMain);
#ifndef GTEST_x86LINUX_BUILD
		m_potun_tclSensorClient = new tun_tclSensorClient(this, m_poclTmcTuner_stationLogo_map);
#endif
		vCreateTuningActionsClassInstances();
	}
	catch (...)
	{
		ETG_TRACE_USR4(("Error Allocating Memory!"));
	}


}

tVoid tuner_tclApp::vCreateTuningActionsClassInstances()
{

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	m_poclAars_MTCAudioSource = new clAars_MTCAudioSource(this, m_ptun_MsgToADR,m_potun_ActualData,m_potun_Config,m_poclConfigMain,m_poclAars_CM_UpdateLandscape);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_MTCAudioSource);
	m_poclAars_AudioSource				= new clAars_AudioSource(this, m_ptun_MsgToADR,m_potun_ActualData,m_potun_Config,m_ptun_MsgToADR,m_poclConfigMain,m_poclAars_CM_UpdateLandscape);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_AudioSource);
#endif
	m_poclAars_AtPiSearch	= new clAars_AtPiSearch(m_ptun_MsgToADR);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_AtPiSearch);

}

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tuner_tclApp::vCreateFunctionBlockInterfaceClassInstances()
{
	m_poclAars_CM_Commit	= new clAars_CM_Commit(m_ptun_MsgToADR);

	m_ptun_MsgToADR ->vAddFunction(m_poclAars_CM_Commit);
}

tVoid tuner_tclApp::vCreateCurrentStateClassInstances()
{
	m_poclAars_DemodulationSwitch			= new clAars_DemodulationSwitch(m_ptun_MsgToADR,m_potun_ActualData);
	m_poclAars_CM_UpdateLandscape			= new clAars_CM_UpdateLandscape(m_ptun_MsgToADR,m_poclAars_CM_Commit,m_potu_Manager);
	m_poclAars_CM_UpdateLandscapeProgress   = new clAars_CM_UpdateLandscapeProgress(m_ptun_MsgToADR);
	m_poclAars_AFBestSwitch					= new clAars_AFBestSwitch(m_ptun_MsgToADR);
	m_poclAars_CM_DARC_SetFrequency			= new clAars_CM_DARC_SetFrequency(m_ptun_MsgToADR);
	m_poclAars_CM_DARCGetData				= new clAars_CM_DARCGetData(m_ptun_MsgToADR);

	m_ptun_MsgToADR->vAddFunction(m_poclAars_DemodulationSwitch);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_UpdateLandscape);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_UpdateLandscapeProgress);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_AFBestSwitch);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_DARC_SetFrequency);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_DARCGetData);
}

tVoid tuner_tclApp::vCreateDiagnosisAdjustmentTestFeaturesClassInstances()
{
    m_poclAars_SpecialDiagnosisMode = new clAars_SpecialDiagnosisMode(m_ptun_MsgToADR);
    m_poclAars_SetConfigSections    = new clAars_SetConfigSections(m_ptun_MsgToADR);

    m_poclAars_EnhancedTestMode = new clAars_EnhancedTestMode(m_ptun_MsgToADR);

    m_ptun_MsgToADR->vAddFunction(m_poclAars_SpecialDiagnosisMode);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_SetConfigSections);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_EnhancedTestMode);
}

tVoid tuner_tclApp::vCreatePresetListClassInstances()
{
	m_poclAars_ATPresetList_XX			= new clAars_ATPresetList_XX(m_ptun_MsgToADR,m_potun_Config);
    m_poclAars_ATPresetListSetActive	= new clAars_ATPresetListSetActive(m_ptun_MsgToADR);
    m_poclAars_ATPresetSave				= new clAars_ATPresetSave(m_ptun_MsgToADR);
    m_poclAars_ATPreparePresetStorage	= new clAars_ATPreparePresetStorage(m_ptun_MsgToADR);

	m_ptun_MsgToADR->vAddFunction(m_poclAars_ATPresetList_XX);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_ATPresetSave);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_ATPreparePresetStorage);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_ATPresetListSetActive);
	m_potun_MsgDispatcher->vSet_clAars_ATPresetList_XXPtr(m_poclAars_ATPresetList_XX);
	m_ptun_MsgToADR->vSet_clAars_ATPresetList_XXPtr(m_poclAars_ATPresetList_XX);
	if(m_poclAars_DemodulationSwitch != nullptr)
	{
		m_poclAars_DemodulationSwitch->vSet_clAars_ATPresetList_XXPtr(m_poclAars_ATPresetList_XX);
	}
}

tVoid tuner_tclApp::vCreateStationListClassInstances()
{
	m_poclAars_CM_StationsList			= new clAars_CM_StationsList(m_ptun_MsgToADR);
	m_poclAars_CM_StationListConfig		= new clAars_CM_StationListConfig(m_ptun_MsgToADR,m_poclConfigMain,m_poclAars_CM_StationsList);
	m_poclAars_CM_StationListRelease	= new clAars_CM_StationListRelease(m_ptun_MsgToADR);
	m_poclAars_CM_ChangeOfSurveilledStations = new clAars_CM_ChangeOfSurveilledStations(m_ptun_MsgToADR);
	m_poclAars_CM_ChangeLsm = new clAars_CM_ChangeLsm(m_ptun_MsgToADR);

	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_StationsList);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_StationListConfig);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_StationListRelease);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_ChangeOfSurveilledStations);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_ChangeLsm);
}

#ifdef VARIANT_S_FTR_ENABLE_DRM
tVoid tuner_tclApp::vCreateDRMClassInstances()
{
	m_poclAars_DRMAudioStreamDecoderStatus = new clAars_DRMAudioStreamDecoderStatus(m_ptun_MsgToADR);
	m_poclAars_CM_DRMCurrentRadiotext      = new clAars_CM_DRMCurrentRadiotext(m_ptun_MsgToADR);
    m_poclAars_DRMTestMode = new clAars_DRMTestMode(m_ptun_MsgToADR);
	m_poclAars_CM_ATDRM_AudioServiceDirect = new clAars_CM_ATDRM_AudioServiceDirect(m_ptun_MsgToADR);

	m_ptun_MsgToADR->vAddFunction(m_poclAars_DRMAudioStreamDecoderStatus);
    m_ptun_MsgToADR->vAddFunction(new clAars_DRMLogicalFrame(m_ptun_MsgToADR, m_poclAars_DRMAudioStreamDecoderStatus));
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_DRMCurrentRadiotext);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_DRMTestMode);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_ATDRM_AudioServiceDirect);
}
#endif

tVoid tuner_tclApp::vCreateHDClassInstances()
{
	m_poclAars_ATHDAudioProgram     = new clAars_ATHDAudioProgram(m_ptun_MsgToADR);
	m_poclAars_ATHDAudioProgramDirect   = new clAars_ATHDAudioProgramDirect(m_ptun_MsgToADR);
	m_poclAars_ATHDLongName			= new clAars_ATHDLongName(m_ptun_MsgToADR);
	m_poclAars_ATHDImageFileUpdate	= new clAars_ATHDImageFileUpdate(m_ptun_MsgToADR,m_poclConfigMain);
	m_poclHDStationLogoManagement	= new clHDStationLogoManagement();
	m_poclAars_HDTestMode			= new clAars_HDTestMode(m_ptun_MsgToADR);
	m_poclAars_EvaluationParameter		= new clAars_CM_EvaluationParameter(m_ptun_MsgToADR);

	m_poclclAars_CM_CalibrationData = new clAars_CM_CalibrationData(m_ptun_MsgToADR);

    m_ptun_MsgToADR->vAddFunction(new clAars_HDFirmwareInfo(m_ptun_MsgToADR,m_poclConfigMain));
	
	m_ptun_MsgToADR->vAddFunction(m_poclAars_ATHDAudioProgram);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_ATHDAudioProgramDirect);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_ATHDLongName);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_ATHDImageFileUpdate);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_HDTestMode);
	m_ptun_MsgToADR->vAddFunction(m_poclAars_EvaluationParameter);
	m_ptun_MsgToADR->vAddFunction(m_poclclAars_CM_CalibrationData);
}
#endif

tVoid tuner_tclApp::vCreateDiagnosisClassInstances()
{
	/**vnd4kor:
	 if new cannot allocate memory in free store it will throw an exception of type std::bad_alloc. 
	 This removes the need to explicitly check the result of an allocation.
	 if bad_alloc is not caught, the program terminates.
	*/
	/** Hence no need to check if pointer is NULL after assignment with new */

/** Create new instances of each class */
	try 
	{
	 m_potun_tclDiagHandler =  new tun_tclDiagHandler(this);
 #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	 if(NULL != m_potun_tclDiagHandler)
	 {
		m_potun_tclDiagHandler->vSetclAars_SpecialDiagnosisModePtr(m_poclAars_SpecialDiagnosisMode);
	 }
#endif
     m_potun_MsgFromDiag = new tun_DiagService( this );
     m_potun_DiagManager = new tun_DiagManager(this );
     m_potun_DiaglogHandler = new tun_DiaglogHandler(this);
	}
	catch(...)
	{

	   ETG_TRACE_USR4(("Error Allocating Memory!"));
	   TUN_ASSERT_RETURN( m_potun_tclDiagHandler != NULL);
	   TUN_ASSERT_RETURN( m_potun_MsgFromDiag != NULL);
	   TUN_ASSERT_RETURN( m_potun_DiagManager != NULL);
	   TUN_ASSERT_RETURN( m_potun_DiaglogHandler != NULL);
	}
}

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tuner_tclApp::vCreateGeneralConfigurationClassInstances()
{
	 m_poclAars_ATTunerState = new clAars_ATTunerState(m_ptun_MsgToADR, m_poclAars_AtPiSearch, m_potun_MsgToHMI, m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW);
	 m_ptun_MsgToADR->vAddFunction(m_poclAars_ATTunerState);
}
#endif

tVoid tuner_tclApp::vCreateHMIClassInstances()
{
	/**vnd4kor:
	 if new cannot allocate memory in free store it will throw an exception of type std::bad_alloc. 
	 This removes the need to explicitly check the result of an allocation.
	 if bad_alloc is not caught, the program terminates.
	*/
	/** Hence no need to check if pointer is NULL after assignment with new */

/** Create new instances of each class */
	try 
	{
		m_potun_MsgFromHMI = new tun_MsgFromHMI( this );
		#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		if(m_potun_tclSensorClient != NULL)
		{
			m_potun_tclSensorClient->vSet_tun_MsgFromHMI_ptr(m_potun_MsgFromHMI);
		}
		#endif
		m_potun_MsgToHMI  = tun_MsgToHMI::instance();
		m_potun_MsgToHMI->vSet_tuner_tclApp_Ptr( this);
		m_potun_HMIManager  = new tun_HMIManager( this );
		
		if(NULL!=m_potun_MsgFromHMI)
		{
			m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY = OSAL_NEW clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY(m_potun_MsgFromHMI);
			m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY);
		}
		
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
      if(NULL!=m_potun_MsgFromHMI)
      {
		  m_potun_MsgFromHMI->vAddFunction(OSAL_NEW clTmcTuner_Method_AudioDevice(m_potun_MsgFromHMI));
		  
		  vCreateHMIPresetListClassInstances();
		  vCreateHMIStationListClassInstances();
		  vCreateHMICurrentStateClassInstances();
		  vCreateHMIDiagnosisAdjustmentTestFeaturesClassInstances();
#ifdef VARIANT_S_FTR_ENABLE_DRM
		  vCreateHMIDRMClassInstances();
#endif
		  vCreateHMIHDClassInstances();
		  vCreateHMITuningActionClassInstances();
		  m_poclAars_AudioSource->vSettun_MsgFromHMIImpl(m_potun_MsgFromHMI);
		  m_poclAars_MTCAudioSource->vSettun_MsgFromHMIImpl(m_potun_MsgFromHMI);
		  vCreateHMIJapanStationNameClassInstances();
	  }
#endif

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	  if(m_poclAars_ATPresetList_XX != NULL)
	  {
		  m_poclAars_ATPresetList_XX->vSet_tun_MsgToHMI_Ptr(m_potun_MsgToHMI);
	  }
	  if(m_poclAars_CM_ChangeLsm != NULL)
	  {
		  m_poclAars_CM_ChangeLsm->vSet_tun_MsgToHMI_Ptr(m_potun_MsgToHMI);
	  }
#endif
	  
	  m_poclTmcTuner_AdditionalVersionInfo_Update = new clTmcTuner_AdditionalVersionInfo_Update(this);
	  clTmcTuner_TMCTunerControl::vSetAdditionalVersionInfoImpl(m_poclTmcTuner_AdditionalVersionInfo_Update);

	  if(NULL!=m_ptun_MsgToADR || NULL!=m_poclConfigMain)
	  {
		  m_poclTmcTuner_GetConfigurationInfoStatus = new clTmcTuner_GetConfigurationInfoStatus(m_ptun_MsgToADR,this,m_poclConfigMain);
		  clTmcTuner_TMCTunerControl::vSetGetConfigurationInfoImpl(m_poclTmcTuner_GetConfigurationInfoStatus);
	  }

	  if(NULL!=m_potun_MsgFromHMI)
      {
		  m_poclTmcTuner_Property_AtPiSearch = OSAL_NEW clTmcTuner_Property_AtPiSearch(m_potun_MsgFromHMI,m_poclAars_AtPiSearch);
		  m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_AtPiSearch);
	  }
	  
	  clTmcTuner_TMCTunerControl::vSetAtPiSearchImpl(m_poclTmcTuner_Property_AtPiSearch);
	}
	catch(...)
	{
		
		ETG_TRACE_USR4(("Error Allocating Memory! "));
	}
}

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tuner_tclApp::vCreateHMITuningActionClassInstances()
{
    if(m_ptun_MsgToADR == NULL || m_potun_MsgFromHMI == NULL)
    {
        NORMAL_M_ASSERT (m_ptun_MsgToADR != NULL);
        NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
        return;
    }
    m_poclAars_ATPI  = new clAars_ATPI(m_ptun_MsgToADR);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_ATPI);
    m_poclTmcTuner_Method_S_SET_PI = OSAL_NEW clTmcTuner_Method_S_SET_PI(m_potun_MsgFromHMI, m_poclAars_ATPI);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_SET_PI);
    Mute::MuteHandling::clMuteControl::instance()->vSetMuteTunerImpl(Mute::MuteHandling::ATPI ,m_poclTmcTuner_Method_S_SET_PI);

    m_poclTmcTuner_Property_G_SET_PI = OSAL_NEW clTmcTuner_Property_G_SET_PI();
    clTmcTuner_TMCTunerControl::vSetATPIImpl(m_poclTmcTuner_Property_G_SET_PI);
    
   /*SetUser*/
    m_poclAars_CM_SetUserOptions  = new clAars_CM_SetUserOptions(m_ptun_MsgToADR);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_SetUserOptions);
    m_poclAars_CM_CopyUserContent  = new clAars_CM_CopyUserContent(m_ptun_MsgToADR);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_CopyUserContent);
    m_poclAars_CM_PresetListContentUpdate  = new clAars_CM_PresetListContentUpdate(m_ptun_MsgToADR);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_CM_PresetListContentUpdate);
	if(m_poclAars_CM_SetUserOptions != NULL)
	{
		m_poclAars_CM_SetUserOptions->vSet_tun_MsgToADR_Ptr(m_ptun_MsgToADR);
	}
    m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE = OSAL_NEW clTmcTuner_Method_S_USER_PROFILE_UPDATE(m_potun_MsgFromHMI, m_poclAars_CM_SetUserOptions,m_poclAars_CM_CopyUserContent,m_poclAars_ATPresetList_XX);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE);
    clTmcTuner_TMCTunerControl::vSetCMSetUserOptionsImpl(m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE);
    if (NULL != m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE)
    {
    	m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE->vSet_tun_MsgToADR_Ptr(m_ptun_MsgToADR); ;
    }
    m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE = OSAL_NEW clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE(m_potun_MsgFromHMI, m_poclAars_CM_PresetListContentUpdate,m_poclAars_ATPresetList_XX,m_poclConfigMain);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE);
    clTmcTuner_TMCTunerControl::vSetPresetListContentUpdateImpl(m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE);
    /*Seek*/
    m_poclAars_ATSeek = OSAL_NEW clAars_ATSeek(m_ptun_MsgToADR);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_ATSeek);

    m_poclTmcTuner_Method_S_SEEK = OSAL_NEW clTmcTuner_Method_S_SEEK(m_potun_MsgFromHMI, m_poclAars_ATSeek);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_SEEK);
    Mute::MuteHandling::clMuteControl::instance()->vSetMuteTunerImpl(Mute::MuteHandling::SEEK ,m_poclTmcTuner_Method_S_SEEK);

    m_poclTmcTuner_Property_G_SEEK = OSAL_NEW clTmcTuner_Property_G_SEEK(m_potun_MsgFromHMI);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_SEEK);
    clTmcTuner_TMCTunerControl::vSetATSeekImpl(m_poclTmcTuner_Property_G_SEEK);

    /*ATFrequency*/
    m_poclAars_ATFrequency = OSAL_NEW clAars_ATFrequency(m_ptun_MsgToADR);
    m_ptun_MsgToADR->vAddFunction(m_poclAars_ATFrequency);

    m_poclTmcTuner_Method_S_DIRECT_FREQUENCY = OSAL_NEW clTmcTuner_Method_S_DIRECT_FREQUENCY(m_potun_MsgFromHMI, m_poclAars_ATFrequency);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_DIRECT_FREQUENCY);
    Mute::MuteHandling::clMuteControl::instance()->vSetMuteTunerImpl(Mute::MuteHandling::DIRECTFREQUENCY ,m_poclTmcTuner_Method_S_DIRECT_FREQUENCY);

    m_poclTmcTuner_Property_G_DIRECT_FREQUENCY = OSAL_NEW clTmcTuner_Property_G_DIRECT_FREQUENCY();
    clTmcTuner_TMCTunerControl::vSetATFrequencyImpl(m_poclTmcTuner_Property_G_DIRECT_FREQUENCY);

    m_poclTmcTuner_Method_S_CHANGE_LSM = OSAL_NEW clTmcTuner_Method_S_CHANGE_LSM(m_potun_MsgFromHMI,m_poclAars_CM_ChangeLsm);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_CHANGE_LSM);
	clTmcTuner_TMCTunerControl::vSetChangeLsmImpl(m_poclTmcTuner_Method_S_CHANGE_LSM);
	
    m_poclTmcTuner_Property_G_GET_DARC_DATA=OSAL_NEW clTmcTuner_Property_G_GET_DARC_DATA(m_potun_MsgFromHMI);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_GET_DARC_DATA);
    clTmcTuner_TMCTunerControl::vSetPropertyDARCDataImpl(m_poclTmcTuner_Property_G_GET_DARC_DATA);

    m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST = OSAL_NEW clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST(m_potun_MsgFromHMI,m_poclAars_CM_DARC_SetFrequency);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST);

    m_poclTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE = OSAL_NEW clTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE(m_potun_MsgFromHMI);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE);
	
	vSetDARCClassPointers();
}


tVoid tuner_tclApp::vSetDARCClassPointers()
{
	if(m_poclTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE == NULL || m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST == NULL || m_poclTmcTuner_Property_G_GET_DARC_DATA == NULL)
	{
		NORMAL_M_ASSERT (m_poclTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE != NULL);
		NORMAL_M_ASSERT (m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST != NULL);
		NORMAL_M_ASSERT (m_poclTmcTuner_Property_G_GET_DARC_DATA != NULL);
		return;
	}
	
	m_poclTmcTuner_Property_G_GET_DARC_DATA->vSet_G_GET_DARC_DATA_Ptr(m_poclTmcTuner_Property_G_GET_DARC_DATA);
	m_poclTmcTuner_Property_G_GET_DARC_DATA->vSet_S_DARC_VICS_FREQUENCY_LIST(m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST);
	
	m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST->vSet_G_GET_DARC_DATA_Ptr(m_poclTmcTuner_Property_G_GET_DARC_DATA);
	
	m_poclTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE->vSet_G_GET_DARC_DATA_Ptr(m_poclTmcTuner_Property_G_GET_DARC_DATA);
    m_poclTmcTuner_Method_S_DARC_NO_VICS_DATA_AVAILABLE->vSet_S_DARC_VICS_FREQUENCY_LIST(m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST);
}


tVoid tuner_tclApp::vCreateHMIHDClassInstances()
{
	if(m_potun_MsgFromHMI == NULL || m_poclAars_ATHDAudioProgram == NULL || m_poclAars_ATHDLongName == NULL || m_poclAars_ATHDImageFileUpdate == NULL 
		|| m_poclAars_ATHDAudioProgramDirect == NULL || m_poclAars_EvaluationParameter == NULL || m_poclclAars_CM_CalibrationData == NULL)
	{
		NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT (m_poclAars_ATHDAudioProgram != NULL);
		NORMAL_M_ASSERT (m_poclAars_ATHDLongName != NULL);
		NORMAL_M_ASSERT (m_poclAars_ATHDImageFileUpdate != NULL);
		NORMAL_M_ASSERT (m_poclAars_ATHDAudioProgramDirect != NULL);
		NORMAL_M_ASSERT (m_poclAars_EvaluationParameter != NULL);
		NORMAL_M_ASSERT (m_poclclAars_CM_CalibrationData != NULL);
		return;
	}
	m_potun_MsgFromHMI->vAddFunction(OSAL_NEW clTmcTuner_Method_S_SELECT_HD_AUDIOPRGM(m_potun_MsgFromHMI, m_poclAars_ATHDAudioProgram));
	m_poclTmcTuner_Property_G_HD_AUDIOPRGM = OSAL_NEW clTmcTuner_Property_G_HD_AUDIOPRGM(m_potun_MsgFromHMI,m_poclConfigMain);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_HD_AUDIOPRGM);
	m_poclTmcTuner_Property_G_HD_LONGNAME = OSAL_NEW clTmcTuner_Property_G_HD_LONGNAME(m_potun_MsgFromHMI,m_poclAars_ATHDLongName,m_poclConfigMain);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_HD_LONGNAME);
	m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE = OSAL_NEW clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE(m_potun_MsgFromHMI,m_poclAars_ATHDImageFileUpdate,
			m_potun_MsgToHMI, m_poclHDStationLogoManagement, m_poclConfigMain, m_potun_MsgFromHMI);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE);
	m_poclTmcTuner_Property_G_HD_TEST_MODE_DATA = OSAL_NEW clTmcTuner_Property_G_HD_TEST_MODE_DATA(m_potun_MsgFromHMI,m_poclConfigMain);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_HD_TEST_MODE_DATA);
	m_potun_MsgFromHMI->vAddFunction(OSAL_NEW clTmcTuner_Method_S_SEL_HD_AUDIOPRGMDIRECT(m_potun_MsgFromHMI, m_poclAars_ATHDAudioProgramDirect,m_poclConfigMain));

	m_poclTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE = OSAL_NEW clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE(m_potun_MsgFromHMI, m_poclAars_EvaluationParameter);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE);

	m_poclTmcTuner_Method_S_SET_HD_SECTION_PARAMETER = OSAL_NEW clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER(m_potun_MsgFromHMI, m_poclAars_EvaluationParameter);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_SET_HD_SECTION_PARAMETER);
	
	m_potun_MsgFromHMI->vAddFunction(OSAL_NEW clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT(m_potun_MsgFromHMI, m_poclAars_HDTestMode));

	m_poclTmcTuner_Property_G_AUDIO_SPLIT_MODE = OSAL_NEW clTmcTuner_Property_G_AUDIO_SPLIT_MODE(m_potun_MsgFromHMI,m_poclAars_EvaluationParameter,m_poclConfigMain);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_AUDIO_SPLIT_MODE);

	m_poclTmcTuner_Property_G_HD_SECTION_PARAMETER = OSAL_NEW clTmcTuner_Property_G_HD_SECTION_PARAMETER(m_potun_MsgFromHMI,m_poclAars_EvaluationParameter,m_poclConfigMain);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_HD_SECTION_PARAMETER);

	m_poclTmcTuner_Property_G_CALIBRATION_DATA = OSAL_NEW clTmcTuner_Property_G_CALIBRATION_DATA(m_potun_MsgFromHMI, m_poclclAars_CM_CalibrationData, m_poclAars_EvaluationParameter);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_CALIBRATION_DATA);

	m_poclTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS = OSAL_NEW clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS(m_potun_MsgFromHMI, m_potun_HMIManager);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS);

	clTmcTuner_TMCTunerControl::vSetHDFirmwareInfoImpl(OSAL_NEW clTmcTuner_HDFirwareInfo_Update());
    clTmcTuner_TMCTunerControl::vSetSelectAudioProgramImpl(m_poclTmcTuner_Property_G_HD_AUDIOPRGM);
	clTmcTuner_TMCTunerControl::vSetATHDLongNameImpl(m_poclTmcTuner_Property_G_HD_LONGNAME);
    clTmcTuner_TMCTunerControl::vSetATHDImageFileUpdateImpl(m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE);
    clTmcTuner_TMCTunerControl::vSetHDTestModeImpl(m_poclTmcTuner_Property_G_HD_TEST_MODE_DATA);
	clTmcTuner_TMCTunerControl::vSetAudioSplitModeImpl(m_poclTmcTuner_Property_G_AUDIO_SPLIT_MODE);
    clTmcTuner_TMCTunerControl::vSetHDSectionParameterImpl(m_poclTmcTuner_Property_G_HD_SECTION_PARAMETER);
    clTmcTuner_TMCTunerControl::vSetCalibrationDataImpl(m_poclTmcTuner_Property_G_CALIBRATION_DATA);

    clTmcTuner_TMCTunerControl::vSetEnhancedTestModeImpl(m_poclTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS);
}

#ifdef VARIANT_S_FTR_ENABLE_DRM
tVoid tuner_tclApp::vCreateHMIDRMClassInstances()
{
	if(m_potun_MsgFromHMI == NULL || m_poclAars_CM_DRMCurrentRadiotext == NULL || m_poclAars_DRMTestMode == NULL || NULL==m_poclAars_CM_ATDRM_AudioServiceDirect)
	{
		NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT (m_poclAars_CM_DRMCurrentRadiotext != NULL);
		NORMAL_M_ASSERT (m_poclAars_DRMTestMode != NULL);
		NORMAL_M_ASSERT (m_poclAars_CM_ATDRM_AudioServiceDirect != NULL);
		return;
	}
	m_poclTmcTuner_Property_DrmRadioText=OSAL_NEW clTmcTuner_Property_DrmRadioText(m_potun_MsgFromHMI,m_poclAars_CM_DRMCurrentRadiotext,m_poclConfigMain);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_DrmRadioText);
	m_poclTmcTuner_Method_DRM_TestMode = OSAL_NEW clTmcTuner_Method_DRM_TestMode(m_potun_MsgFromHMI, m_poclAars_DRMTestMode);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_DRM_TestMode);
	m_poclTmcTuner_Property_DRM_TestMode = OSAL_NEW clTmcTuner_Property_DRM_TestMode(m_potun_MsgFromHMI);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_DRM_TestMode);
	m_potun_MsgFromHMI->vAddFunction(OSAL_NEW clTmcTuner_Method_SetDrmSrcActivity(m_potun_MsgFromHMI));
	m_poclTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM = OSAL_NEW clTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM(m_potun_MsgFromHMI,m_potun_ActualData,m_poclAars_CM_ATDRM_AudioServiceDirect);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_SELECT_DRM_AUDIOPRGM);
	m_poclTmcTuner_Method_DRM_ResetMuteCounter = OSAL_NEW clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER(m_potun_MsgFromHMI, m_poclTmcTuner_Property_DRM_TestMode);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_DRM_ResetMuteCounter);

	clTmcTuner_TMCTunerControl::vSetDRMTestModeImpl(m_poclTmcTuner_Property_DRM_TestMode);
	clTmcTuner_TMCTunerControl::vSetDRMRadiotextImpl(m_poclTmcTuner_Property_DrmRadioText);
}
#endif

tVoid tuner_tclApp::vCreateHMICurrentStateClassInstances()
{
	if(m_potun_MsgFromHMI == NULL || m_poclAars_DemodulationSwitch == NULL || m_potun_MsgToHMI == NULL
		|| m_poclAars_AFBestSwitch == NULL)
	{
		NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT (m_poclAars_DemodulationSwitch != NULL);
		NORMAL_M_ASSERT (m_potun_MsgToHMI != NULL);
		NORMAL_M_ASSERT (m_poclAars_AFBestSwitch != NULL);
		return;
	}
	m_poclTmcTuner_Method_SetDemodulationSwitch = OSAL_NEW clTmcTuner_Method_SetDemodulationSwitch(\
		m_potun_MsgFromHMI, m_poclAars_DemodulationSwitch,m_potun_ActualData,m_poclAars_ATPresetList_XX);
	m_poclTmcTuner_Property_DemodulationSwitchStatus = OSAL_NEW clTmcTuner_Property_DemodulationSwitchStatus(m_potun_MsgFromHMI,m_poclAars_DemodulationSwitch, m_potun_MsgToHMI,m_poclTmcTuner_Method_SetDemodulationSwitch);
	m_poclTmcTuner_Method_S_Set_AF = OSAL_NEW clTmcTuner_Method_S_Set_AF(m_potun_MsgFromHMI, m_poclAars_AFBestSwitch, m_potun_MsgToHMI);

	 m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_DemodulationSwitchStatus);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_SetDemodulationSwitch);
	 m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_Set_AF);
	 m_poclTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS= OSAL_NEW clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS(m_potun_MsgFromHMI, m_potun_ActualData);
	 m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS);
	m_poclTmcTuner_Property_G_Mute_Request = OSAL_NEW clTmcTuner_Property_G_Mute_Request(m_potun_MsgFromHMI);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_Mute_Request);
	m_poclTmcTuner_Method_S_AudioMuteRequest = OSAL_NEW clTmcTuner_Method_S_AudioMuteRequest(m_potun_MsgFromHMI);
	m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_AudioMuteRequest);
	m_potun_MsgToHMI->vSet_clAars_DemodulationSwitchPtr(m_poclAars_DemodulationSwitch);

	clTmcTuner_TMCTunerControl::vSetDemodulationImpl(m_poclTmcTuner_Property_DemodulationSwitchStatus);
	clTmcTuner_TMCTunerControl::vSetUpdateLandscapeProgressImpl(m_poclTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS);
	clTmcTuner_TMCTunerControl::vSetMuteRequestImpl(m_poclTmcTuner_Property_G_Mute_Request);
	clTmcTuner_TMCTunerControl::vSetAudioMuteRequestImpl(m_poclTmcTuner_Method_S_AudioMuteRequest);
}

tVoid tuner_tclApp::vCreateHMIDiagnosisAdjustmentTestFeaturesClassInstances()
{
	if(m_potun_MsgFromHMI == NULL || m_poclAars_SpecialDiagnosisMode == NULL || m_potun_Config == NULL || m_poclAars_SetConfigSections == NULL
		|| m_potun_MsgToHMI ==NULL || m_potun_ActualData == NULL || m_poclAars_MTCAudioSource == NULL || m_poclAars_AudioSource == NULL)
	{
		NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT (m_poclAars_SpecialDiagnosisMode != NULL);
		NORMAL_M_ASSERT (m_potun_Config != NULL);
		NORMAL_M_ASSERT (m_poclAars_SetConfigSections != NULL);
		NORMAL_M_ASSERT (m_potun_MsgToHMI != NULL);
		NORMAL_M_ASSERT (m_potun_ActualData != NULL);
        NORMAL_M_ASSERT (m_poclAars_MTCAudioSource != NULL);
        NORMAL_M_ASSERT (m_poclAars_AudioSource != NULL);
		return;
	}
	m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW = OSAL_NEW clTmcTuner_Method_S_AUDIO_FG_BG_NEW(m_potun_MsgFromHMI, m_poclAars_AudioSource, m_poclAars_MTCAudioSource, m_poclAars_SpecialDiagnosisMode, m_potun_MsgToHMI, m_potun_ActualData,m_poclConfigMain);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW);
	m_poclTmcTuner_SetConfigSections = new clTmcTuner_SetConfigSections(m_poclAars_SetConfigSections,m_potun_Config,m_potun_Utility,m_poclConfigMain);
#ifdef VARIANT_S_FTR_ENABLE_DRM
	m_potun_MsgFromHMI->vAddFunction(OSAL_NEW clTmcTuner_Method_TestMode(m_potun_MsgFromHMI,m_poclAars_EnhancedTestMode,m_poclAars_HDTestMode,m_poclAars_DRMTestMode));
#else
	m_potun_MsgFromHMI->vAddFunction(OSAL_NEW clTmcTuner_Method_TestMode(m_potun_MsgFromHMI,m_poclAars_EnhancedTestMode,m_poclAars_HDTestMode));
#endif
	
	clTmcTuner_TMCTunerControl::vSetConfigSectionsImpl(m_poclTmcTuner_SetConfigSections);
	clTmcTuner_TMCTunerControl::vSetAudioFGBGImpl(m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW);
	
	if(m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW != NULL)
	{
		m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW->vSet_tun_MsgFromHMI_Ptr(m_potun_MsgFromHMI);
		m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW->vSet_TmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCYPtr(m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY);
	}
}

tVoid tuner_tclApp::vCreateHMIPresetListClassInstances()
{
	if(m_potun_MsgFromHMI == NULL || m_poclAars_ATPresetList_XX == NULL || m_poclAars_ATPresetSave == NULL || m_potun_MsgToHMI == NULL || m_potun_Config == NULL || m_poclConfigMain == NULL)
	{
		NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT (m_poclAars_ATPresetList_XX != NULL);
		NORMAL_M_ASSERT (m_poclAars_ATPresetSave != NULL);
		NORMAL_M_ASSERT (m_potun_MsgToHMI != NULL);
		NORMAL_M_ASSERT (m_potun_Config != NULL);
		NORMAL_M_ASSERT (m_poclConfigMain != NULL);
		return;
	}
	m_poclTmcTuner_Method_S_GET_STATIC_LIST =OSAL_NEW clTmcTuner_Method_S_GET_STATIC_LIST(m_potun_MsgFromHMI,m_poclAars_ATPresetList_XX);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_GET_STATIC_LIST);
    m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST =OSAL_NEW clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST(m_potun_MsgFromHMI,m_poclAars_ATPresetListSetActive,
    		  	  	  	  	  	  	  	  	  	  	  	m_potun_ActualData,m_poclAars_ATPresetList_XX,m_potun_MsgToHMI,m_poclConfigMain);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST);
    m_poclTmcTuner_Method_S_PRESET_HANDLING=OSAL_NEW clTmcTuner_Method_S_PRESET_HANDLING(m_potun_MsgFromHMI,m_poclAars_ATPresetList_XX,m_poclAars_ATPresetSave);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_PRESET_HANDLING);
    m_poclTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE= OSAL_NEW clTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE(m_potun_MsgFromHMI,m_poclAars_ATPreparePresetStorage);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_PRESET_STORAGE_PS_FREEZE);
    m_poclTmcTuner_Property_G_GET_STATIC_LIST= OSAL_NEW clTmcTuner_Property_G_GET_STATIC_LIST(m_potun_MsgFromHMI,m_potun_MsgToHMI,m_potun_Config,m_potun_HMIManager,m_poclAars_ATPresetList_XX,m_poclConfigMain);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_GET_STATIC_LIST);
    if(m_potun_tclSensorClient != NULL)
	{
    	m_potun_tclSensorClient->vSet_clTmcTuner_Property_G_GET_STATIC_LIST_Ptr(m_poclTmcTuner_Property_G_GET_STATIC_LIST);
	}

    m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID=OSAL_NEW clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID(m_potun_MsgFromHMI , m_potun_MsgToHMI);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID);
    if(m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST != NULL)
    {
        m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST->vSet_G_GET_ACTIVE_PRESETLISTID_Ptr( m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID );
    }

	clTmcTuner_TMCTunerControl::vSetGetStaticListImpl(m_poclTmcTuner_Property_G_GET_STATIC_LIST);
	clTmcTuner_TMCTunerControl::vSetPresetListSetActiveImpl(m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST);
	Mute::MuteHandling::clMuteControl::instance()->vSetMuteTunerImpl(Mute::MuteHandling::PRESETRECALL ,m_poclTmcTuner_Method_S_PRESET_HANDLING);
}

tVoid tuner_tclApp::vCreateHMIStationListClassInstances()
{
	if(m_potun_MsgFromHMI == NULL || m_poclAars_CM_StationListConfig == NULL || m_poclAars_CM_UpdateLandscape == NULL)
	{
		NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT (m_poclAars_CM_StationListConfig != NULL);
		NORMAL_M_ASSERT (m_poclAars_CM_UpdateLandscape != NULL);
		return;
	}
	m_poclTmcTuner_Method_S_GET_CONFIG_LIST= OSAL_NEW clTmcTuner_Method_S_GET_CONFIG_LIST(m_potun_MsgFromHMI,m_poclAars_CM_StationListConfig,m_poclAars_CM_StationsList);
	m_poclTmcTuner_Method_S_GET_CONFIG_LIST ->vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_GET_CONFIG_LIST);
	m_poclTmcTuner_Property_G_GET_CONFIG_LIST=OSAL_NEW clTmcTuner_Property_G_GET_CONFIG_LIST(m_potun_MsgFromHMI,m_potun_ActualData,m_poclAars_CM_StationListConfig,m_potun_MsgToHMI,m_poclConfigMain,m_potun_HMIManager);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_GET_CONFIG_LIST);
    m_poclTmcTuner_Method_S_STATIONLIST_EXIT= OSAL_NEW clTmcTuner_Method_S_STATIONLIST_EXIT(m_potun_MsgFromHMI\
		,m_poclAars_CM_StationListRelease,m_poclTmcTuner_Method_S_GET_CONFIG_LIST);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_STATIONLIST_EXIT);
    m_poclTmcTuner_Method_S_SEL_LIST_ELEM = OSAL_NEW clTmcTuner_Method_S_SEL_LIST_ELEM(m_potun_MsgFromHMI, m_poclConfigMain, m_potun_ActualData
    		,m_poclAars_CM_StationsList ,m_poclTmcTuner_Method_S_STATIONLIST_EXIT,m_poclTmcTuner_Method_S_GET_CONFIG_LIST, m_ptun_MsgToADR);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_SEL_LIST_ELEM);
   	m_poclTmcTuner_Method_S_CONFIGLIST_UPDATE= OSAL_NEW clTmcTuner_Method_S_CONFIGLIST_UPDATE(m_potun_MsgFromHMI,m_poclAars_CM_UpdateLandscape);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_CONFIGLIST_UPDATE);

	clTmcTuner_TMCTunerControl::vSetMethodGetConfigListImpl(m_poclTmcTuner_Method_S_GET_CONFIG_LIST);
	clTmcTuner_TMCTunerControl::vSetPropertyGetConfigListImpl(m_poclTmcTuner_Property_G_GET_CONFIG_LIST);
	clTmcTuner_TMCTunerControl::vSetMethodConfiglistUpdateLandImpl(m_poclTmcTuner_Method_S_CONFIGLIST_UPDATE);
	clTmcTuner_TMCTunerControl::vSetMethodSelectConfiglistElementImpl(m_poclTmcTuner_Method_S_SEL_LIST_ELEM);
	m_poclAars_CM_StationListConfig->vSettun_MsgToHMIptr(m_potun_MsgToHMI);
	Mute::MuteHandling::clMuteControl::instance()->vSetMuteTunerImpl(Mute::MuteHandling::STATIONLIST ,m_poclTmcTuner_Method_S_SEL_LIST_ELEM);
	Mute::MuteHandling::clMuteControl::instance()->vSetMuteTunerImpl(Mute::MuteHandling::CONFIGLISTUPDATE ,m_poclTmcTuner_Method_S_CONFIGLIST_UPDATE);

	m_poclTmcTuner_Method_G_SEL_LIST_ELEM = OSAL_NEW clTmcTuner_Method_G_SEL_LIST_ELEM();
    clTmcTuner_TMCTunerControl::vSetStationListSelectionImpl(m_poclTmcTuner_Method_G_SEL_LIST_ELEM);
	
	
    m_poclTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE=OSAL_NEW clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE(m_potun_MsgFromHMI,m_potun_MsgToHMI,m_poclConfigMain,m_poclAars_CM_StationListConfig, m_poclAars_CM_StationListRelease,m_potun_HMIManager);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE);
    clTmcTuner_TMCTunerControl::vSetPropertySurviellanceListUpdateImpl(m_poclTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE);

    m_poclTmcTuner_Property_G_LISTUPDATE_NOTIFICATION=OSAL_NEW clTmcTuner_Property_G_LISTUPDATE_NOTIFICATION(m_potun_MsgFromHMI);
    m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_LISTUPDATE_NOTIFICATION);
    clTmcTuner_TMCTunerControl::vSetPropertyListUpdateNotificationImpl(m_poclTmcTuner_Property_G_LISTUPDATE_NOTIFICATION);

}

tVoid tuner_tclApp::vCreateHMIJapanStationNameClassInstances()
{
   if((m_potun_MsgFromHMI == NULL) || (m_poclAars_ATPresetList_XX == NULL))
   {
		NORMAL_M_ASSERT(m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT(m_poclAars_ATPresetList_XX != NULL);
		return;
   }
   m_poclJapanStationName = OSAL_NEW clJapanStationName();

   m_poclTmcTuner_Property_G_JAPAN_AREA = OSAL_NEW clTmcTuner_Property_G_JAPAN_AREA(m_potun_MsgFromHMI);
   m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_JAPAN_AREA);

   m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST = OSAL_NEW clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST(m_potun_MsgFromHMI, m_poclJapanStationName);
   m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST);

   m_poclTmcTuner_Method_S_JAPAN_SET_AREA = OSAL_NEW clTmcTuner_Method_S_JAPAN_SET_AREA(m_potun_MsgFromHMI, m_poclJapanStationName, m_poclTmcTuner_Property_G_JAPAN_AREA, m_poclConfigMain, m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST,m_poclAars_ATPresetList_XX);
   m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_JAPAN_SET_AREA);

   m_poclTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME = OSAL_NEW clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME(m_potun_MsgFromHMI, m_poclJapanStationName);
   m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME);

   m_poclTmcTuner_Method_S_LANGUAGE_SETTING = OSAL_NEW clTmcTuner_Method_S_LANGUAGE_SETTING(m_potun_MsgFromHMI, m_poclJapanStationName,m_poclAars_ATPresetList_XX);
   m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_LANGUAGE_SETTING);

   m_poclTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME = OSAL_NEW clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME(m_potun_MsgFromHMI, m_poclJapanStationName, m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST,m_poclAars_ATPresetList_XX);
   m_potun_MsgFromHMI->vAddFunction(m_poclTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME);


}

#endif

tVoid tuner_tclApp::vCreateTraceClassInstances()
{
   m_poHandleTTFISCommands = OSAL_NEW HandleTTFISCommands();
}

tVoid tuner_tclApp::vCreateTraceClassPointers()
{
   if(m_potun_MsgFromHMI == NULL ||
         m_ptun_MsgToADR == NULL ||
         m_potun_Config == NULL ||
         m_potun_ActualData == NULL ||
         _poExemplar == NULL ||
         m_poHandleTTFISCommands == NULL ||
		 m_poclTmcTuner_stationLogo_map == NULL
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
         || m_poclAars_CM_Commit == NULL
#endif
         )
   {
      NORMAL_M_ASSERT(m_potun_MsgFromHMI != NULL);
      NORMAL_M_ASSERT(m_ptun_MsgToADR != NULL);
      NORMAL_M_ASSERT(m_potun_Config != NULL);
      NORMAL_M_ASSERT(m_potun_ActualData != NULL);
      NORMAL_M_ASSERT(_poExemplar != NULL);
      NORMAL_M_ASSERT(m_poHandleTTFISCommands != NULL);
	  NORMAL_M_ASSERT(m_poclTmcTuner_stationLogo_map != NULL);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
      NORMAL_M_ASSERT(m_poclAars_CM_Commit != NULL);
#endif
      return;
   }

   m_poHandleTTFISCommands->vSet_tun_MsgFromHMI_Ptr(m_potun_MsgFromHMI);
   m_poHandleTTFISCommands->vSet_tun_MsgToADR_Ptr(m_ptun_MsgToADR);
   m_poHandleTTFISCommands->vSet_tun_Config_Ptr(m_potun_Config);
   m_poHandleTTFISCommands->vSet_tun_ActualData_Ptr(m_potun_ActualData);
   m_poHandleTTFISCommands->vSet_tun_Main_Ptr(this);
   m_poHandleTTFISCommands->vSet_StationLogoMapPtr(m_poclTmcTuner_stationLogo_map);
   
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   m_poHandleTTFISCommands->vSet_tun_AarsCommit(m_poclAars_CM_Commit);
#endif
}

tVoid tuner_tclApp::vCreateClassPointers()
{
	TUN_ASSERT_RETURN( tun_DrvAdrIf::instance() != NULL);
	TUN_ASSERT_RETURN( m_potun_tclSPMClient != NULL);
	TUN_ASSERT_RETURN( m_potu_Manager != NULL);
	TUN_ASSERT_RETURN( m_potun_MsgDispatcher != NULL);
	TUN_ASSERT_RETURN( m_potun_MsgToTunMaster != NULL);
	TUN_ASSERT_RETURN( m_ptun_RUIF_WaitingThread != NULL);
	TUN_ASSERT_RETURN( m_ptun_MsgToADR != NULL);
	TUN_ASSERT_RETURN( m_potun_ActualData != NULL);
	TUN_ASSERT_RETURN( m_potun_tclSensorClient != NULL);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	TUN_ASSERT_RETURN( m_potun_tclVdClockClient != NULL);
#endif


	   /** Assigning pointers to tun_DrvAdrIf member pointers */
       	tun_DrvAdrIf::instance()->vSet_tunMain_Ptr(this);
       	tun_DrvAdrIf::instance()->vSet_tun_tclSPMClient_Ptr(m_potun_tclSPMClient);
		tun_DrvAdrIf::instance()->vSet_tun_MsgToHMI_Ptr(m_potun_MsgToHMI);
        tun_DrvAdrIf::instance()->vSet_tun_DiaglogHandler_Ptr(m_potun_DiaglogHandler);
        tun_DrvAdrIf::instance()->vSet_tun_ConfigInterface_Ptr(m_poclConfigMain);
   
	   
	 /** Assigning pointers to m_potun_tclSPMClient member pointers */
     m_potun_tclSPMClient->vSet_tun_ActualData_Ptr(m_potun_ActualData);
     m_potun_tclSPMClient -> vSet_tu_Manager_Ptr( m_potu_Manager );
     m_potun_tclSPMClient ->vSet_tun_MsgToADR_Ptr( m_ptun_MsgToADR );
     m_potun_tclSPMClient ->vSet_tun_MsgToHMI_Ptr( m_potun_MsgToHMI );
     m_potun_tclSPMClient ->vSet_tun_HMIManager_Ptr( m_potun_HMIManager );
     m_potun_tclSPMClient ->vSet_tun_Config_Ptr( m_potun_Config );
     m_potun_tclSPMClient ->vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	 m_potun_tclSPMClient ->vSet_UpdateLandscape_Ptr (m_poclAars_CM_UpdateLandscape);
#endif

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	 /** Assigning pointers to m_potun_tclVdClockClient member pointers */
     m_potun_tclVdClockClient ->vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
#endif
#ifndef GTEST_x86LINUX_BUILD
     m_potun_tclSensorClient ->vSet_tun_ConfigInterface_Ptr(m_poclConfigMain);
#endif
     m_potun_Config ->vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );

    /** Assigning pointers to m_potu_Manager member pointers */
     m_potu_Manager ->vSet_tun_MsgToADR_Ptr( m_ptun_MsgToADR );
     m_potu_Manager->vSet_tun_ActualData_Ptr( m_potun_ActualData );
     m_potu_Manager->vSet_tun_config_Ptr( m_potun_Config );
 
	  /** Assigning pointers to m_potun_MsgDispatcher member pointers */
      m_potun_MsgDispatcher -> vSet_tu_Manager_Ptr( m_potu_Manager ); 
      m_potun_MsgDispatcher -> vSet_tun_MsgToHMI_Ptr( m_potun_MsgToHMI );
      m_potun_MsgDispatcher -> vSet_tun_ActualData_Ptr( m_potun_ActualData );
      m_potun_MsgDispatcher -> vSet_tun_HMIManager_Ptr( m_potun_HMIManager );      
      m_potun_MsgDispatcher ->vSet_tun_DiagManager_Ptr( m_potun_DiagManager);
	  m_potun_MsgDispatcher ->vSet_tun_tclDiagHandler( m_potun_tclDiagHandler);
      m_potun_MsgDispatcher -> vSet_tun_MsgToADR_Ptr( m_ptun_MsgToADR );
      m_potun_MsgDispatcher -> vSet_tun_Config_Ptr( m_potun_Config );
      m_potun_MsgDispatcher -> vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
      m_potun_MsgDispatcher -> vSet_tun_MsgToTunMaster_Ptr( m_potun_MsgToTunMaster );
	  m_potun_MsgDispatcher->vSet_tun_MsgFromHMI_Ptr(m_potun_MsgFromHMI);
	  #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	  m_potun_MsgDispatcher->vSet_clAars_ATPresetList_XXPtr(m_poclAars_ATPresetList_XX);
	  m_potun_MsgDispatcher->vSet_TmcTuner_Method_S_SET_ACTIVE_PRESETLISTPtr(m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST);
	  m_potun_MsgDispatcher->vSet_TmcTuner_Method_S_USER_PROFILE_UPDATEPtr(m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE);
	  m_potun_MsgDispatcher->vSet_clAars_DemodulationSwitch(m_poclAars_DemodulationSwitch);
	  m_potun_MsgDispatcher->vSet_TmcTuner_Method_S_JAPAN_SET_AREAPtr(m_poclTmcTuner_Method_S_JAPAN_SET_AREA);
	  #endif
 
	 /** Assigning pointers to m_potun_MsgToTunMaster member pointers */
     m_potun_MsgToTunMaster -> vSet_tun_HMIManager_Ptr( m_potun_HMIManager );
     m_potun_MsgToTunMaster -> vSet_tun_Utility_Ptr( m_potun_Utility );
     m_potun_MsgToTunMaster -> vSet_tun_MsgToHMI_Ptr( m_potun_MsgToHMI );
     m_potun_MsgToTunMaster -> vSet_tun_ActualData_Ptr( m_potun_ActualData );
  
	/** Assigning pointers to m_ptun_RUIF_WaitingThread member pointers */
    m_ptun_RUIF_WaitingThread -> vSet_tun_MsgDispatcher_Ptr( m_potun_MsgDispatcher );
	 /** Assigning pointers to m_ptun_MsgToADR member pointers */
    m_ptun_MsgToADR ->vSet_tun_Utility_Ptr( m_potun_Utility );
     m_ptun_MsgToADR -> vSet_tun_ActualData_Ptr( m_potun_ActualData );
     m_ptun_MsgToADR ->vSet_tun_Config_Ptr( m_potun_Config );
     m_ptun_MsgToADR -> vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
    m_ptun_MsgToADR ->vSet_tun_MsgToHMI_Ptr(m_potun_MsgToHMI);
	m_ptun_MsgToADR ->vSet_tu_Manager_Ptr( m_potu_Manager );
	m_ptun_MsgToADR->vSet_tun_main_Ptr(this);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	m_ptun_MsgToADR->vSet_TmcTuner_Method_S_SET_ACTIVE_PRESETLISTPtr(m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST);
	if(m_poclAars_CM_SetUserOptions != NULL)
	{
		m_ptun_MsgToADR->vSet_SetUserOptions_Ptr(m_poclAars_CM_SetUserOptions);
	}
#endif
	m_ptun_MsgToADR ->vSet_tun_tclDiagHandler( m_potun_tclDiagHandler);

   

   
	   /** Assigning pointers to m_potun_ActualData member pointers */
       m_potun_ActualData ->vSet_tun_Utility_Ptr( m_potun_Utility );
       m_potun_ActualData -> vSet_tun_MsgToADR_Ptr( m_ptun_MsgToADR );
       m_potun_ActualData -> vSet_tun_MsgToHMI_Ptr( m_potun_MsgToHMI );
       m_potun_ActualData->vSet_tun_HMIManager_Ptr(m_potun_HMIManager);
       m_potun_ActualData->vSet_tun_ConfigInterface_Ptr(m_poclConfigMain);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
       m_potun_ActualData->vSet_TmcTuner_Method_S_JAPAN_SET_AREAPtr(m_poclTmcTuner_Method_S_JAPAN_SET_AREA);
#endif
}

tVoid tuner_tclApp::vCreateHMIClassPointers()
{
	if( m_potun_MsgFromHMI != NULL )
   {
     m_potun_MsgFromHMI -> vSet_tu_Manager_Ptr( m_potu_Manager );
     m_potun_MsgFromHMI -> vSet_tun_MsgToADR_Ptr( m_ptun_MsgToADR );
     m_potun_MsgFromHMI -> vSet_tun_MsgToHMI_Ptr( m_potun_MsgToHMI );
     m_potun_MsgFromHMI ->vSet_tun_ActualData_Ptr( m_potun_ActualData );
     m_potun_MsgFromHMI ->vSet_tun_Config_Ptr( m_potun_Config );
     m_potun_MsgFromHMI -> vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
     m_potun_MsgFromHMI ->vSet_tun_Utility_Ptr( m_potun_Utility );
     m_potun_MsgFromHMI ->vSet_tun_HMIManager_Ptr( m_potun_HMIManager );
	 #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	 m_potun_MsgFromHMI->vSet_clAars_ATPresetListSetActive_Ptr(m_poclAars_ATPresetListSetActive);
	 m_potun_MsgFromHMI->vSet_clTmcTuner_AudioFGBGNEW_Ptr(m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW);
	#endif
   }

   if( m_potun_MsgToHMI != NULL )
   {
      m_potun_MsgToHMI -> vSet_tun_HMIManager_Ptr( m_potun_HMIManager );
      m_potun_MsgToHMI ->vSet_tun_ActualData_Ptr( m_potun_ActualData );
      m_potun_MsgToHMI -> vSet_tun_MsgToADR_Ptr( m_ptun_MsgToADR );
      m_potun_MsgToHMI ->vSet_tun_Utility_Ptr( m_potun_Utility );
      m_potun_MsgToHMI->vSet_tun_Config_Ptr( m_potun_Config );
      m_potun_MsgToHMI -> vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
      m_potun_MsgToHMI->vSet_tun_MsgFromHMI_Ptr(m_potun_MsgFromHMI);
#ifndef GTEST_x86LINUX_BUILD
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
      m_potun_MsgToHMI->vSet_tun_GetConfigInfoStatus_Ptr(m_poclTmcTuner_GetConfigurationInfoStatus);
	  m_potun_MsgToHMI->vSet_tun_AudioFgBg_Ptr(m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW);
#endif
#endif
      #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
      m_potun_MsgToHMI->vSet_clAars_ATPresetList_XXPtr(m_poclAars_ATPresetList_XX);
      m_potun_MsgToHMI->vSet_TmcTuner_Method_S_SET_ACTIVE_PRESETLISTPtr(m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST);
      m_potun_MsgToHMI->vSet_TmcTuner_Method_S_JAPAN_SET_AREAPtr(m_poclTmcTuner_Method_S_JAPAN_SET_AREA);
      m_potun_MsgToHMI->vSet_TmcTuner_Method_S_USER_PROFILE_UPDATEPtr(m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE);
	  m_potun_MsgToHMI->vSet_TmcTuner_Method_S_PRESETLIST_CONTENT_UPDATEPtr(m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE);
	  #endif
	  m_potun_MsgToHMI->vSet_TmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCYPtr(m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY);
   }
   
      if( m_potun_HMIManager != NULL )
   {
     m_potun_HMIManager ->vSet_tun_ActualData_Ptr( m_potun_ActualData );
     m_potun_HMIManager ->vSet_tun_Utility_Ptr( m_potun_Utility );
     m_potun_HMIManager->vSet_tun_Config_Ptr( m_potun_Config );
     m_potun_HMIManager -> vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
     m_potun_HMIManager -> vSet_tun_MsgToADR_Ptr( m_ptun_MsgToADR );
   }
}

tVoid tuner_tclApp::vCreateDiagnosisClassPointers()
{
	   if( m_potun_MsgFromDiag != NULL )
   {
     m_potun_MsgFromDiag ->vSet_tun_DiagManager_Ptr(m_potun_DiagManager);
     m_potun_MsgFromDiag ->vSet_tun_MsgToADR_Ptr(m_ptun_MsgToADR);
     m_potun_MsgFromDiag ->vSet_tun_Config_Ptr(m_potun_Config);
     m_potun_MsgFromDiag -> vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
     m_potun_MsgFromDiag ->vSet_tun_DiaglogHandler_Ptr(m_potun_DiaglogHandler);
     m_potun_MsgFromDiag ->vSet_tun_ActualData_Ptr(m_potun_ActualData);
     m_potun_MsgFromDiag ->vSet_tun_HMIManager_Ptr(m_potun_HMIManager);
   }

   if( m_potun_DiagManager != NULL )
   {
     m_potun_DiagManager ->vSet_tun_Diagnostics_Ptr(m_potun_MsgFromDiag);
     m_potun_DiagManager ->vSet_tun_MsgToADR_Ptr(m_ptun_MsgToADR);
     m_potun_DiagManager ->vSet_tun_Utility_Ptr(m_potun_Utility);
     m_potun_DiagManager ->vSet_tun_DiaglogHandler_Ptr (m_potun_DiaglogHandler);
	 m_potun_DiagManager ->vSet_tun_DiagHandler_Ptr (m_potun_tclDiagHandler);
   }
  
    
   if(m_potun_tclDiagHandler!=NULL)
   {
	   m_potun_tclDiagHandler->vSet_tun_MsgToADR_Ptr(m_ptun_MsgToADR);
	   m_potun_tclDiagHandler->vSet_tun_ConfigInterface_Ptr( m_poclConfigMain );
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	   m_potun_tclDiagHandler->vSetHDStationLogoManagement(m_poclHDStationLogoManagement);
#endif
   }
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::vDeleteClassInstances()
 *
 *DESCRIPTION:  Delete class instances
 *
 *PARAMETER:    
 *
 *RETURNVALUE:  tVoid

 ******************************************************************-FUNCHEADER*/
/** vnd4kor: Solving logiscope maintainability "POOR" issue.
 Deleting a null pointer has no effect (if the deallocation 
 function is one supplied  in the standard library), so 
 it is not necessary to check for a null pointer before 
 calling delete. 

 Osal internally uses
 #define OSAL_DELETE delete 

 vDeleteNoThrow assigns pointer to 0, hence assigning NULL 
 again is redundant
 */
tVoid tuner_tclApp::vDeleteClassInstances()
{
	/** Comments added to satisfy logiscope , 
	which is otherwise very obvious*/

	/** Delete MsgToADR pointer */
	vDeleteNoThrow (m_ptun_MsgToADR);
	/** Delete ActualData pointer */
	vDeleteNoThrow (m_potun_ActualData);
	/** Delete RUIF_WaitingThread pointer */
	vDeleteNoThrow (m_ptun_RUIF_WaitingThread);
	/** Delete MsgDispatcher pointer */
	vDeleteNoThrow (m_potun_MsgDispatcher);
	/** Delete Manager pointer */
	vDeleteNoThrow (m_potu_Manager);
	/** Delete Utility pointer */
	vDeleteNoThrow( m_potun_Utility);
	/** Delete MsgToTunMaster pointer */
	vDeleteNoThrow (m_potun_MsgToTunMaster);
	/** Delete Config pointer */
	vDeleteNoThrow (m_potun_Config);
	/** Delete Config pointer **/
	vDeleteNoThrow (m_poclConfigMain);
	/** Delete PortMngr pointer */
	vDeleteNoThrow(m_poPortMngr);
	/** Delete DrvAdrIf pointer */
	OSAL_DELETE tun_DrvAdrIf::instance();
	/** Delete SPMClient pointer */
	vDeleteNoThrow(m_potun_tclSPMClient);
	vDeleteNoThrow(m_podp_tclTunerImpl);
	vDeleteNoThrow(m_potun_tclSensorClient);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	/** Delete VdClockClient pointer */
	vDeleteNoThrow(m_potun_tclVdClockClient);
#endif
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::vDeleteHMIClassInstances()
 *
 *DESCRIPTION:  Delete class instances
 *
 *PARAMETER:    
 *
 *RETURNVALUE:  tVoid

 ******************************************************************-FUNCHEADER*/
/** vnd4kor: Solving logiscope maintainability "POOR" issue */
tVoid tuner_tclApp::vDeleteHMIClassInstances()
{
	/** Comments added to satisfy logiscope , 
	which is otherwise very obvious*/

	/** Delete HMIManager pointer */
     vDeleteNoThrow (m_potun_HMIManager);
	 /** Delete MsgToHMI pointer */
	 vDeleteNoThrow (m_potun_MsgToHMI);
	 /** Delete MsgFromHMI pointer */
     vDeleteNoThrow (m_potun_MsgFromHMI);
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tuner_tclApp::vDeleteDiagnosisClassInstances()
 *
 *DESCRIPTION:  Delete class instances
 *
 *PARAMETER:    
 *
 *RETURNVALUE:  tVoid

 ******************************************************************-FUNCHEADER*/
/** vnd4kor: Solving logiscope maintainability "POOR" issue */
tVoid tuner_tclApp::vDeleteDiagnosisClassInstances()
{
	/** Comments added to satisfy logiscope , 
	which is otherwise very obvious*/

	/** Delete MsgFromDiag pointer */
	 vDeleteNoThrow(m_potun_MsgFromDiag);
	/** Delete DiagManager pointer */
 	 vDeleteNoThrow(m_potun_DiagManager);
	/** Delete DiaglogHandler pointer */
 	 vDeleteNoThrow(m_potun_DiaglogHandler);
}

/* *****************************************************************************

   FUNCTION:      vDeleteNoThrow

   DESCRIPTION:   Deletes memory without throwing an exception.

   PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

   RETURN TYPE:   void

   HINT:          Why this function? If delete is called inside the destructor,
                  Lint complains with warning 1551 that delete might throw an
                  execption, which is not caught.

                  But try / catch must not be used, and delete does not throw
                  an exception, anyway. To prevent a Lint warning deactivation,
                  this function guarantees that no exception is thrown.
                  Furthermore, it sets the given pointer to 0, and Lint is
                  happy.

                  It is a template, because two different memory types have to
                  be deleted inside this class.

----------------------------------------------------------------------------- */

template< class T > void tuner_tclApp::vDeleteNoThrow( T*& rfpArg ) throw()
{
   OSAL_DELETE rfpArg;
   rfpArg = 0;
}

tU16 tuner_tclApp::u16GetRegID_TPEG()const
{
	return m_u16TPEGRegID;
}


tU16 tuner_tclApp::u16GetRegID_TM()const
{
	return m_u16TMRegID;
}

tU16 tuner_tclApp::u16GetRegID_UI()const
{
	return m_u16UIRegID;
}
tVoid tuner_tclApp::vSetRestartTimeValue(tU32 tenRestartTimeValue)
{
	//ETG_TRACE_ERR(("AMFMADR3::vSetRestartTimeValue timervalue:%d", tenRestartTimeValue));
	m_enRestartTimeValue=tenRestartTimeValue;
	if(tenRestartTimeValue!=enNoError)
	{
		(tVoid)OSAL_s32TimerSetTime(_hTimerHandler,_theServer->m_enRestartTimeValue, 0);
	}
	ETG_TRACE_ERR(("AMFMADR3::vSetRestartTimeValue timervalue:%d", tenRestartTimeValue));
}
tU32 tuner_tclApp::u32GetRestartTimeValue()
{
	return m_enRestartTimeValue;
}

tBool tuner_tclApp::bCheckAIVI_SBRVariant()
{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	if( m_poclConfigMain != NULL)
	{
		if(m_poclConfigMain->u32GetConfigData("SBR"))
		{
			ETG_TRACE_USR4(("bCheckAIVI_SBRVariant:: SBR AIVI variant"));
			return true;
		}
	}
#endif
	return false;
}

/*** END OF FILE *************************************************************/
