/************************************************************************
* FILE:           tun_MsgToTunMaster.cpp
* PROJECT:        Ford H/L RNS
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All messages sent to HMI are handled in this file.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 01.04.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
*
*************************************************************************/



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 
/*----------------------------------------------------------------------*/

#include "tun_Utility.h"

#include "tun_defines.h"

#include "tun_Manager.h"
#include "tun_HMIManager.h"

#include "tun_MsgToHMI.h"

#include "tun_main.h"
#include "tun_MsgToADR.h"

#include "tun_Config.h"

#include "tun_MsgtoTunMaster.h"
#include "tun_trace.h"

#include "tun_hmi_fid_if.h"

#include "tun_ActualData.h"
#include "tun_FI_HelpFunc.h"


#include "tun_Diagnostics.h"
#include "tun_DiagManager.h"

//#define MANUAL_TO_FI_CLASSES
OSAL_tSemHandle tun_MsgToTunMaster::m_hNotHMITableSem  = OSAL_C_INVALID_HANDLE;


/*****************************************************************************
 * ETG trace
 * 0x260C:    TUN_TRACE_CLASS_MSGTOHMI
 ****************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI 
#include "trcGenProj/Header/tun_MsgToTunMaster.cpp.trc.h"
#endif


/*************************************************************************
*
* FUNCTION:     tun_MsgToTunerMaster::tun_MsgToTunerMaster( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tun_MsgToTunMaster::tun_MsgToTunMaster( tVoid ): m_potun_HMIManager( NULL ), m_potun_MsgToHMI( NULL ),
                                                 poGWMain( NULL ), m_potun_Utility( NULL ), m_potun_ActualData(NULL)
{
	tS32 ret = OSAL_s32SemaphoreCreate(TUNER_TUNERMASTER_NOTTABLE_SEM_NAME, &m_hNotHMITableSem, 1);
	ETG_TRACE_USR1(( " tun_MsgToTunMaster::tun_MsgToTunMaster() -> Ret =%d",ret)); 
    
  // Initialize notification table array.
  //::memset(m_aFuncID_HMI_Array, 0, sizeof(m_aFuncID_HMI_Array));
  //::memset(m_aNotArray_HMI, 0, sizeof(m_aFuncID_HMI_Array));

  vSubscribe< trMsg_CM_ATStationInfo_Status>();  // -> vMessage( trMsg_CM_ATStationInfo_Status* prMsg)

}//End of constructor

/*************************************************************************
*
* FUNCTION:     tun_MsgToTunerMaster::~tun_MsgToTunerMaster( )
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tun_MsgToTunMaster::~tun_MsgToTunMaster( )
{
  OSAL_s32SemaphoreClose( m_hNotHMITableSem );   
  OSAL_s32SemaphoreDelete( TUNER_TUNERMASTER_NOTTABLE_SEM_NAME );
  
  m_potun_HMIManager = NULL;
  m_potun_MsgToHMI = NULL;
  poGWMain = NULL;
  m_potun_Utility = NULL;
  m_potun_ActualData = NULL;

}//End of Destructor


/*************************************************************************
*
* FUNCTION:     tun_MsgToTunerMaster::vSet_tuner_tclApp_Ptr( )
* 
* DESCRIPTION:  The access of config class pointer.
*
* PARAMETER:    poGWMain*
*
* RETURNVALUE:  tVoid
*
*************************************************************************/
tVoid tun_MsgToTunMaster::vSet_tuner_tclApp_Ptr( tuner_tclApp* potunerMainApp)
{
  if( potunerMainApp != NULL )
  {
    poGWMain = ( tuner_tclApp* )potunerMainApp;
  }
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToTunerMaster::vSet_tun_HMIManager_Ptr( )
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToTunMaster::vSet_tun_HMIManager_Ptr( tun_HMIManager* potun_HMIManager )
{
  if( potun_HMIManager != NULL )
  {
    m_potun_HMIManager = potun_HMIManager;
  }
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToTunerMaster::vSet_tun_HMIManager_Ptr( )
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToTunMaster::vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI )
{
  if( potun_MsgToHMI != NULL )
  {
    m_potun_MsgToHMI = potun_MsgToHMI;
  }
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToTunerMaster::vSet_tun_Utility_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToTunMaster::vSet_tun_Utility_Ptr( tun_Utility* potun_Utility )
{
  if( potun_Utility != NULL )
  {  
    m_potun_Utility = potun_Utility;
  }
  else
  {
    /* Assert to do */
  }
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToTunerMaster::vSet_tun_HMIManager_Ptr( )
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToTunMaster::vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData )
{
  if( potun_ActualData != NULL )
  {
    m_potun_ActualData = potun_ActualData;
  }
}
/*******************************************************************************
*FUNCTION:    tun_MsgToTunerMaster::vGetDatafromAMT
*
*DESCRIPTION: This function converts Amt message to visitor class and 
*             get the data from visitor to the Fi class. Refer FI Manual.
*             Doc.
*
*PARAMETER:    
*           poFiMsg   - Amt Message 
*           oFIData   - Base class of Fi class 
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_MsgToTunMaster::vGetDatafromAMT( amt_tclServiceData* poFIMsg,
                                        fi_tclTypeBase&     oFIData )const
{
   // Create Visitor message object for incoming message
   fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

   /* Get the data in FI class from Vistor class*/   
   if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
   {
      // assert here 
      NORMAL_M_ASSERT_ALWAYS ();
   }

}


/****************************************************************************
*FUNCTION:    tun_MsgToTunerMaster::vSendMessage
*
*DESCRIPTION: This function converts Amt message to visitor class and 
*             get the data from visitor to the Fi class. Refer FI Manual.Doc.
*
*PARAMETER:    
*             u16DestAppID      - Destination ID of Out Msg  
*             oOutData          - Base class of out going Fi object
*             u16Fid            - Funtion id of the out going message
*             u8OpCode          - Opcode of the message 
*
*RETURNVALUE: None
******************************************************************************/
tVoid tun_MsgToTunMaster::vSendMessage( tU16             u16DestAppID,
                                  const fi_tclTypeBase&  oOutData,
                                     tU16             u16Fid,
                                     tU8              u8OpCode,
                                     tU16             u16CmdCtr,
                                     tU16             u16RegId)
{

  TUN_ASSERT_RETURN( poGWMain != NULL);

  // Create the Visitor Message
  fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);

  // Set the CCA message information
  oOutVisitorMsg.vInitServiceData(
         CCA_C_U16_APP_TUNER,                      /* Source app-ID    */
         u16DestAppID,                             /* Dest. app-ID     */
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,        /* stream type      */
         0,                                        /* stream counter   */
         u16RegId,                                 /* Registry ID      */
         u16CmdCtr,                                /* Command counter  */
         CCA_C_U16_SRV_TUNERCONTROL,               /* Service-ID       */
         u16Fid,                                   /* Function-ID      */
         u8OpCode,                                 /* OpCode           */
         0,                                        /* ACT              */
         0,                                        /* Source sub-ID    */
         0 );                                      /* Dest. sub-ID     */

  
    /* ---
    send it to the client 
    --- */
    if(poGWMain->enPostMessage( &oOutVisitorMsg, TRUE ) != AIL_EN_N_NO_ERROR)
    {
      // Message sent successfully.
      ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI, ET_EN_T8 _ 255 _ ET_EN_T16 _ u16Fid _  ET_EN_DONE);
    }
    else
    {
      // Message not sent successfully.
      ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI, ET_EN_T8 _ 0x55 _ ET_EN_T16 _ u16Fid _  ET_EN_DONE);
    }
  }
/******************************************************************************

  FUNCTION:      vDeleteNoThrow

  DESCRIPTION:   Deletes memory without throwing an exception.

  PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

  RETURN TYPE:   void

  HINT:          Why this function? If delete is called inside the destructor,
                 Lint complains with warning 1551 that delete might throw an
                 execption, which is not caught.

                 But try / catch must not be used, and delete does not throw
                 an exception, anyway. To prevent a Lint warning deactivation,
                 this function guarantees that no exception is thrown.
                 Furthermore, it sets the given pointer to 0, and Lint is
                 happy.

                 It is a template, because two different memory types have to
                 be deleted inside this class.

----------------------------------------------------------------------------- */

template< class T > void tun_MsgToTunMaster::vDeleteNoThrow( T*& rfpArg ) throw()
{
   OSAL_DELETE rfpArg;
   rfpArg = 0;
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToTunerMaster::vHandle_r_Get_Data_TMC( )
* 
* DESCRIPTION:  Handle TUN_R_GET_DATA_TMC response from Radio Unit.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToTunMaster::vSend_g_Component_Status( )
{
#if 0
  if( ( m_potun_ActualData == NULL ) || ( m_potun_MsgToHMI == NULL ))
   {

    NORMAL_M_ASSERT( m_potun_ActualData != NULL );
    NORMAL_M_ASSERT( m_potun_MsgToHMI != NULL );
    return;
  }


  ahl_bEnterCritical( m_hNotHMITableSem );


  tU16 u16FunctionId = MIDW_TUNERFI_C_U16_FID_TUN_G_COMPONENT_STATUS_TUNER;

  for(ahl_tNotification* pNot =
                m_potun_MsgToHMI->m_poHMINotTable->poGetNotificationList(u16FunctionId);
        pNot != OSAL_NULL;
        pNot=pNot->pNext)
  {
        
    midw_tunerfi_tclMsgFID_TUN_G_COMPONENT_STATUS_TUNERStatus oStatusMsg;


    ET_TRACE_INFO_BIN(TUN_TRACE_CLASS_MSGTOHMI,\
                       ET_EN_T16 _ FID_TUN_G_COMPONENT_STATUS_TUNER _
                       ET_EN_DONE );


   
    oStatusMsg.Component_status.u8AudioSinkTUN1 = m_potun_ActualData->m_otun_Data_MainStatus.u8GetAudioSinkTuner();
	oStatusMsg.Component_status.u8BGModeTuner = m_potun_ActualData->m_otun_Data_MainStatus.u8GetBackgroundModeTuner();

    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                            ET_EN_T16 _ FID_TUN_G_COMPONENT_STATUS_TUNER _\
                            ET_EN_T16 _ TUN_TRACE_MSG_TO_HMI_STATUS_MSG _\
                            ET_EN_T8  _ oStatusMsg.Component_status.u8AudioSinkTUN1 _\
                            ET_EN_T16 _ oStatusMsg.Component_status.u8BGModeTuner _\
                            ET_EN_DONE);


    vSendMessage ( pNot->u16AppID,
                         oStatusMsg,
                         u16FunctionId,
                         AMT_C_U8_CCAMSG_OPCODE_STATUS,
                         pNot->u16CmdCounter,
                         pNot->u16RegisterID );

    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                            ET_EN_T16 _ FID_TUN_G_COMPONENT_STATUS_TUNER _\
                            ET_EN_T16 _ 0xffff _\
                            ET_EN_DONE);
  } /* for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
              pNot != OSAL_NULL;
              pNot=pNot->pNext) */

  ahl_bReleaseCritical(m_hNotHMITableSem);

#endif
}

tVoid tun_MsgToTunMaster::vMessage( trMsg_CM_ATStationInfo_Status* pu8Message) const
{
  if(pu8Message == NULL)
   {

        NORMAL_M_ASSERT( pu8Message != NULL );

      return;
   }

  
}
