/************************************************************************
* FILE:           tun_MsgToHMI.cpp
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All messages sent to HMI are handled in this file.
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------

* HISTORY:      
* Date      | Author                       | Modification
* 01.04.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
*
*************************************************************************/



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 
/*----------------------------------------------------------------------*/

#include "tun_Utility.h"

#include "tun_Manager.h"
#include "tun_HMIManager.h"

#include "tun_main.h"
#include "tun_MsgToADR.h"

#include "tun_PrjConfig.h"
#include "tun_Config.h"

#include "tun_MsgToHMI.h"
#include "tun_trace.h"

//#include "tun_hmi_if_message.h"

#include "tun_hmi_fid_if.h"

#include "tun_ActualData.h"
#include "tun_MsgFromHMI.h"

#include "tun_Msg_types.h"

#include "tun_MsgDefines.h"
#include "tun_FI_HelpFunc.h"

#include "tun_Diagnostics.h"
#include "tun_DiagManager.h"
#include "tun_DrvAdrIf.hpp"
#include "TunerApp/clTmcTuner_stationLogo_map.h"
#include "Aars/clAars_AtPiSearch.h"
#include "kdsconfig/clConfigInterface.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#include "AMFMTuner/clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "Aars/clAars_DemodulationSwitch.h"
#include "AMFMTuner/clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST.h"
#include "AMFMTuner/clTmcTuner_Method_S_AUDIO_FG_BG_NEW.h"
#include "Aars/clAars_HDTestMode.h"
#include "AMFMTuner/clTmcTuner_Method_S_JAPAN_SET_AREA.h"
#include "AMFMTuner/clTmcTuner_Method_S_USER_PROFILE_UPDATE.h"
#include "AMFMTuner/clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE.h"
#include "TunerApp/clTmcTuner_GetConfigurationInfoStatus.h"
#endif
#include "AMFMTuner/clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY.h"

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#include "dp_generic_if.h"
#else
   #include"diaglib_if.h"
#endif


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/tun_MsgToHMI.cpp.trc.h"
#endif

//#define MANUAL_TO_FI_CLASSES
OSAL_tSemHandle tun_MsgToHMI::m_hNotHMITableSem  = OSAL_C_INVALID_HANDLE;


#define TMC_SELECTIONFILTER_MASK_SIZE 1
#define TMC_SELECTIONFILTER_MGS  1
#define TMC_SELECTIONFILTER_BSA  2 



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::tun_MsgToHMI( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tun_MsgToHMI::tun_MsgToHMI( tVoid )                       : m_potun_HMIManager( NULL ), poGWMain( NULL ),
                                                            m_potun_ActualData( NULL ), m_potun_MsgToADR( NULL ),
                                                            m_potun_Utility( NULL ),\
                                                            m_potun_Config(NULL),\
                                                            m_poclConfigInterface(NULL),\
															m_potun_MsgFromHMI(NULL)
{	
	m_u16ListIdOfSetActivePresetList = 0xff;
	m_u16AMActivePresetListId =0xff;
	m_u16FMActivePresetListId = 0xff;
	m_u16DRMActivePresetListId = 0xff;
	m_bSendAutostoreMthdResult = false;
	m_u8RDSSwitchStatus = 0;
	m_u32AnnoInfoFreq = 0;
	m_u16AnnoInfoPI = 0;
	m_utf8StringPSName = NULL;
	m_u8AnnoInfoType = 0;
	m_u8AtStaInfoQuality = 0;
	m_u32AtStaInfoFreq = 0;
	m_u8AnnoMessage = 0;
	m_u8AFSwitch = 0;
	#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
	   m_u8BGAnnoMessage = 0;
       m_enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_PTY_OFF;
	#endif
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	m_poclAars_ATPresetList_XX=NULL;
	m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST=NULL;
	m_poclTmcTuner_Method_S_JAPAN_SET_AREA = NULL;
	m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE = NULL;
	m_poclAars_DemodulationSwitch = NULL;
	m_poclTmcTuner_GetConfigurationInfoStatus = NULL;
	m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW = NULL;
	m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE = NULL;
#endif
	m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY = NULL;

  fFeatureFlag = false;
  fAntennaFlag = false;
  m_u8PhysicalTuner  = 0;
  m_u8TunerState = 0; //Idle
  m_u8SeekState = 0; //Off
  m_u8TunFGBG = (tU8)enAudioSource_No_audio;
	bSystemPresets = false;
	u8SystemPresets_Band = 0xFF;
	m_u8AnnoSwitchState = 0;
	m_u32ATStationFreq = 0;
  m_u16DiagRegID = 0;
    m_u16CommandCntr = 0;
  m_u16TMCommandCntrActiveTuner = 0;
  m_u16TMCommandCntrSetRdbid = 0;
  m_u16TMCommandCntrBandChange = 0;
  m_u16BandChangeRegID =0;
	m_u16TMCommandCntrFGBG = 0;
  m_u16FGBGRegID =0;
	m_u16TMCommandCntrDirectFreq =0;
  m_u16DirectFreqID =0;
	m_u16TMDiagRegID = 0;
  m_bDirectFreqReq = false;
  m_u16TMSetRDBISRegID = 0;
  m_u16CmdCtrForPresetRecall = 0;
  m_u16CmdCtrForTMCConfigList = 0;
  m_u16CmdCtrForAutostore = 0;
  
	m_u8PrevBand = 0xFF;

  tS32 ret = OSAL_s32SemaphoreCreate(TUNER_HMI_NOTTABLE_SEM_NAME, &m_hNotHMITableSem, 1);
  ETG_TRACE_USR1((" tun_MsgToHMI::tun_MsgToHMI() ret = %d",ret));
    
  // Initialize notification table array.
  //::memset(m_aFuncID_HMI_Array, 0, sizeof(m_aFuncID_HMI_Array));
  //::memset(m_aNotArray_HMI, 0, sizeof(m_aFuncID_HMI_Array));

  /* ---
  create HMI NotificationTable.
  Here we store information about all HMI registered clients
  --- */
  m_poHMINotTable = new ahl_tclNotificationTable( TUNER_HMI_FUNID_CARRAY_SIZE); 
  //m_poHMINotTable = new ahl_tclNotificationTable( m_aFuncID_HMI_Array, 
  //                                                 TUNER_HMI_FUNID_CARRAY_SIZE,       
  //                                                 m_aNotArray_HMI,  
  //                                                 TUNER_HMI_FUNID_NOTARRAY_SIZE 
  //                                               );




  
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   m_u8CurrentAudioProgram = 0x00;
   m_u8HDStationInfoBits = 0xff;
   m_u32HDFrequency = 0x00000000;
   	m_u32StationInfoHDStationID = 0x00;
  	m_bHDAudioDecodingBit = false;
	m_bAdvisoryTimerSet = false;
	m_bBit0and1OnceOn = false;
	m_bHDStationInfoBitTimer = false;
	m_bHDSeekSelected = false;
	m_bHDAudioProgramSelected = false;
	m_bHDStationListElementSelected = false;
	m_bHDPresetSelected = false;
	m_bHDAudioProgramDirectSelected = false;
	m_bHDRotateEncoderSelected = false;
	m_sHDActiveCallSign = 0;
	m_hTimerAdvisoryTimer = OSAL_C_INVALID_HANDLE;
	m_hHDStationInfoBitTimer = OSAL_C_INVALID_HANDLE;
#endif
	m_bPresetSelected = false;
	m_bStationListElementSelected = false;
	m_u16StationListCommandCtr = 0;
	m_u16UIRegID = 0;
	m_u16UIAppID = 0;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20	   	
	/* create Advisory supervision timer */
	tS32 s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vAdvisoryTimerCallback,
	                                         ( tPVoid )this, &m_hTimerAdvisoryTimer );
	TUN_ASSERT_RETURN( s32OsalError == OSAL_OK);
	/* create HDStationInfoBit timer */
		s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vHDStationInfoBitTimerCallback,
		                                         ( tPVoid )this, &m_hHDStationInfoBitTimer );
	TUN_ASSERT_RETURN( s32OsalError == OSAL_OK);
#endif
  vUpdatePresetListID();
  m_u8RequestedPresetIndex = 0xFF;
}//End of constructor

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::~tun_MsgToHMI( )
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tun_MsgToHMI::~tun_MsgToHMI( )
{
  OSAL_s32SemaphoreClose( m_hNotHMITableSem );   
  OSAL_s32SemaphoreDelete( TUNER_HMI_NOTTABLE_SEM_NAME );
  
  if( m_poHMINotTable != NULL )
  {
    vDeleteNoThrow( m_poHMINotTable);
  }

  m_potun_HMIManager = NULL;
  poGWMain = NULL;
  m_potun_ActualData = NULL;
  m_potun_MsgToADR = NULL;
  m_potun_Utility = NULL;
  m_potun_Config = NULL;
  m_poclConfigInterface = NULL;
  m_potun_MsgFromHMI = NULL;
  m_u8TunFGBG = (tU8)enAudioSource_No_audio;
  m_u16CommandCntr = 0;
  m_u16DiagRegID = 0;
  m_u16TMDiagRegID = 0;
  m_u16TMCommandCntrActiveTuner = 0;
  m_u16TMCommandCntrSetRdbid =0;
  m_u16TMCommandCntrBandChange = 0;
  m_u16TMCommandCntrFGBG = 0;
  m_u16BandChangeRegID =0;
  m_u16FGBGRegID =0;
  m_u16TMCommandCntrDirectFreq = 0;
  m_u16DirectFreqID =0;
  m_u8PrevBand = 0xFF;
  m_u16CmdCtrForPresetRecall = 0;
  m_u16CmdCtrForTMCConfigList = 0;
  m_u16StationListCommandCtr = 0;
  m_u16UIRegID = 0;
  m_u16UIAppID = 0;
  m_u8AnnoSwitchState = 0;
  m_u8RDSSwitchStatus = 0;
  m_u32ATStationFreq = 0;
  m_u8AFSwitch = 0;
  m_u32AnnoInfoFreq = 0;
  m_u16AnnoInfoPI = 0;
  m_utf8StringPSName = NULL;
  m_u8AnnoInfoType = 0;

 #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE = NULL;
   m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE = NULL;
   m_u8CurrentAudioProgram = INVALID_AUDIOPROGRAM;
   m_u8HDStationInfoBits = 0xff;
   m_u32StationInfoHDStationID = 0x00;
   m_bHDAudioDecodingBit = false;
   m_bAdvisoryTimerSet = false;
   m_bHDStationInfoBitTimer = false;
   m_u32HDFrequency = 0x00000000;
   m_bBit0and1OnceOn = false;
   m_bHDSeekSelected = false;
   m_bHDAudioProgramSelected = false;
   m_bHDStationListElementSelected = false;
   m_bHDPresetSelected = false;
   m_bHDAudioProgramDirectSelected = false;
   m_bHDRotateEncoderSelected = false;
   m_sHDActiveCallSign = 0;
#endif
   m_bPresetSelected = false;
   m_bStationListElementSelected = false;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
     	/* delete advisory timer */
	tS32 s32OsalError = OSAL_s32TimerDelete( m_hTimerAdvisoryTimer);
	NORMAL_M_ASSERT( s32OsalError == OSAL_OK);
	s32OsalError = OSAL_s32TimerDelete( m_hHDStationInfoBitTimer);
	NORMAL_M_ASSERT( s32OsalError == OSAL_OK);
	m_hTimerAdvisoryTimer = OSAL_C_INVALID_HANDLE;
	m_hHDStationInfoBitTimer = OSAL_C_INVALID_HANDLE;
#endif

  m_bSendAutostoreMthdResult = false;

  m_u8AnnoMessage = 0;
  #ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
    m_u8BGAnnoMessage = 0;
    m_enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_PTY_OFF;
  #endif
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  m_poclAars_ATPresetList_XX=NULL;
  m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST=NULL;
  m_poclTmcTuner_Method_S_JAPAN_SET_AREA = NULL;
  m_poclAars_DemodulationSwitch = NULL;
  m_poclTmcTuner_GetConfigurationInfoStatus = NULL;
#endif
  m_u16AMActivePresetListId =0;
  m_u16FMActivePresetListId = 0;
  m_u16DRMActivePresetListId = 0;

  m_u8RequestedPresetIndex = 0xFF;

}//End of Destructor


/*************************************************************************
*
* FUNCTION:     tun_RUIF_WaitingThread::vSet_tun_HMIManager_Ptr( )
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_tun_HMIManager_Ptr( tun_HMIManager* potun_HMIManager )
{
  if( potun_HMIManager != NULL )
  {
    m_potun_HMIManager = potun_HMIManager;
  }
}

/*************************************************************************
*
* FUNCTION:     tun_RUIF_WaitingThread::vSet_tun_MsgFromHMI_Ptr( )
*
* DESCRIPTION:  Pointer for MsgFromHMI
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_tun_MsgFromHMI_Ptr( tun_MsgFromHMI* potun_MsgFromHMI )
{
	if(potun_MsgFromHMI != NULL)
	{
		m_potun_MsgFromHMI = potun_MsgFromHMI;
	}
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSet_tun_ActualData_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData )
{
  if( potun_ActualData != NULL )
  {
    m_potun_ActualData = ( tun_ActualData* )potun_ActualData;
  }
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSet_tun_MsgToADR_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR )
{
  if( potun_MsgToADR != NULL )
  {  
    m_potun_MsgToADR = potun_MsgToADR;
  }
  else
  {
    /* Assert to do */
  }
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSet_tun_Utility_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_tun_Utility_Ptr( tun_Utility* potun_Utility )
{
  if( potun_Utility != NULL )
  {  
    m_potun_Utility = potun_Utility;
  }
  else
  {
    /* Assert to do */
  }
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToADR::vSet_tun_Config_Ptr( )
* 
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_tun_Config_Ptr( tun_Config* potun_Config )
{
  if( potun_Config != NULL )
  {
    m_potun_Config = ( tun_Config* )potun_Config;
  }
  
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSet_tun_ConfigInterface_Ptr( )
*
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface )
{
  if( poclConfigInterface != NULL )
  {
	  m_poclConfigInterface = poclConfigInterface;
  }

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSet_tun_GetConfigInfoStatus_Ptr( )
*
* DESCRIPTION:
*
* PARAMETER:    clTmcTuner_GetConfigurationInfoStatus* poclTmcTuner_GetConfigurationInfoStatus
*
* RETURNVALUE:  void
*
*************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tun_MsgToHMI::vSet_tun_GetConfigInfoStatus_Ptr( clTmcTuner_GetConfigurationInfoStatus* poclTmcTuner_GetConfigurationInfoStatus )
{
  if( poclTmcTuner_GetConfigurationInfoStatus != NULL )
  {
	  m_poclTmcTuner_GetConfigurationInfoStatus = poclTmcTuner_GetConfigurationInfoStatus;
  }

}

tVoid tun_MsgToHMI::vSet_tun_AudioFgBg_Ptr( clTmcTuner_Method_S_AUDIO_FG_BG_NEW* poclTmcTuner_Method_S_AUDIO_FG_BG_NEW )
{
	if(poclTmcTuner_Method_S_AUDIO_FG_BG_NEW != NULL)
	{
		m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW = poclTmcTuner_Method_S_AUDIO_FG_BG_NEW;
	}
}
#endif

/*************************************************************************
*
* FUNCTION:     tun_MsgToRU::vSet_tuner_tclApp_Ptr( )
* 
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_tuner_tclApp_Ptr( tuner_tclApp* potunerMainApp )
{
  if( potunerMainApp != NULL )
  {
    poGWMain = ( tuner_tclApp* )potunerMainApp;
  }
  
}
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tun_MsgToHMI::vSet_TmcTuner_Method_S_SET_ACTIVE_PRESETLISTPtr( clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST )
{
  if( poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST != NULL )
  {
	  m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST = ( clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* )poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST;
  }

}
tVoid tun_MsgToHMI::vSet_clAars_ATPresetList_XXPtr(clAars_ATPresetList_XX* poclAars_ATPresetList_XX)
  {
		if(NULL != poclAars_ATPresetList_XX)
	   {
		  m_poclAars_ATPresetList_XX = ( clAars_ATPresetList_XX* )poclAars_ATPresetList_XX;
	   }
  }

tVoid tun_MsgToHMI::vSet_TmcTuner_Method_S_JAPAN_SET_AREAPtr(clTmcTuner_Method_S_JAPAN_SET_AREA* poclTmcTuner_Method_S_JAPAN_SET_AREA)
{
   if(NULL != poclTmcTuner_Method_S_JAPAN_SET_AREA)
   {
     m_poclTmcTuner_Method_S_JAPAN_SET_AREA = ( clTmcTuner_Method_S_JAPAN_SET_AREA* )poclTmcTuner_Method_S_JAPAN_SET_AREA;
   }
}

clTmcTuner_Method_S_JAPAN_SET_AREA* tun_MsgToHMI::poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr()
{
	if(NULL != m_poclTmcTuner_Method_S_JAPAN_SET_AREA)
	{
		return m_poclTmcTuner_Method_S_JAPAN_SET_AREA;
	}
	return NULL;
}

tVoid tun_MsgToHMI::vSet_clAars_DemodulationSwitchPtr(clAars_DemodulationSwitch* poclAars_DemodulationSwitch)
  {
		if(NULL != poclAars_DemodulationSwitch)
	   {
		  m_poclAars_DemodulationSwitch = ( clAars_DemodulationSwitch* )poclAars_DemodulationSwitch;
	   }
  }
tVoid tun_MsgToHMI::vSet_TmcTuner_Method_S_USER_PROFILE_UPDATEPtr( clTmcTuner_Method_S_USER_PROFILE_UPDATE* poclTmcTuner_Method_S_USER_PROFILE_UPDATE )
{
  if( poclTmcTuner_Method_S_USER_PROFILE_UPDATE != NULL )
  {
	  m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE = poclTmcTuner_Method_S_USER_PROFILE_UPDATE;
  }
}
tVoid tun_MsgToHMI::vSet_TmcTuner_Method_S_PRESETLIST_CONTENT_UPDATEPtr( clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE* poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE )
{
  if( poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE != NULL )
  {
	  m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE = poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE;
  }
}

#endif
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSet_TmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCYPtr( )
* 
* DESCRIPTION:   sets m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY
*
* PARAMETER:    clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY* poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSet_TmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCYPtr( clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY* poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY )
{
  if( poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY != NULL )
  {
	  m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY = poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY;
  }
}

/*************************************************************************
*
* FUNCTION:     tun_RUIF_WaitingThread::vAddNotificationTable ( )
* 
* DESCRIPTION:  Add new (HMI UpReg) Function ID registration in the Notification table
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tBool tun_MsgToHMI::bAddNotificationTable ( const amt_tclServiceData* poMessage )
{
  if(( poMessage == NULL ) ||( m_poHMINotTable == NULL) )
  {
    if( poMessage == NULL )
    {
      NORMAL_M_ASSERT( poMessage != NULL );
    } 

    if( m_poHMINotTable == NULL )
    {
      NORMAL_M_ASSERT( m_poHMINotTable != NULL );
    } 

    return false;
  }//if(( poMessage == NULL ) ||( m_poHMINotTable == NULL) )

  tBool bSuccess = TRUE;

  ahl_bEnterCritical( m_hNotHMITableSem );

  tU16 u16ServiceID = poMessage->u16GetServiceID();
    
  switch(u16ServiceID)
  {
    case CCA_C_U16_SRV_TUNERCONTROL:  
    {
      switch (poMessage->u8GetOpCode())
      {
        case AMT_C_U8_CCAMSG_OPCODE_UPREG:
        {
          /*---------------------------------------------------------------*/
          /* Notfication-Message - entry with TRUE in ahl_notificationList */
          /*---------------------------------------------------------------*/
          bSuccess = m_poHMINotTable -> bAddNotification( poMessage->u16GetFunctionID(),
                                                          poMessage->u16GetSourceAppID(),
                                                          poMessage->u16GetRegisterID(),
                                                          TRUE,
                                                          poMessage->u16GetCmdCounter() );   
          if (bSuccess == FALSE)
          {
            /*-------------------------------*/
            /* send an UpReg Failure Message */
            /*-------------------------------*/
            /* vSendErrorNoNotification( poMessage->u16GetSourceAppID(),
                                        poMessage->u16GetSourceSubID(),
                                        poMessage->u16GetServiceID(),
                                        poMessage->u16GetRegisterID(),
                                        poMessage->u16GetFunctionID(),
                                        poMessage->u8GetACT(),
                                        poMessage->u16GetCmdCounter(),
                                        AMT_C_U16_ERROR_UPREG_FAILURE );  */
              
              
            ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_MSGTOHMI, ET_EN_T16 _ TUN_TRACE_MSG_TO_HMI_ADD_TO_NOTIF_FAIL _ 
                                  ET_EN_T16 _ poMessage->u16GetFunctionID() _ 
                                  ET_EN_T16 _ poMessage->u16GetSourceAppID() _
                                  ET_EN_T16 _ u16ServiceID _
                                  ET_EN_T16 _ poMessage->u16GetRegisterID() _ ET_EN_DONE);
          }
          else
          {
            ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI, ET_EN_T16 _ TUN_TRACE_MSG_TO_HMI_ADD_TO_NOTIF_OK _
                               ET_EN_T16 _ poMessage->u16GetFunctionID() _ 
                               ET_EN_T16 _ poMessage->u16GetSourceAppID() _
                               ET_EN_T16 _ u16ServiceID _
                               ET_EN_T16 _ poMessage->u16GetRegisterID() _ ET_EN_DONE);
          }
        } /* AMT_C_U8_CCAMSG_OPCODE_UPREG */
        break;               

        case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:              
        case AMT_C_U8_CCAMSG_OPCODE_GET: 
        case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
          break;
                
        default:
           ET_TRACE_WARNING( ( (ail_tclAppInterface*)poGWMain )->u16GetAppId(), (tChar*) "TUN: tun_MsgToHMI - unknown Opcode\n");                  
           break;

      } /* switch (poMessage->u8GetOpCode()) */                         

    }/* case CCA_C_U16_SRV_TUNERCONTROL: */
    break;

    default:
      ET_TRACE_WARNING( ( (ail_tclAppInterface*)poGWMain )->u16GetAppId(), (tChar*) "TUN: tun_MsgToHMI - unknown Opcode\n");            
      break;        
  } /* switch(u16ServiceID) */

  ahl_bReleaseCritical(m_hNotHMITableSem); 
  return bSuccess;
}//End of Function


/*************************************************************************
*
* FUNCTION:     tun_RUIF_WaitingThread::vRemoveNotification ( )
* 
* DESCRIPTION:  Remove (HMI UpReg) Function ID registration in the Notification table
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tBool tun_MsgToHMI::bRemoveNotification( const amt_tclServiceData* poMessage )
{
  if(( poMessage == NULL ) ||( m_poHMINotTable == NULL) )
  {
    if( poMessage == NULL )
    {
      NORMAL_M_ASSERT( poMessage != NULL );
    } 
    if( m_poHMINotTable == NULL )
    {
      NORMAL_M_ASSERT( m_poHMINotTable != NULL );
    } 
    return false;
  }//if(( poMessage == NULL ) ||( m_poHMINotTable == NULL) )

  tBool bSuccess = TRUE;

  ahl_bEnterCritical( m_hNotHMITableSem );

  tU16 u16ServiceID = poMessage->u16GetServiceID();
    
  switch(u16ServiceID)
  {
    case CCA_C_U16_SRV_TUNERCONTROL:  
    {
      switch (poMessage->u8GetOpCode())
      {               

        case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
        {
          /*--------------------------------------------*/
          /* Remove FunctionID from notification table  */
          /*--------------------------------------------*/
          bSuccess = m_poHMINotTable -> bRemoveNotification( poMessage->u16GetFunctionID(),
                                                             poMessage->u16GetSourceAppID(),
                                                             poMessage->u16GetRegisterID(),
                                                             TRUE,
                                                             poMessage->u16GetCmdCounter() );
          
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI, ET_EN_T16 _ TUN_TRACE_MSG_TO_HMI_REM_NOTIF _
                               ET_EN_T16 _ poMessage->u16GetFunctionID() _ 
                               ET_EN_T16 _ poMessage->u16GetSourceAppID() _
                               ET_EN_T16 _ u16ServiceID _
                               ET_EN_T16 _ poMessage->u16GetRegisterID() _ ET_EN_DONE);
        
        }/* case AMT_C_U8_CCAMSG_OPCODE_RELUPREG */
        break;

        case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
        case AMT_C_U8_CCAMSG_OPCODE_GET:   
        case AMT_C_U8_CCAMSG_OPCODE_UPREG:
          break;
                
        default:
          ET_TRACE_WARNING( ( (ail_tclAppInterface*)poGWMain )->u16GetAppId(), (tChar*) "TUN: tun_MsgToHMI - unknown Opcode\n");                  
          break;

      } /* switch (poMessage->u8GetOpCode()) */                         

    }/* case CCA_C_U16_SRV_TUNERCONTROL: */
    break;

    default:
      ET_TRACE_WARNING( ( (ail_tclAppInterface*)poGWMain )->u16GetAppId(), (tChar*) "TUN: tun_MsgToHMI - unknown Opcode\n");            
      break;        

  }//Switch(u16ServiceID)
            
  ahl_bReleaseCritical(m_hNotHMITableSem); 
       
  return bSuccess;
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vRemoveAllEntriesWithRegID ( )
* 
* DESCRIPTION:  Remove All entries (HMI UpReg) of Function ID registration in the Notification table
*
* PARAMETER:    tU16 u16ServiceID, tU16 u16RegisterID
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vRemoveAllEntriesWithRegID( tU16 u16ServiceID, tU16 u16RegisterID )
{   

  if( m_poHMINotTable != NULL )
	{
		m_poHMINotTable -> bRemoveAllEntriesWithRegID( u16RegisterID );
	}
	ETG_TRACE_USR1((" tun_MsgToHMI::vRemoveAllEntriesWithRegID ServID = %d RegID = %d", u16ServiceID, u16RegisterID));
   
}


/*******************************************************************************
*FUNCTION:    tun_MsgToHMI::vGetDatafromAMT
*
*DESCRIPTION: This function converts Amt message to visitor class and 
*             get the data from visitor to the Fi class. Refer FI Manual.
*             Doc.
*
*PARAMETER:    
*           poFiMsg   - Amt Message 
*           oFIData   - Base class of Fi class 
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_MsgToHMI::vGetDatafromAMT( amt_tclServiceData* poFIMsg,
                                        fi_tclTypeBase&     oFIData )const
{
   // Create Visitor message object for incoming message
   fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

   /* Get the data in FI class from Vistor class*/   
   if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
   {
      // assert here 
      NORMAL_M_ASSERT_ALWAYS ();
   }

}






/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_AtBand( )
* 
* DESCRIPTION:  Handle CM_AtBand status from ADR
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_AtBand( const tU8* pu8Message, tU32 u32MessageLen )
{
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	if( pu8Message == NULL  || u32MessageLen == 0 || m_poHMINotTable == NULL || 
	m_potun_Utility == NULL || m_potun_HMIManager == NULL || m_potun_MsgToADR == NULL || m_potun_Config == NULL || m_poclConfigInterface == NULL
	|| m_poclTmcTuner_GetConfigurationInfoStatus == NULL)
    {
        NORMAL_M_ASSERT( pu8Message != NULL );
		NORMAL_M_ASSERT( u32MessageLen != 0 );
		NORMAL_M_ASSERT( m_poHMINotTable != NULL );
		NORMAL_M_ASSERT( m_potun_Utility != NULL );
		NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
		NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
		NORMAL_M_ASSERT( m_potun_Config != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		NORMAL_M_ASSERT( m_poclTmcTuner_GetConfigurationInfoStatus != NULL );
		return;
	}
#endif
    /** Required for Suzuki Bugfix */
	/**At startup the active preset list is read based on the Response from ATBand*/

    tU16 u16ADRListID = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_ATBand_idx_ActivePresetList] );

	/** For mixed preset */
	if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
	{
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	   tU32 u32Frequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ enCM_ATBand_idx_Frequency] );
	   u8SystemPresets_Band = m_potun_MsgToADR->u8ConvertCombibandToTunerband(pu8Message[ enCM_ATBand_idx_Band], u32Frequency);
#else
		u8SystemPresets_Band = pu8Message[ enCM_ATBand_idx_Band];
#endif
	}
	else
	{
		u8SystemPresets_Band = pu8Message[ enCM_ATBand_idx_Band];
	}

	/* */
	if(u16ADRListID == 0)
	{
		ETG_TRACE_USR1((" tun_MsgToHMI::vHandle_r_AtBand u16ADRListID = %d ", u16ADRListID));

		if(u8SystemPresets_Band == 0)//FM
		{
			m_u16FMActivePresetListId = U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)u8SystemPresets_Band);
		}
		else if(u8SystemPresets_Band == 2)//AM
		{
			m_u16AMActivePresetListId = U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)u8SystemPresets_Band);
		}
		else if(u8SystemPresets_Band == 0x14)//DRM
		{
			m_u16DRMActivePresetListId = U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)u8SystemPresets_Band);
		}
	}
	else
	{
		ETG_TRACE_USR1((" tun_MsgToHMI::vHandle_r_AtBand u8SystemPresets_Band = %d ", u8SystemPresets_Band));
    	if(u8SystemPresets_Band == 0)//FM
		{
			m_u16FMActivePresetListId = u16ADRListID;
			ETG_TRACE_USR1((" tun_MsgToHMI::vHandle_r_AtBand m_u16FMActivePresetListId = %d ", m_u16FMActivePresetListId));
		}
		else if(u8SystemPresets_Band == 2)//MW
		{
			m_u16AMActivePresetListId = u16ADRListID;
			ETG_TRACE_USR1((" tun_MsgToHMI::vHandle_r_AtBand m_u16AMActivePresetListId = %d ", m_u16AMActivePresetListId));
		}
		else if(u8SystemPresets_Band == 0x14)//DRM
		{
			m_u16DRMActivePresetListId =  u16ADRListID;
			ETG_TRACE_USR1((" tun_MsgToHMI::vHandle_r_AtBand m_u16DRMActivePresetListId = %d ", m_u16DRMActivePresetListId));
		}
	}

	/**Store the active preset list*/
	#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST->vSaveListIDForSetActivePresetList((tun_tenAmFmTunerMsg)u16ADRListID);
	#else
	vSaveListIDForSetActivePresetList(u16ADRListID);
	#endif

	ahl_bEnterCritical( m_hNotHMITableSem );
    for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_BAND_PLUS_STATION_INFO) ; pNot != OSAL_NULL; pNot=pNot->pNext)
    {
		midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus oAtBandStatusMsg;
		

      /*Frequency*/
     tU32 u32Freq = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ enCM_ATBand_idx_Frequency] );
     oAtBandStatusMsg.TunerBandAndStationInfo.u32Frequency = u32Freq;

				/*Band*/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		oAtBandStatusMsg.TunerBandAndStationInfo.e8Band.enType = \
		      (midw_fi_tcl_e8_Tun_TunerBand::tenType)m_potun_MsgToADR->u8ConvertCombibandToTunerband(pu8Message[enCM_ATBand_idx_Band], u32Freq);
#else
		oAtBandStatusMsg.TunerBandAndStationInfo.e8Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)pu8Message[enCM_ATBand_idx_Band];
#endif

      /*PI*/
      tU16 u16PI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_ATBand_idx_PI] );
      oAtBandStatusMsg.TunerBandAndStationInfo.u16PI = u16PI;
      
      /* name is copied in UTF format here */
      midw_fi_tclString sUtf8String ;
      m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[enCM_ATBand_idx_Stationname],&sUtf8String/* oStationDataStatusMsg.TunerStationData.sPSName*/) ;
      oAtBandStatusMsg.TunerBandAndStationInfo.sPSName.bSet( sUtf8String ,
                               midw_fi_tclString::FI_EN_UTF8);

	   tU32 u16Preset = pu8Message[ enCM_ATBand_idx_PresetAutoCompare];
	  /*PresetAutocompare*/
      
      oAtBandStatusMsg.TunerBandAndStationInfo.u16StaticListElementID = (tU16)(u16Preset);


	/*Status message*/	  
	vSendMessage( pNot->u16AppID,
						 oAtBandStatusMsg,
						 MIDW_TUNERFI_C_U16_FID_TUN_G_BAND_PLUS_STATION_INFO,
						 AMT_C_U8_CCAMSG_OPCODE_STATUS,
						 pNot->u16CmdCounter,
						 pNot->u16RegisterID);
						 
	
	
	}
	ahl_bReleaseCritical(m_hNotHMITableSem);

	   if(!(m_potun_MsgToADR->bGetNotificationSentStatus()))
	   {
		   m_potun_MsgToADR->vDec_m_NumofAtBandReqAtStartUp();
	   }
	   if(0 == m_potun_MsgToADR->u8Get_m_NumofAtBandReqAtStartUp() && (!(m_potun_MsgToADR->bGetNotificationSentStatus())))
	   {
		   tuner_tclApp::VSetTime_ForDoNotfication_1secTimer(0);
		   ETG_TRACE_USR1((" tun_MsgToHMI::bGetNotificationSentStatus sent "));
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		   m_poclTmcTuner_GetConfigurationInfoStatus->vDoNotification();
#endif
	   }

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vGetFMActivePresetListId( )
*
* DESCRIPTION:  Gets the active preset list ID in FM band
*
* PARAMETER:    void
*
* RETURNVALUE:  tU16
*
*************************************************************************/
tU16 tun_MsgToHMI::u16GetFMActivePresetListId()
{
	ETG_TRACE_USR1((" tun_MsgToHMI::u16GetFMActivePresetListId : %d ",m_u16FMActivePresetListId));
	return m_u16FMActivePresetListId;
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vGetAMActivePresetListId( )
*
* DESCRIPTION:  Gets the active preset list ID in MW band
*
* PARAMETER:    void
*
* RETURNVALUE:  tU16
*
*************************************************************************/
tU16 tun_MsgToHMI::u16GetAMActivePresetListId()
{
	ETG_TRACE_USR1((" tun_MsgToHMI::u16GetAMActivePresetListId : %d ",m_u16AMActivePresetListId));
	return m_u16AMActivePresetListId;
}
tU16 tun_MsgToHMI::u16GetDRMActivePresetListId()
{
	ETG_TRACE_USR1((" tun_MsgToHMI::u16GetDRMActivePresetListId : %d ",m_u16DRMActivePresetListId));
	return m_u16DRMActivePresetListId;
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSetFMActivePresetListId( )
*
* DESCRIPTION:  Gets the active preset list ID in FM band
*
* PARAMETER:    tU16
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSetFMActivePresetListId(tU16 u16FMActivePresetListId)
{
	m_u16FMActivePresetListId = u16FMActivePresetListId;
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSetAMActivePresetListId( )
*
* DESCRIPTION:  Gets the active preset list ID in MW band
*
* PARAMETER:    tU16
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSetAMActivePresetListId(tU16 u16AMActivePresetListId)
{
	m_u16AMActivePresetListId = u16AMActivePresetListId;
}
tVoid tun_MsgToHMI::vSetDRMActivePresetListId(tU16 u16DRMActivePresetListId)
{
	m_u16DRMActivePresetListId = u16DRMActivePresetListId;
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_AtStationInfo( )
* 
* DESCRIPTION:  Handle CM_AtStationInfo status from ADR
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_AtStationInfo(tU8* pu8Message )
{
  if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL) 
              ||( m_poHMINotTable == NULL ) ||
      (m_potun_Utility == NULL) || (poGWMain == NULL) || (m_potun_MsgFromHMI == NULL) || (m_potun_MsgToADR == NULL) || (m_poclConfigInterface == NULL) ||
							(m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY == NULL))
    {

        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
        NORMAL_M_ASSERT( m_potun_Utility != NULL );
        NORMAL_M_ASSERT( poGWMain != NULL );
        NORMAL_M_ASSERT( m_potun_MsgFromHMI != NULL );
        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
		NORMAL_M_ASSERT(m_poclConfigInterface != NULL);
		NORMAL_M_ASSERT(m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY != NULL);
        return;
    }
  

       /*Updating Quality and frequency*/
        vSetAtStaInfoQuality(pu8Message[enCM_ATStationInfo_idx_Quality]);
        vSetAtStaInfoFreq(m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ enCM_ATStationInfo_idx_Frequency] ));

		/** moved in order to optimise. 
		For each client data is extracted , assigned, and same traces are printed*/

		midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus oAtStationInfoStatusMsg;
            /**pmn3kor:
             *created new function to solve logiscope issues
             *This funtion packs the StationInfo data*/
		if((bIsTunerFG()) || (m_u8AnnoMessage & TUN_ANNOUNCEMENTMESSAGE_BIT_MSK_EON)
#if defined(VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC)//gds5kor - NCG3D-38335
					|| bIsFMAnnouFG()
#endif
			)
		{
            vUpdateStationInfo( oAtStationInfoStatusMsg , pu8Message);
		}


		if(bIsFMAnnouFG())
		{
			  tU8 u8Quality = pu8Message[enCM_ATStationInfo_idx_Quality];
			  vSendAnnouncementInfo_Quality(u8Quality);
		}

			 ETG_TRACE_USR2((" TunerHeader = %d, Freq = %u, PI = 0x%x, AtStationTPInfo = %d, \
					  Band = %d"
              , oAtStationInfoStatusMsg.Atstationinfo.u8TunerHeader.enType
              , oAtStationInfoStatusMsg.Atstationinfo.u32Frequency
              , oAtStationInfoStatusMsg.Atstationinfo.u16PI
              , oAtStationInfoStatusMsg.Atstationinfo.e8AtStationTPinfo.enType
              , oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType
              ));
			 
			 ETG_TRACE_USR2((" PresetListID = %d, ActiveStationList = %d, Preset = %d,\
					  ConfigListElementID = %d, u8AtStationInfoBits = %d "
              , oAtStationInfoStatusMsg.Atstationinfo.u16PresetListID
              , oAtStationInfoStatusMsg.Atstationinfo.u8ActiveStationList
              , oAtStationInfoStatusMsg.Atstationinfo.u16StaticListElementID
              , oAtStationInfoStatusMsg.Atstationinfo.u16ConfigListElementID
              , oAtStationInfoStatusMsg.Atstationinfo.u8AtStationInfoBits.u8Value
              ));
			 

            ETG_TRACE_USR2((" Stationname = %s"
                            , oAtStationInfoStatusMsg.Atstationinfo.sPSName.szGet(midw_fi_tclString::FI_EN_UTF8) ));


			ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_AtStationInfo(), StationLogo=%s"
					,oAtStationInfoStatusMsg.Atstationinfo.StationLogo.szGet(midw_fi_tclString::FI_EN_UTF8)
				));


       {
            

            /*Band change method result sent to tunermaster*/
            /**pmn3kor:
             *created new function to solve logiscope issues
             *handler for change band method result*/
			/*if(m_poclConfigInterface->u32GetConfigData("SBR"))
			{
				if((m_u8TunerState == 0) && (bSystemPresets == true))
				{
					bSystemPresets = false;
					ETG_TRACE_USR2((" tun_MsgToHMI::vHandle_r_AtStationInfo TunerState = %d bSystemPresets = %d send method result\n", m_u8TunerState, bSystemPresets));
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20					
					m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW->vSendFGBGMethodResult();
#endif
				}
			}
			else*/
			{
				vHandleChangeBandMethodResult(oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType, \
					oAtStationInfoStatusMsg.Atstationinfo.u16PresetListID);
			}
            /**pmn3kor:
             *created new function to solve logiscope issues
             *handler for direct frequency method result*/
            tU32 u32Frequency = oAtStationInfoStatusMsg.Atstationinfo.u32Frequency;
            vHandleDirectFrequencyMethodResult(u32Frequency);



            ETG_TRACE_USR2((" tun_MsgToHMI::vHandle_r_AtStationInfo ->SeekState = %d, TunerState = %d ", m_u8SeekState, m_u8TunerState));

			/*bUpdateRequiredtoClient avoids multiple status message sent to clients*/
			tBool bUpdateRequiredtoClient = false; 

			/*No seek ongoing, sned status only if tunerstate is IDLE*/
				if(m_u8SeekState == 0)
				{
					if(m_u8TunerState == 0)
					{
						bUpdateRequiredtoClient = true;

						/*If tuner is in BG, below change setPWM frequency to TUN_PWM_HIGH_CORRECTEDFREQUENCY. NCG3D-44370*/
						if(((pu8Message[ enCM_ATStationInfo_idx_Band] == (tU8)enBand_MW)
								 || (pu8Message[ enCM_ATStationInfo_idx_Band] == (tU8)enBand_LW)
								 || (pu8Message[ enCM_ATStationInfo_idx_Band] == (tU8)enBand_CB1)
								 || (pu8Message[ enCM_ATStationInfo_idx_Band] == (tU8)enBand_TRF))
								 && (bIsTunerFG()))//AM Source
						{


							ETG_TRACE_USR4((" vHandle_r_AtStationInfo -> AM Source!"));
							/*Check frequency range to set PWM*/
							if(poGWMain->bCheckAIVI_SBRVariant())
							{
								tU32 u32CurrentAMFrequency = oAtStationInfoStatusMsg.Atstationinfo.u32Frequency;
								if(AM_FREQUENCY_RANGE_CHECK_FOR_SWITCHING_FREQUENCY)
									m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY->vSendSwitchingFrequency(TUN_SWITCHING_FREQUENCY_384kHz);
								else
									m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY->vSendSwitchingFrequency(TUN_SWITCHING_FREQUENCY_432kHz);

									
								tU32 u32CorrectedFreq = u32CheckAMFreqRange(oAtStationInfoStatusMsg.Atstationinfo.u32Frequency , TUN_PWM_SYNC_SIGNAL1);
								if((poGWMain->vGetPWMFrequency(TUN_PWM_SYNC_SIGNAL1) != u32CorrectedFreq) || (poGWMain->vGetPWMValue(TUN_PWM_SYNC_SIGNAL1)!= DUTYCYCLE_50))
								{
									ETG_TRACE_USR4((" AM Source corrected freq = %u! ",u32CorrectedFreq));
									/*Set PWM12 to 50% duty cycle and the corrected frequency*/
									poGWMain->vSetPWM( DUTYCYCLE_50 ,u32CorrectedFreq , TUN_PWM_SYNC_SIGNAL1);
								}
								
								u32CorrectedFreq = u32CheckAMFreqRange(oAtStationInfoStatusMsg.Atstationinfo.u32Frequency , TUN_PWM_SYNC_SIGNAL3);
								if((poGWMain->vGetPWMFrequency(TUN_PWM_SYNC_SIGNAL3) != u32CorrectedFreq) || (poGWMain->vGetPWMValue(TUN_PWM_SYNC_SIGNAL3)!= DUTYCYCLE_50))
								{
									ETG_TRACE_USR4((" AM Source corrected freq = %u! ",u32CorrectedFreq));
									/*Set PWM12 to 50% duty cycle and the corrected frequency*/
									poGWMain->vSetPWM( DUTYCYCLE_50 ,u32CorrectedFreq , TUN_PWM_SYNC_SIGNAL3);
								}
							}
							else
							{
								tU32 u32CorrectedFreq = u32CheckAMFreqRange(oAtStationInfoStatusMsg.Atstationinfo.u32Frequency);
								if((poGWMain->vGetPWMFrequency() != u32CorrectedFreq) || (poGWMain->vGetPWMValue()!= DUTYCYCLE_50))
								{
									ETG_TRACE_USR4((" AM Source corrected freq = %u! ",u32CorrectedFreq));
									/*Set PWM12 to 50% duty cycle and the corrected frequency*/
									poGWMain->vSetPWM( DUTYCYCLE_50 ,u32CorrectedFreq);
								}
							}
						}
						else if ((pu8Message[ enCM_ATStationInfo_idx_Band] == (tU8)enBand_FM)|| (pu8Message[ enCM_ATStationInfo_idx_Band] == (tU8)enBand_WB))
						{
							if(poGWMain->bCheckAIVI_SBRVariant())
							{
								m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY->vSendSwitchingFrequency(TUN_SWITCHING_FREQUENCY_432kHz);
								
								if(poGWMain->vGetPWMValue(TUN_PWM_SYNC_SIGNAL1) != 0)
									poGWMain->vSetPWM( DUTYCYCLE_50 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC1_RANGE1 , TUN_PWM_SYNC_SIGNAL1);
								
								if(poGWMain->vGetPWMValue(TUN_PWM_SYNC_SIGNAL3) != 0)
									poGWMain->vSetPWM( DUTYCYCLE_50 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC3_RANGE1 , TUN_PWM_SYNC_SIGNAL3);
							}
							else
							{
								if(poGWMain->vGetPWMValue() != 0)
								{
									ETG_TRACE_USR4((" vHandle_r_AtStationInfo -> FM Source! Corrected Frequency = %d", TUN_PWM_HIGH_CORRECTEDFREQUENCY));
								#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
									/*Set PWM12 to 50% duty cycle - NCG3D-44370*/
									poGWMain->vSetPWM( DUTYCYCLE_50 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY);
								#else
									/*Set PWM12 to 100% duty cycle*/
									poGWMain->vSetPWM( DUTYCYCLE_100 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY);
								#endif
								}
							}

						}
					}
				}
				else/*If seek is ongoing, don't check for tunerstate*/
				{
					ETG_TRACE_USR2((" tun_MsgToHMI::vHandle_r_AtStationInfo ->Seek ongoing " ));
					bUpdateRequiredtoClient = true;

				}

				if(((bIsTunerFG()) || (m_u8AnnoMessage & TUN_ANNOUNCEMENTMESSAGE_BIT_MSK_EON)
#if defined(VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI) || defined(VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC)
					|| bIsFMAnnouFG()
#endif
					) && (true == bUpdateRequiredtoClient))
				{
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20				
					/* Check if audio decoding bits to be updated to clients if tuning happens within same HD Station ID*/
					ETG_TRACE_USR4((" tun_MsgToHMI::vHandle_r_AtStationInfo received HDStationInfoBits = %x", oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value ));
					ETG_TRACE_USR1(("CCR.HD_RADIO_PRIMARY_IMAGE: tun_MsgToHMI::vHandle_r_AtStationInfo received HDStationInfoBits = %x", oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value ));
					vHandleHDAudioDecodingTimer(oAtStationInfoStatusMsg.Atstationinfo.u32Frequency, oAtStationInfoStatusMsg.Atstationinfo.u32StationInfoHDStationID);
					if(m_bHDStationInfoBitTimer == true)
					{
						oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value |= TUN_ADVISORY_BITS_MASK;
					}
					ETG_TRACE_USR2((" tun_MsgToHMI::vHandle_r_AtStationInfo modified u8HDStationInfoBits = %x, m_bHDStationInfoBitTimer = %d", oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value, m_bHDStationInfoBitTimer ));
#endif
					ahl_bEnterCritical( m_hNotHMITableSem );

					for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO) ; pNot != OSAL_NULL; pNot=pNot->pNext)
					{

						vSendMessage( pNot->u16AppID,
							oAtStationInfoStatusMsg,
							MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO,
							AMT_C_U8_CCAMSG_OPCODE_STATUS,
							pNot->u16CmdCounter,
							pNot->u16RegisterID);
					}
					ahl_bReleaseCritical(m_hNotHMITableSem);					
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
					/** Seek off */
					/*gds5kor: if HD-Demodulation switch is OFF, do not handle PSD and advisory message */
					if( m_u8SeekState == 0 && (bIsFMDemodulationON(oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType) || bIsAMDemodulationON(oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType)) )
					{
						vPSDAndAdvisoryHandling(oAtStationInfoStatusMsg);
					}
					else
					{
						/*NCG3D-46087: If demodulation switch is Off, update current audio program and HDStationID*/
						m_u8CurrentAudioProgram = (tU8)oAtStationInfoStatusMsg.Atstationinfo.e8ActiveHDAudPrgm.enType;
						m_u32StationInfoHDStationID = oAtStationInfoStatusMsg.Atstationinfo.u32StationInfoHDStationID;
					}
						
#endif

				}
				else
				{
					ETG_TRACE_USR2((" tun_MsgToHMI::vHandle_r_AtStationInfo ->\
									Tuner not in FG \
									OR \
									Tuner not idle, update not sent to client" ));
				}




        }
		TUN_ASSERT_RETURN(poGWMain->m_poclAars_AtPiSearch != NULL);
		poGWMain->m_poclAars_AtPiSearch->vOnNewAtStationPICode(oAtStationInfoStatusMsg.Atstationinfo.u16PI);
		/** NCG3D-10402 and NCG3D-8305 tuner shut down handled in main thread */
	   //m_potun_MsgToADR->vSetNotificationSentStatus(false);
}


#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vPSDAndAdvisoryHandling( )
*
* DESCRIPTION:  Handling of PSD and advisory information for current station.
*
* PARAMETER:    const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vPSDAndAdvisoryHandling(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg)
{

	TUN_ASSERT_RETURN( m_poclConfigInterface != NULL);
	TUN_ASSERT_RETURN( poGWMain != NULL);
	TUN_ASSERT_RETURN( poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE != NULL);
	TUN_ASSERT_RETURN( poGWMain->m_poclAars_HDTestMode != NULL);

	if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
	{
		/*NCG3D-35657 - Reset transition counter if frequency is changed */
        if(m_u32HDFrequency != oAtStationInfoStatusMsg.Atstationinfo.u32Frequency)
		{
			poGWMain->m_poclAars_HDTestMode->vResetTransitionCount();
		}
		/** clearing stored data on wrong HD station id, but do not clear if transition from staion Id(0x00 -> valid id and vice versa) - NCG3D-41663 */
		if(m_u32HDFrequency != oAtStationInfoStatusMsg.Atstationinfo.u32Frequency || \
			((m_u32StationInfoHDStationID != oAtStationInfoStatusMsg.Atstationinfo.u32StationInfoHDStationID) && \
			(oAtStationInfoStatusMsg.Atstationinfo.u32StationInfoHDStationID != 0x00) && (m_u32StationInfoHDStationID != 0x00)) )
		{
			ETG_TRACE_USR2((" tun_MsgToHMI::vPSDAndAdvisoryHandling: vClearPSDMap() and vClearData called" ));
			m_oStationPsdData.vClearPSDMap();
			poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->vClearData();
		}
		else
		{
			if((oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value & TUN_ADVISORY_BITS_MASK) == TUN_ADVISORY_BITS_MASK)
			{
				/** Send PSD data if only HD modulation, data and audio deoding bits set - NCG3D-41663: send PSD always */
				vSendPSDStatus((tU8)oAtStationInfoStatusMsg.Atstationinfo.e8ActiveHDAudPrgm.enType);
			}
			/* Is Tuned Station MPS */
			if(oAtStationInfoStatusMsg.Atstationinfo.e8ActiveHDAudPrgm.enType == midw_fi_tcl_e8_Tun_HDAudioProgram::FI_EN_TUN_AUDIO_PROGRAM_ONE)
			{
				/** Handle Transition Count*/
				poGWMain->m_poclAars_HDTestMode->vHandleTransitionCount(oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value);
			}
		}


		/** Check if Advisory message is to be sent */
		if( (oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value ^ m_u8HDStationInfoBits ) &  TUN_ADVISORY_BITS_MASK)
		{
			vHandle_Advisory_Info(oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value,
				oAtStationInfoStatusMsg.Atstationinfo.e8ActiveHDAudPrgm.enType);
		}

	}

	/** update member variables */
	m_u32HDFrequency = oAtStationInfoStatusMsg.Atstationinfo.u32Frequency;
	m_u8CurrentAudioProgram = (tU8)oAtStationInfoStatusMsg.Atstationinfo.e8ActiveHDAudPrgm.enType;
	m_u8HDStationInfoBits = oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value;
	m_u32StationInfoHDStationID = oAtStationInfoStatusMsg.Atstationinfo.u32StationInfoHDStationID;


}
#endif


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vUpdateStationInfo( )
*
* DESCRIPTION:  Pack StationInfo Data
*
* PARAMETER:    midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg,
*               tU8 *pu8Message
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vUpdateStationInfo\
(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg, tU8 *pu8Message)
{
	TUN_ASSERT_RETURN( m_potun_HMIManager != NULL);
	TUN_ASSERT_RETURN( pu8Message != NULL);
	TUN_ASSERT_RETURN( m_potun_Utility != NULL);
	TUN_ASSERT_RETURN( m_potun_MsgToADR != NULL);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	TUN_ASSERT_RETURN( m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE != NULL);
	TUN_ASSERT_RETURN( m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE != NULL);
	TUN_ASSERT_RETURN( m_poclConfigInterface != NULL);
	TUN_ASSERT_RETURN( m_poclTmcTuner_Method_S_JAPAN_SET_AREA != NULL);
#endif

    /*Tunerheader*/
    tun_FI_HelpFunc :: bConverttU8toEnumHeader(pu8Message[enAdrMsgOffset_INSTANCE_ID],
                                               oAtStationInfoStatusMsg.Atstationinfo.u8TunerHeader.enType);

    /*u32AvailFlags -- confirm if it is not required*/

    /*Frequency*/
    tU32 u32frequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ enCM_ATStationInfo_idx_Frequency] );	
    oAtStationInfoStatusMsg.Atstationinfo.u32Frequency = u32frequency;	
    m_u32ATStationFreq = oAtStationInfoStatusMsg.Atstationinfo.u32Frequency;

	/* name is copied in UTF format here */
    midw_fi_tclString sUtf8String ;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
    vUpdateJapanStationCount(oAtStationInfoStatusMsg);


	//if(japan_variant and tunerstate==IDLE and Stationcount>0 and station name not suppressed)
	if((m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bIsJapanRegion()) && (m_u8TunerState == 0)
			&& (oAtStationInfoStatusMsg.Atstationinfo.u8JapanStationCount > 0) && (!m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bIsSuppressStationName()))
   {
	   oAtStationInfoStatusMsg.Atstationinfo.sPSName.bSet ( m_poclTmcTuner_Method_S_JAPAN_SET_AREA->vGetStationNameFromDatabase(), midw_fi_tclString::FI_EN_UTF8);

   }
	//if station name is suppressed or station count is 0 or not JPN region, station name will be empty.
	else

#endif

	 if((m_poclConfigInterface->u32GetConfigData("HDSupported") == true && m_u8CurrentAudioProgram == 0x00) ||
		(m_poclConfigInterface->u32GetConfigData("HDSupported") == false))
	{
#endif
		m_potun_HMIManager->vConvertRDSPSNametotString(&pu8Message[enCM_ATStationInfo_idx_Stationname], &sUtf8String/* oStationDataStatusMsg.TunerStationData.sPSName*/);

		oAtStationInfoStatusMsg.Atstationinfo.sPSName.bSet(sUtf8String,
			midw_fi_tclString::FI_EN_UTF8);

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	}
#endif
	   //only japan station name gets updated before other member variables of actual_data.
	   //Others actual_data station info fields get update from MsgDispatcher later*/
	   vSetStationName(oAtStationInfoStatusMsg.Atstationinfo.sPSName);

      /*PI*/
      oAtStationInfoStatusMsg.Atstationinfo.u16PI = \
		  m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_ATStationInfo_idx_PI] );
      
      /*ATStationTpInfo*/
      oAtStationInfoStatusMsg.Atstationinfo.e8AtStationTPinfo.enType = \
		  (midw_fi_tcl_e8_AtStationTPinfo::tenType)pu8Message[ enCM_ATStationInfo_idx_ATStationTpInfo];
	  
	  /** vnd4kor 21/10/2013: added FieldStrength , Quality and PTY*/
	  /*Fieldstrength */
	  oAtStationInfoStatusMsg.Atstationinfo.u8FieldStrngth = pu8Message[enCM_ATStationInfo_idx_Fieldstrength];
      /*Quality */
      oAtStationInfoStatusMsg.Atstationinfo.u8Quality = pu8Message[enCM_ATStationInfo_idx_Quality];
	  /** PTY */
	  oAtStationInfoStatusMsg.Atstationinfo.u8PTY = pu8Message[enCM_ATStationInfo_idx_PTY];

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	  /*Band*/

     oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType = \
           (midw_fi_tcl_e8_Tun_TunerBand::tenType)m_potun_MsgToADR->u8ConvertCombibandToTunerband(pu8Message[ enCM_ATStationInfo_idx_Band], u32frequency);
#else
	   oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType =  \
	          (midw_fi_tcl_e8_Tun_TunerBand::tenType)pu8Message[ enCM_ATStationInfo_idx_Band];
#endif

      //if(m_potun_MsgToADR->bGetNotificationSentStatus() == false) // For first ATStationInfo message received dont update m_u8PrevBand
      {
        
      }
      
      /*ActivePresetList --  confirm the number of bytes*/
      oAtStationInfoStatusMsg.Atstationinfo.u16PresetListID =  \
		  m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_ATStationInfo_idx_ActivePresetList] );
      

      
      /*PresetAutocompare*/
      oAtStationInfoStatusMsg.Atstationinfo.u16StaticListElementID = \
		  m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_ATStationInfo_idx_PresetAutocompare] );
	  
	  oAtStationInfoStatusMsg.Atstationinfo.bUserPresetAction = FALSE;
	  if(oAtStationInfoStatusMsg.Atstationinfo.u16StaticListElementID == m_u8RequestedPresetIndex)
	  {
		  oAtStationInfoStatusMsg.Atstationinfo.bUserPresetAction = TRUE;
		  m_u8RequestedPresetIndex = 0xFF;
	  }
      
      /*StationListAutocompare*/
      oAtStationInfoStatusMsg.Atstationinfo.u16ConfigListElementID = \
		  m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_ATStationInfo_idx_StationListAutocompare] );
      
      /*ATStationInfoBits*/
      oAtStationInfoStatusMsg.Atstationinfo.u8AtStationInfoBits.u8Value =  pu8Message[ enCM_ATStationInfo_idx_ATStationInfo];
	  

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20	
	  if(m_poclConfigInterface->u32GetConfigData("SBR"))
	  {
		if((u8GetTunFGBGStatus() != clCMEnum_MTCAudioSource::Anno_audio_RDS) || ( clCMEnum_MTCAudioSource::PTY31_audio_RDS == (static_cast<clCMEnum_MTCAudioSource::enMTCAudioSource>(m_u8TunFGBG))))
		{
			m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE->vSetActivePresetList(oAtStationInfoStatusMsg.Atstationinfo.u16PresetListID);
			m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE->vSetActivePresetList(oAtStationInfoStatusMsg.Atstationinfo.u16PresetListID);
			m_u8PrevBand = (tU8)oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType;
		}
		  
	  }
	  else
	  {
		  if((u8GetTunFGBGStatus() != (tU8)enAudioSource_TA_audio) || ( enAudioSource_PTY_audio == (static_cast<tenAudioSource>(m_u8TunFGBG))))
		{
			m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE->vSetActivePresetList(oAtStationInfoStatusMsg.Atstationinfo.u16PresetListID);
			m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE->vSetActivePresetList(oAtStationInfoStatusMsg.Atstationinfo.u16PresetListID);
			m_u8PrevBand = (tU8)oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType;
		}
	  }
      /*ActiveStationList*/
      oAtStationInfoStatusMsg.Atstationinfo.u8ActiveStationList =  \
										pu8Message[ enCM_ATStationInfo_idx_ActiveStationList];
	  /*HDStationInfoBits*/
      oAtStationInfoStatusMsg.Atstationinfo.b8HDStationInfoBits.u8Value =  pu8Message[ enCM_ATStationInfo_idx_HDStationInfoBits ];
	  
	  /*HDStationId*/
      oAtStationInfoStatusMsg.Atstationinfo.u32StationInfoHDStationID =  \
		  m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ enCM_ATStationInfo_idx_HDStationId ] );
	  
	  /*HDCallSign*/
      //m_potun_HMIManager -> vConvertRTextTotString(&pu8Message[enCM_ATStationInfo_idx_HDCallSign],&sUtf8String,enCM_ATStationInfo_len_HDCallSign) ;
      //oAtStationInfoStatusMsg.Atstationinfo.sHDCallSign.bSet( sUtf8String ,
      //                                                  midw_fi_tclString::FI_EN_UTF8);
	  
	  	  /*e8HDCallSignTextEncoding*/
      oAtStationInfoStatusMsg.Atstationinfo.e8HDCallSignTextEncoding.enType = \
		  (midw_fi_tcl_e8_Tun_HD_TextEncodingType::tenType) pu8Message[ enCM_ATStationInfo_idx_HDCallsignTextEncoding ];

	  if(midw_fi_tcl_e8_Tun_HD_TextEncodingType::FI_EN_ISO_IEC_8859_1_1998 == oAtStationInfoStatusMsg.Atstationinfo.e8HDCallSignTextEncoding.enType)
	  {
		  sUtf8String = (const char *)&(pu8Message[enCM_ATStationInfo_idx_HDCallSign]);
		  oAtStationInfoStatusMsg.Atstationinfo.sHDCallSign.bSet( sUtf8String ,
                                                        midw_fi_tclString::FI_EN_ISO8859_1M);
		  m_sHDActiveCallSign = (const char *)&(pu8Message[enCM_ATStationInfo_idx_HDCallSign]);
	  }
	  else
	  {
		  ETG_TRACE_USR2(("tun_MsgToHMI::vUpdateStationInfo : ************* ERROR ************** HD Text Encoding Not supported"));
	  }

	  /*u8HDStationGenre*/
      oAtStationInfoStatusMsg.Atstationinfo.u8HDStationGenre =  pu8Message[ enCM_ATStationInfo_idx_HDStationGenre ];

	  /*b8HDAudioPrgmAvail*/
      oAtStationInfoStatusMsg.Atstationinfo.b8HDAudioPrgmAvail.u8Value =  pu8Message[ enCM_ATStationInfo_idx_HDNumberOfAudioPrograms ];
	  
	  /*u8HDQuality*/
      oAtStationInfoStatusMsg.Atstationinfo.u8HDQuality =  pu8Message[ enCM_ATStationInfo_idx_HDQuality ];

	  /*e8ActiveHDAudPrgm*/
      oAtStationInfoStatusMsg.Atstationinfo.e8ActiveHDAudPrgm.enType = \
		  (midw_fi_tcl_e8_Tun_HDAudioProgram::tenType) pu8Message[ enCM_ATStationInfo_idx_HDActiveAudioProgram ];
	  
      //update drm data
      vUpdateDRMData(oAtStationInfoStatusMsg, pu8Message);
#endif

	  if(oAtStationInfoStatusMsg.Atstationinfo.u16PI != 0)
	  {
		  
		  vGetStationLogoPath(oAtStationInfoStatusMsg.Atstationinfo.u16PI , sUtf8String);
		  oAtStationInfoStatusMsg.Atstationinfo.StationLogo.bSet(  sUtf8String,
                                                        midw_fi_tclString::FI_EN_UTF8);
	  }
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	  if(m_poclConfigInterface->u32GetConfigData("HDSupported") == true)
	  {
		  if(oAtStationInfoStatusMsg.Atstationinfo.u32StationInfoHDStationID != 0x00 && (bIsFMDemodulationON(oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType) || bIsAMDemodulationON(oAtStationInfoStatusMsg.Atstationinfo.e8Band.enType)) )
		  {
			vGetActiveHDStationLogoPath(oAtStationInfoStatusMsg.Atstationinfo.StationLogo, oAtStationInfoStatusMsg.Atstationinfo.u32StationInfoHDStationID, (tU8)oAtStationInfoStatusMsg.Atstationinfo.e8ActiveHDAudPrgm.enType);
		  }
	  }
#endif

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vUpdateJapanStationCount( )
*
* DESCRIPTION:  Calculate station count for japan station name.
*
* PARAMETER:    midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus
*
* RETURNVALUE:  void
*
*************************************************************************/

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tun_MsgToHMI::vUpdateJapanStationCount(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg)
{
	TUN_ASSERT_RETURN( m_poclTmcTuner_Method_S_JAPAN_SET_AREA != NULL);

	/**u8JapanStationCount  : m_u8TunerState is IDLE and Japan region and station name should not be suppressed*/
	if(m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bIsJapanRegion() &&  (m_u8TunerState == 0) && (!m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bIsSuppressStationName()))
	{
	   //if  ( (prev_freq != cur_freq) or ( (new area code) and (prev_freq == cur_freq) ) )
       if ( (m_potun_ActualData ->m_otun_Data_Station.u32GetFrequency( ) != m_u32ATStationFreq ) ||
             ( (m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bGetNewAreaCodeFlag())
                   &&  (m_potun_ActualData ->m_otun_Data_Station.u32GetFrequency( ) == m_u32ATStationFreq)  )  )
		  {
			 oAtStationInfoStatusMsg.Atstationinfo.u8JapanStationCount = m_poclTmcTuner_Method_S_JAPAN_SET_AREA->u8GetJapanStationCount();
			 if(m_poclTmcTuner_Method_S_JAPAN_SET_AREA->bGetNewAreaCodeFlag())
			 {
				 m_poclTmcTuner_Method_S_JAPAN_SET_AREA->vSetNewAreaCodeFlag( false);
			 }
		  }
		  else // when there is no change in area code or freq,  send the previously calculated station count
		  {
			 oAtStationInfoStatusMsg.Atstationinfo.u8JapanStationCount = m_poclTmcTuner_Method_S_JAPAN_SET_AREA->m_poclJapanStationName->u8GetStationCount();
		  }
	}
	else // for regions other than japan, station count value will be 0 by default. and also during m_u8TunerState!=0 (seek or any other tuning action)
	{
		//ETG_TRACE_USR4(("vUpdateJapanStationCount:: State not IDLE or Is not Japan region or suppress station name"));
		oAtStationInfoStatusMsg.Atstationinfo.u8JapanStationCount = 0;
	}
	ETG_TRACE_USR4(("u8JapanStationCount = %d", oAtStationInfoStatusMsg.Atstationinfo.u8JapanStationCount));
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vUpdateDRMData( )
*
* DESCRIPTION: pack DRM data and post
*
* PARAMETER:    midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus, tU8* pu8Message
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vUpdateDRMData(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg, tU8* pu8Message)
{
	TUN_ASSERT_RETURN( m_potun_HMIManager != NULL);
	TUN_ASSERT_RETURN( pu8Message != NULL);
	TUN_ASSERT_RETURN( m_potun_Utility != NULL);
	TUN_ASSERT_RETURN( m_potun_MsgToADR != NULL);

	/* name is copied in UTF format here */
   midw_fi_tclString sUtf8String ;

	  /*b8DRMStationInfoBits*/
    oAtStationInfoStatusMsg.Atstationinfo.b8DRMStationInfoBits.u8Value =  pu8Message[ enCM_ATStationInfo_idx_DRMStationInfoBits ];

	  /*u32DRMServiceId*/
    oAtStationInfoStatusMsg.Atstationinfo.u32DRMServiceId =  \
		  m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ enCM_ATStationInfo_idx_DRMServiceId ] );

	  /*sDRMServiceLabel*/
    m_potun_HMIManager -> vConvertRTextTotString(&pu8Message[enCM_ATStationInfo_idx_DRMServiceLabel],&sUtf8String,enCM_ATStationInfo_len_DRMServiceLabel) ;
    oAtStationInfoStatusMsg.Atstationinfo.sDRMServiceLabel.bSet( sUtf8String ,
                                                      midw_fi_tclString::FI_EN_UTF8);

	  /*u8DRMPTY*/
    oAtStationInfoStatusMsg.Atstationinfo.u8DRMPTY =  pu8Message[ enCM_ATStationInfo_idx_DRMPTY ];

	  /*b16DRMAnnouBits*/
    oAtStationInfoStatusMsg.Atstationinfo.b16DRMAnnouBits.u16Value =  \
		  m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_ATStationInfo_idx_DRMAnnoSupport] );

	  /*b8DRMNumberOfAudioServices*/
    oAtStationInfoStatusMsg.Atstationinfo.b8DRMNumberOfAudioServices.u8Value =  pu8Message[ enCM_ATStationInfo_idx_DRMNumberOfAudioServices ];

	  /*u8DRMQuality*/
    oAtStationInfoStatusMsg.Atstationinfo.u8DRMQuality =  pu8Message[ enCM_ATStationInfo_idx_DRMQuality ];

	  /*u8DRMServiceShortId*/
    oAtStationInfoStatusMsg.Atstationinfo.u8DRMServiceShortId =  pu8Message[ enCM_ATStationInfo_idx_DRMServiceShortId ];

    /**u8Drmlanguage*/
    oAtStationInfoStatusMsg.Atstationinfo.u8Drmlanguage =  pu8Message[ enCM_ATStationInfo_idx_Drmlanguage ];

    /**u32DrmlanguageCode*/
    oAtStationInfoStatusMsg.Atstationinfo.u32DrmlanguageCode =  \
          m_potun_Utility->u32Convert3SeparateBytesTo32Bit( &pu8Message[ enCM_ATStationInfo_idx_DrmlanguageCode] );

    /**u16DrmCountryCode*/
    oAtStationInfoStatusMsg.Atstationinfo.u16DrmCountryCode =  \
          m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_ATStationInfo_idx_DrmCountryCode] );

    /**s8DrmFrequencyCorrection*/
    oAtStationInfoStatusMsg.Atstationinfo.s8DrmFrequencyCorrection =  pu8Message[ enCM_ATStationInfo_idx_DrmFrequencyCorrection];


	   ETG_TRACE_USR2((" tun_MsgToHMI::vUpdateDRMData : b8DRMStationInfoBits = 0x%02x, u32DRMServiceId = 0x%08x, u8DRMPTY = 0x%02x, b16DRMAnnouBits = 0x%04x, "
					   "b8DRMNumberOfAudioServices = 0x%02x, u8DRMQuality =%d, u8DRMServiceShortId =%d, "
            , oAtStationInfoStatusMsg.Atstationinfo.b8DRMStationInfoBits.u8Value
            , oAtStationInfoStatusMsg.Atstationinfo.u32DRMServiceId
            , oAtStationInfoStatusMsg.Atstationinfo.u8DRMPTY
            , oAtStationInfoStatusMsg.Atstationinfo.b16DRMAnnouBits.u16Value
            , oAtStationInfoStatusMsg.Atstationinfo.b8DRMNumberOfAudioServices.u8Value
            , oAtStationInfoStatusMsg.Atstationinfo.u8DRMQuality
            , oAtStationInfoStatusMsg.Atstationinfo.u8DRMServiceShortId
            ));

	   ETG_TRACE_USR2((" tun_MsgToHMI::vUpdateDRMData : u8Drmlanguage = %d, u32DrmlanguageCode = %u, u16DrmCountryCode=%d  "
	   "s8DrmFrequencyCorrection = %i"
	                , oAtStationInfoStatusMsg.Atstationinfo.u8Drmlanguage
	                , oAtStationInfoStatusMsg.Atstationinfo.u32DrmlanguageCode
	                , oAtStationInfoStatusMsg.Atstationinfo.u16DrmCountryCode
	                , oAtStationInfoStatusMsg.Atstationinfo.s8DrmFrequencyCorrection));

	   ETG_TRACE_USR2((" tun_MsgToHMI::vUpdateDRMData : sDRMServiceLabel = %s", (tChar*)&pu8Message[ enCM_ATStationInfo_idx_DRMServiceLabel]));



}

#endif
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandleChangeBandMethodResult( )
*
* DESCRIPTION:  Sends change band method result to TunerMaster
*
* PARAMETER:    tU8 u8Band,
*               tU16 &u16PresetListID
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandleChangeBandMethodResult\
(tU8 u8Band, tU16 &u16PresetListID)
{
	 if((m_potun_MsgToADR == NULL)
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		 || (m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW == NULL)
#endif
		 )
    {

        NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
        return;
    }
	 ETG_TRACE_USR4((" tun_MsgToHMI::vHandleChangeBandMethodResult() bSystemPresets -%d, u8Band-%d, u8SystemPresets_Band-%d", bSystemPresets, u8Band, u8SystemPresets_Band));
    if((bSystemPresets == true) && (m_u8TunerState == 0x00) && (u8Band == u8SystemPresets_Band))
    {
          
		  /** Get Preset list to update the HMI when Band change happens */
    	ETG_TRACE_USR4((" tun_MsgToHMI::vHandleChangeBandMethodResult() if the requested band is same as cm_atstationband"));
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW->vSendFGBGMethodResult();
        bSystemPresets = false;
		m_poclAars_ATPresetList_XX->vGetPresetList(u16PresetListID);
#else
		m_potun_MsgToADR->vGetPresetList(u16PresetListID);
#endif

		/** Send Set Active Preset List  Method Result, if it was requested earlier */
		vSendSetActivePresetListMethodResult();

    }
	/*Send the cm_systempreset request only if the tuning state is Idle*/
    else if((bSystemPresets == true) && (u8Band != u8SystemPresets_Band) && (m_u8TunerState == 0x00))
    {
        m_potun_MsgToADR->vSendSetBand(u8SystemPresets_Band);
    }
	/** Mixed preset case. where in band change is done via atband
	check too see if tuner is not in testmode and also whether band change was requested. gds5kor: and received band is same as requested and tunerstate is idle
	if so send method result.*/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	ETG_TRACE_USR4((" tun_MsgToHMI::vHandleChangeBandMethodResult() AtBandSent = %d requested for = %d and received band = %d", m_potun_MsgToADR->bGetAtBandSent(), m_potun_MsgToADR->oGetAtBandRequested(), m_potun_MsgToADR->u8ConvertTunerbandToCombiband(u8Band)));
#endif
    if( (m_potun_MsgToADR->bGetAtBandSent())
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		&& (m_potun_MsgToADR->oGetAtBandRequested() == m_potun_MsgToADR->u8ConvertTunerbandToCombiband(u8Band)) && (m_u8TunerState == 0)
#endif
		)
    {
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
    	ETG_TRACE_USR4((" tun_MsgToHMI::vHandleChangeBandMethodResult() if the requested band is same as cm_atstationband"))
		m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW->vSendFGBGMethodResult();
#endif

		m_potun_MsgToADR->vSetAtBandSent(false);  
		/** Send Set Active Preset List  Method Result, if it was requested earlier */
		vSendSetActivePresetListMethodResult();
    }
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
    else if((m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW->IsUserSwitchedTunerToFG()) && (m_u8TunerState == 0) && (!(m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW->bIsBandChangeRequested())))
	{
    	ETG_TRACE_USR4((" tun_MsgToHMI::vHandleChangeBandMethodResult() only we cm_audiosource request is send without cm_systempreset and cm_atband"));
    	m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW->vSendFGBGMethodResult();
	}
#endif
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSendSetActivePresetListMethodResult( )
*
* DESCRIPTION:  Sends Set ActivePresetList Method Result
*
* PARAMETER:    
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSendSetActivePresetListMethodResult()
{
	 if((m_potun_MsgFromHMI == NULL))
    {
        NORMAL_M_ASSERT( m_potun_MsgFromHMI != NULL );
        return;
    }
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	 if(m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST!=NULL)
	 {
		 if(m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST->bIsActivePresetListRequested())
		 {
			 m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST->vOnATPresetListSetActiveResult();
			 m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST->vSetActivePresetListRequested(false);
		 }
	 }
#else
	if(m_potun_MsgFromHMI->bGet_SetActivePresetListRequested() == true)
	{
		vHandle_r_CM_ATPresetListSetActive();
		m_potun_MsgFromHMI->vSet_SetActivePresetListRequested(false);
		ETG_TRACE_USR2((" vSendSetActivePresetListMethodResult::Sending Set Active Preset List Method Result"));
	}
#endif
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandleDirectFrequencyMethodResult( )
*
* DESCRIPTION:  Sends direct frequency method result to TunerMaster
*
* PARAMETER:    midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandleDirectFrequencyMethodResult(tU32 u32frequency)
{
	if(m_potun_MsgFromHMI == NULL)
    {

        NORMAL_M_ASSERT( m_potun_MsgFromHMI != NULL );
        return;
    }

    if(vGetDirectFreqRequested() && (m_potun_MsgFromHMI->u32GetDirectFreqRequested() == u32frequency))
    {
        /*Send Direct Freq Method Result to TunerMaster - SDS case*/
        /*Send method result to Tunermaster*/
        midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult oResponse;

    	      		// Response -> SUCC / FAIL / BUSY
    	      		oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
    	      								midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;

    	      		// Current Tuner state -> Not required for client. NORAL added as default.
    	      		oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
    	      								midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

    	      		tU16 u16CmdCtr = u16GetTunerMasterCommandCntrForDirectFreq();
    	      		tU16 u16RegID = u16GetTunerMasterRegIDForDirectFreq();

    	      		//------------------------------
    	      		// Send the response to client.
    	      		//------------------------------
    	      	    vSendMessage( CCA_C_U16_APP_TUNERMASTER,
    	      	                   oResponse,
    	      	                   MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY,
    	      	                   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
    	      	                   u16CmdCtr,
    	      	                   u16RegID
    	      	                 );

    	      	    vSetDirectFreqRequested(FALSE);

    }

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::u32CheckAMFreqRange( )
*
* DESCRIPTION:  Check the AM frequency range to set the frequency of the PWM12
*
* PARAMETER:    tU32 u32Freq , tU8 u8Sync_Signal
*
* RETURNVALUE:  tU32
*
*************************************************************************/
tU32 tun_MsgToHMI::u32CheckAMFreqRange(tU32 u32Freq , tU8 u8Sync_Signal)const
{
	if(poGWMain == NULL)
   {
        NORMAL_M_ASSERT( poGWMain != NULL );
        return 0;
   }
	
	tU32 u32CorrectedFreq = 0;
	if(u8Sync_Signal == TUN_PWM_SYNC_SIGNAL1)
	{
		u32CorrectedFreq = TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC1_RANGE1;
		if(AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION_SYNC1_RANGE1)
		{
			if(u32Freq >= (unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") && u32Freq <= (unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW"))
			{
				u32CorrectedFreq = TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC1_RANGE1;
			}
		}
		else if(AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION_SYNC1_RANGE2)
		{
			if(u32Freq >= (unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") && u32Freq <= (unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW"))
			{
				u32CorrectedFreq = TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC1_RANGE2;
			}
		}
		else
		{
			// no operations
		}
	}
	else if(u8Sync_Signal == TUN_PWM_SYNC_SIGNAL3)
	{
		u32CorrectedFreq = TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC3_RANGE1;
		if(AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION_SYNC3_RANGE1)
		{
			if(u32Freq >= (unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") && u32Freq <= (unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW"))
			{
				u32CorrectedFreq = TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC3_RANGE1;
			}
		}
		else if(AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION_SYNC3_RANGE2)
		{
			if(u32Freq >= (unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") && u32Freq <= (unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW"))
			{
				u32CorrectedFreq = TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC3_RANGE2;
			}
		}
		else
		{
			// no operations
		}
	}
	else if(u8Sync_Signal == TUN_PWM_SYNC_GEN3)
	{
		u32CorrectedFreq = TUN_PWM_HIGH_CORRECTEDFREQUENCY;
		if(AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION)
		{
			#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			u32CorrectedFreq = 320000;
			#else
			#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
			if(u32Freq >= (unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") && u32Freq <= (unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW"))
			{
			u32CorrectedFreq = 322580;
			}
			else
			{
			u32CorrectedFreq = 366970;
			}
			#else
			#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
			u32CorrectedFreq = 320000;
			#else

			u32CorrectedFreq = 487800;
			#endif
			#endif
			#endif
		}
	}
	else
	{
		// no handling
	}

	return u32CorrectedFreq;
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_DDASwitch( )
* 
* DESCRIPTION:  Handle CM_DDASwitch status from ADR3
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_DDASwitch( const tU8* pu8Message )
{
  if((pu8Message == NULL)||( m_poHMINotTable == NULL )
      )
   {
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
     return;
   }

    /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */ 
    /*--------------------------------------------------------*/
  //  if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
    {
      ahl_bEnterCritical( m_hNotHMITableSem );

       for(ahl_tNotification* pNot =
                m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_DDA) ;
           pNot != OSAL_NULL;
           pNot=pNot->pNext
          )
      {
          
          midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/  
          
          /* DDAMode / Phase diversity */
          /*u8DDA = 0x00  -> DDA Off
            u8DDA   = 0x01  -> DDA Enabled
            u8DDA   = 0x02  -> DDA Forced ON 
          */
          oStatusMsg.u8DDA = pu8Message[enAdrMsgOffset_DATA];

              
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,
                             ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_DDA _\
                             ET_EN_T8 _ (oStatusMsg.u8DDA) _\
                             ET_EN_DONE);
   
    ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_DDASwitch() -> DDAMode = 0x%02x" , oStatusMsg.u8DDA));
         /* ---
         send it to the client 
         --- */

           vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_SET_DDA,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );

      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */
      
      ahl_bReleaseCritical(m_hNotHMITableSem);

    } /*End of if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) ) */
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_REGMode( )
* 
* DESCRIPTION:  Handle REG status from ADR
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_REGMode( const tU8* pu8Message, tU32 u32MessageLen )
{
  if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL)||
       (u32MessageLen == 0) ||( m_poHMINotTable == NULL )
      )
   {
      if( m_potun_HMIManager == NULL )
      {
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
      } 
      if( pu8Message == NULL )
      {
        NORMAL_M_ASSERT( pu8Message != NULL );
      }
      if( u32MessageLen == 0 )
      {
        NORMAL_M_ASSERT( u32MessageLen != 0 );
      }
      if( m_poHMINotTable == NULL )
      {
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
      }
     return;
   }
   
   /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */ 
    /*--------------------------------------------------------*/
  //  if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
    {
      ahl_bEnterCritical( m_hNotHMITableSem );

       for(ahl_tNotification* pNot =
                m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG) ;
           pNot != OSAL_NULL;
           pNot=pNot->pNext
          )
      {
          
          midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/  
      if(pu8Message[enAdrMsgOffset_DATA] == 0x04) //ON
      {
      oStatusMsg.u8RDSreg = 0x00; //FIX
      ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_REGMode() -> FIX"));
      }
      else if(pu8Message[enAdrMsgOffset_DATA] == 0x01)//AUTO
      {
        oStatusMsg.u8RDSreg = 0x01; //AUTO
      ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_REGMode() -> AUTO"));
      }
          
              
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,
                             ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG _\
                             ET_EN_T8 _ (oStatusMsg.u8RDSreg) _\
                             ET_EN_DONE);
   
     ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_REGMode() -> REG = 0x%02x" , oStatusMsg.u8RDSreg));
         /* send it to the client  */

           vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDSREG,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );

      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */
      ahl_bReleaseCritical(m_hNotHMITableSem);

    } /*End of if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) ) */
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_RDSSwitch( )
* 
* DESCRIPTION:  Handle RDSSwitch status from ADR and sends status msg to clients
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void
*
* Author : vnd4kor ECG
*************************************************************************/

tVoid tun_MsgToHMI::vHandle_r_RDSSwitch( const tU8* pu8Message )
{
	if((pu8Message == NULL)||( m_poHMINotTable == NULL )
		)
	{
			NORMAL_M_ASSERT( pu8Message != NULL );
			NORMAL_M_ASSERT( m_poHMINotTable != NULL );
		return;
	}

	ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_RDSSwitch()"));


	ahl_bEnterCritical( m_hNotHMITableSem );

	for(ahl_tNotification* pNot =
		m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDS) ;
		pNot != OSAL_NULL;
	pNot=pNot->pNext
		)
	{

		midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus oStatusMsg;

		/*------------------------*/
		/* Fill in the message    */
		/*------------------------*/  

		oStatusMsg.u8RDS = pu8Message[enAdrMsgOffset_DATA]; 

		/** store the RDS switch value */
		vSetRDSSwitchStatus(pu8Message[enAdrMsgOffset_DATA]);

		ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_RDSSwitch() -> RDS = 0x%02x" , oStatusMsg.u8RDS));

		/* send msg to the client  */
		vSendMessage ( pNot->u16AppID,
			oStatusMsg,
			MIDW_TUNERFI_C_U16_FID_TUN_G_SET_RDS,
			AMT_C_U8_CCAMSG_OPCODE_STATUS,
			pNot->u16CmdCounter,
			pNot->u16RegisterID );

	} /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
	  pNot != OSAL_NULL; pNot=pNot->pNext) */
	ahl_bReleaseCritical(m_hNotHMITableSem);

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_AFBestSwitch( )
* 
* DESCRIPTION:  Handle CM_AfBestSwitch status from ADR
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_AFBestSwitch( const tU8* pu8Message )
{
  if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL)||
       ( m_poHMINotTable == NULL )
      )
   {
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
     return;
   }
   
   /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */ 
    /*--------------------------------------------------------*/
  //  if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
    {
      ahl_bEnterCritical( m_hNotHMITableSem );

       for(ahl_tNotification* pNot =
                m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF) ;
           pNot != OSAL_NULL;
           pNot=pNot->pNext
          )
      {
          
          midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/  

          oStatusMsg.u8AF = pu8Message[enAdrMsgOffset_DATA];
          vSetAFSwitchValue(oStatusMsg.u8AF);
              
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,
                             ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF _\
                             ET_EN_T8 _ (oStatusMsg.u8AF) _\
                             ET_EN_DONE);
     ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_AFBestSwitch() -> AF = 0x%02x" , oStatusMsg.u8AF));
   
         /* send it to the client  */

           vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );

      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */
      ahl_bReleaseCritical(m_hNotHMITableSem);

    } /*End of if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) ) */
   
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Set_Feature( )
* 
* DESCRIPTION:  Radio unit response indicating feature ON or OFF.
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Set_Feature( const tU8* pu8Message)
{
    if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL) ||
       (m_potun_ActualData == NULL) || ( m_poHMINotTable == NULL )
      )
   {
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_potun_ActualData != NULL );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
     return;
   }

    /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */ 
    /*--------------------------------------------------------*/
    //if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
    {
      ahl_bEnterCritical( m_hNotHMITableSem );

      for(ahl_tNotification* pNot =
              m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE) ;
          pNot != OSAL_NULL;
          pNot=pNot->pNext)
      {
          
            midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/  
          
            oStatusMsg.b32_Features.u32Value = m_potun_ActualData->m_otun_Data_MainStatus.u32GetFeatures();

            /*-------------------------------*/
            /* Post message to HMI component */
            /*-------------------------------*/          
                
            ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                               ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE _\
                               ET_EN_T8 _ 0x01 _/* trace no used in trc file for writing rule */\
                               ET_EN_T32 _ oStatusMsg.b32_Features.u32Value _\
                               ET_EN_DONE);
         
           vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );


      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID);
               pNot != OSAL_NULL;
               pNot=pNot->pNext) */
      
      ahl_bReleaseCritical(m_hNotHMITableSem);

    } /* End of if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) ) */
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Get_TestMode( )
* 
* DESCRIPTION:  Radio unit response, giving test mode details.
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Get_EnhancedTestMode( const tU8* pu8Message )
{
	
    if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL) 
             ||( m_poHMINotTable == NULL ) || (m_potun_Utility == NULL))
   {
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
        NORMAL_M_ASSERT( m_potun_Utility != NULL );
      
     return;
   }
   
   
    ahl_bEnterCritical( m_hNotHMITableSem );
    for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS) ; pNot != OSAL_NULL; pNot=pNot->pNext)
    {
      midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus oTestModeDataStatusMsg;
      
      /* Tuner Header */
      tun_FI_HelpFunc :: bConverttU8toEnumPhsicalTuner((pu8Message[enAdrMsgOffset_INSTANCE_ID]),
                            oTestModeDataStatusMsg.TunerTestModeData.u8PhysicalTuner.enType);
        
      /* Modulation */                
      oTestModeDataStatusMsg.TunerTestModeData.u8Source.enType = (midw_fi_tcl_e8_Tun_Testmode_TunerBand::tenType)pu8Message[10];   
      
      /* Frequency */
      oTestModeDataStatusMsg.TunerTestModeData.u32AFFrequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[11] );
      
      /* Current PI */
      oTestModeDataStatusMsg.TunerTestModeData.u16CurrentPI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[15] );
      
	  /*Target PI */
      oTestModeDataStatusMsg.TunerTestModeData.u16TargetPI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[17] );
      
      /* Quality */
      oTestModeDataStatusMsg.TunerTestModeData.u8Quality = pu8Message[19]; 
      
      /* FieldStrength */
      oTestModeDataStatusMsg.TunerTestModeData.u8Fieldstrength = pu8Message[20]; 
   
      /* Multipath */
      oTestModeDataStatusMsg.TunerTestModeData.u8Multipath = pu8Message[21]; 
      
      /* Neighbour */
      oTestModeDataStatusMsg.TunerTestModeData.u8Neighbour = pu8Message[22]; 
   
      /* AFListLength */
      oTestModeDataStatusMsg.TunerTestModeData.u8AFListLength = pu8Message[23]; 
      /* Highcut */
      oTestModeDataStatusMsg.TunerTestModeData.u8HiCut = pu8Message[24];
      
      /* Sharx */
      oTestModeDataStatusMsg.TunerTestModeData.u8Sharx = pu8Message[25];
    
	/* Current Station Name*/
      midw_fi_tclString sUtf8String ;
      m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[26],&sUtf8String) ;
      oTestModeDataStatusMsg.TunerTestModeData.sCurrentStationName.bSet( sUtf8String ,
                               midw_fi_tclString::FI_EN_UTF8);
	/* Fix Station Name*/						   
	 m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[34],&sUtf8String) ;
     oTestModeDataStatusMsg.TunerTestModeData.sFixPSName.bSet( sUtf8String ,
                               midw_fi_tclString::FI_EN_UTF8);
							   
    
	/*ScrollPSStatus*/
	oTestModeDataStatusMsg.TunerTestModeData.bScrollPSStatus = pu8Message[42];
	
	/*AFStatus*/
	oTestModeDataStatusMsg.TunerTestModeData.bAFStatus = pu8Message[43];
      
	  /*FM deviation*/
	oTestModeDataStatusMsg.TunerTestModeData.u8FMDeviation = pu8Message[44];
	/*RDS deviation*/
	oTestModeDataStatusMsg.TunerTestModeData.u8RDSDeviation = pu8Message[45];
	
	/*IF Offset*/
	oTestModeDataStatusMsg.TunerTestModeData.s8IFOffset = pu8Message[46];
	
	/*RDS Offset*/
	oTestModeDataStatusMsg.TunerTestModeData.s8RDSOffset = pu8Message[47];
	
	/*Co Channel Status*/
	oTestModeDataStatusMsg.TunerTestModeData.u8CoChannelStatus = pu8Message[48];
	
	/*AGC*/
	oTestModeDataStatusMsg.TunerTestModeData.u8AGC = pu8Message[49];
      /* ChannelSeperation */
      oTestModeDataStatusMsg.TunerTestModeData.u8ChannelSeparation = pu8Message[50];

      /* RDS error rate */
      oTestModeDataStatusMsg.TunerTestModeData.u8RdsErrorRate = pu8Message[51];

      /* DiversityState */
      oTestModeDataStatusMsg.TunerTestModeData.e8DiversityState.enType = (midw_fi_tcl_e8_Tun_DiversityState::tenType)pu8Message[52];
      
	  /* AntennaPathSwitch1 */
      oTestModeDataStatusMsg.TunerTestModeData.e8AntennaPathSwitch1.enType = (midw_fi_tcl_e8_Tun_AntennaPathSwitch1::tenType)pu8Message[53];
      
	  /* AntennaPathSwitch2 */
      oTestModeDataStatusMsg.TunerTestModeData.e8AntennaPathSwitch2.enType = (midw_fi_tcl_e8_Tun_AntennaPathSwitch2::tenType)pu8Message[54];
      /* Info bits */
      oTestModeDataStatusMsg.TunerTestModeData.u8TestmodeBits.u8Value = pu8Message[55];
	  
	  tU8 u8AudibleTunerbit = pu8Message[55] & TESTMODE_AUDIBLETUNER_MASK;
            u8AudibleTunerbit = (tU8)(u8AudibleTunerbit >> 4 );
			
	  vPrintTestModeTraces(oTestModeDataStatusMsg);

	  if(u8AudibleTunerbit)
	  {
		m_u8PhysicalTuner = ((tU8)oTestModeDataStatusMsg.TunerTestModeData.u8PhysicalTuner.enType);  // check
		ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_EnhancedTestMode() ->m_u8PhysicalTuner = 0x%02x" , m_u8PhysicalTuner));
	  }
       
      vSendMessage ( pNot->u16AppID,
                     oTestModeDataStatusMsg,
                     MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS,
                     AMT_C_U8_CCAMSG_OPCODE_STATUS,
                     pNot->u16CmdCounter,
                     pNot->u16RegisterID );
    }
    ahl_bReleaseCritical(m_hNotHMITableSem);
   
  

   
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vPrintTestModeTraces( )
* 
* DESCRIPTION:  Print traces for Testmode Data.
*
* PARAMETER:    midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus &oTestModeDataStatusMsg
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vPrintTestModeTraces(\
						midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus \
						&oTestModeDataStatusMsg
					)const
{
	
	/** Print traces related to Test mode */
	  ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_TestMode() Part1 ->\n\
					    Source = 0x%02x, Freq = %u, Current PI = 0x%x, \
						Target PI = 0x%x " , \
						oTestModeDataStatusMsg.TunerTestModeData.u8Source.enType,\
						oTestModeDataStatusMsg.TunerTestModeData.u32AFFrequency,\
						oTestModeDataStatusMsg.TunerTestModeData.u16CurrentPI,\
						oTestModeDataStatusMsg.TunerTestModeData.u16TargetPI\
						));

	  ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_TestMode() Part2 -> \n\
					   Quality = 0x%02x, Fieldstrength = %d, Multipath = 0x%02x, \
					   NC = 0x%02x, AFListLength = 0x%02x" , \
					   oTestModeDataStatusMsg.TunerTestModeData.u8Quality,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8Fieldstrength,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8Multipath,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8Neighbour,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8AFListLength
					   ));

	  ETG_TRACE_USR2((" tun_MsgToHMI::vHandle_r_Get_TestMode() Part3 -> \n\
					  CurrentStationname = %8s, FixStationname = %8s"\
					  ,(tChar*)oTestModeDataStatusMsg.TunerTestModeData.sCurrentStationName
					  ,(tChar*)oTestModeDataStatusMsg.TunerTestModeData.sFixPSName
                      ));


	  ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_TestMode() Part4 -> \n\
					   HiCut = 0x%02x, Sharx = 0x%02x, ScrollPSStatus = 0x%02x, \
					   AFStatus = 0x%02x, FMDeviation = 0x%02x" ,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8HiCut,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8Sharx,\
					   oTestModeDataStatusMsg.TunerTestModeData.bScrollPSStatus,\
					   oTestModeDataStatusMsg.TunerTestModeData.bAFStatus,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8FMDeviation
					   ));

	  ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_EnhancedTestMode() Part5 -> \n\
					 RDSDeviation = 0x%02x, IFOffset = 0x%02x, RDSOffset = 0x%02x, \
					 CoChannelStatus = 0x%02x, AGC = 0x%02x" ,\
					 oTestModeDataStatusMsg.TunerTestModeData.u8RDSDeviation,\
					 oTestModeDataStatusMsg.TunerTestModeData.s8IFOffset,\
					 oTestModeDataStatusMsg.TunerTestModeData.s8RDSOffset,\
					 oTestModeDataStatusMsg.TunerTestModeData.u8CoChannelStatus,\
					 oTestModeDataStatusMsg.TunerTestModeData.u8AGC\
					 ));

	  ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_EnhancedTestMode() Part6 -> \n\
					   CS = 0x%02x, RDSErrorRate = 0x%02x, Diversity State = 0x%02x, \
					   AntennaPathSwitch1 = 0x%02x, AntennaPathSwitch2 = 0x%02x, InfoBits = 0x%02x" ,\
                       oTestModeDataStatusMsg.TunerTestModeData.u8ChannelSeparation,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8RdsErrorRate,\
					   oTestModeDataStatusMsg.TunerTestModeData.e8DiversityState.enType,\
					   oTestModeDataStatusMsg.TunerTestModeData.e8AntennaPathSwitch1.enType,\
					   oTestModeDataStatusMsg.TunerTestModeData.e8AntennaPathSwitch2.enType,\
					   oTestModeDataStatusMsg.TunerTestModeData.u8TestmodeBits.u8Value\
					   ));
  
      
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Get_TestMode( )
* 
* DESCRIPTION:  Radio unit response, giving test mode details.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Get_TestMode( const tU8* pu8Message )
{
    	
    if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL)
             || ( m_poHMINotTable == NULL ) || (m_potun_Utility == NULL))
   {
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
        NORMAL_M_ASSERT( m_potun_Utility != NULL );
      
     return;
   }
  
    ahl_bEnterCritical( m_hNotHMITableSem );
    for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS) ; pNot != OSAL_NULL; pNot=pNot->pNext)
    {
      midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus oTestModeDataStatusMsg;
      
      /* Tuner Header */
      tun_FI_HelpFunc :: bConverttU8toEnumPhsicalTuner((pu8Message[enAdrMsgOffset_INSTANCE_ID]),
                            oTestModeDataStatusMsg.TunerTestModeData.u8PhysicalTuner.enType);
        
      /* Modulation */                
      oTestModeDataStatusMsg.TunerTestModeData.u8Source.enType = (midw_fi_tcl_e8_Tun_Testmode_TunerBand::tenType)pu8Message[10];   
            
      /* Frequency */
      oTestModeDataStatusMsg.TunerTestModeData.u32AFFrequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[11] ); 
      
      /* Current PI */
      oTestModeDataStatusMsg.TunerTestModeData.u16CurrentPI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[15] );
      
	  /*Target PI */
      oTestModeDataStatusMsg.TunerTestModeData.u16TargetPI = 0;
      
	  /* Quality */
      oTestModeDataStatusMsg.TunerTestModeData.u8Quality = pu8Message[17]; 
      
      /* FieldStrength */
      oTestModeDataStatusMsg.TunerTestModeData.u8Fieldstrength = pu8Message[18]; 

      /* Multipath */
      oTestModeDataStatusMsg.TunerTestModeData.u8Multipath = pu8Message[19]; 
      
      /* Neighbour */
      oTestModeDataStatusMsg.TunerTestModeData.u8Neighbour = pu8Message[20]; 

      /* AFListLength */
      oTestModeDataStatusMsg.TunerTestModeData.u8AFListLength = pu8Message[21]; 
      
      /* Highcut */
      oTestModeDataStatusMsg.TunerTestModeData.u8HiCut = pu8Message[22];
      
      /* Sharx */
      oTestModeDataStatusMsg.TunerTestModeData.u8Sharx = pu8Message[23];
    
	/* Current Station Name*/
      midw_fi_tclString sUtf8String ;
      m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[24],&sUtf8String) ;
      oTestModeDataStatusMsg.TunerTestModeData.sCurrentStationName.bSet( sUtf8String ,
                               midw_fi_tclString::FI_EN_UTF8);
	/* Fix Station Name*/						   
	 m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[24],&sUtf8String) ;
     oTestModeDataStatusMsg.TunerTestModeData.sFixPSName.bSet( sUtf8String ,
                               midw_fi_tclString::FI_EN_UTF8);
							   
	
	/*ScrollPSStatus*/
	oTestModeDataStatusMsg.TunerTestModeData.bScrollPSStatus = 0;
	
	/*AFStatus*/
	oTestModeDataStatusMsg.TunerTestModeData.bAFStatus = 0;
      
	  /*FM deviation*/
	oTestModeDataStatusMsg.TunerTestModeData.u8FMDeviation = pu8Message[34];
	      

	/*RDS deviation*/
	oTestModeDataStatusMsg.TunerTestModeData.u8RDSDeviation = 0;
    
	/*IF Offset*/
	oTestModeDataStatusMsg.TunerTestModeData.s8IFOffset = 0;
    
	/*RDS Offset*/
	oTestModeDataStatusMsg.TunerTestModeData.s8RDSOffset = 0;
    
	/*Co Channel Status*/
	oTestModeDataStatusMsg.TunerTestModeData.u8CoChannelStatus = 0;
    
	/*AGC*/
	oTestModeDataStatusMsg.TunerTestModeData.u8AGC = 0;

      /* ChannelSeperation */
      oTestModeDataStatusMsg.TunerTestModeData.u8ChannelSeparation = pu8Message[32];

      /* RDS error rate */
      oTestModeDataStatusMsg.TunerTestModeData.u8RdsErrorRate = pu8Message[33];

      /* DiversityState */
      oTestModeDataStatusMsg.TunerTestModeData.e8DiversityState.enType = (midw_fi_tcl_e8_Tun_DiversityState::tenType)0;
      
	  /* AntennaPathSwitch1 */
      oTestModeDataStatusMsg.TunerTestModeData.e8AntennaPathSwitch1.enType = (midw_fi_tcl_e8_Tun_AntennaPathSwitch1::tenType)0;
      
	  /* AntennaPathSwitch2 */
      oTestModeDataStatusMsg.TunerTestModeData.e8AntennaPathSwitch2.enType = (midw_fi_tcl_e8_Tun_AntennaPathSwitch2::tenType)0;

      /* Info bits */
      oTestModeDataStatusMsg.TunerTestModeData.u8TestmodeBits.u8Value = pu8Message[35];
	  
	  tU8 u8AudibleTunerbit = pu8Message[35] & TESTMODE_AUDIBLETUNER_MASK;
            u8AudibleTunerbit = (tU8)(u8AudibleTunerbit >> 4) ;

	  vPrintTestModeTraces(oTestModeDataStatusMsg);
	
	  if(u8AudibleTunerbit)
		{
			m_u8PhysicalTuner = ((tU8)oTestModeDataStatusMsg.TunerTestModeData.u8PhysicalTuner.enType);  // check
			ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_TestMode() ->m_u8PhysicalTuner = 0x%02x" , m_u8PhysicalTuner));
		}

      
       
      vSendMessage ( pNot->u16AppID,
                     oTestModeDataStatusMsg,
                     MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS,
                     AMT_C_U8_CCAMSG_OPCODE_STATUS,
                     pNot->u16CmdCounter,
                     pNot->u16RegisterID );
    }
    ahl_bReleaseCritical(m_hNotHMITableSem);
   
   
}






/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Set_Highcut( )
* 
* DESCRIPTION:  Radio unit response ( TUN_R_SET_HICUT ) giving Hicut values.
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Set_Highcut( const tU8* pu8Message)
{
    if((pu8Message == NULL)||( m_poHMINotTable == NULL ) )
   {
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );

     return;
   }

	ETG_TRACE_USR4(( " tun_MsgToHMI::vHandle_r_Set_Highcut() "));

    /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */ 
    /*--------------------------------------------------------*/
  //  if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
    //{
      ahl_bEnterCritical( m_hNotHMITableSem );

       for(ahl_tNotification* pNot =
                m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_HICUT) ;
           pNot != OSAL_NULL;
           pNot=pNot->pNext
          )
      {
          
          midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/  
          
          /* Hicut u8AbsVal */
          /*u8AbsValue = 0x00  -> HICUT_OFF
            u8AbsValue = 0x01  -> HICUT_LEVEL1 
            u8AbsValue = 0x02  -> HICUT_LEVEL2 
            u8AbsValue = 0x03  -> HICUT_LEVEL3 
            u8AbsValue = 0x04  -> HICUT_LEVEL4 
            u8AbsValue = 0x05  -> HICUT_LEVEL5 
            u8AbsValue = 0x06  -> HICUT_LEVEL6 
            u8AbsValue = 0x07  -> HICUT_LEVEL7 
          */
          oStatusMsg.u8AbsVal = pu8Message[12];

              
         
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,
                             ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_HICUT _\
                             ET_EN_T8 _ 0x01 _\
                             ET_EN_T8 _ (oStatusMsg.u8AbsVal) _\
                             ET_EN_DONE);
   
         /* ---
         send it to the client 
         --- */

           vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_SET_HICUT,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );

      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */
      
      ahl_bReleaseCritical(m_hNotHMITableSem);

    //} /*End of if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) ) */

}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Get_CalibrationData( )
*
* DESCRIPTION:  Radio unit response giving Calibration values.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Get_CalibrationData( tU8* pu8Message, tU32 u32MessageLen )
{
  TUN_ASSERT_RETURN( m_potun_Utility != NULL);

    if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL)||
       (u32MessageLen == 0) ||( m_poHMINotTable == NULL ) ||
       (m_poclConfigInterface == NULL)
      )
   {

        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( u32MessageLen != 0 );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
        NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
        return;
   }

   ETG_TRACE_USR1(( " tun_MsgToHMI::vHandle_r_Get_CalibrationData() entered"));
    /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */
    /*--------------------------------------------------------*/
  //  if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
    {
      ahl_bEnterCritical( m_hNotHMITableSem );

       for(ahl_tNotification* pNot =
                m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_CALIBRATION_DATA) ;
           pNot != OSAL_NULL;
           pNot=pNot->pNext
          )
      {
		ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_CalibrationData() entered looop"));

          midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus oStatusMsg;

		  tU16 u16CalibrationData = 0;

		  /*FM1 Tuner*/
		  u16CalibrationData = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[10] );
		  oStatusMsg.CalibrationData.CalibrationValues.push_back(u16CalibrationData);
		  
						   
		  
		  /*FM2 Tuner*/

		   u16CalibrationData = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[12] );
		   oStatusMsg.CalibrationData.CalibrationValues.push_back(u16CalibrationData);
		   
		   /*FM3 Tuner*/
		    u16CalibrationData = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[14] );
		   oStatusMsg.CalibrationData.CalibrationValues.push_back(u16CalibrationData);
		   
		   /*FM4 Tuner*/
		   u16CalibrationData = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[16] );
		   oStatusMsg.CalibrationData.CalibrationValues.push_back(u16CalibrationData);

		   /*For tuner variant 1 and 2, we have to use AM calibration data of tuner 2.
		    For all other tuner variants, we have to use AM calibration data of tuner 1.*/
		   tU8 u8TunerMode = (tU8)m_poclConfigInterface->u32GetConfigData("FmDabHdTunerMode");
		   if(u8TunerMode == TUN_VAR1_2FE_DDA 
			   || u8TunerMode == TUN_VAR2_1FE 
			   || u8TunerMode == TUN_VAR45_2FE 
			   || u8TunerMode == TUN_VAR47_2FE 
			   || u8TunerMode == TUN_VAR48_3FE 
			   || u8TunerMode == TUN_VAR49_3FE 
			   || u8TunerMode == TUN_VAR50_3FE 
			   || u8TunerMode == TunVar51_2FE_AM_2FE  
			   || u8TunerMode == TunVar52_3FE_AM_2FE_DDA  
			   || u8TunerMode == TunVar55_4FE_AM_2FE_DDA_DAB  
			   || u8TunerMode == TunVar56_4FE_AM_2FE_DAB_NO_FM2  
			   || u8TunerMode == TunVar57_3FE_AM_2FE  
			   || u8TunerMode == TunVar61_2FE_AM_2FE_DAB  
			   || u8TunerMode == TunVar62_3FE_AM_2FE_DDA_DAB  
			   || u8TunerMode == TunVar63_3FE_AM_2FE_DAB  
			   || u8TunerMode == TunVar64_4FE_AM_2FE_DDA_DAB  
			   || u8TunerMode == TunVar66_2FE_DAB  
			   || u8TunerMode == TunVar67_3FE_DDA_DAB  
			   || u8TunerMode == TunVar68_3FE_DAB
			   || u8TunerMode == TunVar69_4FE_DDA_DAB
			   || u8TunerMode == TunVar70
			   || u8TunerMode == TunVar71 )
		   {
			   u16CalibrationData = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[20] );
			   oStatusMsg.CalibrationData.CalibrationValues.push_back(u16CalibrationData);

			   ETG_TRACE_USR1(( " tun_MsgToHMI::vHandle_r_Get_CalibrationData() -> TunerMode is 1 or 2"));
		   }
		   else
		   {
			   u16CalibrationData = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[18] );
			   oStatusMsg.CalibrationData.CalibrationValues.push_back(u16CalibrationData);
			   ETG_TRACE_USR1(( " tun_MsgToHMI::vHandle_r_Get_CalibrationData() -> TunerMode is not 1 or 2"));
		   }

		ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_CalibrationData() -> CalibrationData = 0x%04x, 0x%04x, 0x%04x, 0x%04x, 0x%04x" 
		, oStatusMsg.CalibrationData.CalibrationValues[0]
		, oStatusMsg.CalibrationData.CalibrationValues[1]
		, oStatusMsg.CalibrationData.CalibrationValues[2]
		, oStatusMsg.CalibrationData.CalibrationValues[3]
		, oStatusMsg.CalibrationData.CalibrationValues[4]
		));

        vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_CALIBRATION_DATA,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );

      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */

      ahl_bReleaseCritical(m_hNotHMITableSem);

    } /*End of if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) ) */

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_TunerState( )
*
* DESCRIPTION:  Handles response CM_AtTunerState from ADR
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_TunerState( const tU8* pu8Message)
{
    if(( m_potun_Utility == NULL ) ||(pu8Message == NULL)||(m_potun_MsgFromHMI == NULL)
      || (poGWMain == NULL) )
   {
        NORMAL_M_ASSERT( m_potun_Utility != NULL );
		NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_potun_MsgFromHMI != NULL );
        NORMAL_M_ASSERT( poGWMain != NULL );

     return;
   }

	m_u8TunerState = pu8Message[enCM_ATTunerState_idx_TuningState];
	tU16 u16FunctionId = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Message[enCM_ATTunerState_idx_FID]);
	ETG_TRACE_USR1(( " tun_MsgToHMI::vHandle_r_TunerState() -> TunerState = %d, FID = 0x%4x", m_u8TunerState,u16FunctionId));

	if(m_u8TunerState  == 0)
	{
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		vHandleAdvisoryMemberVariableStates (u16FunctionId);
#endif
		if(u16FunctionId != (tU16)enMsg_CM_AtPiSearch)
		{
			TUN_ASSERT_RETURN(poGWMain->m_poclAars_AtPiSearch != NULL);
			poGWMain->m_poclAars_AtPiSearch->vSendAtPiSearchStatus((tU8)midw_fi_tcl_e8_PISearch_Status::FI_EN_IDLE,0x00);

		}		
	}

#ifdef MUTE_ACTIVE
	if((m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_curr != None)
			|| (m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_next != None))
	{
		if(m_u8TunerState == 0)
		{
			vHandleMuteDemuteAction();	
		}
	}
#endif
}

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandleAdvisoryMemberVariableStates( )
*
* DESCRIPTION:  Handles states of member variables related to advisory
*
* PARAMETER:    tU16 u16FunctionId
*
* RETURNVALUE:  void
*
* Author : vnd4kor ECV2 13.7.2015
*************************************************************************/
tVoid tun_MsgToHMI::vHandleAdvisoryMemberVariableStates(tU16 u16FunctionId)
{
	TUN_ASSERT_RETURN( m_poclConfigInterface != NULL);

	if(!m_poclConfigInterface->u32GetConfigData("HDSupported"))
	{
		return;
	}

	vClearAdvisoryStates();

	if( (enMsg_CM_ATPresetList_00 <= u16FunctionId) && (enMsg_CM_ATPresetList_31 >= u16FunctionId))
	{
		m_bPresetSelected = true;
	}
	else if( u16FunctionId != (tU16)enMsg_CM_StationsList)
	{
		m_bStationListElementSelected = true;
	}
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandleHDTuningActionVariableStates()
*
* DESCRIPTION:  Handles states of member variables related to HD tuning action
*
* PARAMETER:    tU16 u16FunctionId
*
* RETURNVALUE:  void
*
* Author : gds5kor ECO11 07.10.2016
*************************************************************************/
tVoid tun_MsgToHMI::vHandleHDTuningActionVariableStates(tU16 u16FunctionId)
{
	TUN_ASSERT_RETURN( m_poclConfigInterface != NULL);

	if(!m_poclConfigInterface->u32GetConfigData("HDSupported"))
	{
		return;
	}

	vStopHDAudioDecodingTimer();
	vClearHDTuningActionStates();

	ETG_TRACE_USR2(( " tun_MsgToHMI::vHandleHDTuningActionVariableStates() m_u8HDStationInfoBits - %02x", m_u8HDStationInfoBits ));
	if((m_u8HDStationInfoBits & TUN_ADVISORY_BITS_MASK) != TUN_ADVISORY_BITS_MASK)
	{
		ETG_TRACE_USR2(( " tun_MsgToHMI::vHandleHDTuningActionVariableStates() -> HD SIGNAL LOST " ));
		return;
	}

	if( (enMsg_CM_ATPresetList_00 <= u16FunctionId) && (enMsg_CM_ATPresetList_31 >= u16FunctionId))
	{
		m_bHDPresetSelected = true;
	}
	else if(u16FunctionId == (tU16)enMsg_CM_ATSeek)
	{
		m_bHDSeekSelected = true;
	}
	else if(u16FunctionId == (tU16)enMsg_CM_ATHDAudioProgram)
	{
		m_bHDAudioProgramSelected = true;
	}
	else if(u16FunctionId == (tU16)enMsg_CM_StationsList)
	{
		m_bHDStationListElementSelected = true;
	}
	else if(u16FunctionId == (tU16)enMsg_CM_ATHDAudioProgramDirect)
	{
		m_bHDAudioProgramDirectSelected = true;
	}
	/*added AT_Frequency message to start timer.
	* required to avoid to send advisory message "Loading", if it is tuned to SPS/MPS withing same frequency/StationId
	*/
	else if(u16FunctionId == (tU16)enMsg_ATFrequency)
	{
		m_bHDRotateEncoderSelected = true;
	}
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::bIsHDTuningActionSelected()
*
* DESCRIPTION:  Checks whether any HD tuning action is selected within the same service Id
*
* PARAMETER:    oAtStationInfoStatusMsg
*
* RETURNVALUE:  tBool
*
* Author : gds5kor ECO11 07.10.2016
*************************************************************************/
tBool tun_MsgToHMI::bIsHDTuningActionSelected(const tU32 u32AtStationInfoFrequency, const tU32 u32AtStationInfoHDStationId)
{
	tBool bSelected = false;
	if(m_bHDSeekSelected || m_bHDAudioProgramSelected || m_bHDStationListElementSelected || m_bHDPresetSelected || m_bHDAudioProgramDirectSelected || m_bHDRotateEncoderSelected)
	{
		//gds5kor: Check for invalid HD station ID (0)
		if ((m_u32HDFrequency == u32AtStationInfoFrequency) &&
			(m_u32StationInfoHDStationID == u32AtStationInfoHDStationId) && (u32AtStationInfoHDStationId != 0))
		{
			bSelected = true;
		}
		else
		{
			//Clear tuning action state if frequencies are different
			vClearHDTuningActionStates();
		}
	}
	ETG_TRACE_USR4(( " tun_MsgToHMI ::bIsHDTuningActionSelected bSelected = %d, m_u32HDFrequency = %u, m_u32StationInfoHDStationID = %u", bSelected, m_u32HDFrequency, m_u32StationInfoHDStationID));
	return bSelected;
}
#endif
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandleDemuteAction( )
*
* DESCRIPTION:  Handles Sending Demute action. 
* Made generic in order to be able to send demute action even when any 
* command fails without triggering TunerState status msg.(ex. deleted preset recall)
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  void
*
* Author : vnd4kor 26-3-2014
*************************************************************************/
tVoid tun_MsgToHMI::vHandleMuteDemuteAction()
{
	if((m_potun_MsgFromHMI == NULL) || (m_potun_MsgToADR == NULL))
	{
		NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT (m_potun_MsgToADR != NULL);
		return;
	}

	if(m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_next == None)
	{
		if((m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_curr == StationList) && (m_potun_MsgFromHMI->u8GetConfigListID() != 0xFF))
		{
			 ETG_TRACE_USR4(( " tun_MsgToHMI ::vHandleMuteDemuteAction , send Station list exit "));
			 m_potun_MsgToADR -> vSendStationListExit(m_potun_MsgFromHMI->u8GetConfigListID());
			 m_potun_MsgFromHMI->vSetConfigListID(0xFF);
		}
		ETG_TRACE_USR1(( " tun_MsgToHMI::vHandleMuteDemuteAction(), send DeMute request"));
		m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_curr = None;
		vSend_MuteDemuteReq(false,false);
	}
	else
	{
		ETG_TRACE_USR1(( " tun_MsgToHMI::vHandleMuteDemuteAction(), Perform next mute request"));
		m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_curr = m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_next;
		m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_next = None;
		vSend_MuteDemuteReq(false,true);
		m_potun_MsgFromHMI->vHandleMuteRequest(m_potun_MsgFromHMI->m_MuteHandlingRequest.enMuteAction_curr);
	}
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSend_MuteDemuteReq( )
*
* DESCRIPTION:
*
* PARAMETER:    tBool bMute , tBool bMute_Interrupt
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vSend_MuteDemuteReq(tBool bMute , tBool bMute_Interrupt)
{
	if((m_potun_MsgFromHMI == NULL) || (m_poHMINotTable == NULL))
	{
		NORMAL_M_ASSERT (m_potun_MsgFromHMI != NULL);
		NORMAL_M_ASSERT (m_poHMINotTable != NULL);
		return;
	}

	ahl_bEnterCritical( m_hNotHMITableSem );
    for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_MUTE_REQUEST) ; pNot != OSAL_NULL; pNot=pNot->pNext)
    {
      midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus oMuteRequestStatusMsg;

      oMuteRequestStatusMsg.bMute = bMute;
      oMuteRequestStatusMsg.u8Attenuation = 0;
      oMuteRequestStatusMsg.bMute_Interrupt = bMute_Interrupt;

      vSendMessage( pNot->u16AppID,
					 oMuteRequestStatusMsg,
					 MIDW_TUNERFI_C_U16_FID_TUN_G_MUTE_REQUEST,
					 AMT_C_U8_CCAMSG_OPCODE_STATUS,
					 pNot->u16CmdCounter,
					 pNot->u16RegisterID);
    }
    ahl_bReleaseCritical(m_hNotHMITableSem);
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_SpecialDiagnosis( )
*
* DESCRIPTION:  Handles response CM_SpecialDiagnosis from ADR
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_SpecialDiagnosis( const tU8* pu8Message )
{
	//Added to remove lint warning.
  
  // Check the validity of incoming data
    if (pu8Message == NULL)
    {
	   NORMAL_M_ASSERT (pu8Message != NULL);
       return;
    }

	if(m_poHMINotTable == NULL)
	{
		NORMAL_M_ASSERT (m_poHMINotTable != NULL);
		return;
	}

    for(ahl_tNotification* pNot =
                m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_MEASUREMODE) ;
           pNot != OSAL_NULL;
           pNot=pNot->pNext
          )
      {
          
          midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/            
          oStatusMsg.u8Measuremode = pu8Message[enCM_SpecialDiagnosisMode_idx_Mode];

          oStatusMsg.e8PhysicalTunerId.enType = \
			  (midw_fi_tcl_e8_Tun_PhysicalTuner::tenType)pu8Message[enCM_SpecialDiagnosisMode_idx_PhysicalTunerId];


		  ETG_TRACE_USR1((" tun_MsgToHMI::vHandle_r_SpecialDiagnosis u8Measuremode = %d, e8PhysicalTunerId = %d "\
			  , oStatusMsg.u8Measuremode, \
			  ETG_CENUM( tenPhysicalTunerId,    pu8Message[enCM_SpecialDiagnosisMode_idx_PhysicalTunerId])));

    
		  vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_SET_MEASUREMODE,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );


      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */
      

		midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult oADRResponse;
		oADRResponse.u8_PhysicalTuner.enType = \
			(midw_fi_tcl_e8_Tun_PhysicalTuner::tenType)pu8Message[enCM_SpecialDiagnosisMode_idx_PhysicalTunerId];//Physical Tuner ID
				
		ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAG_MGR,
                               ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_S_ACTIVE_TUNER _\
                               ET_EN_T8 _ oADRResponse.u8_PhysicalTuner.enType _\
                               ET_EN_DONE );
		
		
		//------------------------------
        // Send the response to diagnosis
        //------------------------------
		
		tU16 u16CommandCntr = u16GetTunerMasterCommandCntrForActiveTuner();
		tU16 u16RegID = u16GetTunerMasterRegID();
        vSendMessage( CCA_C_U16_APP_TUNERMASTER,
                      oADRResponse,
                      MIDW_TUNERFI_C_U16_FID_TUN_S_ACTIVE_TUNER,
                      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                      u16CommandCntr,
                      u16RegID 
                    );
    
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_SystemPresets( )
*
* DESCRIPTION:  Handles response CM_SystemPresets from ADR
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_SystemPresets( const tU8* pu8Message, tU32 u32MessageLen )
{
	if( pu8Message == NULL  || u32MessageLen == 0 || m_poHMINotTable == NULL ||
	m_potun_Utility == NULL || m_potun_HMIManager == NULL || m_potun_Config == NULL || m_poclConfigInterface == NULL)
    {
        NORMAL_M_ASSERT( pu8Message != NULL );
		NORMAL_M_ASSERT( u32MessageLen != 0 );
		NORMAL_M_ASSERT( m_poHMINotTable != NULL );
		NORMAL_M_ASSERT( m_potun_Utility != NULL );
		NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
		NORMAL_M_ASSERT( m_potun_Config != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}

    ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_SystemPresets()"));

	if(!m_poclConfigInterface->u32GetConfigData("PresetListType"))
	{
		    bSystemPresets = true;
	

    tU16 u16ADRListID = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Message[enAdrMsgOffset_DATA]);

	u8SystemPresets_Band = oGetADR3ToMidwTunerBand(u16ADRListID);

	vUpdatePresetListID_DP(u16ADRListID);

	}
   
	ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_SystemPresets() : band = %d", u8SystemPresets_Band));

}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_ATSeek( )
*
* DESCRIPTION:  Handles response CM_ATSeek from ADR
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_ATSeek( const tU8* pu8Message, tU32 u32MessageLen )
{
    if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL)||
       (u32MessageLen == 0) ||( m_poHMINotTable == NULL )
      )
   {
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( u32MessageLen != 0 );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );

     return;
   }
	
	ahl_bEnterCritical( m_hNotHMITableSem );

       for(ahl_tNotification* pNot =
                m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK) ;
           pNot != OSAL_NULL;
           pNot=pNot->pNext
          )
      {
          
          midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/            
          oStatusMsg.e8SeekState.enType = (midw_fi_tcl_e8_Tun_TunerSeek::tenType)pu8Message[10];

         
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,
                             ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK _\
                             ET_EN_DONE);
   
         /* ---
         send it to the client 
         --- */

		 if(oStatusMsg.e8SeekState.enType <= \
			 midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_SCAN_SORTED_PS)
		 {
           vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_ATSEEK,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );
		ETG_TRACE_USR1(( " tun_MsgToHMI::vHandle_r_ATSeek() -> Status sent to HMI" ));
		 }

      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */
      
      ahl_bReleaseCritical(m_hNotHMITableSem);
	  
	m_u8SeekState = pu8Message[10];
	ETG_TRACE_USR1(( " tun_MsgToHMI::vHandle_r_ATSeek() -> SeekState = %d", m_u8SeekState));
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI:: u8GetSeekMode( )
* 
* DESCRIPTION:  Returns the current seek mode
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU8 SeekMode
*
*************************************************************************/
tU8 tun_MsgToHMI::u8GetSeekMode()
{
	ETG_TRACE_USR1((  " tun_MsgToHMI::u8GetSeekMode(),SeekMode=%d"
                     ,m_u8SeekState
                  ));
				  
	return m_u8SeekState;
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Set_AFBestSwitch( )
* 
* DESCRIPTION:  Radio unit response ( TUN_R_SET_HICUT ) giving Hicut values.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Set_AFBestSwitch( const tU8* pu8Message)
{
    if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL)||
       ( m_poHMINotTable == NULL )
      )
   {
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
     return;
   }

    /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */ 
    /*--------------------------------------------------------*/
  //  if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
    {
      ahl_bEnterCritical( m_hNotHMITableSem );

       for(ahl_tNotification* pNot =
                m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF) ;
           pNot != OSAL_NULL;
           pNot=pNot->pNext
          )
      {
          
          midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/  
          
          oStatusMsg.u8AF = pu8Message[10];//AFBestSwitch Value

         
          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,
                             ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF _\
                             ET_EN_T8 _ 0x01 _\
                             ET_EN_T8 _ (oStatusMsg.u8AF) _\
                             ET_EN_DONE);
   
         /* ---
         send it to the client 
         --- */

           vSendMessage ( pNot->u16AppID,
                          oStatusMsg,
                          MIDW_TUNERFI_C_U16_FID_TUN_G_SET_AF,
                          AMT_C_U8_CCAMSG_OPCODE_STATUS,
                          pNot->u16CmdCounter,
                          pNot->u16RegisterID );

      } /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */
      
      ahl_bReleaseCritical(m_hNotHMITableSem);

    } /*End of if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) ) */

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_AfList( )
* 
* DESCRIPTION:  Radio unit response ( TUN_R_GET_DATA_AFLIST_V2 ) giving length of AF list.
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_AfList( const tU8* pu8Message )
{
	TUN_ASSERT_RETURN( pu8Message      != NULL);
	TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
	TUN_ASSERT_RETURN( m_potun_Utility != NULL);

	ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_AfList()"));	

	if( pu8Message[ enAdrMsgOffset_OP_TYPE] == (tU8)enOpType_STATUS)
	{

		ahl_bEnterCritical( m_hNotHMITableSem );

		for(ahl_tNotification* pNot=
			m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_AFLIST_V2) ;
			pNot != OSAL_NULL; pNot=pNot->pNext
			)
		{
			midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status oStatusMsg;

			/*------------------------*/
			/* Fill in the message    */
			/*------------------------*/  

			/* LengthofAflist u8LengthOfAFList = number of AF list elements */
			oStatusMsg.u8LengthOfAFList = pu8Message[ enCM_ATAfList_idx_NumberOfAfs];

			ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_AfList(),u8LengthOfAFList =%d ",
                     oStatusMsg.u8LengthOfAFList));

			midw_fi_tcl_TunerAFList oTunerAFListElement;

			for( tUInt u8AFListElementID = 0, u8AFListElementOffset = (tU8)enCM_ATAfList_idx_ListData; 
				u8AFListElementID < pu8Message[ enCM_ATAfList_idx_NumberOfAfs];
				u8AFListElementID++, u8AFListElementOffset += (tU8)enCM_ATAfList_len_ListElement
				)
			{
				oTunerAFListElement.u8TunerHeader.enType = 
					(midw_fi_tcl_e8_Tun_TunerHeader::tenType)pu8Message[ \
					enAdrMsgOffset_INSTANCE_ID ];

				/* u8AFListElementID */
				oTunerAFListElement.u8AFListElementID = (tU8)(u8AFListElementID);

				/* u32AFFrequency */
				oTunerAFListElement.u32AFFrequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit\
					( &pu8Message[ (tU8)enCM_ATAfList_idx_Frequency + u8AFListElementOffset]) ;

				/* u16AFPI */
				oTunerAFListElement.u16AFPI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( \
					&pu8Message[ (tU8)enCM_ATAfList_idx_PI + u8AFListElementOffset] );

				/* u8AFQualityLevel */
				oTunerAFListElement.u8AFQualityLevel = pu8Message[ (tU8)enCM_ATAfList_idx_QualityLevel\
					+ u8AFListElementOffset];

				/* u8FieldStrength */
				oTunerAFListElement.u8AFFieldStrength = pu8Message[ (tU8)enCM_ATAfList_idx_FieldStrength \
					+ u8AFListElementOffset];

				/* u8AFBitErrorRate */
				oTunerAFListElement.u8AFBitErrorRate = pu8Message[ (tU8)enCM_ATAfList_idx_BitErrorRate \
					+ u8AFListElementOffset];

	

				/* u8AFInformation */
				oTunerAFListElement.u8AFInfo.enType = 
					(midw_fi_tcl_e8_Tun_AFInformation::tenType)pu8Message[ (tU8)enCM_ATAfList_idx_AfInfo \
					+ u8AFListElementOffset];

				oStatusMsg.TunerAFList.push_back(oTunerAFListElement);

				ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_AfList(),u8TunerHeader =%d, \
								  u8AFListElementID =%d, u32AFFrequency =%d, u16AFPI =0x%02x, \
								  u8AFQualityLevel =%d, u8FieldStrength =%d, u8AFBitErrorRate =%d, \
								  u8AFInformationBits =%d ",
                     oTunerAFListElement.u8TunerHeader.enType,
					 oTunerAFListElement.u8AFListElementID,
					 oTunerAFListElement.u32AFFrequency,
					 oTunerAFListElement.u16AFPI,
					 oTunerAFListElement.u8AFQualityLevel,
					 oTunerAFListElement.u8AFFieldStrength,
					 oTunerAFListElement.u8AFBitErrorRate,
					 oTunerAFListElement.u8AFInfo.enType
                  ));

			}//End of for loop



			ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
				ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_AFLIST_V2 _\
				ET_EN_T8 _ 0x01 _\
				ET_EN_T8 _ oStatusMsg.u8LengthOfAFList _\
				ET_EN_DONE);

			/*-------------------------------*/
			/* Post message to HMI component */
			/*-------------------------------*/

			vSendMessage ( pNot->u16AppID,
				oStatusMsg,
				MIDW_TUNERFI_C_U16_FID_TUN_G_AFLIST_V2,
				AMT_C_U8_CCAMSG_OPCODE_STATUS,
				pNot->u16CmdCounter,
				pNot->u16RegisterID );


		} /*End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
		  pNot != OSAL_NULL; pNot=pNot->pNext) */


		ahl_bReleaseCritical(m_hNotHMITableSem);

	} /* if( pu8Message[ enAdrMsgOffset_OP_TYPE] == enOpType_STATUS) */
}





/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Autostore
*
* DESCRIPTION:  Handle FID_TUN_S_AUTOSTORE response from Radio Unit.
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void
*
* History
* 9/3/2013  |  Initial version  | ngp1kor, pmn3kor
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Autostore(const tU8 *pu8Message)
{
    ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_Autostore"));
    if((poGWMain == NULL)||(m_potun_Utility == NULL)||
            (m_potun_Config == NULL)||(pu8Message == NULL)
			|| (m_potun_MsgToADR == NULL)
			)
   {
      NORMAL_M_ASSERT( poGWMain != NULL );
      NORMAL_M_ASSERT( m_potun_Utility != NULL );
      NORMAL_M_ASSERT( m_potun_Config != NULL );
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );
	  NORMAL_M_ASSERT(pu8Message != NULL);
      return;
   }


       if( pu8Message[ enAdrMsgOffset_OP_TYPE] == (tU8)enOpType_RESULT )
       {
           ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_Autostore -> enOpType_RESULT"));
           /**check the parameters of optype "result" of autostore*/
           tU16 u16FunctionIdOfList = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Message[enAdrMsgOffset_DATA]);
           tU8 u8NumberOfFoundStations = pu8Message[(tU8)enAdrMsgOffset_DATA+2];
           /**map to HMI ListID by giving ADR ListID*/

           tU8 u8ListId = 0;
           u8ListId = (tU8)oGetADR3ToMidwTunerPresetListID(u16FunctionIdOfList);
           ETG_TRACE_USR4(("FunctionIdOfList is %u", u16FunctionIdOfList));
           ETG_TRACE_USR4(("u8ListId is %u", u8ListId));
           ETG_TRACE_USR4(("NumberOfFoundStations for autostore is %u",u8NumberOfFoundStations));

           ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_Autostore -> post method result"));

		   /** Wait until Preset list is updated , then send the method result. 
		   This variable is accessed in vHandle_r_CM_AtPresetList() and autostore method result is sent if true**/

		   if(0 == u8NumberOfFoundStations)
		   {
			   /** Since No of stations found is 0, no need for preset list update.
			   Send method result immediately*/

			   /** Send success method result */
			   vSendAutostoreMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL,\
			   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

		   }
		   else
		   {
			   m_bSendAutostoreMthdResult = true;

				/** Get Preset List to update the client */
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
			   m_poclAars_ATPresetList_XX->vGetPresetList(u16FunctionIdOfList);
#else
				m_potun_MsgToADR ->vGetPresetList(u16FunctionIdOfList);
#endif

		   }
		   
       }//if( (pu8Message != NULL) && ( pu8Message[ enAdrMsgOffset_OP_TYPE] == enOpType_RESULT) )
       else
       {

           ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_Autostore -> ERROR"));
           tU8 u8ErrorCode = pu8Message[enAdrMsgOffset_DATA];
           ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_Autostore ->errorcode %u", u8ErrorCode));

           ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_Autostore -> post method error"));

		   /** Send error method result */
		   vSendAutostoreMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL,\
			   AMT_C_U8_CCAMSG_OPCODE_ERROR);
 

       }/**else (pu8Message != NULL) 
            && ( pu8Message[ enAdrMsgOffset_OP_TYPE] == enOpType_RESULT)*/






}/**vHandle_r_Autostore*/

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_TMC_MonitoredStations_Update( )
*
* DESCRIPTION:
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_TMC_MonitoredStations_Update( const tU8* pu8Message, tU32 u32MessageLen)
{

  tU8 u8ListLength;  /* unused parameter */

  TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
  TUN_ASSERT_RETURN( u32MessageLen   != 0);
  TUN_ASSERT_RETURN( m_potun_Utility != NULL);

  for(ahl_tNotification* pNot =
         m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_RDBIDACTUALLIST) ;
       pNot != OSAL_NULL; pNot=pNot->pNext
     )
  {
      midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus oStatusMsg;

	  u8ListLength = ((tU8)(m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enAdrMsgOffset_DATA_LEN] )))/7;
     /*------------------------*/
     /* Fill in the message    */
     /*------------------------*/
      tU8 u8Data = (tU8)enAdrMsgOffset_DATA;
	   midw_fi_tcl_TunerRdbId oRDBID_List;
	  /** Vnd4kor: Changed index to indexRdbId to avoid lint warnings*/
      for(tU8 indexRdbId = 0; indexRdbId < u8ListLength ; indexRdbId++ )
      {
		oRDBID_List.TMCCountryCode = pu8Message[u8Data++];
		oRDBID_List.TableNo        = pu8Message[u8Data++];
		u8Data=(tU8)(u8Data+3);
		oRDBID_List.ServiceID      = pu8Message[u8Data++];
		oRDBID_List.Encrypted      = pu8Message[u8Data++];
		 
		oStatusMsg.ListOfRdbIds.push_back(oRDBID_List);

		ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_TMC_MonitoredStations_Update(), "
								"u8ListLength=%d bytes"
								"CC = %d, "
								"LTN = %d,"
								"SID= %d, "
								"Enc = %d, "
		                        ,u8ListLength
								, oRDBID_List.TMCCountryCode
								, oRDBID_List.TableNo
								, oRDBID_List.ServiceID
								, oRDBID_List.Encrypted
		                       ));
      }


      /*-------------------------------*/
      /* Post message to HMI component */
      /*-------------------------------*/

      vSendMessage ( pNot->u16AppID,
                      oStatusMsg,
                      MIDW_TUNERFI_C_U16_FID_TUN_G_RDBIDACTUALLIST,
                      AMT_C_U8_CCAMSG_OPCODE_STATUS,
                      pNot->u16CmdCounter,
                      pNot->u16RegisterID );

  } /*End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
           pNot != OSAL_NULL; pNot=pNot->pNext) */
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_TMC_Buffered_TrafficInfos( )
*
* DESCRIPTION:
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_TMC_Buffered_TrafficInfos( const tU8* pu8Message)
{

	  tU8 u8ListLength;  /* unused parameter */

	  TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
	  TUN_ASSERT_RETURN( pu8Message      != NULL);
	  TUN_ASSERT_RETURN( m_potun_HMIManager   != NULL);
	  TUN_ASSERT_RETURN( m_potun_Utility != NULL);

	  tU8 u8DataIndex = enAdrMsgOffset_8AMessage_Start_Index;

	  for(ahl_tNotification* pNot =
	         m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TMC) ;
	       pNot != OSAL_NULL; pNot=pNot->pNext
	     )
	  {
	      midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus oStatusMsg;

	      midw_fi_tcl_TrafficInfo oTrafficInfo;

	     /*------------------------*/
	     /* Fill in the message    */
	     /*------------------------*/
	      tU8 u8Data = enAdrMsgOffset_DATA;
	      u8ListLength = pu8Message[u8Data+enAdrMsgOffset_NoOf8AMessages_index];

	      ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_TMC_Buffered_TrafficInfos(), u8ListLength=%d bytes"
	                          ,u8ListLength
	                       ));


	     for(tU8 u8index = 0; u8index < u8ListLength ; u8index++ )
	      {
	    			  oTrafficInfo.RDBId.TMCCountryCode       = pu8Message[u8Data++];
	    			  oTrafficInfo.RDBId.TableNo              = pu8Message[u8Data++];
	    			  oTrafficInfo.RDBId.ServiceID            = pu8Message[u8Data++];
	    			  oTrafficInfo.RDBId.Encrypted            = pu8Message[u8Data++];
	    			  oTrafficInfo.ECC                  = pu8Message[u8Data++];
	    			  oTrafficInfo.ApplicationId.enType        = (midw_fi_tcl_e16_TmcApplicationId::tenType)m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Message[u8Data]);
					  u8Data = (tU8)(u8Data+2);
					  oTrafficInfo.ProgramID            = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Message[u8Data]);
					  u8Data = (tU8)(u8Data+2);
					  oTrafficInfo.Encryption.Encrypted           = pu8Message[u8Data++];
					  oTrafficInfo.Encryption.Encid               = pu8Message[u8Data++];
					  oTrafficInfo.Encryption.TestBits            = pu8Message[u8Data++];
					  oTrafficInfo.MsgSource.MediumTypeId.enType         = (midw_fi_tcl_e8_TmcMediumType::tenType)pu8Message[u8Data++];
					  oTrafficInfo.MsgSource.Number               = pu8Message[u8Data];
					  u8Data = (tU8)(u8Data +9);

			ETG_TRACE_USR2(( " TMCCountryCode = %d  TableNo = %d ServiceID = %d Encrypted = %d  ECC = %d ApplicationId = %d ProgramID = %d"
					, oTrafficInfo.RDBId.TMCCountryCode
					, oTrafficInfo.RDBId.TableNo
					, oTrafficInfo.RDBId.ServiceID
					, oTrafficInfo.RDBId.Encrypted
					, oTrafficInfo.ECC
					, oTrafficInfo.ApplicationId.enType
					, oTrafficInfo.ProgramID
					));

			ETG_TRACE_USR2(( " Encrypted =%d Encid = %d TestBits = %d MediumTypeId = %d Number = %d"
					, oTrafficInfo.Encryption.Encrypted
					, oTrafficInfo.Encryption.Encid
					, oTrafficInfo.Encryption.TestBits
					, oTrafficInfo.MsgSource.MediumTypeId.enType
					, oTrafficInfo.MsgSource.Number
					));

					midw_fi_tclString sUtf8String ;
					m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[u8Data],&sUtf8String) ;
					oTrafficInfo.ProgramServiceName.bSet( sUtf8String ,
						midw_fi_tclString::FI_EN_UTF8);



					u8Data = (tU8)(u8Data+16);
					m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[u8Data],&sUtf8String) ;
					oTrafficInfo.ServiceProviderName.bSet( sUtf8String ,
						midw_fi_tclString::FI_EN_UTF8);

	   	    	   ETG_TRACE_USR2((" 8ADataByte1 = %d",pu8Message[u8DataIndex]));

	    	       oTrafficInfo.ListOf8AData.push_back(pu8Message[u8DataIndex++]);

	   	    	   ETG_TRACE_USR2((" 8ADataByte2 = %d",pu8Message[u8DataIndex]));

	    	       oTrafficInfo.ListOf8AData.push_back(pu8Message[u8DataIndex++]);

	   	    	   ETG_TRACE_USR2((" 8ADataByte3 = %d",pu8Message[u8DataIndex]));

	    	       oTrafficInfo.ListOf8AData.push_back(pu8Message[u8DataIndex++]);

	   	    	   ETG_TRACE_USR2((" 8ADataByte4 = %d",pu8Message[u8DataIndex]));

	    	       oTrafficInfo.ListOf8AData.push_back(pu8Message[u8DataIndex++]);

	   	    	   ETG_TRACE_USR2((" 8ADataByte5 = %d",pu8Message[u8DataIndex]));

	    	       oTrafficInfo.ListOf8AData.push_back(pu8Message[u8DataIndex++]);

	    	       oStatusMsg.ListOfTrafficInfo.push_back(oTrafficInfo);

	    	      oTrafficInfo.ListOf8AData.clear();

	      	       u8Data = enAdrMsgOffset_DATA;//reset to start of data

	      }



	      /*-------------------------------*/
	      /* Post message to HMI component */
	      /*-------------------------------*/

	      vSendMessage ( pNot->u16AppID,
	                      oStatusMsg,
	                      MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TMC,
	                      AMT_C_U8_CCAMSG_OPCODE_STATUS,
	                      pNot->u16CmdCounter,
	                      pNot->u16RegisterID );

	  } /*End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
	           pNot != OSAL_NULL; pNot=pNot->pNext) */
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_TMCStationsCount( )
*
* DESCRIPTION:
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_TMCStationsCount( const tU8* pu8Message )
{

    tU8 u8ListLength;

	TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
	TUN_ASSERT_RETURN( m_potun_HMIManager   != NULL);
	TUN_ASSERT_RETURN( m_potun_Utility   != NULL);
	
	u8ListLength = pu8Message[(tU8)enAdrMsgOffset_DATA+2];
	
	midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult oResponse;

    // Response -> SUCC / FAIL / BUSY
    oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
    			midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;

    // Current Tuner state -> Not required for client. NORAL added as default.
    oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
    			midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
											
	oResponse.TunMakeConfigListElem.e8ListID.enType = (midw_fi_tcl_e8_Tun_ConfigListID::tenType)enCM_StationListConfigListID_TMC;
	oResponse.TunMakeConfigListElem.u8NumOfElementsInList = u8ListLength;


	 //------------------------------
     // Send the response to clients.
     //------------------------------

	vSendMessage( m_u16UIAppID,
				   oResponse,
				   MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST,
				   AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
				   m_u16StationListCommandCtr,
				   m_u16UIRegID
				 );
}	


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_TMCStations( )
*
* DESCRIPTION:
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_TMCStations( const tU8* pu8Message )
{

  TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
  TUN_ASSERT_RETURN( m_potun_HMIManager   != NULL);
  TUN_ASSERT_RETURN( m_potun_Utility   != NULL);
  TUN_ASSERT_RETURN( pu8Message      != NULL);

  ahl_bEnterCritical( m_hNotHMITableSem );
  
  for(ahl_tNotification* pNot =
         m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST) ;
       pNot != OSAL_NULL; pNot=pNot->pNext
     )
  {
	  	ETG_TRACE_USR2((" vHandle_r_TMCStations :-> "));
	    tU8 u8PosX = pu8Message[ enCM_TMCStations_idx_PosX];
	    tU8 u8PosY = pu8Message[ enCM_TMCStations_idx_PosY];

		midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus oTMCListStatusMsg;

	    if( (u8PosX == 0) && (u8PosY == 0))
	    {
		  /** object to hold single list element*/
		  midw_fi_tcl_TunerConfigListElement TunTMCListElement;
		  tU8 u8ListLength = pu8Message[ enCM_TMCStations_idx_StationsInList];
	      tU16 unElementIndex = (tU16)enCM_TMCStations_idx_Data;

		  ETG_TRACE_USR2((" Number of elements in list : %d ",u8ListLength));
	      for( tU8 u8Index = 0; u8Index < u8ListLength; u8Index++)
	      {
	         vCreateTMCListElement(u8Index, &pu8Message[ unElementIndex] , &TunTMCListElement);

	    	 oTMCListStatusMsg.Tun_ConfigListElements.TunerConfigListElement.push_back(TunTMCListElement);
	    	 unElementIndex = (tU16)(unElementIndex + (tU16)enCM_TMCStations_len_Data);
	      }

	      vSendMessage ( pNot->u16AppID,
	    		     oTMCListStatusMsg,
	                 MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST,
	                 AMT_C_U8_CCAMSG_OPCODE_STATUS,
	                 pNot->u16CmdCounter,
	                 pNot->u16RegisterID );
	    }
  }
  ahl_bReleaseCritical(m_hNotHMITableSem);
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_TMCSelctionFilter( )
*
* DESCRIPTION:
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_TMCSelctionFilter( const tU8* pu8Message)
{
	/** NULL pointer check */
	if((pu8Message == NULL) || (m_potun_Utility == NULL))
	{
		NORMAL_M_ASSERT( pu8Message != NULL );
		NORMAL_M_ASSERT( m_potun_Utility != NULL );
		
		return;
	}

	/** Create status msg */
	midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult oRDBIDResponse;

	midw_fi_tcl_Tun_RDBID_Value oRDBID;

	 tU8 u8Length = (tU8)(m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enAdrMsgOffset_DATA_LEN] ));
//	tU8 u8Length = pu8Message[enAdrMsgOffset_DATA_LEN];
	tU8 u8ListLength = (tU8)( (u8Length - 2)/8);

	ETG_TRACE_COMP(( " tun_MsgToHMI::vHandle_r_TMCSelctionFilter() --- DataLen = %d , \
					 Listlength = %d ", u8Length, u8ListLength));

	     /*------------------------*/
	     /* Fill in the message    */
	     /*------------------------*/
	      tU8 u8Data = (tU8)enAdrMsgOffset_DATA+2;
		  /** Vnd4kor: Changed index to u8index to avoid lint warnings*/
  	      for(tU8 u8index = 0; u8index < u8ListLength ; u8index++ )
	      {
		/** MASK */
	      u8Data = (tU8)(u8Data + TMC_SELECTIONFILTER_MASK_SIZE);
		  /** CC - Country Code */
	      oRDBID.u8RdbidCC = pu8Message[u8Data++];
		  /** LTN - Location Table Number */
	      oRDBID.u8RdbidLTN        = pu8Message[u8Data++];
		  /** SID - Service Identifier */
	      oRDBID.u8RdbidSID      = pu8Message[u8Data++];
		  /** MGS- Message Group Service */
		  u8Data = (tU8)(u8Data + TMC_SELECTIONFILTER_MGS);
		  /** BSA - Broadcast Service Areas */
		  u8Data = (tU8)(u8Data + TMC_SELECTIONFILTER_BSA);
	      /** ENC - Encryption flag */
	      oRDBID.bEncFlag      = pu8Message[u8Data++];
	      oRDBIDResponse.TunRDBID_Value.push_back(oRDBID);
	      }


	      vSendMessage( CCA_C_U16_APP_FC_TPEG,
	    		  oRDBIDResponse,
	              MIDW_TUNERFI_C_U16_FID_TUN_S_SET_RDBID,
	              AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
	              u16GetTPEGCommandCntrForSetRdbid(),
	              u16GetTPEGRegIDForSetRdbid()
	              );



}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_OperationAvailability( )
* 
* DESCRIPTION:  Radio unit response ( TUN_R_OPERATION ) giving operation enabled/disabled.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
  tVoid tun_MsgToHMI::vHandle_r_OperationAvailability( const tU8* /*pu8Message*/, tU32 /*u32MessageLen */)
{
#if 0
    if(( m_potun_HMIManager == NULL) ||(pu8Message == NULL) ||
       (u32MessageLen == 0) ||( m_poHMINotTable == NULL )
      )
   {
      if( m_potun_HMIManager == NULL )
      {
        NORMAL_M_ASSERT( m_potun_HMIManager != NULL );

      } 

      if( pu8Message == NULL )
      {
        NORMAL_M_ASSERT( pu8Message != NULL );

      }
      if( u32MessageLen == 0 )
      {
        NORMAL_M_ASSERT( u32MessageLen != 0 );

      }

      if( m_poHMINotTable == NULL )
      {
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );

      }
     return;
   }


    /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */ 
    /*--------------------------------------------------------*/
    //if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
    {
      ahl_bEnterCritical( m_hNotHMITableSem );

      for( ahl_tNotification* pNot =
              m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_OPERATION) ;
           pNot != OSAL_NULL; pNot=pNot->pNext
         )
      {
          midw_tunerfi_tclMsgFID_TUN_G_OPERATIONStatus oStatusMsg;

         /*------------------------*/
         /* Fill in the message    */
         /*------------------------*/  
          
          oStatusMsg.b8OperationFlags.u8Value = pu8Message[2];

          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                             ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_OPERATION _\
                             ET_EN_T8 _ 0x01 _\
                             ET_EN_T8 _ oStatusMsg.b8OperationFlags.u8Value _\
                             ET_EN_DONE);

          /*-------------------------------*/
          /* Post message to HMI component */
          /*-------------------------------*/

          vSendMessage ( pNot->u16AppID,
                         oStatusMsg,
                         MIDW_TUNERFI_C_U16_FID_TUN_G_OPERATION,
                         AMT_C_U8_CCAMSG_OPCODE_STATUS,
                         pNot->u16CmdCounter,
                         pNot->u16RegisterID );

      } /*End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
            pNot != OSAL_NULL; pNot=pNot->pNext) */
      
      ahl_bReleaseCritical(m_hNotHMITableSem);

    } /*End of if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) ) */
#endif 
}




/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_MakeConfigList( )
* 
* DESCRIPTION:  Handle TUN_R_MAKE_CONFIG_LIST response from Radio Unit.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
* History:
* 29/8/2013 vnd4kor (ECG)
* Removed unused parameter msgLength
*************************************************************************/
tVoid tun_MsgToHMI :: vHandle_r_GetConfigList( const tU8* pu8Message)
{
	if(( pu8Message == NULL)||\
		( m_potun_Utility == NULL)||\
		( m_potun_MsgToADR == NULL)
	)
	{
		TUN_ASSERT_RETURN( pu8Message      != NULL);
		TUN_ASSERT_RETURN( m_potun_Utility != NULL);
		TUN_ASSERT_RETURN( m_potun_MsgToADR != NULL);
  		return;
	}
  
  midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult oResponse;

        // Current Tuner state -> Not required for client. NORAL added as default.
        oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
                          midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

        // Response -> SUCC / FAIL / BUSY
        oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
                          midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
		
		oResponse.TunMakeConfigListElem.e8ListID.enType = (midw_fi_tcl_e8_Tun_ConfigListID::tenType)pu8Message[ enCM_StationListConfig_idx_ListId];
		oResponse.TunMakeConfigListElem.u8NumOfElementsInList = (tU8)m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enCM_StationListConfig_idx_NumberOfStations] );
		
		 m_potun_MsgToADR ->vSendGetConfigList( (tU8)oResponse.TunMakeConfigListElem.e8ListID.enType, 0, 0 );

		
		vSendMessage( m_u16UIAppID,
                      oResponse,
                      MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST,
                      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                      m_u16StationListCommandCtr,
                      m_u16UIRegID
                    );				  
}



#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
/*************************************************************************
* 
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_StationsList( )
* 
* DESCRIPTION:  Handle CM_StationsList from ADR3.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_StationsList(tU8* pu8Message )
{
  TUN_ASSERT_RETURN( m_potun_Utility != NULL);
  TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
  
  ahl_bEnterCritical( m_hNotHMITableSem );

  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST) ; 
        pNot != OSAL_NULL; pNot=pNot->pNext)
  {


    tU8 u8PosX = pu8Message[ enCM_StationsList_idx_PosX];
    tU8 u8PosY = pu8Message[ enCM_StationsList_idx_PosY];
    tU16 u16Payload = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enAdrMsgOffset_DATA_LEN] );
    tU8 u8ListId = pu8Message[ u16Payload + (tU8)enAdrMsgOffset_HEADER_LEN - 1];


    ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_CM_StationsList(), u16Payload=%d bytes, Pos={%d,%d}, ListId=%d"
                     ,u16Payload
                     ,u8PosX, u8PosY
                     ,u8ListId
                  ));

	midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus oConfigListStatusMsg;

	oConfigListStatusMsg.e8ConfigListID.enType = (midw_fi_tcl_e8_Tun_ConfigListID::tenType) u8ListId;


    if( (u8PosX == 0) && (u8PosY == 0))
    {
      tU16 unElement = 0;
	
	  /** object to hold single list element*/
	  midw_fi_tcl_TunerConfigListElement TunConfigListElement;


      for( tU16 unElementIndex = (tU16)enCM_StationsList_idx_Data; unElementIndex < (u16Payload - (tU16)enCM_StationsList_len_Pos - (tU16)enCM_StationsList_len_ListId); /*unElementIndex += (tU16)enCM_StationsList_len_Data*/)
      {

		/** Logging the data of each element in list*/
        ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_CM_StationsList()Part 1 ->,\
						  Element=%d, unElementIndex=%d, Selected = %d, u8ModulationType = %d, u32Freq=%d kHz, sPSName_HDCallSign_DRMSrvLabel= %d "
                         ,unElement
                         ,unElementIndex
						 ,pu8Message[ (tU16)enCM_StationsList_idx_Selected + unElementIndex]
						 ,pu8Message[ (tU16)enCM_StationsList_idx_ModulationType + unElementIndex]
                         ,m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ (tU16)enCM_StationsList_idx_Frequency + unElementIndex] )
                         ,pu8Message[ (tU16)enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_size + unElementIndex]
                      ));
					  
        ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_CM_StationsList()Part 2 ->,\
						  sPSName_HDCallSign_DRMSrvLabel=%s"
                         ,(tChar*)&pu8Message[ (tU16)enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data + unElementIndex]
		));
					  
		
		tU8 u8OffsetAfterSendername = (tU8)(unElementIndex + \
						  enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data + \
						  pu8Message[ (tU16)enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_size + unElementIndex]);
		
        ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_CM_StationsList() Part 3 ->\n,\
						  SendernameInfo=%d,u8PTY_HDPTY_DRMPty = %d, u32PI_HDStnId_DRMSrvId = 0x%08X, StationInfo=0x%02X, ReceptionQuality=0x%02X,\n\
						  TMC=0x%02x, PresetListForAcmp=0x%04X, PresetAcmp=0x%04X,s8LevelCompensation = %d"
                         ,ETG_CENUM( tenCM_StationsListSendernameInfo, pu8Message[ (tU16)enCM_StationsList_offset_SendernameInfo + u8OffsetAfterSendername])
                          ,pu8Message[ (tU16)enCM_StationsList_offset_PTY_HDStationGenre_DRMPty + u8OffsetAfterSendername]
                          ,m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ (tU16)enCM_StationsList_offset_PI_HDStationId_DRMServiceID + u8OffsetAfterSendername])
                          ,pu8Message[ (tU16)enCM_StationsList_offset_StationInfo  + u8OffsetAfterSendername] 
                          ,pu8Message[ (tU16)enCM_StationsList_offset_ReceptionQuality + u8OffsetAfterSendername]
                          ,ETG_CENUM( tenCM_StationsListTMC, pu8Message[ (tU16)enCM_StationsList_offset_TMC + u8OffsetAfterSendername] )
                          ,m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ (tU16)enCM_StationsList_offset_PresetListForAcmp + u8OffsetAfterSendername] )
                          ,pu8Message[ (tU16)enCM_StationsList_offset_PresetAcmp + u8OffsetAfterSendername]
						  ,(tS8)pu8Message[(tU16)enCM_StationsList_offset_LevelComp + u8OffsetAfterSendername]
                      ));

        ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_CM_StationsList() Part 4 ->\n,\
						  e8HDTextEncoding = %d,u8HDNumberOfAudioPrograms = %d"
                          ,pu8Message[ (tU16)enCM_StationsList_offset_HDTextEncoding + u8OffsetAfterSendername]
                          //PTY=%d, ,pu8Message[ (tU16)enCM_StationsList_idx_PTY + unElementIndex]
                          ,pu8Message[ (tU16)enCM_StationsList_offset_HDNumberOfAudioPrograms + u8OffsetAfterSendername]
                      ));


 
	   
		  /** Function call to get single list element from byte string of entire list */
    	  vCreateStationsListElement(
          u8ListId,                                              /* tU8 u8ListId          */
          (tU8)unElement,                                        /* tU8 u8ElementId       */
          &pu8Message[ unElementIndex],							 /* const tU8* pu8Element */
		  &TunConfigListElement);								 /* midw_fi_tcl_TunerConfigListElement TunConfigListElement */


		  ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_CM_StationsList(), StationLogo=%s"
					,TunConfigListElement.StationLogo.szGet(midw_fi_tclString::FI_EN_UTF8)
				));

        
		/** Adding element in the list */
		oConfigListStatusMsg.Tun_ConfigListElements.TunerConfigListElement.push_back(TunConfigListElement);

        unElement++;
		/** increment index by constatnt dat length + variable sendername length */
		unElementIndex = (tU16) ( unElementIndex + ((tU16)enCM_StationsList_len_ConstantData_ExceptSendername + \
			pu8Message[ (tU16)enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_size + unElementIndex]));
      }
    }

	vSendMessage ( pNot->u16AppID,
                 oConfigListStatusMsg,
                 MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST,
                 AMT_C_U8_CCAMSG_OPCODE_STATUS,
                 pNot->u16CmdCounter,
                 pNot->u16RegisterID );

    
  } 
 
 ahl_bReleaseCritical(m_hNotHMITableSem);
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vCreateStationsListElement( )
* 
* DESCRIPTION:  Creates and returns Config List element from byte string obtained from ADR.
*
* PARAMETER:    tU8 u8Header, tU8 u8ListId, tU8 u8ElementId, const tU8* pu8Element
*
* RETURNVALUE:  void
*
* Author: vnd4kor ECG4 29/8/2013
*************************************************************************/
tVoid tun_MsgToHMI::vCreateStationsListElement(  tU8 u8ListId, \
												 tU8 u8ElementId, const tU8* pu8Element ,\
												 midw_fi_tcl_TunerConfigListElement* TunerConfigListElement)
{

	if(( m_potun_Utility == NULL)||\
	( m_potun_Config == NULL)||\
	( m_poclConfigInterface == NULL)||\
	( m_potun_HMIManager == NULL)||\
	( m_potun_ActualData == NULL)
	)
	
	{
		TUN_ASSERT_RETURN( m_potun_Utility != NULL);
		TUN_ASSERT_RETURN( m_potun_Config != NULL);
		TUN_ASSERT_RETURN( m_poclConfigInterface != NULL);
		TUN_ASSERT_RETURN( m_potun_HMIManager != NULL);
		TUN_ASSERT_RETURN( m_potun_ActualData != NULL);
		return;
	}
	
	ETG_TRACE_USR2(( " tun_MsgToHMI::vCreateStationsListElement() "));

  
	TunerConfigListElement->e8ConfigListID.enType = (midw_fi_tcl_e8_Tun_ConfigListID::tenType) u8ListId;

	/** index of element in list */
	TunerConfigListElement->u8ElementID = u8ElementId;

	/** station selection */
	TunerConfigListElement->u8ElementSelected = pu8Element[ enCM_StationsList_idx_Selected];

	/** modulation type */
	TunerConfigListElement->e8ModulationType.enType = (midw_fi_tcl_e8_Tun_ModulationType::tenType)pu8Element[ enCM_StationsList_idx_ModulationType];

	/* Frequency */
	TunerConfigListElement->u32Frequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( \
		&pu8Element[ enCM_StationsList_idx_Frequency] );

	/** PSname / DRMServiceLabel / HDCallSign */
	midw_fi_tclString sUtf8String ;


	/** solution to VWMIBB-2114 */
	/** Check if the frequency is currently tuned frequency or not*/
	if(TunerConfigListElement->u32Frequency == m_potun_ActualData->m_otun_Data_Station.u32GetFrequency() &&\
		TunerConfigListElement->e8ModulationType.enType == midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_ANALOG)
	{

		ETG_TRACE_USR2(( " tun_MsgToHMI::vCreateStationsListElement() -> Frequency same as tuned frequency"));

		ETG_TRACE_USR2(( " tun_MsgToHMI::vCreateStationsListElement() -> RDSSwitchStatus = %d , PIIgnore = %d" 
				,u8GetRDSSwitchStatus(), m_poclConfigInterface -> u32GetConfigData("PIIgnore") ));

		/** if RDS is active and PI ignore is inactive */
		if((u8GetRDSSwitchStatus()) && (m_poclConfigInterface -> u32GetConfigData("PIIgnore") == 0))
		{
			//m_potun_HMIManager -> vConvertRTextTotString((const tU8*)m_potun_ActualData->m_otun_Data_Station.pcocGetPSName() ,&sUtf8String,8) ;		
			m_potun_HMIManager -> vConvertRDSPSNametotString((const tU8*)m_potun_ActualData->m_otun_Data_Station.pcocGetPSName() ,&sUtf8String) ;		

			
		    ETG_TRACE_USR2((" Received Stationname = %8s, AtstationInfo Stationname = %8s"
                            , (const tChar*)&pu8Element[ enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data]           
							, m_potun_ActualData->m_otun_Data_Station.pcocGetPSName()			// oAtStationInfoStatusMsg.Atstationinfo.u8PSName1 .. 8
                            ));


		}
		else
		{
			m_potun_HMIManager -> vConvertRDSPSNametotString((const tU8*)&pu8Element[ enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data] ,&sUtf8String) ;
			//m_potun_HMIManager -> vConvertRTextTotString((const tU8*)&pu8Element[ enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data] ,&sUtf8String,
			//	pu8Element[ (tU16)enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_size]) ;
		}

			  
	}
	else
	{
		//m_potun_HMIManager -> vConvertRDSPSNametotString((const tU8*)&pu8Element[ enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data] ,&sUtf8String) ;				
		m_potun_HMIManager -> vConvertRTextTotString((const tU8*)&pu8Element[ enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data] ,&sUtf8String,
			pu8Element[ (tU16)enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_size]) ;				

	}



	/* name is copied in UTF format here */
	TunerConfigListElement->sPSName.bSet( sUtf8String ,
		midw_fi_tclString::FI_EN_UTF8
		);
	
	/** offset calculation after considering variable  stationname */
	tU8 u8OffsetAfterSendername = (tU8)(enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data + \
						  pu8Element[ (tU16)enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_size]);
	
	/** Sendername info */
	TunerConfigListElement->e8SendernameInfo.enType = (midw_fi_tcl_e8_Tun_SendernameInfo::tenType) pu8Element[ enCM_StationsList_offset_SendernameInfo + u8OffsetAfterSendername];
	
	/** PTY */
	TunerConfigListElement->u8PTY = pu8Element[ enCM_StationsList_offset_PTY_HDStationGenre_DRMPty + u8OffsetAfterSendername];
	
	/** u8PTY_HDPTY_DRMPty */
	TunerConfigListElement->u8PTY_HDPTY_DRMPty = pu8Element[ enCM_StationsList_offset_PTY_HDStationGenre_DRMPty + u8OffsetAfterSendername];

	/* PI */
	TunerConfigListElement->u32PI = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( \
		&pu8Element[ enCM_StationsList_offset_PI_HDStationId_DRMServiceID + u8OffsetAfterSendername] );	
	
	/** PI / HDStnId / DRMSrvId */
	TunerConfigListElement->u32PI_HDStnId_DRMSrvId = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( \
		&pu8Element[ enCM_StationsList_offset_PI_HDStationId_DRMServiceID + u8OffsetAfterSendername] );

	///** TP info */
	TunerConfigListElement->bTpInfo = pu8Element[ enCM_StationsList_offset_StationInfo] & \
		tenStationListStationInfo_bit1_TP;

	/** station  info */
	TunerConfigListElement->b8StationInfo.u8Value = pu8Element[ enCM_StationsList_offset_StationInfo + u8OffsetAfterSendername] ;

	/** Reception Quality */
	TunerConfigListElement->u8Quality = pu8Element[ enCM_StationsList_offset_ReceptionQuality + u8OffsetAfterSendername];
	
	/** TMC */
	TunerConfigListElement->e8TMCType.enType = \
		(midw_fi_tcl_e8_Tun_TMCType::tenType)pu8Element[enCM_StationsList_offset_TMC + u8OffsetAfterSendername];

	tU16 u16ADRListID =  m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Element[enCM_StationsList_offset_PresetListForAcmp + u8OffsetAfterSendername]);
	tU8 u8HMIListID = (tU8)oGetADR3ToMidwTunerPresetListID(u16ADRListID);
	TunerConfigListElement->e8PresetListForAcmp.enType = \
	(midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListID;

	/** The index of the FM station in Preset list */
	TunerConfigListElement->u8PositionInPresetList = pu8Element[ enCM_StationsList_offset_PresetAcmp + u8OffsetAfterSendername];
	
	/** Level Compensation */
	TunerConfigListElement->s8LevelCompensation = (tS8)pu8Element[enCM_StationsList_offset_LevelComp + u8OffsetAfterSendername];

	/** HD Text Encoding */
	TunerConfigListElement->e8HDTextEncoding.enType = (midw_fi_tcl_e8_Tun_HD_TextEncodingType::tenType) pu8Element[enCM_StationsList_offset_HDTextEncoding + u8OffsetAfterSendername];

	/** HD Num Of Audio Programs */
	TunerConfigListElement->b8HDNumOfAudioPrograms.u8Value = pu8Element[enCM_StationsList_offset_HDNumberOfAudioPrograms + u8OffsetAfterSendername];


	if(TunerConfigListElement->u32PI_HDStnId_DRMSrvId != 0)
	{

		 
		vGetStationLogoPath(TunerConfigListElement->u32PI_HDStnId_DRMSrvId, sUtf8String) ;
	  TunerConfigListElement->StationLogo.bSet( sUtf8String, midw_fi_tclString::FI_EN_UTF8);

	}


}
#else
/*************************************************************************
* 
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_StationsList( )
* 
* DESCRIPTION:  Handle CM_StationsList from ADR3.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_StationsList(tU8* pu8Message )
{
  TUN_ASSERT_RETURN( m_potun_Utility != NULL);
  TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
  
  ahl_bEnterCritical( m_hNotHMITableSem );

  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST) ; 
        pNot != OSAL_NULL; pNot=pNot->pNext)
  {


    tU8 u8PosX = pu8Message[ enCM_StationsList_idx_PosX];
    tU8 u8PosY = pu8Message[ enCM_StationsList_idx_PosY];
    tU16 u16Payload = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ enAdrMsgOffset_DATA_LEN] );
    tU8 u8ListId = pu8Message[ u16Payload + (tU8)enAdrMsgOffset_HEADER_LEN - 1];


    ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_CM_StationsList(), u16Payload=%d bytes, Pos={%d,%d}, ListId=%d"
                     ,u16Payload
                     ,u8PosX, u8PosY
                     ,u8ListId
                  ));

	midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus oConfigListStatusMsg;
	
    if( (u8PosX == 0) && (u8PosY == 0))
    {
      tU16 unElement = 0;
	
	  /** object to hold single list element*/
	  midw_fi_tcl_TunerConfigListElement TunConfigListElement;


      for( tU16 unElementIndex = (tU16)enCM_StationsList_idx_Data; unElementIndex < (u16Payload - (tU16)enCM_StationsList_len_Pos - (tU16)enCM_StationsList_len_ListId); unElementIndex += (tU16)enCM_StationsList_len_Data)
      {

		/** Logging the data of each element in list*/
        ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_CM_StationsList()Part 1 ->,\
						  Element=%d, unElementIndex=%d, u32Freq=%d kHz, PI=0x%04X, Name=%8s"
                         ,unElement
                         ,unElementIndex
                         ,m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[ (tU16)enCM_StationsList_idx_Frequency + unElementIndex] )
                         ,m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ (tU16)enCM_StationsList_idx_PI + unElementIndex] )
                         ,(tChar*)&pu8Message[ (tU16)enCM_StationsList_idx_Sendername + unElementIndex]
                      ));

        ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_CM_StationsList() Part 2 ->\n,\
						  Selected=%d, SendernameInfo=%d, PTY=%d, TpInfo=0x%02X, ReceptionQuality=0x%02X,\n\
						  TMC=0x%02x, PresetListForAcmp=0x%04X, PresetAcmp=0x%04X,s8LevelCompensation = %d"
                         ,pu8Message[ (tU16)enCM_StationsList_idx_Selected + unElementIndex]
                         ,ETG_CENUM( tenCM_StationsListSendernameInfo, pu8Message[ (tU16)enCM_StationsList_idx_SendernameInfo + unElementIndex])
                         ,pu8Message[ (tU16)enCM_StationsList_idx_PTY + unElementIndex]
                         ,(pu8Message[ (tU16)enCM_StationsList_idx_TpInfo + unElementIndex] & tenStationListStationInfo_bit1_TP)
                         ,pu8Message[ (tU16)enCM_StationsList_idx_ReceptionQuality + unElementIndex]
                         ,ETG_CENUM( tenCM_StationsListTMC, pu8Message[ (tU16)enCM_StationsList_idx_TMC + unElementIndex] )
                         ,m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[ (tU16)enCM_StationsList_idx_PresetListForAcmp + unElementIndex] )
                         ,pu8Message[ (tU16)enCM_StationsList_idx_PresetAcmp + unElementIndex]
						 ,(tS8)pu8Message[(tU16)enCM_StationsList_idx_LevelComp+ unElementIndex]
                      ));

 
	   
		  /** Function call to get single list element from byte string of entire list */
    	  vCreateStationsListElement(
          u8ListId,                                              /* tU8 u8ListId          */
          (tU8)unElement,                                        /* tU8 u8ElementId       */
          &pu8Message[ unElementIndex],							 /* const tU8* pu8Element */
		  &TunConfigListElement);								 /* midw_fi_tcl_TunerConfigListElement TunConfigListElement */

        
		/** Adding element in the list */
		oConfigListStatusMsg.Tun_ConfigListElements.TunerConfigListElement.push_back(TunConfigListElement);

        unElement++;
      }
    }

	vSendMessage ( pNot->u16AppID,
                 oConfigListStatusMsg,
                 MIDW_TUNERFI_C_U16_FID_TUN_G_GET_CONFIG_LIST,
                 AMT_C_U8_CCAMSG_OPCODE_STATUS,
                 pNot->u16CmdCounter,
                 pNot->u16RegisterID );

    
  } 
 
 ahl_bReleaseCritical(m_hNotHMITableSem);
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vCreateStationsListElement( )
* 
* DESCRIPTION:  Creates and returns Config List element from byte string obtained from ADR.
*
* PARAMETER:    tU8 u8Header, tU8 u8ListId, tU8 u8ElementId, const tU8* pu8Element
*
* RETURNVALUE:  void
*
* Author: vnd4kor ECG4 29/8/2013
*************************************************************************/
tVoid tun_MsgToHMI::vCreateStationsListElement(  tU8 u8ListId, \
												 tU8 u8ElementId, const tU8* pu8Element ,\
												 midw_fi_tcl_TunerConfigListElement* TunerConfigListElement)
{

	if(( m_potun_Utility == NULL)||\
	( m_potun_Config == NULL)||\
	( m_poclConfigInterface == NULL)||\
	( m_potun_HMIManager == NULL)||\
	( m_potun_ActualData == NULL)
	)
	
	{
		TUN_ASSERT_RETURN( m_potun_Utility != NULL);
		TUN_ASSERT_RETURN( m_potun_Config != NULL);
		TUN_ASSERT_RETURN( m_poclConfigInterface != NULL);
		TUN_ASSERT_RETURN( m_potun_HMIManager != NULL);
		TUN_ASSERT_RETURN( m_potun_ActualData != NULL);
		return;
	}
	
	ETG_TRACE_USR2(( " tun_MsgToHMI::vCreateStationsListElement() "));

  
	TunerConfigListElement->e8ConfigListID.enType = (midw_fi_tcl_e8_Tun_ConfigListID::tenType) u8ListId;

	/** index of element in list */
	TunerConfigListElement->u8ElementID = u8ElementId;

	/** station selection */
	TunerConfigListElement->u8ElementSelected = pu8Element[ enCM_StationsList_idx_Selected];

	/** Sendername info */
	TunerConfigListElement->e8SendernameInfo.enType = (midw_fi_tcl_e8_Tun_SendernameInfo::tenType) pu8Element[ enCM_StationsList_idx_SendernameInfo];


	/* Frequency */
	TunerConfigListElement->u32Frequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( \
		&pu8Element[ enCM_StationsList_idx_Frequency] );

	/* PI */
	TunerConfigListElement->u32PI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( \
		&pu8Element[ enCM_StationsList_idx_PI] );

	
	/** PS name is copied here*/	
	midw_fi_tclString sUtf8String ;


	/** solution to VWMIBB-2114 */
	/** Check if the frequency is currently tuned frequency or not*/
	if(TunerConfigListElement->u32Frequency == m_potun_ActualData->m_otun_Data_Station.u32GetFrequency())
	{

		ETG_TRACE_USR2(( " tun_MsgToHMI::vCreateStationsListElement() -> Frequency same as tuned frequency"));

		ETG_TRACE_USR2(( " tun_MsgToHMI::vCreateStationsListElement() -> RDSSwitchStatus = %d , PIIgnore = %d" 
				,u8GetRDSSwitchStatus(), m_poclConfigInterface -> u32GetConfigData("PIIgnore") ));

		/** if RDS is active and PI ignore is inactive */
		if((u8GetRDSSwitchStatus()) && (m_poclConfigInterface -> u32GetConfigData("PIIgnore") == 0))
		{
			m_potun_HMIManager -> vConvertRDSPSNametotString((const tU8*)m_potun_ActualData->m_otun_Data_Station.pcocGetPSName() ,&sUtf8String) ;		

			
		    ETG_TRACE_USR2((" Received Stationname = %8s, AtstationInfo Stationname = %8s"
                            , (const tChar*)&pu8Element[ enCM_StationsList_idx_Sendername]           
							, m_potun_ActualData->m_otun_Data_Station.pcocGetPSName()			// oAtStationInfoStatusMsg.Atstationinfo.u8PSName1 .. 8
                            ));


		}
		else
		{
			m_potun_HMIManager -> vConvertRDSPSNametotString((const tU8*)&pu8Element[ enCM_StationsList_idx_Sendername] ,&sUtf8String) ;
		}

			  
	}
	else
	{
		m_potun_HMIManager -> vConvertRDSPSNametotString((const tU8*)&pu8Element[ enCM_StationsList_idx_Sendername] ,&sUtf8String) ;				

	}



	/* name is copied in UTF format here */
	TunerConfigListElement->sPSName.bSet( sUtf8String ,
		midw_fi_tclString::FI_EN_UTF8
		);

	/** PTY */
	TunerConfigListElement->u8PTY = pu8Element[ enCM_StationsList_idx_PTY];

	/** Reception Quality */
	TunerConfigListElement->u8Quality = pu8Element[ enCM_StationsList_idx_ReceptionQuality];

	/** The index of the FM station in Preset list */
	TunerConfigListElement->u8PositionInPresetList = pu8Element[ enCM_StationsList_idx_PresetAcmp];

	/** TP info */
	TunerConfigListElement->bTpInfo = pu8Element[ enCM_StationsList_idx_TpInfo] & \
		tenStationListStationInfo_bit1_TP;

	/** TMC */
	TunerConfigListElement->e8TMCType.enType = \
		(midw_fi_tcl_e8_Tun_TMCType::tenType)pu8Element[enCM_StationsList_idx_TMC];
		
	tU16 u16ADRListID =  m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Element[enCM_StationsList_idx_PresetListForAcmp]);
	tU8 u8HMIListID = (tU8)oGetADR3ToMidwTunerPresetListID(u16ADRListID);
	TunerConfigListElement->e8PresetListForAcmp.enType = \
	(midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListID;

	/** Level Compensation */
	TunerConfigListElement->s8LevelCompensation = (tS8)pu8Element[enCM_StationsList_idx_LevelComp];


	if(TunerConfigListElement->u32PI_HDStnId_DRMSrvId != 0)
	{
		
		vGetStationLogoPath(TunerConfigListElement->u32PI_HDStnId_DRMSrvId, sUtf8String) ;
	  TunerConfigListElement->StationLogo.bSet( sUtf8String,midw_fi_tclString::FI_EN_UTF8);
	}


}

#endif


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_UpdateConfigList( )
* 
* DESCRIPTION:  Handle TUN_R_UPDATE_CONFIG_LIST response from Radio Unit.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/








/*tVoid tun_MsgToHMI :: vHandle_r_UpdateConfigList( const tU8* pu8Message, tU32 u32MessageLen )
{

}*/

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Audio_Fg_Bg_new( )
* 
* DESCRIPTION:  Handle TUN_R_AUDIO_FG_BG response from Radio Unit.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Audio_Fg_Bg_new( const tU8* pu8Message, tU32 u32MessageLen )
{
   if(( m_poHMINotTable == NULL) ||(m_potun_HMIManager == NULL) )
   {
      if( m_poHMINotTable == NULL )
      {
         NORMAL_M_ASSERT( m_poHMINotTable != NULL );

      } 

      if( m_potun_HMIManager == NULL )
      {
         NORMAL_M_ASSERT( m_potun_HMIManager != NULL );

      }

      return;
   }

   if(    (pu8Message != NULL) && (u32MessageLen != 0) && (m_potun_ActualData != NULL)
       && ( pu8Message[ enAdrMsgOffset_OP_TYPE] == (tU8)enOpType_STATUS)
     )
   {
		
	   vSetTunFGBGStatus(pu8Message[ enAdrMsgOffset_DATA]);
	   ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Audio_Fg_Bg_new() -> TunerFGBG : %d ",pu8Message[ enAdrMsgOffset_DATA]));
		
       //midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult oResponse;

        // Response -> SUCC / FAIL / BUSY
      //  oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =
                               // midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;

        // Current Tuner state -> Not required for client. NORAL added as default.
      //  oResponse.TunerServer_StatusResponse.u8TunerState.enType =
                              //  midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

        //------------------------------
        // Send the response to client.
        //------------------------------
/*#ifndef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		tU16 u16CommandCntr = u16GetTunerMasterCommandCntrForFGBG();
		tU16 u16RegID = u16GetTunerMasterRegIDForFGBG();
        vSendMessage( CCA_C_U16_APP_TUNERMASTER,
                      oResponse,
                      MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW,
                      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                      u16CommandCntr,
                      u16RegID
                    );
#endif*/       
		
		

   }//if( (pu8Message != NULL) && (u32MessageLen != 0) )
}




/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Sharx_Level( )
* 
* DESCRIPTION:  Handle TUN_R_AUDIO_FG_BG response from Radio Unit.
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_Sharx_Level( const tU8* pu8Message )
{

    if(( m_poHMINotTable == NULL) || ( pu8Message == NULL ) )
   {
        NORMAL_M_ASSERT( m_poHMINotTable != NULL );
        NORMAL_M_ASSERT( pu8Message != NULL );
     return;
   }

	ETG_TRACE_USR4(( " tun_MsgToHMI::vHandle_r_Sharx_Level() "));
         


    /*--------------------------------------------------------*/
    /* HMI Manager decides, should the message be sent to HMI */
    /*--------------------------------------------------------*/
      ahl_bEnterCritical( m_hNotHMITableSem );

       for(ahl_tNotification* pNot =
            m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_SHARXLEVEL) ;
           pNot != OSAL_NULL; pNot=pNot->pNext
          )
      {
         midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus oStatusMsg;

         /*Update the Sharx value*/
         oStatusMsg.u8SharxStep = pu8Message[12];

         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                            ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_SHARXLEVEL _\
                            ET_EN_T8 _ 0x01 _\
                            ET_EN_T8 _ oStatusMsg.u8SharxStep _\
                                                       ET_EN_DONE);

   
           /*-------------------------------*/
           /* Post message to HMI component */
           /*-------------------------------*/

         vSendMessage ( pNot->u16AppID,
                        oStatusMsg,
                        MIDW_TUNERFI_C_U16_FID_TUN_G_SET_SHARXLEVEL,
                        AMT_C_U8_CCAMSG_OPCODE_STATUS,
                        pNot->u16CmdCounter,
                        pNot->u16RegisterID );


       }  /* for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
               pNot != OSAL_NULL; pNot=pNot->pNext) */
      
      ahl_bReleaseCritical(m_hNotHMITableSem);


   
}

  
/****************************************************************************
*FUNCTION:    tun_MsgToHMI::vSendMessage
*
*DESCRIPTION: This function converts Amt message to visitor class and 
*             get the data from visitor to the Fi class. Refer FI Manual.Doc.
*
*PARAMETER:    
*             u16DestAppID      - Destination ID of Out Msg  
*             oOutData          - Base class of out going Fi object
*             u16Fid            - Funtion id of the out going message
*             u8OpCode          - Opcode of the message 
*
*RETURNVALUE: None
******************************************************************************/
tVoid tun_MsgToHMI::vSendMessage( tU16             u16DestAppID,
                                  const fi_tclTypeBase&  oOutData,
                                     tU16             u16Fid,
                                     tU8              u8OpCode,
                                     tU16             u16CmdCtr,
                                     tU16             u16RegId)
{
  TUN_ASSERT_RETURN( poGWMain != NULL);

  // Create the Visitor Message
  fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);

  /** Commented out as  port manager functionality is currently not available */
  /*if((u16Fid == MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO) && (u16DestAppID != CCA_C_U16_APP_DIAGDEBUG))
  {
    u16CmdCtr = AHL_UPREG_CMD_COUNTER;
  }*/

  // Set the CCA message information
  oOutVisitorMsg.vInitServiceData(
         CCA_C_U16_APP_TUNER,                      /* Source app-ID    */
         u16DestAppID,                             /* Dest. app-ID     */
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,        /* stream type      */
         0,                                        /* stream counter   */
         u16RegId,                                 /* Registry ID      */
         u16CmdCtr,                                /* Command counter  */
         CCA_C_U16_SRV_TUNERCONTROL,               /* Service-ID       */
         u16Fid,                                   /* Function-ID      */
         u8OpCode,                                 /* OpCode           */
         0,                                        /* ACT              */
         0,                                        /* Source sub-ID    */
         0 );                                      /* Dest. sub-ID     */

  /** Commented out as  port manager functionality is currently not available */
  /*
  if(( u16Fid == MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO ) && ( u16DestAppID != CCA_C_U16_APP_TUNERMASTER ))
  {
	    ahl_tenPortResult enResult;

	    enResult = poGWMain->m_poPortMngr->enPost( &oOutVisitorMsg);

	    ETG_TRACE_USR4((" tun_MsgToHMI::vSendMessage -> Message sent via port, result = %d", enResult));

  }
   
  else */
  {
    /* ---
    send it to the client 
    --- */
    if(poGWMain->enPostMessage( &oOutVisitorMsg, TRUE ) == AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_USR4((" tun_MsgToHMI::vSendMessage -> Message sent successfully."));
    }
    else
    {
      ETG_TRACE_USR4((" tun_MsgToHMI::vSendMessage -> Message not sent successfully."));
    }
  }
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Get_RadioText( )
* 
* DESCRIPTION:  Handle response from ADR3 for Radio Text
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void
*
*************************************************************************/

tVoid tun_MsgToHMI::vHandle_r_Get_RadioText(const tU8* pu8Message)
{
  /* Pointer validation */
  
  if(( m_poHMINotTable == NULL) ||(m_potun_HMIManager == NULL) ||
     ( pu8Message == NULL ) 
    )
  {
      NORMAL_M_ASSERT( m_poHMINotTable != NULL );
      NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
      NORMAL_M_ASSERT( pu8Message != NULL );
   
    return ;
  }//End of Pointer Validation

  /*gds5kor: RadioText should update only to MPS in case of HD signal lost */
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  if (m_poclConfigInterface->u32GetConfigData("HDSupported") && m_u8CurrentAudioProgram != 0x00)
  {
	  ETG_TRACE_USR4((" tun_MsgToHMI::vHandle_r_Get_RadioText() -> Not tuned to MPS, m_u8CurrentAudioProgram = %d", m_u8CurrentAudioProgram));
	  return;
  }
#endif

  /*--------------------------------------------------------*/
  /* HMI Manager decides, should the message be sent to HMI */ 
  /*--------------------------------------------------------*/
 // if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
  if(pu8Message[enAdrMsgOffset_OP_TYPE] == (tU8)enOpType_STATUS)
#else
  if((pu8Message[enAdrMsgOffset_OP_TYPE] == (tU8)enOpType_STATUS) && (u8GetTunFGBGStatus() != (tU8)enAudioSource_TA_audio))
#endif
  {
    ahl_bEnterCritical( m_hNotHMITableSem );

    for( ahl_tNotification* pNot=
         m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT);
         pNot != OSAL_NULL; 
         pNot=pNot->pNext
       )
    {
      midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus oStatusMsg;

      midw_fi_tclString sUtf8String;

      // Convert the characters received in EBU format -> UTF8
      m_potun_HMIManager -> vConvertRTextTotString( &pu8Message[ enCurrentRadiotext_idx_Data], &sUtf8String, (tU8)enCurrentRadiotext_len_Data);

      oStatusMsg.TunerRadioText.sRadioTextData.bSet( sUtf8String,
                                                       midw_fi_tclString::FI_EN_UTF8
                                                   );
	  oStatusMsg.u16PICode = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Message[enCurrentRadiotext_idx_PosX ]);;

      vSendMessage ( pNot->u16AppID,
                     oStatusMsg,
                     MIDW_TUNERFI_C_U16_FID_TUN_G_RADIO_TEXT,
                     AMT_C_U8_CCAMSG_OPCODE_STATUS,
                     pNot->u16CmdCounter,
                     pNot->u16RegisterID 
                   );

      ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_Get_RadioText() -> PICode = 0x%04x text=%64s" ,  \
		  oStatusMsg.u16PICode,oStatusMsg.TunerRadioText.sRadioTextData.szValue));


      oStatusMsg.TunerRadioText.sRadioTextData.vDestroy();

    }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)

    ahl_bReleaseCritical(m_hNotHMITableSem);

  }/*if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )*/

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Set_Antenna( )
* 
* DESCRIPTION:  Handle response from Radio Unit for Radio Text
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void

*Author:       she4kor

*************************************************************************/
tVoid tun_MsgToHMI ::vHandle_r_Set_Antenna(const tU8* /*pu8Message*/)
{
  /* Pointer validation */
#if 0 
  if(( m_poHMINotTable == NULL) ||(m_potun_HMIManager == NULL) ||
     ( pu8Message == NULL ) 
    )
  {
      NORMAL_M_ASSERT( m_poHMINotTable != NULL );
      NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
      NORMAL_M_ASSERT( pu8Message != NULL );
   
    return ;
  }//End of Pointer Validation



  /*--------------------------------------------------------*/
  /* HMI Manager decides, should the message be sent to HMI */
  /*--------------------------------------------------------*/
  
  //if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
  {
    ahl_bEnterCritical( m_hNotHMITableSem );

    for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ANTENNA) ;\
            pNot != OSAL_NULL; pNot=pNot->pNext)
    {      
      /*-------------------------------*/
      /* Post message to HMI component */
      /*-------------------------------*/
          
      /*-----------------------------------------------------*/
      /* Create a message, use the data of given message to  */
      /* get the address information                         */
      /*-----------------------------------------------------*/

      midw_tunerfi_tclMsgFID_TUN_G_SET_ANTENNAStatus oAntennaStatus;

      oAntennaStatus.b8_Antenna.u8Value=pu8Message[2];

      ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                     ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ANTENNA _\
                     ET_EN_T32 _ oAntennaStatus.b8_Antenna.u8Value _\
                     ET_EN_DONE );

   

      vSendMessage ( pNot->u16AppID,
                         oAntennaStatus,
                         MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ANTENNA,
                         AMT_C_U8_CCAMSG_OPCODE_STATUS,
                         pNot->u16CmdCounter,
                         pNot->u16RegisterID );


    }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
    ahl_bReleaseCritical(m_hNotHMITableSem);  
  }//if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
#endif
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Set_Antenna( )
* 
* DESCRIPTION:  Handle response from Radio Unit for Radio Text
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void

*Author:       she4kor

*************************************************************************/
tVoid tun_MsgToHMI ::vSendTMCInfo(tBool /*bTMCInfoFlag*/)
{
  /* Pointer validation */
#if 0  
  if(( m_poHMINotTable == NULL))
  {
    NORMAL_M_ASSERT( m_poHMINotTable != NULL );
    return ;
  } 

  ahl_bEnterCritical( m_hNotHMITableSem );

  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_TMC_INFO) ;\
            pNot != OSAL_NULL; pNot=pNot->pNext)
  {      

    /*-----------------------------------------------------*/
    /* Create a message, use the data of given message to  */
    /* get the address information                         */
    /*-----------------------------------------------------*/

    midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus oTMCInfo;

    oTMCInfo.bTMCAvailableFlag = bTMCInfoFlag;

    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                   ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_TMC_INFO _\
                   ET_EN_T32 _ oTMCInfo.bTMCAvailableFlag _\
                   ET_EN_DONE );



    vSendMessage ( pNot->u16AppID,
                   oTMCInfo,
                   MIDW_TUNERFI_C_U16_FID_TUN_G_TMC_INFO,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   pNot->u16CmdCounter,
                   pNot->u16RegisterID );

  }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
  ahl_bReleaseCritical(m_hNotHMITableSem);  
#endif
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_Monitor_Station( )
* 
* DESCRIPTION:  Handle response from Radio Unit for Radio Text
*
* PARAMETER:    tU8* pu8Message
*
* RETURNVALUE:  void

*Author:       rrb1kor

*************************************************************************/
tVoid tun_MsgToHMI ::vHandle_r_Monitor_Station(const tU8* /*pu8Message*/)
{
  /* Pointer validation */
#if 0 
  if(( m_poHMINotTable == NULL) ||(m_potun_HMIManager == NULL) ||
     (m_potun_ActualData == NULL)||( pu8Message == NULL ) || (m_potun_Utility == NULL)
    )
  {
      NORMAL_M_ASSERT( m_poHMINotTable != NULL );
      NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
      NORMAL_M_ASSERT( m_potun_ActualData != NULL );
      NORMAL_M_ASSERT( pu8Message != NULL );
	  NORMAL_M_ASSERT(m_potun_Utility!=NULL);
        
    return ;
  }//End of Pointer Validation



  /*--------------------------------------------------------*/
  /* HMI Manager decides, should the message be sent to HMI */
  /*--------------------------------------------------------*/
  
  //if( m_potun_HMIManager -> fMessageCanBeSentToHMI( pu8Message, u32MessageLen ) )
  {
    
  ahl_bEnterCritical( m_hNotHMITableSem );

    for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_MONITOR_STATION) ;\
            pNot != OSAL_NULL; pNot=pNot->pNext)
    {      
    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                     ET_EN_T16 _ TUN_TRACE_MSG_TO_HMI_MONITOR_STATION  _\
                     ET_EN_DONE );
    midw_tunerfi_tclMsgFID_TUN_G_MONITOR_STATIONStatus oMonitorStationStatus;
    oMonitorStationStatus.u8Client.enType =(midw_fi_tcl_e8_Tun_Client::tenType)pu8Message[2];
    oMonitorStationStatus.bMode = (tBool)pu8Message[3];
    oMonitorStationStatus.u8Quality=pu8Message[4];
    
    oMonitorStationStatus.u32PI=m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[5]);
  
    
  ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSG_TO_HMI_MONITOR_STATION_DATA _\
                         ET_EN_T8  _ ((tU8)oMonitorStationStatus.u8Client.enType) _\
                         ET_EN_T8  _ (oMonitorStationStatus.bMode) _\
                         ET_EN_T8 _ (oMonitorStationStatus.u8Quality) _\
                         ET_EN_T32 _ (oMonitorStationStatus.u32PI ) _\
                         ET_EN_DONE);
     
     
     
     
      vSendMessage ( pNot->u16AppID,
                         oMonitorStationStatus,
                         MIDW_TUNERFI_C_U16_FID_TUN_G_MONITOR_STATION,
                         AMT_C_U8_CCAMSG_OPCODE_STATUS,
                         pNot->u16CmdCounter,
                         pNot->u16RegisterID );
    ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,\
                         ET_EN_T16 _ TUN_TRACE_MSG_TO_HMI_MONITOR_STATION_DATA _\
                         ET_EN_T8  _ ((tU8)oMonitorStationStatus.u8Client.enType) _\
                         ET_EN_T8  _ (oMonitorStationStatus.bMode) _\
                         ET_EN_T8 _ (oMonitorStationStatus.u8Quality) _\
                         ET_EN_T32 _ (oMonitorStationStatus.u32PI ) _\
                         ET_EN_DONE);


    }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
    ahl_bReleaseCritical(m_hNotHMITableSem);  
  }
#endif
}



/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_AtPresetList( )
* 
* DESCRIPTION:  Handle response from ADR for CM_AtPresetList
*
* PARAMETER:    tU8* pu8Message, tU32 u32MessageLen
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_MsgToHMI ::vHandle_r_CM_AtPresetList(const tU8* pu8Message, tU32 u32MessageLen)
{
	if(( m_potun_Utility == NULL) ||\
	( m_poHMINotTable == NULL)||\
	( m_potun_Config == NULL)||\
	( m_potun_MsgToADR == NULL)
	)
	{
		TUN_ASSERT_RETURN( m_potun_Utility != NULL);
		TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
		TUN_ASSERT_RETURN( m_potun_Config != NULL);
		TUN_ASSERT_RETURN( m_potun_MsgToADR != NULL);
		return;
	}
	
	

	/** No of presets received */
	tU8 u8NoOfPresets = 0;


		ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_CM_AtPresetList() : OpType : STATUS"));

		ahl_bEnterCritical( m_hNotHMITableSem );

		

		if( /** Preset Delete all case */
			(((pu8Message[ enCM_PresetList_idx_PosX] == 0) && (pu8Message[ enCM_PresetList_idx_PosY] == 2))
			||
			/** Preset single element delete case */
			((pu8Message[ enCM_PresetList_idx_PosX] != 0) && (pu8Message[ enCM_PresetList_idx_PosY] == 2))
			||
			/** Preset save case */
			((pu8Message[ enCM_PresetList_idx_PosX] != 0) && (pu8Message[ enCM_PresetList_idx_PosY] == 0))
			))
		{
			/** Work Around */
			/** In Preset Delete all case : entire list is not received , 
			hence do not parse pu8Message array for entire preset list */

			/** Calculate Number Of preset frequencies Received */
			u8NoOfPresets = (tU8)((u32MessageLen - (tU32)enCM_PresetList_idx_Data)/(tU32)enCM_PresetList_len_Frequency);
		}
		else
		{
		
		/** Calculate Number Of presets Received */
		u8NoOfPresets = (tU8)( (u32MessageLen - (tU32)enCM_PresetList_idx_Data)/(tU32)enCM_PresetList_len_Data);

		
		for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST) ; pNot != OSAL_NULL; pNot=pNot->pNext)
		{
			tU8 u8PosX = pu8Message[ enCM_PresetList_idx_PosX];
			tU8 u8PosY = pu8Message[ enCM_PresetList_idx_PosY];


			ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_CM_AtPresetList(),  Pos={%d,%d}"
				,u8PosX, u8PosY
				));

			/** Create Status msg */
			midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus oStatusMsg;
			/*midw_fi_tcl_TunerStaticListElementList oStatic_List;*/
			midw_fi_tcl_TunerStaticListElement oStatic_ListElem;

			oStatusMsg.u8NumofElementsinList = u8NoOfPresets;

			/** Get ADR preset list ID */
			tU16 u16ADRListID = TUN_DRVADRIF_GET_U16( &pu8Message[enAdrMsgOffset_FKT_ID]);
			/** Convert ADR preset list ID to HMI Preset List ID [Bank]*/
			tU8 u8HMIListID = (tU8)oGetADR3ToMidwTunerPresetListID(u16ADRListID);
			oStatusMsg.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListID;
			
			tU8 u8Index = 1;
			for( tU16 unElement = (tU16)enCM_PresetList_idx_Data ; u8Index <= u8NoOfPresets; unElement = (tU16)( unElement + ((tU16)enCM_PresetList_len_Data)), u8Index++)
			{
				/** Function call to create a preset list element */
				vCreatePresetListElement(oStatic_ListElem,u8HMIListID,u8Index,&pu8Message[unElement]);

				oStatusMsg.Tun_StaticListElements.TunerStaticListElement.push_back(oStatic_ListElem);

				/** Traces to print list element */
				ETG_TRACE_USR1((  " tun_MsgToHMI::vHandle_r_CM_AtPresetList(), HMIListID=%d, Element=%d, u32Freq=%d kHz, PI=0x%04X"
					,oStatic_ListElem.e8ListID.enType
					,oStatic_ListElem.u8ElementID
					,oStatic_ListElem.u32Frequency
					,oStatic_ListElem.u16PI
					));

				ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_CM_AtPresetList(), Selected=%d, \
								  SendernameInfo=%d, PTY=%d, TpTmcInfo=0x%02X, LevelCompensation = %d"
					,oStatic_ListElem.bSelected
					,ETG_CENUM( tenCM_StationsListSendernameInfo, oStatic_ListElem.e8SendernameInfo.enType)
					,oStatic_ListElem.u32PTY
					,oStatic_ListElem.u8TpTmcInfo
					,oStatic_ListElem.s8LevelCompensation
				));

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
				ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_CM_AtPresetList(), e8Modulation=%d, \
								  u32HDStationId_DRMServiceId=0x%08x, e8HDTextEncoding=%d, u8HDStationGenre_DRMPty = %d,\
								  u8HDAudioProgram_DRMShortID = %d, sHDCallSign_DRMServiceLabel=%s"
					,oStatic_ListElem.e8Modulation.enType//ETG_CENUM( midw_fi_tcl_e8_Tun_ModulationType::tenType, oStatic_ListElem.e8Modulation.enType)
					,oStatic_ListElem.u32HDStationId_DRMServiceId
					,oStatic_ListElem.e8HDTextEncoding.enType//ETG_CENUM( midw_fi_tcl_e8_Tun_HD_TextEncodingType::tenType, oStatic_ListElem.e8HDTextEncoding.enType)
					,oStatic_ListElem.u8HDStationGenre_DRMPty
					,oStatic_ListElem.u8HDAudioProgram_DRMShortID
					,oStatic_ListElem.sHDCallSign_DRMServiceLabel.szGet(midw_fi_tclString::FI_EN_UTF8)
				));

#endif



				ETG_TRACE_USR2((  " tun_MsgToHMI::vHandle_r_CM_AtPresetList(), StationLogo=%s"
					,oStatic_ListElem.StationLogo.szGet(midw_fi_tclString::FI_EN_UTF8)
				));

			}

			vSendMessage( pNot->u16AppID,
				oStatusMsg,
				MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST,
				AMT_C_U8_CCAMSG_OPCODE_STATUS,
				pNot->u16CmdCounter,
				pNot->u16RegisterID);

		}

        }
        
		/** Function call to send Preset handling method result */
		vSendPresetHandlingMethodResult(pu8Message,u8NoOfPresets);

		ahl_bReleaseCritical(m_hNotHMITableSem);
	

	/** Check if autostore mthd result is to be sent */
	if(m_bSendAutostoreMthdResult)
	{
		/** Send success method result */
		vSendAutostoreMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED,\
			AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
		/** make the variable false as method result is already sent above. */
		m_bSendAutostoreMthdResult = false;

	}

	ETG_TRACE_USR4(( " tun_MsgToHMI::u8UpdateMethodResultStatus : END"));
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vCreatePresetListElement( )
* 
* DESCRIPTION:  Create a list element to get added to preset list
*
* PARAMETER:    midw_fi_tcl_TunerStaticListElement &oStatic_ListElem, 
*				tU8 u8HMIListID, tU8 u8Index, const tU8* pu8Message,
*
* RETURNVALUE:  void
*Date: 30.1.2014 vnd4kor
*************************************************************************/
tVoid tun_MsgToHMI::vCreatePresetListElement(midw_fi_tcl_TunerStaticListElement &oStatic_ListElem, \
											 tU8 u8HMIListID, tU8 u8Index, const tU8* pu8Message)

{
	if(( m_potun_Utility == NULL) ||\
	( m_potun_HMIManager == NULL) ||
	(pu8Message == NULL)
	)
	{
		TUN_ASSERT_RETURN( m_potun_Utility != NULL);
		TUN_ASSERT_RETURN(m_potun_HMIManager != NULL);
		TUN_ASSERT_RETURN(pu8Message != NULL);
		return;
	}

	/** Preset Bank  */
	oStatic_ListElem.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)u8HMIListID;
	/** Element index */
	oStatic_ListElem.u8ElementID = u8Index;
	/** Preset select Status : Selected / Not Seleceted */
	oStatic_ListElem.bSelected = pu8Message[enCM_PresetList_idx_Selected ];
	/** Frequency */
	oStatic_ListElem.u32Frequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[enCM_PresetList_idx_Frequency ] );

	/** PS name */
	midw_fi_tclString sUtf8String ;
	m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[enCM_PresetList_idx_Sendername ],&sUtf8String/* oStationDataStatusMsg.TunerStationData.sPSName*/) ;
	oStatic_ListElem.sPSName.bSet( sUtf8String ,midw_fi_tclString::FI_EN_UTF8);

	/** Sender name info */
	oStatic_ListElem.e8SendernameInfo.enType = (midw_fi_tcl_e8_Tun_SendernameInfo::tenType)pu8Message[enCM_PresetList_idx_StationNameInfo ];
	/** PI  */
	oStatic_ListElem.u16PI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Message[enCM_PresetList_idx_PI ]);
	/** TpTmcInfo */
	oStatic_ListElem.u8TpTmcInfo = pu8Message[enCM_PresetList_idx_TpTmcInfo ];
	/** PTY31 */
	oStatic_ListElem.u32PTY = pu8Message[enCM_PresetList_idx_PTY ];
	/** Level Compenstation */
	oStatic_ListElem.s8LevelCompensation = (tS8)pu8Message[enCM_PresetList_idx_Level_Comp ];

	
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20	
	/** Digital Modulation */
	oStatic_ListElem.e8Modulation.enType = (midw_fi_tcl_e8_Tun_ModulationType::tenType)pu8Message[enCM_PresetList_idx_DigitalModulation ];

	/** u32HDStationId_DRMServiceId */
	oStatic_ListElem.u32HDStationId_DRMServiceId = m_potun_Utility->u32Convert4SeparateBytesTo32Bit( &pu8Message[enCM_PresetList_idx_HDStationId_or_DRMServiceId ]);

	/** sHDCallSign_DRMServiceLabel */
	m_potun_HMIManager -> vConvertRTextTotString(&pu8Message[enCM_PresetList_idx_HDCallSign_or_DRMServiceLabel ],&sUtf8String,enCM_PresetList_len_HDCallSign_or_DRMServiceLabel) ;
	oStatic_ListElem.sHDCallSign_DRMServiceLabel.bSet( sUtf8String ,midw_fi_tclString::FI_EN_UTF8);

	/** e8HDTextEncoding */
	oStatic_ListElem.e8HDTextEncoding.enType = (midw_fi_tcl_e8_Tun_HD_TextEncodingType::tenType)pu8Message[enCM_PresetList_idx_HdtextEncoding ];
	
	/** HDStationGenre_or_DRMPty */
	oStatic_ListElem.u8HDStationGenre_DRMPty = pu8Message[enCM_PresetList_idx_HDStationGenre_or_DRMPty ];

	/** HDProgramNumber / DRMServiceShortId */
	oStatic_ListElem.u8HDAudioProgram_DRMShortID = pu8Message[enCM_PresetList_idx_HDProgramNumber_or_DRMServiceShortId ];
	



#endif

	if(oStatic_ListElem.u16PI != 0)
	{
		
		vGetStationLogoPath(oStatic_ListElem.u16PI, sUtf8String);
	  oStatic_ListElem.StationLogo.bSet( sUtf8String,midw_fi_tclString::FI_EN_UTF8);
	}

}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSendPresetHandlingMethodResult( )
* 
* DESCRIPTION:  Send Preset Handling method result
*
* PARAMETER:    tun_tPresetHandlingCmdState e8CommandState, 
*				const tU8* pu8Message, tU8 u8NoOfPresets
*
* RETURNVALUE:  void
*
* AUTHOR:		vnd4kor(ECG) 31.1.2014
*************************************************************************/
tVoid tun_MsgToHMI::vSendPresetHandlingMethodResult(const tU8* pu8Message, tU8 u8NoOfPresets)
{
	/** Since method calls will submitted serialy, The 1st status that 
	arrives will be for the 1st method start. Hence 1st element in list 
	determines the type of preset handling action performed*/


	TUN_ASSERT_RETURN( m_potun_MsgToADR != NULL);
	
	/** Get the iterator to first element of preset action list */
	iteratorPresetAction ActionIterator = m_potun_MsgToADR->\
		m_listPresetAction.begin();

	/** Create MethodResult Object */
	midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult  oResponse ;

	if(ActionIterator == m_potun_MsgToADR->m_listPresetAction.end())
	{
		ETG_TRACE_USR2((  " tun_MsgToHMI::vSendPresetHandlingMethodResult() : \
						  Preset Request Handling List EMPTY"));

		return;
	}


	ETG_TRACE_USR2((  " tun_MsgToHMI::vSendPresetHandlingMethodResult() : \
					  Preset Action: %d, u8ListElementId = %d, u8NoOfPresets = %d",
					  ActionIterator->u8Action,ActionIterator->u8ListElement,u8NoOfPresets));

	/** Check to see if request is for Get preset list, if so then do not
	send method result*/
	if(GET_ALL_ELEMENTS != ActionIterator->u8Action )
	{
		/** Copy action of first element to method response msg  */
		oResponse.e8Action.enType = \
			(midw_fi_tcl_e8_Tun_PresetAction::tenType)ActionIterator->u8Action;

				/** Update method response status : FAIL / SUCCESS */
		oResponse.TunerServer_StatusResponse.u8TunerStatus.enType =\
				(midw_fi_tcl_e8_Tun_ResponseStatus::tenType)u8ReturnMethodResultStatus(\
				*(ActionIterator),\
				pu8Message,\
				u8NoOfPresets);
		
		/* Current Tuner state -> Not required for client. NORAL added as default.*/
		oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
			midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

	
		/*------------------------------
		 Send the response to client.
		------------------------------*/
		vSendMessage( CCA_C_U16_APP_TUNERMASTER,
			oResponse,
			MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING,
			AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
			ActionIterator->u16CmdCounter,
			poGWMain->u16GetRegID_TM()
			);

	}

	/** Delete the first element from list as the response is being sent to it */
	m_potun_MsgToADR->m_listPresetAction.erase(ActionIterator);

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSendAutostoreMethodResult( )
* 
* DESCRIPTION:  Send Autostore method result
*
* PARAMETER:    midw_fi_tcl_e8_Tun_ResponseStatus e8MthdRsltstatus, tU8 u8Opcode
*
* RETURNVALUE:  void
*
* AUTHOR:		vnd4kor(ECG) 30.1.2014
*************************************************************************/
tVoid tun_MsgToHMI::vSendAutostoreMethodResult( midw_fi_tcl_e8_Tun_ResponseStatus::tenType e8MthdRsltStatus, tU8 u8Opcode)
{
	/**create object of autostore methodresult*/
	midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult oResponseAuto;

	// Response -> SUCC / FAIL / BUSY
	oResponseAuto.TunerServer_StatusResponse.u8TunerStatus.enType =\
		e8MthdRsltStatus;

	// Current Tuner state -> Not required for client. NORAL added as default.
	oResponseAuto.TunerServer_StatusResponse.u8TunerState.enType =\
		midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;


	//------------------------------
	// Send the response to client.
	//------------------------------
	vSendMessage( CCA_C_U16_APP_TUNERMASTER, /**poMessage->u16GetSourceAppID()*/
		oResponseAuto,
		MIDW_TUNERFI_C_U16_FID_TUN_S_AUTOSTORE,
		u8Opcode,
		u16GetCmdCtrForAutostore(), /**u16GetCmdCtrForAutostore()*/
		poGWMain->u16GetRegID_TM() /**poGWMain->u16GetRegID_TM()*/
		);

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::u8ReturnMethodResultStatus( )
* 
* DESCRIPTION:  Return Method Result status : FAIL / SUCCESS
*
* PARAMETER:    PresetHandlingData data,const tU8* pu8Message, tU8 u8NoOfPresets
*
* RETURNVALUE:  tU8
*
* AUTHOR:		vnd4kor(ECG) 10.9.2013
*************************************************************************/
tU8 tun_MsgToHMI ::u8ReturnMethodResultStatus(PresetHandlingData data,const tU8* pu8Message, tU8 u8NoOfPresets)
{
	if((m_potun_Utility == NULL) || (u8NoOfPresets == 0))
	{
		return (tU8)FI_EN_TUN_RES_REQ_FAIL;
	}

	tU8 u8ReturnValue = (tU8)FI_EN_TUN_RES_REQ_FAIL;

	switch(data.u8Action)
	{
	case RECALL_ELEMENT:
		{
			tU8 u8Index = 1 ;
			tU16 u16ElementPos;
			/** iterate till the element is found in pu8Message */
			for(u16ElementPos = (tU16)enCM_PresetList_idx_Data; ((u8Index != data.u8ListElement) && (u8Index < u8NoOfPresets)); u16ElementPos = (tU16)(u16ElementPos + ((tU16)enCM_PresetList_len_Data)), u8Index++)
			{
			}
			
			/** Check if element is selected */
			if(1 == pu8Message[(tU16)enCM_PresetList_idx_Selected + u16ElementPos])
			{
				u8ReturnValue = (tU8)FI_EN_TUN_RES_REQ_SUCCEED;
			}
		
	
		}
		break;
	case SAVE_ELEMENT:
		{
			
			/** Check if element is selected */
			if( (data.u8ListElement == pu8Message[enCM_PresetList_idx_PosX])
				&&
				(1 == pu8Message[(tU8)enCM_PresetList_idx_Selected + (tU8)enCM_PresetList_idx_Data])
				)
			{
				u8ReturnValue =  (tU8)FI_EN_TUN_RES_REQ_SUCCEED;
			}
		
		}
		break;
	case DELETE_ONE_ELEMENT:
		{		
			/** Check if frequency is ZERO */
			u8ReturnValue  = (0 == m_potun_Utility->u32Convert4SeparateBytesTo32Bit(&pu8Message[enCM_PresetList_idx_Data])) ?
									(tU8)FI_EN_TUN_RES_REQ_SUCCEED : (tU8)FI_EN_TUN_RES_REQ_FAIL;
			
		}
		break;
	case DELETE_ALL_ELEMENTS:
		{
			tU8 u8Index = 1 ;
			tU16 u16ElementPos ;
			/** iterate till the last element in pu8Message */
			for(u16ElementPos = (tU16)enCM_PresetList_idx_Data; (u8Index <= u8NoOfPresets); u16ElementPos = (tU16)(u16ElementPos +((tU16)enCM_PresetList_len_Frequency)), u8Index++)
			{
				/** Check if all frequencies are zero */
				if(0 != m_potun_Utility->u32Convert4SeparateBytesTo32Bit(&pu8Message[u16ElementPos]))
				{
					break;
				}

			}

			/** Check to see if entire array is parsed */
			u8ReturnValue = (u8Index > u8NoOfPresets )? (tU8)FI_EN_TUN_RES_REQ_SUCCEED : (tU8)FI_EN_TUN_RES_REQ_FAIL;
		}
		break;
	default:
		{
			ETG_TRACE_USR4(( " tun_MsgToHMI::u8UpdateMethodResultStatus,\
									 u8Action  : Invalid Input "));
			u8ReturnValue =  (tU8)FI_EN_TUN_RES_REQ_FAIL;
		}
	}

	ETG_TRACE_USR4(( " tun_MsgToHMI::vSendPresetHandlingMethodResult : Method Result : %d",\
		ETG_CENUM(T_e8_TunerResponseStatus,u8ReturnValue)));


	return u8ReturnValue;

}


/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_ATPresetListSetActive( )
* 
* DESCRIPTION:  Handles CM_ATPresetListSetActive Result, and sends method result
*
* PARAMETER:    const tU8* pu8Message
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 16.9.2013
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_ATPresetListSetActive()
{



	ETG_TRACE_USR1(("tun_MsgToHMI::vHandle_r_CM_ATPresetListSetActive :-> Entered"));

    TUN_ASSERT_RETURN( m_potun_MsgToADR != NULL);
		
		/** Send method result */
		midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult oResponse;

		vUpdatePresetListID_DP(u16GetListIDForSetActivePresetList());
		/** Get the Preset list in order to update the HMI */
		m_potun_MsgToADR->vGetPresetList(u16GetListIDForSetActivePresetList());

		/** Update method response status : SUCCESS */
		oResponse.TunerServer_StatusResponse.u8TunerStatus.enType = (midw_fi_tcl_e8_Tun_ResponseStatus::tenType)FI_EN_TUN_RES_REQ_SUCCEED;
		
		// Current Tuner state -> Not required for client. NORAL added as default.
		oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
			midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

		MsgData rSetActivePresetListMsgData = rGetMsgDataForSetActivePresetList();
		//------------------------------
		// Send the response to client.
		//------------------------------
		vSendMessage( rSetActivePresetListMsgData.u16AppID,
			oResponse,
			MIDW_TUNERFI_C_U16_FID_TUN_S_SET_ACTIVE_PRESETLIST,
			AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
			rSetActivePresetListMsgData.u16CmdCounter,       // Command Counter
			rSetActivePresetListMsgData.u16RegID        // RegID
			);
	
}


/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_EngineeringParameter( )
* 
* DESCRIPTION:  Handles CM_EngineeringParameter Status and sends it to client 
*
* PARAMETER:    const tU8* pu8Message
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 7.10.2013
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_EngineeringParameter(const tU8* pu8Message)
{
	TUN_ASSERT_RETURN( pu8Message != NULL);
	TUN_ASSERT_RETURN( m_poHMINotTable != NULL);
	TUN_ASSERT_RETURN( m_potun_Utility != NULL);

	/** Create status msg to send to client */
	midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus oStatusMsg;

	oStatusMsg.e8ParameterID.enType = \
		midw_fi_tcl_e8_Tun_Engg_Param_ID::FI_EN_INVALID_TYPE;
	/*------------------------*/
	/* Fill in the message    */
	/*------------------------*/  

	/** Check for valid param Id to avoid reset */
	if(pu8Message[enCM_SetEnggParam_idx_ParameterId] <= \
		(tU8)midw_fi_tcl_e8_Tun_Engg_Param_ID::FI_EN_BACKGROUND_SCAN_ACTIVITY)
	{
		oStatusMsg.e8ParameterID.enType = (midw_fi_tcl_e8_Tun_Engg_Param_ID::tenType)\
			pu8Message[enCM_SetEnggParam_idx_ParameterId]; 

	}
	else if(pu8Message[enCM_SetEnggParam_idx_ParameterId] == \
		(tU8)midw_fi_tcl_e8_Tun_Engg_Param_ID::FI_EN_SELECT_ALL_PARAMETERS)
	{
		oStatusMsg.e8ParameterID.enType = (midw_fi_tcl_e8_Tun_Engg_Param_ID::tenType)\
			pu8Message[enCM_SetEnggParam_idx_ParameterId];

		midw_fi_tcl_Tun_Engg_Param_List_Elem oListElem;

		for(tU8 i = 0; i <= (tU8)midw_fi_tcl_e8_Tun_Engg_Param_ID::FI_EN_BACKGROUND_SCAN_ACTIVITY; i++)
		{
			oListElem.e8ParameterID.enType = (midw_fi_tcl_e8_Tun_Engg_Param_ID::tenType)i;

			/** Extract the Param value */
			oListElem.u32ParameterValue = m_potun_Utility->u32Convert4SeparateBytesTo32Bit\
				(&pu8Message[(tU8)enCM_SetEnggParam_idx_ParameterValue + (i * (tU8)enCM_SetEnggParam_len_ParameterValue)]);

			/** Push the value in list */
			oStatusMsg.ListOfEnggParamValues.push_back(oListElem);

			/** Print trace */
			ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_EngineeringParameter() -> Param = %d, Value = %d",\
				oStatusMsg.ListOfEnggParamValues[i].e8ParameterID.enType,
				oStatusMsg.ListOfEnggParamValues[i].u32ParameterValue));
		}
	}


	/** Value assigned to parameter */
	/** The param value sholud be ignored if ParamID = 255 */
	oStatusMsg.u32ParameterValue = m_potun_Utility->u32Convert4SeparateBytesTo32Bit\
		(&pu8Message[enCM_SetEnggParam_idx_ParameterValue]);


	ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_EngineeringParameter() -> Param = %d, Value = %d",\
		oStatusMsg.e8ParameterID.enType,
		(tS32)(oStatusMsg.u32ParameterValue)));


	ahl_bEnterCritical( m_hNotHMITableSem );

	for(ahl_tNotification* pNot =
		m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ENGG_PARAMETER);
		pNot != OSAL_NULL;
	pNot=pNot->pNext
		)
	{
		vSendMessage ( pNot->u16AppID,
			oStatusMsg,
			MIDW_TUNERFI_C_U16_FID_TUN_G_SET_ENGG_PARAMETER,
			AMT_C_U8_CCAMSG_OPCODE_STATUS,
			pNot->u16CmdCounter,
			pNot->u16RegisterID );

	} /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
	  pNot != OSAL_NULL; pNot=pNot->pNext) */

	ahl_bReleaseCritical(m_hNotHMITableSem);
}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_TuningActionConfiguration( )
* 
* DESCRIPTION:  Handles CM_TuningActionConfiguration Status and sends it to client
*
* PARAMETER:    const tU8* pu8Message
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 9.10.2013
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_TuningActionConfiguration(const tU8* pu8Message)
{

	if((pu8Message == NULL)||( m_poHMINotTable == NULL )
		)
	{
			NORMAL_M_ASSERT( pu8Message != NULL );
			NORMAL_M_ASSERT( m_poHMINotTable != NULL );
		return;
	}

	ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_r_CM_TuningActionConfiguration()"));


	ahl_bEnterCritical( m_hNotHMITableSem );

	for(ahl_tNotification* pNot =
		m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_SET_TUNING_ACTION_CONFIG);
		pNot != OSAL_NULL;
	pNot=pNot->pNext
		)
	{

		/** Create status msg to send to client */
		midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus oStatusMsg;

		/** Create midw_fi_tcl_TuningActionConfigParam obj to hold one element  */
		midw_fi_tcl_TuningActionConfigParam oTuningActionConfigParam;

		/*------------------------*/
		/* Fill in the message    */
		/*------------------------*/  

		/** Array Indexing parameter */
		tU8 u8TunConfigParameterValueOffset = (tU8)enCM_TuningActionConfiguration_idx_Data;
		
		/** Check if all params selected */
		if(pu8Message[enCM_TuningActionConfiguration_idx_PosX] == \
			(tU8)TAC_AllParameters)
		{

			/** Iterate untill all elements are fetched from array */
			for(tU8 u8Index = 1; u8Index <= (tU8)TAC_ScrollingPSDetectionTimer ; u8Index++)
			{
				vCreateTuningActionConfigParam(pu8Message,\
					u8TunConfigParameterValueOffset,\
					u8Index,\
					&oTuningActionConfigParam);

				ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_TuningActionConfiguration() -> ConfigParam = %d, Value = %d",\
				oTuningActionConfigParam.e8ConfigParamType.enType,
				oTuningActionConfigParam.u32ConfigParamValue));

				/** Push Element in list */
				oStatusMsg.ListOfTuningActionConfigParameters.push_back(oTuningActionConfigParam);	

			}
		}
		else
		{
			/** Fetch element details and fill the object oTuningActionConfigParam */
			vCreateTuningActionConfigParam(pu8Message,\
					u8TunConfigParameterValueOffset,\
					pu8Message[enCM_TuningActionConfiguration_idx_PosX],\
					&oTuningActionConfigParam);

			
			ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_TuningActionConfiguration() -> ConfigParam = %d, Value = %d",\
				oTuningActionConfigParam.e8ConfigParamType.enType,
				oTuningActionConfigParam.u32ConfigParamValue));

			/** Push the element in list */
			oStatusMsg.ListOfTuningActionConfigParameters.push_back(oTuningActionConfigParam);
		}


		

		/* send msg to the client  */
		vSendMessage ( pNot->u16AppID,
			oStatusMsg,
			MIDW_TUNERFI_C_U16_FID_TUN_G_SET_TUNING_ACTION_CONFIG,
			AMT_C_U8_CCAMSG_OPCODE_STATUS,
			pNot->u16CmdCounter,
			pNot->u16RegisterID );

	} /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
	  pNot != OSAL_NULL; pNot=pNot->pNext) */

	ahl_bReleaseCritical(m_hNotHMITableSem);
}


/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vCreateTuningActionConfigParam( )
* 
* DESCRIPTION:  Creates TuningActionConfig object from pu8Message data
*
* PARAMETER:    const tU8* pu8Message,
				tU8 &u8TunConfigParameterValueOffset,
				tU8 u8ParamId,
				midw_fi_tcl_TuningActionConfigParam* oTuningActionConfigParam
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 9.10.2013
*************************************************************************/
tVoid tun_MsgToHMI::vCreateTuningActionConfigParam(\
				const tU8* pu8Message,\
				tU8 &u8TunConfigParameterValueOffset,\
				tU8 u8ParamId,\
				midw_fi_tcl_TuningActionConfigParam* oTuningActionConfigParam) const
{
	TUN_ASSERT_RETURN( m_potun_Utility != NULL);
		
	/** Assign Parameter ID */
	oTuningActionConfigParam->e8ConfigParamType.enType = \
					(midw_fi_tcl_e8_Tun_ConfigParam_Type::tenType)u8ParamId;

	switch(u8ParamId)
				{
				case TAC_PTYFilter:
					{
						/** Fetch 4 bytes of data */
						oTuningActionConfigParam->u32ConfigParamValue = \
							m_potun_Utility->u32Convert4SeparateBytesTo32Bit\
							(&pu8Message[u8TunConfigParameterValueOffset]);

						/** Increment indexing param by 4 */
						u8TunConfigParameterValueOffset = \
								(tU8)(u8TunConfigParameterValueOffset + ((tU8)enCM_TuningActionConfiguration_len_PTYFilterData));
					}
					break;
				case TAC_AutoSeekStepDelay:
				case TAC_ManualStepDelay:
					{
						/** Fetch 2 bytes of data */
						oTuningActionConfigParam->u32ConfigParamValue = \
							m_potun_Utility->u16Convert2SeparateBytesTo16Bit\
							(&pu8Message[u8TunConfigParameterValueOffset]);

						/** Increment indexing param by 2 */
						u8TunConfigParameterValueOffset = \
								(tU8)( u8TunConfigParameterValueOffset + ((tU8)enCM_TuningActionConfiguration_len_AutoSeekStepDelayData));

					}
					break;
				default:
					{
						/** Fetch 1 bytes of data */
						oTuningActionConfigParam->u32ConfigParamValue = \
							pu8Message[u8TunConfigParameterValueOffset];

						/** Increment indexing param by 1 */
						u8TunConfigParameterValueOffset = \
								(tU8)( u8TunConfigParameterValueOffset + ((tU8)enCM_TuningActionConfiguration_len_data));

					}
					break;
				}

}
/*************************************************************************
* FUNCTION:     vClearAnnoMessage
* DESCRIPTION:  Clear Announcement Message if service becomes unavailable
* PARAMETER:    None
* RETURNVALUE:  tVoid
* AUTHOR:		gds5kor
*************************************************************************/
tVoid tun_MsgToHMI::vClearAnnoMessage()
{
	m_u8AnnoMessage = 0;
	#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
	   m_u8BGAnnoMessage = 0;
      m_enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_PTY_OFF;
	#endif
}

/*************************************************************************
* FUNCTION:     vOnTunerStateChanged
* DESCRIPTION:  Update m_u8TunerState
* PARAMETER:    tU8
* RETURNVALUE:  tVoid
* AUTHOR:		
*************************************************************************/
tVoid tun_MsgToHMI::vOnTunerStateChanged(tU8 u8TunerState)
{
	m_u8TunerState = u8TunerState;
}

/*************************************************************************
* FUNCTION:     vHandle_r_CM_AnnouncementSwitch( )
* 
* DESCRIPTION:  Send Announcement switch (TP/PTY) status (ON/OFF) to client
*
* PARAMETER:    const tU8* pu8Message,
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 28.10.2013
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_AnnouncementSwitch(const tU8* pu8Message)
{
  if(( m_poHMINotTable == NULL))
  {
    NORMAL_M_ASSERT( m_poHMINotTable != NULL );
    return ;
  } 



	  /** state of switches to be saved to avoid overwriting of the
		switches while setting*/
		m_u8AnnoSwitchState = pu8Message[enAdrMsgOffset_DATA];

	  ahl_bEnterCritical( m_hNotHMITableSem );

	  ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementSwitch() "));

	  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_SWITCH) ;\
	            pNot != OSAL_NULL; pNot=pNot->pNext)
	  {

	    /*-----------------------------------------------------*/
	    /* Create status message to send to client             */
	    /*-----------------------------------------------------*/

	    midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus oAnnoSwitch;


		/** extract TP switch status from the m_u8AnnoSwitchState */
		oAnnoSwitch.bTPState = ((m_u8AnnoSwitchState & (tU8)enAnnoSwitchTPMask) && (tU8)enAnnoSwitchTPMask);

		/** extract PTY switch status from the m_u8AnnoSwitchState */
		oAnnoSwitch.bPTYState = ((m_u8AnnoSwitchState & (tU8)enAnnoSwitchPTY31Mask) && (tU8)enAnnoSwitchPTY31Mask);

		oAnnoSwitch.bWeatherAlertState = ((m_u8AnnoSwitchState & (tU8)enWeatherAlertMask) && (tU8)enWeatherAlertMask);
		ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementMessage() , bTPState = %d "\
			"bPTYState = %d bWeatherAlertState = %d\n",oAnnoSwitch.bTPState,oAnnoSwitch.bPTYState,oAnnoSwitch.bWeatherAlertState));



	    vSendMessage ( pNot->u16AppID,
	                   oAnnoSwitch,
	                   MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_SWITCH,
	                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
	                   pNot->u16CmdCounter,
	                   pNot->u16RegisterID );

	  }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
  ahl_bReleaseCritical(m_hNotHMITableSem);  


}


/*************************************************************************
* FUNCTION:     vHandle_r_CM_AnnouncementMessage( )
* 
* DESCRIPTION:  Send TA/EON-TA/PTY Announcement ON/OFF message to client
*
* PARAMETER:    const tU8* pu8Message,
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 28.10.2013
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_AnnouncementMessage( const tU8* pu8Message)
{
  if( m_poHMINotTable == NULL) 
  {
    NORMAL_M_ASSERT( m_poHMINotTable != NULL );
    return ;
  } 
  ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementMessage() "));	
  if(m_potun_MsgToADR->bGetTestModeActivity() == true)
  {
	  ETG_TRACE_USR4(("tun_MsgToHMI::vHandle_r_CM_AnnouncementMessage() Test mode is active"));
	  return;
  }
  midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus oAnnoMsg;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
  if((pu8Message[enAdrMsgOffset_INSTANCE_ID]) == 0xff)
  {
     m_u8BGAnnoMessage = pu8Message[enAdrMsgOffset_DATA];
  }
  else
  {
     m_u8AnnoMessage = pu8Message[enAdrMsgOffset_DATA];
  }
  if(m_enAnnoMsg == enGetAnnouncementMessage((m_u8BGAnnoMessage | m_u8AnnoMessage)))
  {
     ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementMessage()-> Repeated announ msg skipped"));
     return;
  }
  m_enAnnoMsg = enGetAnnouncementMessage((m_u8BGAnnoMessage | m_u8AnnoMessage));
  oAnnoMsg.e8AnnoMessage = m_enAnnoMsg;
#else
  m_u8AnnoMessage = pu8Message[enAdrMsgOffset_DATA];
  oAnnoMsg.e8AnnoMessage = enGetAnnouncementMessage(m_u8AnnoMessage);
#endif
  ahl_bEnterCritical(m_hNotHMITableSem);
  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE) ;\
            pNot != OSAL_NULL; pNot=pNot->pNext)
  {      

	ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementMessage(), e8AnnoMessage = %d,\
					received data = %d",oAnnoMsg.e8AnnoMessage.enType, \
					pu8Message[enAdrMsgOffset_DATA]
					));

	vSendMessage ( pNot->u16AppID,
				   oAnnoMsg,
				   MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE,
				   AMT_C_U8_CCAMSG_OPCODE_STATUS,
				   pNot->u16CmdCounter,
				   pNot->u16RegisterID );
  }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
  ahl_bReleaseCritical(m_hNotHMITableSem);
}

/*************************************************************************
* FUNCTION:     u8GetAnnouncementMessage( )
*
* DESCRIPTION:  Extract TA/EON-TA/PTY Announcement ON/OFF
*
* PARAMETER:    u8AnnoMsg
*
* RETURNVALUE:  tU8
*
* AUTHOR:
*************************************************************************/
midw_fi_tcl_e8_Anno_Message tun_MsgToHMI::enGetAnnouncementMessage( tU8 u8AnnoMsg)
{
	ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_AnnouncementMessage() "));
	midw_fi_tcl_e8_Anno_Message enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_PTY_OFF;
	/*Bit0: TA Bit1: EON TA Bit2: PTY31*/
	switch(u8AnnoMsg)
	{
	case 0:
		/** both TA and PTY are OFF then e8AnnoMessage = 0x00 */
	   enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_PTY_OFF;
		break;
	case 1:
	case 2:
	case 3:
		/** If TA or EON-TA or both are ON then e8AnnoMessage = 0x01 (TA bit = ON) */
	   enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_ON_PTY31_OFF;
		break;
	case 4:
		/** IF only PTY is ON then b8AnnoMessage =0x02 (PTY bit ON)*/
	   enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_PTY31_ON_TA_OFF;
	break;
	case 5:
	case 6:
	case 7:
      enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_ON_PTY31_ON;
   break;
   case 8:
      enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_OFF_PTY31_OFF_WEATHERALERT_ON;
	break;
   case 9:
   case 10:
   case 11:
      enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_ON_PTY31_OFF_WEATHERALERT_ON;
   break;
   case 12:
      enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_OFF_PTY31_ON_WEATHERALERT_ON;
   break;
   case 13:
   case 14:
   case 15:
      enAnnoMsg = midw_fi_tcl_e8_Anno_Message::FI_EN_TA_ON_PTY31_ON_WEATHERALERT_ON;
   break;
	default:
		ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_AnnouncementMessage(), invalid "));
		break;

	}
	return enAnnoMsg;

}

/*************************************************************************
* FUNCTION:     vHandle_r_CM_AnnouncementInfo( )
* 
* DESCRIPTION:  Send data related to announcement station currently received
*				to client
*
* PARAMETER:    const tU8* pu8Message,
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 28.10.2013
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_AnnouncementInfo( const tU8* pu8Message )
{

  if(( NULL == m_poHMINotTable ) || (NULL == m_potun_HMIManager)\
	  || (NULL == m_potun_Utility))
  {
    NORMAL_M_ASSERT( m_poHMINotTable != NULL );
    NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
    NORMAL_M_ASSERT( m_potun_Utility != NULL );
    return ;
  } 


  ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementInfo() "));	


  ahl_bEnterCritical( m_hNotHMITableSem );

  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO) ;\
            pNot != OSAL_NULL; pNot=pNot->pNext)
  {      

    /*-----------------------------------------------------*/
    /* Create status message to send to client             */
    /*-----------------------------------------------------*/

    midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus oAnnoInfo;

	/** Fill msg data  */
	oAnnoInfo.AnnoInfoStatus.u32Frequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit\
										(&pu8Message[enCM_AnnouncementInfo_Frequency]);
	oAnnoInfo.AnnoInfoStatus.u16PI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit\
										(&pu8Message[enCM_AnnouncementInfo_PI]);

	/* name is copied in UTF format here */
    midw_fi_tclString sUtf8String ;
    m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[enCM_AnnouncementInfo_StationName],&sUtf8String) ;
    oAnnoInfo.AnnoInfoStatus.sAnnoStationName.bSet( sUtf8String ,
                             midw_fi_tclString::FI_EN_UTF8);

    if(oAnnoInfo.AnnoInfoStatus.u32Frequency == u32GetAtStaInfoFreq())
    {
        oAnnoInfo.AnnoInfoStatus.u8Quality = u8GetAtStaInfoQuality();
    }
	oAnnoInfo.b8AnnoTypes.u8Value = u8Getmidw_fi_tcl_b8_Anno_Message(pu8Message[enCM_AnnouncementInfo_AnnoType]);

	ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_AnnouncementInfo(), u32Frequency = %d,\
					u16PI= %04x, u8Quality =%d, AnnoType = %d",\
					oAnnoInfo.AnnoInfoStatus.u32Frequency,\
					oAnnoInfo.AnnoInfoStatus.u16PI,\
					oAnnoInfo.AnnoInfoStatus.u8Quality,\
					oAnnoInfo.b8AnnoTypes.u8Value));	

	
    ETG_TRACE_USR2((" Stationname = %8s"\
              , (const tChar*)&pu8Message[ enCM_AnnouncementInfo_StationName]\
			  ));

    // When BG tuner TP gets lost, the TP status was never updated to clients. 
   // if(!(oAnnoInfo.AnnoInfoStatus.u32Frequency == 0 && oAnnoInfo.AnnoInfoStatus.u16PI == 0))
    {
    vSendMessage ( pNot->u16AppID,
                   oAnnoInfo,
                   MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   pNot->u16CmdCounter,
                   pNot->u16RegisterID );
    }

  }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
  ahl_bReleaseCritical(m_hNotHMITableSem);

  vSetAnnoInfoFreq(m_potun_Utility->u32Convert4SeparateBytesTo32Bit\
										(&pu8Message[enCM_AnnouncementInfo_Frequency]));

  m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[enCM_AnnouncementInfo_StationName],&m_utf8StringPSName);
  vSetAnnoInfoPSName(m_utf8StringPSName);

  vSetAnnoInfoPI(m_potun_Utility->u16Convert2SeparateBytesTo16Bit\
										(&pu8Message[enCM_AnnouncementInfo_PI]));

  vSetAnnoInfoType(pu8Message[enCM_AnnouncementInfo_AnnoType]);

}


/*************************************************************************
* FUNCTION:     vHandle_r_CM_PiPsRelation( )
* 
* DESCRIPTION:  Send PI PS relation status to Client
*
* PARAMETER:    const tU8* pu8Message,
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 11.11.2013
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_PiPsRelation( const tU8* pu8Message)
{
  if(( NULL == m_poHMINotTable ) || (NULL == m_potun_HMIManager)\
	  || (NULL == m_potun_Utility))
  {
    NORMAL_M_ASSERT( m_poHMINotTable != NULL );
    NORMAL_M_ASSERT( m_potun_HMIManager != NULL );
    NORMAL_M_ASSERT( m_potun_Utility != NULL );
    return ;
  } 

  ahl_bEnterCritical( m_hNotHMITableSem );

  ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_PiPsRelation() "));	

  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_PI_PS_RELATION) ;\
            pNot != OSAL_NULL; pNot=pNot->pNext)
  {      

    /*-----------------------------------------------------*/
    /* Create status message to send to client             */
    /*-----------------------------------------------------*/

    midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus oStatusMsg;

	/** Fill msg data  */
	oStatusMsg.u16PI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit\
										(&pu8Message[enCM_PiPsRelation_idx_PI]);

	/* name is copied in UTF format here */
    midw_fi_tclString sUtf8String ;
    m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Message[enCM_PiPsRelation_idx_PSName],&sUtf8String) ;
    oStatusMsg.sPSName.bSet( sUtf8String ,
                             midw_fi_tclString::FI_EN_UTF8);

	ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_PiPsRelation(), \
					u16PI= %04x",\
					oStatusMsg.u16PI));	

	
    ETG_TRACE_USR2((" PSName = %8s"\
              , (const tChar*)&pu8Message[ enCM_PiPsRelation_idx_PSName]\
			  ));

    
    vSendMessage ( pNot->u16AppID,
                   oStatusMsg,
                   MIDW_TUNERFI_C_U16_FID_TUN_G_PI_PS_RELATION,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   pNot->u16CmdCounter,
                   pNot->u16RegisterID );

  }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
  ahl_bReleaseCritical(m_hNotHMITableSem);  

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandle_g_AvailableBandRange( )
* 
* DESCRIPTION:  Send Available Band range to HMI
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 6.1.2014
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_g_AvailableBandRange()
{

  if(( NULL == m_poHMINotTable ) || ( NULL == m_poclConfigInterface ))
  {
    NORMAL_M_ASSERT( m_poHMINotTable != NULL );
    NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
    return ;
  } 

  ahl_bEnterCritical( m_hNotHMITableSem );

  ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_g_AvailableBandRange() "));	

  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(\
	  MIDW_TUNERFI_C_U16_FID_TUN_G_AVAILABLE_BAND_RANGE) ;\
            pNot != OSAL_NULL; pNot=pNot->pNext)
  {      

    /*-----------------------------------------------------*/
    /* Create status message to send to client             */
    /*-----------------------------------------------------*/

    midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus oStatusMsg;

	/** Fill msg data  */
	tU32 u32AvailBands = m_poclConfigInterface->u32GetConfigData("AvailableBands") ;
	oStatusMsg.u32AvailableBands = u32AvailBands;

	 midw_fi_tcl_AvailableBandInfoElement oAvailableBandInfoElement;


	if(u32AvailBands & TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_FM)
	{
		oAvailableBandInfoElement.e8Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)enBand_FM;
		oAvailableBandInfoElement.u32HighFrequency = m_poclConfigInterface->u32GetConfigData("HighFM");
		oAvailableBandInfoElement.u32LowFrequency = m_poclConfigInterface->u32GetConfigData("LowFM");
		oAvailableBandInfoElement.u16AutoSeekStepWidth = (tU16)m_poclConfigInterface->u32GetConfigData("StepSizeFM");
		oAvailableBandInfoElement.u16ManualStepWidth = (tU16)m_poclConfigInterface->u32GetConfigData("ManualStepSizeFM");

		oStatusMsg.TunerAvailableBandInfoList.AvailableBandInfoElement.push_back(oAvailableBandInfoElement);

		ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_g_AvailableBandRange(), \
					e8Band= %d,u32HighFrequency= %u,u32LowFrequency= %u,u16AutoSeekStepWidth= %d,u16ManualStepWidth= %d",\
					oAvailableBandInfoElement.e8Band.enType,
					oAvailableBandInfoElement.u32HighFrequency,
					oAvailableBandInfoElement.u32LowFrequency,
					oAvailableBandInfoElement.u16AutoSeekStepWidth,
					oAvailableBandInfoElement.u16ManualStepWidth
					));	


	}
	
	if(u32AvailBands & TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_LW)
	{
		oAvailableBandInfoElement.e8Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)enBand_LW;
		oAvailableBandInfoElement.u32HighFrequency = m_poclConfigInterface->u32GetConfigData("HighLW");
		oAvailableBandInfoElement.u32LowFrequency = m_poclConfigInterface->u32GetConfigData("LowLW");
		oAvailableBandInfoElement.u16AutoSeekStepWidth = (tU16)m_poclConfigInterface->u32GetConfigData("StepSizeLW");
		oAvailableBandInfoElement.u16ManualStepWidth = (tU16)m_poclConfigInterface->u32GetConfigData("ManualStepSizeLW");

		oStatusMsg.TunerAvailableBandInfoList.AvailableBandInfoElement.push_back(oAvailableBandInfoElement);

		ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_g_AvailableBandRange(), \
					e8Band= %d,u32HighFrequency= %u,u32LowFrequency= %u,u16AutoSeekStepWidth= %d,u16ManualStepWidth= %d",\
					oAvailableBandInfoElement.e8Band.enType,
					oAvailableBandInfoElement.u32HighFrequency,
					oAvailableBandInfoElement.u32LowFrequency,
					oAvailableBandInfoElement.u16AutoSeekStepWidth,
					oAvailableBandInfoElement.u16ManualStepWidth
					));	

	}
	
	if(u32AvailBands & TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_MW)
	{
		oAvailableBandInfoElement.e8Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)enBand_MW;
		oAvailableBandInfoElement.u32HighFrequency = m_poclConfigInterface->u32GetConfigData("HighMW");
		oAvailableBandInfoElement.u32LowFrequency = m_poclConfigInterface->u32GetConfigData("LowMW");
		oAvailableBandInfoElement.u16AutoSeekStepWidth = (tU16)m_poclConfigInterface->u32GetConfigData("StepSizeMW");
		oAvailableBandInfoElement.u16ManualStepWidth = (tU16)m_poclConfigInterface->u32GetConfigData("ManualStepSizeMW");

		oStatusMsg.TunerAvailableBandInfoList.AvailableBandInfoElement.push_back(oAvailableBandInfoElement);

		ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_g_AvailableBandRange(), \
					e8Band= %d,u32HighFrequency= %u,u32LowFrequency= %u,u16AutoSeekStepWidth= %d,u16ManualStepWidth= %d",\
					oAvailableBandInfoElement.e8Band.enType,
					oAvailableBandInfoElement.u32HighFrequency,
					oAvailableBandInfoElement.u32LowFrequency,
					oAvailableBandInfoElement.u16AutoSeekStepWidth,
					oAvailableBandInfoElement.u16ManualStepWidth
					));	


	}


	ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_g_AvailableBandRange(), \
					u32AvailableBands= %x",\
					oStatusMsg.u32AvailableBands));	


    vSendMessage ( pNot->u16AppID,
                   oStatusMsg,
                   MIDW_TUNERFI_C_U16_FID_TUN_G_AVAILABLE_BAND_RANGE,
                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
                   pNot->u16CmdCounter,
                   pNot->u16RegisterID );

  }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
  ahl_bReleaseCritical(m_hNotHMITableSem);  
}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandle_r_ConfigList_Update( )
* 
* DESCRIPTION:  Send Method result for ConfigList Update.
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 19.2.2014
*************************************************************************/

tVoid tun_MsgToHMI::vHandle_r_ConfigList_Update(tU8 u8Status)
{
	midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult oResponse;

	
	MsgData rConfigListUpdateMsgData = rGetMsgDataForConfigListUpdate();

	
	/** Update method response status : SUCCESS */
	oResponse.TunerServer_StatusResponse.u8TunerStatus.enType = \
		(midw_fi_tcl_e8_Tun_ResponseStatus::tenType)u8Status;
		
	// Current Tuner state -> Not required for client. NORAL added as default.
	oResponse.TunerServer_StatusResponse.u8TunerState.enType =\
		midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

	//------------------------------
	// Send the response to client.
	//------------------------------
	vSendMessage( rConfigListUpdateMsgData.u16AppID,
		oResponse,
		MIDW_TUNERFI_C_U16_FID_TUN_S_CONFIGLIST_UPDATE,
		AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
		rConfigListUpdateMsgData.u16CmdCounter,       // Command Counter
		rConfigListUpdateMsgData.u16RegID        // RegID
		);

}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_EvaluationParameter( )
* 
* DESCRIPTION:  Print trace for evaluation parameter response received from adr.
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 26.3.2014
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_EvaluationParameter( const tU8* pu8Message )
{
  
	if( NULL == m_potun_Utility )
	{
		NORMAL_M_ASSERT( m_potun_Utility != NULL );
		return ;
	} 

	  ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_EvaluationParameter(), u8Section = %d",
					ETG_CENUM( tenEvalSection, pu8Message[enCM_EvaluationParameter_Section] ) ));	


	tU16 u16ParamID = m_potun_Utility->u16Convert2SeparateBytesTo16Bit\
										(&pu8Message[enCM_EvaluationParameter_idx_ParameterId]);

	ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_EvaluationParameter(), \
					u16ParamID = %d",\
					 u16ParamID));	

	ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_EvaluationParameter(), \
					u8ParamValue = %d",\
					 pu8Message[enCM_EvaluationParameter_idx_ParameterValue]));	

}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_UpdateLandscapeProgress( )
*
* DESCRIPTION:  UpdateLandscapeProgress response received from adr.
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* AUTHOR:
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_UpdateLandscapeProgress( const tU8* pu8Message )
{

	if( NULL == m_poHMINotTable )
	{
		NORMAL_M_ASSERT( m_poHMINotTable != NULL );
		return ;
	}

	  ahl_bEnterCritical( m_hNotHMITableSem );

	  ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_UpdateLandscapeProgress()"));

	  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_UPDATELANDSCAPE_PROGRESS) ;\
	            pNot != OSAL_NULL; pNot=pNot->pNext)
	  {

	    /*-----------------------------------------------------*/
	    /* Create status message to send to client             */
	    /*-----------------------------------------------------*/

	    midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus oStatusMsg;

		/** Fill msg data  */
		oStatusMsg.u8FreqPerc = pu8Message[enCM_UpdateLandscapeProgress_idx_ScannedFreqRatio];

		ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_UpdateLandscapeProgress(), FreqPercentage = %d",(tU8)oStatusMsg.u8FreqPerc));

	    vSendMessage ( pNot->u16AppID,
	                   oStatusMsg,
	                   MIDW_TUNERFI_C_U16_FID_TUN_G_UPDATELANDSCAPE_PROGRESS,
	                   AMT_C_U8_CCAMSG_OPCODE_STATUS,
	                   pNot->u16CmdCounter,
	                   pNot->u16RegisterID );

	  }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
	  ahl_bReleaseCritical(m_hNotHMITableSem);
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vCreateTMCListElement( )
*
* DESCRIPTION:  Creates and returns TMC List element from byte string obtained from ADR.
*
* PARAMETER:    tU8 u8ElementId , const tU8* pu8Element , midw_fi_tcl_TunerConfigListElement* TunerConfigListElement
*
* RETURNVALUE:  void
*
* Author:
*************************************************************************/
tVoid tun_MsgToHMI::vCreateTMCListElement( tU8 u8ElementId , const tU8* pu8Element ,\
												 midw_fi_tcl_TunerConfigListElement* TunerTMCListElement)
{

	if(( m_potun_Utility == NULL)||( m_potun_HMIManager == NULL))
	{
		TUN_ASSERT_RETURN( m_potun_Utility != NULL);
		TUN_ASSERT_RETURN( m_potun_HMIManager != NULL);
		return;
	}

	  ETG_TRACE_USR2(( " tun_MsgToHMI::vCreateTMCListElement() "));

	  ETG_TRACE_USR2((" Element = %d, Freq = %u, PI = %u, Quality = %d, CC = %d, LTN = %d, SID = %d"
          , u8ElementId
          , pu8Element[enCM_TMCStations_idx_Frequency]
          , pu8Element[enCM_TMCStations_idx_PI]
          , pu8Element[enCM_TMCStations_idx_Quality]
          , pu8Element[enCM_TMCStations_idx_CC]
          , pu8Element[enCM_TMCStations_idx_LTN]
          , pu8Element[enCM_TMCStations_idx_SID]
          ));

	   ETG_TRACE_USR2((" Stationname = %8s"
	                       , (const tChar*)&pu8Element[enCM_TMCStations_idx_Sendername]
	                       ));


    TunerTMCListElement->u8ElementID = u8ElementId;
    TunerTMCListElement->e8ConfigListID.enType = (midw_fi_tcl_e8_Tun_ConfigListID::tenType)enCM_StationListConfigListID_TMC;

	TunerTMCListElement->u32Frequency = m_potun_Utility->u32Convert4SeparateBytesTo32Bit(&pu8Element[enCM_TMCStations_idx_Frequency]);
	TunerTMCListElement->u32PI = m_potun_Utility->u16Convert2SeparateBytesTo16Bit(&pu8Element[enCM_TMCStations_idx_PI]);

     midw_fi_tclString sUtf8String ;

     m_potun_HMIManager -> vConvertRDSPSNametotString(&pu8Element[enCM_TMCStations_idx_Sendername],&sUtf8String) ;
     tBool bRetVal = TunerTMCListElement->sPSName.bSet( sUtf8String ,
                              midw_fi_tclString::FI_EN_UTF8);

     (tVoid)bRetVal;                // unused paremeter (makes Lint happy)


     TunerTMCListElement->u8Quality = pu8Element[enCM_TMCStations_idx_Quality];
     TunerTMCListElement->u8ECC = pu8Element[enCM_TMCStations_idx_CC];
     TunerTMCListElement->u8LTN = pu8Element[enCM_TMCStations_idx_LTN];
     TunerTMCListElement->u8SID = pu8Element[enCM_TMCStations_idx_SID];

}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSaveListIDForSetActivePresetList( )
* 
* DESCRIPTION:  Saves ADR List ID which has to be activated. 
*				In order to get the list to update HMI once result is obtained
*
* PARAMETER:    tU16 u16ADRListID
*
* RETURNVALUE:  tVoid
*
* AUTHOR:		vnd4kor(ECG) 17.9.2013
*************************************************************************/
tVoid tun_MsgToHMI::vSaveListIDForSetActivePresetList(tU16 u16ADRListID)
{
	m_u16ListIdOfSetActivePresetList = u16ADRListID;

	ETG_TRACE_USR2(("tun_MsgToHMI::vSaveListIDForSetActivePresetList() -> \
			m_u16ListIdOfSetActivePresetList= %02x",\
			m_u16ListIdOfSetActivePresetList));	



}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::u16GetListIDForSetActivePresetList( )
* 
* DESCRIPTION:  Returns List Id which was activated.
*				Required to get list to update HMI.
*
* PARAMETER:    none
*
* RETURNVALUE:  tU16
*
* AUTHOR:		vnd4kor(ECG) 17.9.2013
*************************************************************************/
tU16 tun_MsgToHMI::u16GetListIDForSetActivePresetList()const
{
	return m_u16ListIdOfSetActivePresetList;
}

/******************************************************************************

  FUNCTION:      vDeleteNoThrow

  DESCRIPTION:   Deletes memory without throwing an exception.

  PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

  RETURN TYPE:   void

  HINT:          Why this function? If delete is called inside the destructor,
                 Lint complains with warning 1551 that delete might throw an
                 execption, which is not caught.

                 But try / catch must not be used, and delete does not throw
                 an exception, anyway. To prevent a Lint warning deactivation,
                 this function guarantees that no exception is thrown.
                 Furthermore, it sets the given pointer to 0, and Lint is
                 happy.

                 It is a template, because two different memory types have to
                 be deleted inside this class.

----------------------------------------------------------------------------- */

template< class T > void tun_MsgToHMI::vDeleteNoThrow( T*& rfpArg ) throw()
{
   OSAL_DELETE rfpArg;
   rfpArg = 0;
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::u8GetAudibleTuner( )
* 
* DESCRIPTION:  Returns the audible tuner info
*
* PARAMETER:    Void
*
* RETURNVALUE:  tU8
*
*************************************************************************/
tU8 tun_MsgToHMI::u8GetAudibleTuner( ) const
{
	return m_u8PhysicalTuner;
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSetTunFGBGStatus( )
* 
* DESCRIPTION:  Sets the status of the audible tuner to FG/BG
*
* PARAMETER:    tBool
*
* RETURNVALUE:  tVoid
*
*************************************************************************/
tVoid tun_MsgToHMI::vSetTunFGBGStatus(tU8 u8TunFGBG)
{
	m_u8TunFGBG = u8TunFGBG;
}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::u8GetTunFGBGStatus( )
* 
* DESCRIPTION:  Returns the status of the audible tuner as FG/BG
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU8
*
*************************************************************************/
tU8 tun_MsgToHMI::u8GetTunFGBGStatus() const
{
	return m_u8TunFGBG;
}

/**************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHandleFSMethodResult( )
* 
* DESCRIPTION:  Handle the Method result for AtStationInfo when FieldStrength
*               is requested by diagnosis
*
* PARAMETER:    tU8 *
*
* RETURNVALUE:  None
* vnd4kor: removed unused param msgLength
*************************************************************************/
tVoid tun_MsgToHMI::vHandleFSMethodResult(const tU8* pu8Message)
{
 
  // Check the validity of incoming data
    if (pu8Message == NULL)
    {
	   NORMAL_M_ASSERT (pu8Message != NULL);
       return;
    }

		midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult oADRResponse;
		oADRResponse.Tuner_Field_Strength = pu8Message[enCM_ATStationInfo_idx_Fieldstrength];
				
		ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAG_MGR,
                               ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_S_TUN_GET_FIELD_STRENGTH _\
                               ET_EN_T8 _ oADRResponse.Tuner_Field_Strength _\
                               ET_EN_DONE );
		
		
		//------------------------------
        // Send the response to diagnosis
        //------------------------------
		
		tU16 u16CommandCntr = u16GetDiagCommandCntr();
		tU16 u16DiagRegID = u16GetDiagRegID();
        vSendMessage( CCA_C_U16_APP_DIAGDEBUG,
                      oADRResponse,
                      MIDW_TUNERFI_C_U16_FID_S_TUN_GET_FIELD_STRENGTH,
                      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                      u16CommandCntr,
                      u16DiagRegID 
                    );
    
}



/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetDiagRegID( )
* 
* DESCRIPTION:  To store the Diagnosis Register ID
*
* PARAMETER:    tU16 
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetDiagRegID(tU16 u16RegID)
{
    m_u16DiagRegID = u16RegID;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetDiagRegID( )
* 
* DESCRIPTION:  To retrieve the Diagnosis Register ID
*
* PARAMETER:    None 
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetDiagRegID() const
{
    return  m_u16DiagRegID;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetDiagCommandCntr( )
* 
* DESCRIPTION:  To store the Diagnosis Command Counter
*
* PARAMETER:    tU16 
*
* RETURNVALUE:  None 
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetDiagCommandCntr(tU16 u16ComCntr)
{
    m_u16CommandCntr = u16ComCntr;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetDiagCommandCntr( )
* 
* DESCRIPTION:  To retrieve the Diagnosis Command Counter
*
* PARAMETER:    None 
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetDiagCommandCntr() const
{
    return  m_u16CommandCntr;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterCommandCntrForActiveTuner( )
* 
* DESCRIPTION:  To store the TunerMaster Command Counter
*
* PARAMETER:    tU16 
*
* RETURNVALUE:  None 
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTunerMasterCommandCntrForActiveTuner(tU16 u16ComCntr)
{
    m_u16TMCommandCntrActiveTuner = u16ComCntr;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterCommandCntrForActiveTuner( )
* 
* DESCRIPTION:  To retrieve the Tunermaster Command Counter
*
* PARAMETER:    None 
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTunerMasterCommandCntrForActiveTuner() const
{
    return  m_u16TMCommandCntrActiveTuner;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterCommandCntrForBandChange( )
*
* DESCRIPTION:  To store the TunerMaster Command Counter
*
* PARAMETER:    tU16
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTunerMasterCommandCntrForBandChange(tU16 u16ComCntr)
{
    m_u16TMCommandCntrBandChange = u16ComCntr;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterCommandCntrForFGBG( )
*
* DESCRIPTION:  To store the TunerMaster Command Counter
*
* PARAMETER:    tU16
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTunerMasterCommandCntrForFGBG(tU16 u16ComCntr)
{
    m_u16TMCommandCntrFGBG = u16ComCntr;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterCommandCntrForBandChange( )
*
* DESCRIPTION:  To retrieve the Tunermaster Command Counter
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTunerMasterCommandCntrForBandChange() const
{
    return  m_u16TMCommandCntrBandChange;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterCommandCntrForFGBG( )
*
* DESCRIPTION:  To retrieve the Tunermaster Command Counter
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTunerMasterCommandCntrForFGBG() const
{
    return  m_u16TMCommandCntrFGBG;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterCommandCntrForSetRdbid( )
*
* DESCRIPTION:  To store the TunerMaster Command Counter
*
* PARAMETER:    tU16
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTPEGCommandCntrForSetRdbid(tU16 u16ComCntr)
{
	m_u16TMCommandCntrSetRdbid = u16ComCntr;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterCommandCntrForSetRdbid( )
*
* DESCRIPTION:  To retrieve the Tunermaster Command Counter
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTPEGCommandCntrForSetRdbid() const
{
    return  m_u16TMCommandCntrSetRdbid;
}



/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterCommandCntrForDirectFreq( )
*
* DESCRIPTION:  To store the TunerMaster Command Counter
*
* PARAMETER:    tU16
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTunerMasterCommandCntrForDirectFreq(tU16 u16ComCntr)
{
	m_u16TMCommandCntrDirectFreq = u16ComCntr;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterCommandCntrForDirectFreq( )
*
* DESCRIPTION:  To retrieve the Tunermaster Command Counter
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTunerMasterCommandCntrForDirectFreq() const
{
    return  m_u16TMCommandCntrDirectFreq;
}




/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterRegID( )
* 
* DESCRIPTION:  To store the TunerMaster Register ID
*
* PARAMETER:    tU16 
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTunerMasterRegID(tU16 u16RegID)
{
    m_u16TMDiagRegID = u16RegID;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterRegID( )
* 
* DESCRIPTION:  To retrieve the TunerMaster Register ID
*
* PARAMETER:    None 
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTunerMasterRegID() const
{
    return  m_u16TMDiagRegID;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterRegIDForBandChange( )
*
* DESCRIPTION:  To store the TunerMaster Register ID
*
* PARAMETER:    tU16
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTunerMasterRegIDForBandChange(tU16 u16RegID)
{
    m_u16BandChangeRegID = u16RegID;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterRegIDForFGBG( )
*
* DESCRIPTION:  To store the TunerMaster Register ID
*
* PARAMETER:    tU16
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTunerMasterRegIDForFGBG(tU16 u16RegID)
{
    m_u16FGBGRegID = u16RegID;
}
/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterRegIDForBandChange( )
*
* DESCRIPTION:  To retrieve the TunerMaster Register ID
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTunerMasterRegIDForBandChange() const
{
    return  m_u16BandChangeRegID;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterRegIDForFGBG( )
*
* DESCRIPTION:  To retrieve the TunerMaster Register ID
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTunerMasterRegIDForFGBG() const
{
    return  m_u16FGBGRegID;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTunerMasterRegIDForDirectFreq( )
*
* DESCRIPTION:  To store the TunerMaster Register ID
*
* PARAMETER:    tU16
*
* RETURNVALUE:  None
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetTunerMasterRegIDForDirectFreq(tU16 u16RegID)
{
    m_u16DirectFreqID = u16RegID;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetTunerMasterRegIDForDirectFreq( )
*
* DESCRIPTION:  To retrieve the TunerMaster Register ID
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI :: u16GetTunerMasterRegIDForDirectFreq() const
{
    return  m_u16DirectFreqID;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetDirectFreqRequested( )
*
* DESCRIPTION:  Sets if directfreq is requested by SDS
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tVoid tun_MsgToHMI :: vSetDirectFreqRequested(tBool bDirectFreqReq)
{
	m_bDirectFreqReq = bDirectFreqReq;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetDirectFreqRequested( )
*
* DESCRIPTION:  Sets if directfreq is requested by SDS
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tBool tun_MsgToHMI :: vGetDirectFreqRequested()const
{
	return m_bDirectFreqReq;
}

tVoid tun_MsgToHMI :: vSetTPEGRegIDForSetRdbid(tU16 u16RegID)
{
	m_u16TMSetRDBISRegID = u16RegID;
}

tU16 tun_MsgToHMI ::u16GetTPEGRegIDForSetRdbid()const
{
  return m_u16TMSetRDBISRegID;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetCmdCtrTMCConfigList( )
*
* DESCRIPTION:  To store Tunermaster Command Counter for TMC Config List
*
* PARAMETER:    tU16 u16CmdCntr
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetCmdCtrTMCConfigList(tU16 u16CmdCntr)
{
	m_u16CmdCtrForTMCConfigList = u16CmdCntr;
}

tU16 tun_MsgToHMI :: u16GetCmdCtrTMCConfigList() const
{
    return  m_u16CmdCtrForTMCConfigList;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetCmdCtrForAutostore()
*
* DESCRIPTION:  To retrieve the Tunermaster Command Counter
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI::u16GetCmdCtrForAutostore() const
{
    return m_u16CmdCtrForAutostore;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetCmdCtrForAutostore(tU16 u16CmdCntr
*
* DESCRIPTION:  To set the command counter value got from HMI
*
* PARAMETER:    u16CmdCntr
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetCmdCtrForAutostore(tU16 u16CmdCntr)
{
    m_u16CmdCtrForAutostore = u16CmdCntr;
}



/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::rGetMsgDataForSetActivePresetList()
*
* DESCRIPTION:  To retrieve the Command Counter, App id and reg id
*
* PARAMETER:    None
*
* RETURNVALUE:  MsgData
*******************************************************************************/
MsgData tun_MsgToHMI::rGetMsgDataForSetActivePresetList() const
{
    return m_rSetActivePresetListMsgData;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetMsgDataForSetActivePresetList
*
* DESCRIPTION:  To set the command counter, App Id, Reg Id, value got from HMI
*
* PARAMETER:    tU16 u16AppId,tU16 u16RegId,tU16 u16CmdCntr
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetMsgDataForSetActivePresetList(tU16 u16AppId,tU16 u16RegId,tU16 u16CmdCntr)
{
    m_rSetActivePresetListMsgData.u16AppID =  u16AppId;
	m_rSetActivePresetListMsgData.u16RegID =  u16RegId;
	m_rSetActivePresetListMsgData.u16CmdCounter =  u16CmdCntr;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::rGetMsgDataForConfigListUpdate()
*
* DESCRIPTION:  To retrieve the Command Counter, App id and reg id
*
* PARAMETER:    None
*
* RETURNVALUE:  MsgData
*******************************************************************************/
MsgData tun_MsgToHMI::rGetMsgDataForConfigListUpdate() const
{
    return m_rConfigListUpdateData;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetMsgDataForConfigListUpdate
*
* DESCRIPTION:  To set the command counter, App Id, Reg Id, value got from HMI
*
* PARAMETER:    tU16 u16AppId,tU16 u16RegId,tU16 u16CmdCntr
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetMsgDataForConfigListUpdate(tU16 u16AppId,tU16 u16RegId,tU16 u16CmdCntr)
{
    m_rConfigListUpdateData.u16AppID =  u16AppId;
	m_rConfigListUpdateData.u16RegID =  u16RegId;
	m_rConfigListUpdateData.u16CmdCounter =  u16CmdCntr;
}



tVoid tun_MsgToHMI ::vClear_TunerStates()
 {
	  m_u8TunerState = 0; //Idle
      m_u8SeekState = 0; //Off
 }

 /*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u8GetRDSSwitchStatus
*
* DESCRIPTION:  Getter for rds switch
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU8
*******************************************************************************/
tU8 tun_MsgToHMI::u8GetRDSSwitchStatus() const 
{ 
	return m_u8RDSSwitchStatus; 
}
 /*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetRDSSwitchStatus
*
* DESCRIPTION:  Setter for rds switch
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU8
*******************************************************************************/
tVoid tun_MsgToHMI::vSetRDSSwitchStatus(tU8 u8RdsSwitch) 
{ 
   m_u8RDSSwitchStatus = u8RdsSwitch; 
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetAtStaInfoQuality
*
* DESCRIPTION:  Set AtStaionInfo Quality
*
* PARAMETER:    tU8 u8AtStaInfoQuality
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetAtStaInfoQuality(tU8 u8AtStaInfoQuality)
{
    m_u8AtStaInfoQuality = u8AtStaInfoQuality;
	
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u8GetAtStaInfoQuality
*
* DESCRIPTION:  Get AtStaionInfo Quality
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU8
*******************************************************************************/
tU8 tun_MsgToHMI::u8GetAtStaInfoQuality() const
{
    return m_u8AtStaInfoQuality;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetAtStaInfoFreq
*
* DESCRIPTION:  Set AtStaionInfo Frequency
*
* PARAMETER:    tU32 u32Frequency
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetAtStaInfoFreq(tU32 u32Frequency)
{
    m_u32AtStaInfoFreq = u32Frequency;	
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u32GetAtStaInfoFreq
*
* DESCRIPTION:  Get AtStaionInfo Frequency
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU32
*******************************************************************************/
tU32 tun_MsgToHMI::u32GetAtStaInfoFreq() const
{
    return m_u32AtStaInfoFreq;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u32GetAnnoInfoFreq
*
* DESCRIPTION:  Get AnnouncementInfo Frequency
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU32
*******************************************************************************/
tU32 tun_MsgToHMI::u32GetAnnoInfoFreq() const
{
	return m_u32AnnoInfoFreq;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetAnnoInfoFreq
*
* DESCRIPTION:  Set AnnouncementInfo Frequency
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetAnnoInfoFreq(tU32 u32Frequency)
{
	m_u32AnnoInfoFreq = u32Frequency;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::utf8GetAnnoInfoPSName
*
* DESCRIPTION:  Get AnnouncementInfo PSName
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  midw_fi_tclString
*******************************************************************************/
midw_fi_tclString tun_MsgToHMI::utf8GetAnnoInfoPSName() const
{
	return m_utf8StringPSName;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetAnnoInfoPSName
*
* DESCRIPTION:  Set AnnouncementInfo PSName
*
* PARAMETER:    midw_fi_tclString sUtf8String
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetAnnoInfoPSName(midw_fi_tclString sUtf8String)
{
	m_utf8StringPSName = sUtf8String;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u16GetAnnoInfoPI
*
* DESCRIPTION:  Get AnnouncementInfo PI
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU16
*******************************************************************************/
tU16 tun_MsgToHMI::u16GetAnnoInfoPI() const
{
	return m_u16AnnoInfoPI;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetAnnoInfoPI
*
* DESCRIPTION:  Set AnnouncementInfo PI
*
* PARAMETER:    tU16 u16PI
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetAnnoInfoPI(tU16 u16PI)
{
	m_u16AnnoInfoPI = u16PI;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u8GetAnnoInfoType
*
* DESCRIPTION:  Get AnnouncementInfo Type
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU8
*******************************************************************************/
tU8 tun_MsgToHMI::u8GetAnnoInfoType() const
{
	return m_u8AnnoInfoType;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetAnnoInfoType
*
* DESCRIPTION:  Set AnnouncementInfo Type
*
* PARAMETER:    tU8 u8AnnoType
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetAnnoInfoType(tU8 u8AnnoType)
{
	m_u8AnnoInfoType = u8AnnoType;
}

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u8GetAnnoMessageType
*
* DESCRIPTION:  Get AnnoMessage Type
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tU8
*******************************************************************************/
tU8 tun_MsgToHMI::u8GetAnnoMessageType() const
{
	return m_u8AnnoMessage;
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vGetCurrentStateUpdates
*
* DESCRIPTION:
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vGetCurrentStateUpdates()
{
	ETG_TRACE_USR2(("tun_MsgToHMI::vGetCurrentVariableUpdate() -> \n\
			TUNFGBGStatus = %d \n, TunerState = %d \n, Frequency = %d KHz\n, Band = %d \n, \
			AnnoSwitchState = %d \n, AnnoMessage = %d",
			m_u8TunFGBG, m_u8TunerState , m_u32ATStationFreq , u8SystemPresets_Band , m_u8AnnoSwitchState , m_u8AnnoMessage));
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vUpdatePresetListID
*
* DESCRIPTION:
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vUpdatePresetListID()
{
	dp_tclTmcTunerDPPresetListID  oPresetListID;
	m_u16ListIdOfSetActivePresetList = oPresetListID.tGetData();
	ETG_TRACE_USR2(("tun_MsgToHMI::vUpdatePresetListID(), list ID : %d", m_u16ListIdOfSetActivePresetList));
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vUpdatePresetListID_DP
*
* DESCRIPTION:
*
* PARAMETER:    u16PresetListID
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vUpdatePresetListID_DP(tU16 u16PresetListID)
{
	ETG_TRACE_USR2(("tun_MsgToHMI::vUpdatePresetListID_DP(), list ID : %d", u16PresetListID));
	dp_tclTmcTunerDPPresetListID  oPresetListID;
	tS32 s32ReturnValue = oPresetListID.s32SetData(u16PresetListID);
#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
	if(DP_S32_NO_ERR != s32ReturnValue)
	{
		ETG_TRACE_USR4(("Datapool::vUpdatePresetListID_DP: Write error = %u! \n", s32ReturnValue));
    }
#endif
	ETG_TRACE_USR2(("tun_MsgToHMI::vUpdatePresetListID_DP(), data : %d", oPresetListID.tGetData()));
}


/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vGetStationLogoPath(tU32 u32PI,midw_fi_tclString &oUtf8String,tBool bRequireSmallLogo)
*
* DESCRIPTION: returns station logo image path in rfs
*
* PARAMETER:    u32PI
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vGetStationLogoPath(tU32 u32PI,midw_fi_tclString &oUtf8String,tBool bRequireSmallLogo)
{
	if( poGWMain == NULL )
    {
        NORMAL_M_ASSERT( poGWMain != NULL );
		return ;
	}
	
	if( poGWMain->m_poclTmcTuner_stationLogo_map == NULL )
    {
		NORMAL_M_ASSERT( poGWMain->m_poclTmcTuner_stationLogo_map != NULL );
		return ;
	}
	
	tunerString sLogoPath;
	poGWMain->m_poclTmcTuner_stationLogo_map->vGetStationLogoFilePath(u32PI,sLogoPath, bRequireSmallLogo);
	oUtf8String.bSet(sLogoPath.c_str(), midw_fi_tclString::FI_EN_UTF8);

	
}

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20	
/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandle_r_CM_ATHD_PSDDataFrame( )
*
* DESCRIPTION:  extracts PSD data and stores it.
*
* PARAMETER:    const tU8* pu8Message 
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 10.10.2014
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_r_CM_ATHD_PSDDataFrame( const tU8* pu8Message )
{
  TUN_ASSERT_RETURN( m_potun_Utility    != NULL);
  TUN_ASSERT_RETURN( m_potun_HMIManager != NULL);

  ETG_TRACE_USR1(("CCR.STARTING.HD_RADIO_PRIMARY_IMAGE:vHandle_r_CM_ATHD_PSDDataFrame"));
	/*-----------------------------------------------------*/
	/* Create status message to send to client             */
	/*-----------------------------------------------------*/

	tU16 u16NoOfPSDDataFrameBytes = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( &pu8Message[enCM_ATHD_PSDDataFrame_idx_NoOfPSDDataBytes] );
   	AudioProgPSDData oAP_PSDData ; 

   	for(tU16 u16Index = (tU16)enCM_ATHD_PSDDataFrame_idx_PSDDataRepetitionByte; \
		u16Index < u16NoOfPSDDataFrameBytes + enCM_ATHD_PSDDataFrame_idx_PSDFrame_ReservedByte;)
	{
		
		/** Extract Audio Program  */
		if(oAP_PSDData.u8AudioProgNum != pu8Message[u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_ProgramNo])
		{
			m_oStationPsdData.vAddAudioProgPSDData(oAP_PSDData);
			oAP_PSDData = m_oStationPsdData.oGetAudioProgramPSDData(pu8Message[u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_ProgramNo]);
			ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_ATHD_PSDDataFrame(): Obtained oAP_PSDData for AudioProg = %d",oAP_PSDData.u8AudioProgNum));
		}
		/** Extract SubField Length  */
		tU8 u8SubFieldLength = pu8Message[u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldLen]; 
		
		/** Extract FieldBit mask*/
		tU16 u16FieldBitMask = m_potun_Utility->u16Convert2SeparateBytesTo16Bit( \
			&pu8Message[u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_FieldBitMask] );
		
		/** extract subfield */
		tU8 u8SubfieldMask = pu8Message[u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubField] ;

		/** extract subfield data Type */
		tU8 u8SubfieldDataType = pu8Message[u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldDatatype] ;

		switch(u16FieldBitMask)
		{			
		case enFieldBitMask_Title:
		case enFieldBitMask_Artist:
		case enFieldBitMask_Album:
		case enFieldBitMask_Genre:
			vSetTitleArtistAlbumGenre(u16FieldBitMask,u8SubFieldLength,u8SubfieldDataType,\
				&pu8Message[ u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldData],oAP_PSDData);
			break;
		case enFieldBitMask_Comment:
			vExtractPSDCommentData(u8SubfieldMask,u8SubFieldLength,u8SubfieldDataType,\
				&pu8Message[ u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldData],oAP_PSDData);
			break;
		case enFieldBitMask_UFID:
			vExtractPSDUFIDData(u8SubfieldMask,u8SubFieldLength,&pu8Message[ u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldData],oAP_PSDData);
			break;
		case enFieldBitMask_Commercial:
			vExtractPSDCommercialData(u8SubfieldMask,u8SubFieldLength,u8SubfieldDataType,\
				&pu8Message[ u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldData],oAP_PSDData);
			break;
		case enFieldBitMask_XHDR:
			vExtractPSDXHDRData(u8SubFieldLength,&pu8Message[ u16Index + enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldData],oAP_PSDData);
			break;
		default:
			ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_ATHD_PSDDataFrame(): Unknown FieldBitMask"));
			break;
		}

		/** increment index for frame */
		u16Index = (tU16)((u16Index + enCM_ATHD_PSDDataFrame_len_PSDFrame_OffsetForEachFrame + u8SubFieldLength));
	
	}
	m_oStationPsdData.vAddAudioProgPSDData(oAP_PSDData);
	ETG_TRACE_USR4(("tun_MsgToHMI::vHandle_r_CM_ATHD_PSDDataFrame() m_u8HDStationInfoBits - %02x",m_u8HDStationInfoBits));
	if((m_u8HDStationInfoBits & TUN_ADVISORY_BITS_MASK) == TUN_ADVISORY_BITS_MASK)
	{
		/*send PSD data only if HD modulation, data and audio deoding bits set */
		vSendPSDStatus(m_u8CurrentAudioProgram);
		ETG_TRACE_USR2(("tun_MsgToHMI::vHandle_r_CM_ATHD_PSDDataFrame(): %d",m_oStationPsdData.u8PSDMapSize()));
	}
}



/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetTitleArtistAlbumGenre( )
*
* DESCRIPTION:  Handles Title Artist Album and Genre PSD data.
*
* PARAMETER:    const tU16 u16FieldBitMask,const tU8 u8SubFieldLength,
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData &oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 24.8.2015
*************************************************************************/
tVoid tun_MsgToHMI::vSetTitleArtistAlbumGenre(const tU16 u16FieldBitMask,const tU8 u8SubFieldLength,\
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData &oAP_PSDData)
{
	ETG_TRACE_USR2(("tun_MsgToHMI::vSetTitleArtistAlbumGenre(): PSD_DATA_KIND = %d, PSD_DATA = %s",
				ETG_CENUM(tenFieldBitMask, u16FieldBitMask),(const char*)pu8Message));
	

	if(u8SubfieldDataType != enSubFieldDataType_ISO_IEC8859_1_1998) 
	{
		ETG_TRACE_USR2(("tun_MsgToHMI::vSetTitleArtistAlbumGenre() : Invalid Subfield encoding type : %d",
				ETG_CENUM(tenSubFieldDataType, u8SubfieldDataType)));

		return;
	}

	tunerString sSubFieldData;
	vStripLeadingAndTrailingSpaces(pu8Message,sSubFieldData,u8SubFieldLength);
	vReplaceUnusedCharactersWithSpace(sSubFieldData);

	switch(u16FieldBitMask)
	{
		case enFieldBitMask_Title:
			oAP_PSDData.sTitle.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
			break;
		case enFieldBitMask_Artist:
			oAP_PSDData.sArtist.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
			break;
		case enFieldBitMask_Album:
			oAP_PSDData.sAlbum.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
			break;
		case enFieldBitMask_Genre:
			oAP_PSDData.sGenre.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
			break;
		default:
			ETG_TRACE_USR2(("tun_MsgToHMI::vSetTitleArtistAlbumGenre(): Unknown u16FieldBitMask"));
		break;
	}
}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vExtractPSDCommentData( )
*
* DESCRIPTION:  Handles Comments PSD data.
*
* PARAMETER:    tU8 &u8SubfieldMask,const tU8 u8SubFieldLength,\
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData &oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 14.7.2015
*************************************************************************/
tVoid tun_MsgToHMI::vExtractPSDCommentData(tU8 &u8SubfieldMask,const tU8 u8SubFieldLength,\
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData &oAP_PSDData)
{
	
	if(u8SubfieldDataType != enSubFieldDataType_ISO_IEC8859_1_1998) 
	{
		ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDCommentData() : Invalid Subfield encoding type : %d",
				ETG_CENUM(tenSubFieldDataType, u8SubfieldDataType)));

		return;
	}

	tunerString sSubFieldData;
	vStripLeadingAndTrailingSpaces(pu8Message,sSubFieldData,u8SubFieldLength);
	vReplaceUnusedCharactersWithSpace(sSubFieldData);

	switch(u8SubfieldMask)
	{
	case enCommentSubFieldBitMask_Language:
		oAP_PSDData.oPSDCommentData.sLanguage.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	case enCommentSubFieldBitMask_ShortContentDescription:
		oAP_PSDData.oPSDCommentData.sShortContentDescription.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	case enCommentSubFieldBitMask_ActualText:
		oAP_PSDData.oPSDCommentData.sActualText.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	default:
		ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDCommentData(): Unknown SubfieldBitMask"));
		break;
	}

	ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDCommentData(): AudioProgram = %d u8SubfieldMask = %d , SubfieldData = %s "\
		,oAP_PSDData.u8AudioProgNum
		,ETG_CENUM( tenCommentSubFieldBitMask,   u8SubfieldMask )
		,sSubFieldData.c_str()
		));
}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vExtractPSDCommercialData( )
*
* DESCRIPTION:  Handles Commercial PSD data.
*
* PARAMETER:    tU8 &u8SubfieldMask,const tU8 u8SubFieldLength,\
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData &oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 14.7.2015
*************************************************************************/
tVoid tun_MsgToHMI::vExtractPSDCommercialData(tU8 &u8SubfieldMask,const tU8 u8SubFieldLength,\
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData &oAP_PSDData)
{
	if(u8SubfieldDataType != enSubFieldDataType_ISO_IEC8859_1_1998) 
	{
		ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDCommercialData() : Invalid Subfield encoding type : %d",
				ETG_CENUM(tenSubFieldDataType, u8SubfieldDataType)));

		return;
	}

	tunerString sSubFieldData;
	vStripLeadingAndTrailingSpaces(pu8Message,sSubFieldData,u8SubFieldLength);
	vReplaceUnusedCharactersWithSpace(sSubFieldData);

	switch(u8SubfieldMask)
	{
	case enCommercialSubFieldBitMask_PriceString:
		oAP_PSDData.oPSDCommercialData.sPriceString.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	case enCommercialSubFieldBitMask_ValidUntil:
		oAP_PSDData.oPSDCommercialData.sValidUntil.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	case enCommercialSubFieldBitMask_ContactURL:
		oAP_PSDData.oPSDCommercialData.sContactURL.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	case enCommercialSubFieldBitMask_ReceivedAs:
		oAP_PSDData.oPSDCommercialData.sReceivedAs.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	case enCommercialSubFieldBitMask_NameOfSeller:
		oAP_PSDData.oPSDCommercialData.sNameOfSeller.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	case enCommercialSubFieldBitMask_Description:
		oAP_PSDData.oPSDCommercialData.sDescription.bSet(sSubFieldData.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M); 
		break;
	default:
		ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDCommercialData(): Unknown SubfieldBitMask"));
		break;
	}

	ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDCommercialData(): AudioProgram = %d u8SubfieldMask = %d , SubfieldData = %s "\
		,oAP_PSDData.u8AudioProgNum
		,ETG_CENUM( tenCommercialSubFieldBitMask,   u8SubfieldMask )
		,sSubFieldData.c_str()
		));

}


/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vStripLeadingAndTrailingSpaces( )
*
* DESCRIPTION:  Removes leading and trailing spaces in the string.
*
* PARAMETER:     char* source, char* dstination
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 20.7.2015
*************************************************************************/
tVoid tun_MsgToHMI::vStripLeadingAndTrailingSpaces(const tU8* source, string& destination,tU8 u8StringLength)
{
	if (source != NULL && u8StringLength != 0)
	{
		tU8 u8Start = 0x00; 
		//tU8 u8MsgLength = strlen((const char*)source);
		tU8 u8End = (tU8)(u8StringLength - 1);
		while(source[u8Start] == 0x20 && u8Start < u8StringLength)
		{
			u8Start++;
		}
		while(source[u8End] == 0x20 && u8End > u8Start)
		{
			u8End--;
		}

		destination.assign((const char*)&source[u8Start], (u8End + 1) - u8Start);
	}
	if(u8StringLength == 0)
	{
		/*if length is zero, clear the string and update */
		destination.clear();
	}
}
/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vReplaceUnusedCharactersWithSpace( )
*
* DESCRIPTION:  Replace Unused characters (as per ISO/IEC 8859-1:1998 - A standard 0x7f - 0x9f) with space
*
* PARAMETER:     string& destination
*
* RETURNVALUE:  tVoid
*
* AUTHOR: gds5kor ECO11 07.10.2016
*************************************************************************/
tVoid tun_MsgToHMI::vReplaceUnusedCharactersWithSpace(string& destination)
{
	if (destination.empty() == false)
	{
		short u8Start = 0x00;
		short stringSize = (short)destination.size();
		char strTempString[stringSize+1] = {0};
		strcpy(strTempString, destination.c_str());
		bool bIsInvalidCharacterPresent = false;
		while(u8Start < stringSize)
		{
					if(((short)strTempString[u8Start] >= 0x00 && (short)strTempString[u8Start] <= 0x1F)||
					    ((short)strTempString[u8Start] >= 0x7F && (short)strTempString[u8Start] <= 0x9F))
					{
								strTempString[u8Start] = 0x20;
								bIsInvalidCharacterPresent = true;
					}
					u8Start++;
		}
		if(bIsInvalidCharacterPresent)
		{
					destination.replace(destination.begin(), destination.end(), strTempString);
		}
	}
	return;
}
/*************************************************************************
* FUNCTION:     tun_MsgToHMI::strGetActiveHDCallSign()
*
* DESCRIPTION:  Get active HD call sign
*
* PARAMETER:
*
* RETURNVALUE:  tString
*
* AUTHOR: gds5kor ECO11 21.11.2016
*************************************************************************/
midw_fi_tclString tun_MsgToHMI::strGetActiveHDCallSign()
{
	midw_fi_tclString strHDCallSign;
	strHDCallSign.bSet( m_sHDActiveCallSign ,midw_fi_tclString::FI_EN_ISO8859_1M);
	ETG_TRACE_USR2(("tun_MsgToHMI::strGetActiveHDCallSign() %s", strHDCallSign.szValue));
	return strHDCallSign;
}
/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vGetActiveHDStationLogoPath(midw_fi_tclString& strHDStationLogoPath, tU32 u32HDStationID, tU8 u8HDAudioProgNum)
*
* DESCRIPTION:  Get active HD Station Logo Path
*
* PARAMETER:    strHDStationLogoPath
*
* RETURNVALUE:  tVoid
*
* AUTHOR: gds5kor ECO11 25.11.2016
*************************************************************************/
tVoid tun_MsgToHMI::vGetActiveHDStationLogoPath(midw_fi_tclString& strHDStationLogoPath, tU32 u32HDStationID, tU8 u8HDAudioProgNum)
{
	ETG_TRACE_USR2(("tun_MsgToHMI::vGetActiveHDStationLogoPath() u32HDStationID- %d, u8HDAudioProgNum- %d", u32HDStationID, u8HDAudioProgNum));
	TUN_ASSERT_RETURN( poGWMain != NULL);
	TUN_ASSERT_RETURN( poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE != NULL);
	
	midw_fi_tclString strHDStationLogoPathTemp = poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->strGetActiveStationLogoPath(u32HDStationID, u8HDAudioProgNum);
	strHDStationLogoPath.bSet(strHDStationLogoPathTemp, midw_fi_tclString::FI_EN_UTF8);
}
/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vExtractPSDUFIDData( )
*
* DESCRIPTION:  Handles UFID PSD data.
*
* PARAMETER:    tU8 &u8SubfieldMask,tU8 &u8SubFieldLength,const tU8* pu8Message,AudioProgPSDData &oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 14.7.2015
*************************************************************************/
tVoid tun_MsgToHMI::vExtractPSDUFIDData(tU8 &u8SubfieldMask,tU8 &u8SubFieldLength,const tU8* pu8Message,AudioProgPSDData &oAP_PSDData)
{
	switch(u8SubfieldMask)
	{
	case enUFIDSubFieldBitMask_OwnerIdentifier:
		oAP_PSDData.oPSDUFIDData.oOwnerIdentifier.assign(pu8Message,pu8Message+u8SubFieldLength);
		break;
	case enUFIDSubFieldBitMask_Identifier:
		oAP_PSDData.oPSDUFIDData.oIdentifier.assign(pu8Message,pu8Message+u8SubFieldLength);
		break;
	default:
		ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDUFIDData(): Unknown SubfieldBitMask"));
		break;
	}


}


/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vExtractPSDXHDRData( )
*
* DESCRIPTION:  Handles UFID PSD data.
*
* PARAMETER:     u8SubFieldLength, pu8Message, oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 14.7.2015
*************************************************************************/
tVoid tun_MsgToHMI::vExtractPSDXHDRData(tU8 &u8SubFieldLength,const tU8* pu8Message,AudioProgPSDData &oAP_PSDData)
{
	TUN_ASSERT_RETURN( m_potun_Config != NULL);

	unsigned int u32MIMEHash = 0;
	bool bIsInvalidMIMEHash = false;
	vReadLittleEndian(u32MIMEHash,&pu8Message[ enXHDR_idx_MIMEhash] );
	if(u32MIMEHash != 0xBE4B7536 && u32MIMEHash != 0xD9C72536)
	{
		//NCG3D-76772 - Do not parse XHDR frame anymore, asit is having invalid MIME hash.
		ETG_TRACE_USR1(("tun_MsgToHMI::vExtractPSDXHDRData(): AudioProgram = %d u32MIMEHash = 0x%08x (INVALID) u32StationID = %d", oAP_PSDData.u8AudioProgNum, u32MIMEHash, m_u32StationInfoHDStationID ));
		bIsInvalidMIMEHash = true;
	}
	oAP_PSDData.oXHDR.u32MIMEHash = u32MIMEHash;

	ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDXHDRData(): AudioProgram = %d u32MIMEHash = 0x%08x u32StationID = %d"
	,oAP_PSDData.u8AudioProgNum
	,oAP_PSDData.oXHDR.u32MIMEHash
	,m_u32StationInfoHDStationID
	));

	for(unsigned char u8LoopIdx = enXHDR_loop_starting_idx; u8LoopIdx < u8SubFieldLength; )
	{
		oAP_PSDData.oXHDR.u8ParameterID = pu8Message[ u8LoopIdx + enXHDR_loop_idx_ParamID];
		oAP_PSDData.oXHDR.u8ParameterLength = pu8Message[ u8LoopIdx + enXHDR_loop_idx_Length];
		if(oAP_PSDData.oXHDR.u8ParameterLength == 0)
		{
			u8LoopIdx = (tU8)(u8LoopIdx +( enXHDR_len_ParamID + enXHDR_len_Length));
		}
		else if(oAP_PSDData.oXHDR.u8ParameterLength == enXHDR_len_Value)
		{
			vReadLittleEndian(oAP_PSDData.oXHDR.u16ParameterValue,&pu8Message[ u8LoopIdx + enXHDR_loop_idx_Value] );
			u8LoopIdx = (tU8)(u8LoopIdx + (enXHDR_len_ParamID + enXHDR_len_Length + enXHDR_len_Value));
		}
		else
		{
			ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDXHDRData(): Invalid u8ParameterLength = %d ",oAP_PSDData.oXHDR.u8ParameterLength));
			u8LoopIdx = (tU8)(u8LoopIdx +(enXHDR_len_ParamID + enXHDR_len_Length + oAP_PSDData.oXHDR.u8ParameterLength));
			oAP_PSDData.oXHDR.u16ParameterValue = 0x00;
			continue;
		}

		ETG_TRACE_USR2(("tun_MsgToHMI::vExtractPSDXHDRData(): AudioProgram = %d, u8ParameterID = %d, u8ParameterLength = %d , u16ParameterValue = 0x%04x "\
		,oAP_PSDData.u8AudioProgNum
		,oAP_PSDData.oXHDR.u8ParameterID
		,oAP_PSDData.oXHDR.u8ParameterLength
		,oAP_PSDData.oXHDR.u16ParameterValue
		));

		vHandlePSDXHDRData(oAP_PSDData, bIsInvalidMIMEHash);

	}

}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vReadLittleEndian( )
*
* DESCRIPTION:  Reads little endian array bytes into dataHolder variable.
*				type of dataHolder variable determines the number of bytes read.
*
* PARAMETER:     T &dataHolder, tU8 *pu8Message
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 20.7.2015
*************************************************************************/
template<typename T>
tVoid tun_MsgToHMI::vReadLittleEndian(T &dataHolder,const tU8* pu8Message)
{
    dataHolder = 0;
	for(tU8 u8Count = sizeof(dataHolder);u8Count;u8Count--)
	{
		tU8 u8Data = pu8Message[u8Count-1];
		dataHolder = (T)( (dataHolder<<8) + u8Data);
	}
}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vExtractPSDXHDRData( )
*
* DESCRIPTION:  Manages display/NonDisplay of Image.
*
* PARAMETER:     AudioProgPSDData &oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 20.7.2015
*************************************************************************/
tVoid tun_MsgToHMI::vHandlePSDXHDRData(const AudioProgPSDData &oAP_PSDData, const bool& bIsInvalidMIMEHash)
{
	ETG_TRACE_USR2(( " tun_MsgToHMI::vHandlePSDXHDRData() m_u8HDStationInfoBits - %02x, bIsInvalidMIMEHash - %d", m_u8HDStationInfoBits, bIsInvalidMIMEHash ));
	if((m_u8HDStationInfoBits & TUN_ADVISORY_BITS_MASK) != TUN_ADVISORY_BITS_MASK)
	{
		ETG_TRACE_USR2(( " tun_MsgToHMI::vHandlePSDXHDRData() -> HD SIGNAL LOST " ));
		return;
	}
	if(bIsInvalidMIMEHash)
	{
		/*NCG3D-110726 - Trigger blank image display if received Invalid MIME hash */
		vBlankImageDisplayTrigger(oAP_PSDData);
		return;
	}

	switch(oAP_PSDData.oXHDR.u8ParameterID)
	{
	case enXHDRParamId_DisplayTrigger:
		vTriggerDisplayOfImage(oAP_PSDData);
		break;
	case enXHDRParamId_BlankDisplay:
		vBlankImageDisplayTrigger(oAP_PSDData);
		break;
	case enXHDRParamId_FlushMemory:
		vFlushImageMemory(oAP_PSDData);
		break;
	default :
		ETG_TRACE_USR2(("tun_MsgToHMI::vHandlePSDXHDRData(): Invalid u8ParameterId = %d ",oAP_PSDData.oXHDR.u8ParameterID));
		break;
	}

}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::bIsEqualsCurrentAudioProgram( )
*
* DESCRIPTION:  checks if Audioprogram belongs to current audioProgram
*
* PARAMETER:     unsigned char u8AudioProgram
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 22.7.2015
*************************************************************************/
tBool tun_MsgToHMI::bIsEqualsCurrentAudioProgram(unsigned char u8AudioProgram)
{
	if(u8AudioProgram != m_u8CurrentAudioProgram)
	{
		return false;
	}
	else
	{
		return true; 
	}
}


/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vTriggerDisplayOfImage( )
*
* DESCRIPTION:  Sends Display trigger of Image.
*
* PARAMETER:     AudioProgPSDData &oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 20.7.2015
*************************************************************************/
tVoid tun_MsgToHMI::vTriggerDisplayOfImage(const AudioProgPSDData& oAP_PSDData )
{
	TUN_ASSERT_RETURN( poGWMain != NULL);
	TUN_ASSERT_RETURN( poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE != NULL);

	if(bIsEqualsCurrentAudioProgram(oAP_PSDData.u8AudioProgNum) && (bIsFMDemodulationON((midw_fi_tcl_e8_Tun_TunerBand::tenType)m_u8PrevBand) || bIsAMDemodulationON((midw_fi_tcl_e8_Tun_TunerBand::tenType)m_u8PrevBand)) )
	{
		poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->vOnNewPSDXHDRImageDisplayTrigger(oAP_PSDData.u8AudioProgNum,\
			oAP_PSDData.oXHDR.u16ParameterValue,m_u32StationInfoHDStationID);
	}
	else
	{
		ETG_TRACE_USR2(("tun_MsgToHMI::vTriggerDisplayOfImage(): XHDR does not belong to curent AudioProgram or demodulation switch off"));
	}
}


/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vBlankImageDisplayTrigger( )
*
* DESCRIPTION:  Blank Display trigger of Image.
*
* PARAMETER:     AudioProgPSDData &oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 1.9.2015
*************************************************************************/
tVoid tun_MsgToHMI::vBlankImageDisplayTrigger(const AudioProgPSDData& oAP_PSDData )
{
	TUN_ASSERT_RETURN( poGWMain != NULL);
	TUN_ASSERT_RETURN( poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE != NULL);

	if(bIsEqualsCurrentAudioProgram(oAP_PSDData.u8AudioProgNum))
	{
		poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->vOnNewPSDXHDRBlankImageDisplayTrigger(oAP_PSDData.u8AudioProgNum,\
				m_u32StationInfoHDStationID, oAP_PSDData.oXHDR.u16ParameterValue);
	}
	else
	{
		ETG_TRACE_USR2(("tun_MsgToHMI::vBlankImageDisplayTrigger(): XHDR does not belong to curent AudioProgram"));
	}
}



/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vFlushImageMemory( )
*
* DESCRIPTION:  Delete all images related to Mime Hash.
*
* PARAMETER:     AudioProgPSDData &oAP_PSDData
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 1.9.2015
*************************************************************************/
tVoid tun_MsgToHMI::vFlushImageMemory(const AudioProgPSDData& oAP_PSDData )
{
	TUN_ASSERT_RETURN( poGWMain != NULL);
	TUN_ASSERT_RETURN( poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE != NULL);

	if(bIsEqualsCurrentAudioProgram(oAP_PSDData.u8AudioProgNum))
	{
		poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->vOnNewPSDXHDRFlushImageTrigger(oAP_PSDData.u8AudioProgNum,\
			m_u32StationInfoHDStationID, oAP_PSDData.oXHDR.u32MIMEHash);
	}
	else
	{
		ETG_TRACE_USR2(("tun_MsgToHMI::vFlushImageMemory(): XHDR does not belong to curent AudioProgram"));
	}
}


/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vSendPSDStatus( )
*
* DESCRIPTION:  Sends title , artist and album names to clients.
*
* PARAMETER:    tU8 u8AudioProgNum
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 15.1.2015
*************************************************************************/
tVoid tun_MsgToHMI::vSendPSDStatus(tU8 u8AudioProgNum)
{	
  	TUN_ASSERT_RETURN( m_poHMINotTable    != NULL);
	ETG_TRACE_USR2(("tun_MsgToHMI::vSendPSDStatus()"));
	/** Get PSD data for the audioprog Num */
	AudioProgPSDData data = m_oStationPsdData.oGetAudioProgramPSDData(u8AudioProgNum);

	vPrintPSDStatus(data);


	/** Create Fi object to send the PSD data status msg */
	midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus oStatusMsg;

	oStatusMsg.TunPSDData.e8HDAudioProgram.enType = (midw_fi_tcl_e8_Tun_HDAudioProgram::tenType)data.u8AudioProgNum;
	oStatusMsg.TunPSDData.sTitle.bSet( data.sTitle , midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.sArtist.bSet( data.sArtist , midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.sAlbum.bSet( data.sAlbum ,	midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.sGenre.bSet( data.sGenre ,	midw_fi_tclString::FI_EN_UTF8);
	
	oStatusMsg.TunPSDData.TunPSDCommercial.sPriceString.bSet( data.oPSDCommercialData.sPriceString ,	midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.TunPSDCommercial.sValidUntil.bSet( data.oPSDCommercialData.sValidUntil ,	midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.TunPSDCommercial.sContactURL.bSet( data.oPSDCommercialData.sContactURL ,	midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.TunPSDCommercial.sReceivedAs.bSet( data.oPSDCommercialData.sReceivedAs ,	midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.TunPSDCommercial.sNameOfSeller.bSet( data.oPSDCommercialData.sNameOfSeller ,	midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.TunPSDCommercial.sDescription.bSet( data.oPSDCommercialData.sDescription ,	midw_fi_tclString::FI_EN_UTF8);
		
	oStatusMsg.TunPSDData.TunPSDComment.sLanguage.bSet( data.oPSDCommentData.sLanguage ,	midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.TunPSDComment.sShortContentDescription.bSet( data.oPSDCommentData.sShortContentDescription ,	midw_fi_tclString::FI_EN_UTF8);
	oStatusMsg.TunPSDData.TunPSDComment.sActualText.bSet( data.oPSDCommentData.sActualText ,	midw_fi_tclString::FI_EN_UTF8);

	ahl_bEnterCritical( m_hNotHMITableSem );
	/** Send to registered clients */
	for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_PSD_DATA) ;\
		pNot != OSAL_NULL; pNot=pNot->pNext)
	{
		vSendMessage ( pNot->u16AppID,
			oStatusMsg,
			MIDW_TUNERFI_C_U16_FID_TUN_G_HD_PSD_DATA,
			AMT_C_U8_CCAMSG_OPCODE_STATUS,
			pNot->u16CmdCounter,
			pNot->u16RegisterID );
	}
	ahl_bReleaseCritical(m_hNotHMITableSem);
}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vPrintPSDStatus( )
*
* DESCRIPTION:  Print PSD data.
*
* PARAMETER:    AudioProgPSDData data
*
* RETURNVALUE:  tVoid
*
* AUTHOR: vnd4kor ECV2 15.1.2015
*************************************************************************/
tVoid tun_MsgToHMI::vPrintPSDStatus(AudioProgPSDData& data)
{
	ETG_TRACE_USR2(("tun_MsgToHMI::vPrintPSDStatus(): u8AudioProgramNumber = %d ",data.u8AudioProgNum));
	
	/** Title , Artist, Album , Genre */
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sTitle = %s ",data.sTitle.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sArtist = %s ",data.sArtist.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sAlbum = %s ",data.sAlbum.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sGenre = %s ",data.sGenre.szGet(midw_fi_tclString::FI_EN_UTF8)));

	/** Commercial */
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : Commercial Data"));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sPriceString = %s ",data.oPSDCommercialData.sPriceString.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sValidUntil = %s",data.oPSDCommercialData.sValidUntil.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sContactURL = %s",data.oPSDCommercialData.sContactURL.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sReceivedAs = %s",data.oPSDCommercialData.sReceivedAs.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sNameOfSeller = %s",data.oPSDCommercialData.sNameOfSeller.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sDescription = %s ",data.oPSDCommercialData.sDescription.szGet(midw_fi_tclString::FI_EN_UTF8)));
	
	/** Content */
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : Comment Data"));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sLanguage = %s",data.oPSDCommentData.sLanguage.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sShortContentDesc = %s",data.oPSDCommentData.sShortContentDescription.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR2((" tun_MsgToHMI::vPrintPSDStatus() : sActualText = %s ",data.oPSDCommentData.sActualText.szGet(midw_fi_tclString::FI_EN_UTF8)));

}


/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vAdvisoryTimerCallback( )
*
* DESCRIPTION:  Advisory timer call back function.
*
* PARAMETER:    tU8 u8HDStationInfoBits
*
* RETURNVALUE:  tVoid
*
* Author : vnd4kor ECV2 [2.2.2015]
*************************************************************************/
tVoid tun_MsgToHMI::vAdvisoryTimerCallback(tVoid* pArg)
{
	(tVoid)pArg;    /* unused parameter */

	 /*------------------*/
  /* set event handle */
  /*------------------*/
  OSAL_tEventHandle hRxSSI = OSAL_C_INVALID_HANDLE;

  if( OSAL_s32EventOpen( EVENT_TUNER_SYSTEM_EVENT_HANDLE, &hRxSSI) == OSAL_OK)
  {
    NORMAL_M_ASSERT( OSAL_s32EventPost( hRxSSI, EVENT_ADVISORY_MSG, OSAL_EN_EVENTMASK_OR) == OSAL_OK);
    (tVoid)OSAL_s32EventClose( hRxSSI);

    ETG_TRACE_USR2(( " tun_MsgToHMI::vAdvisoryTimerCallback() -> EVENT_ADVISORY_MSG Thread event posted" ));
  }
  else
  {
     ETG_TRACE_ERR(( " tun_MsgToHMI::vAdvisoryTimerCallback() -> EVENT_ADVISORY_MSG Post event fail" ));
  }

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vAdvisoryTimerExpired( )
*
* DESCRIPTION:  Advisory timer expired handler.
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* Author : vnd4kor ECV2 [4.2.2015]
*************************************************************************/
tVoid tun_MsgToHMI::vAdvisoryTimerExpired()
{
	//Fix for NCG3D-46206
	m_bAdvisoryTimerSet = false;
	m_bHDAudioDecodingBit = false; //Fix for NCG3D-79710
	
	ETG_TRACE_USR4((" tun_MsgToHMI::vAdvisoryTimerExpired() -> vClearPSDMap() and vClearData called" ));
	m_oStationPsdData.vClearPSDMap();
	poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->vClearData();
	vSendPSDStatus(m_u8CurrentAudioProgram);
	poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->vSendBlankImageDisplayToClient();
	vSend_HD_SignalLostTimer(false);

	if(m_u8CurrentAudioProgram == 0)
	{	
		//vSendAdvisory(TUN_HD_ADVISORY_NONE)
		ETG_TRACE_USR2(( " tun_MsgToHMI::vAdvisoryTimerExpired() -> *** NO HD Signal - Analogue played *** " ));
		vSend_HD_AdvisoryInfo((tU8)midw_fi_tcl_e8_Tun_HDAdvisoryInfo::FI_EN_TUN_HD_ADVISORY_NONE);
	}
	else
	{   
		if(m_bBit0and1OnceOn)
		{
			ETG_TRACE_USR2(( " tun_MsgToHMI::vAdvisoryTimerExpired() -> *** HD Signal Lost*** " ));
			vSend_HD_AdvisoryInfo((tU8)midw_fi_tcl_e8_Tun_HDAdvisoryInfo::FI_EN_TUN_HD_ADVISORY_SIGNAL_LOST);
		}
		else
		{
			ETG_TRACE_USR2(( " tun_MsgToHMI::vAdvisoryTimerExpired() -> *** HD Channel not available *** " ));
			vSend_HD_AdvisoryInfo((tU8)midw_fi_tcl_e8_Tun_HDAdvisoryInfo::FI_EN_TUN_HD_ADVISORY_CHANNEL_NOT_AVAILABLE);
		}
	}
	m_bBit0and1OnceOn = false;
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vClearAdvisoryStates( )
*
* DESCRIPTION:  Clear states of membervariables used for advisory
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* Author : vnd4kor ECV2 [2.2.2015]
*************************************************************************/
tVoid tun_MsgToHMI::vClearAdvisoryStates()
{

	ETG_TRACE_USR2(( " tun_MsgToHMI::vClearAdvisoryStates() - frequency or AP changed m_bAdvisoryTimerSet - %d, m_u8HDStationInfoBits - %02x",m_bAdvisoryTimerSet, m_u8HDStationInfoBits ));
	
	if(m_bAdvisoryTimerSet)
	{
		tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerAdvisoryTimer, 0, 0 );
		TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
		m_bAdvisoryTimerSet = false;
		vSend_HD_SignalLostTimer(m_bAdvisoryTimerSet);
	}
	m_bBit0and1OnceOn = false;
	m_u8HDStationInfoBits = 0xff;
	m_bHDAudioDecodingBit = false;
	m_bPresetSelected = false;
	m_bStationListElementSelected = false;
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vClearHDTuningActionStates( )
*
* DESCRIPTION:  Clear states of membervariables used for HD Audio decoding timer
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* Author : gds5kor ECO11 [07.10.2016]
*************************************************************************/
tVoid tun_MsgToHMI::vClearHDTuningActionStates()
{

	ETG_TRACE_USR2(( " tun_MsgToHMI::vClearHDTuningActionStates()" ));
	m_bHDSeekSelected = false;
	m_bHDAudioProgramSelected = false;
	m_bHDStationListElementSelected = false;
	m_bHDPresetSelected = false;
	m_bHDAudioProgramDirectSelected = false;
	m_bHDRotateEncoderSelected = false;
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vStopHDAudioDecodingTimer( )
*
* DESCRIPTION:  Stop HD Audio decoding timer
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* Author : gds5kor ECO11 [07.10.2016]
*************************************************************************/
tVoid tun_MsgToHMI::vStopHDAudioDecodingTimer()
{
	if(m_bHDStationInfoBitTimer)
	{
		tS32 s32RetVal = OSAL_s32TimerSetTime( m_hHDStationInfoBitTimer, 0, 0 );
		TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
		m_bHDStationInfoBitTimer = false;
		ETG_TRACE_USR2(( " tun_MsgToHMI::vStopHDAudioDecodingTimer()" ));
	}
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vStartHDAudioDecodingTimer( )
*
* DESCRIPTION:  Start HD Audio decoding timer
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* Author : gds5kor ECO11 [07.10.2016]
*************************************************************************/
tVoid tun_MsgToHMI::vStartHDAudioDecodingTimer()
{
	tS32 s32RetVal = OSAL_s32TimerSetTime( m_hHDStationInfoBitTimer, HDSTATIONINFOBITSTIMER, 0 );
	TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
	ETG_TRACE_USR2(( " tun_MsgToHMI::vStartHDAudioDecodingTimer() -> *** HD Audio decoding : %d ms Timer Started *** ", (int)HDSTATIONINFOBITSTIMER));
	m_bHDStationInfoBitTimer = true;
}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandle_Advisory_Info( )
*
* DESCRIPTION:  Manage Advisory information.
*
* PARAMETER:    const tU8 u8HDStationInfoBits, const tU8 u8HDAudioProgNum
*
* RETURNVALUE:  tVoid
*
* Author : vnd4kor ECV2 [2.2.2015]
*************************************************************************/
tVoid tun_MsgToHMI::vHandle_Advisory_Info( tU8 u8HDStationInfoBits, const tU8 u8HDAudioProgNum)
{
	tBool bIsHDBlendOnAnalog = (u8HDStationInfoBits & 0x08) >> 3;
	ETG_TRACE_USR4(( " tun_MsgToHMI::vHandle_Advisory_Info() bIsHDBlendOnAnalog - %d, m_bHDAudioDecodingBit - %d, m_bAdvisoryTimerSet - %d", bIsHDBlendOnAnalog, m_bHDAudioDecodingBit, m_bAdvisoryTimerSet));
	u8HDStationInfoBits &= TUN_ADVISORY_BITS_MASK;

	if(u8HDStationInfoBits < 4 )
	{
		/** SPS, Bit 2 atleast once seen case, consider for MPS also. Needed to clear PSD data after Lost timer */
		if(m_bHDAudioDecodingBit)
		{
			if(!m_bAdvisoryTimerSet)
			{
				//Send signal lost
				ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_Advisory_Info() -> *** HD SIGNAL LOST : %ds Timer Started *** ", m_poclConfigInterface->u32GetConfigData("Timer1")));

				tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerAdvisoryTimer, m_poclConfigInterface->u32GetConfigData("Timer1") * 1000, 0 );
					TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
				
				m_bAdvisoryTimerSet = true;
				vSend_HD_SignalLostTimer(m_bAdvisoryTimerSet);
			}
		}
		/** SPS Preset / StationListElem Selected , Bit 2 never seen case  */
		else if(((m_bPresetSelected) || (m_bStationListElementSelected || bIsHDBlendOnAnalog) )&& (u8HDAudioProgNum != 0)) //Fix for NCG3D-79710
		{
			if(!m_bAdvisoryTimerSet)
			{
				/** -------------------- start Advisory timer --------------------*/
				tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerAdvisoryTimer, m_poclConfigInterface->u32GetConfigData("Timer2") * 1000, 0 );
				TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
				
				m_bAdvisoryTimerSet = true;
				ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_Advisory_Info() -> *** WAITING FOR HD SIGNAL : %ds Timer Started *** ", m_poclConfigInterface->u32GetConfigData("Timer2")));
				//vSendWaitingForHD TUN_HD_ADVISORY_WAITING_FOR_SIGNAL
				vSend_HD_AdvisoryInfo((tU8)midw_fi_tcl_e8_Tun_HDAdvisoryInfo::FI_EN_TUN_HD_ADVISORY_WAITING_FOR_SIGNAL);
				vSend_HD_SignalLostTimer(m_bAdvisoryTimerSet);
			}
		}
		/** SPS and MPS Bit2 never seen case */
		else
		{
			if(u8HDStationInfoBits < 3 && u8HDAudioProgNum == 0)
			{
				//vSendAdvisory(TUN_HD_ADVISORY_NONE)
				ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_Advisory_Info() -> *** NO HD Signal - Analogue played *** " ));
				//vSend_HD_AdvisoryInfo((tU8)midw_fi_tcl_e8_Tun_HDAdvisoryInfo::FI_EN_TUN_HD_ADVISORY_NONE);
				return;
			}
			if(!m_bAdvisoryTimerSet)
			{

				/** -------------------- start Advisory timer --------------------*/
				tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerAdvisoryTimer,m_poclConfigInterface->u32GetConfigData("Timer2") * 1000, 0 );
				TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
				
				m_bAdvisoryTimerSet = true;
				ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_Advisory_Info() -> *** HD SIGNAL ACQUIRING / Waiting for Signal : %ds Timer Started *** ", m_poclConfigInterface->u32GetConfigData("Timer2")));
				//vSendAcquiring TUN_HD_ADVISORY_ACQUIRING
				tU8 u8AdvisoryInfo = (u8HDAudioProgNum == 0 ) ? (tU8)midw_fi_tcl_e8_Tun_HDAdvisoryInfo::FI_EN_TUN_HD_ADVISORY_ACQUIRING\
					: (tU8)midw_fi_tcl_e8_Tun_HDAdvisoryInfo::FI_EN_TUN_HD_ADVISORY_WAITING_FOR_SIGNAL;
				vSend_HD_AdvisoryInfo(u8AdvisoryInfo);
				vSend_HD_SignalLostTimer(m_bAdvisoryTimerSet);
			}
		}
		
	}
	/** SPS and MPS bit 2 is On case */
	else if(u8HDStationInfoBits > 3 )
	{
		if(m_bAdvisoryTimerSet)
		{
			//stop timer
			tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerAdvisoryTimer, 0, 0 );
			TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
			m_bAdvisoryTimerSet = false;
			vSend_HD_SignalLostTimer(m_bAdvisoryTimerSet);
		}
			m_bHDAudioDecodingBit = true;
			//send TUN_HD_ADVISORY_HDAUDIO_AVAILABLE
			ETG_TRACE_USR2(( " tun_MsgToHMI::vHandle_Advisory_Info() -> *** HD SIGNAL AVAILABLE *** " ));
			vSend_HD_AdvisoryInfo((tU8)midw_fi_tcl_e8_Tun_HDAdvisoryInfo::FI_EN_TUN_HD_ADVISORY_HDAUDIO_AVAILABLE);
		
	}
	/** Check whether HD signal was received or not when the timer is set */
	if(m_bAdvisoryTimerSet && (u8HDStationInfoBits == 3) )
	{
		m_bBit0and1OnceOn = true;
	}
}

/*************************************************************************
* FUNCTION:     tun_MsgToHMI::vHandleHDAudioDecodingTimer(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg )
*
* DESCRIPTION:  Manage Audio decoding bit information. If any of the bit (HD modulation, HD Data decoding and HD audio decoding) is not set, set timer for 2 seconds
*				After timeout, read latest received HD Station Info bits and update to clients.
* PARAMETER:    const tU8 u8HDStationInfoBits
*
* RETURNVALUE:  tVoid
*
* Author : gds5kor ECO11 [07.10.2016]
*************************************************************************/
tVoid tun_MsgToHMI::vHandleHDAudioDecodingTimer(const tU32 u32AtStationInfoFrequency, const tU32 u32AtStationInfoHDStationId)
{
	if (bIsHDTuningActionSelected(u32AtStationInfoFrequency, u32AtStationInfoHDStationId) == true)
	{
		ETG_TRACE_USR2(( " tun_MsgToHMI::vHandleHDAudioDecodingTimer() -> preset flag = %d seek flag = %d HDAudioProgram flag = %d, StationListElement flag = %d, EncoderRotate=%d",
				m_bHDPresetSelected, m_bHDSeekSelected, m_bHDAudioProgramSelected, m_bHDStationListElementSelected, m_bHDRotateEncoderSelected));
		if(m_bHDStationInfoBitTimer == false)
		{
			vStartHDAudioDecodingTimer();
		}
		else
		{
			// restart timer
			vStopHDAudioDecodingTimer();
			vStartHDAudioDecodingTimer();
		}
	}
	else if(m_bHDStationInfoBitTimer == true)
	{
		//stop timer
		vStopHDAudioDecodingTimer();
		vClearHDTuningActionStates();
	}
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHDStationInfoBitTimerCallback( )
*
* DESCRIPTION:  HDStationInfoBit timer call back function.
*
* PARAMETER:    tU8 u8HDStationInfoBits
*
* RETURNVALUE:  tVoid
*
* Author : gds5kor ECO11 [07.10.2016]
*************************************************************************/
tVoid tun_MsgToHMI::vHDStationInfoBitTimerCallback(tVoid* pArg)
{
	(tVoid)pArg;    /* unused parameter */

	 /*------------------*/
  /* set event handle */
  /*------------------*/
  OSAL_tEventHandle hRxSSI = OSAL_C_INVALID_HANDLE;

  if( OSAL_s32EventOpen( EVENT_TUNER_SYSTEM_EVENT_HANDLE, &hRxSSI) == OSAL_OK)
  {
    NORMAL_M_ASSERT( OSAL_s32EventPost( hRxSSI, EVENT_HDAUDIODECODING, OSAL_EN_EVENTMASK_OR) == OSAL_OK);
    (tVoid)OSAL_s32EventClose( hRxSSI);

    ETG_TRACE_USR2(( " tun_MsgToHMI::vHDStationInfoBitTimerCallback() -> EVENT_HDAUDIODECODING Thread event posted" ));
  }
  else
  {
     ETG_TRACE_ERR(( " tun_MsgToHMI::vHDStationInfoBitTimerCallback() -> EVENT_HDAUDIODECODING Post event fail" ));
  }

}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vHDStationInfoBitTimerExpired( )
*
* DESCRIPTION:  HDStationInfoBit timer expired handler.
*
* PARAMETER:    tVoid
*
* RETURNVALUE:  tVoid
*
* Author : gds5kor ECO11 [07.10.2016]
*************************************************************************/
tVoid tun_MsgToHMI::vHDStationInfoBitTimerExpired()
{
	ETG_TRACE_USR2(( " tun_MsgToHMI::vHDStationInfoBitTimerExpired() -> HD Station Info Bit Timer Expired" ));
	m_bHDStationInfoBitTimer = false;
	vClearHDTuningActionStates();
}
/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSend_HD_AdvisoryInfo( )
*
* DESCRIPTION:  Send Advisory status message to registered clients
*
* PARAMETER:    tU8 u8Advisory;
*
* RETURNVALUE:  tVoid
* Author :		vnd4kor ECV2 03.02.2015
*************************************************************************/
tVoid tun_MsgToHMI::vSend_HD_AdvisoryInfo(tU8 u8Advisory)
{
    TUN_ASSERT_RETURN( m_poHMINotTable != NULL );
   
	ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,
		ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_HD_AVISORY_INFO _\
		ET_EN_DONE); 



		midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus oStatusMsg;

		/*------------------------*/
		/* Fill in the message    */
		/*------------------------*/  
		oStatusMsg.e8HDAdvisoryInfo.enType = (midw_fi_tcl_e8_Tun_HDAdvisoryInfo::tenType)u8Advisory;

		ETG_TRACE_USR2(( " tun_MsgToHMI::vSend_HD_AdvisoryInfo() -> e8HDAdvisoryInfo = %d" , u8Advisory ));

		/* --- send it to the client --- */
ahl_bEnterCritical( m_hNotHMITableSem );
	for(ahl_tNotification* pNot =
		m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_AVISORY_INFO) ;
		pNot != OSAL_NULL;
	pNot=pNot->pNext
		)
	{
		vSendMessage ( pNot->u16AppID,
			oStatusMsg,
			MIDW_TUNERFI_C_U16_FID_TUN_G_HD_AVISORY_INFO,
			AMT_C_U8_CCAMSG_OPCODE_STATUS,
			pNot->u16CmdCounter,
			pNot->u16RegisterID );

	} /* End of for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ;
	  pNot != OSAL_NULL; pNot=pNot->pNext) */

  ahl_bReleaseCritical(m_hNotHMITableSem); 
	
}

/*************************************************************************
*
* FUNCTION:     tun_MsgToHMI::vSend_HD_SignalLostTimer( )
* DESCRIPTION:  Send Advisory status message to registered clients
* PARAMETER:    tBool bTimer;
* RETURNVALUE:  tVoid
* Author :		gds5kor ECO1 17.03.2017
*************************************************************************/
tVoid tun_MsgToHMI::vSend_HD_SignalLostTimer(tBool bTimerStatus)
{
    TUN_ASSERT_RETURN( m_poHMINotTable != NULL );
   
	ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_MSGTOHMI,
		ET_EN_T16 _ MIDW_TUNERFI_C_U16_FID_TUN_G_HD_SIGNALLOST_TIMER _\
		ET_EN_DONE); 

		midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus oStatusMsg;
		oStatusMsg.bTimer = bTimerStatus;

		/* --- send it to the client --- */
ahl_bEnterCritical( m_hNotHMITableSem );
	for(ahl_tNotification* pNot =
		m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_SIGNALLOST_TIMER) ;
		pNot != OSAL_NULL;
	pNot=pNot->pNext
		)
	{
		vSendMessage ( pNot->u16AppID,
			oStatusMsg,
			MIDW_TUNERFI_C_U16_FID_TUN_G_HD_SIGNALLOST_TIMER,
			AMT_C_U8_CCAMSG_OPCODE_STATUS,
			pNot->u16CmdCounter,
			pNot->u16RegisterID );

	}

ahl_bReleaseCritical(m_hNotHMITableSem); 
	ETG_TRACE_USR2(( " tun_MsgToHMI::vSend_HD_SignalLostTimer() -> bTimer = %d" , oStatusMsg.bTimer ));
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tBool tun_MsgToHMI::blGetSendAutoStoreMethodeResult()
{
	return m_bSendAutostoreMthdResult;
}
tVoid tun_MsgToHMI::vSetSendAutoStoreMethodeResult(tBool blSendAutostoreMthdResult)
{
	m_bSendAutostoreMthdResult=blSendAutostoreMthdResult;
}
#endif

/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSendAnnouncementInfo_Quality()
*
* DESCRIPTION: Send anno info status with quality update
*
* PARAMETER:    u8Quality
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSendAnnouncementInfo_Quality(tU8 u8Quality)
{
	TUN_ASSERT_RETURN( m_poHMINotTable != NULL );  
	ahl_bEnterCritical( m_hNotHMITableSem );

	  for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO) ;\
				pNot != OSAL_NULL; pNot=pNot->pNext)
	  {

		/*-----------------------------------------------------*/
		/* Create status message to send to client             */
		/*-----------------------------------------------------*/

		midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus oAnnoInfo;

		/** Fill msg data  */
		oAnnoInfo.AnnoInfoStatus.u32Frequency = m_u32AnnoInfoFreq;
		oAnnoInfo.AnnoInfoStatus.u16PI = m_u16AnnoInfoPI;

		oAnnoInfo.AnnoInfoStatus.sAnnoStationName.bSet(m_utf8StringPSName ,
								 midw_fi_tclString::FI_EN_UTF8);

		oAnnoInfo.AnnoInfoStatus.u8Quality = u8Quality;

		oAnnoInfo.b8AnnoTypes.u8Value = m_u8AnnoInfoType;

		ETG_TRACE_USR2(("tun_MsgToHMI::vSendAnnouncementInfo_Quality(), u32Frequency = %d,\
						u16PI= %04x, AnnoType = %d , Quality = %d ",\
						oAnnoInfo.AnnoInfoStatus.u32Frequency,\
						oAnnoInfo.AnnoInfoStatus.u16PI,\
						oAnnoInfo.b8AnnoTypes.u8Value,
						oAnnoInfo.AnnoInfoStatus.u8Quality));

		vSendMessage ( pNot->u16AppID,
					   oAnnoInfo,
					   MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO,
					   AMT_C_U8_CCAMSG_OPCODE_STATUS,
					   pNot->u16CmdCounter,
					   pNot->u16RegisterID );

	  }//for(ahl_tNotification* pNot= m_poHMINotTable->poGetNotificationList(u16FID) ; pNot != OSAL_NULL; pNot=pNot->pNext)
	  ahl_bReleaseCritical(m_hNotHMITableSem);
}
/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::vSetAFSwitchValue()
*
* DESCRIPTION: update AFSwitch value
*
* PARAMETER:    u8NewValue
*
* RETURNVALUE:  tVoid
*******************************************************************************/
tVoid tun_MsgToHMI::vSetAFSwitchValue(tU8 u8NewValue)
{
   m_u8AFSwitch = u8NewValue;
}
/*******************************************************************************
* FUNCTION:     tun_MsgToHMI::u8GetAFSwitchValue()
*
* DESCRIPTION: return updated value of AFSwitch
*
* PARAMETER:    None
*
* RETURNVALUE:  tU8
*******************************************************************************/
tU8 tun_MsgToHMI::u8GetAFSwitchValue() const
{
   return m_u8AFSwitch;
}
/**
*
**/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tU8 tun_MsgToHMI::u8GetActiveAudioProgram() const
{
	return m_u8CurrentAudioProgram;
}

/*Check for FM demodulation switch*/
bool tun_MsgToHMI::bIsFMDemodulationON(midw_fi_tcl_e8_Tun_TunerBand::tenType eCurrentBand)
{
	if(m_poclAars_DemodulationSwitch != NULL)
	{
		ETG_TRACE_USR4(("tun_MsgToHMI::bIsFMDemodulationON - %d", m_poclAars_DemodulationSwitch->u8GetAarsDemodulationSwitch()));
		if( (m_poclAars_DemodulationSwitch->u8GetAarsDemodulationSwitch() & FMHDDEMODULATION) && (eCurrentBand == midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_FM) )
		{
			return true;
		}
	}
	return false;
}

/*Check for AM demodulation switch*/
bool tun_MsgToHMI::bIsAMDemodulationON(midw_fi_tcl_e8_Tun_TunerBand::tenType eCurrentBand)
{
	if(m_poclAars_DemodulationSwitch != NULL)
	{
		if( (m_poclAars_DemodulationSwitch->u8GetAarsDemodulationSwitch() & AMHDDEMODULATION) && (eCurrentBand == midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_LW || eCurrentBand == midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_MW) )
		{
			return true;
		}
	}
	return false;
}

/*If advisory timer is started, and if user has switched off demodulation switch, stop advisory timer and update status to clients */
tVoid tun_MsgToHMI::vOnNewDemodulationStatus(unsigned char u8DemodulationSwitch)
{	
	if( m_bAdvisoryTimerSet && (!(u8DemodulationSwitch & AMHDDEMODULATION) || !(u8DemodulationSwitch & FMHDDEMODULATION)) )
	{
		vClearAdvisoryStates();
		vSend_HD_SignalLostTimer(false);
	}
	/*NCG3D-46087: If demodulation switch is Off, clear current audio program and HDStationID*/
	if(!(bIsFMDemodulationON((midw_fi_tcl_e8_Tun_TunerBand::tenType)m_u8PrevBand) || bIsAMDemodulationON((midw_fi_tcl_e8_Tun_TunerBand::tenType)m_u8PrevBand)))
	{
		ETG_TRACE_USR4(("tun_MsgToHMI::vOnNewDemodulationStatus, m_u8CurrentAudioProgram - %d", m_u8CurrentAudioProgram));
		m_u8CurrentAudioProgram = (tU8)0x00;
		m_u32StationInfoHDStationID = (tU32)0x00;
		if( poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE != NULL)
		{
			/*If demodulation switch off, clear stored variables and trigger blank image display to clients */
			poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->vOnNewPSDXHDRImageDisplayTrigger(0xff, 0x00, m_u32StationInfoHDStationID);
			poGWMain->m_poclTmcTuner_Property_G_HD_IMAGEFILE_UPDATE->vSendBlankImageDisplayToClient();
		}
	}
}
#endif

/*******************************************************************************
*FUNCTION:    tun_MsgToHMI::u8GetBandFromFrequency
*
*DESCRIPTION: Returns the band of the given frequency
*
*PARAMETER:   tU32Frequency
*
*RETURNVALUE: midw_fi_tcl_e8_Tun_TunerBand
********************************************************************************/
midw_fi_tcl_e8_Tun_TunerBand tun_MsgToHMI::u8GetBandFromFrequency(tU32 u32Frequency)
{
	midw_fi_tcl_e8_Tun_TunerBand e8Band;
	e8Band.enType = midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
	if(m_poclConfigInterface == NULL)
	{
		return e8Band;
	}
	if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighFM") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowFM") <= u32Frequency))
	{
		e8Band.enType = midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_FM;
	}
	else if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighLW") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowLW") <= u32Frequency))
	{
		e8Band.enType = midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_LW;
	}
	else if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") <= u32Frequency))
	{
		e8Band.enType = midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_MW;
	}
	return e8Band;
}
tU8 tun_MsgToHMI::u8Getmidw_fi_tcl_b8_Anno_Message(tU8 u8ADRAnnouncementType)
{
   if(u8ADRAnnouncementType == tenCM_AnnouncementInfoAnnoType::enCM_AnnouncementInfo_AnnoType_WeatherAlert)
   {
      return midw_fi_tcl_b8_Anno_Message::FI_C_U8_BIT_WEATHERALERT;
   }
   if(u8ADRAnnouncementType == tenCM_AnnouncementInfoAnnoType::enCM_AnnouncementInfo_AnnoType_PTY31)
   {
      return midw_fi_tcl_b8_Anno_Message::FI_C_U8_BIT_PTY31;
   }
   if(u8ADRAnnouncementType == tenCM_AnnouncementInfoAnnoType::enCM_AnnouncementInfo_AnnoType_TP)
   {
      return midw_fi_tcl_b8_Anno_Message::FI_C_U8_BIT_TA;
   }
   return 0;
}
tBool tun_MsgToHMI::bIsTunerFG()
{
	if(m_poclConfigInterface !=nullptr)
	{
		if(m_poclConfigInterface->u32GetConfigData("SBR"))
		{
			if((clCMEnum_MTCAudioSource::User_audio_FM == (static_cast<clCMEnum_MTCAudioSource::enMTCAudioSource>(m_u8TunFGBG))) ||
					(clCMEnum_MTCAudioSource::User_audio_LW == (static_cast<clCMEnum_MTCAudioSource::enMTCAudioSource>(m_u8TunFGBG))) ||
					(clCMEnum_MTCAudioSource::User_audio_MW == (static_cast<clCMEnum_MTCAudioSource::enMTCAudioSource>(m_u8TunFGBG))) ||
					(clCMEnum_MTCAudioSource::User_audio_CB1 == (static_cast<clCMEnum_MTCAudioSource::enMTCAudioSource>(m_u8TunFGBG))) ||
					(clCMEnum_MTCAudioSource::User_audio_WB == (static_cast<clCMEnum_MTCAudioSource::enMTCAudioSource>(m_u8TunFGBG))) ||
					(clCMEnum_MTCAudioSource::User_audio_TRF == (static_cast<clCMEnum_MTCAudioSource::enMTCAudioSource>(m_u8TunFGBG))))
			{
				return true;
			}
		}
		else
		{
			if(enAudioSource_User_audio == (static_cast<tenAudioSource>(m_u8TunFGBG)))
			{
				return true;
			}
		}
	}
	return false;
}
tBool tun_MsgToHMI::bIsFMAnnouFG()
{
	if(m_poclConfigInterface !=nullptr)
	{
		if(m_poclConfigInterface->u32GetConfigData("SBR"))
		{
			if(( clCMEnum_MTCAudioSource::Anno_audio_RDS == (static_cast<clCMEnum_MTCAudioSource::enMTCAudioSource>(m_u8TunFGBG))) ||
					(m_u8TunFGBG == clCMEnum_MTCAudioSource::PTY31_audio_RDS))
			{
				return true;
			}
		}
		else
		{
			if((enAudioSource_TA_audio == (static_cast<tenAudioSource>(m_u8TunFGBG))) ||
					(m_u8TunFGBG ==enAudioSource_PTY_audio) || (m_u8TunFGBG ==enAudioSource_WeatherAlert))
			{
				return true;
			}
		}
	}
	return false;
}
