/************************************************************************
* FILE:         tun_trace.h
* PROJECT:      g3g
* SW-COMPONENT: Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION: Tuner Server, trace defines.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 19.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
*
*************************************************************************/

#ifndef TUNER_TRACE_H
#define TUNER_TRACE_H



#include "trace_if.h"
//#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#include "etrace_if.h"

/*-------------------------*/
/* Trace for each class    */
/*-------------------------*/

/*----------------------------------------------------------------------------------*/
/* Tuner Componenet ->  TR_COMP_TUNER ( tri_types.h )  (256 * 38) = 9,728 (0x2600)  */

/* A class definition describes a 16 bit value, which has two parts                 */

/*   [  Component - ID   ][   Trace-Class-ID  ]                                     */
/*   15                  10                   0                                     */

/*----------------------------------------------------------------------------------*/




#define TUN_TRACE_CLASS_TUNAPP         (TR_COMP_TUNER + 1)
#define TUN_TRACE_CLASS_TUNTCLSRV      (TR_COMP_TUNER + 16) // Temperorily done   


#define TUN_TRACE_CLASS_WTHREAD        (TR_COMP_TUNER + 3)  

#define TUN_TRACE_CLASS_RU_INTF        (TR_COMP_TUNER + 4)
#define TUN_TRACE_CLASS_IPNINT         (TR_COMP_TUNER + 5)  

#define TUN_TRACE_CLASS_MSGQUE         (TR_COMP_TUNER + 6)
#define TUN_TRACE_CLASS_MSGTOADR       (TR_COMP_TUNER + 7)  

#define TUN_TRACE_CLASS_MGR            (TR_COMP_TUNER + 8)
#define TUN_TRACE_CLASS_ACTDATA        (TR_COMP_TUNER + 9)   

#define TUN_TRACE_CLASS_DISPATCHER     (TR_COMP_TUNER + 10) 
#define TUN_TRACE_CLASS_MSGFROMHMI    (TR_COMP_TUNER + 11) 

#define TUN_TRACE_CLASS_MSGTOHMI      (TR_COMP_TUNER + 12) 
#define TUN_TRACE_CLASS_FLASH_ACCESS   (TR_COMP_TUNER + 2) 

#define TUN_TRACE_CLASS_DIAG_SRV       (TR_COMP_TUNER + 13) //0d

#define TUN_TRACE_CLASS_DIAG_MGR       (TR_COMP_TUNER + 14) //0e

#define TUN_TRACE_CLASS_DIAGLOG        (TR_COMP_TUNER + 15) //0f

#define TUN_TRACE_CLASS_DEBUG          (TR_COMP_TUNER + 17) //11

#define TUN_TRACE_CLASS_SPM_CLIENT     (TR_COMP_TUNER + 18) //12

#define TUN_TRACE_CLASS_HMI_MGR        (TR_COMP_TUNER + 19) 

#define TUN_TRACE_CLASS_RTEXT          (TR_COMP_TUNER + 20)     

#define TUN_TRACE_CLASS_KDSCONFIG      (TR_COMP_TUNER + 22)//0x16

#define TUN_TRACE_CLASS_CONFIG_LISTENER       (TR_COMP_TUNER + 23)//0x17

#define TUN_TRACE_CLASS_DIAGHANDLER    (TR_COMP_TUNER + 24)//0x18

#define TUN_TRACE_CLASS_DRVADRIF       (TR_COMP_TUNER + 25)//0x19

#define TUN_TRACE_CLASS_DRVADRIF_LOW   (TR_COMP_TUNER + 26)//0x1A

#define TUN_TRACE_CLASS_MUTE_HANDLER	(TR_COMP_TUNER +30)//0X1E

/*---------------------*/
/* class tuner_tclApp  */
/*---------------------*/
#define TUN_TRACE_TUNAPP_CONSTRUCTOR              0x0101  
#define TUN_TRACE_TUNAPP_DESTRUCTOR               0x0102
#define TUN_TRACE_TUNAPP_ONINIT                   0x0103
#define TUN_TRACE_TUNAPP_SERVICE_STATE            0x0104
#define TUN_TRACE_TUNAPP_NEW_APP_STATE            0x0105
#define TUN_TRACE_TUNAPP_NEW_MESSAGE              0x0106
#define TUN_TRACE_TUNAPP_GET_SRV_VERSION          0x0107
#define TUN_TRACE_TUNAPP_ONWATCHDOG               0x0108
#define TIN_TRACE_TUNAPP_APPLICATION_CLOSE        0x0109
#define TUN_TRACE_TUNAPP_SEND_ERROR               0x010a
#define TUN_TRACE_TUNAPP_INIT_TUNER               0x010b

#define TUN_TRACE_TUNAPP_NEW_APP_STATE_NORMAL     0x010c
#define TUN_TRACE_TUNAPP_NEW_APP_STATE_DIAG       0x010d
#define TUN_TRACE_TUNAPP_NEW_APP_STATE_PAUSE      0x010e
#define TUN_TRACE_TUNAPP_NEW_APP_STATE_OFF        0x010f
#define TUN_TRACE_TUNAPP_NEW_APP_STATE_INVALID    0x0110

#define TUN_TRACE_TUNAPP_REGISTER_WITH_TTFIS      0x0113
#define TUN_TRACE_TUNAPP_UNREGISTER_WITH_TTFIS    0x0114

#define TUN_TRACE_TUNAPP_TRACE_CALLBACK_REG_SUCC  0x0115
#define TUN_TRACE_TUNAPP_TRACE_CALLBACK_REG_FAIL  0x0116

#define TUN_TRACE_TUNAPP_TRACE_CALLBACK_UNREG_SUCC  0x0115
#define TUN_TRACE_TUNAPP_TRACE_CALLBACK_UNREG_FAIL  0x0116

#define TUN_TRACE_TUNAPP_TRACE_VALUES               0x0117

/* Error messages */
#define TUN_TRACE_TUNAPP_ERR_NEW_FAIL             0x011a
#define TUN_TRACE_TUNAPP_NULL_POINTER             0x011b

#define  TUN_TRACE_TUNAPP_FLASH_FILE_READ_SUCC      0x0201
#define  TUN_TRACE_TUNAPP_FLASH_FILE_READ_FAIL      0x0202

#define  TUN_TRACE_TUNAPP_FLASH_FILE_WRITE_SUCC     0x0203
#define  TUN_TRACE_TUNAPP_FLASH_FILE_WRITE_FAIL     0x0204

#define  TUN_TRACE_TUNAPP_FLASH_FILE_SAVE           0x0205


#define  TUN_TRACE_TUNAPP_DIAG_CLIENT_SERVICE        0x0210
#define  TUN_TRACE_TUNAPP_SPM_CLIENT_SERVICE         0x0211

#define  TUN_TRACE_TUNAPP_COMMUNICATION_INIT         0x0310
#define  TUN_TRACE_TUNAPP_COMMUNICATION_DE_INIT      0x0312

#define  TUN_TRACE_TUNAPP_BG_TUNER_ACTIVE            0x0316
#define  TUN_TRACE_TUNAPP_BG_TUNER_NOTACTIVE         0x0318

#define  TUN_TRACE_TUNAPP_PROJ_CONFIGURATION         0x0319
#define  TUN_TRACE_TUNAPP_SRV_TUNERCONTROL_MAJOR_VERSION  0X0320
#define  TUN_TRACE_TUNAPP_SRV_TUNERCONTROL_MINOR_VERSION  0X0321




          

/*-------------------------*/
/* class tuner_tclservice  */
/*-------------------------*/

#define TUN_TRACE_TCLSERVICE_HANDLE_COMP_STATUS   0x023a
#define TUN_TRACE_TCLSERVICE_HANDLE_FG_BG         0x023b
#define TUN_TRACE_TCLSERVICE_INVALID_PARA         0x023c



/*-------------------------*/
/* tun_IPNInterface traces */
/*-------------------------*/
#define TUN_TRACE_IPNITF_CHANNEL_REQUEST_FAIL        0x0101   /* ipn channel request failed     */
#define TUN_TRACE_IPNITF_CHANNEL_REQUEST_OK          0x0102   /* ipn channel requested          */

#define TUN_TRACE_IPNITF_MSG_TX_FAIL                 0x0103   /* sending of messages failed     */
#define TUN_TRACE_IPNITF_MSG_TX_OK                   0x0104   /* message sent successfully      */


#define TUN_TRACE_IPNITF_MSG_RX_FAIL                 0x0105   /* receiving of messages failed   */
#define TUN_TRACE_IPNITF_MSG_RX_OK                   0x0106   /* message received successfully  */


#define TUN_TRACE_IPNITF_HEREIAM                     0x0105   /* here I am                      */
#define TUN_TRACE_IPNITF_RX_MSG_RECV                 0x0106   /* Msg from RU received           */ 

#define TUN_TRACE_IPNETF_EVENT_FAIL                  0x0107   /* Event post fail                */ 
#define TUN_TRACE_IPNITF_NULLPOINTER                 0x010a   /* NULL pointer as parameter passed */ 

#define TUN_TRACE_IPNITF_CONSTRUCTOR                 0x0201   /* class constructor              */ 
#define TUN_TRACE_IPNITF_DESTRUCTOR                  0x0202   /* class constructor              */
 
#define TUN_TRACE_IPNITF_THREAD_EVENT_POSTED         0x0204   /* class constructor              */ 
#define TUN_TRACE_IPNITF_MSG_SENT_CONFIRMATION       0x0205   /* Message sent to RU success     */ 




/*----------------------------*/
/* class tun_MsgToADR traces   */
/*----------------------------*/
#define TUN_TRACE_MSGTOADR_MSG_INDEX_1                0x0103
#define TUN_TRACE_MSGTOADR_SEND_MSGTO_RU_1            0x0104
#define TUN_TRACE_MSGTOADR_WAITING_FOR_CONF_1         0x0105

#define TUN_TRACE_MSGTOADR_MSG_SENT_CONF              0x0106
#define TUN_TRACE_MSGTOADR_MSG_INDEX_2                0x0107
#define TUN_TRACE_MSGTOADR_SEND_MSGTO_RU_2            0x0108
#define TUN_TRACE_MSGTOADR_WAITING_FOR_CONF_2         0x0109

#define TUN_TRACE_MSGTOADR_MESSAGE_DATA               0x010a
#define TUN_TRACE_MSGTOADR_DATA                       0x010b


/*------------------------------*/
/* class tun_RUIF_WaitingThread */
/*------------------------------*/

#define TUN_TRACE_WTHREAD_THREAD_STARTED             0x0120
#define TUN_TRACE_WTHREAD_LOOP_RUNNING               0x0121
#define TUN_TRACE_WTHREAD_EVENT_MASK                 0x0122
#define TUN_TRACE_SYSLAYER_LOOP_NOEVENT              0x0124
#define TUN_TRACE_SYSLAYER_LOOP_END                  0x0125
#define TUN_TRACE_WTHREAD_HANDLE_RX_MSG              0x0135
#define TUN_TRACE_WTHREAD_RX_MSG_CONFIRMATION        0x0136
#define TUN_TRACE_WTHREAD_RX_MSG_INDICATION          0x0137
#define TUN_TRACE_WTHREAD_TIMER_EVENT                0x0138
#define TUN_TRACE_TX_EVENT_RECEIVED                  0x0139

#define TUN_TRACE_WTHREAD_SELF_POSE_EVENT            0x0200
#define TUN_TRACE_WTHREAD_SELF_POSE_EVENT_SUCC       0x0202
#define TUN_TRACE_WTHREAD_SELF_POSE_EVENT_FAIL       0x0203
#define TUN_TRACE_WTHREAD_THREAD_TERMINATE           0x0206


/* Error */
#define TUN_TRACE_WTHREAD_THREAD_CREATION_FAIL       0x013a
#define TUN_TRACE_WTHREAD_INVALID_IPNET_INTF_PTR     0x013c
#define TUN_TRACE_WTHREAD_INVALID_MESSAGE            0x013d

/*----------------------------*/
/* Tuner Message Q interface  */
/*----------------------------*/
#define TUN_TRACE_MESSAGEQUE_CONSTRUCTOR             0x0101
#define TUN_TRACE_MESSAGEQUE_DESTRUCTOR              0x0102

#define TUN_TRACE_MESSAGEQUE_GETNEXTMSG_OK           0x0105
#define TUN_TRACE_MESSAGEQUE_GETNEXTMSG_FAIL         0x0106

#define TUN_TRACE_MESSAGEQUE_INSERTNEXTMSG_OK        0x0109
#define TUN_TRACE_MESSAGEQUE_INSERTNEXTMSG_FAIL      0x010a

#define TUN_TRACE_MESSAGEQUE_ADDNEWMSG               0x010d
#define TUN_TRACE_MESSAGEQUE_ADDTOHEAD               0x010e

#define TUN_TRACE_MESSAGEQUE_ADDTOTAIL               0x0111
#define TUN_TRACE_MESSAGEQUE_REMOVEFROMHEAD          0x0112

#define TUN_TRACE_MESSAGEQUE_REMOVEFROMTAIL          0x0115


#define TUN_TRACE_MESSAGEQUE_PUTINQUE_OK             0x0119
#define TUN_TRACE_MESSAGEQUE_PUTINQUE_FAIL           0x011a

#define TUN_TRACE_MESSAGEQUE_MSGSENTSUCCESS          0x011d
#define TUN_TRACE_MESSAGEQUE_INCRHEADER              0x011e

#define TUN_TRACE_MESSAGEQUE_CLRMSG                  0x0121
#define TUN_TRACE_MESSAGEQUE_MSGOVERFLOW             0x0122

#define TUN_TRACE_MESSAGEQUE_WAITINGFORCONF          0x0124
#define TUN_TRACE_MESSAGEQUE_NOT_WAITINGFORCONF      0x0125

#define TUN_TRACE_MESSAGEQUE_NEXTVALIDMSG_AVAI       0x0128
#define TUN_TRACE_MESSAGEQUE_NEXTVALIDMSG_NOT_AVAI   0x0129


#define TUN_TRACE_MESSAGEQUE_MSGHEADER               0x0150
#define TUN_TRACE_MESSAGEQUE_MSGTAIL                 0x0151


/*----------------*/
/* Tuner Manager  */
/*----------------*/
#define TUN_TRACE_UPDATE_TUNER_STATE                0x0101
#define TUN_TRACE_TUNER_STATE_READY                 0x0102
#define TUN_TRACE_TUNER_STATE_NOT_READY             0x0103
#define TUN_TRACE_CHANGE_COMP_STATUS                0x0104




/*----------------------*/
/* class tun_MsgFromHMI */
/*----------------------*/

#define TUN_TRACE_MSGFROMHMI_NULL_POINTER          0x0101
#define TUN_TRACE_MSGFROMHMI_SEND_REPLY_TO_CLIENT  0x0104
#define TUN_TRACE_MSGFROMHMI_SEND_ERROR_TO_CLIENT  0x0105
#define TUN_TRACE_MSGFROMHMI_FID_HANDLER           0x0109

#define TUN_TRACE_MSGFROMHMI_WRONG_OPCODE          0x0501
#define TUN_TRACE_MSGFROMHMI_WRONG_PARA            0x0502
#define TUN_TRACE_MSGFROMHMI_POST_MSG_FAIL         0x0701
#define TUN_TRACE_MSGFROMHMI_POST_MSG_OK           0x0702
#define TUN_TRACE_MSGFROMHMI_MSG_DEL_FAIL          0x0703


#define TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC  0x0705
#define TUN_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL  0x0706

#define TUN_TRACE_MSGFROMHMI_NEW_CREATION_FAIL     0x0801
#define TUN_TRACE_MSGFROMHMI_UPREG_REG             0x5555
#define TUN_TRACE_MSGFROMHMI_MS                    0x6666
#define TUN_TRACE_MSGFROMHMI_METHOD_START          0x7777
#define TUN_TRACE_MSGFROMHMI_METHOD_UPREG          0x8888
#define TUN_TRACE_MSGFROMHMI_METHOD_UPREG_VALUE    0x9999
#define TUN_TRACE_MSGFROMHMI_METHOD_RELUPREG_FAIL  0x1111
#define TUN_TRACE_MSGFROMHMI_METHOD_RELUPREG_SUCCESS  0x2222








/*----------------------*/
/* class tun_MsgToHMI   */
/*----------------------*/

#define TUN_TRACE_MSG_TO_HMI_ADD_TO_NOTIF_FAIL      0x0120
#define TUN_TRACE_MSG_TO_HMI_ADD_TO_NOTIF_OK        0x0121

#define TUN_TRACE_MSG_TO_HMI_REM_NOTIF              0x0124
#define TUN_TRACE_MSG_TO_HMI_REMALL_NOTIF           0x0125
#define TUN_TRACE_MSG_TO_HMI_STATUS_MSG             0x7777

#define TUN_TRACE_MSG_TO_HMI_MONITOR_STATION        0x7778
#define TUN_TRACE_MSG_TO_HMI_MONITOR_STATION_DATA   0x7779

#define TUN_TRACE_MSG_POST_FAIL_ERR                 0x0501


/*----------------------*/
/* class tun_ActualData */
/*----------------------*/
#define TUN_ACT_DATA_TUNER_MONITOR_STATION         0x0003

/* class tun_Data_MainStatus */

#define TUN_ACT_DATA_TUNER_MAIN_STATUS             0x0001
#define TUN_ACT_DATA_TUNER_STATION                 0x0002




/*-----------------------------*/
/* class tun_Flash_File_Access */
/*-----------------------------*/
#define TUN_TRACE_FLASH_CREATE_FILE_FAIL            0x0101
#define TUN_TRACE_FLASH_CREATE_FILE_SUCC            0x0102

#define TUN_TRACE_FLASH_OPEN_FILE_FAIL              0x0106
#define TUN_TRACE_FLASH_OPEN_FILE_SUCC              0x0107

#define TUN_TRACE_FLASH_READ_FILE_FAIL              0x0108
#define TUN_TRACE_FLASH_READ_FILE_SUCC              0x0109
#define TUN_TRACE_FLASH_READ_FILE                   0x010a

#define TUN_TRACE_FLASH_WRITE_FILE_FAIL             0x010b
#define TUN_TRACE_FLASH_WRITE_FILE_SUCC             0x010c
#define TUN_TRACE_FLASH_WRITE_FILE                  0x010d



#define TUN_TRACE_FLASH_READ_DATA                   0x0201
#define TUN_TRACE_FLASH_WRITE_DATA                  0x0202
#define TUN_TRACE_FLASH_ACCESS_LIST_EMPTY           0x0203
#define TUN_TRACE_FLASH_ACCESS_INVALID_LIST_LEN     0x0204

#define TUN_TRACE_FLASH_READ_FILE_VER_WRONG         0x0205



#define TUN_TRACE_FLASH_ACCESS_INVALID_PARA         0x0301

/*----------------------*/
/* class tun_KDSConfiguration */
/*----------------------*/

#define TUN_TRACE_KDSCONFIG_CONSTRUCTOR          0x0101
#define TUN_TRACE_KDSCONFIG_DESTRUCTOR           0x0102
#define TUN_TRACE_KDSCONFIG_KDS_OPEN_ERROR       0x0103
#define TUN_TRACE_KDSCONFIG_KDS_OPEN_SUCCESS     0x0104
#define TUN_TRACE_KDSCONFIG_KDS_CLOSE_ERROR      0x0105
#define TUN_TRACE_KDSCONFIG_KDS_CLOSE_SUCCESS    0x0106
#define TUN_TRACE_KDSCONFIG_KDS_READ_ERROR       0x0107
#define TUN_TRACE_KDSCONFIG_KDS_READ_SUCCESS     0x0108
#define TUN_TRACE_KDSCONFIG_KDS_NO_OF_ANTENNA    0X0109
#define TUN_TRACE_KDSCONFIG_KDS_AREA             0X010a
#define TUN_TRACE_KDSCONFIG_KDS_FMAM_LIMITS      0X010b
#define TUN_TRACE_KDS_CONFIG_KDS_TUNER_MODE		 0X010c	

//These are use by Diagnostics Class DiagManagaer

#define SET_FID_REQ_STATUS                  0x0e01
#define GET_FID_REQ_STATUS                  0x0e02
#define MESSAGES_FROM_RU                    0x0e03
#define PERFORM_TEST                        0x0e04
#define FIELDSTRENGTH_MEASURE               0x0e05
#define SET_TROUBLE_CODESTATUS              0x0e06
#define SEND_PERFTEST_STATUS                0x0e07
//Class DiagManagaer


#define SEND_PERFORM_TEST_MRESULT           0x0d01
#define HANDLE_FIELDSTRENGTH                0x0d02
#define SEND_PERFORM_TEST_STATUS            0x0d03 


#define SEND_PERFORM_TEST_STATUS_1        0x01       
#define SEND_PERFORM_TEST_STATUS_2        0x02
#define SEND_PERFORM_TEST_STATUS_3        0x03       
#define SEND_PERFORM_TEST_STATUS_4        0x04       
#define SEND_PERFORM_TEST_STATUS_5        0x05
#define SEND_PERFORM_TEST_STATUS_6        0x06       
#define SEND_PERFORM_TEST_STATUS_7        0x07



#define SEND_PERFORM_TEST_MRESULT_1        0x01       
#define SEND_PERFORM_TEST_MRESULT_2        0x02
#define SEND_PERFORM_TEST_MRESULT_3        0x03       
#define SEND_PERFORM_TEST_MRESULT_4        0x04       
#define SEND_PERFORM_TEST_MRESULT_5        0x05
#define SEND_PERFORM_TEST_MRESULT_6        0x06       
#define SEND_PERFORM_TEST_MRESULT_7        0x07
#define SEND_PERFORM_TEST_MRESULT_8        0x08
#define SEND_PERFORM_TEST_MRESULT_9        0x09       
#define SEND_PERFORM_TEST_MRESULT_10       0x0a


#define PERFORM_TEST_1        0x01
#define PERFORM_TEST_2        0x02
#define PERFORM_TEST_3        0x03
#define PERFORM_TEST_4        0x04
#define PERFORM_TEST_5        0x05
#define PERFORM_TEST_6        0x06
#define PERFORM_TEST_7        0x07
#define PERFORM_TEST_8        0x08
#define PERFORM_TEST_9        0x09
#define PERFORM_TEST_10       0x0a

#define SEND_PERFTEST_STATUS_1      0x01
#define SEND_PERFTEST_STATUS_2      0x02
#define SEND_PERFTEST_STATUS_3      0x03
#define SEND_PERFTEST_STATUS_4      0x04

/*----------------------*/
/* class tun_MsgToHMI   */
/*----------------------*/

#define TUN_TRACE_MSG_TO_DIAG_ADD_TO_NOTIF_FAIL      0x0120
#define TUN_TRACE_MSG_TO_DIAG_ADD_TO_NOTIF_OK        0x0121

#define TUN_TRACE_MSG_TO_DIAG_REM_NOTIF              0x0124
#define TUN_TRACE_MSG_TO_DIAG_REMALL_NOTIF           0x0125


#define TUN_DEBUG 0x01
// Macro for ordinary trace
/*#define TUN_TRACE(Trace_Val)                            \
  do {                                                  \
         ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DEBUG,     \
          ET_EN_T8 _ TUN_DEBUG _                        \
            ET_EN_T32 _ __LINE__ _                      \
              ET_EN_T8 _ Trace_Val _                    \
                ET_EN_STRING _ __FILE__ _               \
                  ET_EN_DONE);                          \
      }while(0);*/


#define TUN_TRACE(Trace_Val)                           \
           ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DEBUG,     \
					          ET_EN_T8 _ TUN_DEBUG _     \
							  ET_EN_T32 _ __LINE__ _     \
                              ET_EN_T8 _ Trace_Val _     \
                              ET_EN_STRING _ __FILE__ _  \
                              ET_EN_DONE);
   

/*------------------------------------*/
/* class tun_tclSPMClient definition  */
/*------------------------------------*/

#define TUN_TRACE_COPRO_STATE_CHANGE                 0x0101
#define TUN_TRACE_SYSTEM_STATE_CHANGE                0x0102

#define TUN_TRACE_REGISTER_FOR_SERVICE_SUCC          0x0105
#define TUN_TRACE_REGISTER_FOR_SERVICE_FAIL          0x0107
#define TUN_TRACE_UNREGISTER_FOR_SERVICE             0x0108

#define TUN_TRACE_REGISTER_FOR_FID_INVALID_SRVID     0x0109
#define TUN_TRACE_REGISTER_FOR_FID                   0x010a
#define TUN_TRACE_UNREGISTER_FOR_FID                 0x010b

#define TUN_TRACE_SET_COPRO_STATE                    0x010c

#define TUN_TRACE_LOW_VOLTAGE_EVENT                  0x010e

#define TUN_TRACE_SPM_SYSTEM_STATE                   0x010d

#define TUN_TRACE_ON_SERVICE_STATE                   0x0110
#define TUN_TRACE_ON_SERVICE_STATE_AVAILABLE         0x0112
#define TUN_TRACE_ON_SERVICE_STATE_UNAVAILABLE       0x0113

#define TUN_TRACE_ON_INVALID_REGID                   0x0114

#define TUN_TRACE_ON_REG_FOR_COPRO_SUCC              0x0116

#define TUN_TRACE_ON_REG_FOR_SYSSTATE_SUCC           0x0117

#define TUN_TRACE_SPM_INFO_COPRO_STANDBY             0x0120
#define TUN_TRACE_SPM_INFO_COPRO_DOWN                0x0122
#define TUN_TRACE_SPM_INFO_COPRO_NORMAL              0x0124


/*------------------------------------*/
/* class tun_HMIManager definition    */
/*------------------------------------*/


#define TUN_SAVE_STATIC_LIST_ELEM        0x01
#define TUN_STORE_STATIC_LIST_ELEM_1       0x02
#define TUN_STORE_STATIC_LIST_ELEM_2       0x03

#define TUN_G_GET_STATIC_LIST_1          0x00
#define TUN_G_GET_STATIC_LIST_2          0x01
#define TUN_G_GET_STATIC_LIST_3          0x02
#define TUN_G_GET_STATIC_LIST_4          0x03
#define TUN_G_GET_STATIC_LIST_5          0x04
#define TUN_G_GET_STATIC_LIST_6          0x05


/*--------------------------------------*/
/* class tun_RTextManager definition    */
/*--------------------------------------*/          


#define TUN_RTEXT_MSG_FROM_RU                      0x0140

#define TUN_RTEXT_MSG_FROM_RU_GRP_TYPE_INFO        0x0142

#define TUN_RTEXT_MSG_FROM_RU_BG_TUNER             0x0144

#define TUN_RTEXT_CONSTRUCT_GROUP_INFO             0x0150

#define TUN_RTEXT_CONSTRUCT_GROUP_INFO_RT_CHANGE   0x0152

#define TUN_RTEXT_CONSTRUCT_GROUP_B_INFO           0x0154

#define TUN_RTEXT_CONSTRUCT_GROUP_B_RECPT_STATUS   0x0156

#define TUN_RTEXT_CONSTRUCT_GROUP_B_NEW_DATA       0x0158

#define TUN_RTEXT_CONSTRUCT_GROUP_B_UPDATE_DISP    0x0160
#define TUN_RTEXT_CONSTRUCT_GROUP_A_INFO           0x0162

#define TUN_RTEXT_CONSTRUCT_GROUP_A_RECPT_STATUS   0x0164

#define TUN_RTEXT_CONSTRUCT_GROUP_A_NEW_DATA       0x0168

#define TUN_RTEXT_CONSTRUCT_GROUP_A_UPDATE_DISP    0x0170

#define TUN_RTEXT_GROUP_TYPE_INFO                  0x0172

#define TUN_RTEXT_GROUP_TYPE_A_INFO                0x0174
#define TUN_RTEXT_GROUP_TYPE_B_INFO                0x0176


#define TUN_RTEXT_CHANGE_IN_RTEXT_FIRST_VALID_RT   0x0180
#define TUN_RTEXT_CHANGE_IN_RTEXT_FIRST_SEG_RT     0x0182
#define TUN_RTEXT_CHANGE_IN_RTEXT_MID_SEG_RT       0x0184
#define TUN_RTEXT_CHANGE_IN_RTEXT_NEW_PI           0x0186
#define TUN_RTEXT_CHANGE_IN_RTEXT_NEW_GRP_TYPE     0x0188

#define TUN_RTEXT_CONSTRUCT_RTEXT_NEWDATA          0x0190

#define TUN_RTEXT_UPDATE_TO_CLIENT                 0x0198
#define TUN_TRACE_HMI_MGR_MAN_TUN_DIR_TICS            0x0401
#define TUN_TRACE_HMI_MGR_MAN_TUN_NEW_DIR_TICS        0x0403
#define TUN_TRACE_HMI_MGR_MAN_TUN_NEW_CTR             0x0405
#define TUN_TRACE_HMI_MGR_MAN_TUN_FRQ_ON_STEPS        0x0407
#define TUN_TRACE_HMI_MGR_MAN_TUN_FRQ_ON_STEPS_RES    0x0408
#define TUN_TRACE_HMI_MGR_MAN_TUN_FRQ_ON_P_STEPS      0x0409
#define TUN_TRACE_HMI_MGR_MAN_TUN_FRQ_ON_P_STEPS_RES  0x040a

#define TUN_TRACE_HMI_MGR_MAN_TUN_WITH_ONE_STEP       0x040b
#define TUN_TRACE_HMI_MGR_MAN_TUN_WITH_STEPS          0x040d

#define TUN_TRACE_HMI_MGR_MAN_TUN_TO_NEW_FRQ          0x040f

#define TUN_TRACE_HMI_MGR_MAN_TUN_EVAL_RU_NEW_FRQ     0x0501

#define TUN_TRACE_HMI_MGR_MAN_TUN_EVAL_RU_INPROG      0x0503
#define TUN_TRACE_HMI_MGR_MAN_TUN_EVAL_RU_INPROG_COM  0x0504

#define TUN_TRACE_HMI_MGR_MAN_TUN_EVAL_RU_COMP        0x0505
#define TUN_TRACE_HMI_MGR_MAN_TUN_EVAL_RU_INACTIVE    0x0507

//These are use by Learn Mem Flash File Read and write operation Class tun_Flash_File_Access

#define TUN_TRACE_LEARNMEM_TRACE_DEF                  0xdddd
#define TUN_TRACE_LEARNMEM_READ_FILE_UNSUCC           0x0001
#define TUN_TRACE_FLASH_GET_FILE_SIZE_ERROR           0x0002
#define TUN_TRACE_FLASH_FILE_SIZE_LESS                0x0003
#define TUN_TRACE_FLASH_FILE_SIZE_WRONG               0x0004
#define TUN_TRACE_LEARNMEM_READ_FILE_SUCC             0x0005
#define TUN_TRACE_LEARNMEM_READ_FILE_FAIL             0x0006
#define TUN_TRACE_LEARNMEM_READ_DATA                  0x0007
#define TUN_TRACE_LEARNMEM_FILE_CREATED               0x0008
#define TUN_TRACE_LEARNMEM_WRITE_HEADERINFO           0x0009
#define TUN_TRACE_LEARNMEM_WRITE_DATA_SUCC            0x000a
#define TUN_TRACE_LEARNMEM_WRITE_DATA_FAIL            0x000b
#define TUN_TRACE_LEARNMEM_CREATE_FILE_FAIL           0x000c
#define TUN_TRACE_LEARNMEM_CREATE_FILE_SUCC           0x000d
#define TUN_TRACE_LEARNMEM_WRITE_DATA                 0x000e

/*----------------------------------------------------------*/
/* class tun_ConfigAntennaListener definition    */
/*----------------------------------------------------------*/
#define TUN_TRACE_CLASS_CONFIG_LISTENER_NULL_POINTER       0x0101
#define TUN_TRACE_CLASS_CONFIG_LISTENER_ROUTINE_START       0x0102
#define TUN_TRACE_CLASS_CONFIG_LISTENER_CONFIGURE_ANTENNA   0x0103
#define TUN_TRACE_CLASS_CONFIG_LISTENER_NOK					0x0104
#define TUN_TRACE_CLASS_CONFIG_LISTENER_BUILDVECTOR			0x0105
#define TUN_TRACE_CLASS_CONFIG_LISTENER_SEND_ERROR			0x0106


/*----------------------------------------------------------*/
/* class tun_DiagHandler definition    */
/*----------------------------------------------------------*/
#define TUN_TRACE_CLASS_DIAGHANDLER_CONSTR			0x0101
#define TUN_TRACE_CLASS_DIAGHANDLER_INVALID_VER		0x0102
#define TUN_TRACE_CLASS_DIAGHANDLER_UNKNOWN_VER 	0x0103
#define TUN_TRACE_CLASS_DIAGHANDLER_FACT_NULL_PTR	0x0104
#define TUN_TRACE_CLASS_DIAGHANDLER_DIAGIF_NULL_PTR	0x0105
#define TUN_TRACE_CLASS_DIAGHANDLER_INTF_PTR     	0x0106
#define TUN_TRACE_CLASS_DIAGHANDLER_REGISTER		0x0107
#define TUN_TRACE_CLASS_DIAGHANDLER_DESTR			0x0108
#define TUN_TRACE_CLASS_DIAGHANDLER_NEWAPPSTATE		0x0109
#define TUN_TRACE_CLASS_DIAGHANDLER_SERVID			0x0110
#define TUN_TRACE_CLASS_DIAGHANDLER_DISPATCHMSG		0x0111
#define TUN_TRACE_CLASS_DIAGHANDLER_SERVVER			0x0112


/*----------------------------------------------------------*/
/* class tun_DrvAdrIf definition                            */
/* TUN_TRACE_CLASS_DRVADRIF                                 */
/*----------------------------------------------------------*/
#define TUN_TRACE_ADRIF_LOW_RX_IND                  0x01     /* SsiDataIndicationCallbackFunction() */ 
#define TUN_TRACE_ADRIF_LOW_TX_REQ                  0x02     /* tun_bSendMessageToRU() */
#define TUN_TRACE_ADRIF_LOW_TX_CONF                 0x03     /* SsiDataConfirmationCallbackFunction() */
#define TUN_TRACE_ADRIF_RX_MSG_NOT_SUPPORTED        0x04     /* tun_DrvAdrIf::vDispatch() */
#define TUN_TRACE_ADRIF_LOW_TX_TMC_REQ              0x05
#define TUN_TRACE_ADRIF_LOW_TMC_RX_IND              0x06
#define TUN_TRACE_ADRIF_LOW_SOCKET_OPEN             0x07
#define TUN_TRACE_ADRIF_LOW_THREAD_NOTCREATED              0x08
#define TUN_TRACE_ADRIF_LOW_THREAD_CREATED              0x09
#define TUN_TRACE_ADRIF_LOW_THREAD_ENTRY              0x0a
#define TUN_TRACE_ADRIF_LOW_RX_STATUS              0x0b 
#define TUN_TRACE_ADRIF_LOW_WRITE_STATUS              0x0c 
#define TUN_TRACE_ADRIF_LOW_THREAD_DETAILS              0x0d 


#endif /* TUNER_TRACE_H */
/*** END OF FILE *************************************************************/
