/************************************************************************
* FILE:           tun_defines.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    All headers specific to Tuner component.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 19.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
*
*************************************************************************/


#ifndef TUNER_DEFINES_H
#define TUNER_DEFINES_H


#include "datatypes/tString.h"
/*--------------------------------------------------------------------------*/
/* The below defines are only for the test purposes, they must be commented */
/*--------------------------------------------------------------------------*/

//#define TU_TEST_AUDIO_COMPONENT
//#define FORD_TPEX_ENVIRONMENT

/*MH no need for this interface here 
#define NUCLEUS_DRIVER_S_IMPORT_INTERFACE_IPN_DRV
#include "nucleus_driver_pif.h"
*/

/*---------------------------------*/

/*---------------------------------*/
/* tun_DrvAdrIf defines            */
/*---------------------------------*/
#define TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_TX_BUFFER_SIZE        1500
#define TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_RX_BUFFER_SIZE        6000
#define TUN_DRVADRIF_CONF_AMFM_TUNER_LUN                       0x14
#define TUN_DRVADRIF_CONF_PING_TIMEOUT_MS                      2000
#define TUN_DRVADRIF_CONF_PING_COUNTER_FOR_ADR_RESET           5
#define TUN_DRVADRIF_CONF_ADR3_MAXRESET_COUNTER                2
#define TUN_DRVADRIF_CONF_ADR_CONTROL_DRIVER_NAME             "/dev/adr3ctrl"
#define TUN_DRVADRIF_CONF_PING_COUNT_FOR_ADR_VERSION_PRINT     15

#define TUN_DRVADRIF_TX_MAX_PAYLOAD ( TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_TX_BUFFER_SIZE - 10)
#define TUN_DRVADRIF_RX_MAX_PAYLOAD ( TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_RX_BUFFER_SIZE - 10)


#define TUN_MSGTOHMI_ADVISORY_TIMEOUT_MS                      15000

/*------------------------------------*/
/* tun_RUIF_WaitingThread defines     */
/*------------------------------------*/



/*------------------------------------*/


/*--------------------------------------*/
/* Different  Audible Tuner Modes    */
/*--------------------------------------*/
#define CUSTOMER_MODE 0
#define DDA_MODE 1
#define DDS_MODE 2
#define SINGLE_TUNER_MODE 3
#define AUTO_MODE 4

/*-----------------------------------*/
/* posible events for waiting thread */
/*-----------------------------------*/
/**Vnd4kor: INC Adaptations*/
#ifdef VARIANT_S_FTR_ENABLE_OPTADR 
#define EVENT_SPI_RX_READY    0x0001
#define EVENT_SPI_TX_READY    0x0008
#else
#define EVENT_INC_RX_READY    0x0001
#define EVENT_INC_TX_READY    0x0008
#endif
#define EVENT_TERMINATE       0x0002
#define EVENT_FROM_MAINTHREAD_UPDATE_MANTUN   0x0004
#define EVENT_PING_TIMER      0x0010
#define EVENT_NEW_ADR_STATE   0x0020


#define EVENT_ADVISORY_MSG   0x0040
#define EVENT_HDAUDIODECODING 0x0080

/*------------------------------------*/
/* tuner waiting thread configuration */
/*------------------------------------*/
#define TUN_WAITINGTHREAD_DEFAULT_PRIO                133
#define TUN_WAITINGTHREAD_DEFAULT_STACKSIZE           4096
#define EVENT_TUNER_SYSTEM_EVENT_HANDLE               "TunerSrv"



/*-----------------------------------------------------*/


/*----------------------------------------*/
/* Tuner thread configuration in registry */
/*----------------------------------------*/

#define TUN_REGPATH_THREAD                "APP_THREAD"
#define TUN_REGVALUE_THREAD_PRIO_NAME     "TUN_RU_TREAD_PRIO"
#ifdef VARIANT_S_FTR_ENABLE_INC_ADAPTATION_TO_NISSANLCN2KAI
#define TUN_REGVALUE_TMCTHREAD_PRIO_NAME     "TUN_RX_TREAD_PRIO"
#define TUN_REGVALUE_TMCTHREAD_STACK_SIZE_NAME      "TUNER_RX_STACK"
#endif
#define TUN_REGVALUE_STACK_SIZE_NAME      "TUNER_STACK"


#define TUN_FEATURE_AF_MODE_MAN                    0x00000001
#define TUN_FEATURE_AF_MODE_MASK_ON               0x00000001

#define TUN_FEATURE_AF_MODE_MASK_OFF           0x00000000
#define TESTMODE_AUDIBLETUNER_MASK        0x10   //bitwise 00010000

#define TUN_REGISTRY_VERSIONS    "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS"
#define TUN_REGISTRY_KEY_ADR_HW  "ADR_HW_Version"
#define TUN_REGISTRY_KEY_ADR_SW  "ADR_SW_Version"


/*------------------------------------*/
/* Fc_TmcTuner data stored in flash   */
/*------------------------------------*/
// File to be created in FFS
#define TUN_TMC_FFS_FILE_NAME   "/dev/ffs/FC_TmcTuner_LMM.DAT" 
#define TUN_TMC_LEARN_MEM_FFS_FILE_NAME   "/dev/ffs/FC_TmcTuner_Learn_Mem.DAT" 





#define FC_TMCTUNER_SW_VERSION     1 


/*-----------------------------------------------------*/

#define NO_OF_BYTES_PER_LINE 230

/*------------------------------------*/
/* defines used in class tun_MsgToHMI */
/*------------------------------------*/
#define TUNER_HMI_FUNID_CARRAY_SIZE           40  // To be verified
#define TUNER_HMI_FUNID_NOTARRAY_SIZE         60  // To be verified

#define TUNER_HMI_NOTTABLE_SEM_NAME           "TUNER_HMI_NOTTABLESEM"


/*-----------------------------------------------------*/

/*------------------------------------------*/
/* defines used in class tun_MsgToTunMaster */
/*------------------------------------------*/
#define TUNER_TUNERMASTER_NOTTABLE_SEM_NAME   "TUNER_MASTER_NOTTABLESEM"



/*------------------------------------*/

#define TUNER_SEND_DATA_TO_RU_SYNC_SEM_NAME    "TUN_SENDDTATTORU_SYNC"

#define TUNER_RECV_DATA_FROM_ADR_SEM_NAME    "TUN_RXDATAFROMADR"




/*-----------------------------*/
/* Different tuner states      */
/*-----------------------------*/
#define TUNER_STATE_NOT_READY                 0x01  /* Tuner Component not ready to take any request */
#define TUNER_STATE_READY                     0x02  /* Tuner Component ready to take any request     */
#define TUNER_STATE_BLOCKED                   0x03  /* Tuner Component current busy, cannot take new request */


/*--------------------------------------*/
/* Different  seek type (u8SeekType)    */
/*--------------------------------------*/

#define TUN_SEEKTYPE_OFF                      0x00
#define TUN_SEEKTYPE_UP_AUTO                  0x01
#define TUN_SEEKTYPE_UP_SCAN_PRESET           0x02
#define TUN_SEEKTYPE_UP_SCAN_FREQUENCY        0x03
#define TUN_SEEKTYPE_UP_CONTINOUS             0x04
#define TUN_SEEKTYPE_UP_PRESET                0x05
#define TUN_SEEKTYPE_UP_STATION_LIST          0x06

#define TUN_SEEKTYPE_DOWN_AUTO                0x07
#define TUN_SEEKTYPE_DOWN_SCAN_PRESET         0x08
#define TUN_SEEKTYPE_DOWN_SCAN_FREQUENCY      0x09
#define TUN_SEEKTYPE_DOWN_CONTINOUS           0x0a
#define TUN_SEEKTYPE_DOWN_PRESET              0x0b
#define TUN_SEEKTYPE_DOWN_STATION_LIST        0x0c

#define TUN_SEEKTYPE_AUTOTP_UP                0x0d
#define TUN_SEEKTYPE_AUTOTP_DOWN              0x0e

#define TUN_PTY_UP                            0x0f
#define TUN_PTY_DOWN                          0x10


#define TUN_TMC_UP                            0x11
#define TUN_TMC_DOWN                          0x12


#define TUN_ATFREQUENCY_UP                   0x00
#define TUN_ATFREQUENCY_DOWN                 0x01

/*--------------*/
/* Tuner trace  */
/*--------------*/

#define TUN_TRACE_HELP                       	0x00
#define TUN_TRACE_ACT_DATA                   	0x02
#define TUN_TRACE_NEW_RDBID_DATA             	0x03
#define TUN_TRACE_WRITE_TO_FLASH             	0x04
#define TUN_TRACE_READ_FROM_FLASH            	0x05
#define TUN_TRACE_GET_CURRENT_RDBID_DATA     	0x06
#define TUN_TRACE_SET_TIME_GRP_8A_MSG_SEND   	0x07
#define TUN_TRACE_SET_TIME_SEL_BG_TUN        	0x08
#define TUN_TRACE_SET_DIAG_MEASUREMENT       	0x0B
#define TUN_TRACE_SET_RAW_MESSAGE_TO_ADR     	0x0C
#define TUN_TRACE_TUN_DRVADRIF               	0x0D
#define TUN_TRACE_TUN_DRVADRIF_GET_INFO      	0x01
#define TUN_TRACE_TUN_DRVADRIF_RESET_ADR     	0x02
#define TUN_TRACE_TUN_MSGTOADR               	0x0E
#define TUN_TRACE_TUN_MSGTOADR_SETCONFIGURATION 0x01
#define TUN_TRACE_TUN_CONFIG                 	0x0F
#define TUN_TRACE_TUN_CONFIG_PRINT             	0x01
#define TUN_TRACE_TUN_CONFIG_SET_TO_DEFAULT    	0x02
#define TUN_TRACE_TUN_CONFIG_READ_KDS          	0x03
#define TUN_CHECK_CONTAINER                  	0x10
#define TUN_POST_SELF_MSG_SEEK            		0x11
#define TUN_CHANGE_BAND                         0x14
#define TUN_RESET_ADR							0x15
#define TUN_CMD_FEATURE_HIGHCUT                 0x20
#define TUN_CMD_FEATURE_SHARX                   0x21
#define TUN_ADR_RESET                           0x22
#define TUN_SDS_DIRECT_FREQUENCY                0x23
#define TUN_SEND_COMMIT                         0x24
#define TUN_CMD_TESTMODE						0x25
#define TUN_POST_SELF_MSG_SEL_LIST_ELEM			0x26
#define TUN_POST_SELF_MSG_SET_ENGG_PARAM		0x27
#define TUN_POST_SELF_MSG_GET_ENGG_PARAM		0x29
#define TUN_POST_SELF_MSG_SET_ACTIVE_PRSEST_LIST 0x28
#define TUN_POST_SELF_MSG_SET_VOLUME_INFO 		0x30
#define TUN_POST_SELF_MSG_SET_SPEED_INFO 		0x31
#define TUN_POST_SELF_MSG_GET_AVAIL_BAND_RANGE 	0x32
#define TUN_POST_SELF_MSG_UPDATE_CONFIGLIST 	0x33
#define TUN_POST_CM_EVALUATIONPARAMETER 		0x34
#define TUN_GET_CURRENTSTATE_UPDATES 			0x35
#define TUN_POST_SELF_MSG_DEFAULT_SETTINGS 		0x36
#define TUN_POST_SELF_MSG_SET_DEMODULATION_SWITCH 0x37
#define TUN_POST_SELF_MSG_SELECT_HD_AUDIOPRGM 	0x38
#define TUN_POST_SELF_MSG_SET_DRM_TESTMODE 		0x39
#define TUN_POST_SELF_MSG_SET_DRM_AUDIOSERVICEDIRECT 0x40
#define TUN_POST_SELF_MSG_SET_ENHANCED_TESTMODE 0x41
#define TUN_POST_SELF_MSG_SET_PI 				0x42
#define TUN_POST_SELF_MSG_SET_DIRECT_FREQUENCY 	0x43
#define TUN_POST_SELF_MSG_SEL_HD_AUDIOPRGMDIRECT 0x44
#define TUN_POST_SELF_MSG_ADR3COMMICATIONERR	0x45
#define TUN_POST_SELF_MSG_SET_HD_SECTION_PARAMETER 0x46
#define TUN_POST_SELF_MSG_HD_RESET_TRANSITIONCOUNT 0x47
#define TUN_POST_SELF_MSG_GET_CONFIG_LIST 		0x49
#define TUN_POST_SELF_MSG_GET_CALIBRATION_DATA 	0x48
#define TUN_POST_SELF_MSG_PRESET_HANDLING 		0x067
#define TUN_POST_SELF_MSG_JAPAN_SET_AREA 		0x50
#define TUN_POST_SELF_MSG_JAPAN_CHANGE_STATION_NAME 0x51
#define TUN_POST_SELF_MSG_USER_PROFILE_UPDATE 0x52
#define TUN_POST_SELF_MSG_LANGUAGE_SETTING 0x53
#define TUN_POST_SELF_MSG_RESET_MUTECOUNTER 0x54
#define TUN_POST_SELF_MSG_SENSOR_POSITION		0x55
#define TUN_POST_SELF_MSG_PRESET_STORAGE_PS_FREEZE	0x56
#define TUN_POST_SELF_MSG_JAPAN_SELECT_STATION_NAME 0x57
#define TUN_POST_SELF_MSG_DDA            		0x58
#define TUN_POST_SELF_MSG_AF            		0x59

#define TUN_POST_SELF_MSG_ATFREQUENCY                          0x60 
#define TUN_POST_SELF_MSG_ANNOUNCEMENT_ESCAPE                  0x61
#define TUN_POST_SELF_MSG_ANNOUNCEMENT_SWITCH                  0x62       
#define TUN_POST_SELF_MSG_CHANGE_LSM                           0x63
#define TUN_POST_SELF_MSG_GET_STATIC_LIST                      0x64

#define TUN_POST_SELF_MSG_ANNOSWITCH         0x65
#define TUN_POST_SELF_MSG_ANNOINFO           0x66
#define TUN_POST_SELF_MSG_ANNOMSG            0x69
#define TUN_POST_SELF_MSG_AUDIOSOURCE        0x68

#define TUN_TRACE_SET_MAN_TUNE_STEPS         0x09

#define TUN_TRACE_SET_MAN_TUNE_TIMER          0x0A

#define TUN_NEW_POST_SELF_HEADER    0xFE
/*-------------------------------------------------------------*/
/* From trace command get actual data for below defined class  */
/*-------------------------------------------------------------*/
#define TU_ACTDATA_MAINSTATUS                0x00  /* class tun_Data_MainStatus        */
#define TU_ACTDATA_STATION                   0x01  /* class tun_Data_Station           */
#define TU_ACTDATA_GET_LIST_ELEM             0x02  /* class tun_Data_GetStaticListElem */
 

/*-----------------------------------*/
/* PS Name maximum size of the array */
/*-----------------------------------*/

#define TUN_PS_NAME_MAX_SIZE				8
#define TUN_HD_CALLSIGN_MAX_SIZE			16
#define TUN_DRM_SERVICE_LABEL_MAX_SIZE      64

/*-----------------------------------*/
/* This is added for the Packed info */
/* for Config list element           */
/*-----------------------------------*/
#define TUN_CONFIG_PACKINFO_TP                  0x01
#define TUN_CONFIG_PACKINFO_TP_SELF             0x02
#define TUN_CONFIG_PACKINFO_PTY_DYNAMIC         0x04
#define TUN_CONFIG_PACKINFO_PS_DYNAMIC          0x08
#define TUN_CONFIG_PACKINFO_TMC_RESERVED        0x10
#define TUN_CONFIG_PACKINFO_TMC_YES             0x20
#define TUN_CONFIG_PACKINFO_TMC_NO              0x00

/* This is added to check for the bits 4 & 5 for TMC_NO */

#define TUN_CONFIG_MASK_FOR_TMC_NO              0x30


// Defines needed for tun_MsgFromHMI - Manual ticks.

#define TUN_MSGFROMHMI_NOOF_TICKS_1             0x01

/*----------------------*/
/* Band change status.  */
/*----------------------*/
#define TUN_BAND_CHANGE_INPROGRESS              0x01
#define TUN_BAND_CHANGE_COMPLETE                0x02


// When TUN1 is in BG, internally RU switches to FM
#define TUN_TEMP_FM                             0x01

/*----------------------*/
/* Static list ID.  */
/*----------------------*/
#define TUN_STATIC_LIST_ID_INVALID              0xff


/*-------------------------*/
/* Mixed preset list info  */
/*-------------------------*/
#define TUN_MIXED_PRESET_LIST_ID_1              0x00

// Maximum size of the RText recieved from RU.
#define TUN_RTEXT_CHARS_MAX                     64
// RText type A
#define TUN_RTEXT_TYPE_A                        0x00
// RText type B
#define TUN_RTEXT_TYPE_B                        0x10

#define TUN_RTEXT_TYPE_MASK                     0x10

// The RU message received from message 0x6d, starting from offset,
// the raw data can be read.
#define TUN_R_GET_DATA_RDS_RAW_OFFSET           5

#define TUN_RDS_GROUP_2                         0x02

#define TUN_RDS_GROUP_2_TYPE_A                  0x00


#ifndef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG

#define TUN_RDS_GROUP_2_TYPE_B                  0x08

#endif



#define TUN_RTEXT_GROUP_TYPE_MASK               0x08

#define TUN_RTEXT_TEXT_SPACE                    0x20

// RText reception status for TYPE A and B
#define TUN_RTEXT_DATA_INVALID                  0x01
#define TUN_RTEXT_DATA_RECEPTION_START          0x02
#define TUN_RTEXT_DATA_RECEPTION_INPROG         0x03
#define TUN_RTEXT_DATA_RECEPTION_COMPLETE       0x04

// R-Text - current data reception position mask
#define TUN_RTEXT_DATA_RECEPTION_MASK           0x0f

#define TUN_RTEXT_DATA_RECEPTION_FIRST_DATA     0x00
#define TUN_RTEXT_DATA_RECEPTION_LAST_DATA      0x0f

// Invalid Grp only for initialization purpose.
#define TUN_RTEXT_CURRENT_GRP_INVALID           0xff
// Invalid Typ only for initialization purpose.
#define TUN_RTEXT_CURRENT_TYP_INVALID           0xff

#define TUN_RTEXT_INVALID_PI                    0xffff

#define TUN_MIXEDPRESET_LIST_FIRST_ELEMENT      00

#define TUN_MIXEDPRESET_LIST_LAST_ELEMENT       24

#define TUN_MIXEDPRESET_LISTID_FMAM             00

#define TUN_CHAR_INVALID                      	0xFFFF

/*-------------------------------------------------------*/
/* List type can be static OR config used for selecting  */
/* Saving list elements.                                 */ 
/*-------------------------------------------------------*/
//#define TUN_LIST_TYPE_STATIC                    0x00 //already defined in tun_MsgDefines.h
//#define TUN_LIST_TYPE_CONFIG                    0x01 //already defined in tun_MsgDefines.h

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG

#define TUN_RDS_GROUP_2_TYPE_B                  1/*type B -> 32 byte RT msg is coming from RDS*/

#endif

/*----------------------*/
/* Set Antenna.  */
/*----------------------*/

#define TUN_ANTENNA1                            0x01
#define TUN_ANTENNA2                            0x02

/*----------------------*/
/* Set Diag Mode.       */
/*----------------------*/

#define DIAGMODE_ENABLE                          0xD6
#define DIAGMODE_DISABLE                         0x00

/*-----------------------*/
/* Operation             */
/*-----------------------*/
#define OPERATION_DISABLE                        0
#define TUN_OPERATION_TP                         16
#define TUN_OPERATION_BG                         32

//TO ENABLE/DISABLE AF JUMP FEATURE

#define TUN_AF_JUMP                                      0x01

#define TUN_AF_JUMP_TUNER_ACTION_ENABLE                  0x01

#define TUN_AF_JUMP_TUNER_ACTION_DISABLE                  0x00

//SPM System States defines
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	
	#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#ifndef GTEST_x86LINUX_BUILD
	#include "spm_fi_if.h"
	
	#define SPM_SYSTEM_STATE_STANDBY                    spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_LANDSCAPE_SCAN
	#define SPM_SYSTEM_STATE_OFF                        spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_OFF
	#define SPM_SYSTEM_STATE_ON                         spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_ON
	
	#define CVM_CRITICAL_LOW_VOLTAGE_START				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START
	#define CVM_CRITICAL_LOW_VOLTAGE_END				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END
	#define CVM_LOW_VOLTAGE_START						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START
	#define CVM_LOW_VOLTAGE_END							spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END
	#define CVM_HIGH_VOLTAGE_START						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START
	#define CVM_HIGH_VOLTAGE_END						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END
	#define CVM_CRITICAL_HIGH_VOLTAGE_START				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START
	#define CVM_CRITICAL_HIGH_VOLTAGE_END				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END
	#define CVM_NO_EVENT								spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT
#else /*Build error resolution*/
	#define SPM_SYSTEM_STATE_STANDBY	0x02
	#define SPM_SYSTEM_STATE_OFF		0x00
	#define SPM_SYSTEM_STATE_ON			0x01
	#define CVM_CRITICAL_LOW_VOLTAGE_START	0x01
	#define CVM_CRITICAL_LOW_VOLTAGE_END	0x02
	#define CVM_LOW_VOLTAGE_START			0x03
	#define CVM_LOW_VOLTAGE_END				0x04
	#define CVM_HIGH_VOLTAGE_START			0x05
	#define CVM_HIGH_VOLTAGE_END			0x06
	#define CVM_CRITICAL_HIGH_VOLTAGE_START	0x07
	#define CVM_CRITICAL_HIGH_VOLTAGE_END	0x08
	#define CVM_NO_EVENT					0x0f
#endif
#else

	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_SERVICEINFO
	#include "cfc_fi_if.h"
	
	#define SPM_SYSTEM_STATE_STANDBY                    cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY
	#define SPM_SYSTEM_STATE_OFF                        cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF
	#define SPM_SYSTEM_STATE_ON                         cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON
	
	#define CVM_CRITICAL_LOW_VOLTAGE_START				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START
	#define CVM_CRITICAL_LOW_VOLTAGE_END				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END
	#define CVM_LOW_VOLTAGE_START						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START
	#define CVM_LOW_VOLTAGE_END							cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END
	#define CVM_HIGH_VOLTAGE_START						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START
	#define CVM_HIGH_VOLTAGE_END						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END
	#define CVM_CRITICAL_HIGH_VOLTAGE_START				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START
	#define CVM_CRITICAL_HIGH_VOLTAGE_END				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END
	#define CVM_NO_EVENT								cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT
#endif

//Set RDBID parameters.
#define RDBIDCC  0x0F
#define RDBIDLTN 0x3F
#define RDBIDSID 0x3F

#define TUN_RDBID_LIST_ARRAY_MAX_SIZE               160

#define TUN_LASTPASSED_FREQ_BIT     	   0x02
#define TUN_LASTPASSED_FREQ_ENABLE     	   0x02
#define TUN_LASTPASSED_FREQ_DISABLE    	   0xFD

//Preset Action
#define RECALL_ELEMENT 0
#define SAVE_ELEMENT  1
#define DELETE_ONE_ELEMENT 2
#define DELETE_ALL_ELEMENTS 3
#define SPECIALSAVE_ELEMENT 4
#define GET_ALL_ELEMENTS 5

#define TUN_SCAN_PRESET      0x02
#define TUN_SCAN_FREQUENCY   0x03
#define TUN_SCAN_PI          0x1B

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#define AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION ((u32Freq >= 542 && u32Freq <= 621) ||\
	   (u32Freq >= 698 && u32Freq <= 777) ||\
	   (u32Freq >= 853 && u32Freq <= 932) ||\
	   (u32Freq >= 1008 && u32Freq <= 1088) ||\
	   (u32Freq >= 1164 && u32Freq <= 1243)||\
	   (u32Freq >= 1320 && u32Freq <= 1399)||\
	   (u32Freq >= 1475 && u32Freq <= 1554)\
	   )
#else
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
#define AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION ((u32Freq >= 586 && u32Freq <= 617) ||\
	   (u32Freq >= 736 && u32Freq <= 767) ||\
	   (u32Freq >= 887 && u32Freq <= 918) ||\
	   (u32Freq >= 1037 && u32Freq <= 1068) ||\
	   (u32Freq >= 1187 && u32Freq <= 1219)||\
	   (u32Freq >= 1338 && u32Freq <= 1369)||\
	   (u32Freq >= 1488 && u32Freq <= 1519)||\
	   (u32Freq >= 1638 && u32Freq <= 1670)||\
	   (u32Freq >= 135 && u32Freq <= 166)||\
	   (u32Freq >= 285 && u32Freq <= 316)\
	   )
#else
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
#define AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION ((u32Freq >= 542 && u32Freq <= 621) ||\
	   (u32Freq >= 698 && u32Freq <= 777) ||\
	   (u32Freq >= 853 && u32Freq <= 932) ||\
	   (u32Freq >= 1008 && u32Freq <= 1088) ||\
	   (u32Freq >= 1164 && u32Freq <= 1243)||\
	   (u32Freq >= 1320 && u32Freq <= 1399)||\
	   (u32Freq >= 1475 && u32Freq <= 1554)\
	   )
#else
#define AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION ((u32Freq >= 504 && u32Freq <= 535) ||\
	   (u32Freq >= 764 && u32Freq <= 795) ||\
	   (u32Freq >= 1023 && u32Freq <= 1055) ||\
	   (u32Freq >= 1283 && u32Freq <= 1314) ||\
	   (u32Freq >= 1543 && u32Freq <= 1574)\
	   )
#endif
#endif
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#define TUN_PWM_HIGH_CORRECTEDFREQUENCY   301000
#else
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
#define TUN_PWM_HIGH_CORRECTEDFREQUENCY   300750
#else
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
#define TUN_PWM_HIGH_CORRECTEDFREQUENCY   301000
#else
#define TUN_PWM_HIGH_CORRECTEDFREQUENCY   519500
#endif
#endif
#endif

#define AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION_SYNC1_RANGE1 ((u32Freq >= 520 && u32Freq <= 580) ||\
	   (u32Freq >= 620 && u32Freq <= 780) ||\
	   (u32Freq >= 820 && u32Freq <= 980) ||\
	   (u32Freq >= 1020 && u32Freq <= 1180) ||\
	   (u32Freq >= 1220 && u32Freq <= 1380)||\
	   (u32Freq >= 1420 && u32Freq <= 1580)||\
	   (u32Freq >= 1620 && u32Freq <= 1710)\
	   )
	   
#define AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION_SYNC1_RANGE2 ((u32Freq >= 581 && u32Freq <= 619) ||\
	   (u32Freq >= 781 && u32Freq <= 819) ||\
	   (u32Freq >= 981 && u32Freq <= 1019) ||\
	   (u32Freq >= 1181 && u32Freq <= 1219) ||\
	   (u32Freq >= 1381 && u32Freq <= 1419)||\
	   (u32Freq >= 1581 && u32Freq <= 1619)\
	   )
	   
#define AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION_SYNC3_RANGE1 ((u32Freq >= 520 && u32Freq <= 880) ||\
	   (u32Freq >= 930 && u32Freq <= 1340) ||\
	   (u32Freq >= 1390 && u32Freq <= 1710)\
	   )
	   
#define AM_FREQUENCY_CHECK_FOR_POWER_SUPPLY_SYNCHRONIZATION_SYNC3_RANGE2 ((u32Freq >= 881 && u32Freq <= 929) ||\
	   (u32Freq >= 1341 && u32Freq <= 1389)\
	   )

#define TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC1_RANGE1   400000
#define TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC1_RANGE2   377358
#define TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC3_RANGE1   909090
#define TUN_PWM_HIGH_CORRECTEDFREQUENCY_SYNC3_RANGE2   952380

#define TUN_PWM_SYNC_GEN3	 0x00
#define TUN_PWM_SYNC_SIGNAL1 0x01
#define TUN_PWM_SYNC_SIGNAL2 0x02
#define TUN_PWM_SYNC_SIGNAL3 0x03


#define DUTYCYCLE_50	50
#define DUTYCYCLE_100	100

#define AM_FREQUENCY_RANGE_CHECK_FOR_SWITCHING_FREQUENCY  ((u32CurrentAMFrequency >= 828 && u32CurrentAMFrequency <= 900) ||\
	   (u32CurrentAMFrequency >= 1260 && u32CurrentAMFrequency <= 1341) ||\
	   (u32CurrentAMFrequency >= 1692 && u32CurrentAMFrequency <= 1710)\
	   )

#define TUN_SWITCHING_FREQUENCY_384kHz 0x01
#define TUN_SWITCHING_FREQUENCY_432kHz 0x02

#define KDS_BIT_0  0x00000001
#define KDS_BIT_1  0x00000002
#define KDS_BIT_2  0x00000004
#define KDS_BIT_3  0x00000008
#define KDS_BIT_4  0x00000010
#define KDS_BIT_5  0x00000020
#define KDS_BIT_6  0x00000040
#define KDS_BIT_7  0x00000080
#define KDS_BIT_8  0x00000100
#define KDS_BIT_9  0x00000200
#define KDS_BIT_10 0x00000400
#define KDS_BIT_11 0x00000800
#define KDS_BIT_12 0x00001000
#define KDS_BIT_13 0x00002000
#define KDS_BIT_14 0x00004000
#define KDS_BIT_15 0x00008000
#define KDS_BIT_16 0x00010000
#define KDS_BIT_17 0x00020000
#define KDS_BIT_18 0x00040000
#define KDS_BIT_19 0x00080000
#define KDS_BIT_20 0x00100000
#define KDS_BIT_21 0x00200000
#define KDS_BIT_22 0x00400000
#define KDS_BIT_23 0x00800000
#define KDS_BIT_24 0x01000000
#define KDS_BIT_25 0x02000000
#define KDS_BIT_26 0x04000000
#define KDS_BIT_27 0x08000000
#define KDS_BIT_28 0x10000000
#define KDS_BIT_29 0x20000000
#define KDS_BIT_30 0x40000000
#define KDS_BIT_31 0x80000000


#define TUN_BG_TA_DISABLE 0xFD
#define TUN_BG_TA_ENABLE  0x02
#define TUN_KDS_AVAILABLEBANDS_FM_MW_LW_MASK 0x7
#define TUN_UPDATELANDSCAPE_CB1_BIT	0x00100000
/*---------------------------------*/
/* common macros                   */
/*---------------------------------*/

#define TUN_GET_U32(pu8) ((tU32)(((tU32)((pu8)[0])<<24) + ((tU32)((pu8)[1])<<16) + ((tU32)((pu8)[2])<<8) + (pu8)[3]))
#define TUN_GET_U16(pu8) ((tU16)(((tU16)((pu8)[0])<<8) + (pu8)[1]))
#define TUN_CONFIG_DEFAULT_AVAILABLEBAND_AM_MASKVAL  0x06
#define TUN_CONFIG_DEFAULT_AVAILABLEBAND_TRF_MASKVAL 0x10
#define TUN_CONFIG_DEFAULT_AVAILABLEBAND_WB_MASKVAL 0x08
#define TUN_CONFIG_DEFAULT_TRF_LOW_FREQ  1620
#define TUN_CONFIG_DEFAULT_TRF_HIGH_FREQ  1629
#define TUN_CONFIG_DEFAULT_TRF_LSM_FREQ  1620
#define TUN_CONFIG_DEFAULT_TRF_AUTO_SEEK_STEPSIZE  9
#define TUN_CONFIG_DEFAULT_TRF_MANUAL_STEPSIZE  9
#define TUN_CONFIG_PRESETLIST_TYPE_MIXED  0x01
#define TUN_INVALID_BAND 0xff
//lint -emacro(572, TUN_DRVADRIF_SET_U32) prio2: Excessive shift
//lint -emacro(778, TUN_DRVADRIF_SET_U32) prio2: Constant expression evaluates to 0 in operation '>>'
#define TUN_SET_U32(pu8, u32)   \
    (pu8)[0]=(tU8)(((tU32)(u32)>>24)& 0xFF);       \
    (pu8)[1]=(tU8)(((tU32)(u32)>>16)& 0xFF);  \
    (pu8)[2]=(tU8)(((tU32)(u32)>>8) & 0xFF);  \
    (pu8)[3]=(tU8)(((tU32)(u32))    & 0xFF);

//lint -emacro(572, TUN_DRVADRIF_SET_U16) prio2: Excessive shift
//lint -emacro(778, TUN_DRVADRIF_SET_U16) prio2: Constant expression evaluates to 0 in operation '>>'
#define TUN_SET_U16(pu8, u16)   \
    (pu8)[0]=(tU8)(((tU16)(u16)>>8) & 0xFF);         \
    (pu8)[1]=(tU8)(((tU16)(u16))    & 0xFF);

/* Enums */
#define WB_FREQUENCY_CHECK(u32Frequency) (u32Frequency == 162400 || u32Frequency == 162425 ||\
							 u32Frequency == 162450 || u32Frequency == 162475 ||\
							 u32Frequency == 162500 || u32Frequency == 162525 ||\
							 u32Frequency == 162550 || u32Frequency == 161650 ||\
							 u32Frequency == 161775 || u32Frequency == 163275)
enum
{
  TUN_KDS_INVALID_PARAMETER_         = 255
 ,TUN_KDS_FM_AM_Tuner_Parameter_Set = 1
 ,TUN_KDS_GENERIC_Tuner_Parameter_Set = 2
 ,TUN_KDS_VARIANT_CODING = 3
 ,TUN_KDS_DRM_TUNER_PARAM_SET = 4
 ,TUN_KDS_HD_RADIO_PARAM_SET = 5

};

//Japan Station Name defines
#define AUTOMATIC_UPDATE 0
#define MANUAL_UPDATE 1
// vehicle information parameters can be found in IVI document : https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-821714/Alliance_IVI_DiagnosticServices_V3.2.pdf
#define JAPAN_REGION 0x19
#define JAPAN_AREACODE_READ_FROM_KDS 0xfe
#define CHANESTATIONNAMETIMEOUT 10000 //10sec timeout
//structure defined to pass only relevant data from clJapnStationName to required file
struct TunerJapanStationName
{
	unsigned short u16IndexID;
	tunerString sJpnStnName;
	TunerJapanStationName()
	{
		u16IndexID= 0;
		sJpnStnName="";
	};
};
#define SUPPRESS_STATION_NAME 0xff

#define AUDIO_MUTED 1

#define TUN_HICUT_LIMIT 8
#define TUN_SHARX_LIMIT 8

#endif /* TUNER_DEFINES_H */
/*** END OF FILE *************************************************************/
