/************************************************************************
* FILE:           tun_Utility.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Tuner Utility tasks are done .
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 12.05.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef TUN_UTILITY_H
#define TUN_UTILITY_H

#define TUN_INVALID_UTF8_CHAR          0xffff
#define TUN_INVALID_UNICODE_CHARACTER  0xffff
#define TUN_INVALID_EBUCODE_CHARACTER  0xff
#define TUN_CHAR_SPACE                 0x20

#define TUN_CRC32_POLYNOM          0xEDB88320UL /* polynom for CRC32 generation */
#define TUN_CRC32_DEFAULT          (tU32)(~0x00000000UL)/* Start value for CRC32 calc.*/
#define TUN_CRC32_RESULT(a)        (~(a))       /* CRC32-value to compare with. */


/** vnd4kor: importing std map required for list id map */
#include <map>
#include <list>

using namespace std;

/*------------------------------*/
/* class tu_Manager definition  */
/*------------------------------*/


class tun_Utility
{
private:
	 /** Maping of HMI List ID with ADR List Id */
  typedef std::map<tU8, tU16> mapRdsEBU2Unicode;
  mapRdsEBU2Unicode m_mapRdsEBU2Unicode;

public:

	tun_Utility();
 
  tVoid vConvert16BitTo2SeparateBytes( tU8* pu8Message, tU16 u16Frequency )const;

  tU16 u16Convert2SeparateBytesTo16Bit( const tU8* pu8NewData )const;

  tVoid vConvert32BitTo4SeparateBytes( tU8* pu8Message, tU32 u32Frequency )const;

  tU32 u32Convert4SeparateBytesTo32Bit( const tU8* pu8NewData )const;

  tU32 u32Convert3SeparateBytesTo32Bit( const tU8* pu8NewData) const;

  // Converts the RDS data received in air to Unicode
  tU16 u16ConvertFromRdsEBU2Unicode( tU8 u8RdsChar )const;

  // Converts the Unicode character to UTF8 equivalent:
  tU32 u32ConvertFromUnicode2UTF8( tU16 u16UnicodeChar )const;

  // Converts the RDS data in Air to UTF8 equivalent:
  tU32 u32ConvertFromRdsEBU2UTF8( tU8 u8RdsChar )const;

  tU32 u32GetCRC32( tU8 u8Data, tU32 u32PrevCRC) const;

  tU32 u32CalculateCRC32( tPU8 pu8Data, tU32 u32Length) const;
};


#define TUN_ASSERT_RETURN(expr)                 \
    if (!(expr)) {                              \
        NORMAL_M_ASSERT_ALWAYS();               \
        return;                                 \
    }

#define TUN_ASSERT_RETURN_VAL(expr, retval)     \
    if (!(expr)) {                              \
        NORMAL_M_ASSERT_ALWAYS();               \
        return (retval);                        \
    }

	
#endif /* TUN_UTILITY_H */
/*** END OF FILE *************************************************************/
