/************************************************************************
* FILE:         tun_SPMClient.h
* PROJECT:      g3g
* SW-COMPONENT: Tuner server
*----------------------------------------------------------------------
*
* DESCRIPTION: FC_TmcTuner registers as client to SPM 
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author               | Modification
* 12.09.06  | RBIN/EDI1 Dinesh     | initial version
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef TUN_SPM_CLIENT_H
#define TUN_SPM_CLIENT_H

// use AIL template with MessageMaps
#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#ifndef GTEST_x86LINUX_BUILD
	#include "spm_fi_if.h"
#endif
#else
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_SERVICEINFO
	#include "cfc_fi_if.h"
#endif

// Use OSAL defines
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "tun_Class_ForwardDecl.h"


// Copro reset/ normal indication
#define TUN_CRITICAL_STATUS_COPRO_BIT               0x01

// Component stable/unstable indication
#define TUN_CRITICAL_STATUS_COMP_STABLE_BIT         0x02

// Copro reset happened during undervoltage
#define TUN_CRITICAL_STATUS_COPRO_RESET_LOWVOLT_BIT 0x04


// Copro has gone to standby mode
#define TUN_CRITICAL_STATUS_COPRO_STANDBY_BIT       0x08


// Undervoltage indication
#define TUN_CRITICAL_STATUS_LOWVOLTAGE_BIT          0x10



// forward declarations
//class tuner_tclApp;
class clConfigInterface;


/*------------------------------------*/
/* class tun_tclSPMClient definition  */
/*------------------------------------*/
class tun_tclSPMClient : public ahl_tclBaseWork
{
private:

	// Pointer to class tuner_tclApp.
	tuner_tclApp*   poGWMain;
	tun_MsgToADR*    m_potun_MsgToADR;
	tun_MsgToHMI*	m_potun_MsgToHMI;
    tun_ActualData*   m_potun_ActualData;
    tun_HMIManager*   m_potun_HMIManager;
    tun_Config*       m_potun_Config;
    clConfigInterface* 	m_poclConfigInterface;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	clAars_CM_UpdateLandscape* m_poclAars_CM_UpdateLandscape;
#endif

      /*----------------*/
  /* Tuner Manager  */
  /*----------------*/   
  tu_Manager* m_potu_Manager;

  
   // Store the RegID of the registered service   
   tU16  m_u16SrvRegID; 


   tBool m_fFidSysStateReg;

   tBool m_fFidCVMReg;
   
   // Store the copro state
   tU32 m_u32CoproState;

   // Store the voltage state
   tU32 m_u32VoltageEvent;

   // Critical status bits
   tU8 m_u8CriticalStatus;

   // High Voltage on startup?
   tBool m_fIsHighVoltageOnStartup;

 
   /*---------------------------------------------------------------------*/
   
   // Function to register for required service
   virtual tBool fRegisterForService();
   
   /*---------------------------------------------------------------------*/
   
   // Function to unregister for required service
   tBool fUnregisterForService();
   
   /*---------------------------------------------------------------------*/
   
   // Function to register for FID (upreg)
   tBool fRegisterForFID(tU16 u16FID);
   
   /*---------------------------------------------------------------------*/

   // Function to unregister for FID (relupreg)
   tBool fUnregisterForFID(tU16 u16FID);

   /*---------------------------------------------------------------------*/   

protected:
  /*---------------------------------------------------------------------*/
     // Function to handle unknown messages
   virtual tVoid vOnUnknownMessage
                  (
                  amt_tclBaseMessage* poMessage
                  );
#ifndef GTEST_x86LINUX_BUILD
   virtual tVoid vSendMessage ( tU16             u16DestAppID,
                        const fi_tclTypeBase&  oOutData,
                        tU16             u16Fid,
                        tU8              u8OpCode,
                        tU16             u16CmdCtr,
                        tU16             u16RegId);
#endif
public:

//Functions to set the pointers to other classes

	tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR );
	tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData );
	tVoid vSet_tu_Manager_Ptr( tu_Manager* potu_Manager );
	tVoid vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* m_potun_MsgToHMI );
  tVoid vSet_tun_HMIManager_Ptr( tun_HMIManager* m_potun_HMIManager );
  tVoid vSet_tun_Config_Ptr( tun_Config* potun_Config );
  tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tVoid vSet_UpdateLandscape_Ptr( clAars_CM_UpdateLandscape* poclAars_CM_UpdateLandscape );
#endif

     tBool m_LowvoltState;

    // constructor
    tun_tclSPMClient (tuner_tclApp* poMain);
	tun_tclSPMClient();//default constructor is added to remove lint warning

   /*---------------------------------------------------------------------*/

   // destructor
   virtual ~tun_tclSPMClient();
      
   /*---------------------------------------------------------------------*/

   // Function to handle new app state
   tVoid vOnNewAppState
      (
      tU32 u32OldAppState, 
      tU32 u32AppState
      );
   
   /*---------------------------------------------------------------------*/
      
   // Function to handle CVM status
   /** Vnd4kor: Made function const to avoid lint */
   tVoid  vHandleCVM
      (
       amt_tclServiceData* poMessage
      ) ;

   //Function to handle the System state property from SPM
   tVoid vHandleSysState( amt_tclServiceData* poMessage );
   /*---------------------------------------------------------------------*/
   
   // Function to handle the service state changes
   tVoid vOnServiceState
      ( 
      tU16 u16ServiceId,
      tU16 u16ServerId,
      tU16 u16RegisterId, 
      tU8  u8ServiceState,
      tU16 u16SubId
      );

   /*---------------------------------------------------------------------*/      

   // Set the voltage after getting the voltage state from main application
   tVoid vSetVoltageState (tU32 u32Event);

   /*---------------------------------------------------------------------*/   

   /*---------------------------------------------------------------------*/   
   
   // Get the current critical component status
   tU8 u8GetCriticalStatus ()const;

   /*---------------------------------------------------------------------*/
   
   // Get the current copro state
   tU32 u32GetActualCoproState ()const;

   /*---------------------------------------------------------------------*/

   // Get the current voltage state
   tU32 u32GetVoltageState ()const;

   /*---------------------------------------------------------------------*/
   void vRestartSBRProcess();

   DECLARE_MSG_MAP(tun_tclSPMClient)
};

#endif //TUN_SPM_CLIENT_H
