/************************************************************************
* FILE:           tun_MsgToHMI.h
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All messages sent to HMI are handled in this file.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 01.04.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef TUN_MSGTOTUNMASTER_H
#define TUN_MSGTOTUNMASTER_H

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 
/*----------------------------------------------------------------------*/
#include "tun_MsgDefines.h"
#include "tun_Class_ForwardDecl.h"
#include "tun_DrvAdrIf.hpp"


/*--------------------------------------*/
/* class tun_MsgToTunMaster definition  */
/*--------------------------------------*/

class tun_MsgToTunMaster : public TUN_Singleton< tun_MsgToTunMaster>, public tun_MsgHandler< tun_MsgToTunMaster>
{
  friend class TUN_Singleton< tun_MsgToTunMaster>;

private:

     // Get the Data from AMT
   tVoid vGetDatafromAMT( amt_tclServiceData* poFIMsg,fi_tclTypeBase& oFIData )const;

   template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
   /* this function must not be used, therefore it is private */
   tun_MsgToTunMaster& operator=(const tun_MsgToTunMaster& c);
   

  /*-------------*/
  /* Constructor */
  /*-------------*/
protected:
  tun_MsgToTunMaster();
  /* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
   tun_MsgToTunMaster(const tun_MsgToTunMaster& c);

public:

 /*-------------*/
 /* Destructors */
 /*-------------*/
  virtual ~tun_MsgToTunMaster( );


  tVoid vSet_tuner_tclApp_Ptr( tuner_tclApp* potunerMainApp);

  tVoid vSet_tun_HMIManager_Ptr( tun_HMIManager* potun_HMIManager );

  tVoid vSet_tun_Utility_Ptr( tun_Utility* potun_Utility );

  tVoid vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI );
   
  tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData );

  /*----------------------------------------------------------------------*/
  /* Add new (HMI UpReg) Function ID registration in the Nototable table  */
  /*----------------------------------------------------------------------*/
  tBool bAddNotificationTable ( const amt_tclServiceData* poMessage );

  /*--------------------------------------------------------------------*/
  /* Remove (HMI UpReg) Function ID registration in the Nototable table */
  /*--------------------------------------------------------------------*/
  tBool bRemoveNotification( const amt_tclServiceData* poMessage );

  /*-----------------------------------------------------------------------------------*/
  /* Remove All entries (HMI UpReg) of Function ID registration in the Nototable table */
  /*-----------------------------------------------------------------------------------*/
  tVoid vRemoveAllEntriesWithRegID( tU16 u16ServiceID, tU16 u16RegisterID );


                                 

 tVoid vSendError( amt_tclServiceData* poMessage, tU16 u16ErrorCode  );
  
  tun_HMIManager* m_potun_HMIManager;
  tun_MsgToHMI* m_potun_MsgToHMI;

  tuner_tclApp*   poGWMain;

  tun_Utility* m_potun_Utility;
  tun_ActualData* m_potun_ActualData;

  tVoid vSend_g_Component_Status();

  tVoid bSendStatus(tU16 u16FID );

  virtual tVoid vSendMessage( tU16             u16DestAppID,
                      const fi_tclTypeBase&  oOutData,
                      tU16             u16Fid,
                      tU8              u8OpCode,
                      tU16             u16CmdCtr,
                      tU16             u16RegId);
	tVoid vMessage( trMsg_CM_ATStationInfo_Status* pu8Message) const;

  /*-------------------------------------*/
  /* Notification table : HMI client     */
  /*-------------------------------------*/
  //ahl_tFunction            m_aFuncID_HMI_Array[TUNER_HMI_FUNID_CARRAY_SIZE];     
  //ahl_tNotification        m_aNotArray_HMI[TUNER_HMI_FUNID_NOTARRAY_SIZE]; 
  
  static OSAL_tSemHandle     m_hNotHMITableSem;  

  
};


#endif /* TUN_MSGTOTUNMASTER_H */
