/************************************************************************
* FILE:           tun_MsgToADR.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    All the message sent to RU is sent by this class.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 21.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai* 02.09.2013 | vnd4kor  | added ConfigListID enum
*************************************************************************/


#ifndef TUN_MsgToADR_H
#define TUN_MsgToADR_H

#include "tun_Class_ForwardDecl.h"
#include "tun_Singleton.h"
#include "tun_Config.h"
#include "AarsApp/clAarsHandler.h"

/** vnd4kor: importing std list required for m_listPresetAction */
#include <list>

using namespace std;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
class clAars_ATPresetList_XX;
#endif
/*----------------*/
/* Defines        */
/*----------------*/
#define TUN_INIT_UNUSED_BYTE  0xAA
#define TUN_AREA_EU           0x00
#define TUN_AREA_NAR          0x02
#define TUN_PRESET_FM_MIN     0x01
#define TUN_PRESET_FM_MAX     0X0C
#define TUN_PRESET_FM1_MAX    0X06
#define TUN_VAR1_2FE_DDA	  0x01
#define TUN_VAR2_1FE		  0x02
#define TUN_VAR45_2FE		  0x2D
#define TUN_VAR47_2FE		  0x2F
#define TUN_VAR48_3FE		  0x30
#define TUN_VAR49_3FE		  0x31
#define TUN_VAR50_3FE		  0x32
#define TunVar51_2FE_AM_2FE				0x33
#define TunVar52_3FE_AM_2FE_DDA			0x34
#define TunVar55_4FE_AM_2FE_DDA_DAB		0x37
#define TunVar56_4FE_AM_2FE_DAB_NO_FM2  0x38
#define TunVar57_3FE_AM_2FE				0x39
#define TunVar61_2FE_AM_2FE_DAB			0x3d
#define TunVar62_3FE_AM_2FE_DDA_DAB		0x3e
#define TunVar63_3FE_AM_2FE_DAB         0x3f
#define TunVar64_4FE_AM_2FE_DDA_DAB     0x40
#define TunVar66_2FE_DAB				0x42
#define TunVar67_3FE_DDA_DAB			0x43
#define TunVar68_3FE_DAB				0x44
#define TunVar69_4FE_DDA_DAB			0x45
#define TunVar70						0x46
#define TunVar71						0x47

#define ADR_SW_CUSTOMER_VERSION_LENGTH 10
#define ADR_SW_CUSTOMER_ADDITIONALVERSION_LENGTH 16

#define PSA_COMBIBAND_VALUE 0x10000006

/*============================================================================
 * Client ID
 *--------------------------------------------------------------------------*/
typedef enum
{
  enClientId_undefined       = 0x0000,
  enClientId_AmFmTuner       = 0x0010,
  enClientId_TMCTuner        = 0x0011,
  enClientId_Startup         = 0xFFFF
} tun_tenClientId;
/*==========================================================================*/

/*============================================================================
 * Function Block ID
 *--------------------------------------------------------------------------*/
typedef enum
{
  enFBlockId_undefined       = 0x0000,
  enFBlockId_AmFmTuner       = 0x0040,
  enFBlockId_TMCTuner        = 0x0041

} tun_tenFBlockId;
/*==========================================================================*/

/*============================================================================
 * Instance ID
 *--------------------------------------------------------------------------*/
typedef enum
{
  enInstanceId_undefined       = 0x00,
  enInstanceId_AudioSource1    = 0x01,
  enInstanceId_AudioSource2    = 0x02,
  enInstanceId_All             = 0xFF

} tun_tenInstanceId;
/*==========================================================================*/

/*============================================================================
 * Message Header
 *--------------------------------------------------------------------------*/
typedef enum
{
 enAdrMsgOffset_CLIENT_ID   =  0,  /*   2 bytes        */
 enAdrMsgOffset_FBLOCK_ID   =  2,  /*   2 bytes        */
 enAdrMsgOffset_INSTANCE_ID =  4,  /*   1 byte         */
 enAdrMsgOffset_FKT_ID      =  5,  /*   2 bytes        */
 enAdrMsgOffset_OP_TYPE     =  7,  /*   1 byte         */
 enAdrMsgOffset_DATA_LEN    =  8,  /*   2 bytes        */
 enAdrMsgOffset_DATA        = 10,  /*                  */
 enAdrMsgOffset_HEADER_LEN  = 10  /* = 10 bytes header */
} tun_tenAdrMsgOffsets;

/*============================================================================
 * ERROR
 *--------------------------------------------------------------------------*/
typedef enum
{
  enErrorCodes_idx_ErrorCode                     = 10, enErrorCodes_len_ErrorCode                    = 1,
  enErrorCodes_idx_ErrorInfo                     = 11, enErrorCodes_len_ErrorInfo                    = 1
} tenErrorCodes;
/*==========================================================================*/

/*============================================================================
 * Error codes
 *--------------------------------------------------------------------------*/
typedef enum
{
  enErrorCode_No_Error                                          = 0x00, /* internal */
  enErrorCode_FblockID_not_available                            = 0x01,
  enErrorCode_InstanceID_not_available                          = 0x02,
  enErrorCode_FktID_not_available                               = 0x03,
  enErrorCode_OPType_not_available                              = 0x04,
  enErrorCode_Invalid_length                                    = 0x05,
  enErrorCode_Parameter_wrong_or_out_of_range                   = 0x06,
  enErrorCode_Parameter_not_available                           = 0x07,
  enErrorCode_Device_malfunction                                = 0x0B,
  enErrorCode_Function_is_supported_but_currently_occupied      = 0x40,
  enErrorCode_Function_is_supported_but_currently_not_available = 0x41,
  enErrorCode_Method_aborted                                    = 0x43,
  enErrorCode_No_more_registrations_possible                    = 0xF0,
  enErrorCode_Given_FktId_cannot_be_registered                  = 0xF5,
  enErrorCode_OpType_INVALID                                    = 0xEF,  /* internal */
  enErrorCode_Invalid_format                                    = 0xFF   /* internal */
} tun_tenErrorCode;
/*==========================================================================*/

/*============================================================================
 * Function ID of messages
 * https://inside.bosch.com/irj/go/km/docs/room_extensions_rb/cm_stores/documents/workspaces/31cfd519-25b0-2c10-759b-92ca27c37c68/20_public/10_documents/05_AM_FM/SWID_tuner_message_interface.pdf
 *--------------------------------------------------------------------------*/
typedef enum
{
  enMsg_CM_Startup                     = 0xFFF4,
  enMsg_CM_Ping                        = 0x0F0D,
  enMsg_CM_PrepareShutdown             = 0x0F11, // Supports auto notification
  enMsg_CM_Shutdown                    = 0x0F12,
  enMsg_CM_VersionInfo                 = 0x0F13,
  enMsg_CM_AdditionalVersionInfo       = 0x0fd2,
  enMsg_FktIds                         = 0x0000,
  enMsg_Notification                   = 0x0001,
  enMsg_NotificationCheck              = 0x0002,
  enMsg_CM_AudioSource                 = 0x0F01,
  enMsg_CM_ATBand                      = 0x0F00,
  enMsg_ATFrequency                    = 0x0206,
  enMsg_ATSeek                         = 0x0204, // Supports auto notification
  enMsg_CM_ATSeek                      = 0x0F92,
  enMsg_ATPI                           = 0x0205,
  enMsg_CM_Autostore                   = 0x0F90,
  enMsg_CM_TuningActionConfiguration   = 0x0F0B,
  enMsg_CM_ActiveConfiguration         = 0x0F60,
  enMsg_CM_AreaFeatures                = 0x0F61,
  enMsg_CM_AvailableBands              = 0x0F62,
  enMsg_CM_CombibandConfiguration      = 0x0F63,
  enMsg_CM_BandConfiguration           = 0x0F64,
  enMsg_CM_DefaultSetting              = 0x0F65,
  enMsg_CM_AcceptAf                    = 0x0F80,
  enMsg_ATStationInfo                  = 0x0201, // Supports auto notification
  enMsg_CM_ATStationInfo               = 0x0F70, // Supports auto notification
  enMsg_CM_ATStationInfoConfig         = 0x0F71,
  enMsg_CM_ATTunerState                = 0x0F72, // Supports auto notification
  enMsg_TPSwitch                       = 0x0450,
  enMsg_AFBestSwitch                   = 0x0F02,
  enMsg_AFBestSwitchFeatures           = 0x0F1A,
  enMsg_RDSSwitch                      = 0x0451,
  enMsg_CM_MonoStereo                  = 0x0F81,
  enMsg_REG                            = 0x0452,
  enMsg_CM_DDASwitch                   = 0x0F0C,
  enMsg_TAEscape                       = 0x0453,
  enMsg_CM_PersistentStorage           = 0x0F10,
  enMsg_TAMessage                      = 0x0456, // Supports auto notification
  enMsg_CM_DateAndTime                 = 0x0F03, // Supports auto notification
  enMsg_CurrentRadiotext               = 0x0C20, // Supports auto notification
  enMsg_CM_CurrentRadiotext            = 0x0F16, // Supports auto notification
  enMsg_RadiotextMetaData              = 0x0C30, // Supports auto notification
  enMsg_CM_RadiotextMetaData           = 0x0C31, // Supports auto notification
  enMsg_CM_ReceptionParameter          = 0x0F0A,
  enMsg_DRMAudioStreamDecoderStatus    = 0x0F9B,
  enMsg_CM_UpdateLandscape             = 0x0F14,
  enMsg_CM_AtPiSearch				   = 0x0FA0,
  enMsg_CM_SurveilTp                   = 0x0FAA, // Supports auto notification
  enMsg_CM_SurveillanceConfiguration   = 0x0FA2,
  enMsg_TaInfo                         = 0x0455, // Supports auto notification
  enMsg_CM_TaInfo                      = 0x0F15, // Supports auto notification
  enMsg_CM_ATPresetList_00             = 0x0F20,
  enMsg_CM_ATPresetList_01             = 0x0F21,
  enMsg_CM_ATPresetList_02             = 0x0F22,
  enMsg_CM_ATPresetList_03             = 0x0F23,
  enMsg_CM_ATPresetList_04             = 0x0F24,
  enMsg_CM_ATPresetList_05             = 0x0F25,
  enMsg_CM_ATPresetList_06             = 0x0F26,
  enMsg_CM_ATPresetList_07             = 0x0F27,
  enMsg_CM_ATPresetList_08             = 0x0F28,
  enMsg_CM_ATPresetList_09             = 0x0F29,
  enMsg_CM_ATPresetList_10             = 0x0F2A,
  enMsg_CM_ATPresetList_11             = 0x0F2B,
  enMsg_CM_ATPresetList_12             = 0x0F2C,
  enMsg_CM_ATPresetList_13             = 0x0F2D,
  enMsg_CM_ATPresetList_14             = 0x0F2E,
  enMsg_CM_ATPresetList_15             = 0x0F2F,
  enMsg_CM_ATPresetList_16             = 0x0F30,
  enMsg_CM_ATPresetList_17             = 0x0F31,
  enMsg_CM_ATPresetList_18             = 0x0F32,
  enMsg_CM_ATPresetList_19             = 0x0F33,
  enMsg_CM_ATPresetList_20             = 0x0F34,
  enMsg_CM_ATPresetList_21             = 0x0F35,
  enMsg_CM_ATPresetList_22             = 0x0F36,
  enMsg_CM_ATPresetList_23             = 0x0F37,
  enMsg_CM_ATPresetList_24             = 0x0F38,
  enMsg_CM_ATPresetList_25             = 0x0F39,
  enMsg_CM_ATPresetList_26             = 0x0F3A,
  enMsg_CM_ATPresetList_27             = 0x0F3B,
  enMsg_CM_ATPresetList_28             = 0x0F3C,
  enMsg_CM_ATPresetList_29             = 0x0F3D,
  enMsg_CM_ATPresetList_30             = 0x0F3E,
  enMsg_CM_ATPresetList_31             = 0x0F3F,
  enMsg_CM_ATPresetSave                = 0x0F40,
  enMsg_CM_SystemPresets               = 0x0F42,
  enMsg_CM_ATPresetListSetActive       = 0x0F43,
  enMsg_CM_PresetListContentUpdate     = 0x0F46,
  enMsg_CM_ATPresetListConfig          = 0x0F41,
  enMsg_CM_ATPresetListResetAll        = 0x0F44,
  enMsg_CM_StationListConfig           = 0x0F08,
  enMsg_CM_StationListRelease          = 0x0F0E,
  enMsg_CM_ActiveStationList           = 0x0F0F,
  enMsg_CM_StationsList                = 0x0F17,
  enMsg_CM_Container                   = 0xFFF1,
  enMsg_CM_SpecialDiagnosisMode        = 0xFFF5,
  enMsg_CM_SnapshotMode                = 0xFFFB,
  enMsg_CM_EnhancedTestMode            = 0x0FCA, // Supports auto notification
  enMsg_CM_TestMode					   = 0xFFF6, // Supports auto notification
  enMsg_CM_ATAfList                    = 0xFFF7, // Supports auto notification
  enMsg_CM_ATEnhancedAfList            = 0x0FCB, // Supports auto notification
  enMsg_CM_TestTunerSwitches           = 0xFFF8,
  enMsg_CM_SetConfiguration            = 0xFFF9,
  enMsg_CM_SetConfigSections            = 0xef01,
  enMsg_CM_GetConfigurationInfo        = 0xFFFA,
  enMsg_CM_CalibrationData             = 0xFFFC,
  enMsg_CM_TMCSelectionFilter          = 0x0F00,
  enMsg_CM_TMCMonitoredStationsUpdate  = 0x0F01,
  enMsg_CM_TMCTrafficInfos             = 0x0F02,
  enMsg_CM_TMCDataGroup				   = 0x0F03,
  enMsg_CM_TMCStations                 = 0x0F04,
  enMsg_CM_ATLsmSetup				   = 0x0FC0,
  enMsg_CM_Commit                      = 0x0FC2,
  enMsg_CM_StationNameFix              = 0x0F04,
  enMsg_CM_SetEngineeringParameter     = 0x0FCC,
  enMsg_CM_ATTestTuneFrequency		   = 0x0FCD,
  /** Announcement related FIDs */
  enMsg_CM_AnnouncementSwitch		   = 0x0FBA,
  enMsg_CM_AnnouncementMessage		   = 0x0FBB,
  enMsg_CM_AnnouncementInfo			   = 0x0FBC,
  enMsg_CM_AnnouncementEscape		   = 0x0FBD,
  /** -------------------------- */
  enMsg_CM_AtVolumeInfo				   = 0x0FCE,
  enMsg_CM_PiPsRelation				   = 0x0FD0,
  enMsg_CM_ATPreparePresetStorage	   = 0x0F45,
  enMsg_CM_SpeedInformation			   = 0x0FDA,
  enMsg_CM_EvaluationParameter		   = 0x0FCF,
  enMsg_CM_UpdateLandscapeProgress     = 0x0FD1,
  enMsg_CM_CancelAutostore		       = 0x0F91,
  enMsg_CM_SetUser                     = 0x0FEA,
  enMsg_CM_GetUser                     = 0x0FEB,
  enMsg_CM_CopyUserContent             = 0x0FED,
  enMsg_CM_DARC_RegisterOutput         = 0x0FE5,
  enMsg_DRMAudioLogicalFrame           = 0x0F98,
  enMsg_CM_DRMTestMode 				   = 0x0FD5,
  /* debug messages in 1st version of ADR3 from CF42 */
  enMsg_Unknown_Message_0x0002         = 0x0002,
  enMsg_Unknown_Message_0xFFF2         = 0xFFF2,
  enMsg_Unknown_Message_0xFFF3         = 0xFFF3,

  
  enMsg_CM_ATHD_PSDDataFrame           = 0x0F75,
  enMsg_CM_HDTestMode                  = 0x0FDD,
  enMsg_CM_ATHDAudioProgram            = 0x0F93,
  enMsg_CM_ATHDAudioProgramDirect      = 0x0F94,

   enMsg_CM_ChangeLSM         		   = 0x0FC5,
   enMsg_CM_ChangeOfSurveilledStations = 0x07b0,
   enMsg_CM_GetConfigurationData       = 0xef00,
   enMsg_CM_DARC_SetFrequency          = 0x0fe0,
   enMsg_CM_DARC_GetFieldstrength	   = 0x0fe1,
   enMsg_CM_DARC_SetConfigReg          = 0x0fe2,
   enMsg_CM_DARC_GetStatusReg          = 0x0fe3,
   enMsg_CM_DARC_GetBlockReg           = 0x0fe4,
   enMsg_CM_DARC_GetData              = 0x0fe6,
#ifdef VARIANT_S_FTR_ENABLE_SBR_API_A2S1
   enMsg_CM_MTC_ATAudioSource			= 0x0102,
#endif
  enMsg_Unknown_Message_0x0000         = 0x0000  // internal, init value
} tun_tenAmFmTunerMsg;
/*==========================================================================*/


/*============================================================================
 * OPTypes
 *--------------------------------------------------------------------------*/
typedef enum
{
  enOpType_SET         = 0x00,
  enOpType_START       = 0x00,
  enOpType_GET         = 0x01,
  enOpType_SETGET      = 0x02,
  enOpType_STARTRESULT = 0x02,
  enOpType_Increment   = 0x03,
  enOpType_Decrement   = 0x04,
  enOpType_PROCESSING  = 0x0D,
  enOpType_STATUS      = 0x0C,
  enOpType_RESULT      = 0x0C,
  enOpType_STATUSREQ   = 0x10,
  enOpType_ERROR       = 0x0F,
  enOpType_INVALID     = 0xFF
} tun_tenOpType;
/*==========================================================================*/


/*============================================================================
 * Notification
 *--------------------------------------------------------------------------*/
typedef enum
{
  enNotificationControl_SetAll         = 0,
  enNotificationControl_SetFunction    = 1,
  enNotificationControl_ClearAll       = 2,
  enNotificationControl_ClearFunction  = 3
} tenNotificationControl;
/*==========================================================================*/


/*============================================================================
 * CM_AudioSource
 *--------------------------------------------------------------------------*/
typedef enum
{
  enAudioSource_No_audio       = 0,
  enAudioSource_User_audio     = 1,
  enAudioSource_TA_audio       = 2,
  enAudioSource_PTY_audio	   = 3,
  enAudioSource_WeatherAlert  = 4
} tenAudioSource;
/*==========================================================================*/


/*============================================================================
 * CM_ATBand
 *--------------------------------------------------------------------------*/
typedef enum
{
  enBand_FM         =  0,
  enBand_LW         =  1,
  enBand_MW         =  2,
  enBand_KW_SUB_1   =  3,
  enBand_KW_SUB_2   =  4,
  enBand_KW_SUB_3   =  5,
  enBand_KW_SUB_4   =  6,
  enBand_KW_SUB_5   =  7,
  enBand_KW_SUB_6   =  8,
  enBand_KW_SUB_7   =  9,
  enBand_KW_SUB_8   = 10,
  enBand_KW_SUB_9   = 11,
  enBand_KW_SUB_10  = 12,
  enBand_KW_SUB_11  = 13,
  enBand_KW_SUB_12  = 14,
  enBand_KW_SUB_13  = 15,
  enBand_KW_SUB_14  = 16,
  enBand_TRF        = 17,
  enBand_WB         = 18,
  enBand_tbd       = 19,
  enBand_CB1       = 20,
  enBand_GetCurrent = 0xff
} tenBand;
/*==========================================================================*/


/*============================================================================
 * ATSeek
 *--------------------------------------------------------------------------*/
typedef enum
{
  enATSeekMode_Off                                    =  0,
  enATSeekMode_Up_auto                                =  1,
  enATSeekMode_Up_scan_current_preset_list            =  2,
  enATSeekMode_Up_scan_frequency                      =  3,
  enATSeekMode_Up_continuous_manual_step_unmuted      =  4,
  enATSeekMode_Up_preset                              =  5,
  enATSeekMode_Up_current_station_list                =  6,
  enATSeekMode_Down_auto                              =  7,
  enATSeekMode_Down_scan_current_preset_list          =  8,
  enATSeekMode_Down_scan_frequency                    =  9,
  enATSeekMode_Down_continuous_manual_step_unmuted    = 10,
  enATSeekMode_Down_preset                            = 11,
  enATSeekMode_Down_current_station_list              = 12,
  enATSeekMode_Up_auto_RDS_only                       = 13,
  enATSeekMode_Down_auto_RDS_only                     = 14,
  enATSeekMode_Up_auto_RDS_only_PTY_mask              = 15,
  enATSeekMode_Down_auto_RDS_only_PTY_mask            = 16,
  enATSeekMode_TP_up                                  = 17,
  enATSeekMode_TP_down                                = 18,
  enATSeekMode_SELF_TP_up                             = 19,
  enATSeekMode_SELF_TP_down                           = 20,
  enATSeekMode_TP_up_with_PTY_mask                    = 21,
  enATSeekMode_TP_down_with_PTY_mask                  = 22,
  enATSeekMode_SELF_TP_up_with_PTY_mask               = 23,
  enATSeekMode_SELF_TP_down_with_PTY_mask             = 24,
  enATSeekMode_Up_continuous_manual_step_muted        = 25,
  enATSeekMode_Down_continuous_manual_step_muted      = 26,
  enATSeekMode_Up_scan_PI                             = 27,
  enATSeekMode_Down_scan_PI                           = 28,
  enATSeekMode_Up_scan_Sorted_PS                      = 29,
  enATSeekMode_Down_scan_Sorted_PS                    = 30

} tenATSeekMode;

typedef enum
{
   enTUN_TUN_CONFIG_LIST_FM = 0,
   enTUN_TUN_CONFIG_LIST_TMC = 1,
   enTUN_TUN_CONFIG_LIST_MW = 2,
   enTUN_TUN_CONFIG_LIST_LW = 3,
   enTUN_TUN_CONFIG_LIST_AM = 4,
   enTUN_TUN_CONFIG_LIST_DRM = 5,
   enINVALID_TYPE = 255
}tenConfigListID;

/*==========================================================================*/


/*============================================================================
 * CM_ATSeek
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: SET
   *-------------------------------------------------------------------------*/
  enCM_ATSeek_idx_TSeekMode                      = 10, enCM_ATSeek_len_TSeekMode                     = 1,
  enCM_ATSeek_idx_Frequency                      = 11, enCM_ATSeek_len_Frequency                     = 4

} tenCM_ATSeek;
/*==========================================================================*/


/*============================================================================
 * CM_ATTunerState
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: SET
   *-------------------------------------------------------------------------*/
  enCM_ATTunerState_idx_TuningState                      = 11, enCM_ATSeek_len_TuningState                     = 1,
  enCM_ATTunerState_idx_FID                              = 12, enCM_ATSeek_len_FID                     = 2

} tenCM_ATTunerState;
/*==========================================================================*/


/*============================================================================
 * ATStationInfo
 *--------------------------------------------------------------------------*/
typedef enum
{
  enATStationInfo_Data_AllData               = 0,
  enATStationInfo_Data_Stationname           = 1,
  enATStationInfo_Data_StationnameInfo       = 2,
  enATStationInfo_Data_Frequency             = 3,
  enATStationInfo_Data_PTY                   = 4,
  enATStationInfo_Data_PI                    = 5,
  enATStationInfo_Data_ATStationInfoSwitches = 6,
  enATStationInfo_Data_ReceptionQuality      = 7

} tenATStationInfo_Data;
/*--------------------------------------------------------------------------*/
typedef enum
{
  enStationnameInfo_NON_RDS_Station                    = 0,
  enStationnameInfo_Station_name_is_first_received_PS  = 1,
  enStationnameInfo_Station_name_is_last_received_PS   = 2,
  enStationnameInfo_not_supported_3                    = 3,
  enStationnameInfo_Name_assigned_by_customer          = 4,
  enStationnameInfo_not_supported_5                    = 5

} tenStationnameInfo;
/*==========================================================================*/


/*============================================================================
 * CM_ATHD_PSDDataFrame
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_ATHD_PSDDataFrame_idx_ProgramBitMask			= 10, enCM_ATHD_PSDDataFrame_len_ProgramBitMask		= 1,
  enCM_ATHD_PSDDataFrame_idx_FieldBitMask			= 11, enCM_ATHD_PSDDataFrame_len_FieldBitMask		= 2,
  enCM_ATHD_PSDDataFrame_idx_CommentsBitMask		= 13, enCM_ATHD_PSDDataFrame_len_CommentsBitMask	= 1,
  enCM_ATHD_PSDDataFrame_idx_UFIDBitMask			= 14, enCM_ATHD_PSDDataFrame_len_UFIDBitMask		= 1,
  enCM_ATHD_PSDDataFrame_idx_CommersialBitMask		= 15, enCM_ATHD_PSDDataFrame_len_CommersialBitMask	= 1,

  enCM_ATHD_PSDDataFrame_idx_HDStationId			= 10, enCM_ATHD_PSDDataFrame_len_HDStationId		= 4,
  enCM_ATHD_PSDDataFrame_idx_ReservedByte0_7		= 14, enCM_ATHD_PSDDataFrame_len_ReservedByte0_7	= 8,
  enCM_ATHD_PSDDataFrame_idx_NoOfPSDDataBytes		= 22, enCM_ATHD_PSDDataFrame_len_NoOfPSDDataBytes	= 2,

  enCM_ATHD_PSDDataFrame_idx_PSDFrame_ReservedByte		= 24, enCM_ATHD_PSDDataFrame_len_PSDFrame_ReservedByte	= 1,

  enCM_ATHD_PSDDataFrame_idx_PSDDataRepetitionByte		= 25, 
  /** data which repeats */

  enCM_ATHD_PSDDataFrame_idx_PSDFrame_ProgramNo			= 0, enCM_ATHD_PSDDataFrame_len_PSDFrame_ProgramNo			= 1,
  enCM_ATHD_PSDDataFrame_idx_PSDFrame_FieldBitMask		= 1, enCM_ATHD_PSDDataFrame_len_PSDFrame_FieldBitMask		= 2,
  enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubField			= 3, enCM_ATHD_PSDDataFrame_len_PSDFrame_SubField			= 1,
  enCM_ATHD_PSDDataFrame_idx_PSDFrame_Reserved			= 4, enCM_ATHD_PSDDataFrame_len_PSDFrame_Reserved			= 1,
  enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldDatatype	= 5, enCM_ATHD_PSDDataFrame_len_PSDFrame_SubFieldDatatype	= 1,
  enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldLen		= 6, enCM_ATHD_PSDDataFrame_len_PSDFrame_SubFieldLen		= 1,
  enCM_ATHD_PSDDataFrame_idx_PSDFrame_SubFieldData		= 7, enCM_ATHD_PSDDataFrame_len_PSDFrame_OffsetForEachFrame	= 7	
  

} tenCM_ATHD_PSDDataFrame;

#define CM_ATHD_PSDDataFrame_PROG_BITMASK			0xff

typedef enum
{
  enFieldBitMask_Reserved	= 0x0000,
  enFieldBitMask_Title		= 0x0100,
  enFieldBitMask_Artist		= 0x0200,
  enFieldBitMask_Album		= 0x0400,
  enFieldBitMask_Genre		= 0x0800,
  enFieldBitMask_Comment	= 0x1000,
  enFieldBitMask_UFID		= 0x2000,
  enFieldBitMask_Commercial = 0x4000,
  enFieldBitMask_XHDR		= 0x8000

} tenFieldBitMask;


typedef enum
{
  enCommercialSubFieldBitMask_PriceString	= 0x01,
  enCommercialSubFieldBitMask_ValidUntil	= 0x02,
  enCommercialSubFieldBitMask_ContactURL	= 0x04,
  enCommercialSubFieldBitMask_ReceivedAs	= 0x08,
  enCommercialSubFieldBitMask_NameOfSeller	= 0x10,
  enCommercialSubFieldBitMask_Description	= 0x20

} tenCommercialSubFieldBitMask;


typedef enum
{
  enCommentSubFieldBitMask_Language					= 0x01,
  enCommentSubFieldBitMask_ShortContentDescription	= 0x02,
  enCommentSubFieldBitMask_ActualText				= 0x04

} tenCommentSubFieldBitMask;

typedef enum
{
  enSubFieldDataType_ISO_IEC8859_1_1998		= 0x00,
  enSubFieldDataType_ISO_IEC10646_1_2000	= 0x01,
  enSubFieldDataType_Binary					= 0xFF

} tenSubFieldDataType;


typedef enum
{
  enUFIDSubFieldBitMask_OwnerIdentifier	= 0x01,
  enUFIDSubFieldBitMask_Identifier		= 0x02
} tenUFIDSubFieldBitMask;


typedef enum
{


  enXHDR_idx_MIMEhash	= 0,  enXHDR_len_MIMEhash		= 4,

  enXHDR_loop_starting_idx	= 4,


  enXHDR_loop_idx_ParamID	= 0,  enXHDR_len_ParamID		= 1,
  enXHDR_loop_idx_Length	= 1,  enXHDR_len_Length			= 1,
  enXHDR_loop_idx_Value		= 2,  enXHDR_len_Value			= 2

} tenXHDR;


typedef enum
{
  enXHDRParamId_DisplayTrigger	= 0,
  enXHDRParamId_BlankDisplay	= 1,
  enXHDRParamId_FlushMemory		= 2  

} tenXHDRParamId;



/*============================================================================
 * CM_HDTestMode
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_HDTestMode_idx_HDCallSign				= 10, enCM_HDTestMode_len_HDCallSign			= 8,
  enCM_HDTestMode_idx_HDStationID				= 18, enCM_HDTestMode_len_HDStationID			= 4,
  enCM_HDTestMode_idx_AvailableAudioProgram		= 22, enCM_HDTestMode_len_AvailableAudioProgram	= 1,
  enCM_HDTestMode_idx_ActiveAudioProgram		= 23, enCM_HDTestMode_len_ActiveAudioProgram	= 1,
  enCM_HDTestMode_idx_AudioQuality				= 24, enCM_HDTestMode_len_AudioQuality			= 1,
  enCM_HDTestMode_idx_ACQStates					= 25, enCM_HDTestMode_len_ACQStates				= 1,
  enCM_HDTestMode_idx_CD_NO						= 26, enCM_HDTestMode_len_CD_NO					= 1,
  enCM_HDTestMode_idx_RFU_Bytes					= 27, enCM_HDTestMode_len_RFU_Bytes				= 47

  

} tenCM_HDTestMode;


/*============================================================================
 * CM_ATStationInfo
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_ATStationInfo_idx_Stationname             = 10, enCM_ATStationInfo_len_Stationname            = 8,
  enCM_ATStationInfo_idx_StationnameInfo         = 18, enCM_ATStationInfo_len_StationnameInfo        = 1,
  enCM_ATStationInfo_idx_Frequency               = 19, enCM_ATStationInfo_len_Frequency              = 4,
  enCM_ATStationInfo_idx_PTY                     = 23, enCM_ATStationInfo_len_PTY                    = 1,
  enCM_ATStationInfo_idx_PI                      = 24, enCM_ATStationInfo_len_PI                     = 2,
  enCM_ATStationInfo_idx_ATStationTpInfo         = 26, enCM_ATStationInfo_len_ATStationTpInfo        = 1,
  enCM_ATStationInfo_idx_ATStationTmcInfo        = 27, enCM_ATStationInfo_len_ATStationTmcInfo       = 1,
  enCM_ATStationInfo_idx_Fieldstrength           = 28, enCM_ATStationInfo_len_Fieldstrength          = 1,
  enCM_ATStationInfo_idx_Quality                 = 29, enCM_ATStationInfo_len_Quality                = 1,
  enCM_ATStationInfo_idx_Band                    = 30, enCM_ATStationInfo_len_Band                   = 1,
  enCM_ATStationInfo_idx_ActivePresetList        = 31, enCM_ATStationInfo_len_ActivePresetList       = 2,
  enCM_ATStationInfo_idx_ActiveStationList       = 33, enCM_ATStationInfo_len_ActiveStationList      = 1,
  enCM_ATStationInfo_idx_PresetAutocompare       = 34, enCM_ATStationInfo_len_PresetAutocompare      = 2,
  enCM_ATStationInfo_idx_StationListAutocompare  = 36, enCM_ATStationInfo_len_StationListAutocompare = 2,
  enCM_ATStationInfo_idx_ATStationInfo           = 38, enCM_ATStationInfo_len_ATStationInfo          = 1
  #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  ,
  enCM_ATStationInfo_idx_HDStationInfoBits       = 39, enCM_ATStationInfo_len_HDStationInfo          = 1,
  enCM_ATStationInfo_idx_HDStationId             = 40, enCM_ATStationInfo_len_HDStationId            = 4,
  enCM_ATStationInfo_idx_HDCallSign              = 44, enCM_ATStationInfo_len_HDCallSign             = 16,
  enCM_ATStationInfo_idx_HDCallsignTextEncoding  = 60, enCM_ATStationInfo_len_HDCallsignTextEncoding = 1,
  enCM_ATStationInfo_idx_HDStationGenre          = 61, enCM_ATStationInfo_len_HDStationGenre         = 1,
  enCM_ATStationInfo_idx_HDNumberOfAudioPrograms = 62, enCM_ATStationInfo_len_HDNumberOfAudioPrograms= 1,
  enCM_ATStationInfo_idx_HDQuality               = 63, enCM_ATStationInfo_len_HDQuality              = 1,
  enCM_ATStationInfo_idx_HDActiveAudioProgram    = 64, enCM_ATStationInfo_len_HDActiveAudioProgram   = 1,

  enCM_ATStationInfo_idx_DRMStationInfoBits		 = 65, enCM_ATStationInfo_len_DRMStationInfoBits	 = 1,
  enCM_ATStationInfo_idx_DRMServiceId			 = 66, enCM_ATStationInfo_len_DRMServiceId			 = 4,
  enCM_ATStationInfo_idx_DRMServiceLabel		 = 70, enCM_ATStationInfo_len_DRMServiceLabel		 = 64,
  enCM_ATStationInfo_idx_DRMPTY					 = 134, enCM_ATStationInfo_len_DRMPTY				 = 1,
  enCM_ATStationInfo_idx_DRMAnnoSupport			 = 135, enCM_ATStationInfo_len_DRMAnnoSupport		 = 2,
  enCM_ATStationInfo_idx_DRMNumberOfAudioServices	= 137, enCM_ATStationInfo_len_DRMNumberOfAudioServices  = 1,
  enCM_ATStationInfo_idx_DRMQuality				 = 138, enCM_ATStationInfo_len_DRMQuality			 = 1,
  enCM_ATStationInfo_idx_DRMServiceShortId		 = 139, enCM_ATStationInfo_len_DRMServiceShortId		 = 1,
  enCM_ATStationInfo_idx_Drmlanguage   = 140,  enCM_ATStationInfo_len_Drmlanguage = 1,
  enCM_ATStationInfo_idx_DrmlanguageCode  = 141,  enCM_ATStationInfo_len_DrmlanguageCode = 3,
  enCM_ATStationInfo_idx_DrmCountryCode = 144, enCM_ATStationInfo_len_DrmCountryCode = 2,
  enCM_ATStationInfo_idx_DrmFrequencyCorrection = 146, enCM_ATStationInfo_len_DrmFrequencyCorrection = 1,
  enCM_ATStationInfo_idx_rfu_bytes				 = 147, enCM_ATStationInfo_len_rfu_bytes			 = 5

#endif
} tenCM_ATStationInfo;

/*============================================================================
 * CM_SetEngineeringParameter
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_SetEnggParam_idx_ParameterId             = 10, enCM_SetEnggParam_len_ParameterId            = 1,
  enCM_SetEnggParam_idx_ParameterValue          = 11, enCM_SetEnggParam_len_ParameterValue         = 4
} tenCM_SetEnggParam;

/*============================================================================
 * CM_AnnouncementInfo
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_AnnouncementInfo_Frequency             = 10, enCM_AnnouncementInfo_len_Frequency             = 4,
  enCM_AnnouncementInfo_PI					  = 14, enCM_AnnouncementInfo_len_PI					= 2,
  enCM_AnnouncementInfo_StationName           = 16, enCM_AnnouncementInfo_len_StationName           = 8,
  enCM_AnnouncementInfo_AnnoType			  = 24, enCM_AnnouncementInfo_len_AnnoType				= 1

} tenCM_AnnouncementInfo;
typedef enum
{
   enCM_AnnouncementInfo_AnnoType_TP,
   enCM_AnnouncementInfo_AnnoType_PTY31,
   enCM_AnnouncementInfo_AnnoType_WeatherAlert
}tenCM_AnnouncementInfoAnnoType;


/*============================================================================
 * CM_TuningActionConfiguration
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_TuningActionConfiguration_idx_PosX					= 10, enCM_TuningActionConfiguration_len_PosX            = 1,
  enCM_TuningActionConfiguration_idx_PosY					= 11, enCM_TuningActionConfiguration_len_PosY            = 1,
  enCM_TuningActionConfiguration_idx_Data					= 12, 
																  enCM_TuningActionConfiguration_len_data      = 1,
																  enCM_TuningActionConfiguration_len_PTYFilterData      = 4,
																  enCM_TuningActionConfiguration_len_AutoSeekStepDelayData      = 2,
																  enCM_TuningActionConfiguration_len_ManualStepDelayData      = 2
} tenCM_TuningActionConfiguration;

typedef enum 
{
      TAC_AllParameters= 0,
      TAC_NumberOfSeekPeriods = 1,
      TAC_ScanTime= 2,
      TAC_AFBestDelayTime = 3,
      TAC_TPSeekStrategy = 4,
      TAC_PTYFilter = 5,
      TAC_TuningSwitches = 6,
      TAC_AutoSeekStepDelay= 7,
      TAC_ManualStepDelay= 8,
      TAC_WrongPIAcceptDelay= 9,
      TAC_NonRDSDetectionTimer= 10,
      TAC_TPSeekAfterRDSLostTimer = 11,
      TAC_AMStationInListRemoveTimer = 12,
      TAC_ScrollingPSDetectionTimer = 13,
      TAC_INVALID_TYPE = 255
} tenTuningActionConfigParam;

/*============================================================================
 * CM_ATTestTuneFrequency
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_ATTestTuneFrequency_idx_PhysicalTunerID					= 10, enCM_ATTestTuneFrequency_len_PhysicalTunerID            = 1,
  enCM_ATTestTuneFrequency_idx_Mode						= 11, enCM_ATTestTuneFrequency_len_Mode						= 1,
  enCM_ATTestTuneFrequency_idx_Frequency					= 12, enCM_ATTestTuneFrequency_len_Frequency			        = 4
} tenCM_ATTestTuneFrequency;

/*============================================================================
 * CM_PiPsRelation
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_PiPsRelation_idx_PI					= 10, enCM_PiPsRelation_len_PI            = 2,
  enCM_PiPsRelation_idx_PSName				= 12, enCM_PiPsRelation_len_PSName		  = 8
} tenCM_PiPsRelation;


/*============================================================================
 * CM_EvaluationParameter
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_EvaluationParameter_Section					= 10, enCM_EvaluationParameter_len_Section        = 1,
  enCM_EvaluationParameter_idx_ParameterId			= 11, enCM_EvaluationParameter_len_ParameterId	  = 2,
  enCM_EvaluationParameter_idx_ParameterValue		= 13, enCM_EvaluationParameter_len_ParameterValue = 1
} tenCM_EvaluationParameter;


/*============================================================================
 * CM_UpdateLandscapeProgress
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_UpdateLandscapeProgress_idx_ScannedFreqRatio		= 10, enCM_UpdateLandscapeProgress_len_ScannedFreqRatio = 1
} tenCM_UpdateLandscapeProgress;


typedef enum
{
  enEvalSection					= 0
  } tenEvalSection;



/*--------------------------------------------------------------------------
*CM_TAInfo
*--------------------------------------------------------------------------*/

typedef enum
{
	enCM_TAInfo_idx_Frequency		= 10, enCM_TAInfo_len_Frequency 	= 4,
	enCM_TAInfo_idx_PI				= 14, enCM_TAInfo_len_PI			= 2,
	enCM_TAInfo_idx_TaStationName	= 16, enCM_TAInfo_len_TAStationName = 8
}tenCM_TAInfo;
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------
*CM_AtPiSearch
*--------------------------------------------------------------------------*/

typedef enum
{
	enCM_AtPiSearch_idx_PISearchStatus		= 10, enCM_AtPiSearch_len_PISearchStatus 	= 1,
	enCM_AtPiSearch_idx_PI					= 11, enCM_AtPiSearch_len_PI			= 2
}tenCM_AtPiSearch;
/*--------------------------------------------------------------------------*/

typedef enum
{
	enPISearchStatus_SearchStarted		= 0, 
	enPISearchStatus_PIFound			= 1,
	enPISearchStatus_PINotFound			= 2
}tenPiSearchStatus;
/*--------------------------------------------------------------------------*/

typedef enum
{
  enCM_ATStationnameInfo_NON_RDS_Station                    = 0,
  enCM_ATStationnameInfo_Station_name_is_first_received_PS  = 1,
  enCM_ATStationnameInfo_Station_name_is_last_received_PS   = 2,
  enCM_ATStationnameInfo_Name_assigned_by_customer          = 3
} tenCM_ATStationnameInfo;
/*--------------------------------------------------------------------------*/
typedef enum
{
  enATStationTpInfo_TP_status_of_station_is_unknown  = 0,
  enATStationTpInfo_Station_is_NO_TP_station         = 1,
  enATStationTpInfo_Station_is_SELF_TP_station       = 2,
  enATStationTpInfo_Station_is_EON_TP_station        = 3
} tenATStationTpInfo;
/*--------------------------------------------------------------------------*/
typedef enum
{
  enATStationTmcInfo_TMC_status_of_station_is_unknown  = 0,
  enATStationTmcInfo_Station_is_NO_TMC_station         = 1,
  enATStationTmcInfo_Station_is_TMC_station            = 2
} tenATStationTmcInfo;
/*==========================================================================*/


/*============================================================================
 * CM_TestMode
 *--------------------------------------------------------------------------*/
typedef enum
{
  enTestmodeActivity_Testmode_auto_notifications_off  = 0,
  enTestmodeActivity_Testmode_auto_notifications_on   = 1
} tenTestmodeActivity;
/*--------------------------------------------------------------------------*/
typedef enum
{
  enModulation_FM              = 0,
  enModulation_FM_NON_RDS      = 1,
  enModulation_AM              = 2,
  enModulation_DRM             = 3,
  enModulation_HD              = 4,
  enModulation_DAB             = 5
} tenModulation;
/*--------------------------------------------------------------------------*/
/* Mask for u8InfoBits                                                      */
#define TUN_INFO_BIT_MSK_TP             0x01
#define TUN_INFO_BIT_MSK_TA             0x02
#define TUN_INFO_BIT_MSK_TMC            0x04
#define TUN_INFO_BIT_MSK_DDA            0x08
#define TUN_INFO_BIT_MSK_AUDIO_TUNER    0x10
/*==========================================================================*/

/*============================================================================
 * CM_SetConfiguration
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: STARTRESULT
   *-------------------------------------------------------------------------*/
  enCM_SetConfiguration_idx_VersionId                    =   10, enCM_SetConfiguration_len_VersionId                        =   16,
  enCM_SetConfiguration_idx_NumberOfBytes                =   26, enCM_SetConfiguration_len_NumberOfBytes                    =   2,

  /***********************************************************************************************************/
  /*********************************Tunning Behaviour Configuration Start	***************************/

  enCM_SetConfiguration_idx_NumOfSeekPeriods             =   0 + 28, enCM_SetConfiguration_len_NumOfSeekPeriods             =   1,
  enCM_SetConfiguration_idx_ScanTime                     =   1 + 28, enCM_SetConfiguration_len_ScanTime                     =   1,
  /**based on New Configuration*/
  enCM_SetConfiguration_idx_reserved0			         =   2 + 28, enCM_SetConfiguration_len_reserved0					     =   1,
  enCM_SetConfiguration_idx_TpSeekStrategy               =   3 + 28, enCM_SetConfiguration_len_TpSeekStrategy               =   1,
  enCM_SetConfiguration_idx_PtyFilterForSeek             =   4 + 28, enCM_SetConfiguration_len_PtyFilterForSeek             =   4,
  enCM_SetConfiguration_idx_AutoSeekStepDelay            =   8 + 28, enCM_SetConfiguration_len_AutoSeekStepDelay            =   2,
  enCM_SetConfiguration_idx_PemanentManualStepDelay      =  10 + 28, enCM_SetConfiguration_len_PemanentManualStepDelay      =   2,
  enCM_SetConfiguration_idx_reserved1			         =  12 + 28, enCM_SetConfiguration_len_reserved1					    =   1,
  enCM_SetConfiguration_idx_TuningBehaviourSwitches		 =  13 + 28, enCM_SetConfiguration_len_PISearchSwitch					=   1,

  enCM_SetConfiguration_idx_MUTE_RAMP_1                  =  14 + 28, enCM_SetConfiguration_len_MUTE_RAMP_1                  =   2,
  enCM_SetConfiguration_idx_DEMUTE_RAMP_1                =  16 + 28, enCM_SetConfiguration_len_DEMUTE_RAMP_1                =   2,
  enCM_SetConfiguration_idx_MUTE_RAMP_2                  =  18 + 28, enCM_SetConfiguration_len_MUTE_RAMP_2                  =   2,
  enCM_SetConfiguration_idx_DEMUTE_RAMP_2                =  20 + 28, enCM_SetConfiguration_len_DEMUTE_RAMP_2                =   2,
  enCM_SetConfiguration_idx_reserved2                    =  22 + 28, enCM_SetConfiguration_len_reserved2                   =   28,

  /*********************************Tunning Behaviour Configuration END		***************************/

   /*********************************ATStation info Configuration Start		***************************/
  enCM_SetConfiguration_idx_reserved3                    =  50 + 28, enCM_SetConfiguration_len_reserved3                   =   1,
  enCM_SetConfiguration_idx_ATStationInfoBits			 =  51 + 28, enCM_SetConfiguration_len_ATStationInfoBits           =   1,
  enCM_SetConfiguration_idx_reserved4                    =  52 + 28, enCM_SetConfiguration_len_reserved4                   =   8,
  /*********************************ATStation info Configuration END		***************************/

  /*********************************Timer Configuration Start		***************************/
  enCM_SetConfiguration_idx_t_SCAN_radio								= 60 + 28, enCM_SetConfiguration_len_t_SCAN_radio								 = 1,
  enCM_SetConfiguration_idx_t_inhibit_list_sort_after_skip				= 61 + 28, enCM_SetConfiguration_len_t_inhibit_list_sort_after_skip				 = 1,		
  enCM_SetConfiguration_idx_t_delay_TP_station_select_after_Vol_zero    = 62 + 28, enCM_SetConfiguration_len_t_delay_TP_station_select_after_Vol_zero    = 1,
  enCM_SetConfiguration_idx_t_delay_no_TP_station_found					= 63 + 28, enCM_SetConfiguration_len_t_delay_no_TP_station_found				 = 1,
  enCM_SetConfiguration_idx_t_non_RDS_detect							= 64 + 28, enCM_SetConfiguration_len_t_non_RDS_detect							 = 1,
  enCM_SetConfiguration_idx_t_PS_delete_after_RDS_lost					= 65 + 28, enCM_SetConfiguration_len_t_PS_delete_after_RDS_lost					 = 1,
  enCM_SetConfiguration_idx_t_wrongPI_accept							= 66 + 28, enCM_SetConfiguration_len_t_wrongPI_accept							 = 1,
  enCM_SetConfiguration_idx_t_scroll_PS_detect							= 67 + 28, enCM_SetConfiguration_len_t_scroll_PS_detect							 = 1,
  enCM_SetConfiguration_idx_t_delay_TP_station_select_after_RDS_lost	= 68 + 28, enCM_SetConfiguration_len_t_delay_TP_station_select_after_RDS_lost	 = 1,
  enCM_SetConfiguration_idx_t_TA_end_after_RDS_lost						= 69 + 28, enCM_SetConfiguration_len_t_TA_end_after_RDS_lost					 = 1,
  enCM_SetConfiguration_idx_t_AM_min_tun_time							= 70 + 28, enCM_SetConfiguration_len_t_AM_min_tun_time							 = 1,
  enCM_SetConfiguration_idx_t_cursor_delay_after_station_select			= 71 + 28, enCM_SetConfiguration_len_t_cursor_delay_after_station_select		 = 1,
  enCM_SetConfiguration_idx_t_AF_inhibit_after_man_tune					= 72 + 28, enCM_SetConfiguration_len_t_AF_inhibit_after_man_tune				 = 1,
  enCM_SetConfiguration_idx_t_accept_PI_after_recall					= 73 + 28, enCM_SetConfiguration_len_t_accept_PI_after_recall					 = 1,
  enCM_SetConfiguration_idx_t_PTY_hold									= 74 + 28, enCM_SetConfiguration_len_t_PTY_hold									 = 1,
  enCM_SetConfiguration_idx_reserved5									= 75 + 28, enCM_SetConfiguration_len_reserved5									 = 25,
  /*********************************Timer Configuration END		***************************/

    /*********************************Reception behaviour configuration Start		***************************/
  enCM_SetConfiguration_idx_FieldstrengthSeekLevel_FM_RDS             =  100 + 28, enCM_SetConfiguration_len_FieldstrengthSeekLevel_FM_RDS				=   1,
  enCM_SetConfiguration_idx_QualitySeekLevel_FM_RDS					  =  101 + 28, enCM_SetConfiguration_len_QualitySeekLevel_FM_RDS					=   1,
  enCM_SetConfiguration_idx_FieldstrengthSeekLevel_FM_NONRDS          =  102 + 28, enCM_SetConfiguration_len_FieldstrengthSeekLevel_FM_NONRDS			=   1,
  enCM_SetConfiguration_idx_QualitySeekLevel_FM_NONRDS				  =  103 + 28, enCM_SetConfiguration_len_QualitySeekLevel_FM_NONRDS					=   1,
  enCM_SetConfiguration_idx_FieldstrengthSeekLevel_LW                 =  104 + 28, enCM_SetConfiguration_len_FieldstrengthSeekLevel_LW					=   1,
  enCM_SetConfiguration_idx_QualitySeekLevel_LW						  =  105 + 28, enCM_SetConfiguration_len_QualitySeekLevel_LW						=   1,
  enCM_SetConfiguration_idx_FieldstrengthSeekLevel_MW                 =  106 + 28, enCM_SetConfiguration_len_FieldstrengthSeekLevel_MW				    =   1,
  enCM_SetConfiguration_idx_QualitySeekLevel_MW						  =  107 + 28, enCM_SetConfiguration_len_QualitySeekLevel_MW						=   1,
  enCM_SetConfiguration_idx_FieldstrengthSeekLevel_SW                 =  108 + 28, enCM_SetConfiguration_len_FieldstrengthSeekLevel_SW					=   1,
  enCM_SetConfiguration_idx_QualitySeekLevel_SW						  =  109 + 28, enCM_SetConfiguration_len_QualitySeekLevel_SW						=   1,
  enCM_SetConfiguration_idx_FieldstrengthSeekLevel_TRF                =  110 + 28, enCM_SetConfiguration_len_FieldstrengthSeekLevel_TRF					=   1,
  enCM_SetConfiguration_idx_QualitySeekLevel_TRF					  =  111 + 28, enCM_SetConfiguration_len_QualitySeekLevel_TRF						=   1,
  enCM_SetConfiguration_idx_FieldstrengthSeekLevel_WB                 =  112 + 28, enCM_SetConfiguration_len_FieldstrengthSeekLevel_WB					=   1,
  enCM_SetConfiguration_idx_QualitySeekLevel_WB						  =  113 + 28, enCM_SetConfiguration_len_QualitySeekLevel_WB						=   1,
  
  enCM_SetConfiguration_idx_FieldstrengthListLevel_FM_RDS             =  114 + 28, enCM_SetConfiguration_len_FieldstrengthListLevel_FM_RDS				=   1,
  enCM_SetConfiguration_idx_QualityListLevel_FM_RDS					  =  115 + 28, enCM_SetConfiguration_len_QualityListLevel_FM_RDS					=   1,
  enCM_SetConfiguration_idx_FieldstrengthListLevel_FM_NONRDS          =  116 + 28, enCM_SetConfiguration_len_FieldstrengthListLevel_FM_NONRDS			=   1,
  enCM_SetConfiguration_idx_QualityListLevel_FM_NONRDS				  =  117 + 28, enCM_SetConfiguration_len_QualityListLevel_FM_NONRDS					=   1,
  enCM_SetConfiguration_idx_FieldstrengthListLevel_LW                 =  118 + 28, enCM_SetConfiguration_len_FieldstrengthListLevel_LW					=   1,
  enCM_SetConfiguration_idx_QualityListLevel_LW                       =  119 + 28, enCM_SetConfiguration_len_QualityListLevel_LW						=   1,
  enCM_SetConfiguration_idx_FieldstrengthListLevel_MW                 =  120 + 28, enCM_SetConfiguration_len_FieldstrengthListLevel_MW					=   1,
  enCM_SetConfiguration_idx_QualityListLevel_MW						  =  121 + 28, enCM_SetConfiguration_len_QualityListLevel_MW						=   1,
  enCM_SetConfiguration_idx_FieldstrengthListLevel_SW                 =  122 + 28, enCM_SetConfiguration_len_FieldstrengthListLevel_SW					=   1,
  enCM_SetConfiguration_idx_QualityListLevel_SW						  =  123 + 28, enCM_SetConfiguration_len_QualityListLevel_SW						=   1,
  enCM_SetConfiguration_idx_FieldstrengthListLevel_TRF                =  124 + 28, enCM_SetConfiguration_len_FieldstrengthListLevel_TRF					=   1,
  enCM_SetConfiguration_idx_QualityListLevel_TRF					  =  125 + 28, enCM_SetConfiguration_len_QualityListLevel_TRF						=   1,
  enCM_SetConfiguration_idx_FieldstrengthListLevel_WB                 =  126 + 28, enCM_SetConfiguration_len_FieldstrengthListLevel_WB					=   1,
  enCM_SetConfiguration_idx_QualityListLevel_WB                       =  127 + 28, enCM_SetConfiguration_len_QualityListLevel_WB						=   1,
  enCM_SetConfiguration_idx_FM_SHARX								  =  128 + 28, enCM_SetConfiguration_len_FM_SHARX									=   1,
  enCM_SetConfiguration_idx_AM_SHARX								  =  129 + 28, enCM_SetConfiguration_len_AM_SHARX									=   1,
  enCM_SetConfiguration_idx_FM_HICUT								  =  130 + 28, enCM_SetConfiguration_len_FM_HICUT									=   1,
  enCM_SetConfiguration_idx_AM_HICUT								  =  131 + 28, enCM_SetConfiguration_len_AM_HICUT									=   1,
  enCM_SetConfiguration_idx_reserved6								  =  132 + 28, enCM_SetConfiguration_len_reserved6									=   18,

  /*********************************Reception behaviour configuration END		***************************/

  /*********************************band Setup configuration Start		***************************/
  enCM_SetConfiguration_idx_AvailableBands               =  150 + 28, enCM_SetConfiguration_len_AvailableBands              =   4,
  enCM_SetConfiguration_idx_CombiBandConfig              =  154 + 28, enCM_SetConfiguration_len_CombiBandConfig             =   4,
  /** Band FM */
  enCM_SetConfiguration_idx_FM_LowFrequency              =  158 + 28, enCM_SetConfiguration_len_FM_LowFrequency             =   4,
  enCM_SetConfiguration_idx_FM_HighFrequency             =  162 + 28, enCM_SetConfiguration_len_FM_HighFrequency            =   4,
  enCM_SetConfiguration_idx_FM_StepSizeAutoSeek          =  166 + 28, enCM_SetConfiguration_len_FM_StepSizeAutoSeek         =   2,
  enCM_SetConfiguration_idx_FM_StepSizeManualStep        =  168 + 28, enCM_SetConfiguration_len_FM_StepSizeManualStep       =   2,
  enCM_SetConfiguration_idx_FM_LSM                       =  170 + 28, enCM_SetConfiguration_len_FM_LSM                      =   4,
  /** Band LW */
  enCM_SetConfiguration_idx_LW_LowFrequency              =  174 + 28, enCM_SetConfiguration_len_LW_LowFrequency             =   4,
  enCM_SetConfiguration_idx_LW_HighFrequency             =  178 + 28, enCM_SetConfiguration_len_LW_HighFrequency            =   4,
  enCM_SetConfiguration_idx_LW_StepSizeAutoSeek          =  182 + 28, enCM_SetConfiguration_len_LW_StepSizeAutoSeek         =   2,
  enCM_SetConfiguration_idx_LW_StepSizeManualStep        =  184 + 28, enCM_SetConfiguration_len_LW_StepSizeManualStep       =   2,
  enCM_SetConfiguration_idx_LW_LSM                       =  186 + 28, enCM_SetConfiguration_len_LW_LSM                      =   4,
  /** Band MW */  
  enCM_SetConfiguration_idx_MW_LowFrequency              =  190 + 28, enCM_SetConfiguration_len_MW_LowFrequency             =   4,
  enCM_SetConfiguration_idx_MW_HighFrequency             =  194 + 28, enCM_SetConfiguration_len_MW_HighFrequency            =   4,
  enCM_SetConfiguration_idx_MW_StepSizeAutoSeek          =  198 + 28, enCM_SetConfiguration_len_MW_StepSizeAutoSeek         =   2,
  enCM_SetConfiguration_idx_MW_StepSizeManualStep        =	200 + 28, enCM_SetConfiguration_len_MW_StepSizeManualStep       =   2,
  enCM_SetConfiguration_idx_MW_LSM                       =  202 + 28, enCM_SetConfiguration_len_MW_LSM                      =   4,
  enCM_SetConfiguration_idx_other_band_configs           =  206 + 28, enCM_SetConfiguration_len_other_band_configs          = 256,
  enCM_SetConfiguration_idx_reserved7			         =  462 + 28, enCM_SetConfiguration_len_reserved7				    =  38,
  
/*********************************band Setup configuration END		***************************/

/*********************************User Setting configuration Start		***************************/
  enCM_SetConfiguration_idx_TP_Switch_AudioTuner1        = 500 + 28, enCM_SetConfiguration_len_TP_Switch_AudioTuner1        =   1,
  enCM_SetConfiguration_idx_TP_Switch_AudioTuner2        = 501 + 28, enCM_SetConfiguration_len_TP_Switch_AudioTuner2        =   1,
  enCM_SetConfiguration_idx_AF_Switch_AudioTuner1        = 502 + 28, enCM_SetConfiguration_len_AF_Switch_AudioTuner1        =   1,
  enCM_SetConfiguration_idx_AF_Switch_AudioTuner2        = 503 + 28, enCM_SetConfiguration_len_AF_Switch_AudioTuner2        =   1,
  enCM_SetConfiguration_idx_DDA_Switch_AudioTuner1       = 504 + 28, enCM_SetConfiguration_len_DDA_Switch_AudioTuner1       =   1,
  enCM_SetConfiguration_idx_DDA_Switch_AudioTuner2       = 505 + 28, enCM_SetConfiguration_len_DDA_Switch_AudioTuner2       =   1,
  enCM_SetConfiguration_idx_RDS_Switch_AudioTuner1       = 506 + 28, enCM_SetConfiguration_len_RDS_Switch_AudioTuner1       =   1,
  enCM_SetConfiguration_idx_RDS_Switch_AudioTuner2       = 507 + 28, enCM_SetConfiguration_len_RDS_Switch_AudioTuner2       =   1,
  enCM_SetConfiguration_idx_PS_FIX_Switch_AudioTuner1    = 508 + 28, enCM_SetConfiguration_len_PS_FIX_Switch_AudioTuner1    =   1,
  enCM_SetConfiguration_idx_PS_FIX_Switch_AudioTuner2    = 509 + 28, enCM_SetConfiguration_len_PS_FIX_Switch_AudioTuner2    =   1,
  enCM_SetConfiguration_idx_Stereo_Switch_AudioTuner1    = 510 + 28, enCM_SetConfiguration_len_Stereo_Switch_AudioTuner1    =   1,
  enCM_SetConfiguration_idx_Stereo_Switch_AudioTuner2    = 511 + 28, enCM_SetConfiguration_len_Stereo_Switch_AudioTuner2    =   1,
  enCM_SetConfiguration_idx_REG_Switch_AudioTuner1       = 512 + 28, enCM_SetConfiguration_len_REG_Switch_AudioTuner1       =   1,
  enCM_SetConfiguration_idx_REG_Switch_AudioTuner2       = 513 + 28, enCM_SetConfiguration_len_REG_Switch_AudioTuner2       =   1,
  enCM_SetConfiguration_idx_PTY31_Switch_AudioTuner1     = 514 + 28, enCM_SetConfiguration_len_PTY31_Switch_AudioTuner1     =   1,
  enCM_SetConfiguration_idx_PTY31_Switch_AudioTuner2     = 515 + 28, enCM_SetConfiguration_len_PTY31_Switch_AudioTuner2     =   1,
  enCM_SetConfiguration_idx_DDS_Switch_AudioTuner1       = 516 + 28, enCM_SetConfiguration_len_DDS_Switch_AudioTuner1       =   1,
  enCM_SetConfiguration_idx_DDS_Switch_AudioTuner2       = 517 + 28, enCM_SetConfiguration_len_DDS_Switch_AudioTuner2       =   1,
  enCM_SetConfiguration_idx_DMQ_Switch_AudioTuner1       = 518 + 28, enCM_SetConfiguration_len_DMQ_Switch_AudioTuner1       =   1,
  enCM_SetConfiguration_idx_DMQ_Switch_AudioTuner2       = 519 + 28, enCM_SetConfiguration_len_DMQ_Switch_AudioTuner2       =   1,/*
  enCM_SetConfiguration_idx_reserved8                    = 520 + 28, enCM_SetConfiguration_len_reserved8                    =   30,*/
/*********************************User Setting configuration END		***************************/



/*********************************** HD Parameter Configuration  Starts **********************************/

 enCM_SetConfiguration_idx_reserved8								= 520 + 28, enCM_SetConfiguration_len_reserved8									=   10,
 
 enCM_SetConfiguration_idx_BlendThresholdFMHybrid                   = 530 + 28, enCM_SetConfiguration_len_BlendThresholdFMHybrid                    =   1,
 enCM_SetConfiguration_idx_DigiAudioScalingFMHybrid                 = 531 + 28, enCM_SetConfiguration_len_DigiAudioScalingFMHybrid                  =   2,
 enCM_SetConfiguration_idx_DigiAudioDelayFMHybridPrimaryBBRate      = 533 + 28, enCM_SetConfiguration_len_DigiAudioDelayFMHybridPrimaryBBRate       =   2,
 enCM_SetConfiguration_idx_BlendRateFMHybrid						= 535 + 28, enCM_SetConfiguration_len_BlendRateFMHybrid							=   1,
 enCM_SetConfiguration_idx_u8BlendThresholdAMHybrid                 = 536 + 28, enCM_SetConfiguration_len_u8BlendThresholdAMHybrid                  =   1,
 enCM_SetConfiguration_idx_u16AM_MPSAudioScaling					= 537 + 28, enCM_SetConfiguration_len_u16AM_MPSAudioScaling						=   2,
 enCM_SetConfiguration_idx_AM_MPSBlendRate							= 539 + 28, enCM_SetConfiguration_len_AM_MPSBlendRate							=   1,
 enCM_SetConfiguration_idx_DigiAudioDelayAM_MPSPrimaryBBRate        = 540 + 28, enCM_SetConfiguration_len_DigiAudioDelayAM_MPSPrimaryBBRate         =   2,
 enCM_SetConfiguration_idx_DigiAudioPhaseInversion                  = 542 + 28, enCM_SetConfiguration_len_DigiAudioPhaseInversion                   =   1,
 enCM_SetConfiguration_idx_BlendDecision							= 543 + 28, enCM_SetConfiguration_len_BlendDecision								=   1,
 enCM_SetConfiguration_idx_FM_CDNO_BlendDecision                    = 544 + 28, enCM_SetConfiguration_len_FM_CDNO_BlendDecision						=   1,
 enCM_SetConfiguration_idx_AM_CDNO_BlendDecision                    = 545 + 28, enCM_SetConfiguration_len_AM_CDNO_BlendDecision						=   1,

 enCM_SetConfiguration_idx_reserved15								= 546 + 28, enCM_SetConfiguration_len_reserved15									=   4,


/*********************************** HD Parameter Configuration  Ends   **********************************/

/*********************************RF and RDS parameter configuration Start		***************************/

  enCM_SetConfiguration_idx_FM_Channel_Separation        = 550 + 28, enCM_SetConfiguration_len_FM_Channel_Separation        =   1,
  enCM_SetConfiguration_idx_FM_Limiting                  = 551 + 28, enCM_SetConfiguration_len_FM_Limiting                  =   1,
  enCM_SetConfiguration_idx_FM_Multipath                 = 552 + 28, enCM_SetConfiguration_len_FM_Multipath                 =   1,
  enCM_SetConfiguration_idx_FM_Softmute                  = 553 + 28, enCM_SetConfiguration_len_FM_Softmute                  =   1,
  enCM_SetConfiguration_idx_AM_Softmute                  = 554 + 28, enCM_SetConfiguration_len_AM_Softmute                  =   1,
  enCM_SetConfiguration_idx_FM_Hicut_Configuration       = 555 + 28, enCM_SetConfiguration_len_FM_Hicut_Configuration       =   1,
  enCM_SetConfiguration_idx_AM_Hicut_Configuration       = 556 + 28, enCM_SetConfiguration_len_AM_Hicut_Configuration       =   1,
  enCM_SetConfiguration_idx_FM_Deemphasis                = 557 + 28, enCM_SetConfiguration_len_FM_Deemphasis                =   1,
  enCM_SetConfiguration_idx_AM_Deemphasis                = 558 + 28, enCM_SetConfiguration_len_AM_Deemphasis                =   1,
  enCM_SetConfiguration_idx_FM_Frequency_Response        = 559 + 28, enCM_SetConfiguration_len_FM_Frequency_Response        =   1,
  enCM_SetConfiguration_idx_AM_Frequency_Response        = 560 + 28, enCM_SetConfiguration_len_AM_Frequency_Response        =   1,
  enCM_SetConfiguration_idx_FM_Miscellaneous             = 561 + 28, enCM_SetConfiguration_len_FM_Miscellaneous             =   1,
  enCM_SetConfiguration_idx_AM_Miscellaneous             = 562 + 28, enCM_SetConfiguration_len_AM_Miscellaneous             =   1,
  enCM_SetConfiguration_idx_AM_Antenna_Attenuation       = 563 + 28, enCM_SetConfiguration_len_AM_Antenna_Attenuation       =   1,
  enCM_SetConfiguration_idx_FM_Antenna_Attenuation       = 564 + 28, enCM_SetConfiguration_len_FM_Antenna_Attenuation       =   1,
  enCM_SetConfiguration_idx_PhysicalTunerConfigId        = 565 + 28, enCM_SetConfiguration_len_PhysicalTunerConfigId        =   1,
  enCM_SetConfiguration_idx_AntennaConfigId              = 566 + 28, enCM_SetConfiguration_len_AntennaConfigId              =   1,

#ifndef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  enCM_SetConfiguration_idx_reserved9                    = 567 + 28, enCM_SetConfiguration_len_reserved9                    =   3,
#else
  enCM_SetConfiguration_idx_AMFM_Hicut_Extender    = 567 + 28, enCM_SetConfiguration_len_AMFM_Hicut_Extender        =   1,
  enCM_SetConfiguration_idx_FM_Softmute_Timing       = 568 + 28, enCM_SetConfiguration_len_FM_Softmute_Timing        =   1,
  enCM_SetConfiguration_idx_AMFM_Misc2                    = 569 + 28, enCM_SetConfiguration_len_AMFM_Misc2                    =   1,
#endif

  enCM_SetConfiguration_idx_EXCHANGE_ANTENNA_LEVEL       = 570 + 28, enCM_SetConfiguration_len_EXCHANGE_ANTENNA_LEVEL       =   1,
  enCM_SetConfiguration_idx_PITEST_LEVEL                 = 571 + 28, enCM_SetConfiguration_len_PITEST_LEVEL                 =   1,
  enCM_SetConfiguration_idx_NRDS_LEVEL                   = 572 + 28, enCM_SetConfiguration_len_NRDS_LEVEL                   =   1,
  enCM_SetConfiguration_idx_EON_LEVEL                    = 573 + 28, enCM_SetConfiguration_len_EON_LEVEL                    =   1,
  enCM_SetConfiguration_idx_FM_MEMO_LEVEL                = 574 + 28, enCM_SetConfiguration_len_FM_MEMO_LEVEL                =   1,
  enCM_SetConfiguration_idx_PANIC_FIELDST_LEVEL          = 575 + 28, enCM_SetConfiguration_len_PANIC_FIELDST_LEVEL          =   1,
  enCM_SetConfiguration_idx_PARAM_RDS_LEVEL              = 576 + 28, enCM_SetConfiguration_len_PARAM_RDS_LEVEL              =   1,
  enCM_SetConfiguration_idx_RDS_DATA_ACCEPT_LEVEL        = 577 + 28, enCM_SetConfiguration_len_RDS_DATA_ACCEPT_LEVEL        =   1,
  enCM_SetConfiguration_idx_PI_STEP_LEVEL                = 578 + 28, enCM_SetConfiguration_len_PI_STEP_LEVEL                =   1,
  enCM_SetConfiguration_idx_DDA_ANTENNA_DIST_LEVEL       = 579 + 28, enCM_SetConfiguration_len_DDA_ANTENNA_DIST_LEVEL       =   1,
  enCM_SetConfiguration_idx_RDS_SYN_DELAY_CNT            = 580 + 28, enCM_SetConfiguration_len_RDS_SYN_DELAY_CNT            =   1,
  enCM_SetConfiguration_idx_MP_MEASURE_LEVEL             = 581 + 28, enCM_SetConfiguration_len_MP_MEASURE_LEVEL             =   1,
  enCM_SetConfiguration_idx_MP_LEVEL2_LEVEL              = 582 + 28, enCM_SetConfiguration_len_MP_LEVEL2_LEVEL              =   1,
  enCM_SetConfiguration_idx_MP_VERYBAD_LEVEL             = 583 + 28, enCM_SetConfiguration_len_MP_VERYBAD_LEVEL             =   1,
  enCM_SetConfiguration_idx_MP_MEDIUM_LEVEL              = 584 + 28, enCM_SetConfiguration_len_MP_MEDIUM_LEVEL              =   1,
  enCM_SetConfiguration_idx_RDS_BAD_LEVEL                = 585 + 28, enCM_SetConfiguration_len_RDS_BAD_LEVEL                =   1,
  enCM_SetConfiguration_idx_ILLEGAL_AF                   = 586 + 28, enCM_SetConfiguration_len_ILLEGAL_AF                   =   1,
  enCM_SetConfiguration_idx_AF_SAVE_LEVEL                = 587 + 28, enCM_SetConfiguration_len_AF_SAVE_LEVEL                =   1,
  enCM_SetConfiguration_idx_FIRST_RUNDUM                 = 588 + 28, enCM_SetConfiguration_len_FIRST_RUNDUM                 =   1,
  enCM_SetConfiguration_idx_SECOND_RUNDUM                = 589 + 28, enCM_SetConfiguration_len_SECOND_RUNDUM                =   1,
  enCM_SetConfiguration_idx_THIRD_RUNDUM                 = 590 + 28, enCM_SetConfiguration_len_THIRD_RUNDUM                 =   1,
  enCM_SetConfiguration_idx_PI_STEP_MODE                 = 591 + 28, enCM_SetConfiguration_len_PI_STEP_MODE                 =   1,
  enCM_SetConfiguration_idx_AUDIO_OFF_SCANMODE           = 592 + 28, enCM_SetConfiguration_len_AUDIO_OFF_SCANMODE           =   1,
  enCM_SetConfiguration_idx_AM_LEARN_CYCLE               = 593 + 28, enCM_SetConfiguration_len_AM_LEARN_CYCLE               =   1,
  enCM_SetConfiguration_idx_PI_IGNORE                    = 594 + 28, enCM_SetConfiguration_len_PI_IGNORE                    =   1,
  enCM_SetConfiguration_idx_PI_SEARCH_TIME               = 595 + 28, enCM_SetConfiguration_len_PI_SEARCH_TIME               =   1,
  /**Value is ZERO then NO, if ONE then YES
  FOR MIB the Default is YES and NO for other projects.*/
  enCM_SetConfiguration_idx_DISABLE_SEAMLESS_BLENDING    = 596 + 28, enCM_SetConfiguration_len_DISABLE_SEAMLESS_BLENDING    =   1,
  enCM_SetConfiguration_idx_SL_ADJ_THRESHOLD             = 597 + 28, enCM_SetConfiguration_len_SL_ADJ_THRESHOLD             =   1,
  enCM_SetConfiguration_idx_SL_MP_THRESHOLD              = 598 + 28, enCM_SetConfiguration_len_SL_MP_THRESHOLD              =   1,
  enCM_SetConfiguration_idx_SPECIAL_FM_START_FREQUENCY   = 599 + 28, enCM_SetConfiguration_len_SPECIAL_FM_START_FREQUENCY   =   1,
  enCM_SetConfiguration_idx_reserved14                   = 600 + 28, enCM_SetConfiguration_len_reserved14                   =   2,
  enCM_SetConfiguration_idx_HD_Scan_Every_Freq           = 601 + 28, enCM_SetConfiguration_len_HD_Scan_Every_Freq           =   1,
  enCM_SetConfiguration_idx_HW_SubConfig				 = 602 + 28, enCM_SetConfiguration_len_HW_SubConfig                 =   1,
  enCM_SetConfiguration_idx_reserved10                   = 603 + 28, enCM_SetConfiguration_len_reserved10                   =  15,

  /*********************************HF and RDS parameter configuration End		***************************/

  /*********************************TestMode and AF-List configuration Start		***************************/
  enCM_SetConfiguration_idx_reserved11                    = 618 + 28, enCM_SetConfiguration_len_reserved11                    =  32,
  enCM_SetConfiguration_idx_TestModeDataUpdateInterval   = 650 + 28, enCM_SetConfiguration_len_TestModeDataUpdateInterval   =   1,
  enCM_SetConfiguration_idx_AFListUpdateInterval		 = 651 + 28, enCM_SetConfiguration_len_AFListUpdateInterval         =   1,
  enCM_SetConfiguration_idx_AFListReleaseBehaviour       = 652 + 28, enCM_SetConfiguration_len_AFListReleaseBehaviour       =   1,
  enCM_SetConfiguration_idx_reserved12                   = 653 + 28, enCM_SetConfiguration_len_reserved12                   =  27,
  /*********************************TestMode and AF-List configuration End		***************************/

  /*********************************Station List configuration Start	***************************/
  enCM_SetConfiguration_idx_MaxNumberofStationsInStnList       = 680 + 28, enCM_SetConfiguration_len_MaxNumberofStationsInStnList       =   1,
  enCM_SetConfiguration_idx_reserved13                         = 681 + 28, enCM_SetConfiguration_len_reserved13                         =  19,
  /*********************************Station List configuration End		***************************/


  enCM_SetConfiguration_idx_PresetList                   = 700 + 28 /* length depends on KDS entry */
} tenCM_SetConfiguration;
/*==========================================================================*/

/*============================================================================
 * CM_GetConfigurationInfo
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_GetConfigurationInfo_idx_VersionId        = 10, enCM_GetConfigurationInfo_len_VersionId       = 4,
  enCM_GetConfigurationInfo_idx_u32Checksum      = 14, enCM_GetConfigurationInfo_len_u32Checksum     = 1
} tenCM_GetConfigurationInfo;
/*==========================================================================*/

/*============================================================================
 * CM_VersionInf
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_VersionInf_idx_SoftwareVersion            = 10, enCM_VersionInf_len_SoftwareVersion       = 64,
  enCM_VersionInf_idx_HardwareVersion            = 74, enCM_VersionInf_len_HardwareVersion       = 64
} tenCM_VersionInf;
/*============================================================================
 * CM_AdditionalVersionInf
 *--------------------------------------------------------------------------*/
typedef enum
{
    enCM_AdditionalVersionInf_idx_VersionNumber = 10, enCM_AdditionalVersionInf_len_VersionNumber = 2,
    enCM_AdditionalVersionInf_idx_VersionDigit1 = 12, enCM_AdditionalVersionInf_len_VersionDigit1 = 1,
    enCM_AdditionalVersionInf_idx_VersionDigit2 = 13, enCM_AdditionalVersionInf_len_VersionDigit2 = 1,
    enCM_AdditionalVersionInf_idx_VersionDigit3 = 14, enCM_AdditionalVersionInf_len_VersionDigit3 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_3 = 15, enCM_AdditionalVersionInf_len_rfu_byte_3 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_4 = 16, enCM_AdditionalVersionInf_len_rfu_byte_4 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_5 = 17, enCM_AdditionalVersionInf_len_rfu_byte_5 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_6 = 18, enCM_AdditionalVersionInf_len_rfu_byte_6 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_7 = 19, enCM_AdditionalVersionInf_len_rfu_byte_7 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_8 = 20, enCM_AdditionalVersionInf_len_rfu_byte_8 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_9 = 21, enCM_AdditionalVersionInf_len_rfu_byte_9 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_10 = 22, enCM_AdditionalVersionInf_len_rfu_byte_10 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_11 = 23, enCM_AdditionalVersionInf_len_rfu_byte_11  = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_12 = 24, enCM_AdditionalVersionInf_len_rfu_byte_12 = 1,
    enCM_AdditionalVersionInf_idx_rfu_byte_13 = 25, enCM_AdditionalVersionInf_len_rfu_byte_13 = 1
}tenCM_AdditionalVersionInf;
/*==========================================================================*/

/*============================================================================
 * parameter for bSendCM_SetConfiguration
 *--------------------------------------------------------------------------*/
typedef enum
{
  enTraceSetConfiguration_Send                       = 0x10,
  enTraceSetConfiguration_SendAndTracePlain          = 0x11,
  enTraceSetConfiguration_SendAndTraceRaw            = 0x12,
  enTraceSetConfiguration_SendAndTracePlainAndRaw    = 0x13,
  enTraceSetConfiguration_TraceOnlyPlain             = 0x01,
  enTraceSetConfiguration_TraceOnlyRaw               = 0x02,
  enTraceSetConfiguration_TraceOnlyPlainAndRaw       = 0x03,
  enTraceSetConfiguration_CalculateCRCOnly           = 0x20

} tenTraceSetConfiguration;
/*==========================================================================*/


/*============================================================================
 * CM_ATAfList
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: SET
   *-------------------------------------------------------------------------*/
  enCM_ATAfList_idx_AtAfListActivity             = 10, enCM_ATAfList_len_AtAfListActivity        = 1,

  /*--------------------------------------------------------------------------
   * OpType: STATUS
   *-------------------------------------------------------------------------*/
  enCM_ATAfList_idx_NumberOfAfs                  = 10, enCM_ATAfList_len_NumberOfAfs             = 1,
                                                                                             /* ------ */
   enCM_ATAfList_idx_ListData                  = 11, 
                                                                                             /* ------ */
  enCM_ATAfList_idx_Frequency                    = 0, enCM_ATAfList_len_Frequency               = 4,
  enCM_ATAfList_idx_PI		                     = 4, enCM_ATAfList_len_PI		                 = 2,
  enCM_ATAfList_idx_QualityLevel                 = 6, enCM_ATAfList_len_QualityLevel            = 1,
  enCM_ATAfList_idx_FieldStrength                = 7, enCM_ATAfList_len_FieldStrength			 = 1,
  enCM_ATAfList_idx_BitErrorRate				 = 8, enCM_ATAfList_len_BitErrorRate		     = 1,
  enCM_ATAfList_idx_AfInfo                       = 9, enCM_ATAfList_len_AfInfo                  = 1,
                                                                                             /* ------ */
                                                       enCM_ATAfList_len_ListElement             = 10

} tenCM_ATAfList;
/*----------------------------------------------------------------------------
 * AtAfListActivity
 *--------------------------------------------------------------------------*/
typedef enum
{
  enAtAfListActivity_auto_notifications_off      = 0,
  enAtAfListActivity_auto_notifications_on       = 1

} tenAtAfListActivity;
/*==========================================================================*/


/*============================================================================
 * ATFrequency
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Set, SetGet, Status
   *-------------------------------------------------------------------------*/
  enATFrequency_idx_Frequency                    = 10, enATFrequency_len_Frequency               = 4,

  /*--------------------------------------------------------------------------
   * OpType: Increment
   *-------------------------------------------------------------------------*/
  enATFrequency_idx_NSteps                       = 10, enATFrequency_len_NSteps                  = 1

} tenATFrequency;

/*----------------------------------------------------------------------------
 * Absolute or relative
 *--------------------------------------------------------------------------*/
typedef enum
{
  enATFrequencyAbsOrRel_AbsoluteValue                       = 0x00,
  enATFrequencyAbsOrRel_RelativeValue                       = 0x01
} tenATFrequencyAbsOrRel;
/*----------------------------------------------------------------------------
 * Direction
 *--------------------------------------------------------------------------*/
typedef enum
{
  enATFrequencyDirection_unused                             = 0x00,
  enATFrequencyDirection_Up                                 = 0x01,
  enATFrequencyDirection_Down                               = 0xFF
} tenATFrequencyDirection;
/*==========================================================================*/


/*============================================================================
 * CM_ATBand
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Status
   *-------------------------------------------------------------------------*/
  enCM_ATBand_idx_Band                     = 10, enCM_ATBand_len_Band                = 1,
  enCM_ATBand_idx_Frequency                    = 11, enCM_ATBand_len_Frequency               = 4,
  enCM_ATBand_idx_PI                    = 15, enCM_ATBand_len_PI               = 2,
  enCM_ATBand_idx_Stationname                    = 17, enCM_ATBand_len_Stationname               = 8,

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  enCM_ATBand_idx_HDCallSign                    = 25, enCM_ATBand_len_HDCallSign               = 16,
  enCM_ATBand_idx_HDStationID                    = 41, enCM_ATBand_len_HDStationID               = 4,
  enCM_ATBand_idx_HDAudioService                    = 45, enCM_ATBand_len_HDAudioService               = 1,
  enCM_ATBand_idx_ActivePresetList                    = 46, enCM_ATBand_len_ActivePresetList               = 2,
  enCM_ATBand_idx_PresetAutoCompare                    = 48, enCM_ATBand_len_PresetAutoCompare               = 1,
  enCM_ATBand_idx_DRMServiceLabel                    = 49, enCM_ATBand_len_DRMServiceLabel               = 64,
  enCM_ATBand_idx_DRMServiceId                    = 113, enCM_ATBand_len_DRMServiceId               = 4,
  enCM_ATBand_idx_DRMServiceShortId                    = 117, enCM_ATBand_len_DRMServiceShortId               = 1,
  enCM_ATBand_idx_RFUBytes                    = 118, enCM_ATBand_len_RFUBytes               = 19
#else
  enCM_ATBand_idx_ActivePresetList                    = 25, enCM_ATBand_len_ActivePresetList               = 2,
  enCM_ATBand_idx_PresetAutoCompare                    = 27, enCM_ATBand_len_PresetAutoCompare               = 1

#endif
} tenCM_ATBand;
/*==========================================================================*/


/*============================================================================
 * CurrentRadiotext
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Status
   *-------------------------------------------------------------------------*/
  enCurrentRadiotext_idx_Pos                     = 10, enCurrentRadiotext_len_Pos                = 2,
  enCurrentRadiotext_idx_PosX                    = 10, enCurrentRadiotext_len_PosX               = 1,
  enCurrentRadiotext_idx_PosY                    = 11, enCurrentRadiotext_len_PosY               = 1,
  enCurrentRadiotext_idx_Data                    = 12, enCurrentRadiotext_len_Data               = 64

} tenCurrentRadiotext;
/*==========================================================================*/


/*============================================================================
 * TAMessage
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Status
   *-------------------------------------------------------------------------*/
  enTAMessage_idx_TAMessageInfo                  = 10, enTAMessage_len_TAMessageInfo             = 1

} tenTAMessage;
/*----------------------------------------------------------------------------
 * Mask for TAMessageInfo
 *--------------------------------------------------------------------------*/
#define TUN_TAMESSAGEINFO_BIT_MSK_TA            	  0x01
#define TUN_ANNOUNCEMENTMESSAGE_BIT_MSK_EON           0x02
/*==========================================================================*/


/*============================================================================
 * CM_StationListConfig
 *--------------------------------------------------------------------------*/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: StartResult
   *-------------------------------------------------------------------------*/
  enCM_StationListConfig_idx_ListId              = 10, enCM_StationListConfig_len_ListId         = 1,
  enCM_StationListConfig_idx_Band                = 11, enCM_StationListConfig_len_Band           = 4,
  enCM_StationListConfig_idx_AnalogFilter        = 15, enCM_StationListConfig_len_AnalogFilter   = 1,
  enCM_StationListConfig_idx_DigitalFilter       = 16, enCM_StationListConfig_len_DigitalFilter  = 1,
  enCM_StationListConfig_idx_PtyFilter           = 17, enCM_StationListConfig_len_PtyFilter      = 4,
  enCM_StationListConfig_idx_Sorting             = 21, enCM_StationListConfig_len_Sorting        = 1,
  enCM_StationListConfig_idx_RFUBytes            = 22, enCM_StationListConfig_len_RFUBytes       = 4,

  /*--------------------------------------------------------------------------
   * OpType: Result
   *-------------------------------------------------------------------------*/
  enCM_StationListConfig_idx_NumberOfStations    = 11, enCM_StationListConfigt_len_NumberOfStations = 2

} tenCM_StationListConfig;
#else
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: StartResult
   *-------------------------------------------------------------------------*/
  enCM_StationListConfig_idx_ListId              = 10, enCM_StationListConfig_len_ListId         = 1,
  enCM_StationListConfig_idx_Band                = 11, enCM_StationListConfig_len_Band           = 4,
  enCM_StationListConfig_idx_RdsFilter           = 15, enCM_StationListConfig_len_RdsFilter      = 1,
  enCM_StationListConfig_idx_PtyFilter           = 16, enCM_StationListConfig_len_PtyFilter      = 4,
  enCM_StationListConfig_idx_Sorting             = 20, enCM_StationListConfig_len_Sorting        = 1,

  /*--------------------------------------------------------------------------
   * OpType: Result
   *-------------------------------------------------------------------------*/
  enCM_StationListConfig_idx_NumberOfStations    = 11, enCM_StationListConfigt_len_NumberOfStations = 2

} tenCM_StationListConfig;
#endif
/*----------------------------------------------------------------------------
 * Mask for Band
 *--------------------------------------------------------------------------*/
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_FM            0x00000001
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_LW            0x00000002
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_MW            0x00000004
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_1          0x00000008
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_2          0x00000010
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_3          0x00000020
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_4          0x00000040
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_5          0x00000080
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_6          0x00000100
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_7          0x00000200
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_8          0x00000400
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_9          0x00000800
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_10         0x00001000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_11         0x00002000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_12         0x00004000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_13         0x00008000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_SW_14         0x00010000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_TRF           0x00020000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_WB            0x00040000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_CB_1          0x00080000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_CB_2          0x00100000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_CB_3          0x00200000
#define TUN_CM_STATIONLISTCONFIG_BAND_BIT_MSK_CB_4          0x00400000

#define TUN_CM_LANDSCAPEUPDATE_BAND_MASK					0x00000001
#define ATSTATIONINFO_AF_MASK   							0x08
/*----------------------------------------------------------------------------
 * RdsFilter
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_StationListConfigRdsFilter_RDS_NONRDS_RDSunknown           = 0,
  enCM_StationListConfigRdsFilter_RDSonly                         = 1,
  enCM_StationListConfigRdsFilter_RDS_NONRDS                      = 2,
  enCM_StationListConfigRdsFilter_TPstation                       = 3,
  enCM_StationListConfigRdsFilter_TPSelf                          = 4,
  enCM_StationListConfigRdsFilter_TMCstation                      = 5
} tenCM_StationListConfigRdsFilter;
/*----------------------------------------------------------------------------
 * ConfigListID
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_StationListConfigListID_FM           = 0,
  enCM_StationListConfigListID_TMC          = 1,
  enCM_StationListConfigListID_MW           = 2,
  enCM_StationListConfigListID_LW           = 3,
  enCM_StationListConfigListID_AM           = 4
} tenCM_StationListConfigListID;
/*----------------------------------------------------------------------------
 * Mask for PtyFilter
 *--------------------------------------------------------------------------*/
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_ALL                        0xFFFFFFFF
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_NO_PTY                     0x00000001
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_NEWS                       0x00000002
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_CURRENT_AFFAIRS            0x00000004
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_INFORMATION                0x00000008
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_SPORT                      0x00000010
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_EDUCATION                  0x00000020
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_DRAMA                      0x00000040
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_CULTURE                    0x00000080
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_SCIENCE                    0x00000100
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_VARIED                     0x00000200
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_POP_MUSIC                  0x00000400
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_ROCK_MUSIC                 0x00000800
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_EASY_LISTENING             0x00001000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_LIGHT_CLASSICAL            0x00002000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_SERIOUS_CLASSICAL          0x00004000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_OTHER MUSIC                0x00008000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_WEATHER                    0x00010000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_FINANCE                    0x00020000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_FOR_CHILDREN               0x00040000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_SOCIAL_AFFAIRS             0x00080000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_RELIGION                   0x00100000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_PHONE_IN                   0x00200000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_TRAVEL                     0x00400000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_LEISURE                    0x00800000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_JAZZ_MUSIC                 0x01000000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_COUNTRY_MUSIC              0x02000000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_NATIONAL_MUSIC             0x04000000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_OLDIES_MUSIC               0x08000000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_FOLK_MUSIC                 0x10000000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_DOCUMENTARY                0x20000000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_ALARM_TEST                 0x40000000
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_ALARM                      0x80000000
/** Required for MW/LW station lists */
#define TUN_CM_STATIONLISTCONFIG_PTYFILTER_NONE                       0x00000000
/*----------------------------------------------------------------------------
 * Mask for Sorting
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_StationListConfigSorting_PS_ASCENDING                      = 0,
  enCM_StationListConfigSorting_PI_ASCENDING                      = 1,
  enCM_StationListConfigSorting_FIELDSTRENGTH_ASCENDING           = 2,
  enCM_StationListConfigSorting_FREQUENCY_ASCENDING               = 3,
  enCM_StationListConfigSorting_PS_DESCENDING                     = 4,
  enCM_StationListConfigSorting_PI_DESCENDING                     = 5,
  enCM_StationListConfigSorting_FIELDSTRENGTH_DESCENDING          = 6,
  enCM_StationListConfigSorting_FREQUENCY_DESCENDING              = 7
} tenCM_StationListConfigSorting;

/*==========================================================================*/


/*============================================================================
 * CM_StationListRelease
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Set
   *-------------------------------------------------------------------------*/
  enCM_StationListRelease_idx_ListId             = 10, enCM_StationListRelease_len_ListId           = 1

} tenCM_StationListRelease;
/*==========================================================================*/



#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
/*============================================================================
 * CM_StationsList
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Status
   *-------------------------------------------------------------------------*/
  enCM_StationsList_idx_Pos                      = 10, enCM_StationsList_len_Pos                 = 2,
  enCM_StationsList_idx_PosX                     = 10, enCM_StationsList_len_PosX                = 1,
  enCM_StationsList_idx_PosY                     = 11, enCM_StationsList_len_PosY                = 1,
  enCM_StationsList_idx_Data                     = 12, enCM_StationsList_len_ConstantData_ExceptSendername        = 25,
  enCM_StationsList_idx_Selected                 =  0, enCM_StationsList_len_Selected            = 1,
  enCM_StationsList_idx_ModulationType           =  1, enCM_StationsList_len_ModulationType      = 1,
  enCM_StationsList_idx_Frequency                =  2, enCM_StationsList_len_Frequency           = 4,
  /** Sendername / HDCallSign / DRMServiceLabel is split into size and data */
  enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_size               =  6, enCM_StationsList_len_Sendername_HDCallSign_DRMServiceLabel_size          = 1,
  enCM_StationsList_idx_Sendername_HDCallSign_DRMServiceLabel_data               =  7, 

  /** size of Sendername_HDCallSign_DRMServiceLabel_data is dynamic. all below indices have to be added with proper offset */
  enCM_StationsList_offset_SendernameInfo           = 0, enCM_StationsList_len_SendernameInfo      = 1,
  enCM_StationsList_offset_PTY_HDStationGenre_DRMPty                      = 1, enCM_StationsList_len_PTY_HDStationGenre_DRMPty                 = 1,
  enCM_StationsList_offset_PI_HDStationId_DRMServiceID                       = 2, enCM_StationsList_len_PI_HDStationId_DRMServiceID                  = 4,
  enCM_StationsList_offset_StationInfo                   = 6, enCM_StationsList_len_StationInfo              = 1,
  enCM_StationsList_offset_ReceptionQuality         = 7, enCM_StationsList_len_ReceptionQuality    = 1,
  enCM_StationsList_offset_TMC                      = 8, enCM_StationsList_len_TMC                 = 1,
  enCM_StationsList_offset_PresetListForAcmp        = 9, enCM_StationsList_len_PresetListForAcmp   = 2,
  enCM_StationsList_offset_PresetAcmp               = 11, enCM_StationsList_len_PresetAcmp          = 1,
  enCM_StationsList_offset_LevelComp                = 12, enCM_StationsList_len_LevelComp          = 1,
  enCM_StationsList_offset_HDTextEncoding                = 13, enCM_StationsList_len_HDTextEncoding          = 1,
  enCM_StationsList_offset_HDNumberOfAudioPrograms                = 14, enCM_StationsList_len_HDNumberOfAudioPrograms          = 1,
  enCM_StationsList_offset_RFU_bytes                = 15, enCM_StationsList_len_RFU_bytes          = 3,
                                                    /* enCM_StationsList_len_Data                 23   */
  enCM_StationsList_get_idx_ListId                   = 12,enCM_StationsList_len_ListId              = 1



} tenCM_StationsList;
#else

/*============================================================================
 * CM_StationsList
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Status
   *-------------------------------------------------------------------------*/
  enCM_StationsList_idx_Pos                      = 10, enCM_StationsList_len_Pos                 = 2,
  enCM_StationsList_idx_PosX                     = 10, enCM_StationsList_len_PosX                = 1,
  enCM_StationsList_idx_PosY                     = 11, enCM_StationsList_len_PosY                = 1,
  enCM_StationsList_idx_Data                     = 12, enCM_StationsList_len_Data                = 24,
  enCM_StationsList_idx_Selected                 =  0, enCM_StationsList_len_Selected            = 1,
  enCM_StationsList_idx_Frequency                =  1, enCM_StationsList_len_Frequency           = 4,
  enCM_StationsList_idx_Sendername               =  5, enCM_StationsList_len_Sendername          = 8,
  enCM_StationsList_idx_SendernameInfo           = 13, enCM_StationsList_len_SendernameInfo      = 1,
  enCM_StationsList_idx_PTY                      = 14, enCM_StationsList_len_PTY                 = 1,
  enCM_StationsList_idx_PI                       = 15, enCM_StationsList_len_PI                  = 2,
  enCM_StationsList_idx_TpInfo                   = 17, enCM_StationsList_len_TpInfo              = 1,
  enCM_StationsList_idx_ReceptionQuality         = 18, enCM_StationsList_len_ReceptionQuality    = 1,
  enCM_StationsList_idx_TMC                      = 19, enCM_StationsList_len_TMC                 = 1,
  enCM_StationsList_idx_PresetListForAcmp        = 20, enCM_StationsList_len_PresetListForAcmp   = 2,
  enCM_StationsList_idx_PresetAcmp               = 22, enCM_StationsList_len_PresetAcmp          = 1,
  enCM_StationsList_idx_LevelComp                = 23, enCM_StationsList_len_LevelComp          = 1,
                                                    /* enCM_StationsList_len_Data                 23   */
  enCM_StationsList_get_idx_ListId                   = 12,enCM_StationsList_len_ListId              = 1

    /*  max length = 10 + 2 + ( 255 * 23 ) + 1 = 5878 bytes   */

} tenCM_StationsList;
#endif

/*============================================================================
 * CM_TMCStations
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Status
   *-------------------------------------------------------------------------*/
	  enCM_TMCStations_idx_Pos                      = 10, enCM_TMCStations_len_Pos                 = 2,
	  enCM_TMCStations_idx_PosX                     = 10, enCM_TMCStations_len_PosX                = 1,
	  enCM_TMCStations_idx_PosY                     = 11, enCM_TMCStations_len_PosY                = 1,
	  enCM_TMCStations_idx_StationsInList           = 12, enCM_TMCStations_len_StationsInList      = 1,
	  enCM_TMCStations_idx_Data                     = 13, enCM_TMCStations_len_Data                = 20,
	  enCM_TMCStations_idx_Frequency                =  0, enCM_TMCStations_len_Frequency           = 4,
	  enCM_TMCStations_idx_PI                       =  4, enCM_TMCStations_len_PI                  = 2,
	  enCM_TMCStations_idx_Sendername               =  6, enCM_TMCStations_len_Sendername          = 8,
	  enCM_TMCStations_idx_Quality                  = 14, enCM_TMCStations_len_Quality             = 1,
	  enCM_TMCStations_idx_RDBIDPrio                = 15, enCM_TMCStations_len_RDBIDPrio           = 1,
	  enCM_TMCStations_idx_CC                       = 16, enCM_TMCStations_len_CC	               = 1,
	  enCM_TMCStations_idx_LTN                      = 17, enCM_TMCStations_len_LTN                 = 1,
	  enCM_TMCStations_idx_SID                      = 18, enCM_TMCStations_len_SID                 = 1,
	  enCM_TMCStations_idx_EncryptionFlag           = 19, enCM_TMCStations_len_EncryptionFlag      = 1

} tenCM_TMCStations;

/*============================================================================
 * StationListStationInfo
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * Extracting bits of station info
   *-------------------------------------------------------------------------*/
  tenStationListStationInfo_bit1_TP = 0x01, 
  tenStationListStationInfo_bit2_AF = 0x02

} tenStationListStationInfo;

/*============================================================================
 * CM_PresetList
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Status
   *-------------------------------------------------------------------------*/
  enCM_PresetList_idx_Pos                        = 10, enCM_PresetList_len_Pos                 = 2,
  enCM_PresetList_idx_PosX                       = 10, enCM_PresetList_len_PosX                = 1,
  enCM_PresetList_idx_PosY                       = 11, enCM_PresetList_len_PosY                = 1,
  enCM_PresetList_idx_Data                       = 12, 
  enCM_PresetList_idx_Selected                   =  0, enCM_PresetList_len_Selected            = 1,
  enCM_PresetList_idx_Frequency                  =  1, enCM_PresetList_len_Frequency           = 4,
  enCM_PresetList_idx_Sendername               =  5, enCM_PresetListt_len_Sendername         = 8,
  enCM_PresetList_idx_PI                         = 13, enCM_PresetList_len_PI                  = 2,
  enCM_PresetList_idx_StationNameInfo            = 15, enCM_PresetList_len_StationNameInfo     = 1,
  enCM_PresetList_idx_TpTmcInfo                  = 16, enCM_PresetList_len_TpTmcInfo           = 1,
  enCM_PresetList_idx_PTY                        = 17, enCM_PresetList_len_PTY                 = 1,
  enCM_PresetList_idx_Level_Comp                 = 18, enCM_PresetList_len_Level_Comp          = 1
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  ,
  enCM_PresetList_len_Data               = 94,
  enCM_PresetList_idx_DigitalModulation					= 19, enCM_PresetList_len_DigitalModulation							= 1,
  enCM_PresetList_idx_HDStationId_or_DRMServiceId		= 20, enCM_PresetList_len_HDStationId_or_DRMServiceId				= 4,
  enCM_PresetList_idx_HDCallSign_or_DRMServiceLabel		= 24, enCM_PresetList_len_HDCallSign_or_DRMServiceLabel				= 64,
  enCM_PresetList_idx_HdtextEncoding					= 88, enCM_PresetList_len_HdtextEncoding							= 1,
  enCM_PresetList_idx_HDStationGenre_or_DRMPty          = 89, enCM_PresetList_len_HDStationGenre_or_DRMPty					= 1,
  enCM_PresetList_idx_HDProgramNumber_or_DRMServiceShortId	= 90, enCM_PresetList_len_HDProgramNumber_or_DRMServiceShortId   = 1,
  enCM_PresetList_idx_RFU_Bytes							= 91, enCM_PresetList_len_RFU_Bytes									= 3
  #else
  ,enCM_PresetList_len_Data               = 19
  #endif

} tenCM_PresetList;

#define PRESET_ACTION_INVALID 255
/*----------------------------------------------------------------------------
 * SendernameInfo
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_StationsListSendernameInfo_NON_RDS_Station                    = 0,
  enCM_StationsListSendernameInfo_Station_name_is_first_received_PS  = 1,
  enCM_StationsListSendernameInfo_Station_name_is_last_received_PS   = 2,
  enCM_StationsListSendernameInfo_not_supported_3                    = 3,
  enCM_StationsListSendernameInfo_Name_assigned_by_customer          = 4,
  enCM_StationsListSendernameInfo_not_supported_5                    = 5

} tenCM_StationsListSendernameInfo;
/*----------------------------------------------------------------------------
 * TMC
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_StationsListTMC_undecoded                            = 0x00,
  enCM_StationsListTMC_lost                                 = 0x01,
  enCM_StationsListTMC_no                                   = 0x02,
  enCM_StationsListTMC_free                                 = 0x03,
  enCM_StationsListTMC_pay                                  = 0x04
} tenCM_StationsListTMC;
/*----------------------------------------------------------------------------
 * Posy indices
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_StationsListPosY_selectAll                           = 0x00,
  enCM_StationsListPosY_Selected                            = 0x01,
  enCM_StationsListPosY_Frequency                           = 0x02,
  enCM_StationsListPosY_Sendername                          = 0x03,
  enCM_StationsListPosY_SendernameInfo                      = 0x04,
  enCM_StationsListPosY_PTY                                 = 0x05,
  enCM_StationsListPosY_PI                                  = 0x06,
  enCM_StationsListPosY_TpInfo                              = 0x07,
  enCM_StationsListPosY_ReceptionQuality                    = 0x08,
  enCM_StationsListPosY_TMC                                 = 0x09,
  enCM_StationsListPosY_PresetListForAcmp                   = 0x0A,
  enCM_StationsListPosY_PresetAcmp                          = 0x0B
} tenCM_StationsListPosY;
/*==========================================================================*/

typedef enum
{
  enCM_PresetListPosY_selectAll                           = 0x00,
  enCM_PresetListPosY_Selected                            = 0x01,
  enCM_PresetListPosY__Frequency                          = 0x02,
  enCM_PresetListPosY__Sendername                         = 0x03,
  enCM_PresetListPosY__PI                                 = 0x04,
  enCM_PresetListPosY__Stationnameinfo                    = 0x05,
  enCM_PresetListPosY__TPTMCinfo                          = 0x06,
  enCM_PresetListPosY__PTY                                = 0x07
}tenCM_AtPresetListPosY;

#define CM_PresetListPosX_selectALL 0x00

#define enAdrMsgOffset_8AMessage_Start_Index        57
#define enAdrMsgOffset_NoOf8AMessages_index         46

/*============================================================================
 * CM_SpecialDiagnosisMode
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: Set
   *-------------------------------------------------------------------------*/
  enCM_SpecialDiagnosisMode_idx_Mode             = 10, enCM_SpecialDiagnosisMode_len_Mode             = 1,
  enCM_SpecialDiagnosisMode_idx_PhysicalTunerId  = 11, enCM_SpecialDiagnosisMode_len_PhysicalTunerId  = 1

} tenCM_SpecialDiagnosisMode;

/*============================================================================
 * CM_ATLsmSetup
 *--------------------------------------------------------------------------*/
typedef enum
{
  /*--------------------------------------------------------------------------
   * OpType: SetGet
   *-------------------------------------------------------------------------*/
  enCM_ATLsmSetup_idx_Band             = 10, enCM_ATLsmSetup_len_Mode             = 1,
  enCM_ATLsmSetup_idx_Frequency  = 11, enCM_ATLsmSetup_len_Frequency  = 4,
  enCM_ATLsmSetup_idx_PICode  = 15, enCM_ATLsmSetup_len_PICode  = 2
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20  
  ,enCM_ATLsmSetup_idx_HDStationId_DRMServiceId  = 17, enCM_ATLsmSetup_len_HDStationId_DRMServiceId  = 4
  ,enCM_ATLsmSetup_idx_ModulationType  = 21, enCM_ATLsmSetup_len_ModulationType  = 1
  ,enCM_ATLsmSetup_idx_RFUBytes  = 22, enCM_ATLsmSetup_len_RFUBytes  = 4
#endif
} tenCM_ATLsmSetup;
/*----------------------------------------------------------------------------
 * Mode
 *--------------------------------------------------------------------------*/
typedef enum
{
  enCM_SpecialDiagnosisModeMode_NORMAL_MODE                 = 0x00,
  enCM_SpecialDiagnosisModeMode_MEASURE_MODE                = 0x01,
  enCM_SpecialDiagnosisModeMode_SINGLE_TUNER_MODE           = 0x02
} tenCM_SpecialDiagnosisModeMode;
/*----------------------------------------------------------------------------
 * PhysicalTunerId
 *--------------------------------------------------------------------------*/
typedef enum
{
  enPhysicalTunerId_Tuner0           = 0x00,
  enPhysicalTunerId_Tuner1           = 0x01,
  enPhysicalTunerId_Tuner2           = 0x02,
  enPhysicalTunerId_Tuner3           = 0x03,
  enPhysicalTunerId_Tuner_Auto   = 0x04,
  enPhysicalTunerId_CurrentTuner    = 0xff
} tenPhysicalTunerId;
/*==========================================================================*/

/** vnd4kor : added cm_autostore related defines */
/*============================================================================
 * CM_Autostore
 *--------------------------------------------------------------------------*/
typedef enum
{
 /*============================================================================
 * Position Indices
 *--------------------------------------------------------------------------*/
  enCM_Autostore_idx_FunctionIDList           = 0,
  enCM_Autostore_idx_MaxNumberOfStations      = 2,
  enCM_Autostore_idx_UnusedPresetTreatment    = 3,
  enCM_Autostore_idx_SortingCriteria          = 4,
  enCM_Autostore_idx_BehaviouralSwitches      = 5
} tenCM_AutostorePosIndices;

/** vnd4kor : added CM_ReceptionParameter related defines */
/*============================================================================
 * CM_ReceptionParameter 
 *--------------------------------------------------------------------------*/
typedef enum
{
 /*============================================================================
 * Position Indices
 *--------------------------------------------------------------------------*/
  enCM_ReceptionParameterPosAll					= 0,
  enCM_ReceptionParameterPosSharx					= 1,
  enCM_ReceptionParameterPosHighcut				= 2,
  enCM_ReceptionParameterPosSeeklevel_FM			= 3,
  enCM_ReceptionParameterPosSeeklevel_SW			= 4,
  enCM_ReceptionParameterPosSeeklevel_MW			= 5,
  enCM_ReceptionParameterPosSeeklevel_LW			= 6,
  enCM_ReceptionParameterPosSeeklevel_TRF			= 7,
  enCM_ReceptionParameterPosSeeklevel_WB			= 8,
  enCM_ReceptionParameterPosSeeklevel_FM_NONRDS	= 9,
  enCM_ReceptionParameterPosListlevel_FM			= 10,
  enCM_ReceptionParameterPosListlevel_SW			= 11,
  enCM_ReceptionParameterPosListlevel_MW			= 12,
  enCM_ReceptionParameterPosListlevel_LW			= 13,
  enCM_ReceptionParameterPosListlevel_TRF			= 14,
  enCM_ReceptionParameterPosListlevel_WB			= 15,
  enCM_ReceptionParameterPosListlevel_FM_NONRDS	= 16,
  enCM_ReceptionParameterPosLevelType				= 17
} tenCM_ReceptionParameterPosValues;


/** vnd4kor:  added feature switch related defines */
/*============================================================================
 * FeratureSwitches
 *--------------------------------------------------------------------------*/
typedef enum
{
/*============================================================================
 * Bit Positions
 *--------------------------------------------------------------------------*/
enTUN_FEATURE_AF_MODE = 0x00000001,
enTUN_FEATURE_CT_MODE = 0x00000002,
enTUN_FEATURE_LOC_MODE = 0x00000004,
enTUN_FEATURE_unused = 0x00000008,
enTUN_FEATURE_MONO_MODE = 0x00000010,
enTUN_FEATURE_PSFIX_MODE = 0x00000020,
enTUN_FEATURE_REG_MODE = 0x00000080,
enTUN_FEATURE_RT_MODE = 0x00000100,
enTUN_FEATURE_SEARCH_MODE = 0x00000200,
enTUN_FEATURE_SEEK_SENSE_MODE = 0x00000400,
enTUN_FEATURE_SHARX_MODE = 0x00000800,
enTUN_FEATURE_TM_DATA_MODE = 0x00001000,
enTUN_FEATURE_TMC_MODE = 0x00004000,
enTUN_FEATURE_KHZ50_MODE = 0x00008000,
enTUN_FEATURE_REG_AUTO_MODE = 0x00010000,
enTUN_FEATURE_NEWS_MODE = 0x00020000,
enTUN_FEATURE_RDS_AUTO_MODE = 0x00040000,
enTUN_FEATURE_DDA_MODE = 0x00080000,
enTUN_FEATURE_DDS_MODE = 0x00100000,
enTUN_FEATURE_reserved = 0x00200000,
enTUN_FEATURE_MEASURE_MODE = 0x00400000,
enTUN_FEATURE_AMFMSETUP_MODE = 0x00800000,
enTUN_FEATURE_PERSISTENTSTORAGE_MODE  = 0x01000000
} tenFeatureSwitches;

typedef enum
{
/*============================================================================
 * FeratureSwitchesStatus
 *--------------------------------------------------------------------------*/
enFeatureSwitchON = 0x01,
enFeatureSwitchOFF = 0x00
} tenFeatureSwitchStatus;

typedef enum
{
/*============================================================================
 * Announcement Switches Type
 *--------------------------------------------------------------------------*/
enAnnoSwitchTypeTP = 0x00,
enAnnoSwitchTypePTY31 = 0x01
} tenAnnoSwitchType;

typedef enum
{
/*============================================================================
 * Announcement Switches Mask
 *--------------------------------------------------------------------------*/

enAnnoSwitchTPMask = 0x01,
enAnnoSwitchPTY31Mask = 0x02,
enWeatherAlertMask = 0x04
} tenAnnoSwitchMask;

typedef enum
{
/*============================================================================
 * Announcement Switches Mask
 *--------------------------------------------------------------------------*/

enAnnoSwitchTPExtract = 0xFE,
enAnnoSwitchPTY31Extract = 0xFD
} tenAnnoSwitchExtract;

typedef enum
{
/*============================================================================
 * Announcement Message state
 *--------------------------------------------------------------------------*/

enTAandPTY_OFF = 0x00,
enTA_ONandPTY_OFF = 0x01,
enTA_OFFandPTY_ON = 0x02,
enTA_ONandPTY_ON = 0x03
} tenAnnoMsgState;


/*============================================================================
 * DigitalModulation type
 *--------------------------------------------------------------------------*/
typedef enum
{
enNoDigitalModulation = 0x00,
enHDModulation = 0x01,
enDRMModulation = 0x02
} tenDigitalModulation;

/*============================================================================
 * definitions for buffer size
 *--------------------------------------------------------------------------*/
#define TUN_CM_TESTMODE_SET_LEN	0x0B
#define TUN_CM_PERSISTENT_STORAGE_SET_LEN	0x0B
#define TUN_C_RECEPTION_PARAM_SET_LEN  0x0E
#define TUN_C_LANDSCAPEUPDATE_STARTRESULT_LEN	0x0E
#define TUN_CM_AFMODE_SETGET_LEN  0x0B
#define TUN_CM_DDASWITCH_SETGET_LEN 0x0B
#define TUN_CM_DDAMODE_SETGET_LEN 0x0B
/** RDS mode Set Get Length */
#define TUN_CM_RDSMODE_SETGET_LEN 0x0B
/** Delete Preset Single Element Msg Length */
#define TUN_CM_DEL_SINGLE_PRESET_SETGET_LEN 0x10
#define TUN_CM_DEL_SINGLE_PRESET_DATA_LEN 0x0006


#define INVALID_ENTRY 255
#define TUN_CM_AUTOSTORE_STARTRESULT_LEN 0x10
#define TUN_CM_AUTOSTORE_DATA_LEN 0x0006
#define TUN_CM_TESTTUNERSWITCHES_SET_LEN 0x0C
#define TUN_CM_SPECIAL_DIAGNOSIS_MODE_SET_LEN 0x0C
#define TUN_CM_TAMODE_SETGET_LEN 0x0B
#define TUN_CM_REGMODE_SETGET_LEN  0x0B
#define TUN_CM_SYSTEMPRESET_SET_LEN 0x0D
#define TUN_CM_ATBAND_SET_LEN 0x0B
#define TUN_CM_AUDIOSOURCE_SET_LEN  0x0B
#define TUN_CM_GETCONFIGURATION_STARTRESULT_LEN  10
#define TUN_CM_SETCONFIGURATION_STARTRESULT_LEN  TUN_DRVADRIF_CONF_SSI_AMFM_TUNER_TX_BUFFER_SIZE /* the length is not fix because KDS entry for Presets */
#define TUN_C_RECEPTION_PARAM_GET_LEN 0x0C
#define TUN_CM_ATSEEK_SET_LEN 0x0F
#define TUN_C_ATPI_LEN 0x0B
#define TUN_CM_VERSIONINFO_SET_LEN   10
#define TUN_CM_ADDITIONALVERSIONINFO_GET_LEN 10
#define TUN_CM_ONLY_HEADER 0x0A
#define TUN_CM_ATAFLIST_SET_LEN      11
#define TUN_CM_ATAFLIST_GET_LEN      10
#define TUN_ATFREQUENCY_SET_LEN      14
#define TUN_ATFREQUENCY_GET_LEN      10
#define TUN_ATFREQUENCY_INCREMENT_LEN 11
#define TUN_ATFREQUENCY_DECREMENT_LEN 11
#define TUN_CM_RECEPTIONPAREMETER_POS_HICUT   2
#define TUN_CM_RECEPTIONPAREMETER_POS_SHARX   1

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#define TUN_CM_STATIONLISTCONFIG_STARTRESULT_LEN   0x1A
#define TUN_CM_LSMSETUP_SET_LEN	 0x1A
#define TUN_CM_LSMSETUP_SET_DATA_LEN	 0x10
#else
#define TUN_CM_LSMSETUP_SET_LEN	 0x11
#define TUN_CM_LSMSETUP_SET_DATA_LEN	 0x07
#define TUN_CM_STATIONLISTCONFIG_STARTRESULT_LEN   21
#endif


#define TUN_CM_SETRDBID_SET_LEN 0x0C
#define TUN_CM_DEFAULT_SETTING_START_LEN 0x0B
#define TUN_NOTIFICATION_AMFM_SET_LEN 0x0D
#define TUN_NOTIFICATION_TMC_SET_LEN  0x11
#define TUN_CM_SNAPSHOT_SET_LEN  0x0B
#define TUN_CM_PRESETLIST_GET_LEN  0x0C
#define TUN_CM_STATIONNAMEFIX_SETGET_LEN  0x0B
#define TEST			0x13
#define TUN_CM_SURVEILTP_SET_LEN	0x0E
#define TUN_CM_SETENGGPARAM_SETGET_LEN 0x0F
#define TUN_CM_SETENGGPARAM_SETGET_DATA_LEN 0x05
#define TUN_CM_SETENGGPARAM_GET_LEN 0x0B
#define TUN_CM_SETENGGPARAM_GET_DATA_LEN 0x01
#define TUN_CM_TUN_ACTION_CONFIG_SINGLE_BYTE_SET_LEN 0x0D
#define TUN_CM_TUN_ACTION_CONFIG_DEFAULT_DATA_LEN 0x03
#define TUN_CM_TUN_ACTION_CONFIG_TWO_BYTE_SET_LEN 0x0E
#define TUN_CM_TUN_ACTION_CONFIG_TWO_BYTE_DATA_LEN 0x04
#define TUN_CM_TUN_ACTION_CONFIG_FOUR_BYTE_SET_LEN 0x10
#define TUN_CM_TUN_ACTION_CONFIG_FOUR_BYTE_DATA_LEN 0x06
#define TUN_CM_TUN_ACTION_CONFIG_GET_LEN 0x0C
#define TUN_CM_TUN_ACTION_CONFIG_GET_DATA_LEN 0x02
#define TUN_CM_TEST_TUNE_FREQUENCY_SET_LEN 0x10
#define TUN_CM_TEST_TUNE_FREQUENCY_SET_DATA_LEN 0x06 
#define TUN_CM_ANNOUNCEMENT_SWITCH_SETGET_LEN 0x0B
#define TUN_CM_ANNOUNCEMENT_SWITCH_SETGET_DATA_LEN 0x01 
#define TUN_CM_ANNOUNCEMENT_ESCAPE_STARTRESULT_LEN 0x0B
#define TUN_CM_ANNOUNCEMENT_ESCAPE_STARTRESULT_DATA_LEN 0x01 
#define TUN_CM_VOLUME_INFO_SET_LEN 0x0B
#define TUN_CM_VOLUME_INFO_SET_DATA_LEN 0x01 
#define TUN_CM_PI_PS_RELATION_SET_LEN 0x14
#define TUN_CM_PI_PS_RELATION_SET_DATA_LEN 0x0A 
#define TUN_CM_PREPARE_PRESET_STORAGE_SET_LEN 0x0B
#define TUN_CM_PREPARE_PRESET_STORAGE_SET_DATA_LEN 0x01
#define TUN_CM_SPEED_INFORMATION_SETGET_LEN 0x0B
#define TUN_CM_SPEED_INFORMATION_SETGET_DATA_LEN 0x01
#define TUN_CM_CURRENTRADIOTEST_GET_LEN 0x0A
#define TUN_CM_EVALUATION_PARAMETER_SETGET_LEN 0x0E
#define TUN_CM_EVALUATION_PARAMETER_SETGET_DATA_LEN 0x04
#define TUN_CM_CANCEL_AUTOSTORE_SET_LEN 0x0A
#define TUN_CM_CANCEL_AUTOSTORE_SET_DATA_LEN 0x00
#define TUN_CM_PRESETLIST_SPECIALSAVE_DATA_LEN  0x15
#define TUN_CM_ATHD_PSD_DATA_SET_LEN 0x10
#define TUN_CM_HDTESTMODE_SET_LEN	0x0B
#define TUN_CM_SETUSER_LEN  0x12
#define TUN_CM_SETUSER_DATA_LEN  0x08
#define TUN_CM_DARC_REGISTEROUTPUT_LEN 0x0D
#define TUN_CM_DARC_REGISTEROUTPUT_DATA_LEN 0x03


/*==========================================================================*/

/*------------------------------*/
/* class tun_Config definition  */
/*------------------------------*/

/** vnd4kor: List required for storing preset handling action */
typedef struct {
	tU8 u8Action;
	tU8 u8ListElement;
	tU16 u16CmdCounter;
}PresetHandlingData;

typedef std::list<PresetHandlingData> listPresetAction;
typedef std::list<PresetHandlingData>::iterator iteratorPresetAction;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
class clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST;
#endif

class clConfigInterface;
class clAars_CM_SetUserOptions;

class tun_MsgToADR :  public TUN_Singleton< tun_MsgToADR>, public tuner::AarsApp::clAarsHandler
{
  friend class TUN_Singleton< tun_MsgToADR>;

private:

  
  // Not used anywhere
  //tU8   u8aMessageBuffer[TUN_MAX_BUFFER_SIZE ];

  tU32  u32MessageLength;
  tBool m_bReadCheckSumAfterConfig;
  // Semphore synchronises, data sending to Radio unit.
  static OSAL_tSemHandle  m_hSendToRU_Sync;
  tun_MessageQ*  m_ptun_MessageQ;
  template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();

  /* this function must not be used, therefore it is private */
   tun_MsgToADR& operator=(const tun_MsgToADR& c);

  /*----------------*/
  /* Constructor    */
  /*----------------*/
protected:
  tun_MsgToADR( );
  /* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
  tun_MsgToADR(const tun_MsgToADR& c);

private:
  

  tBool m_bTestModeActivity;
  tBool m_bResetADRFlag;
  tBool m_bLandscapeRequested;
  tU32 m_u32ADRVersion;
  tU8 m_NumofAtBandReqAtStartUp;

  tU8  u8HWCrc;
  bool m_bAtBandSent;
  tU8 m_u8AtBandRequested;
  tBool bSetDefaultSettingMsgSent;
  //tBool m_bSetConfigurationMessageSent;
  tBool m_bNotificationSent;
  tBool m_bPersonalisationReq;
  char  m_sADRHWVersion[enCM_VersionInf_len_HardwareVersion];
  char  m_sADRSWVersion[enCM_VersionInf_len_SoftwareVersion];
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST;
	clAars_ATPresetList_XX* m_poclAars_ATPresetList_XX;
#endif
public:
  /*---------------*/
  /* Destructor    */
  /*---------------*/
  virtual ~tun_MsgToADR( );


  tun_Utility* m_potun_Utility;

  tun_ActualData*   m_potun_ActualData;

  tun_Config* m_potun_Config;
  
  tu_Manager* m_potu_Manager;
  
   tun_MsgToHMI* m_potun_MsgToHMI;

   tuner_tclApp* m_potun_main;

   clConfigInterface* 	m_poclConfigInterface;

   tun_tclDiagHandler* m_potun_tclDiagHandler;
   
   clAars_CM_SetUserOptions* m_poclAars_CM_SetUserOptions;

  /** vnd4kor: List required for storing preset handling action */
  listPresetAction m_listPresetAction;

  tU8 m_u8CurrentUserId;

  tVoid vSetAtBandSent(tBool bValue);
  tBool bGetAtBandSent()const;
  tU8   oGetAtBandRequested() const;

  tVoid vSet_tun_Utility_Ptr( tun_Utility* potun_Utility );

  tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData );

  tVoid vSet_tun_Config_Ptr( tun_Config* potun_Config );
  
   tVoid vSet_tu_Manager_Ptr( tu_Manager* potu_Manager );
  
  tVoid vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI );
  
  tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

  tVoid vSet_tun_main_Ptr( tuner_tclApp* potun_main );

  tVoid vSet_tun_tclDiagHandler( tun_tclDiagHandler* potun_tclDiagHandler);
  
  tVoid vSet_SetUserOptions_Ptr( clAars_CM_SetUserOptions* poclAars_CM_SetUserOptions );

  #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tVoid vSet_TmcTuner_Method_S_SET_ACTIVE_PRESETLISTPtr(clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST);
  tVoid vSet_clAars_ATPresetList_XXPtr(clAars_ATPresetList_XX* poclAars_ATPresetList_XX);
#endif
  tVoid vSet_bSetConfigurationMessageSent( tBool bState);
  tVoid	vGetDefaultPresetListAfterDefaultSetting();
  tVoid	vGetDefaultPresetListAfterSetUser();
  /*-------------------------------------------*/
  /* All new incomming messages are put in a Q */
  /*-------------------------------------------*/
  virtual tVoid vWaitOnMessageQue( unsigned char* pu8Message, unsigned long u32MessageLen, unsigned char bSendAlways = FALSE);
  tVoid vSend( tun_TxMsg* pMsg);
  tVoid vSetAdrCommunication( tBool bState);

  /*--------------------------------------------------------*/
  /* External interface will call below fn to intimate the
     message sent confirmation.                             */
  /*--------------------------------------------------------*/
  tVoid vMessageSentConfirmation( );


  /*-------------------------------------------*/
  /* Radio unit triggered from trace component */
  /*-------------------------------------------*/
  tVoid vMsgToADRFromTrace( tU8 u8Command, tU8 u8Para1, tU8 u8Para2, tU8 u8Para3); 
  tVoid vMsgToADRFromTrace( tPU8 pu8Msg, tU32 u32Len );
  tVoid vTraceCommand( tPU8 pu8Msg, tU32 u32Len );
  
  
  /*-------------------------*/
  /* Messages to Radio Unit  */
  /*-------------------------*/

  tVoid vSend_TUNFgBg (tU8 u8TunerHeader, tU8 u8SubCommand, tU8 u8AudioSink, tBool bTunerState, tU8 u8PhysicalTuner );

  /*--------------------------------------------------*/

  tVoid vSendSelListElem (tU16 u16ListID, tU8 u8ListElementID, tU8 u8ListType );

  /*--------------------------------------------------*/

  tVoid vSendSaveListElem ( tU16 u16ListID, tU8 u8ListElementID );
  
  /*--------------------------------------------------*/
  
  tVoid vSendSpecialSaveListElem( tU16 u16ListID, tU8 u8ListElementID  , tU32 u32Frequency , tU16 u16PI);

  /*--------------------------------------------------*/

  tVoid vSendDeleteSinglePreset (tU16 u16ListID, tU8 u8ListElementID );

  /*--------------------------------------------------*/

  tVoid vSendDeleteAllPreset ( tU16 u16ListID);

  /*--------------------------------------------------*/
  
  tVoid vSendSetRDBID(const tU8* pu8RDBIDList ,tU8 u8NumOfRDBID);

  /*--------------------------------------------------*/

  tVoid vSendSetEnggParam(tU8 u8ParameterId,tU32 u32ParameterValue);

  /*--------------------------------------------------*/

  tVoid vSendSetTuningActionConfig(tU8 u8ConfigParamType,tU32 u32ConfigParamValue);

  tVoid vGetTuningActionConfigValues(tU8 u8ConfigParamType);

  /*--------------------------------------------------*/

  tVoid vSendSetBand ( tU8 u8Band );
  
  tVoid vSendSetAtBand ( tU8 u8Band );
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tU8 u8ConvertTunerbandToCombiband( tU8 u8Band );

  tU8 u8ConvertCombibandToTunerband( tU8 u8Band, tU32 u32Frequency );
#endif
  tVoid vSetPresetListSetActive (  tU16 u16ListID );
  
  tVoid vGetActivePhyTunerAndMeasureMode();

  /*--------------------------------------------------*/

  tVoid vSendATFrequency( tenATFrequencyAbsOrRel enAbsOrRel, tU8 u8NSteps, tU32 u32Frequency, tenATFrequencyDirection enDirection, tU8 u8TunerHeader);

  /*--------------------------------------------------*/

  tVoid vSendSeekStart (tU8 u8SeekType, tU32 u32Frequency);

  /*--------------------------------------------------*/

  tVoid vSendGetSeekStatus();

  /*--------------------------------------------------*/

  tVoid vSendSetHiCut (tU8 u8AbsVal);

  /*--------------------------------------------------*/

  tVoid vSendGetAFList ( tU8 u8Notification );
  
  /*--------------------------------------------------*/
  

  tVoid vSendMakeConfigList (tU32 u32PtyFilter, tU8 u8ConfigListID, tU8 u8SortCriteria );

  tVoid vSendGetConfigList ( tU8 u8ConfigListID, tU8 u8PosX, tU8 u8PosY );

  tVoid vSendGetTMCList ();

  tVoid vSendUpdateConfigList ( tU8 u8ConfigListID, tU8 u8UpdateMode);

  tVoid vSend_SetPI (tU8 u8TunerHeader, tU8 u8AbsOrRel, tU8 u8RelSteps);

  tVoid vSend_SetSharxLevel (tU8 u8SharxStep);

  tVoid vSendSetATMContainer(tU8 u8DataLength,const tU8* u8DataSpecial );

  tVoid vSendSnapshot(tU8 u8Action);
   
  tVoid vSendTestmode(tU32 u32TestmodeValue, tU16 u16MsgId);
  tVoid vSendPersistentStorage(tU32 u32PersistentStorageMode);
  tVoid vSendAFMode(tU32 u32AFModeValue);
  tVoid vGetAFMode();
  tVoid vHandleAMFMSettings(tU32 u32AMFMSetup);
  tVoid vSendSetDDASwitch(tU32 u8DDAMode);
  tVoid vSendSetRDSSwitch(tU32 u32RDSMode);
  tVoid vSendGetDDASwitch();
  tVoid vSendTestTunerSwitches(tU8 u8DDS, tU8 u8DMQ);
  tVoid vSendSpecialDiagnosisMode( tenCM_SpecialDiagnosisModeMode enMode, tenPhysicalTunerId enPhysicalTunerID);
  tVoid vSendTAMode(tU8 u8TAMode);	
  
  tVoid vGetREGMode();
  tVoid vGetRDSMode();
  tVoid vSendAutostore(tU16 u16ListID, tU8 u8MaxNoOfStations, tenAMFMAutostore_UnUsedPreset enUnUsedPresets, tenAMFMAutostore_Sort enSortingCriteria, \
                                     tU8 u8BehaviouralSwitch);
  tVoid vSendREGMode(tU8 u8REGMode);
  tVoid vGetReceptionParameter (tU8 u8Parameter);
  tVoid vGetCalibrationData();
  tVoid vSendStationListExit(tU8 u8ConfigListID);
  tVoid vUpdateLandscape(tU32 u32Bands);
  tBool bGetTestModeActivity();
  tVoid vSendAcceptAF();
  
  tVoid vSendCommit();
  tBool bGetResetADR();
  tVoid vSetResetADR(tBool bResetADR);
  tVoid vSendGetAtStationInfo();
  tVoid vGetBandDetails( tU8 u8Band );
  tVoid vSendLSMSetup(tU8 u8Band, tU32 u32Frequency, tU16 u16PICode,tU32 u32HDStnID_DRMSrvID,tU8 u8ModulationType);
  tVoid vSendDefaultSetting(tU8 u8DefaultSettingOption);
  tVoid vSendNotificationRequest(tU8 u8NotificationControl, tU16 u16ClientID, tU16 u16FBlockID);
  tVoid vSetLandscapeRequested(tBool bLandscapeReq);
  tBool bGetLandscapeRequested() const;
  tVoid vSendNextMessageFromQueue( tVoid);
  tVoid vClearMessageQueue( tVoid);
  
#ifdef NOT_YET_USED 

  /*--------------------------------------------------*/
  tBool bEnableMsgService ();

  /*--------------------------------------------------*/
  tBool bDisableMsgService ();

  /*--------------------------------------------------*/
  tBool bSendTUNMessageUpReg ();

  
   /*--------------------------------------------------*/
  tVoid vSendSetConfigList(tU8 u8ConfigListID );

  /*--------------------------------------------------*/
  //	-build RU_TUN_C_SET_FRQ - get TunerMainStatus from RU
  //	- is called after Notification of TUNMainStatus from HMI
  tVoid vSendTUNStatusGet ();

  /*--------------------------------------------------*/
  tVoid vSendStationInfoGet ();

  /*--------------------------------------------------*/

  tBool bSendSetFeature (tU8 u8AbsOrRel, tU32 u32Mask, tU32 u32Switches);

  /*--------------------------------------------------*/
  

  //## Operation: vSendSetScanTime%3DF0694803A6
  tVoid vSendSetScanTime (tU8 u8AbsVal);

  /*--------------------------------------------------*/
  tVoid vSendSetPI (tU8 u8AbsOrRel, tU8 u8RelSteps, tU8 u8Direction);

  /*--------------------------------------------------*/
  /*--------------------------------------------------*/
  

  /*--------------------------------------------------*/
  tBool bSendTunStreamMsg (ahl_tclStreamer& poStreamContent, tU8 u8StreamMsgLen);

#endif /* NOT_YET_USED */

  tVoid vConfigureAdr( tVoid);
  tVoid vSendCM_GetConfigurationInfo( tVoid);
  tVoid vNotifyFunctionIDs( tVoid);
  tBool bSendCM_SetConfiguration(  tenTraceSetConfiguration enTraceType, tPU32 pu32Crc);
  tVoid vHandle_r_SetConfiguration( tPU8 pu8Message, tU32 u32MessageLen);
  tVoid vSendCM_VersionInfo( tVoid);
  tVoid vSendCM_AdditionalVersionInfo(tVoid);
  tVoid vHandle_r_CM_VersionInfo( tPU8 pu8Message, tU32 u32MessageLen) ;
  tVoid vHandle_r_CM_AdditionalVersionInfo(tPU8 pu8Message);
  tVoid vFormat_Msg_Header(tU8* pu8Message, tU16 u16ClientID, tU16 u16FBlockID, tU8 u8InstanceID, tU16 u16FktID, tU8 u8Optype) const;
  tVoid vSendStationNameFix(tBool bPSFreeze);
  tVoid vGetPresetList ( tU16 u16ListID );
  tVoid vSendSurveilTP(tU16 u16PI, tBool bSurveilTp, tU8 u8Strategy);
  tVoid vSendTestTuneFrequency(tU8 u8PhysicalTunerId,tU8 u8Mode,tU32 u32Frequency);

  /** ---------------------------------------------------------------- */
  /** Announcement related handlers */
  /** ---------------------------------------------------------------- */
  tVoid vSendSetAnnouncementSwitch(tU8 u8AnnouncementType);
  tVoid vSendGetAnnouncementSwitch();
  tVoid vSendAnnouncementEscape(tU8 u8AnnouncementType);
  /** ---------------------------------------------------------------- */
  tVoid vSendSetPiPsRelation(tU16 u16PI,tU8* sPSName);
  tVoid vSendSetPreparePresetStorage(tU8 u8Mode);
  tVoid vGetEngineeringParameter(tU8 u8ParameterId);
  tVoid vSendSpeedInfo(tU8 u8Speed);
  tVoid vSend_GetRadiotext();
  tVoid vSendTunerFGBG(tun_tenInstanceId e8InstanceId, \
								   tenAudioSource e8AudioSource );

  tVoid vSendSetEvaluationParameter(tU8* puchData);
  tVoid vSendCancelAutostore();

  tVoid vSendSetUser(tU8 u8UserID);

  tU32 u32GetBandFromConfigListID (tU8 u8ConfigListID) const;

  tBool bGetNotificationSentStatus()const;
  tVoid vSetNotificationSentStatus(tBool bValue);

  tBool bGetPersonalisationReq()const;
  tVoid vSetPersonalisationReq(tBool bValue);

  tVoid vHandle_CM_SetUser();
  tVoid vStartupSetUserReq();
  tVoid vHandle_CM_GetUser(const tU8* pu8Message);

  tVoid vPrintADRVersionInformation();
  tBool bGetValue_m_bReadCheckSumAfterConfig();
  tVoid vSetValue_m_bReadCheckSumAfterConfig(tBool bValue);
  
  tVoid vSetDefaultSettingMsg(tBool bValue);
  tVoid vGetUser();
  tBool blGetDefaultSettingMsgSent();

  tVoid vDoNotification();

  tVoid vInc_m_NumofAtBandReqAtStartUp();
  tVoid vDec_m_NumofAtBandReqAtStartUp();
  tU8 u8Get_m_NumofAtBandReqAtStartUp();
  tVoid vSendDARC_RegisterOutput();
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tVoid vSendSetPSD_Data();
#endif
  
};



#endif /* TUN_MsgToADR_H */
