/************************************************************************
* FILE:           tun_RUMsgDispatcher.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Radio Unit messages are received has to be dispached to 
                  the concerned classes. ( HMI, Audio, TMC ). These 
                  classes will decide what action has to done.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 20.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


#ifndef TUN_RUMSGDISPATCHER_H
#define TUN_RUMSGDISPATCHER_H


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "tun_Class_ForwardDecl.h"

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
#include "AarsDBusProxy/AarsDBusProxyInterface.h"
using namespace tuner::AarsDBusProxy;
#endif

class clConfigInterface;

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
class tun_MsgDispatcher : public AarsDBusProxyInterface
#else
class tun_MsgDispatcher
#endif
{
private:
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	clAars_ATPresetList_XX* m_poclAars_ATPresetList_XX;
	clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST;
	clTmcTuner_Method_S_USER_PROFILE_UPDATE* m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE;
  clAars_DemodulationSwitch* m_poclAars_DemodulationSwitch;
  clTmcTuner_Method_S_JAPAN_SET_AREA* m_poclTmcTuner_Method_S_JAPAN_SET_AREA;
#endif
public:
  /*---------------*/
  /* Constructor   */
  /*---------------*/
  tun_MsgDispatcher(tuner_tclApp* poMain);
  tun_MsgDispatcher( );

  /*----------------*/
  /* Destructor     */
  /*----------------*/
  ~tun_MsgDispatcher( );


  tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData );

  tVoid vSet_tu_Manager_Ptr( tu_Manager* potu_Manager );

  tVoid vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI );

  tVoid vSet_tun_MsgFromHMI_Ptr( tun_MsgFromHMI* potun_MsgFromHMI );

  tVoid vSet_tun_HMIManager_Ptr( tun_HMIManager* potun_HMIManager );

  tVoid vSet_tun_DiagManager_Ptr(tun_DiagManager* potun_DiagManager );
  
  tVoid vSet_tun_MsgToADR_Ptr(tun_MsgToADR* potun_MsgToADR );

  tVoid vSet_tun_Config_Ptr( tun_Config* potun_Config );
  tVoid vSet_tun_tclDiagHandler( tun_tclDiagHandler* potun_tclDiagHandler);

  tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

  tVoid vSet_tun_MsgToTunMaster_Ptr( tun_MsgToTunMaster* potun_MsgToTunMaster );
  #ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tVoid vSet_clAars_ATPresetList_XXPtr(clAars_ATPresetList_XX* poclAars_ATPresetList_XX);
  tVoid vSet_TmcTuner_Method_S_SET_ACTIVE_PRESETLISTPtr(clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST);
  tVoid vSet_TmcTuner_Method_S_USER_PROFILE_UPDATEPtr(clTmcTuner_Method_S_USER_PROFILE_UPDATE* poclTmcTuner_Method_S_USER_PROFILE_UPDATE);
  tVoid vSet_clAars_DemodulationSwitch(clAars_DemodulationSwitch* poclAars_DemodulationSwitch);
  tVoid vSet_TmcTuner_Method_S_JAPAN_SET_AREAPtr(clTmcTuner_Method_S_JAPAN_SET_AREA* poclTmcTuner_Method_S_JAPAN_SET_AREA);
#endif


  

  /*-----------------------------------------------------------*/
  /* Dispatch the RU Msg to respective classes Audio, HMI, TMC */
  /*-----------------------------------------------------------*/
  tVoid bDispatchRUMessage( tU8* u8Message, tU32 u32Len );
#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
  virtual void vDispatchRUMessage(unsigned char *pu8ByteArray, int actualLength);
  virtual void vHandleSBRState(unsigned char SBRState);
#endif
  //tVoid bDispatchRUMessage( tU16 u16Event );
  /**pmn3kor:
   *created new handler to solve logiscope issues
   *Handler for TMC related updates*/
  tVoid vHandleTMCData(tU8* u8Message, tU32 u32Len, tun_SsiRxBuffer oRxBuffer);
  /**pmn3kor:
   * created new handler to solve logiscope issues
   * Handler for Error Traces*/
  tVoid vHandleOpTypeError(tU8 *u8Message, tun_SsiRxBuffer oRxBuffer);

  template< class MSG>
  tVoid vProcess( tun_SsiRxBuffer* poRxBuffer);

  template< class MSG>
  tVoid vParseAndTrace( tun_SsiRxBuffer* poRxBuffer);
  
  tuner_tclApp*        poGWMain;
  
  tu_Manager*       m_potu_Manager;

  tun_MsgToHMI*     m_potun_MsgToHMI;

  tun_MsgFromHMI*    m_potun_MsgFromHMI;

  tun_ActualData*   m_potun_ActualData;

  tun_HMIManager*   m_potun_HMIManager;

  tun_DiagManager*  m_potun_DiagManager;

  tun_MsgToADR*      m_potun_MsgToADR;

  tun_Config*       m_potun_Config;

  clConfigInterface* 	m_poclConfigInterface;

  tun_MsgToTunMaster*   m_potun_MsgToTunMaster;

  tun_tclDiagHandler* m_potun_tclDiagHandler;

  static tBool m_bWorkaroundStartupADR3;
};

#endif /* TUN_RUMSGDISPATCHER_H */
