/************************************************************************
* FILE:           tun_Manager.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Main control of the tuner component.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 20.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Configured as Tuner server.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


#ifndef TUN_MANAGER_H
#define TUN_MANAGER_H



#include "tun_ActualData.h"
#include "tun_Class_ForwardDecl.h"
#include "tun_Singleton.h"

/*
#ifndef TUN_MsgToADR_H
class tun_Config;
class tun_RUMessage;
#endif

class tun_MsgToADR;

#ifndef TUN_HMIMANAGER_H
#ifndef TUN_MSGTOHMI_H
class tuner_tclApp;
#endif
#endif
*/


/*------------------------------*/
/* class tu_Manager definition  */
/*------------------------------*/

class tu_Manager : public TUN_Singleton< tu_Manager>
{
  friend class TUN_Singleton< tu_Manager>;

  /*-------------*/
  /* Constructor */
  /*-------------*/
  tu_Manager();

public:
 /*-------------*/
 /* Destructors */
 /*-------------*/
  virtual ~tu_Manager( );

  
  
 // tun_ActualData m_otun_ActualData;

  /*-----------------------------------------*/
  /* Tuner main application class pointer.   */
  /*-----------------------------------------*/
  tuner_tclApp* poGWMain;


  /*--------------------------*/
  /* Interface to Radio Unit  */
  /*--------------------------*/
  tun_MsgToADR* m_potun_MsgToADR;

  
  /*------------------------------------*/
   /* Tuner Data is sored in this class  */
   /*------------------------------------*/
   tun_ActualData* m_potun_ActualData;

  /*------------------------------------------------- */
  /* tuner Config data is stored in this class        */
  /* this is used for getting the Project information */
  /*--------------------------------------------------*/
   tun_Config* m_potun_Config;

  tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR );

  tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData );

  // to access the Config class
  tVoid vSet_tun_config_Ptr( tun_Config* potun_Config );

  tVoid vSet_tuner_tclApp_Ptr( tuner_tclApp* potunerMainApp);

  tVoid vComponentStatus( tU8 u8Status );

  tVoid vSetTunerSystemState( tU8 u8TunerSysState );
  tVoid vSetTunerState( tU8 u8TunerState );

  tU8 u8GetTunerSystemState(  )const;
  tU8 u8GetTunerState( )const;

  tVoid vUpdateComponentStatus();

  // this is used for getting the Last element ID of the List depending on the project
  tU8 u8GetLastListElementID(  )const;

  // this is used for getting the Last list ID depending on the project
  tU8 u8GetLastListID( )const;

private:

  tU8 m_u8TunerSysState;
  tU8 m_u8TunerState;

    /* used for storing the last element number(ID) in the Preset list */
  tU8 m_u8TunLastListElementID;

  /* used for storing the last list ID in the Preset list */
  tU8 m_u8TunLastListID;

  // this is used for setting the Last element ID of the List depending on the project
  tVoid vSetLastListElementID();

};





#endif /* TUN_MANAGER_H */
/*** END OF FILE *************************************************************/
